/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector.beans;

import java.lang.reflect.Array;
import oracle.bali.inspector.beans.AbstractPropertyEditorFactory;

class ArrayPropertyEditorFactory
extends AbstractPropertyEditorFactory {
    private int _index;

    public ArrayPropertyEditorFactory(Object object, int n) {
        super(object);
        this._index = n;
    }

    public int getIndex() {
        return this._index;
    }

    public String getDisplayName() {
        return Integer.toString(this.getIndex());
    }

    public boolean setValue(Object object) throws ArrayIndexOutOfBoundsException, IllegalArgumentException {
        boolean bl = this.getCachedValue() != object;
        Array.set(this.getTarget(), this.getIndex(), object);
        this.setCachedValue(object);
        this.setCachedDisplayValue(AbstractPropertyEditorFactory.INVALID_PROPERTY);
        return bl;
    }

    public Object getValue(Object object) throws ArrayIndexOutOfBoundsException, IllegalArgumentException {
        Object object2 = this.getCachedValue();
        if (object2 == AbstractPropertyEditorFactory.INVALID_PROPERTY) {
            object2 = Array.get(object, this.getIndex());
            this.setCachedValue(object2);
        }
        return object2;
    }

    public boolean isReadable() {
        boolean bl = true;
        try {
            Array.get(this.getTarget(), this.getIndex());
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public boolean isWritable() {
        return false;
    }

    public Class getType() {
        return this.getTarget().getClass().getComponentType();
    }

    protected Object createPropertyID() {
        return new Object();
    }
}

