/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.util;

import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import oracle.i18n.servlet.localesource.LocaleSource;
import oracle.i18n.text.OraBoot;
import oracle.i18n.text.OraSimpleDateFormat;
import oracle.i18n.text.converter.CharacterConverterOGS;
import oracle.i18n.util.GDKMessage;
import oracle.i18n.util.OraLocaleInfo;

public class OraSQLUtil {
    private static final Set M_C_UNICODE_CHARSETS = new HashSet();

    private OraSQLUtil() {
    }

    public static boolean isValidIdentifier(String string, String string2) throws UnsupportedEncodingException {
        if (M_C_UNICODE_CHARSETS.contains(string2.toUpperCase(Locale.US))) {
            return true;
        }
        String string3 = OraBoot.getInstance().getCharSetId(string2);
        if (string3 == null) {
            throw new UnsupportedEncodingException(GDKMessage.getMessage(5210, (Object)string2));
        }
        int n = Integer.parseInt(string3);
        try {
            CharacterConverterOGS.getInstance(n).toOracleString(string);
            return true;
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    public static String escapeUNISTR(String string, String string2) throws UnsupportedEncodingException {
        if (M_C_UNICODE_CHARSETS.contains(string2.toUpperCase(Locale.US))) {
            return "'" + OraSQLUtil.escapeSingleQuote(string) + "'";
        }
        String string3 = OraBoot.getInstance().getCharSetId(string2);
        if (string3 == null) {
            throw new UnsupportedEncodingException(GDKMessage.getMessage(5210, (Object)string2));
        }
        int n = Integer.parseInt(string3);
        return ((CharacterConverterOGS)CharacterConverterOGS.getInstance(n)).toUnistr(string);
    }

    public static boolean synchronizeLocale(Locale locale, Connection connection) throws SQLException {
        OraLocaleInfo oraLocaleInfo = OraLocaleInfo.getInstance(locale);
        return OraSQLUtil.synchronizeLocale(oraLocaleInfo.getLanguage(), oraLocaleInfo.getTerritory(), connection);
    }

    public static boolean synchronizeLocale(String string, String string2, Connection connection) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer("ALTER SESSION SET NLS_LANGUAGE='");
        stringBuffer.append(string).append("' NLS_TERRITORY='").append(string2).append("'");
        String string3 = stringBuffer.toString();
        PreparedStatement preparedStatement = connection.prepareStatement(string3);
        boolean bl = preparedStatement.execute();
        preparedStatement.close();
        return bl;
    }

    public static boolean synchronizeLocale(LocaleSource localeSource, Connection connection) throws SQLException {
        OraLocaleInfo oraLocaleInfo = OraLocaleInfo.getInstance(localeSource.getLocale());
        StringBuffer stringBuffer = new StringBuffer("ALTER SESSION SET NLS_LANGUAGE='");
        stringBuffer.append(oraLocaleInfo.getLanguage());
        stringBuffer.append("' NLS_TERRITORY='");
        stringBuffer.append(oraLocaleInfo.getTerritory());
        stringBuffer.append("' NLS_DATE_LANGUAGE='");
        stringBuffer.append(oraLocaleInfo.getLanguage());
        stringBuffer.append("' NLS_DATE_FORMAT='");
        stringBuffer.append(OraSQLUtil.escapeSingleQuote(((OraSimpleDateFormat)localeSource.getDateFormat(3)).toPattern()));
        stringBuffer.append("' NLS_CURRENCY='");
        stringBuffer.append(OraSQLUtil.escapeSingleQuote(OraLocaleInfo.getCurrencySymbol(localeSource.getISOCurrency())));
        stringBuffer.append("' NLS_ISO_CURRENCY='");
        stringBuffer.append(oraLocaleInfo.getTerritory());
        String string = localeSource.getCollator().getName().toUpperCase(Locale.US);
        if (string.equals("BINARY")) {
            stringBuffer.append("' NLS_COMP='BINARY' NLS_SORT='BINARY'");
        } else {
            stringBuffer.append("' NLS_COMP='ANSI' NLS_SORT='");
            stringBuffer.append(string);
            stringBuffer.append("'");
        }
        String string2 = stringBuffer.toString();
        PreparedStatement preparedStatement = connection.prepareStatement(string2);
        boolean bl = preparedStatement.execute();
        preparedStatement.close();
        return bl;
    }

    private static String escapeSingleQuote(String string) {
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer(cArray.length);
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '\'') {
                stringBuffer.append('\'');
            }
            stringBuffer.append(cArray[i]);
        }
        return stringBuffer.toString();
    }

    static {
        M_C_UNICODE_CHARSETS.add("UTF8");
        M_C_UNICODE_CHARSETS.add("AL32UTF8");
        M_C_UNICODE_CHARSETS.add("AL16UTF16");
        M_C_UNICODE_CHARSETS.add("AL16UTF16LE");
        M_C_UNICODE_CHARSETS.add("UTFE");
    }
}

