/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text.converter;

import java.io.CharConversionException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Vector;
import oracle.i18n.text.converter.CharacterConverterLC;
import oracle.i18n.util.GDKMessage;
import oracle.i18n.util.GDKOracleMetaData;

public class CharacterConverterJAEUC
extends CharacterConverterLC {
    static final long serialVersionUID = GDKOracleMetaData.getOracleVersionID();
    static final int LEADINGCODE = 143;

    public CharacterConverterJAEUC() {
        this.m_groupId = 2;
        this.averageCharsPerByte = 1.0f;
        this.maxCharsPerByte = 1.0f;
        this.maxBytesPerChar = 4.0f;
    }

    int toUnicode(int n) throws SQLException {
        int n2 = 0;
        if ((n >> 16 & 0xFFFF) == 143) {
            n2 = 256;
        }
        int n3 = n >> 8 & 255 + n2;
        int n4 = n & 0xFF;
        if (this.m_ucsCharLevel1[n3] != '\uffff' && this.m_ucsCharLevel2[this.m_ucsCharLevel1[n3] + n4] != -1) {
            return this.m_ucsCharLevel2[this.m_ucsCharLevel1[n3] + n4];
        }
        throw new SQLException(GDKMessage.getORAMessage(17154), null, 17154);
    }

    int toUnicodeWithReplacement(int n) {
        int n2 = 0;
        if ((n >> 16 & 0xFFFF) == 143) {
            n2 = 256;
        }
        int n3 = n >> 8 & 255 + n2;
        int n4 = n & 0xFF;
        int n5 = this.m_ucsCharLevel1[n3] != '\uffff' && this.m_ucsCharLevel2[this.m_ucsCharLevel1[n3] + n4] != -1 ? this.m_ucsCharLevel2[this.m_ucsCharLevel1[n3] + n4] : this.m_ucsCharReplacement;
        return n5;
    }

    public String toUnicodeString(byte[] byArray, int n, int n2) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer(n2);
        while (n2 > 0) {
            int n3;
            int n4 = byArray[n] & 0xFF;
            int n5 = 0;
            if (n4 == 143) {
                if (n2 < 3) {
                    throw new SQLException(GDKMessage.getORAMessage(17154), null, 17154);
                }
                n4 = byArray[n + 1] << 8 & 0xFF00 | byArray[n + 2] & 0xFF;
                n3 = 3;
                n5 = 256;
            } else if (n4 > 127) {
                if (n2 < 2) {
                    throw new SQLException(GDKMessage.getORAMessage(17154), null, 17154);
                }
                n4 = byArray[n] << 8 & 0xFF00 | byArray[n + 1] & 0xFF;
                n3 = 2;
            } else {
                n3 = 1;
            }
            int n6 = (n4 >> 8 & 0xFF) + n5;
            int n7 = n4 & 0xFF;
            if (this.m_ucsCharLevel1[n6] == '\uffff' || this.m_ucsCharLevel2[this.m_ucsCharLevel1[n6] + n7] == -1) {
                throw new SQLException(GDKMessage.getORAMessage(17154), null, 17154);
            }
            int n8 = this.m_ucsCharLevel2[this.m_ucsCharLevel1[n6] + n7];
            if (((long)n8 & 0xFFFFFFFFL) > 65535L) {
                stringBuffer.append((char)(n8 >>> 16));
                stringBuffer.append((char)(n8 & 0xFFFF));
            } else {
                stringBuffer.append((char)n8);
            }
            n2 -= n3;
            n += n3;
        }
        return stringBuffer.toString();
    }

    public String toUnicodeStringWithReplacement(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(n2);
        while (n2 > 0) {
            int n3;
            int n4 = byArray[n] & 0xFF;
            int n5 = 0;
            if (n4 == 143) {
                if (n2 < 3) break;
                n4 = byArray[n + 1] << 8 & 0xFF00 | byArray[n + 2] & 0xFF;
                n3 = 3;
                n5 = 256;
            } else if (n4 > 127) {
                if (n2 < 2) break;
                n4 = byArray[n] << 8 & 0xFF00 | byArray[n + 1] & 0xFF;
                n3 = 2;
            } else {
                n3 = 1;
            }
            int n6 = (n4 >> 8 & 0xFF) + n5;
            int n7 = n4 & 0xFF;
            int n8 = this.m_ucsCharLevel1[n6] != '\uffff' && this.m_ucsCharLevel2[this.m_ucsCharLevel1[n6] + n7] != -1 ? this.m_ucsCharLevel2[this.m_ucsCharLevel1[n6] + n7] : this.m_ucsCharReplacement;
            if (((long)n8 & 0xFFFFFFFFL) > 65535L) {
                stringBuffer.append((char)(n8 >>> 16));
                stringBuffer.append((char)(n8 & 0xFFFF));
            } else {
                stringBuffer.append((char)n8);
            }
            n2 -= n3;
            n += n3;
        }
        return stringBuffer.toString();
    }

    public void extractCodepoints(Vector vector) {
        int[] nArray;
        int n;
        int n2 = 0;
        int n3 = 65535;
        for (n = n2; n <= n3; ++n) {
            try {
                nArray = new int[]{n, this.toUnicode(n)};
                vector.addElement(nArray);
                continue;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        n2 = 0x8F0000;
        n3 = n2 + 65535;
        for (n = n2; n <= n3; ++n) {
            try {
                nArray = new int[]{n, this.toUnicode(n)};
                vector.addElement(nArray);
                continue;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public int ByteToCharConvert(byte[] byArray, int n, int n2, char[] cArray, int n3, int n4) throws IOException, CharConversionException, IndexOutOfBoundsException {
        return 0;
    }

    public int CharToByteConvert(char[] cArray, int n, int n2, byte[] byArray, int n3, int n4) throws IOException, CharConversionException, IndexOutOfBoundsException {
        return 0;
    }
}

