/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.groupv2;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import oracle.ias.cache.commx.GroupException;
import oracle.ias.cache.commx.GroupPacket;
import oracle.ias.cache.commx.NetworkAddress;
import oracle.ias.cache.groupv2.Address;
import oracle.ias.cache.groupv2.GcommException;
import oracle.ias.cache.groupv2.GcommSerializable;
import oracle.ias.cache.groupv2.MemberID;
import oracle.ias.cache.groupv2.PacketFlag;

class Packet
extends GcommSerializable
implements GroupPacket,
Cloneable {
    static final byte[] SIGNATURE = new byte[]{57, 53, 69, 69};
    static final byte[] VERSION = new byte[]{51, 52};
    static final int F_SIGNATURE = 0;
    static final int F_ENDIAN = 1;
    static final int F_VERSION = 2;
    static final int F_TYPE = 3;
    static final int F_SEQUENCE = 4;
    static final int F_TOTALSEQUENCE = 5;
    static final int F_VID = 6;
    static final int F_ACK = 7;
    static final int F_ORIGIN = 8;
    static final int F_DESTINATION = 9;
    static final int F_FLAGS = 10;
    static final int F_PADDING = 11;
    static final int F_DATA_OFFSET = 12;
    static final int F_DATA_LENGTH = 13;
    static final int F_CHECKSUM = 14;
    static final int F_DATA = 15;
    static final int TOTAL_FIELDS = 16;
    static final int[] FIELD_LENGTH = new int[16];
    static final int T_NEWVIEW = 1;
    static final int T_DISCONNECT = 2;
    static final int T_REGISTER = 3;
    static final int T_COORDINATOR_LOOKUP = 4;
    static final int T_BROADCAST = 5;
    static final int T_UNICAST = 6;
    static final int T_LINKDISTRIBUTOR = 8;
    static final int T_UNLINKDISTRIBUTOR = 9;
    static final int T_CHANGEVIEW = 10;
    static final int T_CLOSEDUPLICATEEP = 11;
    static final int T_GETDISTRIBUTORLIST = 12;
    static final int T_COORDINATORELECTION = 13;
    static final int T_COORSHIFTELECTION = 14;
    static final int T_RELINKDISTRIBUTOR = 15;
    static final int T_SWITCHCOORDINATOR = 16;
    static final int T_TERMINATE = 17;
    static final int T_PING = 18;
    static final int T_GETTOKEN = 19;
    static final int T_RELEASETOKEN = 20;
    static final int T_UPDATETOTALSEQUENCE = 21;
    static final int TOTAL_OF_TYPE = 22;
    static final String[] TYPE_NAMES = new String[22];
    private static int HEADER_LENGTH = 0;
    private static long SEQUENCE_ = 0L;
    private byte[] signature_;
    private byte[] version_;
    private int type_;
    private byte[] data_;
    private PacketFlag flag_ = new PacketFlag(FIELD_LENGTH[10]);
    private byte endian_;
    private long sequence_;
    private long totalSequence_;
    private long ack_;
    private long vid_;
    private byte[] origin_;
    private byte[] destination_;
    private int dataOffset_;
    private int dataLength_;
    private int checksum_;
    private String attachedFilename_;
    private InputStream inStream_;
    private int inStreamSize_;

    Packet(byte[] byArray) throws GroupException {
        this();
        this.parseHeader(byArray);
    }

    Packet(int n) throws GroupException {
        this(n, null);
    }

    Packet(int n, MemberID memberID) throws GroupException {
        this();
        this.type_ = n;
        if (memberID != null) {
            this.origin_ = memberID.toBytes();
        }
        this.sequence_ = Packet.getNextSequenceNumber();
    }

    Packet(int n, MemberID memberID, long l) throws GroupException {
        this(n, memberID);
        this.vid_ = l;
    }

    private Packet() {
    }

    static final int getHeaderLength() {
        return HEADER_LENGTH;
    }

    static final synchronized long getNextSequenceNumber() {
        return ++SEQUENCE_;
    }

    static Packet parse(byte[] byArray) throws GroupException {
        Packet packet = new Packet(0);
        packet.parseHeader(byArray);
        int n = packet.getHeaderLength();
        int n2 = byArray.length - packet.getHeaderLength();
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        packet.setData(byArray2);
        return packet;
    }

    private static boolean isSignatureValid(byte[] byArray) {
        return byArray != null && byArray.length == SIGNATURE.length && Arrays.equals(byArray, SIGNATURE);
    }

    int getType() {
        return this.type_;
    }

    PacketFlag getFlag() {
        return this.flag_;
    }

    byte[] getOrigin() {
        return this.origin_;
    }

    byte[] getDestination() {
        return this.destination_;
    }

    void setOrigin(MemberID memberID) throws GroupException {
        this.origin_ = memberID.toBytes();
    }

    void setDestination(MemberID memberID) throws GroupException {
        this.destination_ = memberID.toBytes();
    }

    void setDestination(byte[] byArray) throws GroupException {
        this.destination_ = byArray;
    }

    void setType(int n) throws GroupException {
        if (n < 0 || n >= 22) {
            throw new GcommException("Invalid packet type: " + n);
        }
        this.type_ = n;
    }

    byte[] getData() {
        return this.data_;
    }

    void setData(byte[] byArray) {
        this.data_ = byArray;
        this.dataLength_ = byArray != null ? this.data_.length : 0;
    }

    void setViewId(long l) {
        this.vid_ = l;
    }

    int getDataLength() {
        return this.dataLength_;
    }

    void setDataLength(int n) {
        this.dataLength_ = n;
    }

    void setAsReply() {
        this.flag_.setAsReply();
    }

    boolean isAReply() {
        return this.flag_.contains(1);
    }

    boolean isARequest() {
        return !this.flag_.contains(1);
    }

    void setAck(long l) {
        this.ack_ = l;
    }

    void setTotalSequence(long l) {
        this.totalSequence_ = l;
    }

    void setForRegistered() {
        this.flag_.set(6);
    }

    boolean isRegistered() {
        return this.flag_.contains(6);
    }

    void setBlockReceiver() {
        this.flag_.set(7);
    }

    boolean isBlockReceiver() {
        return this.flag_.contains(7);
    }

    void setFlag(PacketFlag packetFlag) {
        this.flag_ = packetFlag;
    }

    boolean hasErrorStatus() {
        return this.flag_.contains(5);
    }

    long getAck() {
        return this.ack_;
    }

    long getSequence() {
        return this.sequence_;
    }

    long getTotalSequence() {
        return this.totalSequence_;
    }

    long getViewId() {
        return this.vid_;
    }

    void parseHeader(byte[] byArray) throws GroupException {
        int n = 0;
        for (int i = 0; i < 16; ++i) {
            Object var4_4 = null;
            switch (i) {
                case 0: {
                    this.signature_ = new byte[FIELD_LENGTH[i]];
                    System.arraycopy(byArray, n, this.signature_, 0, FIELD_LENGTH[i]);
                    break;
                }
                case 1: {
                    this.endian_ = byArray[n];
                    break;
                }
                case 2: {
                    this.version_ = new byte[FIELD_LENGTH[i]];
                    System.arraycopy(byArray, n, this.version_, 0, FIELD_LENGTH[i]);
                    break;
                }
                case 3: {
                    this.type_ = GcommSerializable.bytesToUnsignedInt(byArray, n, FIELD_LENGTH[i]);
                    break;
                }
                case 4: {
                    this.sequence_ = GcommSerializable.bytesToUnsignedLong(byArray, n, FIELD_LENGTH[i]);
                    break;
                }
                case 5: {
                    this.totalSequence_ = GcommSerializable.bytesToUnsignedLong(byArray, n, FIELD_LENGTH[i]);
                    break;
                }
                case 6: {
                    this.vid_ = GcommSerializable.bytesToUnsignedLong(byArray, n, FIELD_LENGTH[i]);
                    break;
                }
                case 7: {
                    this.ack_ = GcommSerializable.bytesToUnsignedLong(byArray, n, FIELD_LENGTH[i]);
                    break;
                }
                case 8: {
                    this.origin_ = new byte[FIELD_LENGTH[i]];
                    System.arraycopy(byArray, n, this.origin_, 0, FIELD_LENGTH[i]);
                    break;
                }
                case 9: {
                    this.destination_ = new byte[FIELD_LENGTH[i]];
                    System.arraycopy(byArray, n, this.destination_, 0, FIELD_LENGTH[i]);
                    break;
                }
                case 10: {
                    byte[] byArray2 = new byte[FIELD_LENGTH[i]];
                    System.arraycopy(byArray, n, byArray2, 0, FIELD_LENGTH[i]);
                    this.flag_.parseFrom(byArray2);
                    break;
                }
                case 11: {
                    break;
                }
                case 12: {
                    this.dataOffset_ = GcommSerializable.bytesToUnsignedInt(byArray, n, FIELD_LENGTH[i]);
                    break;
                }
                case 13: {
                    this.dataLength_ = GcommSerializable.bytesToUnsignedInt(byArray, n, FIELD_LENGTH[i]);
                    break;
                }
                case 14: {
                    this.checksum_ = GcommSerializable.bytesToUnsignedInt(byArray, n, FIELD_LENGTH[i]);
                    break;
                }
            }
            n += FIELD_LENGTH[i];
        }
    }

    byte[] toBytes() {
        int n = 0;
        byte[] byArray = new byte[HEADER_LENGTH + this.getDataLength()];
        for (int i = 0; i < 16; ++i) {
            switch (i) {
                case 0: {
                    System.arraycopy(SIGNATURE, 0, byArray, n, FIELD_LENGTH[i]);
                    break;
                }
                case 1: {
                    byArray[n] = this.endian_;
                    break;
                }
                case 2: {
                    System.arraycopy(VERSION, 0, byArray, n, VERSION.length);
                    break;
                }
                case 3: {
                    GcommSerializable.writeUnsignedIntTo(byArray, n, this.type_, FIELD_LENGTH[i]);
                    break;
                }
                case 4: {
                    GcommSerializable.writeUnsignedLongTo(byArray, n, this.sequence_, FIELD_LENGTH[i]);
                    break;
                }
                case 5: {
                    GcommSerializable.writeUnsignedLongTo(byArray, n, this.totalSequence_, FIELD_LENGTH[i]);
                    break;
                }
                case 7: {
                    GcommSerializable.writeUnsignedLongTo(byArray, n, this.ack_, FIELD_LENGTH[i]);
                    break;
                }
                case 6: {
                    GcommSerializable.writeUnsignedLongTo(byArray, n, this.vid_, FIELD_LENGTH[i]);
                    break;
                }
                case 8: {
                    if (this.origin_ != null) {
                        System.arraycopy(this.origin_, 0, byArray, n, this.origin_.length);
                        break;
                    }
                    Arrays.fill(byArray, n, n + FIELD_LENGTH[i] - 1, (byte)0);
                    break;
                }
                case 9: {
                    if (this.destination_ != null) {
                        System.arraycopy(this.destination_, 0, byArray, n, this.destination_.length);
                        break;
                    }
                    Arrays.fill(byArray, n, n + FIELD_LENGTH[i] - 1, (byte)0);
                    break;
                }
                case 10: {
                    System.arraycopy(this.flag_.toBytes(), 0, byArray, n, this.flag_.toBytes().length);
                    break;
                }
                case 11: {
                    break;
                }
                case 12: {
                    GcommSerializable.writeUnsignedIntTo(byArray, n, this.dataOffset_, FIELD_LENGTH[i]);
                    break;
                }
                case 13: {
                    GcommSerializable.writeUnsignedIntTo(byArray, n, this.dataLength_, FIELD_LENGTH[i]);
                    break;
                }
                case 14: {
                    GcommSerializable.writeUnsignedIntTo(byArray, n, this.checksum_, FIELD_LENGTH[i]);
                    break;
                }
                case 15: {
                    if (this.data_ == null) break;
                    System.arraycopy(this.data_, 0, byArray, n, this.data_.length);
                }
            }
            n += FIELD_LENGTH[i];
        }
        return byArray;
    }

    String getAttachedFilename() {
        return this.attachedFilename_;
    }

    void setAttachedFilename(String string) {
        this.attachedFilename_ = string;
    }

    InputStream getInputStream() {
        return this.inStream_;
    }

    void setInputStream(InputStream inputStream) {
        this.inStream_ = inputStream;
    }

    int getInputStreamSize() {
        return this.inStreamSize_;
    }

    void setInputStreamSize(int n) {
        this.inStreamSize_ = n;
    }

    void setFromMyself() {
        this.flag_.set(12);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.type_ >= 0 && this.type_ <= 22) {
            stringBuffer.append(TYPE_NAMES[this.type_]);
        } else {
            stringBuffer.append("Unknown");
        }
        stringBuffer.append(", fg=");
        stringBuffer.append(this.flag_.toString());
        if (this.data_ != null) {
            stringBuffer.append(", ln=");
            stringBuffer.append(this.data_.length);
        }
        stringBuffer.append(", sq=");
        stringBuffer.append(this.sequence_);
        if (bl) {
            if (this.origin_ != null) {
                stringBuffer.append(", or=");
                stringBuffer.append(MemberID.parse(this.origin_));
            }
            if (this.destination_ != null) {
                stringBuffer.append(", de=");
                stringBuffer.append(MemberID.parse(this.destination_));
            }
            stringBuffer.append(", ac=");
            stringBuffer.append(this.ack_);
            stringBuffer.append(", total_sq=");
            stringBuffer.append(this.totalSequence_);
            stringBuffer.append(", vid=");
            stringBuffer.append(this.vid_);
            if (this.attachedFilename_ != null) {
                stringBuffer.append(", filename=");
                stringBuffer.append(this.attachedFilename_);
            }
            if (this.inStream_ != null) {
                stringBuffer.append(", inStream=");
                stringBuffer.append(this.inStream_);
            }
        }
        return stringBuffer.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        Packet packet = new Packet();
        packet.type_ = this.type_;
        packet.flag_ = (PacketFlag)this.flag_.clone();
        packet.sequence_ = this.sequence_;
        packet.totalSequence_ = this.totalSequence_;
        packet.ack_ = this.ack_;
        packet.vid_ = this.vid_;
        if (this.attachedFilename_ != null) {
            packet.attachedFilename_ = new String(this.attachedFilename_);
        }
        if (this.origin_ != null) {
            packet.origin_ = new byte[this.origin_.length];
            System.arraycopy(this.origin_, 0, packet.origin_, 0, this.origin_.length);
        }
        if (this.destination_ != null) {
            packet.destination_ = new byte[this.destination_.length];
            System.arraycopy(this.destination_, 0, packet.destination_, 0, this.destination_.length);
        }
        return packet;
    }

    public int getVid() {
        return (int)this.vid_;
    }

    public String getAttachedFileName() {
        return this.attachedFilename_;
    }

    public NetworkAddress getSourceAddress() {
        Address address = null;
        try {
            address = new Address(MemberID.parse(this.origin_), 0, null, null);
        }
        catch (GroupException groupException) {
            // empty catch block
        }
        return address;
    }

    public Serializable getMessage() throws GroupException {
        Serializable serializable = null;
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(this.getData()));
            serializable = (Serializable)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new GroupException(classNotFoundException);
        }
        catch (IOException iOException) {
            throw new GroupException(iOException);
        }
        return serializable;
    }

    public boolean isFromMyself() {
        return this.flag_.contains(12);
    }

    public Object getReceiptTracker() {
        return new Long(this.getSequence());
    }

    static {
        Packet.FIELD_LENGTH[0] = SIGNATURE.length;
        Packet.FIELD_LENGTH[1] = 2;
        Packet.FIELD_LENGTH[2] = VERSION.length;
        Packet.FIELD_LENGTH[3] = 2;
        Packet.FIELD_LENGTH[4] = 8;
        Packet.FIELD_LENGTH[5] = 8;
        Packet.FIELD_LENGTH[6] = 8;
        Packet.FIELD_LENGTH[7] = 8;
        Packet.FIELD_LENGTH[8] = 64;
        Packet.FIELD_LENGTH[9] = 64;
        Packet.FIELD_LENGTH[10] = 4;
        Packet.FIELD_LENGTH[12] = 2;
        Packet.FIELD_LENGTH[13] = 4;
        Packet.FIELD_LENGTH[14] = 2;
        for (int i = 0; i < FIELD_LENGTH.length; ++i) {
            HEADER_LENGTH += FIELD_LENGTH[i];
        }
        Packet.FIELD_LENGTH[11] = HEADER_LENGTH % 4;
        HEADER_LENGTH += FIELD_LENGTH[11];
        Packet.TYPE_NAMES[0] = "UNKNOWN";
        Packet.TYPE_NAMES[1] = "NEWVIEW";
        Packet.TYPE_NAMES[2] = "DISCONNECT";
        Packet.TYPE_NAMES[3] = "REGISTER";
        Packet.TYPE_NAMES[4] = "COORDINATOR_LOOKUP";
        Packet.TYPE_NAMES[5] = "BROADCAST";
        Packet.TYPE_NAMES[6] = "UNICAST";
        Packet.TYPE_NAMES[8] = "LINKDISTRIBUTOR";
        Packet.TYPE_NAMES[9] = "UNLINKDISTRIBUTOR";
        Packet.TYPE_NAMES[10] = "CHANGEVIEW";
        Packet.TYPE_NAMES[11] = "CLOSEDUPLICATEEP";
        Packet.TYPE_NAMES[12] = "GETDISTRIBUTORLIST";
        Packet.TYPE_NAMES[13] = "COORDINATORELECTION";
        Packet.TYPE_NAMES[14] = "COORSHIFTELECTION";
        Packet.TYPE_NAMES[15] = "RELINKDISTRIBUTOR";
        Packet.TYPE_NAMES[16] = "SWITCHCOORDINATOR";
        Packet.TYPE_NAMES[17] = "TERMINATE";
        Packet.TYPE_NAMES[18] = "PING";
        Packet.TYPE_NAMES[19] = "GETTOKEN";
        Packet.TYPE_NAMES[20] = "RELEASETOKEN";
        Packet.TYPE_NAMES[21] = "UPDATETOTALSEQUENCE";
    }
}

