/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.group;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ias.cache.group.AsyncQueue;
import oracle.ias.cache.group.GrpCommunication;
import oracle.ias.cache.group.Job;
import oracle.ias.cache.group.Packet;
import oracle.ias.cache.group.Transport;

class Sender
extends Thread {
    static final String LOGGER_NAME = "oracle.ias.cache.group.Sender";
    static final int QUEUE_LIMIT = 200;
    private AsyncQueue asq;
    private boolean work = true;
    private GrpCommunication gcomm_;
    private Transport trans_;
    private Logger logger_ = Logger.getLogger("oracle.ias.cache.group.Sender");

    Sender(GrpCommunication grpCommunication, Transport transport, AsyncQueue asyncQueue) {
        this.asq = asyncQueue;
        this.gcomm_ = grpCommunication;
        this.trans_ = transport;
        this.setName("Sender");
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Sender sender;
        while (this.work) {
            Job job;
            do {
                job = this.asq.dequeue();
                if (this.asq.getLength() < 200) {
                    sender = this;
                    synchronized (sender) {
                        this.notifyAll();
                    }
                }
                if (job == null) continue;
                this.execute(job);
            } while (job != null);
            this.asq.sleep(6000);
        }
        sender = this;
        synchronized (sender) {
            this.notifyAll();
        }
    }

    void execute(Job job) {
        block11: {
            try {
                switch (job.action) {
                    case 0: {
                        this.trans_.syncSend((Packet)job.argument);
                        break;
                    }
                    case 1: {
                        this.trans_.syncSendTotalOrderedMsg((Packet)job.argument);
                        break;
                    }
                    case 2: {
                        this.trans_.syncMulticast((Packet)job.argument);
                        break;
                    }
                    case 3: {
                        this.trans_.syncMulticastTotalOrderedMsg((Packet)job.argument);
                        break;
                    }
                    default: {
                        if (this.logger_.isLoggable(Level.SEVERE)) {
                            this.logger_.log(Level.SEVERE, "Invalid Job.");
                        }
                        break;
                    }
                }
            }
            catch (Exception exception) {
                if (this.trans_.isReady() && this.logger_.isLoggable(Level.FINE)) {
                    this.logger_.log(Level.FINE, "Asynchronize Sender: ", exception);
                }
            }
            catch (Error error) {
                if (!this.trans_.isReady() || !this.logger_.isLoggable(Level.WARNING)) break block11;
                this.logger_.log(Level.WARNING, "Warning: Asynchronize Sender Error.", error);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopit() {
        this.asq.disable();
        this.work = false;
        this.asq.wakeup();
        Sender sender = this;
        synchronized (sender) {
            this.notifyAll();
        }
    }

    boolean isBusy() {
        boolean bl = false;
        if (this.asq.getLength() >= 200 && this.work) {
            bl = true;
        }
        return bl;
    }
}

