/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipOutputStream;
import oracle.ias.cache.CacheAttributes;
import oracle.ias.cache.CacheWatchUtil;
import oracle.ias.cache.Configurator;
import oracle.ias.cache.SSLConfigurator;

public class CacheUtil {
    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 0) {
                CacheUtil.programUsage();
                return;
            }
            if (stringArray[0].equalsIgnoreCase("watch")) {
                String[] stringArray2 = new String[stringArray.length - 1];
                for (int i = 0; i < stringArray2.length; ++i) {
                    stringArray2[i] = stringArray[i + 1];
                }
                CacheWatchUtil.main(stringArray2);
                return;
            }
            if (stringArray[0].equalsIgnoreCase("sslconfig")) {
                CacheUtil.configSSL(stringArray);
                return;
            }
            if (stringArray[0].equalsIgnoreCase("addclasspath")) {
                if (stringArray.length == 3) {
                    CacheUtil.addClasspath(stringArray[1], stringArray[2]);
                    return;
                }
            } else if (stringArray[0].equalsIgnoreCase("removeclasspath") && stringArray.length == 3) {
                CacheUtil.removeClasspath(stringArray[1], stringArray[2]);
                return;
            }
            CacheUtil.programUsage();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void programUsage() {
        System.out.println("Java Object Cache Utility V1.0\n---------------------------------\nUsage: java -jar cache.jar [command]\nwhere command is: \n  watch <-config=configFileName> \n  addclasspath <the cache.jar> <new classpath> \n  removeclasspath <the cache.jar> <the classpath> \n  sslconfig <cache config file name>  <java keystore location> <java keystore password> \n");
    }

    public static void configSSL(String[] stringArray) throws Exception {
        String string = stringArray[1];
        String string2 = stringArray[2];
        String string3 = stringArray[3];
        Configurator configurator = new Configurator(string, false);
        CacheAttributes cacheAttributes = configurator.getCacheAttributes();
        if (cacheAttributes.getGroupConfig().getSSLConfigFile() == null) {
            System.out.println("No SSL Configuration File Specified");
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(SSLConfigurator.KEYSTORE, string2);
        hashMap.put(SSLConfigurator.PASSWORD, string3);
        SSLConfigurator.save(cacheAttributes.getGroupConfig().getSSLConfigFile(), hashMap);
    }

    public static void addClasspath(String string, String string2) {
        System.out.println("adding classpath " + string2 + " to " + string + " manifest");
        JarFile jarFile = null;
        Manifest manifest = null;
        try {
            jarFile = new JarFile(string);
            manifest = jarFile.getManifest();
            jarFile.close();
            Attributes attributes = manifest.getMainAttributes();
            String string3 = attributes.getValue(Attributes.Name.CLASS_PATH);
            string2 = " " + string2;
            if (string3.indexOf(string2) == -1) {
                string3 = string3 + string2;
                attributes.putValue(Attributes.Name.CLASS_PATH.toString(), string3);
                CacheUtil.updateManifest(string, manifest);
            } else {
                System.out.println("classpath already exists, Nothing to add.");
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void removeClasspath(String string, String string2) {
        System.out.println("removing classpath " + string2 + " from " + string + " manifest");
        JarFile jarFile = null;
        Manifest manifest = null;
        try {
            jarFile = new JarFile(string);
            manifest = jarFile.getManifest();
            jarFile.close();
            Attributes attributes = manifest.getMainAttributes();
            String string3 = attributes.getValue(Attributes.Name.CLASS_PATH);
            string2 = " " + string2;
            int n = string3.indexOf(string2);
            if (n != -1) {
                string3 = string3.substring(0, n) + string3.substring(n + string2.length());
                attributes.putValue(Attributes.Name.CLASS_PATH.toString(), string3);
                CacheUtil.updateManifest(string, manifest);
            } else {
                System.out.println("classpath not exists, Nothing to remove.");
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static boolean updateManifest(String string, Manifest manifest) throws Throwable {
        boolean bl = true;
        String string2 = string + ".tmp";
        String string3 = string + ".bak";
        File file = new File(string);
        JarFile jarFile = new JarFile(string);
        File file2 = new File(string2);
        ZipOutputStream zipOutputStream = null;
        try {
            zipOutputStream = new JarOutputStream((OutputStream)new FileOutputStream(file2), manifest);
            byte[] byArray = new byte[1024];
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                int n;
                JarEntry jarEntry = enumeration.nextElement();
                if (jarEntry.getName().startsWith("META-INF")) continue;
                InputStream inputStream = jarFile.getInputStream(jarEntry);
                ((JarOutputStream)zipOutputStream).putNextEntry(jarEntry);
                while ((n = inputStream.read(byArray)) != -1) {
                    zipOutputStream.write(byArray, 0, n);
                }
            }
        }
        catch (Throwable throwable) {
            System.err.println("ERROR: Not able to write new jar file to " + string2);
            throw throwable;
        }
        finally {
            jarFile.close();
            zipOutputStream.close();
        }
        if (!file.renameTo(new File(string3))) {
            System.err.println("ERROR: Can not rename the orginal to " + string3);
            bl = false;
        }
        if (bl && !file2.renameTo(file)) {
            System.err.println("ERROR: Can not rename from tempfile " + string2);
            bl = false;
        }
        if (bl) {
            System.out.println("jarfile manifest update success! original file is renamed to .bak");
        } else {
            System.out.println("update failed. See error message above.");
        }
        return bl;
    }
}

