/*
 * Decompiled with CFR 0.152.
 */
package oracle.ord.im;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import oracle.ord.im.OrdVBAInputStream;
import oracle.ord.im.OrdVBASegment;

class OrdVectoredByteArray {
    OrdVBASegment[] segments;
    int length;
    private static final int MAX_SEGMENT_SIZE = 65536;
    private static final int MIN_SEGMENT_SIZE = 8192;

    OrdVectoredByteArray() {
    }

    InputStream getInputStream() {
        return new OrdVBAInputStream(this.segments);
    }

    int getLength() {
        return this.length;
    }

    boolean readFromInputStream(InputStream inputStream, int n, int n2) throws IOException {
        this.length = 0;
        int n3 = 65536;
        Vector<OrdVBASegment> vector = new Vector<OrdVBASegment>(n / n3 + 1);
        do {
            if (n3 > n) {
                n3 = n;
            } else if (n <= 0) {
                n3 = n = 8192;
            }
            byte[] byArray = new byte[n3];
            int n4 = inputStream.read(byArray, 0, n3);
            if (n4 <= 0) break;
            if (n4 < n3 / 2 && n3 - n4 > 4096) {
                byte[] byArray2 = new byte[n4];
                System.arraycopy(byArray, 0, byArray2, 0, n4);
                byArray = byArray2;
            }
            vector.addElement(new OrdVBASegment(byArray, n4));
            this.length += n4;
            n -= n4;
        } while (this.length <= n2);
        this.segments = new OrdVBASegment[vector.size()];
        vector.copyInto(this.segments);
        return this.length <= n2;
    }

    void release() {
        int n = 0;
        while (n < this.segments.length) {
            this.segments[n].release();
            ++n;
        }
        this.segments = null;
    }

    int writeToOutputStream(OutputStream outputStream) throws IOException {
        int n = 0;
        while (n < this.segments.length) {
            outputStream.write(this.segments[n].getData(), 0, this.segments[n].getDataLength());
            ++n;
        }
        return this.length;
    }
}

