/*
 * Decompiled with CFR 0.152.
 */
package oracle.ord.im;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import oracle.ord.im.OrdHttpUploadException;

class OrdMultipartInputStream
extends InputStream {
    private BufferedInputStream postData;
    private int lengthRemaining;
    private static final int DEFAULT_BUF_SIZE = 32768;

    OrdMultipartInputStream(InputStream inputStream, int n) {
        int n2 = 32768;
        if (n2 > n) {
            n2 = n;
        }
        this.postData = new BufferedInputStream(inputStream, n2);
        this.lengthRemaining = n;
    }

    public void close() {
        this.postData = null;
    }

    int getLengthRemaining() {
        return this.lengthRemaining;
    }

    public int read() throws IOException {
        if (this.lengthRemaining > 0) {
            int n = this.postData.read();
            --this.lengthRemaining;
            if (n >= 0) {
                return n;
            }
        }
        throw new OrdHttpUploadException(5);
    }
}

