/*
 * Decompiled with CFR 0.152.
 */
package oracle.ord.im;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.servlet.ServletRequest;
import oracle.ord.im.OrdHttpMessage;
import oracle.ord.im.OrdHttpUploadFile;
import oracle.ord.im.OrdHttpUploadForm;
import oracle.ord.im.OrdMultipartParser;
import oracle.ord.im.OrdMultipartUtil;

public class OrdHttpUploadFormData {
    private ServletRequest request;
    private int contentLength;
    private String contentType;
    private boolean isUpload;
    private boolean isParsed;
    private OrdHttpUploadForm form;
    private int maxMemory;
    private String tempFileDir;
    private String characterEncoding;
    private static final int MAX_MEMORY = 0xFFFFFFF;
    private static final String JAVA_IO_TMPDIR = "java.io.tmpdir";

    public OrdHttpUploadFormData() {
        this.init();
    }

    public OrdHttpUploadFormData(ServletRequest servletRequest) {
        this.init();
        this.setServletRequest(servletRequest);
    }

    private void checkState() {
        if (this.request == null) {
            throw new IllegalStateException(OrdHttpMessage.getMessage(1));
        }
        if (this.isUpload) {
            if (!this.isParsed) {
                throw new IllegalStateException(OrdHttpMessage.getMessage(7));
            }
            if (this.form == null) {
                throw new IllegalStateException(OrdHttpMessage.getMessage(8));
            }
        }
    }

    public void enableParameterTranslation(String string) {
        this.characterEncoding = string;
    }

    public OrdHttpUploadFile getFileParameter(String string) {
        this.checkState();
        if (this.isUpload) {
            return this.form.getFileParameter(string);
        }
        return null;
    }

    public Enumeration getFileParameterNames() {
        this.checkState();
        if (this.isUpload) {
            return this.form.getFileParameterNames();
        }
        return new Vector(0, 0).elements();
    }

    public OrdHttpUploadFile[] getFileParameterValues(String string) {
        this.checkState();
        if (this.isUpload) {
            return this.form.getFileParameterValues(string);
        }
        return null;
    }

    public String getParameter(String string) {
        this.checkState();
        if (this.isUpload) {
            return this.form.getParameter(string);
        }
        return this.request.getParameter(string);
    }

    public Enumeration getParameterNames() {
        this.checkState();
        if (this.isUpload) {
            return this.form.getParameterNames();
        }
        return this.request.getParameterNames();
    }

    public String[] getParameterValues(String string) {
        this.checkState();
        if (this.isUpload) {
            return this.form.getParameterValues(string);
        }
        return this.request.getParameterValues(string);
    }

    private void init() {
        this.request = null;
        this.contentLength = 0;
        this.contentType = null;
        this.isUpload = false;
        this.isParsed = false;
        this.form = null;
        this.maxMemory = 0xFFFFFFF;
        this.tempFileDir = null;
        this.characterEncoding = null;
    }

    public boolean isUploadRequest() {
        if (this.request == null) {
            throw new IllegalStateException(OrdHttpMessage.getMessage(1));
        }
        return this.isUpload;
    }

    public void parseFormData() throws IOException {
        if (this.isUploadRequest() && !this.isParsed) {
            OrdMultipartParser ordMultipartParser = new OrdMultipartParser();
            ordMultipartParser.parseFormData((InputStream)this.request.getInputStream(), this.contentLength, this.contentType, this.maxMemory, this.tempFileDir, this.characterEncoding, this.form);
            this.isParsed = true;
        }
    }

    public void release() {
        if (this.form != null) {
            this.form.release();
            this.form = null;
        }
    }

    public void setMaxMemory(int n, String string) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (string == null) {
            string = System.getProperty(JAVA_IO_TMPDIR);
        }
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.tempFileDir = string;
        this.maxMemory = n;
    }

    public void setServletRequest(ServletRequest servletRequest) {
        if (servletRequest == this.request) {
            return;
        }
        if (this.request != null) {
            this.release();
            this.init();
        }
        if (servletRequest == null) {
            return;
        }
        this.request = servletRequest;
        this.contentLength = servletRequest.getContentLength();
        if (this.contentLength == 0) {
            return;
        }
        this.contentType = servletRequest.getContentType();
        if (this.contentType == null || !OrdMultipartUtil.checkMultipartFormData(this.contentType)) {
            return;
        }
        this.isUpload = true;
        this.form = new OrdHttpUploadForm(servletRequest);
    }
}

