/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.model.bc4j;

import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import oracle.adf.model.BindingContext;
import oracle.adf.model.OperationBinding;
import oracle.adf.model.OperationParameter;
import oracle.adf.model.binding.DCBindingContainer;
import oracle.adf.model.binding.DCDataControl;
import oracle.adf.model.binding.DCInvokeMethod;
import oracle.adf.model.binding.DCIteratorBinding;
import oracle.adf.model.binding.DCIteratorBindingDef;
import oracle.adf.model.generic.DCRowContext;
import oracle.adf.model.generic.DCRowSetIteratorImpl;
import oracle.adf.model.generic.RowImpl;
import oracle.adf.model.generic.StructureDefImpl;
import oracle.adf.share.ADFContext;
import oracle.adf.share.statemanager.DefaultPolicyImpl;
import oracle.jbo.ApplicationModule;
import oracle.jbo.ApplicationModuleCreateException;
import oracle.jbo.ApplicationModuleHome;
import oracle.jbo.AttrValException;
import oracle.jbo.AttributeDef;
import oracle.jbo.AttributeList;
import oracle.jbo.InvalidOperException;
import oracle.jbo.JboEvent;
import oracle.jbo.JboException;
import oracle.jbo.Key;
import oracle.jbo.LocaleContext;
import oracle.jbo.NavigatableRowIterator;
import oracle.jbo.NotConnectedException;
import oracle.jbo.Row;
import oracle.jbo.RowNotFoundException;
import oracle.jbo.RowSet;
import oracle.jbo.RowSetIterator;
import oracle.jbo.SortCriteria;
import oracle.jbo.StructureDef;
import oracle.jbo.TransactionStateListener;
import oracle.jbo.Variable;
import oracle.jbo.VariableManager;
import oracle.jbo.VariableValueManager;
import oracle.jbo.ViewCriteria;
import oracle.jbo.ViewObject;
import oracle.jbo.client.Configuration;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.JBOClass;
import oracle.jbo.common.JboEnvUtil;
import oracle.jbo.common.VariableImpl;
import oracle.jbo.common.VariableValueManagerImpl;
import oracle.jbo.common.ampool.SessionCookie;
import oracle.jbo.common.ampool.SessionCookieImpl;
import oracle.jbo.common.ws.WSApplicationModuleImpl;
import oracle.jbo.common.ws.WSProxy;
import oracle.jbo.common.ws.WSRowSet;
import oracle.jbo.common.ws.WSRowSetIteratorBase;
import oracle.jbo.common.ws.WSViewObjectImpl;
import oracle.jbo.domain.Struct;
import oracle.jbo.domain.TypeFactory;
import oracle.jbo.uicli.binding.JUAccessorIteratorDef;

public class DCJboDataControl
extends DCDataControl
implements TransactionStateListener {
    private String mRootAMDefName;
    private Hashtable mContext;
    private String mDBConnectionURL;
    private Properties mDBConnectionProps;
    private String mPackageName;
    private int mValidationInBinding;
    ApplicationModule mAM;
    SessionCookie mSessionCookie;
    boolean mSyncNeeded;
    public static final int VAL_MODE_REMOTE = 3;
    public static final int VAL_MODE_ALWAYS = -1;
    public static final int VAL_MODE_NEVER = 1;
    public static final int VAL_MODE_UNINIT = 0;
    public static final int EXC_MODE_DEFAULT = 0;
    public static final int EXC_MODE_DEFERRED = 1;
    public static final int EXC_MODE_IMMEDIATE = 2;
    private static byte DEPLOY_UNRESOLVED = (byte)-1;
    private static byte DEPLOY_LOCAL = 0;
    private static byte DEPLOY_REMOTE = 1;
    private byte mDeployMode;
    private boolean mInEndRequest;
    private boolean mInRequest;
    private int mReleaseLevel;
    static final String GET_TransactionDirty = "TransactionDirty";
    private static final String FINDVOWITHPARAMS = "findViewObjectWithParameters";
    private static final String VARAIBLE_MANAGER_CLASS;
    private HashMap mastersToExecute;
    private int mExcMode;
    final String VARIABLES_MAP;
    final int VARIABLES_MAP_LENGTH;
    private static /* synthetic */ Class class$oracle$jbo$VariableManager;
    private static /* synthetic */ Class class$oracle$adf$model$bc4j$DCJboDataControl;
    private static /* synthetic */ Class class$oracle$jbo$CSMessageBundle;

    private /* synthetic */ void $init$() {
        this.mValidationInBinding = 0;
        this.mSyncNeeded = false;
        this.mDeployMode = DEPLOY_UNRESOLVED;
        this.mInEndRequest = false;
        this.mInRequest = false;
        this.mReleaseLevel = 1;
        this.mExcMode = 0;
        this.VARIABLES_MAP = "variablesMap";
        this.VARIABLES_MAP_LENGTH = "variablesMap".length() + 1;
    }

    protected DCJboDataControl() {
        this.$init$();
    }

    public DCJboDataControl(Hashtable hashtable, String string, Object object) {
        super(true, object);
        this.$init$();
        this.mContext = hashtable;
        this.mRootAMDefName = string;
    }

    public DCJboDataControl(ApplicationModule applicationModule) {
        this(null, applicationModule, null);
    }

    public DCJboDataControl(DCDataControl dCDataControl, ApplicationModule applicationModule, Object object) {
        super(dCDataControl == null, object);
        this.$init$();
        this.mParent = dCDataControl;
        this.setApplicationModule(applicationModule);
        if (applicationModule.getTransaction().isDirty()) {
            this.setTransactionModified();
        }
    }

    public DCJboDataControl(SessionCookie sessionCookie) {
        super(true, null);
        this.$init$();
        this.mSessionCookie = sessionCookie;
        this.mRootApplication = this;
    }

    private void setApplicationModule(ApplicationModule applicationModule) {
        this.mAM = applicationModule;
        this.setDataProvider(applicationModule);
        this.mSyncNeeded = applicationModule instanceof WSApplicationModuleImpl;
        if (this.mIsRoot) {
            this.mRootAMDefName = this.mAM.getDefFullName();
            this.mRootApplication = this;
            this.mAM.getTransaction().addTransactionStateListener((TransactionStateListener)this);
        } else {
            this.mRootApplication = this.mParent.getRootDataControl();
        }
    }

    public void initialize() {
        if (this.mIsRoot) {
            this.createRootApplicationModule();
            this.loadPackage();
            this.connect();
        }
    }

    public final void createRootApplicationModule() {
        if (!this.mIsRoot) {
            return;
        }
        if (this.mAM == null) {
            if (this.mRootAMDefName == null || this.mRootAMDefName.length() == 0) {
                this.mRootAMDefName = "$DefaultAppModule";
            }
            try {
                InitialContext initialContext = new InitialContext(this.mContext);
                ApplicationModuleHome applicationModuleHome = (ApplicationModuleHome)initialContext.lookup(this.mRootAMDefName);
                this.mAM = applicationModuleHome.create();
                this.setDataProvider(this.mAM);
            }
            catch (NamingException namingException) {
                throw new ApplicationModuleCreateException((Throwable)namingException);
            }
        }
    }

    public final Hashtable getContext() {
        return ((DCJboDataControl)this.getRootDataControl()).mContext;
    }

    final void loadPackage() {
        if (this.mIsRoot && this.mPackageName != null && this.mPackageName.length() != 0) {
            this.mAM.getSession().loadPackage(this.mPackageName);
        }
    }

    protected void connect() {
        if (this.mIsRoot) {
            this.mAM.getTransaction().connect(this.mDBConnectionURL, this.mDBConnectionProps);
            this.mAM.getTransaction().addTransactionStateListener((TransactionStateListener)this);
        }
    }

    public final String getRootAMDefName() {
        return ((DCJboDataControl)this.getRootDataControl()).mRootAMDefName;
    }

    public final String getDBConnectionURL() {
        return this.mDBConnectionURL;
    }

    public final Properties getDBConnectionProps() {
        return this.mDBConnectionProps;
    }

    public final void setConnectionInfo(String string, Properties properties) {
        this.mDBConnectionURL = string;
        this.mDBConnectionProps = properties;
    }

    public final String getPackageName() {
        return this.mPackageName;
    }

    public final void setPackageName(String string) {
        this.mPackageName = string;
    }

    public final LocaleContext getLocaleContext() {
        ApplicationModule applicationModule = this.getApplicationModule();
        if (applicationModule != null) {
            return applicationModule.getSession().getLocaleContext();
        }
        return super.getLocaleContext();
    }

    public final void setLocaleContext(LocaleContext localeContext) {
        ApplicationModule applicationModule = this.getApplicationModule();
        if (applicationModule != null && localeContext != null) {
            applicationModule.getSession().setLocale(localeContext.getLocale());
        }
        super.setLocaleContext(localeContext);
    }

    protected Object internalGet(String string) {
        if (GET_TransactionDirty == string) {
            return this.isTransactionDirty();
        }
        return super.internalGet(string);
    }

    public final ApplicationModule getApplicationModule() {
        return this.mAM;
    }

    public void release(int n) {
        BindingContext bindingContext;
        WSApplicationModuleImpl wSApplicationModuleImpl;
        if (!this.mInEndRequest && this.syncNeeded() && (wSApplicationModuleImpl = (WSApplicationModuleImpl)this.getApplicationModule()) != null && wSApplicationModuleImpl.getImplObject() == null && (bindingContext = this.getBindingContext()) != null && bindingContext.isJClientApp()) {
            this.resetState();
            this.endRequest(null);
        }
        super.release(n);
        if (this.mIsRoot && (n & DCDataControl.REL_DATA_REFS) > 0) {
            if (this.mAM != null) {
                try {
                    this.mAM.getTransaction().removeTransactionStateListener((TransactionStateListener)this);
                }
                catch (NotConnectedException notConnectedException) {
                    // empty catch block
                }
            }
            if (n == DCDataControl.REL_ALL_REFS) {
                if (this.mAM != null && this.syncNeeded()) {
                    ((WSApplicationModuleImpl)this.mAM).closeWSApplicationModule();
                } else if (this.mSessionCookie != null) {
                    ((SessionCookieImpl)this.mSessionCookie).timeout();
                } else if (this.mAM != null) {
                    Configuration.releaseRootApplicationModule((ApplicationModule)this.mAM, (boolean)true);
                }
                this.mSessionCookie = null;
            }
            this.mAM = null;
        }
    }

    protected RowSetIterator getRowSetIterator(String string) {
        return this.mAM.findViewObject(string);
    }

    protected Object getAccessorValue(RowSetIterator rowSetIterator, Row row, DCIteratorBinding dCIteratorBinding, String string) {
        try {
            Object object = row.getAttribute(string);
            if (object == null && this.syncNeeded() && !this.isObjectTypeIterator(dCIteratorBinding) && rowSetIterator != null) {
                this.executeIteratorBinding(dCIteratorBinding);
                Object var7_6 = null;
                return var7_6;
            }
            Object object2 = object;
            return object2;
        }
        catch (InvalidOperException invalidOperException) {
            if (this.syncNeeded() && !dCIteratorBinding.isIteratorMadeVisible()) {
                Object var9_9 = null;
                return var9_9;
            }
            throw invalidOperException;
        }
    }

    private boolean isObjectTypeIterator(DCIteratorBinding dCIteratorBinding) {
        DCIteratorBindingDef dCIteratorBindingDef = dCIteratorBinding.getDef();
        return dCIteratorBindingDef != null && dCIteratorBindingDef.isObjectType();
    }

    protected RowSetIterator createAccessorRowSetIterator(RowSetIterator rowSetIterator, Row row, DCIteratorBinding dCIteratorBinding, String string, String string2, boolean bl) {
        if (this.isObjectTypeIterator(dCIteratorBinding)) {
            dCIteratorBinding.setAllowFindMode(false);
            StructureDef structureDef = null;
            Struct struct = null;
            Class clazz = null;
            if (row != null && (struct = (Struct)this.getAccessorValue(rowSetIterator, row, dCIteratorBinding, string)) != null) {
                clazz = struct.getClass();
                structureDef = struct.getStructureDef();
            }
            if (clazz == null) {
                StructureDef structureDef2 = null;
                if (rowSetIterator instanceof DCRowSetIteratorImpl) {
                    structureDef2 = ((DCRowSetIteratorImpl)rowSetIterator).getStructureDef();
                } else if (rowSetIterator.getRowSet() != null) {
                    structureDef2 = rowSetIterator.getRowSet().getViewObject();
                }
                if (structureDef2 != null) {
                    AttributeDef attributeDef = null;
                    try {
                        attributeDef = structureDef2.lookupAttributeDef(string);
                    }
                    catch (InvalidOperException invalidOperException) {
                        // empty catch block
                    }
                    if (attributeDef != null) {
                        clazz = attributeDef.getJavaType();
                    }
                }
            }
            if (clazz != null && structureDef == null) {
                structureDef = Struct.resolveAndGetStructureDef(clazz);
            }
            return new DCDomainRowSetIteratorImpl(this, struct, string, structureDef, clazz, row);
        }
        try {
            if (this.syncNeeded() && rowSetIterator != null && this.mastersToExecute != null && this.mastersToExecute.containsKey(rowSetIterator.getName())) {
                this.executeIteratorBinding(dCIteratorBinding);
                RowSetIterator rowSetIterator2 = null;
                return rowSetIterator2;
            }
            RowSetIterator rowSetIterator3 = super.createAccessorRowSetIterator(rowSetIterator, row, dCIteratorBinding, string, string2, bl);
            return rowSetIterator3;
        }
        catch (InvalidOperException invalidOperException) {
            if (this.syncNeeded() && !dCIteratorBinding.isIteratorMadeVisible()) {
                RowSetIterator rowSetIterator4 = null;
                return rowSetIterator4;
            }
            throw invalidOperException;
        }
    }

    public RowSetIterator createAccessorRowSetIterator(RowSetIterator rowSetIterator, DCIteratorBinding dCIteratorBinding, String string, String string2) {
        Row row = null;
        if (this.isObjectTypeIterator(dCIteratorBinding)) {
            Object var6_6 = null;
            row = rowSetIterator.getCurrentRow();
            if (row == null) {
                try {
                    row = rowSetIterator.first();
                }
                catch (InvalidOperException invalidOperException) {
                    if (!this.syncNeeded()) {
                        throw invalidOperException;
                    }
                    Diagnostic.println((String)"Warning! Ignoring InvalidOperException in case of domain access in batchmode");
                }
            }
        }
        return this.createAccessorRowSetIterator(rowSetIterator, row, dCIteratorBinding, string, string2);
    }

    protected RowSetIterator createRowSetIteratorImpl(String string, Object object, RowSetIterator rowSetIterator) {
        Object var4_4 = null;
        if (object instanceof RowSetIterator) {
            return (RowSetIterator)object;
        }
        StructureDef structureDef = null;
        if (object instanceof Row) {
            structureDef = ((Row)object).getStructureDef();
        } else if (object instanceof Row[]) {
            Row[] rowArray = (Row[])object;
            if (rowArray.length > 0) {
                structureDef = rowArray[0].getStructureDef();
            }
        } else if (string != null) {
            structureDef = this.getApplicationModule().findViewObject(string);
        }
        if (structureDef == null) {
            structureDef = new StructureDefImpl(this, string, "methodRSIStructure");
        }
        return new DCRowSetIteratorImpl(this, object, "methodArrayIterator", structureDef);
    }

    protected void executeIteratorBinding(DCIteratorBinding dCIteratorBinding) {
        if (this.mSyncNeeded) {
            DCIteratorBindingDef dCIteratorBindingDef = dCIteratorBinding.getDef();
            if (dCIteratorBindingDef != null && dCIteratorBindingDef.getSubType() == "DCAccessorIterator") {
                StringBuffer stringBuffer = new StringBuffer();
                WSViewObjectImpl wSViewObjectImpl = (WSViewObjectImpl)((JUAccessorIteratorDef)dCIteratorBinding.getDef()).calcAccessorPath(dCIteratorBinding, stringBuffer);
                wSViewObjectImpl.setAccessorTraversalByNamePaths(new String[]{stringBuffer.toString()});
                if (dCIteratorBinding.needsEstimatedRowCount()) {
                    wSViewObjectImpl.requestEstimatedRowCount();
                }
            } else {
                RowSetIterator rowSetIterator = dCIteratorBinding.getRowSetIterator();
                if (rowSetIterator != null) {
                    if (this.mastersToExecute == null) {
                        this.mastersToExecute = new HashMap(7);
                    }
                    this.mastersToExecute.put(rowSetIterator.getName(), null);
                }
                ((WSViewObjectImpl)dCIteratorBinding.getViewObject()).refreshDataModel();
                if (dCIteratorBinding.needsEstimatedRowCount()) {
                    ((WSRowSet)rowSetIterator.getRowSet()).requestEstimatedRowCount();
                }
            }
        } else {
            RowSetIterator rowSetIterator = dCIteratorBinding.getRowSetIterator();
            RowSet rowSet = rowSetIterator.getRowSet();
            if (rowSet != null) {
                rowSet.executeQuery();
            }
        }
    }

    protected void executeIteratorBindingIfNeeded(DCIteratorBinding dCIteratorBinding) {
        DCIteratorBindingDef dCIteratorBindingDef;
        if (this.mSyncNeeded && !dCIteratorBinding.hasRSI() && (dCIteratorBindingDef = dCIteratorBinding.getDef()) != null && dCIteratorBindingDef.getSubType() == "DCAccessorIterator") {
            StringBuffer stringBuffer = new StringBuffer();
            WSViewObjectImpl wSViewObjectImpl = (WSViewObjectImpl)((JUAccessorIteratorDef)dCIteratorBinding.getDef()).calcAccessorPath(dCIteratorBinding, stringBuffer);
            wSViewObjectImpl.setAccessorTraversalByNamePaths(new String[]{stringBuffer.toString()});
            if (dCIteratorBinding.needsEstimatedRowCount()) {
                wSViewObjectImpl.requestEstimatedRowCount();
            }
            return;
        }
        RowSetIterator rowSetIterator = dCIteratorBinding.getRowSetIterator();
        if (rowSetIterator != null) {
            RowSet rowSet = rowSetIterator.getRowSet();
            if (rowSet == null) {
                super.rebuildIteratorIfNeeded(dCIteratorBinding);
            } else if (!rowSet.isExecuted()) {
                if (this.mSyncNeeded) {
                    WSRowSet wSRowSet = (WSRowSet)rowSet;
                    wSRowSet.refreshDataModel2(true, false);
                    if (dCIteratorBinding.needsEstimatedRowCount()) {
                        wSRowSet.requestEstimatedRowCount();
                    }
                } else {
                    rowSet.executeQuery();
                }
            }
        }
    }

    public void setCurrentRowWithKeyValue(DCIteratorBinding dCIteratorBinding, String string) {
        RowSetIterator rowSetIterator = dCIteratorBinding.getRowSetIterator();
        ViewObject viewObject = rowSetIterator.getRowSet().getViewObject();
        AttributeDef[] attributeDefArray = viewObject.getKeyAttributeDefs();
        if (attributeDefArray.length == 1) {
            Object object = TypeFactory.getInstance((Class)attributeDefArray[0].getJavaType(), (Object)string);
            Key key = new Key(new Object[]{object});
            this.setCurrentRowInRSI(dCIteratorBinding, rowSetIterator, null, key);
        }
    }

    public void setCurrentRowWithKey(DCIteratorBinding dCIteratorBinding, String string) {
        RowSetIterator rowSetIterator = dCIteratorBinding.getRowSetIterator();
        try {
            this.setCurrentRowInRSI(dCIteratorBinding, rowSetIterator, null, new Key(string, rowSetIterator.getRowSet().getViewObject().getKeyAttributeDefs()));
        }
        catch (JboException jboException) {
            throw jboException;
        }
        catch (Throwable throwable) {
            throw new JboException(throwable);
        }
    }

    public void setCurrentRowWithKey(DCIteratorBinding dCIteratorBinding, Key key) {
        RowSetIterator rowSetIterator = dCIteratorBinding.getRowSetIterator();
        try {
            this.setCurrentRowInRSI(dCIteratorBinding, rowSetIterator, null, key);
        }
        catch (JboException jboException) {
            throw jboException;
        }
        catch (Throwable throwable) {
            throw new JboException(throwable);
        }
    }

    void setCurrentRowInRSI(DCIteratorBinding dCIteratorBinding, RowSetIterator rowSetIterator, Row row, Key key) {
        Row[] rowArray;
        if (row == null && this.syncNeeded()) {
            if (rowSetIterator instanceof WSRowSetIteratorBase) {
                ((WSRowSetIteratorBase)rowSetIterator).findAndSetCurrentRowByKey(key, 0);
            } else if (rowSetIterator instanceof Proxy) {
                WSViewObjectImpl wSViewObjectImpl = null;
                WSProxy wSProxy = (WSProxy)Proxy.getInvocationHandler(rowSetIterator);
                wSViewObjectImpl = wSProxy.getWSViewObject();
                wSViewObjectImpl.findAndSetCurrentRowByKey(key, 0);
            }
        }
        if ((rowArray = rowSetIterator.findByKey(key, 1)) != null && rowArray.length > 0) {
            if (!rowSetIterator.getRowSet().isExecuted()) {
                rowSetIterator.getRowSet().executeQuery();
                rowArray = rowSetIterator.findByKey(key, 1);
            }
        } else {
            Diagnostic.println((String)("Currency not set, no row found with key :" + key));
            Class clazz = class$oracle$jbo$CSMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$jbo$CSMessageBundle = DCJboDataControl.class$("oracle.jbo.CSMessageBundle");
            }
            throw new RowNotFoundException(clazz, "25020", new Object[]{dCIteratorBinding.getName(), key});
        }
        rowSetIterator.setCurrentRow(rowArray[0]);
    }

    protected long getEstimatedRowCount(DCIteratorBinding dCIteratorBinding) {
        long l = 0L;
        try {
            RowSetIterator rowSetIterator = dCIteratorBinding.getRowSetIterator();
            if (rowSetIterator != null) {
                RowSet rowSet = rowSetIterator.getRowSet();
                if (rowSet != null) {
                    if (rowSet.isExecuted() && (l = rowSet.getEstimatedRowCount()) <= 0L) {
                        if (dCIteratorBinding.needsEstimatedRowCount()) {
                            // empty if block
                        }
                        l = rowSetIterator.getRowCountInRange();
                    }
                } else {
                    l = rowSetIterator.getRowCount();
                }
            }
        }
        catch (Exception exception) {
            this.reportException(dCIteratorBinding.getBindingContainer(), exception);
        }
        return l;
    }

    public boolean isTransactionDirty() {
        return this.isTransactionModified() || this.mAM != null && this.mAM.getTransaction().isDirty();
    }

    public void commitTransaction() {
        this.getApplicationModule().getTransaction().commit();
    }

    public void validate() {
        this.getApplicationModule().getTransaction().validate();
    }

    public void rollbackTransaction() {
        this.getApplicationModule().getTransaction().rollback();
    }

    public boolean isOperationSupported(DCIteratorBinding dCIteratorBinding, byte by) {
        if (dCIteratorBinding == null) {
            return false;
        }
        switch (by) {
            case 3: {
                if (!dCIteratorBinding.isFindModeAllowed()) {
                    return false;
                }
                DCIteratorBindingDef dCIteratorBindingDef = dCIteratorBinding.getDef();
                return dCIteratorBindingDef == null || !"DCMethodIterator".equals(dCIteratorBindingDef.getSubType()) || !dCIteratorBinding.hasRSI() || !(dCIteratorBinding.getNavigatableRowIterator() instanceof DCRowSetIteratorImpl);
            }
            case 5: {
                return !dCIteratorBinding.isIteratorMadeVisible() || dCIteratorBinding.getViewObject() != null;
            }
            case 1: 
            case 2: {
                ViewObject viewObject;
                if (this.isObjectTypeIterator(dCIteratorBinding)) {
                    if (dCIteratorBinding.isIteratorMadeVisible()) {
                        DCBindingContainer dCBindingContainer = dCIteratorBinding.getBindingContainer();
                        if (dCBindingContainer != null && dCBindingContainer.isFindMode()) {
                            return false;
                        }
                        DCDomainRowSetIteratorImpl dCDomainRowSetIteratorImpl = (DCDomainRowSetIteratorImpl)dCIteratorBinding.getRowSetIterator();
                        if (dCDomainRowSetIteratorImpl != null && dCDomainRowSetIteratorImpl.getOwnerRow() != null) {
                            if (dCDomainRowSetIteratorImpl != null && dCDomainRowSetIteratorImpl.getFetchedRowCount() == 0) {
                                if (dCDomainRowSetIteratorImpl.getDomainJavaType() != null) {
                                    return by == 1;
                                }
                            } else {
                                return by == 2;
                            }
                        }
                    }
                    return false;
                }
                if (dCIteratorBinding.isFindMode()) {
                    return true;
                }
                if (dCIteratorBinding.hasRSI() && (viewObject = dCIteratorBinding.getViewObject()) != null) {
                    if (this.syncNeeded() && viewObject instanceof WSViewObjectImpl && ((WSViewObjectImpl)viewObject).getImplObject() == null) {
                        return false;
                    }
                    return viewObject.isReadOnly() ^ true;
                }
                return false;
            }
            case 4: {
                switch (this.mValidationInBinding) {
                    case 3: {
                        if (this.mDeployMode == DEPLOY_UNRESOLVED) {
                            this.mDeployMode = this.mAM.getSession().isClient() ? DEPLOY_REMOTE : DEPLOY_LOCAL;
                        }
                        return this.mDeployMode != DEPLOY_LOCAL;
                    }
                    case 1: {
                        return false;
                    }
                }
                return true;
            }
            case 6: {
                DCIteratorBindingDef dCIteratorBindingDef = dCIteratorBinding.getDef();
                return dCIteratorBindingDef == null || dCIteratorBindingDef.getSubType() == "DCIterator";
            }
            case 0: {
                ViewObject viewObject;
                if (dCIteratorBinding.hasRSI() && (viewObject = dCIteratorBinding.getViewObject()) != null) {
                    if (this.syncNeeded() && viewObject instanceof WSViewObjectImpl && ((WSViewObjectImpl)viewObject).getImplObject() == null) {
                        return false;
                    }
                    return viewObject.isReadOnly() ^ true;
                }
                if (dCIteratorBinding.isFindMode()) {
                    return false;
                }
                if (this.isObjectTypeIterator(dCIteratorBinding) && dCIteratorBinding.isIteratorMadeVisible()) {
                    DCDomainRowSetIteratorImpl dCDomainRowSetIteratorImpl;
                    DCBindingContainer dCBindingContainer = dCIteratorBinding.getBindingContainer();
                    if (dCBindingContainer != null && dCBindingContainer.isFindMode()) {
                        return false;
                    }
                    if (dCIteratorBinding.hasRSI() && (dCDomainRowSetIteratorImpl = (DCDomainRowSetIteratorImpl)dCIteratorBinding.getRowSetIterator()) != null && dCDomainRowSetIteratorImpl.getOwnerRow() != null && dCDomainRowSetIteratorImpl.getDomainJavaType() != null) {
                        return true;
                    }
                }
                return super.isOperationSupported(dCIteratorBinding, by);
            }
        }
        return super.isOperationSupported(dCIteratorBinding, by);
    }

    public boolean isClientTier() {
        return this.getApplicationModule().getSession().isClient();
    }

    public boolean syncNeeded() {
        return ((DCJboDataControl)this.getRootDataControl()).mSyncNeeded;
    }

    void syncWithForceOption(String string, boolean bl) {
        WSApplicationModuleImpl wSApplicationModuleImpl;
        if (this.syncNeeded() && !bl && !(wSApplicationModuleImpl = (WSApplicationModuleImpl)this.getApplicationModule()).isSyncNeeded()) {
            if (Diagnostic.isOn()) {
                Diagnostic.println((String)("*** DCDataControl.sync() SKIP visit to MT: " + string));
            }
            return;
        }
        if (Diagnostic.isOn()) {
            Diagnostic.println((String)("*** DCDataControl.sync() called from :" + string));
        }
        this.mastersToExecute = null;
        boolean bl2 = this.isTransactionDirty();
        this.getApplicationModule().sync();
        if (bl2 != this.isTransactionDirty()) {
            this.internalSetTransactionStateChanged(bl2 ^ true);
        }
    }

    public void syncIfNeeded(String string) {
        this.syncWithForceOption(string, false);
    }

    public void sync(String string) {
        this.syncWithForceOption(string, true);
    }

    public void setClientApp(byte by) {
        super.setClientApp(by);
        this.resolveBundledExceptionMode();
    }

    int getBundledExceptionMode() {
        return this.mExcMode != 0 ? this.mExcMode : (this.isJClientApp() ? 2 : 1);
    }

    private void resolveBundledExceptionMode() {
        boolean bl = this.isJClientApp() ^ true;
        if (this.mExcMode == 1) {
            bl = true;
        } else if (this.mExcMode == 2) {
            bl = false;
        }
        if (this.mSessionCookie != null) {
            this.mSessionCookie.getUserData().put("__jbo.bundledexcmode", new Boolean(bl));
        }
    }

    public void setBundledExceptionMode(int n) {
        switch (n) {
            case 1: {
                this.mExcMode = 1;
                break;
            }
            case 2: {
                this.mExcMode = 2;
                break;
            }
            default: {
                this.mExcMode = 0;
            }
        }
        this.resolveBundledExceptionMode();
    }

    public void setValidationInBinding(int n) {
        switch (n) {
            case 1: {
                this.mValidationInBinding = 1;
                break;
            }
            case 0: 
            case 3: {
                this.mValidationInBinding = 3;
                break;
            }
            default: {
                this.mValidationInBinding = -1;
            }
        }
    }

    public int getValidationInBinding() {
        return this.mValidationInBinding;
    }

    void setSyncNeeded(boolean bl) {
        this.mSyncNeeded = bl;
    }

    public void prepareSession() {
        BindingContext bindingContext;
        if (this.syncNeeded() && (bindingContext = this.getBindingContext()) != null && bindingContext.isJClientApp()) {
            this.beginRequest(null);
        }
    }

    public void beginRequest(HashMap hashMap) {
        if (!this.mInRequest) {
            this.mInRequest = true;
            super.beginRequest(hashMap);
            this.rebuildApplicationModule();
            if (this.syncNeeded()) {
                ((WSApplicationModuleImpl)this.mAM).beginRequest(hashMap);
            } else {
                ADFContext aDFContext = ADFContext.getCurrent();
                if (aDFContext.hasEnvironment()) {
                    this.mSessionCookie.writeValue(aDFContext.getEnvironment().getResponse());
                }
            }
        }
    }

    public void endRequest(HashMap hashMap) {
        try {
            this.mInEndRequest = true;
            super.endRequest(hashMap);
            if (this.mAM != null) {
                this.releaseApplicationModule(true);
                if (this.syncNeeded()) {
                    if (hashMap == null) {
                        hashMap = new HashMap<String, Integer>(1);
                    }
                    hashMap.put("__jbo.endrequest_release_level__", new Integer(this.getReleaseLevel()));
                    ((WSApplicationModuleImpl)this.mAM).endRequest(hashMap);
                }
            }
            if (this.mSessionCookie != null && this.mSessionCookie.isFailoverEnabled()) {
                Hashtable<String, DefaultPolicyImpl> hashtable = new Hashtable<String, DefaultPolicyImpl>(4);
                hashtable.put("adf.statemanager.policy_key", new DefaultPolicyImpl(true, true, (long)-1));
                ADFContext aDFContext = ADFContext.getCurrent();
                Map map = aDFContext.getStateManager(ADFContext.SESSION_SCOPE, hashtable);
                String string = this.getName();
                if (string == null) {
                    Class clazz = class$oracle$adf$model$bc4j$DCJboDataControl;
                    if (clazz == null) {
                        clazz = class$oracle$adf$model$bc4j$DCJboDataControl = DCJboDataControl.class$("oracle.adf.model.bc4j.DCJboDataControl");
                    }
                    string = clazz.getName();
                }
                map.put(string, String.valueOf(this.mSessionCookie.getPassivationId()));
            }
            Object var7_6 = null;
            this.mInEndRequest = false;
            this.mInRequest = false;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.mInEndRequest = false;
            this.mInRequest = false;
            throw throwable;
        }
    }

    public boolean resetState() {
        if (super.resetState()) {
            this.releaseApplicationModule(false);
            Map map = ADFContext.getCurrent().getStateManager(ADFContext.SESSION_SCOPE, null);
            String string = this.getName();
            if (string == null) {
                Class clazz = class$oracle$adf$model$bc4j$DCJboDataControl;
                if (clazz == null) {
                    clazz = class$oracle$adf$model$bc4j$DCJboDataControl = DCJboDataControl.class$("oracle.adf.model.bc4j.DCJboDataControl");
                }
                string = clazz.getName();
            }
            map.remove(string);
            if (!this.mInEndRequest) {
                this.rebuildApplicationModule();
            }
            return true;
        }
        return false;
    }

    private void rebuildApplicationModule() {
        if (this.mAM == null && this.syncNeeded()) {
            this.setApplicationModule((ApplicationModule)new WSApplicationModuleImpl(this.mSessionCookie));
            this.prepareSession();
        }
        if (this.mSessionCookie != null) {
            this.mSessionCookie.reservePassivationId();
            if (!this.syncNeeded()) {
                this.setApplicationModule(this.mSessionCookie.useApplicationModule());
                if (this.mSessionCookie.wasActivated() && this.mAM.getTransaction().isDirty()) {
                    this.setTransactionModified();
                }
            }
        }
    }

    public ViewObject findCustomViewObject(String string, String string2) {
        ApplicationModule applicationModule = this.getApplicationModule();
        if (applicationModule == null) {
            throw new IllegalStateException();
        }
        if (this.syncNeeded()) {
            WSApplicationModuleImpl wSApplicationModuleImpl = (WSApplicationModuleImpl)applicationModule;
            return wSApplicationModuleImpl.findCustomViewObject(string, string2);
        }
        return applicationModule.findViewObject(string);
    }

    private void releaseApplicationModule(boolean bl) {
        if (!bl) {
            if (this.getDef() != null) {
                this.release(DCDataControl.REL_ALL_REFS);
            } else {
                if (this.syncNeeded()) {
                    this.mAM.resetState(8);
                }
                this.release(DCDataControl.REL_DATA_REFS);
                this.setDataProvider(null);
            }
        } else if (!this.syncNeeded()) {
            this.release(DCDataControl.REL_DATA_REFS);
            this.setDataProvider(null);
            if ((this.getReleaseLevel() & 2) > 0) {
                this.mSessionCookie.releaseApplicationModule(0);
            } else {
                this.mSessionCookie.releaseApplicationModule(3);
            }
        } else {
            this.release(DCDataControl.REL_WEAK_DATA_REFS);
        }
    }

    protected void setDataProvider(Object object) {
        if (object instanceof WSApplicationModuleImpl) {
            object = ((WSApplicationModuleImpl)object).getCustomApplicationModule();
        }
        super.setDataProvider(object);
    }

    public AttributeDef[] getAttributeDefs(DCIteratorBinding dCIteratorBinding, String[] stringArray) {
        RowSetIterator rowSetIterator = dCIteratorBinding.getRowSetIterator();
        if (rowSetIterator instanceof DCRowSetIteratorImpl) {
            return super.resolveAttributeDefs(((DCRowSetIteratorImpl)rowSetIterator).getStructureDef(), stringArray);
        }
        return new AttributeDef[0];
    }

    public void setSessionCookie(SessionCookie sessionCookie) {
        this.mSessionCookie = sessionCookie;
        this.resolveBundledExceptionMode();
    }

    protected void applySortCriteria(DCIteratorBinding dCIteratorBinding, SortCriteria[] sortCriteriaArray) {
        if (sortCriteriaArray != null) {
            ViewObject viewObject = dCIteratorBinding.getViewObject();
            if (this.syncNeeded()) {
                ((WSApplicationModuleImpl)this.mAM).applyVOSortCriteria(viewObject, sortCriteriaArray);
            } else {
                JboEnvUtil.applyVOSortCriteria((ViewObject)viewObject, (SortCriteria[])sortCriteriaArray);
            }
        }
    }

    protected SortCriteria[] getSortCriteria(DCIteratorBinding dCIteratorBinding) {
        return null;
    }

    public Object createRowData(DCRowContext dCRowContext) {
        DCDomainRowSetIteratorImpl dCDomainRowSetIteratorImpl;
        Row row;
        RowSetIterator rowSetIterator = dCRowContext.getRowSetIterator();
        if (rowSetIterator instanceof DCDomainRowSetIteratorImpl && (row = (dCDomainRowSetIteratorImpl = (DCDomainRowSetIteratorImpl)rowSetIterator).getOwnerRow()) != null) {
            Class clazz = dCDomainRowSetIteratorImpl.getDomainJavaType();
            try {
                Object t = clazz.newInstance();
                row.setAttribute(rowSetIterator.getName(), t);
                Object t2 = t;
                return t2;
            }
            catch (JboException jboException) {
                throw jboException;
            }
            catch (Exception exception) {
                throw new JboException((Throwable)exception);
            }
        }
        return null;
    }

    public boolean removeRowData(DCRowContext dCRowContext) {
        RowSetIterator rowSetIterator = dCRowContext.getRowSetIterator();
        if (rowSetIterator instanceof DCDomainRowSetIteratorImpl) {
            DCDomainRowSetIteratorImpl dCDomainRowSetIteratorImpl = (DCDomainRowSetIteratorImpl)rowSetIterator;
            dCDomainRowSetIteratorImpl.getOwnerRow().setAttribute(rowSetIterator.getName(), null);
            dCDomainRowSetIteratorImpl.clearCurrentData();
            return true;
        }
        return true;
    }

    public void setAttributeInRow(DCIteratorBinding dCIteratorBinding, Row row, AttributeDef attributeDef, Object object) {
        super.setAttributeInRow(dCIteratorBinding, row, attributeDef, object);
        if (dCIteratorBinding.isFindMode()) {
            if (this.syncNeeded()) {
                ((WSApplicationModuleImpl)this.mAM).setIsSyncNeeded(true);
                this.getViewCriteria(dCIteratorBinding);
            } else if (this.isClientTier()) {
                this.getViewCriteria(dCIteratorBinding);
            }
        }
    }

    public ViewCriteria createViewCriteria(DCIteratorBinding dCIteratorBinding) {
        if (dCIteratorBinding.getViewObject() != null) {
            return dCIteratorBinding.getViewObject().createViewCriteria();
        }
        return null;
    }

    public ViewCriteria getViewCriteria(DCIteratorBinding dCIteratorBinding) {
        ViewCriteria viewCriteria = null;
        ViewObject viewObject = dCIteratorBinding.getViewObject();
        if (viewObject != null) {
            viewCriteria = viewObject.getViewCriteria();
            if (viewCriteria == null) {
                viewCriteria = viewObject.createViewCriteria();
            }
            viewObject.applyViewCriteria(viewCriteria);
            if (this.syncNeeded()) {
                ((WSApplicationModuleImpl)this.mAM).setIsSyncNeeded(true);
            }
        }
        return viewCriteria;
    }

    public void applyViewCriteria(ViewCriteria viewCriteria, DCIteratorBinding dCIteratorBinding, RowSetIterator rowSetIterator) {
        if (rowSetIterator instanceof ViewObject) {
            ((ViewObject)rowSetIterator).applyViewCriteria(viewCriteria);
        } else if (rowSetIterator.getRowSet() != null) {
            rowSetIterator.getRowSet().getViewObject().applyViewCriteria(viewCriteria);
        } else if (Diagnostic.isOn()) {
            Diagnostic.println((String)("Warning.... Can't apply criteria to this iteratorbinding :" + dCIteratorBinding.getName()));
        }
    }

    protected void internalSetTransactionStateChanged(boolean bl) {
        if (bl && !this.isTransactionModified() && !this.getApplicationModule().getTransaction().isDirty()) {
            return;
        }
        super.internalSetTransactionStateChanged(bl);
    }

    protected boolean isBoundRowIteratorEvent(DCIteratorBinding dCIteratorBinding, JboEvent jboEvent) {
        NavigatableRowIterator navigatableRowIterator;
        if (dCIteratorBinding.getNavigatableRowIterator() == jboEvent.getSource()) {
            return true;
        }
        if (this.syncNeeded() && (navigatableRowIterator = dCIteratorBinding.getNavigatableRowIterator()) instanceof WSRowSetIteratorBase) {
            return ((WSRowSetIteratorBase)navigatableRowIterator).getImplObject() == jboEvent.getSource();
        }
        return false;
    }

    public int getReleaseLevel() {
        if (this.mAM != null) {
            return this.mReleaseLevel | this.mAM.getReleaseLevel();
        }
        return this.mReleaseLevel;
    }

    public void setReleaseLevel(int n) {
        if (this.mAM != null) {
            this.mAM.setReleaseLevel(n);
        }
        this.mReleaseLevel = n;
    }

    public void executeIteratorBindingWithParams(DCIteratorBinding dCIteratorBinding, OperationParameter[] operationParameterArray, Object[] objectArray) {
        RowSet rowSet = dCIteratorBinding.getRowSetIterator().getRowSet();
        VariableValueManager variableValueManager = rowSet.ensureVariableManager();
        if (operationParameterArray != null) {
            int n = 0;
            while (n < operationParameterArray.length) {
                String string = operationParameterArray[n].getName();
                Variable variable = variableValueManager.lookupVariable(string);
                if (variable != null) {
                    variableValueManager.setVariableValue(string, objectArray[n]);
                    rowSet.setNamedWhereClauseParam(string, variableValueManager.getVariableValue(string));
                }
                ++n;
            }
        }
        rowSet.executeQuery();
    }

    protected Object invokeMethod(DCInvokeMethod dCInvokeMethod, OperationBinding operationBinding, Map map) {
        if (FINDVOWITHPARAMS.equals(dCInvokeMethod.getMethodName())) {
            ApplicationModule applicationModule;
            ViewObject viewObject;
            OperationParameter[] operationParameterArray = dCInvokeMethod.getParameters();
            Object[] objectArray = new Object[operationParameterArray.length];
            int n = 0;
            while (n < operationParameterArray.length) {
                objectArray[n] = operationParameterArray[n].getValue();
                ++n;
            }
            String string = (String)operationParameterArray[0].getValue();
            VariableManager variableManager = null;
            boolean bl = true;
            if (operationParameterArray.length == 3 && VARAIBLE_MANAGER_CLASS.equals(operationParameterArray[1].getTypeName())) {
                variableManager = (VariableManager)operationParameterArray[1].getValue();
                bl = (Boolean)operationParameterArray[2].getValue();
            }
            if (variableManager == null) {
                VariableValueManagerImpl variableValueManagerImpl = new VariableValueManagerImpl(null, null);
                int n2 = 1;
                while (n2 < operationParameterArray.length) {
                    OperationParameter operationParameter = operationParameterArray[n2];
                    variableValueManagerImpl.addVariable(operationParameter.getName());
                    VariableImpl variableImpl = (VariableImpl)variableValueManagerImpl.lookupVariable(operationParameter.getName());
                    try {
                        variableImpl.setJavaType(JBOClass.forName((String)operationParameter.getTypeName()));
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                    variableValueManagerImpl.setVariableValue(operationParameter.getName(), operationParameter.getValue());
                    ++n2;
                }
                variableManager = variableValueManagerImpl;
            }
            if ((viewObject = (applicationModule = (ApplicationModule)dCInvokeMethod.getInvokeInstance(this, this.getBindingContext())).findViewObjectWithParameters(string, variableManager, bl)) != null) {
                this.cacheMethodResult(dCInvokeMethod, viewObject, objectArray);
            }
            return viewObject;
        }
        return super.invokeMethod(dCInvokeMethod, operationBinding, map);
    }

    protected Variable findVariable(String string) {
        int n = string.indexOf("variablesMap");
        if (n > -1) {
            String string2 = string.substring(0, n - 1);
            String string3 = string.substring(n + this.VARIABLES_MAP_LENGTH);
            ViewObject viewObject = this.mAM.findViewObject(string2);
            if (viewObject != null) {
                return viewObject.ensureVariableManager().lookupVariable(string3);
            }
        }
        return null;
    }

    protected void resetAttributeExceptionInRow(DCIteratorBinding dCIteratorBinding, Row row, AttributeDef attributeDef, AttrValException attrValException) {
        if (this.getBundledExceptionMode() == 1 && row != null) {
            block4: {
                boolean bl = this.isTransactionModified();
                int n = attributeDef.getIndex();
                try {
                    dCIteratorBinding.suspendRowSetEventsHandling(true);
                    row.setAttribute(n, row.getAttribute(n));
                    Object var8_7 = null;
                    if (bl) break block4;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    if (!bl) {
                        this.transactionStateChanged(false);
                    }
                    dCIteratorBinding.suspendRowSetEventsHandling(false);
                    throw throwable;
                }
                this.transactionStateChanged(false);
            }
            dCIteratorBinding.suspendRowSetEventsHandling(false);
            {
            }
        }
    }

    static {
        Class clazz = class$oracle$jbo$VariableManager;
        if (clazz == null) {
            clazz = class$oracle$jbo$VariableManager = DCJboDataControl.class$("oracle.jbo.VariableManager");
        }
        VARAIBLE_MANAGER_CLASS = clazz.getName();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class DCDomainRowSetIteratorImpl
    extends DCRowSetIteratorImpl {
        Class mJavaType;
        Row mOwner;
        private static /* synthetic */ Class class$oracle$adf$model$ADFmMessageBundle;

        DCDomainRowSetIteratorImpl(DCDataControl dCDataControl, Object object, String string, StructureDef structureDef, Class clazz, Row row) {
            super(dCDataControl, object, string, structureDef);
            this.mJavaType = clazz;
            this.mOwner = row;
            this.first();
        }

        protected Row internalCreateRowInstanceFor(Object object) {
            return new DomainRowImpl(object, this);
        }

        public Row createAndInitRow(AttributeList attributeList) {
            Object object = this.getDataControl().createRowData(new DCRowContext(this, this.getStructureDef(), attributeList));
            if (object != null) {
                return this.internalCreateRowInstanceFor(object);
            }
            Class clazz = class$oracle$adf$model$ADFmMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$adf$model$ADFmMessageBundle = DCDomainRowSetIteratorImpl.class$("oracle.adf.model.ADFmMessageBundle");
            }
            throw new JboException(clazz, "35004", null);
        }

        public Row getOwnerRow() {
            return this.mOwner;
        }

        final Class getDomainJavaType() {
            return this.mJavaType;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    public class DomainRowImpl
    extends RowImpl {
        protected DomainRowImpl(Object object, DCRowSetIteratorImpl dCRowSetIteratorImpl) {
            super(object, dCRowSetIteratorImpl);
        }

        public Object getAttribute(int n) {
            return ((AttributeList)this.getDataProvider()).getAttribute(n);
        }

        public final Object getAttribute(String string) {
            return ((AttributeList)this.getDataProvider()).getAttribute(string);
        }

        public void setAttribute(int n, Object object) {
            ((AttributeList)this.getDataProvider()).setAttribute(n, object);
        }

        public void setAttribute(String string, Object object) {
            ((AttributeList)this.getDataProvider()).setAttribute(string, object);
        }
    }
}

