/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.model.adapter.dataformat;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import oracle.adf.model.adapter.AdapterContext;
import oracle.adf.model.adapter.AdapterException;
import oracle.adf.model.adapter.dataformat.FormatDataEvent;
import oracle.adf.model.adapter.dataformat.FormatDataEventListener;
import oracle.adf.model.adapter.dataformat.FormatDataHandler;
import oracle.adf.model.adapter.dataformat.xml.TypeMap;
import oracle.adf.model.adapter.utils.Utility;
import oracle.adf.share.logging.ADFLogger;
import oracle.adf.share.perf.Timer;
import oracle.xml.parser.schema.XSDTypeConstants;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLAttr;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLDocumentFragment;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.parser.v2.XSLProcessor;
import oracle.xml.parser.v2.XSLStylesheet;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLHandler
implements FormatDataHandler {
    private Node mDataNode;
    private Node mReferenceRoot;
    private Map mReferenceMap;
    private Document mDoc;
    private InputStream mDataStream;
    private InputStream mXsdStream;
    private InputStream mXsltStream;
    private ADFLogger _logger;
    private FormatDataEventListener mEventListener;
    public static final String EV_EOD = "__ev_eod__";
    public static final String REFERENCE_ROOT = "ReferenceRoot";
    private static final String HREF = "href";
    private static final String ARRAY_ITEM = "item";
    private static final String SOAP_ARRAY_TYPE = "arrayType";
    private static final String SOAP_ARRAY = "Array";
    private static final String SOAP_ENC_NS = "http://schemas.xmlsoap.org/soap/encoding";
    private static Timer sInitTimer = Timer.createTimer((Level)Level.FINER, (String)"/oracle/adf/model/adapter/dataformat/XMLHandler", (String)"init", (String)"Instantiating the XMLHandler ");
    private static Timer sGetSimpleResultTimer = Timer.createTimer((Level)Level.FINER, (String)"/oracle/adf/model/adapter/dataformat/XMLHandler", (String)"getSimpleResult", (String)"Fetching the result for simple type");
    private static Timer sGetComplexResultTimer = Timer.createTimer((Level)Level.FINER, (String)"/oracle/adf/model/adapter/dataformat/XMLHandler", (String)"getComplextResult", (String)"Creating the collection iterators for complex data");
    private static Timer sHandleSoapTimer = Timer.createTimer((Level)Level.FINER, (String)"/oracle/adf/model/adapter/dataformat/XMLHandler", (String)"handleSoapEncodedCollections", (String)"Creating collection iterator for array");
    private static /* synthetic */ Class class$java$lang$String;

    private /* synthetic */ void $init$() {
        this.mReferenceRoot = null;
        this.mReferenceMap = null;
        this.mDoc = null;
        this._logger = AdapterContext.getDefaultContext().getLogger();
        this.mEventListener = null;
    }

    public XMLHandler(InputStream inputStream, boolean bl) {
        this.$init$();
        bl = false;
        try {
            if (bl) {
                this.mDataStream = inputStream;
            } else {
                this.parseDataStream(inputStream, null);
            }
        }
        catch (Exception exception) {
            throw new AdapterException(exception);
        }
    }

    public XMLHandler(InputStream inputStream, InputStream inputStream2, boolean bl) {
        this.$init$();
        bl = false;
        try {
            if (bl) {
                this.mDataStream = inputStream;
            } else {
                this.parseDataStream(inputStream, inputStream2);
            }
        }
        catch (Exception exception) {
            throw new AdapterException(exception);
        }
    }

    public XMLHandler(Node node) {
        this.$init$();
        this.mDataNode = node;
    }

    public XMLHandler(Node node, Reader reader) throws AdapterException {
        this.$init$();
        try {
            try {
                sInitTimer.start();
                this.mDataNode = node;
                if (reader != null) {
                    XSLProcessor xSLProcessor = new XSLProcessor();
                    XMLDocumentFragment xMLDocumentFragment = null;
                    XSLStylesheet xSLStylesheet = xSLProcessor.newXSLStylesheet(reader);
                    if (node instanceof XMLElement) {
                        xMLDocumentFragment = xSLProcessor.processXSL(xSLStylesheet, (XMLElement)node);
                        if (xMLDocumentFragment != null) {
                            this.mDataNode = xMLDocumentFragment.getFirstChild();
                        }
                        this._logger.finest("Dumping Transformed node structure for : " + this.mDataNode.getNodeName());
                        this.dumpNode(this.mDataNode);
                    }
                }
                sInitTimer.stop();
            }
            catch (XSLException xSLException) {
                this._logger.severe("Failed to create style sheet due to : " + xSLException.getMessage());
                throw new AdapterException(xSLException);
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            sInitTimer.cleanup();
            throw throwable;
        }
        sInitTimer.cleanup();
    }

    public void setDataEventListener(FormatDataEventListener formatDataEventListener) {
        this.mEventListener = formatDataEventListener;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getResult(Map map, String string) {
        String string2;
        Object object;
        block22: {
            Object var24_7;
            block20: {
                if (string == null) {
                    ArrayList arrayList = this.getResult(map);
                    if (arrayList != null) return new DataCollection(arrayList);
                    arrayList = new ArrayList();
                    return new DataCollection(arrayList);
                }
                object = null;
                string2 = null;
                String string3 = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
                try {
                    try {
                        block21: {
                            sGetSimpleResultTimer.start();
                            string2 = this.parseXML(this.mDataNode);
                            if (string2 == null || string2.length() == 0) {
                                var24_7 = null;
                                Object var26_8 = null;
                                break block20;
                            }
                            String string4 = TypeMap.getJavaType(string);
                            if (string4.equals("java.lang.String") || string4.equals("java.lang.Object") || string4.equals("byte[]") || string.equals("any")) {
                                object = string2;
                            } else if (string.equals(XSDTypeConstants.DATE_TIME) || string.equals(XSDTypeConstants.TIME)) {
                                char c;
                                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
                                String string5 = string2;
                                if (string2.length() > 23 && ((c = string2.charAt(23)) == '+' || c == '-')) {
                                    StringBuffer stringBuffer = new StringBuffer(string2);
                                    stringBuffer.deleteCharAt(string5.length() - 3);
                                    string5 = stringBuffer.toString();
                                }
                                object = simpleDateFormat.parse(string5, new ParsePosition(0));
                            } else if (string.equals(XSDTypeConstants.DATE)) {
                                try {
                                    Class<?> clazz = Class.forName("java.util.Calendar");
                                    Class<?> clazz2 = Class.forName(string4);
                                    Constructor<?> constructor = clazz2.getConstructor(new Class[0]);
                                    if (constructor == null) break block21;
                                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                                    Date date = simpleDateFormat.parse(string2, new ParsePosition(0));
                                    Object obj = constructor.newInstance(new Object[0]);
                                    if (obj != null && date != null && clazz.isInstance(obj)) {
                                        ((Calendar)obj).setTime(date);
                                        object = obj;
                                    }
                                }
                                catch (Exception exception) {
                                    object = null;
                                    this._logger.fine("Error :> " + exception.toString() + " encountered Converting the return " + "value to type: " + string4);
                                }
                            } else {
                                try {
                                    Constructor<?> constructor;
                                    Class<?> clazz = Class.forName(string4);
                                    Class[] classArray = new Class[1];
                                    Class clazz3 = class$java$lang$String;
                                    if (clazz3 == null) {
                                        clazz3 = classArray[0] = (class$java$lang$String = XMLHandler.class$("java.lang.String"));
                                    }
                                    if ((constructor = clazz.getConstructor(classArray)) != null) {
                                        object = constructor.newInstance(string2);
                                    }
                                }
                                catch (Exception exception) {
                                    object = null;
                                    this._logger.fine("Error :> " + exception.toString() + " encountered Converting the return " + "value to type: " + string4);
                                }
                            }
                        }
                        sGetSimpleResultTimer.stop();
                        break block22;
                    }
                    catch (Exception exception) {
                        throw new AdapterException(exception);
                    }
                }
                catch (Throwable throwable) {
                    Object var26_10 = null;
                    sGetSimpleResultTimer.cleanup();
                    XMLDataEvent xMLDataEvent = new XMLDataEvent(EV_EOD);
                    xMLDataEvent.sendEvent(this.mEventListener);
                    throw throwable;
                }
            }
            sGetSimpleResultTimer.cleanup();
            XMLDataEvent xMLDataEvent = new XMLDataEvent(EV_EOD);
            xMLDataEvent.sendEvent(this.mEventListener);
            return var24_7;
        }
        Object var26_9 = null;
        sGetSimpleResultTimer.cleanup();
        XMLDataEvent xMLDataEvent = new XMLDataEvent(EV_EOD);
        xMLDataEvent.sendEvent(this.mEventListener);
        if (object != null) return object;
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List getResult(Map map) {
        ArrayList arrayList;
        block13: {
            ArrayList arrayList2;
            block12: {
                if (this.mDataNode == null) {
                    return null;
                }
                arrayList = new ArrayList();
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                arrayList.add(hashMap);
                try {
                    try {
                        Node node;
                        sGetComplexResultTimer.start();
                        this.mReferenceRoot = (Node)map.get(REFERENCE_ROOT);
                        this.mDoc = this.mDataNode.getOwnerDocument();
                        if (this.mReferenceRoot != null) {
                            this.prepareReferenceMap();
                        }
                        if ((node = this.getFirstChild(this.mDataNode)) == null) {
                            arrayList2 = arrayList;
                            Object var14_6 = null;
                            break block12;
                        }
                        if (this.isNodeSOAPEncodedCollection(this.mDataNode)) {
                            this.handleSoapEncodedCollections(this.mDataNode, hashMap);
                        } else {
                            short s = node.getNodeType();
                            if (s == 3) {
                                hashMap.put(this.mDataNode.getLocalName(), node.getNodeValue());
                            } else {
                                ArrayList arrayList3 = new ArrayList();
                                HashMap hashMap2 = new HashMap();
                                hashMap.put(this.getNormalizedName(this.mDataNode.getLocalName()), arrayList3);
                                arrayList3.add(hashMap2);
                                ArrayList arrayList4 = new ArrayList();
                                HashMap hashMap3 = new HashMap();
                                hashMap2.put(this.getNormalizedName(node.getLocalName()), arrayList4);
                                arrayList4.add(hashMap3);
                                this.parseXML(node, hashMap2, hashMap3);
                                this.convertToCollection(hashMap2);
                            }
                        }
                        sGetComplexResultTimer.stop();
                        break block13;
                    }
                    catch (Exception exception) {
                        throw new AdapterException(exception);
                    }
                }
                catch (Throwable throwable) {
                    Object var14_8 = null;
                    sGetComplexResultTimer.cleanup();
                    XMLDataEvent xMLDataEvent = new XMLDataEvent(EV_EOD);
                    xMLDataEvent.sendEvent(this.mEventListener);
                    throw throwable;
                }
            }
            sGetComplexResultTimer.cleanup();
            XMLDataEvent xMLDataEvent = new XMLDataEvent(EV_EOD);
            xMLDataEvent.sendEvent(this.mEventListener);
            return arrayList2;
        }
        Object var14_7 = null;
        sGetComplexResultTimer.cleanup();
        XMLDataEvent xMLDataEvent = new XMLDataEvent(EV_EOD);
        xMLDataEvent.sendEvent(this.mEventListener);
        return arrayList;
    }

    private void parseDataStream(InputStream inputStream, InputStream inputStream2) {
        try {
            InputStream inputStream3 = inputStream;
            if (inputStream2 != null) {
                XSLStylesheet xSLStylesheet = new XSLStylesheet(inputStream2, null);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                DOMParser dOMParser = new DOMParser();
                dOMParser.setPreserveWhitespace(false);
                dOMParser.setAttribute("oracle.xml.parser.XMLParser.Standalone", (Object)Boolean.TRUE);
                dOMParser.parse((InputStream)bufferedInputStream);
                XMLDocument xMLDocument = dOMParser.getDocument();
                bufferedInputStream.close();
                XSLProcessor xSLProcessor = new XSLProcessor();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                xSLProcessor.processXSL(xSLStylesheet, xMLDocument, (OutputStream)byteArrayOutputStream);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                byteArrayOutputStream.close();
                inputStream3 = byteArrayInputStream;
            }
            DOMParser dOMParser = new DOMParser();
            dOMParser.setPreserveWhitespace(false);
            dOMParser.parse(inputStream3);
            this.mDataNode = dOMParser.getDocument().getDocumentElement();
        }
        catch (Exception exception) {
            this._logger.severe("Failed to create the DOM tree for the source. Resaon: " + exception.getLocalizedMessage());
            throw new AdapterException(exception);
        }
    }

    private void parseXML(Node node, Map map, Map map2) {
        this.processNode(node, map, map2);
        Node node2 = this.getNextSibling(node);
        while (node2 != null) {
            if (node2 != null) {
                short s = node2.getNodeType();
                switch (s) {
                    case 3: 
                    case 4: {
                        String string = this.getNormalizedName(node2.getParentNode().getLocalName());
                        map2.put("_text", node2.getNodeValue());
                        break;
                    }
                    default: {
                        if (this.isNodeSOAPEncodedCollection(node2)) {
                            this.handleSoapEncodedCollections(node2, map);
                            break;
                        }
                        ArrayList arrayList = null;
                        String string = this.getNormalizedName(node2.getLocalName());
                        HashMap hashMap = new HashMap();
                        if (this.getFirstChild(node2) != null || this.hasDeclaredAttributes(node2)) {
                            if (!map.containsKey(string)) {
                                arrayList = new ArrayList();
                                map.put(string, arrayList);
                            } else {
                                Object v = map.get(string);
                                if (v instanceof List) {
                                    arrayList = (ArrayList)v;
                                } else {
                                    arrayList = new ArrayList();
                                    HashMap hashMap2 = new HashMap();
                                    hashMap2.put(ARRAY_ITEM, v);
                                    arrayList.add(hashMap2);
                                    map.put(string, arrayList);
                                }
                            }
                            arrayList.add(hashMap);
                        }
                        this.processNode(node2, map, hashMap);
                        break;
                    }
                }
            }
            node2 = this.getNextSibling(node2);
        }
    }

    private void processNode(Node node, Map map, Map map2) {
        block14: {
            Node node2;
            if (!this.isNodeSOAPEncodedCollection(node)) {
                this.addAttributes(node, map2);
            }
            if ((node2 = this.getFirstChild(node)) == null) break block14;
            short s = node2.getNodeType();
            switch (s) {
                case 3: 
                case 4: {
                    Node node3;
                    String string = this.getNormalizedName(node2.getParentNode().getLocalName());
                    Object v = map.get(string);
                    if (this.hasDeclaredAttributes(node)) {
                        map2.put("_text", node2.getNodeValue());
                    } else if (v instanceof List && ((List)v).size() > 1) {
                        map2.put(ARRAY_ITEM, node2.getNodeValue());
                    } else {
                        map.put(string, node2.getNodeValue());
                    }
                    node2 = node3 = this.getNextSibling(node2);
                    if (node3 == null) break;
                }
                default: {
                    if (this.isNodeSOAPEncodedCollection(node)) {
                        this.handleSoapEncodedCollections(node, map);
                        break;
                    }
                    String string = this.getNormalizedName(node2.getLocalName());
                    ArrayList arrayList = null;
                    HashMap hashMap = new HashMap();
                    if (this.getFirstChild(node2) != null || this.hasDeclaredAttributes(node2)) {
                        if (!map2.containsKey(string)) {
                            arrayList = new ArrayList();
                            map2.put(string, arrayList);
                        } else {
                            Object v = map2.get(string);
                            if (v instanceof List) {
                                arrayList = (ArrayList)v;
                            } else {
                                arrayList = new ArrayList();
                                HashMap hashMap2 = new HashMap();
                                hashMap2.put(ARRAY_ITEM, v);
                                arrayList.add(hashMap2);
                                map2.put(string, arrayList);
                            }
                        }
                        arrayList.add(hashMap);
                    }
                    this.parseXML(node2, map2, hashMap);
                    break;
                }
            }
        }
    }

    private String parseXML(Node node) {
        if (node == null) {
            return null;
        }
        Node node2 = this.getFirstChild(node);
        if (node2 != null) {
            if (node2.getNodeType() == 3) {
                return node2.getNodeValue();
            }
            return this.parseXML(node2);
        }
        return this.parseXML(this.getNextSibling(node));
    }

    private void addAttributes(Node node, Map map) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            this.normalizeAttributes(namedNodeMap);
            int n = 0;
            while (n < namedNodeMap.getLength()) {
                XMLAttr xMLAttr = (XMLAttr)namedNodeMap.item(n);
                map.put(this.getNormalizedName(xMLAttr.getLocalName()), xMLAttr.getNodeValue());
                ++n;
            }
        }
    }

    private Node getFirstChild(Node node) {
        Node node2 = this.resolveRefs(node);
        Node node3 = node2.getFirstChild();
        if (this.isWhiteSpace(node3)) {
            node3 = this.getNextSibling(node3);
        }
        return node3;
    }

    private Node resolveRefs(Node node) {
        XMLAttr xMLAttr;
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = null;
        if (namedNodeMap != null && (xMLAttr = (XMLAttr)namedNodeMap.getNamedItem(HREF)) != null) {
            Node node2;
            string = xMLAttr.getNodeValue();
            if (string != null && string.charAt(0) == '#') {
                string = string.substring(1, string.length());
            }
            if ((node2 = this.mDoc.getElementById(string)) == null) {
                node2 = (Node)this.mReferenceMap.get(string);
            }
            if (node2 != null) {
                return node2;
            }
        }
        return node;
    }

    private void prepareReferenceMap() {
        this.mReferenceMap = new HashMap();
        String string = null;
        NodeList nodeList = this.mReferenceRoot.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            XMLAttr xMLAttr;
            Node node = nodeList.item(n);
            NamedNodeMap namedNodeMap = node.getAttributes();
            if (namedNodeMap != null && (xMLAttr = (XMLAttr)namedNodeMap.getNamedItem("id")) != null && (string = xMLAttr.getNodeValue()) != null) {
                this.mReferenceMap.put(string, node);
            }
            ++n;
        }
    }

    private Node getNextSibling(Node node) {
        Node node2 = node.getNextSibling();
        while (this.isWhiteSpace(node2)) {
            node2 = node2.getNextSibling();
        }
        return node2;
    }

    private boolean isWhiteSpace(Node node) {
        return node != null && node.getNodeType() == 3 && node.getNodeValue().trim().length() == 0;
    }

    private boolean hasDeclaredAttributes(Node node) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap == null) {
            return false;
        }
        this.normalizeAttributes(namedNodeMap);
        return namedNodeMap.getLength() > 0;
    }

    private void normalizeAttributes(NamedNodeMap namedNodeMap) {
        if (namedNodeMap == null) {
            return;
        }
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            XMLAttr xMLAttr = (XMLAttr)namedNodeMap.item(n);
            if (this.shouldRemoveAttribute(xMLAttr)) {
                namedNodeMap.removeNamedItem(xMLAttr.getNodeName());
                continue;
            }
            ++n;
        }
    }

    private boolean shouldRemoveAttribute(XMLAttr xMLAttr) {
        if (xMLAttr.getPrefix() != null && xMLAttr.getPrefix().equalsIgnoreCase("xmlns")) {
            return true;
        }
        if (xMLAttr.getPrefix() == null && xMLAttr.getLocalName() != null && xMLAttr.getLocalName().equalsIgnoreCase("xmlns")) {
            return true;
        }
        if (xMLAttr.getLocalName() != null && xMLAttr.getNamespaceURI() != null && (xMLAttr.getLocalName().equalsIgnoreCase(SOAP_ARRAY_TYPE) || xMLAttr.getNamespaceURI().equals(SOAP_ENC_NS))) {
            return true;
        }
        if (xMLAttr.getLocalName() != null) {
            if (xMLAttr.getLocalName().equalsIgnoreCase("type")) {
                return true;
            }
            if (xMLAttr.getLocalName().equalsIgnoreCase("nil")) {
                return true;
            }
        }
        return false;
    }

    private String getNormalizedName(String string) {
        return Utility.normalizeString(string);
    }

    private void fixUpList(List list) {
        Iterator iterator = ((ArrayList)list).iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof Map)) continue;
            this.convertToCollection((Map)e);
        }
    }

    private void convertToCollection(Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object v = map.get(string);
            if (v instanceof ArrayList) {
                DataCollection dataCollection = new DataCollection((List)v);
                map.put(string, dataCollection);
                this.fixUpList((List)v);
                continue;
            }
            if (!(v instanceof Map)) continue;
            DataCollection dataCollection = new DataCollection((Map)v);
            map.put(string, dataCollection);
            this.convertToCollection((Map)v);
        }
    }

    private void handleSoapEncodedCollections(Node node, Map map) {
        try {
            String string = this.getNormalizedName(node.getLocalName());
            sHandleSoapTimer.start();
            this._logger.finer("Creating collection for SOAP encoded array: " + string);
            ArrayList arrayList = new ArrayList();
            map.put(string, arrayList);
            Node node2 = this.getFirstChild(node);
            this.collectThisDimension(node2, map, arrayList);
            sHandleSoapTimer.stop();
            this._logger.finer("Array has " + arrayList.size() + " items");
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            sHandleSoapTimer.cleanup();
            throw throwable;
        }
        sHandleSoapTimer.cleanup();
    }

    private void collectThisDimension(Node node, Map map, List list) {
        this._logger.finer("Collecting items for each dimension of the SOAP Array");
        while (node != null) {
            Node node2 = this.getFirstChild(node);
            if (this.isNodeSOAPArrayItem(node2)) {
                this.collectThisDimension(node2, map, list);
            } else {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                list.add(hashMap);
                if (node2.getNodeType() == 4 || node2.getNodeType() == 3) {
                    hashMap.put(ARRAY_ITEM, node2.getNodeValue());
                } else {
                    Node node3 = this.resolveRefs(node);
                    NamedNodeMap namedNodeMap = node3.getAttributes();
                    if (namedNodeMap.getNamedItem("id") != null) {
                        namedNodeMap.removeNamedItem("id");
                    }
                    this.parseXML(node3, map, hashMap);
                    this._logger.finer("Collected " + list.size() + " items for this dimension");
                }
            }
            node = this.getNextSibling(node);
        }
    }

    private boolean isNodeSOAPArrayItem(Node node) {
        return node != null && node.getNodeType() == 1 && node.getLocalName().equalsIgnoreCase(ARRAY_ITEM);
    }

    private boolean isNodeSOAPEncodedCollection(Node node) {
        Node node2 = this.resolveRefs(node);
        NamedNodeMap namedNodeMap = node2.getAttributes();
        if (namedNodeMap != null) {
            XMLAttr xMLAttr = (XMLAttr)namedNodeMap.getNamedItemNS("http://www.w3.org/2001/XMLSchema-instance", "type");
            String string = null;
            if (xMLAttr != null) {
                string = xMLAttr.getNodeValue();
            } else {
                int n = 0;
                while (n < namedNodeMap.getLength()) {
                    xMLAttr = (XMLAttr)namedNodeMap.item(n);
                    String string2 = xMLAttr.getLocalName();
                    if (string2 != null && string2.equalsIgnoreCase("type")) {
                        string = xMLAttr.getNodeValue();
                        break;
                    }
                    ++n;
                }
            }
            if (string != null) {
                int n = string.indexOf(58);
                if (n > 0) {
                    string = string.substring(n + 1, string.length());
                }
                return string.equals(SOAP_ARRAY);
            }
            return false;
        }
        return false;
    }

    private void dumpNode(Node node) {
        try {
            if (node instanceof XMLNode) {
                XMLNode xMLNode = (XMLNode)node;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                xMLNode.print((OutputStream)byteArrayOutputStream);
                String string = byteArrayOutputStream.toString();
                this._logger.finest(string);
                byteArrayOutputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class DataCollection
    extends AbstractCollection {
        private Map _map;
        private List _list;

        private /* synthetic */ void $init$() {
            this._map = null;
            this._list = null;
        }

        private DataCollection(Map map) {
            this.$init$();
            this._map = map;
        }

        private DataCollection(List list) {
            this.$init$();
            this._list = list;
        }

        public Iterator iterator() {
            if (this._list != null) {
                return this._list.iterator();
            }
            if (this._map != null) {
                return this._map.values().iterator();
            }
            return null;
        }

        public int size() {
            if (this._list != null) {
                return this._list.size();
            }
            if (this._map != null) {
                return this._map.size();
            }
            return 0;
        }
    }

    public class XMLDataEvent
    extends FormatDataEvent {
        public XMLDataEvent(String string) {
            super(string, null);
        }
    }
}

