/*
 * Decompiled with CFR 0.152.
 */
package tdg.draw;

import java.awt.Color;
import java.awt.image.ColorModel;
import java.awt.image.ImageFilter;

public class RotateImageFilter
extends ImageFilter {
    private int m_nAngle;
    private int m_nWidth;
    private int m_nHeight;

    public RotateImageFilter(Color maskColor) {
        this(0);
    }

    public RotateImageFilter(int nAngle) {
        this.m_nAngle = nAngle == 1 || nAngle == 2 ? nAngle : 0;
    }

    public void setDimensions(int width, int height) {
        this.m_nWidth = width;
        this.m_nHeight = height;
        if (this.m_nAngle == 1 || this.m_nAngle == 2) {
            this.consumer.setDimensions(height, width);
        } else {
            this.consumer.setDimensions(width, height);
        }
    }

    public void setHints(int hints) {
        this.consumer.setHints(hints & 0xFFFFFFF9);
    }

    public void setPixels(int x, int y, int width, int height, ColorModel model, int[] pixels, int offset, int scansize) {
        int[] m_Pixels = new int[this.m_nWidth * this.m_nHeight];
        switch (this.m_nAngle) {
            default: {
                this.consumer.setPixels(y, x, height, width, model, pixels, 0, height);
                break;
            }
            case 1: {
                int ry = 1;
                while (ry <= height) {
                    int rx = 1;
                    while (rx <= width) {
                        int nOldIdx = ry * scansize - rx + offset;
                        int nNewIdx = (rx - 1) * height - 1 + ry;
                        m_Pixels[nNewIdx] = pixels[nOldIdx];
                        ++rx;
                    }
                    ++ry;
                }
                this.consumer.setPixels(y, x, height, width, model, m_Pixels, 0, height);
                break;
            }
            case 2: {
                int ry = 1;
                while (ry <= height) {
                    int rx = 1;
                    while (rx <= width) {
                        int nOldIdx = ry * scansize - rx + offset;
                        int nNewIdx = scansize - rx;
                        m_Pixels[nNewIdx] = pixels[nOldIdx];
                        ++rx;
                    }
                    ++ry;
                }
                int nNewY = this.m_nHeight - y - 1;
                this.consumer.setPixels(nNewY, x, height, width, model, m_Pixels, 0, height);
            }
        }
    }

    public void setPixels(int x, int y, int width, int height, ColorModel model, byte[] pixels, int offset, int scansize) {
        byte[] m_xPixels = new byte[this.m_nWidth * this.m_nHeight];
        switch (this.m_nAngle) {
            default: {
                this.consumer.setPixels(y, x, height, width, model, pixels, 0, height);
                break;
            }
            case 1: {
                int ry = 1;
                while (ry <= height) {
                    int rx = 1;
                    while (rx <= width) {
                        int nOldIdx = ry * scansize - rx + offset;
                        int nNewIdx = (rx - 1) * height - 1 + ry;
                        m_xPixels[nNewIdx] = pixels[nOldIdx];
                        ++rx;
                    }
                    ++ry;
                }
                this.consumer.setPixels(y, x, height, width, model, m_xPixels, 0, height);
                break;
            }
            case 2: {
                int ry = 1;
                while (ry <= height) {
                    int rx = 1;
                    while (rx <= width) {
                        int nOldIdx = ry * scansize - rx + offset;
                        int nNewIdx = scansize - rx;
                        m_xPixels[nNewIdx] = pixels[nOldIdx];
                        ++rx;
                    }
                    ++ry;
                }
                int nNewY = this.m_nHeight - y - 1;
                this.consumer.setPixels(nNewY, x, height, width, model, m_xPixels, 0, height);
            }
        }
    }
}

