/*
 * Decompiled with CFR 0.152.
 */
package tdg.draw;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.io.Serializable;
import tdg.Perspective;
import tdg.VC;
import tdg.draw.BlackBoxIF;
import tdg.draw.BorderObj;
import tdg.draw.ColorObj;
import tdg.draw.FillColorObj;
import tdg.draw.FillGradientObj;
import tdg.draw.FillObj;
import tdg.draw.FillTextureObj;
import tdg.draw.IdentObj;
import tdg.draw.TextStyleObj;

public class BlackBoxObj
implements Serializable,
BlackBoxIF {
    static final String CLASS_TEXTURE = "tdg.draw.FillTextureObj";
    static final String CLASS_GRADIENT = "tdg.draw.FillGradientObj";
    static final String CLASS_COLOR = "tdg.draw.FillColorObj";
    static final int SCALE_FACTOR = 50;
    private Perspective m_Perspective;
    private IdentObj m_id;
    private FillObj m_FillObj;
    private BorderObj m_BorderObj;
    private Color m_DropShadowColor;
    private Dimension m_DropShadowOffset;
    private boolean m_bTransparentBorderColor;
    private boolean m_bTransparentFillColor;
    Color m_ChartBackgroundColor;

    private BlackBoxObj() {
        this.m_BorderObj = new BorderObj(Color.black);
        this.m_FillObj = new FillColorObj(Color.white);
        this.m_DropShadowColor = Color.black;
        this.m_DropShadowOffset = null;
    }

    public BlackBoxObj(BlackBoxObj bb) {
        this();
        this.copy(bb);
    }

    public BlackBoxObj(Perspective p, IdentObj id) {
        this.m_Perspective = p;
        this.m_BorderObj = new BorderObj(p.getBorderColor(id));
        switch (p.getFillType(id)) {
            case 1: {
                this.m_FillObj = new FillColorObj(p.getFillColor(id));
                break;
            }
            case 2: {
                FillGradientObj fillGradient = new FillGradientObj(p, p.getGradientDirection(id));
                int nPins = p.getGradientNumPins(id);
                int i = 0;
                while (i < nPins) {
                    fillGradient.insertPin(p.getGradientPinPosition(id, i), new ColorObj(p.getGradientPinLeftColor(id, i)), new ColorObj(p.getGradientPinRightColor(id, i)));
                    ++i;
                }
                this.m_FillObj = fillGradient;
                break;
            }
            case 3: {
                String szURL = p.getTexture(id);
                Image img = p.getTexture(szURL);
                if (img != null) {
                    int nDisplayMode = p.getTextureDisplayMode(id);
                    int nFlipMode = p.getTextureFlipMode(id);
                    this.m_FillObj = new FillTextureObj(p, img, nDisplayMode, nFlipMode, 0);
                    break;
                }
                this.m_FillObj = new FillColorObj(p.getFillColor(id));
                p.setFillType(id, 1);
            }
        }
        this.m_bTransparentBorderColor = this.m_Perspective.getTransparentBorderColor(id);
        this.m_bTransparentFillColor = this.m_Perspective.getTransparentFillColor(id);
        this.m_ChartBackgroundColor = p.getFillColor(p.getChartBackground());
        this.m_DropShadowColor = p.getShadowColor(id);
        this.m_DropShadowOffset = p.getShadowDisplay(id) && !this.m_bTransparentFillColor ? new Dimension(p.getVC().virtToDestWidth(p.getShadowXOffset(id) * 50), p.getVC().virtToDestHeight(p.getShadowYOffset(id) * 50)) : null;
    }

    public void copy(BlackBoxObj bb) {
        String szOrgType = bb.m_FillObj.getClass().getName();
        if (szOrgType.equals(CLASS_GRADIENT)) {
            this.m_FillObj = new FillGradientObj();
        } else if (szOrgType.equals(CLASS_COLOR)) {
            this.m_FillObj = new FillColorObj();
        } else if (szOrgType.equals(CLASS_TEXTURE)) {
            this.m_FillObj = new FillTextureObj();
        }
        this.m_FillObj.copy(bb.m_FillObj);
        this.m_BorderObj.copy(bb.m_BorderObj);
        this.m_Perspective = bb.m_Perspective;
        this.m_DropShadowColor = bb.m_DropShadowColor;
        this.m_DropShadowOffset = bb.m_DropShadowOffset;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BlackBoxObj)) {
            return false;
        }
        BlackBoxObj bb2 = (BlackBoxObj)obj;
        boolean bEqual = this.m_FillObj.equals(bb2.m_FillObj);
        return bEqual;
    }

    public Color getBorderColor() {
        return this.m_BorderObj.getColor();
    }

    public Color getFillColor() {
        String sz = this.m_FillObj.getClass().getName();
        if (sz.equals(CLASS_COLOR)) {
            return ((FillColorObj)this.m_FillObj).getColor();
        }
        return Color.white;
    }

    public int getFillType() {
        String sz = this.m_FillObj.getClass().getName();
        if (sz.equals(CLASS_COLOR)) {
            return 1;
        }
        if (sz.equals(CLASS_GRADIENT)) {
            return 2;
        }
        return 3;
    }

    public boolean getTransparentBorderColor() {
        return this.m_bTransparentBorderColor;
    }

    public boolean getTransparentFillColor() {
        return this.m_bTransparentFillColor;
    }

    public void setTransparentFillColor(boolean bTransparent) {
        this.m_bTransparentFillColor = bTransparent;
    }

    public void setTransparentBorderColor(boolean bTransparent) {
        this.m_bTransparentBorderColor = bTransparent;
    }

    public void paint(Graphics g, Point a, Point b) {
        if (!this.m_bTransparentBorderColor) {
            this.m_BorderObj.paint(g, a, b);
        }
    }

    public void paint(Graphics g, Polygon p) {
        if (this.m_DropShadowOffset != null) {
            Polygon pDropShadow = new Polygon();
            int i = 0;
            while (i < p.npoints) {
                pDropShadow.addPoint(p.xpoints[i] + this.m_DropShadowOffset.width, p.ypoints[i] + this.m_DropShadowOffset.height);
                ++i;
            }
            g.setColor(this.m_DropShadowColor);
            g.fillPolygon(pDropShadow);
        }
        if (!this.m_bTransparentFillColor) {
            this.m_FillObj.fillPolygon(g, (Component)this.m_Perspective, p);
        }
        if (!this.m_bTransparentBorderColor) {
            this.m_BorderObj.paint(g, this.m_Perspective, p);
        }
    }

    public void paint(Graphics g, GeneralPath path) {
        if (!this.m_bTransparentFillColor) {
            this.m_FillObj.fillPolygon(g, (Component)this.m_Perspective, path);
        }
        if (!this.m_bTransparentBorderColor) {
            this.m_BorderObj.paint(g, this.m_Perspective, path);
        }
    }

    public void paint(Graphics g, Area area) {
        if (!this.m_bTransparentFillColor) {
            this.m_FillObj.fillPolygon(g, (Component)this.m_Perspective, area);
        }
        if (!this.m_bTransparentBorderColor) {
            this.m_BorderObj.paint(g, this.m_Perspective, area);
        }
    }

    public void paint(Graphics g, Rectangle r) {
        this.paint(g, r, false, false);
    }

    public void paint(Graphics g, Rectangle r, boolean bOval, boolean bNoFill) {
        this.paint(g, r, bOval, bNoFill, false);
    }

    public void paint(Graphics g, Rectangle r, boolean bOval, boolean bNoFill, boolean bDotted) {
        if (this.m_DropShadowOffset != null) {
            Rectangle rDropShadow = new Rectangle(r.x + this.m_DropShadowOffset.width, r.y + this.m_DropShadowOffset.height, r.width, r.height);
            g.setColor(this.m_DropShadowColor);
            if (bOval) {
                g.fillOval(rDropShadow.x, rDropShadow.y, rDropShadow.width, rDropShadow.height);
            } else {
                g.fillRect(rDropShadow.x, rDropShadow.y, rDropShadow.width, rDropShadow.height);
            }
        }
        if (bOval) {
            if (!this.m_bTransparentFillColor && !bNoFill) {
                this.m_FillObj.fillOval(g, this.m_Perspective, r);
            }
            if (!this.m_bTransparentBorderColor) {
                this.m_BorderObj.paintOval(g, r);
            }
        } else {
            if (!this.m_bTransparentFillColor && !bNoFill) {
                this.m_FillObj.fillRect(g, this.m_Perspective, r);
            }
            if (!this.m_bTransparentBorderColor) {
                Rectangle s = new Rectangle(r);
                if (bDotted) {
                    this.m_BorderObj.paint(g, s, bDotted);
                } else {
                    this.m_BorderObj.paint(g, s);
                }
            }
        }
    }

    public void paint(Graphics g, String szText, Rectangle rBounds, TextStyleObj textStyle, VC vc) {
        if (!this.m_bTransparentFillColor) {
            int nBackgroundFillType = this.m_Perspective.getFillType(this.m_Perspective.getChartBackground());
            boolean bPrintingInProgress = this.m_Perspective.getPrintingInProgress();
            this.m_FillObj.fillText(g, this.m_Perspective, szText, rBounds, this.m_DropShadowColor, this.m_DropShadowOffset, textStyle, vc, this.m_ChartBackgroundColor, nBackgroundFillType, bPrintingInProgress);
        }
    }

    public void paint(Graphics g, Point a, Point b, int nThick) {
        double dx = b.x - a.x;
        double dy = b.y - a.y;
        double fNinetyRadians = 1.57;
        double fAngle = Math.atan2(dy, dx);
        double fTwoSeventyRadians = 4.71;
        double x = (double)nThick * Math.cos(fAngle + fNinetyRadians);
        double y = (double)nThick * Math.sin(fAngle + fNinetyRadians);
        double y2 = (double)(nThick / 2) * Math.sin(fAngle + fTwoSeventyRadians);
        double x2 = (double)(nThick / 2) * Math.cos(fAngle + fTwoSeventyRadians);
        Polygon pg = new Polygon();
        pg.addPoint(b.x + (int)Math.round(x2), b.y + (int)Math.round(y2));
        pg.addPoint(b.x + (int)Math.round(x) + (int)Math.round(x2), b.y + (int)Math.round(y) + (int)Math.round(y2));
        pg.addPoint(a.x + (int)Math.round(x) + (int)Math.round(x2), a.y + (int)Math.round(y) + (int)Math.round(y2));
        pg.addPoint(a.x + (int)Math.round(x2), a.y + (int)Math.round(y2));
        pg.addPoint(b.x + (int)Math.round(x2), b.y + (int)Math.round(y2));
        g.drawPolygon(pg.xpoints, pg.ypoints, pg.npoints);
        if (!this.m_bTransparentFillColor) {
            this.m_FillObj.fillPolygon(g, (Component)this.m_Perspective, pg);
        }
        this.m_FillObj.fillOval(g, this.m_Perspective, a.x - nThick / 2, a.y - nThick / 2, nThick, nThick);
        this.m_FillObj.fillOval(g, this.m_Perspective, b.x - nThick / 2, b.y - nThick / 2, nThick, nThick);
        if (!this.m_bTransparentBorderColor) {
            this.m_BorderObj.paint(g, pg);
        }
    }

    public void paint(Graphics g, Point a, Point b, int nThick, int style, boolean isMarker) {
        if (g instanceof Graphics2D) {
            Stroke oldStroke = ((Graphics2D)g).getStroke();
            BasicStroke dashed = new BasicStroke(nThick, 0, 0);
            float dashLen = 10.0f;
            if (style != Perspective.SOLID) {
                if (style == Perspective.DASH) {
                    float[] dash1;
                    if (isMarker) {
                        dash1 = new float[]{4.0f, 2.0f, 4.0f};
                        dashLen = 2.0f;
                        nThick = 2;
                    } else {
                        dash1 = new float[]{dashLen, dashLen / 2.0f};
                    }
                    dashed = new BasicStroke(nThick, 0, 0, dashLen, dash1, 0.0f);
                } else if (style == Perspective.DOTTED) {
                    if (isMarker) {
                        nThick = 2;
                    }
                    float[] dash1 = new float[]{nThick};
                    dashed = new BasicStroke(nThick, 0, 0, 1.0f, dash1, 0.0f);
                } else if (style == Perspective.DASH_DOT) {
                    float[] dash1;
                    if (isMarker) {
                        dash1 = new float[]{3.0f, 1.0f, 2.0f, 1.0f, 3.0f};
                        nThick = 2;
                    } else {
                        dash1 = new float[]{dashLen, dashLen / 2.0f, nThick, dashLen / 2.0f};
                    }
                    dashed = new BasicStroke(nThick, 0, 0, 1.0f, dash1, 0.0f);
                }
            }
            ((Graphics2D)g).setStroke(dashed);
            g.setColor(this.getFillColor());
            g.drawLine(a.x, a.y, b.x, b.y);
            if (!this.m_bTransparentBorderColor) {
                this.m_BorderObj.paint(g, a, b);
            }
            ((Graphics2D)g).setStroke(oldStroke);
        } else {
            this.paint(g, a, b, nThick);
        }
    }

    public void releaseReferences() {
        this.m_Perspective = null;
    }

    public void setBorderColor(Color color) {
        this.m_BorderObj.setColor(color);
    }

    public void setFillColor(int r, int g, int b, int a) {
        String sz = this.m_FillObj.getClass().getName();
        if (!sz.equals(CLASS_COLOR)) {
            this.m_FillObj = new FillColorObj();
        }
        ((FillColorObj)this.m_FillObj).setColor(r, g, b, a);
    }

    public void setFillColor(Color color) {
        this.setFillColor(color.getRed(), color.getGreen(), color.getBlue(), 255);
    }

    public Color getGradientColorAt(double relValue) {
        String sz = this.m_FillObj.getClass().getName();
        if (sz.equals(CLASS_GRADIENT)) {
            return ((FillGradientObj)this.m_FillObj).getColorAt(relValue);
        }
        return new Color(0, 0, 0);
    }

    public void paint(Graphics g, Rectangle r, boolean bOval, boolean bNoFill, int nWidth) {
        if (bOval) {
            if (!this.m_bTransparentFillColor && !bNoFill) {
                this.m_FillObj.fillOval(g, this.m_Perspective, r);
            }
            if (!this.m_bTransparentBorderColor) {
                Rectangle rPrime = new Rectangle(r);
                if (nWidth == 0) {
                    this.m_BorderObj.paintOval(g, rPrime);
                } else {
                    int i = 0;
                    while (i < nWidth) {
                        rPrime.grow(1, 1);
                        this.m_BorderObj.paintOval(g, rPrime);
                        ++i;
                    }
                }
            }
        }
    }
}

