/*
 * Decompiled with CFR 0.152.
 */
package tdg;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;
import tdg.Perspective;
import tdg.VC;
import tdg.draw.BlackBoxObj;
import tdg.draw.DetLabel;
import tdg.draw.DetRect;
import tdg.draw.IdentObj;
import tdg.draw.TextStyleObj;

public class TitleObj
implements Serializable {
    private Perspective m_Perspective;
    private IdentObj m_id;
    private IdentObj m_idBox;
    private String m_szText;
    private Rectangle m_rBounds;
    private boolean m_truncated = false;
    private int m_stopAtLine;

    public TitleObj(Perspective perspective, IdentObj id) {
        this(perspective, id, null);
    }

    public TitleObj(Perspective perspective, IdentObj id, IdentObj idBox) {
        this.m_Perspective = perspective;
        this.m_id = id;
        this.m_idBox = idBox;
        this.m_szText = null;
        this.m_rBounds = null;
    }

    public void calc() {
        this.m_szText = this.m_Perspective.getTextString(this.m_id);
        this.m_rBounds = this.m_Perspective.getRect(this.m_id);
        boolean bTitleFontSizeAbsolute = this.m_Perspective.getFontSizeAbsolute(this.m_id);
        TextStyleObj textStyleObj = new TextStyleObj(this.m_Perspective.m_fontCache, this.m_Perspective.getFontName(this.m_id), this.m_Perspective.getFontStyle(this.m_id), bTitleFontSizeAbsolute, this.m_Perspective.getFontSize(this.m_id), this.m_Perspective.getFontSizeVC(this.m_id), this.m_Perspective.getTextRotation(this.m_id), this.m_Perspective.getTextJustHoriz(this.m_id), this.m_Perspective.getTextJustVert(this.m_id), this.m_Perspective.getAutofit(this.m_id), false, this.m_Perspective.getTextWrap(this.m_id));
        textStyleObj.setLegendTruncate(this.m_truncated, this.m_stopAtLine);
        BlackBoxObj bb = new BlackBoxObj(this.m_Perspective, this.m_id);
        if (this.m_idBox != null && this.m_Perspective.getDisplay(this.m_idBox)) {
            BlackBoxObj bbBox = new BlackBoxObj(this.m_Perspective, this.m_idBox);
            Graphics g = this.m_Perspective.getGraphicsContext();
            VC vc = this.m_Perspective.getVC();
            Rectangle rDest = vc.virtToDest(this.m_rBounds);
            Dimension dimDropShadow = new Dimension(0, 0);
            Rectangle rBox = vc.destToVirt(textStyleObj.getTextBox(g, this.m_szText, rDest, dimDropShadow, vc));
            new DetRect(this.m_Perspective.getDetectiv(), this.m_idBox, rBox.x, rBox.y, rBox.width, rBox.height, bbBox, null, false, true, true);
        }
        new DetLabel(this.m_Perspective.getDetectiv(), this.m_id, this.m_szText, this.m_rBounds, textStyleObj, bb, true);
    }

    public void releaseReferences() {
        this.m_Perspective = null;
    }

    public void setTruncated(boolean trunc, int stopAtLine) {
        this.m_truncated = trunc;
        this.m_stopAtLine = stopAtLine;
        this.m_Perspective.setTitleTruncated(trunc, this.m_id.getObjectID());
    }
}

