/*
 * Decompiled with CFR 0.152.
 */
package tdg;

import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import tdg.JGraphType;
import tdg.TDGMouseState;
import tdg.VC;
import tdg.draw.DetObj;
import tdg.draw.Detectiv;

public class TDGDeadZone {
    private Detectiv m_Detectiv;
    private VC m_VC;

    public TDGDeadZone(Detectiv detective, VC vc) {
        this.m_Detectiv = detective;
        this.m_VC = vc;
    }

    public TDGMouseState findDeadZoneMouseState(JGraphType graphType, MouseEvent mouseEvt, DetObj detObjCurrent, double fPercentDeadZone) {
        TDGMouseState mouseStateDeadZone = null;
        if (graphType.isRadarType() || graphType.isPolar()) {
            mouseStateDeadZone = new TDGMouseState(mouseEvt, detObjCurrent);
            mouseStateDeadZone.setDeadZoneMouseLocation(0);
        } else {
            mouseStateDeadZone = graphType.isOrientHorz() ? this.processVertDeadZone(mouseEvt, detObjCurrent, fPercentDeadZone) : this.processHorizDeadZone(mouseEvt, detObjCurrent, fPercentDeadZone);
        }
        return mouseStateDeadZone;
    }

    private TDGMouseState processHorizDeadZone(MouseEvent mouseEvt, DetObj detObjCurrent, double fPercentDeadZone) {
        TDGMouseState mouseStateDeadZone = new TDGMouseState(mouseEvt, detObjCurrent);
        mouseStateDeadZone.setDeadZoneMouseLocation(0);
        int nCurrentSeries = detObjCurrent.getSeriesID();
        int nCurrentGroup = detObjCurrent.getGroupID();
        double fDestMouseX = mouseEvt.getX();
        Rectangle rectVirtCurrent = detObjCurrent.getBounds();
        Rectangle rectDestCurrent = this.m_VC.virtToDest(rectVirtCurrent);
        double fMiddleDeadZone = rectDestCurrent.x + rectDestCurrent.width / 2;
        double fHalfOfDeadZone = (double)rectDestCurrent.width * fPercentDeadZone / 100.0 / 2.0;
        double fDeadZoneBeginX = fMiddleDeadZone - fHalfOfDeadZone;
        double fDeadZoneEndX = fMiddleDeadZone + fHalfOfDeadZone;
        if (fDestMouseX > fDeadZoneBeginX && fDestMouseX < fDeadZoneEndX) {
            mouseStateDeadZone.setDeadZoneMouseLocation(2);
        } else {
            if (fDestMouseX >= (double)rectDestCurrent.x && fDestMouseX <= fDeadZoneBeginX) {
                mouseStateDeadZone.setDeadZoneMouseLocation(1);
            }
            if (fDestMouseX >= fDeadZoneEndX && fDestMouseX <= (double)(rectDestCurrent.x + rectDestCurrent.width)) {
                mouseStateDeadZone.setDeadZoneMouseLocation(3);
            }
        }
        return mouseStateDeadZone;
    }

    private TDGMouseState processVertDeadZone(MouseEvent mouseEvt, DetObj detObjCurrent, double fPercentDeadZone) {
        TDGMouseState mouseStateDeadZone = new TDGMouseState(mouseEvt, detObjCurrent);
        mouseStateDeadZone.setDeadZoneMouseLocation(0);
        int nCurrentSeries = detObjCurrent.getSeriesID();
        int nCurrentGroup = detObjCurrent.getGroupID();
        double fDestMouseY = mouseEvt.getY();
        Rectangle rectVirtCurrent = detObjCurrent.getBounds();
        Rectangle rectDestCurrent = this.m_VC.virtToDest(rectVirtCurrent);
        double fMiddleDeadZone = rectDestCurrent.y + rectDestCurrent.height / 2;
        double fHalfOfDeadZone = (double)rectDestCurrent.height * fPercentDeadZone / 100.0 / 2.0;
        double fDeadZoneBeginY = fMiddleDeadZone - fHalfOfDeadZone;
        double fDeadZoneEndY = fMiddleDeadZone + fHalfOfDeadZone;
        if (fDestMouseY > fDeadZoneBeginY && fDestMouseY < fDeadZoneEndY) {
            mouseStateDeadZone.setDeadZoneMouseLocation(2);
        } else {
            if (fDestMouseY >= (double)(rectDestCurrent.y - rectDestCurrent.height) && fDestMouseY <= fDeadZoneBeginY) {
                mouseStateDeadZone.setDeadZoneMouseLocation(1);
            }
            if (fDestMouseY >= fDeadZoneEndY && fDestMouseY <= (double)(rectDestCurrent.y + rectDestCurrent.height)) {
                mouseStateDeadZone.setDeadZoneMouseLocation(3);
            }
        }
        return mouseStateDeadZone;
    }
}

