/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.server.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import oracle.jbo.server.util.ShowPathAction;

public class ShowPath {
    private static final boolean DEBUG_MODE = false;
    private static String s_pathString = null;
    private static String s_removePath = null;
    private static String s_envVar = null;
    private static String[] s_pathElements = null;
    private static boolean[] s_isOnFilesystem = null;
    private static boolean[] s_isDuplicate = null;
    private static boolean s_pathIsOk = true;
    private static ShowPathAction s_Action = null;
    private static final String DUPLICATE_BAD_PREFIX = "->";
    private static final String DUPLICATE_GOOD_PREFIX = "  ";
    private static final String NOTEXISTS_BAD_PREFIX = "*";
    private static final String NOTEXISTS_GOOD_PREFIX = " ";
    private static final String PATH_ELEMENT_SEPARATOR = ";";

    public static void main(String[] stringArray) {
        boolean bl = true;
        ShowPath.ParseArgs(stringArray);
        if (ShowPath.s_Action.ord == ShowPathAction.USAGE.ord) {
            ShowPath.Usage();
            bl = false;
        } else if (ShowPath.ProcessString()) {
            if (ShowPath.s_Action.ord == ShowPathAction.SHOW.ord) {
                ShowPath.DumpPath();
            } else if (ShowPath.s_Action.ord == ShowPathAction.CHECK.ord) {
                bl = ShowPath.CheckPath();
            } else if (ShowPath.s_Action.ord == ShowPathAction.REMOVE.ord && !ShowPath.RemovePath()) {
                ShowPath.Usage();
                bl = false;
            }
        } else {
            ShowPath.Usage();
            bl = false;
        }
        if (bl) {
            System.exit(0);
        } else {
            System.exit(1);
        }
    }

    private static void ParseArgs(String[] stringArray) {
        switch (stringArray.length) {
            case 0: {
                s_Action = ShowPathAction.USAGE;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                if (stringArray[0].equalsIgnoreCase("-show")) {
                    s_Action = ShowPathAction.SHOW;
                }
                if (stringArray[0].equalsIgnoreCase("-check")) {
                    s_Action = ShowPathAction.CHECK;
                }
                if (stringArray[0].equalsIgnoreCase("-remove")) {
                    s_Action = ShowPathAction.REMOVE;
                    if (stringArray.length >= 3) {
                        s_removePath = stringArray[2];
                    }
                    if (stringArray.length >= 4) {
                        s_envVar = stringArray[3];
                    }
                }
                if (stringArray.length >= 2) {
                    s_pathString = stringArray[1].equalsIgnoreCase("-f") ? ShowPath.loadFromFile(stringArray[2]) : stringArray[1];
                }
                if (s_Action != null) break;
                System.out.println("Error: unknown switch '" + stringArray[0] + "'");
                s_Action = ShowPathAction.USAGE;
                break;
            }
            default: {
                System.out.println("Too many arguments - did you forget to quote the args?");
                s_Action = ShowPathAction.USAGE;
            }
        }
    }

    public static void DumpPath() {
        if (s_pathIsOk) {
            int n = 0;
            while (n < s_pathElements.length) {
                System.out.println(s_pathElements[n]);
                ++n;
            }
        } else {
            ShowPath.HLine();
            String string = NOTEXISTS_GOOD_PREFIX;
            String string2 = DUPLICATE_GOOD_PREFIX;
            int n = 0;
            while (n < s_pathElements.length) {
                if (!s_isOnFilesystem[n]) {
                    string = NOTEXISTS_BAD_PREFIX;
                }
                if (s_isDuplicate[n]) {
                    string2 = DUPLICATE_BAD_PREFIX;
                }
                System.out.println(string + string2 + NOTEXISTS_GOOD_PREFIX + s_pathElements[n]);
                string = NOTEXISTS_GOOD_PREFIX;
                string2 = DUPLICATE_GOOD_PREFIX;
                ++n;
            }
            ShowPath.HLine();
        }
    }

    public static boolean CheckPath() {
        if (s_pathIsOk) {
            System.out.println("No problems found with path");
        } else {
            System.out.println("Warning: the path had errors - use ShowPath -show for details.");
        }
        return s_pathIsOk;
    }

    public static boolean RemovePath() {
        if (s_removePath == null || s_removePath.trim().length() == 0) {
            System.out.println("Error: invalid remove path string: cannot be empty");
            return false;
        }
        String string = "";
        int n = 0;
        while (n < s_pathElements.length) {
            if (s_pathElements[n].indexOf(s_removePath) < 0) {
                if (string.length() > 0) {
                    string = string + PATH_ELEMENT_SEPARATOR;
                }
                string = string + s_pathElements[n];
            }
            ++n;
        }
        if (s_envVar != null) {
            System.out.print("SET " + s_envVar + "=");
        }
        System.out.println(string);
        return true;
    }

    private static boolean ProcessString() {
        if (s_pathString == null || s_pathString.trim().length() == 0) {
            System.out.println("Error: invalid path string: cannot be empty");
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(s_pathString, PATH_ELEMENT_SEPARATOR);
        int n = stringTokenizer.countTokens();
        s_pathElements = new String[n];
        s_isOnFilesystem = new boolean[n];
        s_isDuplicate = new boolean[n];
        Integer n2 = null;
        Hashtable hashtable = new Hashtable();
        int n3 = 0;
        while (n3 < n) {
            ShowPath.s_pathElements[n3] = stringTokenizer.nextToken();
            n2 = null;
            int n4 = 0;
            while (n4 < n3) {
                if (s_pathElements[n4].equalsIgnoreCase(s_pathElements[n3])) {
                    n2 = new Integer(n4);
                    break;
                }
                ++n4;
            }
            if (n2 != null) {
                ShowPath.s_isDuplicate[n3] = true;
                ShowPath.s_isDuplicate[((Integer)n2).intValue()] = true;
                s_pathIsOk = false;
            } else {
                ShowPath.s_isDuplicate[n3] = false;
            }
            File file = new File(s_pathElements[n3]);
            ShowPath.s_isOnFilesystem[n3] = file.exists();
            if (!s_isOnFilesystem[n3]) {
                s_pathIsOk = false;
            }
            ++n3;
        }
        return true;
    }

    private static String loadFromFile(String string) {
        StringBuffer stringBuffer = new StringBuffer(100);
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while (bufferedReader.ready()) {
                stringBuffer.append(bufferedReader.readLine());
                stringBuffer.append(PATH_ELEMENT_SEPARATOR);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            System.out.println("IO Exception caught: File=" + string);
        }
        return stringBuffer.toString();
    }

    public static void Usage() {
        ShowPath.HLine();
        System.out.println("Usage:  ShowPath [-show|-check|-remove] {dirlist|-f listfile} [path-to-remove]");
        System.out.println("");
        System.out.println("        Lists a semicolon separated list of directories and files");
        System.out.println("        and checks that they are all valid, with no duplicates.");
        System.out.println("        The -show form lists them all out, the -check form just");
        System.out.println("        does the check and returns a bad exit code on failure.");
        System.out.println("");
        System.out.println("Options:");
        System.out.println("        -show       - list all the entries one per line");
        System.out.println("        -check      - just check for duplicates and validity");
        System.out.println("        -remove     - removes paths that match the path-to-remove");
        System.out.println("        -f listfile - listfile contains the pathlike entries");
        System.out.println("        path-to-remove - required only for the -remove option");
        System.out.println("");
        System.out.println("        Nonexistent entries are marked with a \"*\"");
        System.out.println("        Duplicate entries are marked with a \"->\"");
        System.out.println("Note: ");
        System.out.println("        You should quote the argument if it has embedded spaces.");
        System.out.println("Eg:");
        System.out.println("        Showpath -show \"%PATH%\"   - lists the PATH environment variable");
        System.out.println("        Showpath -check %CLASSPATH% - check the sanity of your CLASSPATH");
        System.out.println("        Showpath -show -f %TEMP%\\path.lis - list contents of path.lis");
        ShowPath.HLine();
    }

    private static void HLine() {
        System.out.println("-------------------------------------------------------------------------------");
    }
}

