/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.server.remote;

import com.sun.java.util.collections.ArrayList;
import java.io.Serializable;
import java.util.List;
import oracle.jbo.JboException;
import oracle.jbo.RowSetIterator;
import oracle.jbo.common.JboServiceMessage;
import oracle.jbo.common.PiggybackOutput;
import oracle.jbo.common.SvcMsgResponseValues;
import oracle.jbo.server.ComponentObjectImpl;
import oracle.jbo.server.ViewObjectImpl;
import oracle.jbo.server.ViewRowSetIteratorImpl;
import oracle.jbo.server.remote.AbstractRemoteApplicationModuleImpl;
import oracle.jbo.server.remote.ObjectMarshallerImpl;
import oracle.jbo.server.remote.RuntimeComponentObjectInfo;
import oracle.jbo.server.remote.RuntimeViewRowSetIteratorInfo;
import oracle.svcmsg.ServiceMessage;

public class PiggybackManager {
    private ObjectMarshallerImpl mMarshaller;
    private ArrayList rvInfos;
    private ArrayList rcInfos;
    private JboServiceMessage mServiceMessage;
    private boolean mIsLocal;
    private String mRequestName;
    private Object mRefreshDMMarker;
    private ArrayList mDataModelRefreshEntries;
    private boolean mIsDataModelRefresh;

    private /* synthetic */ void $init$() {
        this.mIsLocal = false;
        this.mRefreshDMMarker = null;
        this.mDataModelRefreshEntries = null;
        this.mIsDataModelRefresh = false;
    }

    public PiggybackManager(ObjectMarshallerImpl objectMarshallerImpl) {
        this.$init$();
        this.mMarshaller = objectMarshallerImpl;
        this.rvInfos = new ArrayList();
        this.rcInfos = new ArrayList();
        this.mServiceMessage = new JboServiceMessage();
    }

    public void setLocal(boolean bl) {
        this.mIsLocal = bl;
    }

    public boolean isLocal() {
        return this.mIsLocal;
    }

    public void setDataModelRefresh(boolean bl) {
        this.mIsDataModelRefresh = bl;
    }

    public void setSvcMsgName(String string) {
        this.mServiceMessage.setName(string);
    }

    public void setRequestName(String string) {
        this.mRequestName = string;
    }

    public String getRequestName() {
        return this.mRequestName;
    }

    public ObjectMarshallerImpl getMarshaller() {
        return this.mMarshaller;
    }

    public ArrayList getIterators() {
        return this.rvInfos;
    }

    public RuntimeViewRowSetIteratorInfo addRowSetIterator(RowSetIterator rowSetIterator) {
        RuntimeViewRowSetIteratorInfo runtimeViewRowSetIteratorInfo;
        int n = this.indexOfRowSetIterator(rowSetIterator);
        if (n == -1) {
            runtimeViewRowSetIteratorInfo = this.mMarshaller.createRowSetListener(this, rowSetIterator);
            this.rvInfos.add((Object)runtimeViewRowSetIteratorInfo);
        } else {
            runtimeViewRowSetIteratorInfo = (RuntimeViewRowSetIteratorInfo)this.rvInfos.get(n);
        }
        return runtimeViewRowSetIteratorInfo;
    }

    void removeRowSetIterator(RowSetIterator rowSetIterator) {
        int n = this.indexOfRowSetIterator(rowSetIterator);
        if (n >= 0) {
            this.rvInfos.remove(n);
        }
    }

    public RuntimeComponentObjectInfo addComponentObject(ComponentObjectImpl componentObjectImpl) {
        RuntimeComponentObjectInfo runtimeComponentObjectInfo;
        int n = this.indexOfComponentObject(componentObjectImpl);
        if (n == -1) {
            runtimeComponentObjectInfo = new RuntimeComponentObjectInfo(this, componentObjectImpl);
            this.rcInfos.add((Object)runtimeComponentObjectInfo);
        } else {
            runtimeComponentObjectInfo = (RuntimeComponentObjectInfo)this.rcInfos.get(n);
        }
        return runtimeComponentObjectInfo;
    }

    public int indexOfRowSetIterator(RowSetIterator rowSetIterator) {
        int n = 0;
        while (n < this.rvInfos.size()) {
            ViewRowSetIteratorImpl viewRowSetIteratorImpl = ViewObjectImpl.getImplObject(rowSetIterator);
            if (viewRowSetIteratorImpl != null && viewRowSetIteratorImpl.equals(((RuntimeViewRowSetIteratorInfo)this.rvInfos.get(n)).getRowSetIterator())) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int indexOfComponentObject(ComponentObjectImpl componentObjectImpl) {
        int n = 0;
        while (n < this.rcInfos.size()) {
            if (componentObjectImpl.equals(((RuntimeComponentObjectInfo)this.rcInfos.get(n)).getObject())) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public ServiceMessage getServiceMessage() {
        return this.mServiceMessage;
    }

    void setServiceMessage(JboServiceMessage jboServiceMessage) {
        this.mServiceMessage = jboServiceMessage;
    }

    protected void addMarshalledObjects() {
        ArrayList arrayList = this.mMarshaller.getMarshalledInThisMsgLst();
        ServiceMessage serviceMessage = this.getServiceMessage();
        int n = 0;
        while (n < arrayList.size()) {
            Serializable serializable = (Serializable)arrayList.get(n);
            if (serviceMessage instanceof JboServiceMessage) {
                ((JboServiceMessage)serviceMessage).addRef(serializable);
            } else {
                serviceMessage.insertResponse(n, serializable);
            }
            ++n;
        }
        this.getMarshaller().clearMarshalledInThisMsg();
    }

    protected void mergeDataModelRefreshEntries() {
        if (this.mRefreshDMMarker == null) {
            return;
        }
        if (this.mDataModelRefreshEntries != null) {
            ServiceMessage serviceMessage = this.getServiceMessage();
            int n = serviceMessage.getResponses().indexOf(this.mRefreshDMMarker);
            int n2 = this.mDataModelRefreshEntries.size() - 1;
            while (n2 >= 0) {
                serviceMessage.insertResponse(n, (Serializable)this.mDataModelRefreshEntries.get(n2));
                --n2;
            }
        }
        this.mDataModelRefreshEntries = null;
        this.mRefreshDMMarker = null;
    }

    public void clearServiceMessage() {
        this.getServiceMessage().clear();
    }

    public void prepareForServiceMessage(AbstractRemoteApplicationModuleImpl abstractRemoteApplicationModuleImpl, ServiceMessage serviceMessage) {
        this.getMarshaller().prepareForServiceMessage(abstractRemoteApplicationModuleImpl, serviceMessage);
    }

    public void cleanUpServiceMessage(JboException jboException) {
        this.finishServiceMessage(true);
        if (this.getMarshaller().isInWorkingSet()) {
            this.clearServiceMessage();
        }
    }

    void finishServiceMessage(boolean bl) {
        if (!bl) {
            this.addMarshalledObjects();
            this.mergeDataModelRefreshEntries();
        } else {
            this.getMarshaller().clearMarshalledInThisMsg();
            this.mDataModelRefreshEntries = null;
            this.mRefreshDMMarker = null;
        }
        this.mMarshaller.finishedPiggybacking();
    }

    public ServiceMessage marshalServiceMessage(AbstractRemoteApplicationModuleImpl abstractRemoteApplicationModuleImpl) {
        JboServiceMessage jboServiceMessage = (JboServiceMessage)this.getServiceMessage();
        this.marshalServiceMessage(jboServiceMessage, abstractRemoteApplicationModuleImpl);
        ServiceMessage serviceMessage = jboServiceMessage.copyTo(new JboServiceMessage());
        jboServiceMessage.clearAll();
        return serviceMessage;
    }

    void marshalServiceMessage(JboServiceMessage jboServiceMessage, AbstractRemoteApplicationModuleImpl abstractRemoteApplicationModuleImpl) {
        boolean bl;
        this.mergeDataModelRefreshEntries();
        boolean bl2 = bl = !this.mIsLocal || jboServiceMessage.isForceMarshal();
        if (bl) {
            jboServiceMessage.marshal(abstractRemoteApplicationModuleImpl.getAdaptee().getSession().getLocale(), abstractRemoteApplicationModuleImpl.getAdaptee(), this.getMarshaller());
        }
        this.addMarshalledObjects();
        if (bl) {
            jboServiceMessage.marshalRefs(abstractRemoteApplicationModuleImpl.getAdaptee().getSession().getLocale(), abstractRemoteApplicationModuleImpl.getAdaptee(), this.getMarshaller());
        }
        this.mMarshaller.finishedPiggybacking();
    }

    public void addDataModelRefreshEntry(Serializable serializable) {
        if (this.mDataModelRefreshEntries == null) {
            this.mDataModelRefreshEntries = new ArrayList(10);
        }
        this.mDataModelRefreshEntries.add((Object)serializable);
    }

    public void addEntry(Serializable serializable) {
        SvcMsgResponseValues svcMsgResponseValues;
        int n;
        if (serializable instanceof SvcMsgResponseValues && (n = (svcMsgResponseValues = (SvcMsgResponseValues)serializable).getOperation()) == 4199 && this.mRefreshDMMarker == null) {
            this.mRefreshDMMarker = serializable;
        }
        if (this.mIsDataModelRefresh) {
            this.addDataModelRefreshEntry(serializable);
        } else {
            this.getServiceMessage().addResponse(serializable);
        }
    }

    public void insertEntry(int n, Serializable serializable) {
        this.getServiceMessage().insertResponse(n, serializable);
    }

    public byte[] getPiggyback(boolean bl, AbstractRemoteApplicationModuleImpl abstractRemoteApplicationModuleImpl) {
        ServiceMessage serviceMessage = this.getServiceMessage();
        List list = serviceMessage.getResponses();
        this.mergeDataModelRefreshEntries();
        if (!bl || list.size() == 0) {
            this.mMarshaller.finishedPiggybacking();
            return new byte[]{0};
        }
        PiggybackOutput piggybackOutput = new PiggybackOutput(list, abstractRemoteApplicationModuleImpl.getAdaptee().getSession().getLocale(), abstractRemoteApplicationModuleImpl.getAdaptee());
        byte[] byArray = piggybackOutput.getPiggybackStream();
        this.mMarshaller.finishedPiggybacking();
        this.getServiceMessage().clear();
        return byArray;
    }

    public RuntimeViewRowSetIteratorInfo getIteratorInfo(RowSetIterator rowSetIterator) {
        int n = this.indexOfRowSetIterator(rowSetIterator);
        if (n >= 0) {
            return (RuntimeViewRowSetIteratorInfo)this.rvInfos.get(n);
        }
        return null;
    }
}

