/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.server;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.HashMap;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import oracle.jbo.ApplicationModule;
import oracle.jbo.AttrSetValException;
import oracle.jbo.AttrValException;
import oracle.jbo.AttributeDef;
import oracle.jbo.AttributeList;
import oracle.jbo.AttributeReadXMLException;
import oracle.jbo.DeadViewRowAccessException;
import oracle.jbo.JboException;
import oracle.jbo.Key;
import oracle.jbo.ReadOnlyAttrException;
import oracle.jbo.ReadOnlyViewObjectException;
import oracle.jbo.ReadXMLException;
import oracle.jbo.Row;
import oracle.jbo.RowCreateException;
import oracle.jbo.RowNotFoundException;
import oracle.jbo.RowReadXMLException;
import oracle.jbo.RowSet;
import oracle.jbo.RowValException;
import oracle.jbo.StructureDef;
import oracle.jbo.ValidationException;
import oracle.jbo.ViewObject;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.JboEnvUtil;
import oracle.jbo.common.XmlInterfaceCriteria;
import oracle.jbo.common.xml.Criteria;
import oracle.jbo.common.xml.XmlOutput;
import oracle.jbo.common.xml.XmlSerializable;
import oracle.jbo.domain.DataCreationException;
import oracle.jbo.domain.DomainAttributeDef;
import oracle.jbo.domain.DomainInterface;
import oracle.jbo.domain.MutableDomainInterface;
import oracle.jbo.server.AttributeDefImpl;
import oracle.jbo.server.DBTransactionImpl;
import oracle.jbo.server.Entity;
import oracle.jbo.server.EntityDefImpl;
import oracle.jbo.server.EntityImpl;
import oracle.jbo.server.EntityReference;
import oracle.jbo.server.JboMessageObject;
import oracle.jbo.server.MapInfo;
import oracle.jbo.server.MetaObjectManager;
import oracle.jbo.server.QueryCollection;
import oracle.jbo.server.RowImpl;
import oracle.jbo.server.RowSetImpl;
import oracle.jbo.server.ViewAttributeDefImpl;
import oracle.jbo.server.ViewDefImpl;
import oracle.jbo.server.ViewObjectImpl;
import oracle.jbo.server.ViewRowSetImpl;
import oracle.jbo.server.ViewRowStorage;
import oracle.jbo.server.XmlDocumentReader;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeIterator;

public class ViewRowImpl
extends RowImpl
implements XmlSerializable,
Row {
    private ViewRowStorage mInner;
    private QueryCollection mQC;
    long mPersistentId;
    static final byte STATUS_NEW = 0;
    static final byte STATUS_UNMODIFIED = 1;
    static final byte STATUS_MODIFIED = 2;
    static final byte STATUS_DELETED = 3;
    static final byte STATUS_DEAD = 4;
    static final byte CURRENT_VERSION = 0;
    static final byte ORIGINAL_VERSION = 1;
    public static final String XML_POSTSTATE_TAG = "bc4j-action";
    public static final String XML_POSTSTATE_REMOVE = "remove";
    static final int REMOVE_FROM_TABLE = 0;
    static final int REMOVE_FROM_COLLECTION = 1;
    static final int REMOVE_AND_RETAIN = 2;
    static final int REMOVE_UNQUALIFIED = 3;
    private static /* synthetic */ Class class$oracle$jbo$CSMessageBundle;

    private /* synthetic */ void $init$() {
        this.mQC = null;
        this.mPersistentId = 0L;
    }

    public ViewRowImpl() {
        this.$init$();
    }

    long getPersistentId() {
        if (this.mPersistentId != 0L) {
            return this.mPersistentId;
        }
        try {
            this.useInner();
            this.mPersistentId = this.mInner.getPersistentId();
            Object var2_1 = null;
            this.releaseInner();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.releaseInner();
            throw throwable;
        }
        return this.mPersistentId;
    }

    void setPersistentId(long l) {
        this.mPersistentId = l;
    }

    void usePersistentId(long l) {
        this.mPersistentId = l;
        try {
            this.useInner();
            this.mInner.usePersistentId(l);
            Object var4_2 = null;
            this.releaseInner();
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.releaseInner();
            throw throwable;
        }
    }

    void setInner(ViewRowStorage viewRowStorage) {
        this.mInner = viewRowStorage;
    }

    final void useInner() {
        if (this.mQC == null) {
            throw new DeadViewRowAccessException(new Integer((int)this.mPersistentId));
        }
        if (this.mInner == null) {
            if (this.mPersistentId == 0L) {
                this.mInner = new ViewRowStorage(this);
            } else {
                this.mInner = this.mQC.getRowStorageFromId(this.mPersistentId);
                if (this.mInner == null) {
                    throw new DeadViewRowAccessException(new Integer((int)this.mPersistentId));
                }
            }
            if (this.mInner.getPostState() == 3) {
                throw new DeadViewRowAccessException(new Integer((int)this.mPersistentId));
            }
            this.mInner.addUse();
            if (this.mInner.getRowImpl() != this) {
                this.mInner.setRowImpl(this);
            }
        } else {
            this.mInner.addUse();
        }
    }

    final void releaseInner() {
        if (this.mQC != null && this.mInner != null) {
            this.mInner.releaseUse();
        }
    }

    final ViewRowImpl init(int[] nArray, EntityImpl[] entityImplArray, ViewDefImpl viewDefImpl, QueryCollection queryCollection, ResultSet resultSet, AttributeList attributeList, boolean bl) {
        try {
            this.initQueryCollection(queryCollection);
            this.useInner();
            this.mInner.init(viewDefImpl, queryCollection, bl);
            if (this.mInner.mRows == null) {
                if ((entityImplArray = this.createMissingEntities(nArray, entityImplArray, resultSet, attributeList, bl)) == null && this.mInner.getViewDef().getEntityReferences() != null) {
                    ViewRowImpl viewRowImpl = null;
                    Object var10_9 = null;
                    this.releaseInner();
                    return viewRowImpl;
                }
                this.setEntities(entityImplArray);
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            this.releaseInner();
            throw throwable;
        }
        Object var10_10 = null;
        this.releaseInner();
        return this;
    }

    protected void initDefaults() {
        try {
            this.useInner();
            this.mInner.initDefaults();
            Object var2_1 = null;
            this.releaseInner();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.releaseInner();
            throw throwable;
        }
    }

    ViewRowStorage getRowStorage() {
        try {
            this.useInner();
            Object var2_1 = null;
            this.releaseInner();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.releaseInner();
            throw throwable;
        }
        return this.mInner;
    }

    protected void create(AttributeList attributeList) {
        try {
            this.useInner();
            this.mInner.create(attributeList);
            Object var3_2 = null;
            this.releaseInner();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseInner();
            throw throwable;
        }
    }

    void callCreate(AttributeList attributeList) {
        ViewObjectImpl viewObjectImpl = (ViewObjectImpl)this.getViewObject();
        try {
            viewObjectImpl.mCreatingEntities = true;
            this.create(attributeList);
            Object var4_3 = null;
            viewObjectImpl.mCreatingEntities = false;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            viewObjectImpl.mCreatingEntities = false;
            throw throwable;
        }
    }

    QueryCollection getQueryCollection() {
        return this.mQC;
    }

    public QueryCollection getQueryCollection(Object object) {
        return this.getQueryCollection();
    }

    public ViewRowSetImpl findRowSetForRow(Object object) {
        QueryCollection queryCollection = this.getQueryCollection(object);
        if (queryCollection != null) {
            return queryCollection.getRowSetImpl();
        }
        return null;
    }

    void initQueryCollection(QueryCollection queryCollection) {
        this.mQC = queryCollection;
    }

    void setQueryCollection(QueryCollection queryCollection) {
        try {
            this.useInner();
            this.mInner.setQueryCollection(queryCollection);
            this.initQueryCollection(queryCollection);
            Object var3_2 = null;
            this.releaseInner();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseInner();
            throw throwable;
        }
    }

    public Object getHandle() {
        Integer n = null;
        n = new Integer((int)this.getPersistentId());
        return n;
    }

    public Key getKey() {
        try {
            this.useInner();
            Key key = null;
            AttributeDef[] attributeDefArray = this.mInner.mVO.getKeyAttributeDefs();
            Object[] objectArray = new Object[attributeDefArray.length];
            int n = 0;
            while (n < attributeDefArray.length) {
                objectArray[n] = this.getAttributeInternal(attributeDefArray[n].getIndex());
                ++n;
            }
            Key key2 = key = new Key(objectArray, this.mInner.mVO.getSignature(), this.getHandle());
            Object var7_6 = null;
            this.releaseInner();
            return key2;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.releaseInner();
            throw throwable;
        }
    }

    public void validate() {
        try {
            this.useInner();
            int n = this.getEntityCount();
            ArrayList arrayList = null;
            if (n == 0) {
                Object var10_3 = null;
                this.releaseInner();
                return;
            }
            boolean bl = this.getDBTransactionImpl().isBundledExceptionMode();
            int n2 = 0;
            while (n2 < n) {
                try {
                    EntityImpl entityImpl = this.getEntity(n2);
                    if (entityImpl != null && entityImpl.isInvalid()) {
                        entityImpl.validate();
                        if (entityImpl.isValid()) {
                            entityImpl.removeFromValidationManager();
                        }
                    }
                }
                catch (JboException jboException) {
                    if (bl) {
                        if (arrayList == null) {
                            arrayList = new ArrayList(5);
                        }
                        arrayList.add((Object)jboException);
                    }
                    throw jboException;
                }
                catch (Exception exception) {
                    if (arrayList == null) {
                        arrayList = new ArrayList(5);
                    }
                    arrayList.add((Object)exception);
                }
                ++n2;
            }
            if (arrayList != null) {
                if (bl) {
                    if (arrayList.size() == 1 && arrayList.get(0) instanceof RowValException) {
                        throw (RowValException)arrayList.get(0);
                    }
                    Class clazz = class$oracle$jbo$CSMessageBundle;
                    if (clazz == null) {
                        clazz = class$oracle$jbo$CSMessageBundle = ViewRowImpl.class$("oracle.jbo.CSMessageBundle");
                    }
                    RowValException rowValException = new RowValException(clazz, "27024", this.getViewObject().getFullName(), this.getKey(), null, true);
                    rowValException.setNeedsEntityToVOMapping(false);
                    rowValException.setDetails(arrayList.toArray());
                    throw rowValException;
                }
                Class clazz = class$oracle$jbo$CSMessageBundle;
                if (clazz == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = ViewRowImpl.class$("oracle.jbo.CSMessageBundle");
                }
                ValidationException.raise(clazz, "27007", new Object[]{this.getViewObject().getName()}, arrayList, false, false);
            }
            this.mDeferredExceptions = null;
        }
        catch (Throwable throwable) {
            Object var10_5 = null;
            this.releaseInner();
            throw throwable;
        }
        Object var10_4 = null;
        this.releaseInner();
    }

    protected Object getAttributeInternal(int n) {
        Object object = null;
        try {
            this.useInner();
            object = this.mInner.getAttributeInternal(n);
            Object var4_3 = null;
            this.releaseInner();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.releaseInner();
            throw throwable;
        }
        return object;
    }

    public Object getAttribute(int n) {
        try {
            Object object;
            this.useInner();
            ViewAttributeDefImpl viewAttributeDefImpl = this.mInner.getViewAttributeDef(n);
            try {
                object = this.getAttrInvokeAccessor(n, viewAttributeDefImpl);
                Object var9_4 = null;
            }
            catch (JboException jboException) {
                throw jboException;
            }
            catch (Exception exception) {
                Throwable throwable = exception;
                if (exception instanceof InvocationTargetException && (throwable = ((InvocationTargetException)exception).getTargetException()) instanceof JboException) {
                    throw (JboException)throwable;
                }
                Class clazz = class$oracle$jbo$CSMessageBundle;
                if (clazz == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = ViewRowImpl.class$("oracle.jbo.CSMessageBundle");
                }
                AttrValException attrValException = new AttrValException(111, clazz, "27019", this.getViewObject().getName(), viewAttributeDefImpl.getName());
                attrValException.setRowKey(111, this.getKey());
                attrValException.setNeedsEntityToVOMapping(false);
                attrValException.addToDetails(throwable);
                throw attrValException;
            }
            this.releaseInner();
            return object;
        }
        catch (Throwable throwable) {
            Object var9_5 = null;
            this.releaseInner();
            throw throwable;
        }
    }

    protected Object getAttrInvokeAccessor(int n, AttributeDefImpl attributeDefImpl) throws Exception {
        if (!attributeDefImpl.mResolveAccessors) {
            attributeDefImpl.initAccessors(this.getClass());
        }
        if (attributeDefImpl.mReadMethod != null) {
            return attributeDefImpl.mReadMethod.invoke((Object)this, null);
        }
        return this.getAttributeInternal(n);
    }

    public Object getAttribute(String string) {
        return this.getAttribute(this.findAttrAndGetIndex(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String string, Object object) {
        Object object2 = this.getSyncLock();
        synchronized (object2) {
            this.setAttribute(this.findAttrAndGetIndex(string), object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(int n, Object object) {
        Object object2 = this.getSyncLock();
        synchronized (object2) {
            try {
                this.useInner();
                ViewAttributeDefImpl viewAttributeDefImpl = null;
                viewAttributeDefImpl = this.mInner.getViewAttributeDef(n);
                try {
                    if (!this.isAttributeUpdateable(n)) {
                        Class clazz = class$oracle$jbo$CSMessageBundle;
                        if (clazz == null) {
                            clazz = class$oracle$jbo$CSMessageBundle = ViewRowImpl.class$("oracle.jbo.CSMessageBundle");
                        }
                        throw new ReadOnlyAttrException(111, clazz, "27008", this.getViewObject().getName(), viewAttributeDefImpl.getName());
                    }
                    object = viewAttributeDefImpl.convertToJava(object);
                    this.setAttrInvokeAccessor(n, object, viewAttributeDefImpl);
                }
                catch (DataCreationException dataCreationException) {
                    MapInfo mapInfo;
                    DBTransactionImpl dBTransactionImpl = (DBTransactionImpl)this.mInner.mVO.getDBTransaction();
                    MapInfo[] mapInfoArray = this.mInner.getMapInfo();
                    if (n < mapInfoArray.length && (mapInfo = mapInfoArray[n]).getSourceIndex() > -1) {
                        EntityImpl entityImpl = this.getEntity(mapInfo.getSourceIndex());
                        AttributeDefImpl attributeDefImpl = entityImpl.getAttributeDefImpl(mapInfo.getIndex());
                        dataCreationException.setAttrInfo(121, entityImpl.getEntityDef().getFullName(), attributeDefImpl.getName(), object);
                    }
                    if (dBTransactionImpl.isBundledExceptionMode()) {
                        this.clearAttributeException(viewAttributeDefImpl.getIndex());
                        this.registerAttributeException(viewAttributeDefImpl, object, dataCreationException);
                        Object var16_11 = null;
                        this.releaseInner();
                        return;
                    }
                    throw dataCreationException;
                }
                catch (JboException jboException) {
                    throw jboException;
                }
                catch (Exception exception) {
                    Class clazz;
                    Throwable throwable = exception;
                    if (Diagnostic.isOn()) {
                        Diagnostic.println("ViewRowImpl.setAttribute failed...");
                        Diagnostic.printStackTrace(exception);
                    }
                    if (exception instanceof InvocationTargetException) {
                        throwable = ((InvocationTargetException)exception).getTargetException();
                        if (Diagnostic.isOn()) {
                            Diagnostic.println("*** InvocationTargetException inner exception");
                            Diagnostic.printStackTrace(exception);
                        }
                        if (throwable instanceof JboException) {
                            throw (JboException)throwable;
                        }
                    }
                    if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                        clazz = class$oracle$jbo$CSMessageBundle = ViewRowImpl.class$("oracle.jbo.CSMessageBundle");
                    }
                    AttrSetValException attrSetValException = new AttrSetValException(111, clazz, "27020", this.getViewObject().getName(), viewAttributeDefImpl.getName(), object);
                    attrSetValException.setRowKey(111, this.getKey());
                    attrSetValException.setNeedsEntityToVOMapping(false);
                    attrSetValException.addToDetails(throwable);
                    throw attrSetValException;
                }
                Object var16_12 = null;
                this.releaseInner();
            }
            catch (Throwable throwable) {
                Object var16_13 = null;
                this.releaseInner();
                throw throwable;
            }
        }
    }

    protected boolean hasAttributeException(int n) {
        boolean bl;
        try {
            MapInfo mapInfo;
            this.useInner();
            MapInfo[] mapInfoArray = this.mInner.getMapInfo();
            if (n < mapInfoArray.length && (mapInfo = mapInfoArray[n]).getSourceIndex() > -1) {
                EntityImpl entityImpl = this.getEntity(mapInfo.getSourceIndex());
                boolean bl2 = entityImpl.hasAttributeException(mapInfo.getSourceIndex());
                Object var8_6 = null;
                this.releaseInner();
                return bl2;
            }
            bl = super.hasAttributeException(n);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.releaseInner();
            throw throwable;
        }
        Object var8_7 = null;
        this.releaseInner();
        return bl;
    }

    public boolean hasDeferredExceptions() {
        int n = this.getEntityCount();
        int n2 = 0;
        while (n2 < n) {
            EntityImpl entityImpl = this.getEntity(n2);
            if (entityImpl != null && entityImpl.hasDeferredExceptions()) {
                return true;
            }
            ++n2;
        }
        return super.hasDeferredExceptions();
    }

    protected void clearAttributeException(String string) {
        ViewAttributeDefImpl viewAttributeDefImpl = (ViewAttributeDefImpl)this.mInner.mVO.findAttributeDef(string);
        if (viewAttributeDefImpl != null) {
            try {
                MapInfo mapInfo;
                MapInfo[] mapInfoArray = this.mInner.getMapInfo();
                int n = viewAttributeDefImpl.getIndex();
                if (n < mapInfoArray.length && (mapInfo = mapInfoArray[n]).getSourceIndex() > -1) {
                    EntityImpl entityImpl = this.getEntity(mapInfo.getSourceIndex());
                    entityImpl.clearAttributeException(string);
                    Object var8_7 = null;
                    this.releaseInner();
                    return;
                }
                Object var8_8 = null;
                this.releaseInner();
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                this.releaseInner();
                throw throwable;
            }
        }
        super.clearAttributeException(string);
    }

    protected void clearAttributeException(int n) {
        try {
            MapInfo mapInfo;
            this.useInner();
            MapInfo[] mapInfoArray = this.mInner.getMapInfo();
            if (n < mapInfoArray.length && (mapInfo = mapInfoArray[n]).getSourceIndex() > -1) {
                EntityImpl entityImpl = this.getEntity(mapInfo.getSourceIndex());
                entityImpl.clearAttributeException(n);
                Object var6_5 = null;
                this.releaseInner();
                return;
            }
            super.clearAttributeException(n);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.releaseInner();
            throw throwable;
        }
        Object var6_6 = null;
        this.releaseInner();
    }

    protected void registerAttributeException(AttributeDef attributeDef, Object object, JboException jboException) {
        MapInfo mapInfo;
        MapInfo[] mapInfoArray = this.mInner.getMapInfo();
        int n = attributeDef.getIndex();
        if (n < mapInfoArray.length && (mapInfo = mapInfoArray[n]).getSourceIndex() > -1) {
            EntityImpl entityImpl = this.getEntity(mapInfo.getSourceIndex());
            entityImpl.registerAttributeException(entityImpl.getAttributeDefImpl(mapInfo.getIndex()), object, jboException);
            return;
        }
        throw jboException;
    }

    protected void setAttrInvokeAccessor(int n, Object object, AttributeDefImpl attributeDefImpl) throws Exception {
        if (!attributeDefImpl.mResolveAccessors) {
            attributeDefImpl.initAccessors(this.getClass());
        }
        if (attributeDefImpl.mWriteMethod != null) {
            Object[] objectArray = new Object[]{object};
            attributeDefImpl.mWriteMethod.invoke((Object)this, objectArray);
        } else {
            this.setAttributeInternal(n, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setAttributeInternal(int n, Object object) {
        Object object2 = this.getSyncLock();
        synchronized (object2) {
            try {
                this.useInner();
                this.mInner.setAttributeInternal(n, object);
                if (this.mQC != null) {
                    this.mQC.setDirty(true);
                }
                Object var5_4 = null;
                this.releaseInner();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.releaseInner();
                throw throwable;
            }
        }
    }

    void setAttributeValue(int n, Object object) {
        try {
            this.useInner();
            this.mInner.setAttributeValue(n, object);
            Object var4_3 = null;
            this.releaseInner();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.releaseInner();
            throw throwable;
        }
    }

    void OnMessage(String string, JboMessageObject jboMessageObject) {
    }

    final Object getSyncLock() {
        ViewObjectImpl viewObjectImpl = (ViewObjectImpl)this.getViewObject();
        if (viewObjectImpl == null) {
            throw new DeadViewRowAccessException(new Integer((int)this.mPersistentId));
        }
        return viewObjectImpl.getSyncLock();
    }

    public final RowSet getRowSet() {
        return this.mQC != null ? this.mQC.getRowSetImpl() : null;
    }

    public final ViewObject getViewObject() {
        ViewObjectImpl viewObjectImpl;
        if (this.mQC == null || (viewObjectImpl = this.mQC.getViewObjectImpl()) == null) {
            try {
                this.useInner();
                viewObjectImpl = this.mInner.mVO;
                Object var3_2 = null;
                this.releaseInner();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.releaseInner();
                throw throwable;
            }
        }
        return viewObjectImpl;
    }

    public final ApplicationModule getApplicationModule() {
        try {
            this.useInner();
            ApplicationModule applicationModule = this.mInner.mVO.getApplicationModule();
            Object var3_2 = null;
            this.releaseInner();
            return applicationModule;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseInner();
            throw throwable;
        }
    }

    Row getEntity(EntityReference entityReference) {
        Row row = null;
        try {
            this.useInner();
            row = this.mInner.getEntity(entityReference);
            Object var4_3 = null;
            this.releaseInner();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.releaseInner();
            throw throwable;
        }
        return row;
    }

    int getEntityIndex(Row row) {
        int n = -1;
        try {
            this.useInner();
            n = this.mInner.getEntityIndex(row);
            Object var4_3 = null;
            this.releaseInner();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.releaseInner();
            throw throwable;
        }
        return n;
    }

    public final ViewDefImpl getViewDef() {
        ViewDefImpl viewDefImpl = null;
        try {
            this.useInner();
            viewDefImpl = this.mInner.getViewDef();
            Object var3_2 = null;
            this.releaseInner();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseInner();
            throw throwable;
        }
        return viewDefImpl;
    }

    public final boolean hasExtendedViewDef() {
        try {
            this.useInner();
            boolean bl = this.mInner.mViewDef != null;
            Object var3_2 = null;
            this.releaseInner();
            return bl;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseInner();
            throw throwable;
        }
    }

    public int getAttributeIndexOf(String string) {
        int n = -1;
        try {
            this.useInner();
            if (this.mInner.mViewDef == null) {
                n = this.mInner.mVO.getAttributeIndexOf(string);
            } else {
                ViewDefImpl viewDefImpl = this.mInner.getViewDef();
                AttributeDef attributeDef = viewDefImpl.lookupAttributeDef(string);
                if (attributeDef == null) {
                    attributeDef = this.mInner.mVO.lookupAttributeDef(string);
                    if (attributeDef != null) {
                        n = viewDefImpl.getAttributeCount() + (attributeDef.getIndex() - this.mInner.mVO.getDynamicAttributeOffset());
                    }
                } else {
                    n = attributeDef.getIndex();
                }
            }
            Object var6_5 = null;
            this.releaseInner();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.releaseInner();
            throw throwable;
        }
        return n;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getAttributeNames() {
        String[] stringArray = new String[this.getAttributeCount()];
        try {
            this.useInner();
            int n = 0;
            AttributeDef[] attributeDefArray = this.mInner.getViewDef().getAttributeDefs();
            int n2 = 0;
            while (n2 < attributeDefArray.length) {
                stringArray[n] = attributeDefArray[n2].getName();
                ++n2;
                ++n;
            }
            attributeDefArray = this.mInner.mVO.getAttributeDefs();
            int n3 = this.mInner.mVO.getDynamicAttributeOffset();
            boolean bl = true;
            do {
                if (!bl || (bl = false) || !true) {
                    stringArray[n] = attributeDefArray[n3].getName();
                    ++n3;
                    ++n;
                }
                if (n3 < 0) break;
            } while (n3 < attributeDefArray.length);
            Object var7_6 = null;
            this.releaseInner();
            return stringArray;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.releaseInner();
            throw throwable;
        }
    }

    public Object[] getAttributeValues() {
        Object[] objectArray = new Object[this.getAttributeCount()];
        int n = 0;
        while (n < objectArray.length) {
            objectArray[n] = this.getAttribute(n);
            ++n;
        }
        return objectArray;
    }

    protected EntityImpl[] createEntities() {
        return this.createMissingEntities(null, null, null, null, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    EntityImpl[] createMissingEntities(int[] nArray, EntityImpl[] entityImplArray, ResultSet resultSet, AttributeList attributeList, boolean bl) {
        EntityImpl[] entityImplArray2;
        try {
            this.useInner();
            EntityReference[] entityReferenceArray = this.mInner.getViewDef().getEntityReferences();
            if (entityReferenceArray == null) {
                EntityImpl[] entityImplArray3 = null;
                Object var28_8 = null;
                this.releaseInner();
                return entityImplArray3;
            }
            EntityImpl[] entityImplArray4 = new EntityImpl[entityReferenceArray.length];
            if (entityImplArray != null) {
                int n = 0;
                while (n < entityImplArray.length) {
                    if (nArray == null) {
                        entityImplArray4[n] = entityImplArray[n];
                    } else {
                        entityImplArray4[nArray[n]] = entityImplArray[n];
                    }
                    ++n;
                }
            }
            int n = 0;
            while (true) {
                if (n >= entityReferenceArray.length) {
                    entityImplArray2 = entityImplArray4;
                    break;
                }
                if (entityImplArray4[n] == null) {
                    EntityReference entityReference = entityReferenceArray[n];
                    AttributeDefImpl[] attributeDefImplArray = entityReference.getDiscrColumns();
                    int[] nArray2 = entityReference.getDiscrColLoadIndices();
                    EntityDefImpl entityDefImpl = entityReference.getEntityDef();
                    if (attributeDefImplArray != null && (resultSet != null || attributeList != null)) {
                        EntityDefImpl entityDefImpl2;
                        block26: {
                            Object[] objectArray = new Object[attributeDefImplArray.length];
                            DBTransactionImpl dBTransactionImpl = (DBTransactionImpl)this.mInner.mVO.getDBTransaction();
                            boolean bl2 = true;
                            int n2 = 0;
                            while (true) {
                                if (n2 >= attributeDefImplArray.length) {
                                    entityDefImpl2 = (EntityDefImpl)entityDefImpl.findDefForDiscrValues(objectArray, true);
                                    if (entityDefImpl2 == null) {
                                        if (resultSet != null || !bl2) break;
                                        entityDefImpl2 = entityDefImpl;
                                    }
                                    break block26;
                                }
                                ViewAttributeDefImpl viewAttributeDefImpl = (ViewAttributeDefImpl)attributeDefImplArray[n2];
                                if (resultSet != null) {
                                    int n3 = nArray2[n2];
                                    if (n3 >= 0) {
                                        objectArray[n2] = viewAttributeDefImpl.loadFromResultSet(resultSet, n3 + 1, dBTransactionImpl);
                                    }
                                } else {
                                    Object object = attributeList.getAttribute(viewAttributeDefImpl.getName());
                                    if (object != null) {
                                        objectArray[n2] = object;
                                    }
                                }
                                if (objectArray[n2] != null) {
                                    bl2 = false;
                                }
                                ++n2;
                            }
                            String string = null;
                            if (bl || Diagnostic.isOn()) {
                                string = "Discr values: ";
                                int n4 = 0;
                                while (n4 < objectArray.length) {
                                    if (n4 > 0) {
                                        string = string + ",";
                                    }
                                    string = string + objectArray[n4];
                                    ++n4;
                                }
                            }
                            if (Diagnostic.isOn()) {
                                Diagnostic.println("ViewRowImpl.createMissingEntities: returning null, no matching discrVals for " + entityReference.getName() + " in " + this.mInner.mVO.getName());
                                Diagnostic.println("  " + string);
                            }
                            if (bl) {
                                Class clazz = class$oracle$jbo$CSMessageBundle;
                                if (clazz == null) {
                                    clazz = class$oracle$jbo$CSMessageBundle = ViewRowImpl.class$("oracle.jbo.CSMessageBundle");
                                }
                                throw new RowCreateException(clazz, "26037", new Object[]{this.mInner.mVO.getName(), entityDefImpl.getName(), string});
                            }
                            EntityImpl[] entityImplArray5 = null;
                            Object var28_9 = null;
                            this.releaseInner();
                            return entityImplArray5;
                        }
                        entityDefImpl = entityDefImpl2;
                    }
                    entityImplArray4[n] = entityDefImpl.createBlankInstance2(this.mInner.mVO.getDBTransactionImpl());
                }
                ++n;
            }
        }
        catch (Throwable throwable) {
            Object var28_11 = null;
            this.releaseInner();
            throw throwable;
        }
        Object var28_10 = null;
        this.releaseInner();
        return entityImplArray2;
    }

    private ArrayList lockEntities(boolean bl, boolean bl2) {
        ArrayList arrayList = null;
        try {
            this.useInner();
            if (this.mInner.mVO.getDBTransactionImpl().getLockingMode() == 0) {
                ArrayList arrayList2 = null;
                Object var10_5 = null;
                this.releaseInner();
                return arrayList2;
            }
            int[] nArray = this.mInner.mVO.getLockParticipants();
            int n = 0;
            while (n < nArray.length) {
                EntityImpl entityImpl = this.mInner.getEntity(nArray[n]);
                if (entityImpl != null) {
                    try {
                        entityImpl.lock();
                    }
                    catch (RowNotFoundException rowNotFoundException) {
                        if (!bl) {
                            if (bl2) {
                                entityImpl.removedByAnotherTrans();
                            }
                            throw rowNotFoundException;
                        }
                        if (arrayList == null) {
                            arrayList = new ArrayList();
                        }
                        arrayList.add((Object)entityImpl);
                    }
                }
                ++n;
            }
        }
        catch (Throwable throwable) {
            Object var10_7 = null;
            this.releaseInner();
            throw throwable;
        }
        Object var10_6 = null;
        this.releaseInner();
        return arrayList;
    }

    public void lock() {
        this.lockEntities(false, false);
    }

    public void revert() {
        this.refresh(0);
    }

    public void refresh(int n) {
        try {
            this.useInner();
            EntityImpl[] entityImplArray = this.getEntities();
            if (entityImplArray != null) {
                int n2 = 0;
                while (n2 < entityImplArray.length) {
                    if (entityImplArray[n2] != null) {
                        entityImplArray[n2].refresh(n);
                    }
                    ++n2;
                }
            }
            Object var5_4 = null;
            this.releaseInner();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.releaseInner();
            throw throwable;
        }
    }

    void doRemove(int n) {
        ArrayList arrayList = null;
        try {
            this.useInner();
            if (this.mInner.mVO.isReadOnly()) {
                throw new ReadOnlyViewObjectException(this.mInner.mVO.getName());
            }
            int[] nArray = null;
            if (n == 0) {
                nArray = this.mInner.mVO.getDeleteParticipants();
            }
            if (n == 0 && nArray.length > 0) {
                if (this.mInner.mVO.getDBTransactionImpl().getLockingMode() == 1) {
                    boolean bl = MetaObjectManager.getSingleton().is323Compatible();
                    boolean bl2 = bl ^ true;
                    arrayList = this.lockEntities(bl, bl2);
                }
                int n2 = 0;
                while (n2 < nArray.length) {
                    EntityImpl entityImpl = this.mInner.getEntity(nArray[n2]);
                    if (arrayList != null && arrayList.contains((Object)entityImpl)) {
                        entityImpl.removedByAnotherTrans();
                    } else if (entityImpl.getPostState() != 3) {
                        entityImpl.remove();
                    }
                    ++n2;
                }
            } else {
                int n3;
                QueryCollection queryCollection = this.mInner.getQueryCollection();
                if (queryCollection != null && (n3 = queryCollection.indexOf(this)) > -1) {
                    queryCollection.removeRow(this, n3, true, n);
                }
            }
            this.mInner.setPostState((byte)3);
            Object var11_10 = null;
            this.releaseInner();
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.releaseInner();
            throw throwable;
        }
    }

    public void remove() {
        this.doRemove(0);
    }

    public void removeFromCollection() {
        this.doRemove(1);
    }

    public void removeAndRetain() {
        this.doRemove(2);
    }

    public int getEntityCount() {
        try {
            this.useInner();
            int n = this.mInner.getEntityCount();
            Object var3_2 = null;
            this.releaseInner();
            return n;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseInner();
            throw throwable;
        }
    }

    public final EntityImpl getEntity(int n) {
        EntityImpl entityImpl = null;
        try {
            this.useInner();
            entityImpl = this.mInner.getEntity(n);
            Object var4_3 = null;
            this.releaseInner();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.releaseInner();
            throw throwable;
        }
        return entityImpl;
    }

    final EntityImpl getEntity(String string) {
        EntityImpl entityImpl = null;
        try {
            this.useInner();
            entityImpl = this.mInner.getEntity(string);
            Object var4_3 = null;
            this.releaseInner();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.releaseInner();
            throw throwable;
        }
        return entityImpl;
    }

    public final Entity getEntityForAttribute(String string) {
        try {
            this.useInner();
            EntityImpl entityImpl = ((ViewAttributeDefImpl)this.getViewDef().findAttributeDef(string)).getEntityInstance(this);
            Object var4_3 = null;
            this.releaseInner();
            return entityImpl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.releaseInner();
            throw throwable;
        }
    }

    public final AttributeDefImpl getEntityAttrForAttribute(String string) {
        try {
            this.useInner();
            AttributeDefImpl attributeDefImpl = ((ViewAttributeDefImpl)this.getViewDef().findAttributeDef(string)).getAttributeDefImpl();
            Object var4_3 = null;
            this.releaseInner();
            return attributeDefImpl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.releaseInner();
            throw throwable;
        }
    }

    public EntityImpl[] getEntities() {
        EntityImpl[] entityImplArray = null;
        try {
            this.useInner();
            entityImplArray = this.mInner.getEntities();
            Object var3_2 = null;
            this.releaseInner();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseInner();
            throw throwable;
        }
        return entityImplArray;
    }

    protected final void setEntities(EntityImpl[] entityImplArray) {
        try {
            this.useInner();
            this.mInner.setEntities(entityImplArray);
            Object var3_2 = null;
            this.releaseInner();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseInner();
            throw throwable;
        }
    }

    protected final void setEntity(int n, EntityImpl entityImpl) {
        try {
            this.useInner();
            this.mInner.setEntity(n, entityImpl);
            Object var4_3 = null;
            this.releaseInner();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.releaseInner();
            throw throwable;
        }
    }

    public final int getAttributeCount() {
        int n = -1;
        try {
            this.useInner();
            n = this.mInner.getViewDef().getAttributeCount() + this.mInner.mVO.getDynamicAttributeCount();
            Object var3_2 = null;
            this.releaseInner();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseInner();
            throw throwable;
        }
        return n;
    }

    public boolean isAttributeUpdateable(int n) {
        boolean bl = false;
        try {
            this.useInner();
            bl = this.mInner.isAttributeUpdateable(n);
            Object var4_3 = null;
            this.releaseInner();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.releaseInner();
            throw throwable;
        }
        return bl;
    }

    public boolean isDead() {
        return this.mQC == null;
    }

    public StructureDef getStructureDef() {
        StructureDef structureDef = null;
        try {
            this.useInner();
            ViewObjectImpl viewObjectImpl = (ViewObjectImpl)this.getViewObject();
            ViewDefImpl viewDefImpl = this.mInner.getViewDefInternal();
            structureDef = viewObjectImpl.getSubclassDef(viewDefImpl);
            Object var5_4 = null;
            this.releaseInner();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.releaseInner();
            throw throwable;
        }
        return structureDef;
    }

    public void entityCacheAdd() {
        try {
            this.useInner();
            this.mInner.entityCacheAdd();
            Object var2_1 = null;
            this.releaseInner();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.releaseInner();
            throw throwable;
        }
    }

    protected void populate(ResultSet resultSet) {
        try {
            this.useInner();
            Object[] objectArray = null;
            int n = 1;
            AttributeDefImpl[] attributeDefImplArray = this.mInner.getViewAttributeDefs();
            int n2 = attributeDefImplArray.length;
            DBTransactionImpl dBTransactionImpl = (DBTransactionImpl)this.mInner.mVO.getDBTransaction();
            ViewAttributeDefImpl viewAttributeDefImpl = null;
            int n3 = 0;
            while (n3 < n2) {
                objectArray = null;
                viewAttributeDefImpl = attributeDefImplArray[n3];
                byte by = viewAttributeDefImpl.getAttributeKind();
                if ((by == 0 || by == 1) && viewAttributeDefImpl.isSelected()) {
                    if (viewAttributeDefImpl.getAttrLoad() == 1) {
                        objectArray = this.mInner.mVO.getSQLBuilder().doLoadBulkFromResultSet(attributeDefImplArray, n3, resultSet, n++, dBTransactionImpl);
                    } else {
                        objectArray = viewAttributeDefImpl.loadFromResultSet(resultSet, n++, dBTransactionImpl);
                        this.populateAttribute(n3, objectArray);
                    }
                }
                if (viewAttributeDefImpl.getAttrLoad() == 1) {
                    Object[] objectArray2 = objectArray;
                    int n4 = 0;
                    while (n3 < n2) {
                        Object object = objectArray2[n4];
                        if (object instanceof DomainInterface) {
                            attributeDefImplArray[n3].processDomainValue((DomainInterface)object, null, dBTransactionImpl);
                        }
                        this.populateAttribute(n3, object);
                        if (n3 + 1 < n2 && attributeDefImplArray[n3 + 1].getAttrLoad() != 2) break;
                        ++n3;
                        ++n4;
                    }
                }
                ++n3;
            }
            Object var14_13 = null;
            this.releaseInner();
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            this.releaseInner();
            throw throwable;
        }
    }

    protected void populateAttribute(int n, Object object) {
        try {
            this.useInner();
            this.mInner.populateAttribute(n, object);
            Object var4_3 = null;
            this.releaseInner();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.releaseInner();
            throw throwable;
        }
    }

    protected void populateAttributeAsChanged(int n, Object object) {
        try {
            this.useInner();
            this.mInner.populateAttributeAsChanged(n, object);
            Object var4_3 = null;
            this.releaseInner();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.releaseInner();
            throw throwable;
        }
    }

    Object getDynamicAttribute(int n) {
        Object object = null;
        try {
            this.useInner();
            object = this.mInner.getDynamicAttribute(n);
            Object var4_3 = null;
            this.releaseInner();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.releaseInner();
            throw throwable;
        }
        return object;
    }

    void setDynamicAttribute(int n, Object object) {
        try {
            this.useInner();
            this.mInner.setDynamicAttribute(n, object);
            Object var4_3 = null;
            this.releaseInner();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.releaseInner();
            throw throwable;
        }
    }

    void setPostState(byte by) {
        try {
            this.useInner();
            this.mInner.setPostState(by);
            Object var3_2 = null;
            this.releaseInner();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseInner();
            throw throwable;
        }
    }

    public byte getNewRowState() {
        byte by = 127;
        try {
            this.useInner();
            by = this.mInner.getNewRowState();
            Object var3_2 = null;
            this.releaseInner();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseInner();
            throw throwable;
        }
        return by;
    }

    byte getPostState() {
        byte by = 1;
        try {
            this.useInner();
            by = this.mInner.getPostState();
            Object var3_2 = null;
            this.releaseInner();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseInner();
            throw throwable;
        }
        return by;
    }

    protected RowSet findAssociatedObjects(String string) {
        try {
            this.useInner();
            ViewAttributeDefImpl viewAttributeDefImpl = (ViewAttributeDefImpl)this.mInner.mVO.findAttributeDef(string);
            RowSet rowSet = (RowSet)viewAttributeDefImpl.get(this);
            Object var5_4 = null;
            this.releaseInner();
            return rowSet;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.releaseInner();
            throw throwable;
        }
    }

    void removeReference(EntityImpl entityImpl) {
        try {
            this.useInner();
            this.mInner.removeReference(entityImpl);
            Object var3_2 = null;
            this.releaseInner();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseInner();
            throw throwable;
        }
    }

    void updateReference(int n, EntityImpl entityImpl) {
        try {
            this.useInner();
            this.mInner.updateReference(n, entityImpl);
            Object var4_3 = null;
            this.releaseInner();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.releaseInner();
            throw throwable;
        }
    }

    Object[] getCalcAttrs() {
        try {
            this.useInner();
            Object[] objectArray = this.mInner.getCalcAttrs();
            Object var3_2 = null;
            this.releaseInner();
            return objectArray;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseInner();
            throw throwable;
        }
    }

    void setCalcAttrs(Object[] objectArray) {
        try {
            this.useInner();
            this.mInner.setCalcAttrs(objectArray);
            Object var3_2 = null;
            this.releaseInner();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseInner();
            throw throwable;
        }
    }

    final DBTransactionImpl getDBTransactionImpl() {
        DBTransactionImpl dBTransactionImpl = null;
        try {
            this.useInner();
            dBTransactionImpl = this.mInner.getDBTransactionImpl();
            Object var3_2 = null;
            this.releaseInner();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseInner();
            throw throwable;
        }
        return dBTransactionImpl;
    }

    static Key getEntityKeyFromViewRowKey(Key key, int n, ViewObjectImpl viewObjectImpl) {
        AttributeDef[] attributeDefArray = viewObjectImpl.getKeyAttributeDefs();
        EntityReference entityReference = viewObjectImpl.getViewDef().getEntityReferences()[n];
        AttributeDefImpl[] attributeDefImplArray = entityReference.getEntityDef().getPrimaryKeys();
        Object[] objectArray = key.getKeyValues();
        ArrayList arrayList = new ArrayList(attributeDefImplArray.length);
        boolean bl = true;
        JboEnvUtil.setSizeInArrayList(arrayList, attributeDefImplArray.length);
        int n2 = 0;
        while (n2 < attributeDefArray.length) {
            ViewAttributeDefImpl viewAttributeDefImpl = (ViewAttributeDefImpl)attributeDefArray[n2];
            AttributeDefImpl attributeDefImpl = viewAttributeDefImpl.getAttributeDefImpl();
            if (viewAttributeDefImpl.getEntityReference() == entityReference && attributeDefImpl.isPrimaryKey()) {
                if (n2 >= objectArray.length) break;
                int n3 = 0;
                while (n3 < attributeDefImplArray.length) {
                    if (attributeDefImpl == attributeDefImplArray[n3]) {
                        arrayList.set(n3, objectArray[n2]);
                        break;
                    }
                    ++n3;
                }
                if (n3 < attributeDefImplArray.length && objectArray[n2] != null) {
                    bl = false;
                }
            }
            ++n2;
        }
        if (bl) {
            return null;
        }
        return new Key(arrayList.toArray());
    }

    public int hashCode() {
        return (int)this.getPersistentId();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ViewRowImpl)) {
            return false;
        }
        return ((ViewRowImpl)object).getPersistentId() == this.getPersistentId();
    }

    AttributeDefImpl[] getAttributeDefImpls() {
        if (this.mQC == null) {
            return null;
        }
        AttributeDefImpl[] attributeDefImplArray = null;
        try {
            this.useInner();
            attributeDefImplArray = this.mInner.getViewAttributeDefs();
            Object var3_2 = null;
            this.releaseInner();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseInner();
            throw throwable;
        }
        return attributeDefImplArray;
    }

    public String getXMLElementTag() {
        return this.getViewDef().getXMLRowElementTag();
    }

    static HashMap validateVOAttrXMLRules(String string, HashMap hashMap) {
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        if (!hashMap.containsKey((Object)string)) {
            hashMap.put((Object)string, null);
        }
        return hashMap;
    }

    public final Node writeXML(long l, HashMap hashMap) {
        ViewObjectImpl viewObjectImpl = (ViewObjectImpl)this.getViewObject();
        String string = this.getViewDef().getFullName();
        hashMap = ViewRowImpl.validateVOAttrXMLRules(string, hashMap);
        XMLDocument xMLDocument = new XMLDocument();
        Element element = xMLDocument.createElement(this.getXMLElementTag());
        this.appendXMLElementNodes((Document)xMLDocument, element, -2, l, hashMap, viewObjectImpl.getViewAttrDefsFromNames((String[])hashMap.get((Object)string)));
        xMLDocument.appendChild((Node)element);
        Element element2 = xMLDocument.getDocumentElement();
        element2.getParentNode().removeChild(element2);
        return element2;
    }

    protected void appendXMLElementNodes(Document document, Node node, int n, long l, HashMap hashMap, AttributeDef[] attributeDefArray) {
        this.writeToXmlDocument(null, document, node, n, l, hashMap, attributeDefArray, (byte)0);
    }

    protected void appendXMLElementNodes(Document document, Node node, int n, long l, AttributeDefImpl[] attributeDefImplArray) {
        this.appendXMLElementNodes(document, node, n, l, null, attributeDefImplArray);
    }

    protected Element renderAttributeInXMLElement(Document document, AttributeDefImpl attributeDefImpl, boolean bl, byte by) {
        Object object = null;
        object = by == 0 ? this.getAttribute(attributeDefImpl.mIndex) : this.getAttributeInternal(attributeDefImpl.mIndex, by);
        Node node = DomainAttributeDef.getXMLContentNode(document, object, attributeDefImpl.getProperty("XML_CDATA") != null);
        Element element = null;
        if (node != null) {
            element = document.createElement(attributeDefImpl.getXMLElementTag());
            element.appendChild(node);
        } else if (bl || attributeDefImpl.getProperty("XML_EXPLICIT_NULL") != null) {
            element = document.createElement(attributeDefImpl.getXMLElementTag());
            element.setAttribute("null", "true");
        }
        return element;
    }

    protected Element renderAttributeInXMLElement(Document document, AttributeDefImpl attributeDefImpl, boolean bl) {
        return this.renderAttributeInXMLElement(document, attributeDefImpl, bl, (byte)0);
    }

    void readAttributeFromXMLElement(Node node, AttributeDefImpl attributeDefImpl, boolean bl) {
        NodeList nodeList;
        int n = attributeDefImpl.mIndex;
        if (this.isAttributeUpdateable(n) && (nodeList = ((XMLElement)node).getChildrenByTagName(attributeDefImpl.getXMLElementTag())).getLength() > 0) {
            Object object = attributeDefImpl.getXMLContentValue((Element)nodeList.item(0), bl);
            if (object != null ? !(object instanceof MutableDomainInterface) && object.equals(this.getAttribute(n)) : this.getAttribute(n) == null) {
                return;
            }
            if (bl) {
                this.populateAttribute(n, object);
            } else {
                this.setAttribute(n, object);
            }
        }
    }

    protected void readAttributeFromXMLElement(Node node, AttributeDefImpl attributeDefImpl) {
        this.readAttributeFromXMLElement(node, attributeDefImpl, false);
    }

    boolean readAssocAttrsFromXML(Element element, AttributeDefImpl[] attributeDefImplArray, int n, XmlDocumentReader xmlDocumentReader) {
        int n2 = n > 0 ? n - 1 : n;
        ArrayList arrayList = new ArrayList(attributeDefImplArray.length);
        int n3 = attributeDefImplArray.length - 1;
        while (n3 >= 0) {
            try {
                if ((attributeDefImplArray[n3].mKind == 2 || attributeDefImplArray[n3].mKind == 6) && n != 0) {
                    RowSetImpl rowSetImpl = (RowSetImpl)attributeDefImplArray[n3].get(this);
                    rowSetImpl.executeQuery();
                    ViewObjectImpl viewObjectImpl = (ViewObjectImpl)rowSetImpl.getViewObject();
                    if (xmlDocumentReader == null) {
                        NodeList nodeList = ((XMLElement)element).getChildrenByTagName(attributeDefImplArray[n3].getXMLElementTag());
                        if (nodeList.getLength() > 0) {
                            viewObjectImpl.updateRowSetFromXML((Element)nodeList.item(0), n2, rowSetImpl);
                        }
                    } else {
                        NodeIterator nodeIterator = xmlDocumentReader.createRowNodeIterator(viewObjectImpl, element);
                        viewObjectImpl.updateRowSetFromXML(element, n2, rowSetImpl, xmlDocumentReader, nodeIterator);
                    }
                }
            }
            catch (JboException jboException) {
                arrayList.add((Object)new AttributeReadXMLException(attributeDefImplArray[n3].getName(), n3, attributeDefImplArray[n3].getXMLElementTag(), jboException));
            }
            catch (Exception exception) {
                arrayList.add((Object)new AttributeReadXMLException(attributeDefImplArray[n3].getName(), n3, attributeDefImplArray[n3].getXMLElementTag(), exception));
            }
            --n3;
        }
        if (arrayList.size() > 0) {
            throw new RowReadXMLException(this.getKey(), element.getTagName(), arrayList);
        }
        return true;
    }

    boolean readAttrsFromXML(Element element, AttributeDefImpl[] attributeDefImplArray, int n) {
        return this.readAttrsFromXML(element, attributeDefImplArray, n, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean readAttrsFromXML(Element element, AttributeDefImpl[] attributeDefImplArray, int n, XmlDocumentReader xmlDocumentReader) {
        boolean bl = XML_POSTSTATE_REMOVE.equals(element.getAttribute(XML_POSTSTATE_TAG));
        int n2 = n > 0 ? n - 1 : n;
        ArrayList arrayList = new ArrayList(attributeDefImplArray.length);
        int n3 = 0;
        while (n3 < attributeDefImplArray.length) {
            try {
                switch (attributeDefImplArray[n3].mKind) {
                    case 2: {
                        if (n != 0) {
                            ViewRowImpl viewRowImpl = (ViewRowImpl)attributeDefImplArray[n3].get(this);
                            ViewObjectImpl viewObjectImpl = (ViewObjectImpl)viewRowImpl.getViewObject();
                            NodeList nodeList = ((XMLElement)element).getChildrenByTagName(attributeDefImplArray[n3].getXMLElementTag());
                            if (nodeList.getLength() > 0) {
                                viewRowImpl.readXML((Element)nodeList.item(0).getFirstChild(), n2);
                            }
                        }
                        break;
                    }
                    case 6: {
                        if (n == 0) break;
                        RowSetImpl rowSetImpl = (RowSetImpl)attributeDefImplArray[n3].get(this);
                        rowSetImpl.executeQuery();
                        ViewObjectImpl viewObjectImpl = (ViewObjectImpl)rowSetImpl.getViewObject();
                        if (xmlDocumentReader == null) {
                            NodeList nodeList = ((XMLElement)element).getChildrenByTagName(attributeDefImplArray[n3].getXMLElementTag());
                            if (nodeList.getLength() > 0) {
                                viewObjectImpl.updateRowSetFromXML((Element)nodeList.item(0), n2, rowSetImpl);
                            }
                        } else {
                            Element element2 = xmlDocumentReader.getChildElement(element, attributeDefImplArray[n3].getXMLElementTag(), 0);
                            if (element2 != null) {
                                viewObjectImpl.readFromXml(xmlDocumentReader, element2);
                            }
                        }
                        break;
                    }
                    default: {
                        if (!bl) {
                            this.readAttributeFromXMLElement(element, attributeDefImplArray[n3], false);
                        }
                        break;
                    }
                }
            }
            catch (JboException jboException) {
                arrayList.add((Object)new AttributeReadXMLException(attributeDefImplArray[n3].getName(), n3, attributeDefImplArray[n3].getXMLElementTag(), jboException));
            }
            catch (Exception exception) {
                arrayList.add((Object)new AttributeReadXMLException(attributeDefImplArray[n3].getName(), n3, attributeDefImplArray[n3].getXMLElementTag(), exception));
            }
            ++n3;
        }
        if (bl) {
            this.remove();
            return false;
        }
        if (arrayList.size() > 0) {
            throw new RowReadXMLException(this.getKey(), element.getTagName(), arrayList);
        }
        return true;
    }

    public final void readXML(Element element, int n) {
        boolean bl = false;
        ViewObjectImpl viewObjectImpl = (ViewObjectImpl)this.getViewObject();
        AttributeDefImpl[] attributeDefImplArray = (AttributeDefImpl[])viewObjectImpl.getKeyAttributeDefs();
        int n2 = 0;
        while (n2 < attributeDefImplArray.length) {
            NodeList nodeList = ((XMLElement)element).getChildrenByTagName(attributeDefImplArray[n2].getXMLElementTag() + "-Old");
            if (nodeList.getLength() > 0) {
                bl = true;
                break;
            }
            ++n2;
        }
        Object object = ViewRowImpl.updateRowFromXML(viewObjectImpl.mViewRowSet, n, element, this.getAttributeDefImpls(), bl, this, false, null);
        if (object instanceof JboException) {
            throw (JboException)object;
        }
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Object updateRowFromXML(RowSetImpl rowSetImpl, int n, Element element, AttributeDefImpl[] attributeDefImplArray, boolean bl, ViewRowImpl viewRowImpl, boolean bl2, XmlDocumentReader xmlDocumentReader) {
        void var9_13;
        ViewRowImpl viewRowImpl2;
        Object var9_9;
        boolean bl3;
        block18: {
            bl3 = false;
            var9_9 = null;
            Object var10_14 = null;
            viewRowImpl2 = null;
            if (viewRowImpl == null || bl) {
                viewRowImpl2 = (ViewRowImpl)rowSetImpl.createRow();
                rowSetImpl.insertRow(viewRowImpl2);
                bl3 = true;
                if (bl && viewRowImpl != null) {
                    if (XML_POSTSTATE_REMOVE.equals(element.getAttribute(XML_POSTSTATE_TAG))) {
                        throw new JboException("Row to be deleted has modified key attributes!");
                    }
                    EntityImpl[] entityImplArray = viewRowImpl2.getEntities();
                    int n2 = 0;
                    while (n2 < entityImplArray.length) {
                        entityImplArray[n2].markEntityNewForXMLRead();
                        ++n2;
                    }
                    n2 = 0;
                    while (n2 < attributeDefImplArray.length) {
                        if (attributeDefImplArray[n2].mKind != 2 && attributeDefImplArray[n2].mKind != 6) {
                            viewRowImpl2.populateAttributeAsChanged(n2, viewRowImpl.getAttribute(n2));
                        }
                        ++n2;
                    }
                    viewRowImpl2.readAttrsFromXML(element, attributeDefImplArray, 0, xmlDocumentReader);
                    viewRowImpl.readAssocAttrsFromXML(element, attributeDefImplArray, n, xmlDocumentReader);
                    attributeDefImplArray = new ViewAttributeDefImpl[]{};
                    viewRowImpl.remove();
                    viewRowImpl2.entityCacheAdd();
                }
                viewRowImpl = viewRowImpl2;
            }
            if (!viewRowImpl.readAttrsFromXML(element, attributeDefImplArray, n, xmlDocumentReader) || !bl2) break block18;
            viewRowImpl.validate();
        }
        Object var20_18 = null;
        if (!bl3 || var9_9 == null) return var9_13;
        try {
            viewRowImpl2.remove();
            return var9_13;
        }
        catch (Exception exception) {}
        return var9_13;
        {
            catch (ReadXMLException readXMLException) {
                ReadXMLException readXMLException2 = readXMLException;
                Object var20_19 = null;
                if (!bl3) return var9_13;
                if (readXMLException2 == null) return var9_13;
                try {
                    viewRowImpl2.remove();
                    return var9_13;
                }
                catch (Exception exception) {}
                return var9_13;
            }
            catch (JboException jboException) {
                ArrayList arrayList = new ArrayList(1);
                arrayList.add((Object)jboException);
                RowReadXMLException rowReadXMLException = new RowReadXMLException(viewRowImpl.getKey(), element.getTagName(), arrayList);
                Object var20_20 = null;
                if (!bl3) return var9_13;
                if (rowReadXMLException == null) return var9_13;
                try {
                    viewRowImpl2.remove();
                    return var9_13;
                }
                catch (Exception exception) {}
                return var9_13;
            }
            catch (Exception exception) {
                JboException jboException = new JboException(exception);
                Object var20_21 = null;
                if (!bl3) return var9_13;
                if (jboException == null) return var9_13;
                try {
                    viewRowImpl2.remove();
                    return var9_13;
                }
                catch (Exception exception2) {}
                return var9_13;
            }
        }
        catch (Throwable throwable) {
            Object var20_22 = null;
            if (!bl3 || var9_9 == null) throw throwable;
            try {
                viewRowImpl2.remove();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public void setNewRowState(byte by) {
        int n = this.getEntityCount();
        int n2 = 0;
        while (n2 < n) {
            EntityImpl entityImpl = this.getEntity(n2);
            if (entityImpl != null) {
                switch (entityImpl.getPostState()) {
                    case -1: 
                    case 0: {
                        entityImpl.setNewRowState(by);
                    }
                }
            }
            ++n2;
        }
        try {
            this.useInner();
            switch (this.mInner.getPostState()) {
                case 0: {
                    this.mInner.setPostState(by);
                    if (by == -1) {
                        int n3 = this.mQC.indexOf(this);
                        if (n3 > -1) {
                            this.mQC.getViewObjectImpl().addNewRowTracker(this.mQC, this, n3, true);
                            break;
                        }
                        this.mQC.getViewObjectImpl().addNewRowTracker(this.mQC, this, Integer.MIN_VALUE, true);
                        if (!this.mQC.isDirty()) {
                            this.mQC.getViewObjectImpl().markQueryCollectionDirty(this.mQC, true);
                        }
                    }
                    break;
                }
                case -1: {
                    this.mInner.setPostState(by);
                }
            }
            Object var8_6 = null;
            this.releaseInner();
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.releaseInner();
            throw throwable;
        }
    }

    public String getElementTagName() {
        return this.getViewDef().getXMLRowElementTag();
    }

    public void writeAsXml(XmlOutput xmlOutput, Node node, Criteria criteria) {
        this.writeAsXml(xmlOutput, node, criteria, (byte)0);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void writeToXmlDocument(XmlOutput xmlOutput, Document document, Node node, int n, long l, HashMap hashMap, AttributeDef[] attributeDefArray, byte by) {
        int n2 = n > 0 ? n - 1 : n;
        boolean bl = this.mInner.mVO.getProperty("XML_EXPLICIT_NULL") != null;
        int n3 = 0;
        while (n3 < attributeDefArray.length) {
            block21: {
                Element element;
                block22: {
                    element = null;
                    AttributeDefImpl attributeDefImpl = (AttributeDefImpl)attributeDefArray[n3];
                    String string = attributeDefImpl.getXMLElementTag();
                    if (string.equals("#hide")) break block22;
                    switch (attributeDefImpl.mKind) {
                        case 2: {
                            if (n == 0 || by != 0) break;
                            ViewRowImpl viewRowImpl = (ViewRowImpl)this.getAttribute(attributeDefImpl.mIndex);
                            if (viewRowImpl != null) {
                                ViewObjectImpl viewObjectImpl = (ViewObjectImpl)viewRowImpl.getViewObject();
                                String string2 = viewRowImpl.getViewDef().getFullName();
                                if (n != -2 || hashMap.containsKey((Object)string2)) {
                                    Node node2;
                                    if (xmlOutput == null) {
                                        element = document.createElement(string);
                                        node2 = document.createElement(viewRowImpl.getXMLElementTag());
                                        viewRowImpl.appendXMLElementNodes(document, node2, n2, l, hashMap, hashMap != null ? viewObjectImpl.getViewAttrDefsFromNames((String[])hashMap.get((Object)string2)) : viewRowImpl.getAttributeDefImpls());
                                    } else {
                                        node2 = xmlOutput.writeObject(viewRowImpl, new XmlInterfaceCriteria(n2, l, hashMap));
                                    }
                                    if (!node2.hasChildNodes()) {
                                        element = null;
                                        break;
                                    }
                                    element.appendChild(node2);
                                    break;
                                }
                                break block21;
                            } else {
                                if (!bl && attributeDefImpl.getProperty("XML_EXPLICIT_NULL") == null) break;
                                element = document.createElement(string);
                                element.setAttribute("null", "true");
                                break;
                            }
                        }
                        case 6: {
                            if (n == 0 || by != 0) break;
                            ViewRowSetImpl viewRowSetImpl = (ViewRowSetImpl)this.getAttribute(attributeDefImpl.mIndex);
                            ViewObjectImpl viewObjectImpl = (ViewObjectImpl)viewRowSetImpl.getViewObject();
                            if (n != -2 || hashMap.containsKey((Object)viewObjectImpl.getViewDef().getFullName())) {
                                if ((l & (long)2) == 0L) {
                                    viewRowSetImpl.setForwardOnly(true);
                                } else {
                                    viewRowSetImpl.setAssociationConsistent(true);
                                }
                                if (viewRowSetImpl.hasNext()) {
                                    if (xmlOutput == null) {
                                        element = document.createElement(string);
                                        viewObjectImpl.appendXMLElementNodes(viewRowSetImpl, document, element, n2, l, hashMap);
                                    } else {
                                        element = (Element)xmlOutput.writeObject(viewRowSetImpl, new XmlInterfaceCriteria(n2, l, hashMap));
                                    }
                                    if (!element.hasChildNodes()) {
                                        element = null;
                                    }
                                } else if (bl || attributeDefImpl.getProperty("XML_EXPLICIT_NULL") != null) {
                                    element = document.createElement(string);
                                    element.setAttribute("null", "true");
                                }
                                viewRowSetImpl.close();
                                break;
                            }
                            break block21;
                        }
                        default: {
                            element = this.renderAttributeInXMLElement(document, attributeDefImpl, bl, by);
                        }
                    }
                }
                if (element != null) {
                    node.appendChild(element);
                }
            }
            ++n3;
        }
    }

    Object getAttributeInternal(int n, byte by) {
        try {
            this.useInner();
            Object object = this.mInner.getAttributeInternal(n, by);
            Object var5_4 = null;
            this.releaseInner();
            return object;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.releaseInner();
            throw throwable;
        }
    }

    byte getViewRowState() {
        try {
            this.useInner();
            byte by = this.mInner.getViewRowState();
            Object var3_2 = null;
            this.releaseInner();
            return by;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseInner();
            throw throwable;
        }
    }

    public void writeAsXml(XmlOutput xmlOutput, Node node, Criteria criteria, byte by) {
        ViewObjectImpl viewObjectImpl = (ViewObjectImpl)this.getViewObject();
        String string = this.getViewDef().getFullName();
        HashMap hashMap = null;
        int n = -2;
        long l = 0L;
        if (criteria instanceof XmlInterfaceCriteria) {
            XmlInterfaceCriteria xmlInterfaceCriteria = (XmlInterfaceCriteria)criteria;
            n = xmlInterfaceCriteria.getDepthCount();
            l = xmlInterfaceCriteria.getRowOptions();
            hashMap = xmlInterfaceCriteria.getAttributeMap();
        }
        hashMap = ViewRowImpl.validateVOAttrXMLRules(string, hashMap);
        this.writeToXmlDocument(xmlOutput, node.getOwnerDocument(), node, n, l, hashMap, viewObjectImpl.getViewAttrDefsFromNames((String[])hashMap.get((Object)string)), by);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

