/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.server;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import java.sql.ResultSet;
import java.util.Locale;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import oracle.jbo.AttributeDef;
import oracle.jbo.AttributeList;
import oracle.jbo.InvalidAttrKindException;
import oracle.jbo.InvalidObjNameException;
import oracle.jbo.JboException;
import oracle.jbo.NameClashException;
import oracle.jbo.NoDefException;
import oracle.jbo.NoObjException;
import oracle.jbo.PersistenceException;
import oracle.jbo.ReadOnlyViewObjectException;
import oracle.jbo.RowCreateException;
import oracle.jbo.StructureDef;
import oracle.jbo.VariableValueManager;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.JBOClass;
import oracle.jbo.common.JboEnvUtil;
import oracle.jbo.common.JboNameUtil;
import oracle.jbo.common.NamedObjectImpl;
import oracle.jbo.common.PropertyMetadata;
import oracle.jbo.common.StringManager;
import oracle.jbo.mom.xml.DefElement;
import oracle.jbo.mom.xml.DefNode;
import oracle.jbo.server.AssociationDefImpl;
import oracle.jbo.server.AssociationEnd;
import oracle.jbo.server.AttributeDefImpl;
import oracle.jbo.server.ComponentObjectImpl;
import oracle.jbo.server.DefObject;
import oracle.jbo.server.EntityAssociation;
import oracle.jbo.server.EntityAssociationReference;
import oracle.jbo.server.EntityDefImpl;
import oracle.jbo.server.EntityDefOverRowSet;
import oracle.jbo.server.EntityImpl;
import oracle.jbo.server.EntityReference;
import oracle.jbo.server.GlueCodeGen;
import oracle.jbo.server.MapInfo;
import oracle.jbo.server.MetaObjectManager;
import oracle.jbo.server.QueryCollection;
import oracle.jbo.server.RowDef;
import oracle.jbo.server.StmtWithBindVars;
import oracle.jbo.server.ViewAttributeDefImpl;
import oracle.jbo.server.ViewLinkDefImpl;
import oracle.jbo.server.ViewObjectImpl;
import oracle.jbo.server.ViewRowImpl;
import oracle.jbo.server.ViewRowSetImpl;

public class ViewDefImpl
extends RowDef
implements StructureDef {
    static final byte FETCH_UNINITIALIZED = -1;
    static final byte FETCH_AS_NEEDED = 0;
    static final byte FETCH_ALL = 1;
    static final byte FETCH_DEFAULT = 2;
    static final String XML_FETCH_AS_NEEDED = "FETCH_AS_NEEDED";
    static final String XML_FETCH_ALL = "FETCH_ALL";
    static final String XML_FETCH_DEFAULT = "FETCH_DEFAULT";
    static final int MAX_FETCH_UNLIMITED = -1;
    static final int MAX_FETCH_DEFAULT = -2;
    static final short DEFAULT_FETCH_SIZE = 1;
    static final String XML_MAX_FETCH_UNLIMITED = "MAX_FETCH_UNLIMITED";
    static final String XML_MAX_FETCH_DEFAULT = "MAX_FETCH_DEFAULT";
    static final HashMap XML_FETCH_MODE_TABLE;
    static final HashMap XML_MAX_FETCH_SIZE_TABLE;
    public static final int CLAUSE_GENERATE_RT = 1;
    public static final int CLAUSE_ADDITIVE = 2;
    private static final short[] NODETYPES_TEXT_CDATA;
    private static final String XML_ENUM_PASSIVATE_ALL = "All";
    private static final String XML_ENUM_PASSIVATE_NONE = "None";
    static final byte PASSIVATE_DEFAULT = 0;
    static final byte PASSIVATE_TRANISENTS_TOO = 1;
    static final byte PASSIVATE_DISABLED = 2;
    private static byte mDefaultFetchMode;
    static final int DEF_RESOLVE_EREFS_ATTRS = 1;
    static final int DEF_RESOLVE_DONE = 2;
    boolean mHasAllEOPKs;
    private ArrayList mEOInfoRefs;
    ViewAttributeDefImpl[] mEORefAttrs;
    private boolean mEOHasDiscrColumns;
    HashMap mEDefToVOAttrsMap;
    HashMap mEAttrToVOAttrsMap;
    ArrayList mKeyAttrs;
    ArrayList mAttrRefs;
    HashMap mViewLinkAccessors;
    ArrayList mViewLinkAccessorList;
    EntityAssociationReference[] mEOAssocRefs;
    private String mQueryStr;
    private boolean mFullSql;
    private boolean mQueryThruEntity;
    Class mRowClass;
    ArrayList mPrimaryKeys;
    MapInfo[] mMapInfo;
    private int mCalcAttrCount;
    int mSelectFlags;
    int mFromFlags;
    int mWhereFlags;
    String mSelect;
    String mFrom;
    String mWhere;
    private String mOrderBy;
    private String mOptimizerHint;
    private ArrayList mAssocBindVars;
    byte mPassivate;
    private boolean mFetchAhead;
    private boolean mCallOut;
    private boolean mReadOnly;
    private boolean mDefaultVO;
    int mDefResolved;
    private boolean mViewLinksResolved;
    private HashMap mTempEOInfoRefsVTable;
    private HashMap mTempAttrRefsVTable;
    private int mTempAttrIndex;
    private int mNumInheritedAttrs;
    private short mRefIndex;
    private short mNumInheritedERefs;
    private byte mFetchMode;
    private short mFetchSize;
    private int mMaxFetchSize;
    private boolean mUseGlueCode;
    private int mIterMode;
    private boolean mViewLinkAccessorRetained;
    private int mMaxRowsPerNode;
    private int mMaxActiveNodes;
    private String mEJBHomeJNDIName;
    private String mEJBAppProviderURL;
    private Object mEJBHome;
    private boolean mIsFinderView;
    private String mRowClientProxyClassName;
    private String mRowInterfaceName;
    private boolean mHasLongDataType;
    private ArrayList mTempEntityAssocs;
    private static /* synthetic */ Class class$oracle$jbo$server$ViewObjectImpl;
    private static /* synthetic */ Class class$oracle$jbo$server$ViewRowImpl;
    private static /* synthetic */ Class class$oracle$jbo$server$ViewDefImpl;

    static {
        NODETYPES_TEXT_CDATA = new short[]{3, 4};
        XML_FETCH_MODE_TABLE = new HashMap(5);
        XML_FETCH_MODE_TABLE.put((Object)XML_FETCH_AS_NEEDED, (Object)new Byte(0));
        XML_FETCH_MODE_TABLE.put((Object)XML_FETCH_ALL, (Object)new Byte(1));
        XML_FETCH_MODE_TABLE.put((Object)XML_FETCH_DEFAULT, (Object)new Byte(2));
        XML_MAX_FETCH_SIZE_TABLE = new HashMap(5);
        XML_MAX_FETCH_SIZE_TABLE.put((Object)XML_MAX_FETCH_UNLIMITED, (Object)new Integer(-1));
        XML_MAX_FETCH_SIZE_TABLE.put((Object)XML_MAX_FETCH_DEFAULT, (Object)new Integer(-2));
        mDefaultFetchMode = (byte)-1;
    }

    private /* synthetic */ void $init$() {
        this.mHasAllEOPKs = true;
        this.mEOInfoRefs = new ArrayList(4);
        this.mEORefAttrs = null;
        this.mEOHasDiscrColumns = false;
        this.mEDefToVOAttrsMap = null;
        this.mEAttrToVOAttrsMap = null;
        this.mKeyAttrs = null;
        this.mAttrRefs = new ArrayList(20);
        this.mViewLinkAccessors = new HashMap(4);
        this.mViewLinkAccessorList = new ArrayList(4);
        this.mEOAssocRefs = null;
        this.mQueryStr = null;
        this.mFullSql = false;
        this.mQueryThruEntity = false;
        this.mPrimaryKeys = new ArrayList(4);
        this.mMapInfo = null;
        this.mCalcAttrCount = 0;
        this.mSelectFlags = 0;
        this.mFromFlags = 0;
        this.mWhereFlags = 0;
        this.mAssocBindVars = null;
        this.mPassivate = 0;
        this.mFetchAhead = true;
        this.mCallOut = true;
        this.mReadOnly = true;
        this.mDefaultVO = false;
        this.mDefResolved = 0;
        this.mViewLinksResolved = false;
        this.mTempEOInfoRefsVTable = null;
        this.mTempAttrRefsVTable = null;
        this.mTempAttrIndex = 0;
        this.mNumInheritedAttrs = 0;
        this.mRefIndex = 0;
        this.mNumInheritedERefs = 0;
        this.mFetchSize = 1;
        this.mMaxFetchSize = -1;
        this.mUseGlueCode = true;
        this.mIterMode = 1;
        this.mViewLinkAccessorRetained = false;
        this.mMaxRowsPerNode = -1;
        this.mMaxActiveNodes = -1;
        this.mEJBHomeJNDIName = null;
        this.mEJBAppProviderURL = null;
        this.mEJBHome = null;
        this.mIsFinderView = false;
        this.mHasLongDataType = false;
        this.mTempEntityAssocs = null;
    }

    protected ViewDefImpl() {
        this.$init$();
        if (mDefaultFetchMode == -1) {
            String string = PropertyMetadata.ENV_FETCH_MODE.getProperty();
            if (string == null) {
                mDefaultFetchMode = 0;
            } else if ((string = string.toUpperCase()).equals("AS.NEEDED")) {
                mDefaultFetchMode = 0;
            } else if (string.equals("ALL")) {
                mDefaultFetchMode = 1;
            } else if (string.equals("DEFAULT")) {
                mDefaultFetchMode = (byte)2;
            } else {
                if (Diagnostic.isOn()) {
                    Diagnostic.println("Fetch mode environment value [" + string + "] is not recognized");
                }
                mDefaultFetchMode = 0;
            }
            if (Diagnostic.isOn()) {
                Diagnostic.println("ViewObjectImpl's default fetch mode = " + mDefaultFetchMode);
            }
        }
        this.mFetchMode = mDefaultFetchMode;
        this.setAliasName("");
    }

    public ViewDefImpl(String string) {
        this();
        this.setName(string);
    }

    static ViewDefImpl findDefObjectNoSub(String string) {
        Class clazz = class$oracle$jbo$server$ViewDefImpl;
        if (clazz == null) {
            clazz = class$oracle$jbo$server$ViewDefImpl = ViewDefImpl.class$("oracle.jbo.server.ViewDefImpl");
        }
        return (ViewDefImpl)MetaObjectManager.findMetaObject(string, 11, clazz, false);
    }

    public static ViewDefImpl findDefObject(String string) {
        Class clazz = class$oracle$jbo$server$ViewDefImpl;
        if (clazz == null) {
            clazz = class$oracle$jbo$server$ViewDefImpl = ViewDefImpl.class$("oracle.jbo.server.ViewDefImpl");
        }
        return (ViewDefImpl)MetaObjectManager.findMetaObject(string, 11, clazz, true);
    }

    public static int getMaxAttrConst(String string) {
        ViewDefImpl viewDefImpl;
        if (string != null && (viewDefImpl = ViewDefImpl.findDefObjectNoSub(string)) != null) {
            return viewDefImpl.getAttributeCount();
        }
        return 0;
    }

    protected AttributeDefImpl[] getAttributeDefImpls() {
        this.resolveDefObject();
        this.processViewLinkAccessors();
        return (ViewAttributeDefImpl[])this.mAttrRefs.toArray((Object[])new ViewAttributeDefImpl[this.mAttrRefs.size()]);
    }

    public AttributeDef[] getAttributeDefs() {
        return this.getAttributeDefImpls();
    }

    public AttributeDef findAttributeDef(String string) {
        AttributeDef attributeDef = this.lookupAttributeDef(string);
        if (attributeDef != null) {
            return attributeDef;
        }
        throw new NoDefException(131, string, this.getName());
    }

    public AttributeDef lookupAttributeDef(String string) {
        string = string.intern();
        int n = 0;
        while (n < this.mAttrRefs.size()) {
            if (((ViewAttributeDefImpl)this.mAttrRefs.get(n)).getName() == string) {
                return (AttributeDef)this.mAttrRefs.get(n);
            }
            ++n;
        }
        Object object = this.mViewLinkAccessors.get((Object)string);
        if (object != null && object instanceof TempViewLinkAccr && object instanceof TempViewLinkAccr) {
            this.mViewLinkAccessorList.remove(this.mViewLinkAccessorList.indexOf((Object)string));
        }
        return null;
    }

    void setViewAttributeDefImpls(ViewAttributeDefImpl[] viewAttributeDefImplArray) {
        this.mAttrRefs.clear();
        int n = 0;
        while (n < viewAttributeDefImplArray.length) {
            this.mAttrRefs.add((Object)viewAttributeDefImplArray[n]);
            ++n;
        }
        this.resolveDefObject();
    }

    void setViewAttributeDefImpls(ArrayList arrayList) {
        this.mAttrRefs = arrayList;
        this.resolveDefObject();
    }

    protected EntityReference[] getEntityReferences() {
        if (this.mEOInfoRefs.size() == 0) {
            return null;
        }
        return (EntityReference[])this.mEOInfoRefs.toArray((Object[])new EntityReference[this.mEOInfoRefs.size()]);
    }

    public boolean isManageRowsByKey() {
        return this.mEOInfoRefs.size() > 0;
    }

    protected EntityReference getEntityReference(String string) {
        int n = 0;
        while (n < this.mEOInfoRefs.size()) {
            EntityReference entityReference = (EntityReference)this.mEOInfoRefs.get(n);
            if (entityReference.getName().equalsIgnoreCase(string)) {
                return entityReference;
            }
            ++n;
        }
        return null;
    }

    protected EntityReference getEntityReference(int n) {
        if (n >= 0 && n < this.mEOInfoRefs.size()) {
            return (EntityReference)this.mEOInfoRefs.get(n);
        }
        return null;
    }

    void setEntityReferences(EntityReference[] entityReferenceArray) {
        this.mEOInfoRefs.clear();
        int n = 0;
        while (n < entityReferenceArray.length) {
            EntityReference entityReference = entityReferenceArray[n];
            if (entityReference.getOrderIndex() < 0) {
                entityReference.setOrderIndex(n);
            }
            this.mEOInfoRefs.add((Object)entityReference);
            entityReference.setParent(this);
            if (entityReference.hasDiscrColumns()) {
                this.mEOHasDiscrColumns = true;
            }
            ++n;
        }
    }

    ViewAttributeDefImpl[] getEntityReferenceAttributes() {
        this.processEntityAssociations();
        return this.mEORefAttrs;
    }

    EntityAssociationReference[] getEntityAssociationReferences() {
        this.processEntityAssociations();
        return this.mEOAssocRefs;
    }

    void setEntityAssociationReferences(EntityAssociationReference[] entityAssociationReferenceArray) {
        this.mEOAssocRefs = entityAssociationReferenceArray;
    }

    StmtWithBindVars getQueryStmt(int n) {
        if (!this.isFullSql() && this.mQueryStr == null) {
            String string;
            StringBuffer stringBuffer = new StringBuffer(100);
            stringBuffer.append("SELECT ");
            if (this.mOptimizerHint != null) {
                stringBuffer.append("/*+ ").append(this.mOptimizerHint).append(" */ ");
            }
            if ((string = this.getSelectClause()) != null && string.length() > 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(" FROM ");
            String string2 = this.getFromClause();
            if (string2 != null && string2.length() > 0) {
                stringBuffer.append(string2);
            }
            StmtWithBindVars stmtWithBindVars = this.getWhereClause(n);
            n = stmtWithBindVars.mNoBindVars;
            if (stmtWithBindVars.mStmt.length() > 0) {
                stringBuffer.append(" WHERE ").append(this.mWhere);
            }
            if (this.mOrderBy != null && this.mOrderBy.length() > 0) {
                stringBuffer.append(" ORDER BY ").append(this.mOrderBy);
            }
            this.mQueryStr = stringBuffer.toString();
        }
        return new StmtWithBindVars(this.mQueryStr, n);
    }

    public String getQuery() {
        return this.mQueryStr;
    }

    public void setQuery(String string) {
        this.setSelectClause(null);
        this.setFromClause(null);
        this.setWhereClause(null);
        if (string == null || string.trim().length() == 0) {
            this.setFullSql(false);
        } else {
            this.setFullSql(true);
        }
        this.mQueryStr = string;
    }

    public void setQueryHint(String string) {
        this.mOptimizerHint = string;
    }

    public String getQueryHint() {
        return this.mOptimizerHint;
    }

    int getEntityIndex(EntityReference entityReference) {
        int n = 0;
        while (n < this.mEOInfoRefs.size()) {
            if ((EntityReference)this.mEOInfoRefs.get(n) == entityReference) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    int getEntityDefCount() {
        return this.mEOInfoRefs.size();
    }

    EntityDefImpl getEntityDef(int n) {
        return ((EntityReference)this.mEOInfoRefs.get(n)).getEntityDef();
    }

    EntityDefImpl[] getEntityDefs() {
        int n = this.getEntityDefCount();
        if (n == 0) {
            return null;
        }
        EntityDefImpl[] entityDefImplArray = new EntityDefImpl[n];
        int n2 = 0;
        while (n2 < n) {
            entityDefImplArray[n2] = this.getEntityDef(n2);
            ++n2;
        }
        return entityDefImplArray;
    }

    EntityDefImpl getEntityDef(String string) {
        int n = this.getEntityDefCount();
        int n2 = 0;
        while (n2 < n) {
            EntityDefImpl entityDefImpl = this.getEntityDef(n2);
            if (entityDefImpl.getFullName().equalsIgnoreCase(string)) {
                return entityDefImpl;
            }
            ++n2;
        }
        return null;
    }

    MapInfo[] getMapInfo() {
        if (this.mMapInfo == null) {
            this.createMap();
        }
        return this.mMapInfo;
    }

    public int getCalculatedAttributeCount() {
        if (this.mMapInfo == null) {
            this.createMap();
        }
        return this.mCalcAttrCount;
    }

    AttributeDefImpl[] getPrimaryKeys() {
        return (AttributeDefImpl[])this.mPrimaryKeys.toArray((Object[])new AttributeDefImpl[this.mPrimaryKeys.size()]);
    }

    public int getAttributeCount() {
        int n = this.prepareViewLinkAccessors();
        return this.mAttrRefs.size() + n;
    }

    public AttributeDef getAttributeDef(int n) {
        this.resolveDefObject();
        this.processViewLinkAccessors();
        return (AttributeDef)this.mAttrRefs.get(n);
    }

    public void setRowClass(Class clazz) {
        this.mRowClass = clazz;
    }

    public Class getRowClass() {
        Class clazz;
        if (this.mRowClass != null) {
            clazz = this.mRowClass;
        } else {
            clazz = class$oracle$jbo$server$ViewRowImpl;
            if (clazz == null) {
                clazz = class$oracle$jbo$server$ViewRowImpl = ViewDefImpl.class$("oracle.jbo.server.ViewRowImpl");
            }
        }
        return clazz;
    }

    public String getRowClientProxyClassName() {
        return this.mRowClientProxyClassName;
    }

    protected void setRowClientProxyClassName(String string) {
        this.mRowClientProxyClassName = string;
    }

    public String getRowInterfaceName() {
        return this.mRowInterfaceName;
    }

    protected void setRowInterfaceName(String string) {
        this.mRowInterfaceName = string;
    }

    protected String getEffectiveRowClientProxyClassName() {
        if (this.mRowClientProxyClassName != null) {
            return this.mRowClientProxyClassName;
        }
        ViewDefImpl viewDefImpl = (ViewDefImpl)this.getBaseDefObject();
        if (viewDefImpl != null) {
            return viewDefImpl.getEffectiveRowClientProxyClassName();
        }
        return null;
    }

    ViewRowImpl newInstance(int[] nArray, EntityImpl[] entityImplArray, ViewObjectImpl viewObjectImpl, ViewRowSetImpl viewRowSetImpl, AttributeList attributeList) {
        if (viewObjectImpl.isReadOnly()) {
            throw new ReadOnlyViewObjectException(viewObjectImpl.getName());
        }
        ViewRowImpl viewRowImpl = this.createBlankInstance(nArray, entityImplArray, viewObjectImpl, viewRowSetImpl.getQueryCollection(), null, attributeList, true);
        int n = 0;
        while (n < viewRowImpl.getEntityCount()) {
            boolean bl = true;
            if (n > 0 && !this.getEntityReference(n).isInsertParticipant()) {
                viewRowImpl.updateReference(n, null);
            } else {
                if (nArray == null) {
                    if (entityImplArray != null && entityImplArray.length > n && entityImplArray[n] != null) {
                        bl = false;
                    }
                } else {
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        if (nArray[n2] == n && entityImplArray[n2] != null) {
                            bl = false;
                            break;
                        }
                        ++n2;
                    }
                }
                if (bl) {
                    viewRowImpl.getEntity(n).initDefaults();
                }
            }
            ++n;
        }
        viewRowImpl.initDefaults();
        return viewRowImpl;
    }

    ViewRowImpl createInstanceFromResultSet(ViewObjectImpl viewObjectImpl, QueryCollection queryCollection, ResultSet resultSet) {
        ViewRowImpl viewRowImpl = this.createBlankInstance(null, null, viewObjectImpl, queryCollection, this.mEOHasDiscrColumns ? resultSet : null, null, false);
        if (viewRowImpl != null) {
            viewRowImpl.populate(resultSet);
        }
        return viewRowImpl;
    }

    ViewRowImpl createInstanceFromResultSet(ViewObjectImpl viewObjectImpl, QueryCollection queryCollection, ResultSet resultSet, boolean bl) {
        ViewRowImpl viewRowImpl = this.createBlankInstance(null, null, viewObjectImpl, queryCollection, this.mEOHasDiscrColumns ? resultSet : null, null, false);
        if (viewRowImpl != null) {
            viewRowImpl.populate(resultSet);
        }
        return viewRowImpl;
    }

    ViewRowImpl createBlankInstance(int[] nArray, EntityImpl[] entityImplArray, ViewObjectImpl viewObjectImpl, QueryCollection queryCollection, ResultSet resultSet, AttributeList attributeList, boolean bl) {
        try {
            ViewRowImpl viewRowImpl = this.mRowClass == null ? new ViewRowImpl() : (ViewRowImpl)this.getRowClass().newInstance();
            ViewRowImpl viewRowImpl2 = viewRowImpl = viewRowImpl.init(nArray, entityImplArray, this, queryCollection, resultSet, attributeList, bl);
            return viewRowImpl2;
        }
        catch (InstantiationException instantiationException) {
            throw new RowCreateException(false, viewObjectImpl.getName(), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RowCreateException(false, viewObjectImpl.getName(), illegalAccessException);
        }
    }

    public void setComponentClass(Class clazz) {
        this.mComponentClass = clazz;
    }

    public Class getComponentClass() {
        Class clazz;
        if (this.mComponentClass != null) {
            clazz = this.mComponentClass;
        } else {
            clazz = class$oracle$jbo$server$ViewObjectImpl;
            if (clazz == null) {
                clazz = class$oracle$jbo$server$ViewObjectImpl = ViewDefImpl.class$("oracle.jbo.server.ViewObjectImpl");
            }
        }
        return clazz;
    }

    String getFullAttributeDefImplName(int n) {
        return this.getFullAttributeDefImplName((ViewAttributeDefImpl)this.mAttrRefs.get(n));
    }

    String getFullAttributeDefImplName(ViewAttributeDefImpl viewAttributeDefImpl) {
        return viewAttributeDefImpl.getEntityReference().getName() + "." + viewAttributeDefImpl.getAttributeDefImpl().getName();
    }

    public int getSelectClauseFlags() {
        return this.mSelectFlags;
    }

    public void setSelectClauseFlags(int n) {
        if (this.mSelectFlags != n) {
            boolean bl = (this.mSelectFlags & 1) != 0;
            boolean bl2 = (n & 1) != 0;
            this.mSelectFlags = n;
            if (!this.isFullSql() && !bl && bl2) {
                this.mSelect = null;
            }
        }
    }

    public int getFromClauseFlags() {
        return this.mFromFlags;
    }

    public void setFromClauseFlags(int n) {
        if (this.mFromFlags != n) {
            boolean bl = (this.mFromFlags & 1) != 0;
            boolean bl2 = (n & 1) != 0;
            this.mFromFlags = n;
            if (!this.isFullSql() && !bl && bl2) {
                this.mFrom = null;
            }
        }
    }

    public int getWhereClauseFlags() {
        return this.mWhereFlags;
    }

    public void setWhereClauseFlags(int n) {
        if (this.mWhereFlags != n) {
            boolean bl = (this.mWhereFlags & 1) != 0;
            boolean bl2 = (n & 1) != 0;
            this.mWhereFlags = n;
            if (!this.isFullSql() && !bl && bl2) {
                this.mWhere = null;
            }
        }
    }

    public String getSelectClause() {
        if (this.mSelect == null) {
            this.mSelect = !this.isFullSql() && (this.mSelectFlags & 1) != 0 && this.getEntityDefCount() > 0 ? ViewDefImpl.buildDefaultSelect(this.getAttributeDefs()) : "";
        }
        return this.mSelect;
    }

    public void setSelectClause(String string) {
        this.mSelect = string;
    }

    public String getFromClause() {
        if (this.mFrom == null) {
            this.mFrom = !this.isFullSql() && (this.mFromFlags & 1) != 0 && this.getEntityDefCount() > 0 ? this.buildDefaultFrom() : "";
        }
        return this.mFrom;
    }

    public void setFromClause(String string) {
        this.mFrom = string;
    }

    protected StmtWithBindVars getWhereClause(int n) {
        if (this.mWhere == null) {
            this.mWhere = !this.isFullSql() && (this.mWhereFlags & 1) != 0 && this.getEntityDefCount() > 1 ? this.buildDefaultWhere() : "";
        }
        StmtWithBindVars stmtWithBindVars = new StmtWithBindVars(this.mWhere, n);
        return stmtWithBindVars;
    }

    public void setWhereClause(String string) {
        this.mWhere = string;
    }

    public String getOrderByClause() {
        return this.mOrderBy;
    }

    public void setOrderByClause(String string) {
        this.mOrderBy = string;
    }

    private void createMap() {
        MapInfo[] mapInfoArray = new MapInfo[this.mAttrRefs.size()];
        int n = 0;
        int n2 = this.mAttrRefs.size();
        int n3 = 0;
        while (n3 < n2) {
            int n4;
            int n5;
            ViewAttributeDefImpl viewAttributeDefImpl = (ViewAttributeDefImpl)this.mAttrRefs.get(n3);
            AttributeDefImpl attributeDefImpl = viewAttributeDefImpl.getAttributeDefImpl();
            int n6 = attributeDefImpl != null ? (int)attributeDefImpl.getAttributeKind() : -1;
            switch (n6) {
                case -1: 
                case 2: 
                case 6: {
                    n5 = n++;
                    n4 = -1;
                    break;
                }
                case 0: 
                case 1: {
                    int n7 = this.mEOInfoRefs.size();
                    int n8 = 0;
                    while (n8 < n7) {
                        if ((EntityReference)this.mEOInfoRefs.get(n8) == viewAttributeDefImpl.getEntityReference()) break;
                        ++n8;
                    }
                    n5 = attributeDefImpl.getIndex();
                    n4 = n8;
                    break;
                }
                case 3: {
                    int n9 = this.mEOInfoRefs.size();
                    int n10 = 0;
                    while (n10 < n9) {
                        if ((EntityReference)this.mEOInfoRefs.get(n10) == viewAttributeDefImpl.getEntityReference()) break;
                        ++n10;
                    }
                    if (n10 < n9) {
                        n5 = attributeDefImpl.getIndex();
                        n4 = n10;
                        break;
                    }
                    n5 = n++;
                    n4 = -1;
                    break;
                }
                default: {
                    throw new InvalidAttrKindException(viewAttributeDefImpl.getName());
                }
            }
            mapInfoArray[n3] = new MapInfo(n5, n4);
            ++n3;
        }
        this.mCalcAttrCount = n;
        this.mMapInfo = mapInfoArray;
    }

    private String entityAssociationsToSQL() {
        if (this.mEOAssocRefs == null || this.mEOAssocRefs.length == 0) {
            return "";
        }
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < this.mEOAssocRefs.length) {
            EntityAssociation entityAssociation = this.mEOAssocRefs[n2].getEntityAssociation();
            String string = this.mEOAssocRefs[n2].getEntityReference().getName() + ".";
            String string2 = this.mEOAssocRefs[n2].getOtherEntityReference().getName() + ".";
            AttributeDefImpl[] attributeDefImplArray = entityAssociation.getAttributeDefImpls();
            AttributeDefImpl[] attributeDefImplArray2 = entityAssociation.getOtherAttributeDefImpls();
            int n3 = 0;
            while (n3 < attributeDefImplArray.length) {
                if (n++ > 0) {
                    stringBuffer.append(" AND ");
                }
                stringBuffer.append(string).append(attributeDefImplArray[n3].getColumnName()).append(" = ").append(string2).append(attributeDefImplArray2[n3].getColumnName());
                ++n3;
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public String buildDefaultFrom() {
        EntityReference[] entityReferenceArray = this.getEntityReferences();
        StringBuffer stringBuffer = new StringBuffer();
        if (entityReferenceArray == null || entityReferenceArray.length == 0) {
            return "";
        }
        this.processEntityAssociations();
        int n = 0;
        int n2 = 0;
        while (n2 < entityReferenceArray.length) {
            AssociationEnd associationEnd;
            EntityAssociationReference entityAssociationReference;
            if (n++ > 0) {
                stringBuffer.append(", ");
            }
            EntityReference entityReference = entityReferenceArray[n2];
            stringBuffer.append(entityReference.getEntityDef().getSource()).append(" ").append(entityReference.getName());
            ArrayList arrayList = entityReference.getAssociationReferencesList();
            if (arrayList != null && arrayList.size() > 0 && (entityAssociationReference = (EntityAssociationReference)arrayList.get(0)) != null && entityAssociationReference.getOtherEntityReference() == entityReference && (associationEnd = entityAssociationReference.getEntityAssociation().findEndByName(entityAssociationReference.getOtherEndName())) != null) {
                associationEnd.appendIntersectFrom(stringBuffer);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    private String buildDefaultWhere() {
        this.processEntityAssociations();
        return this.entityAssociationsToSQL();
    }

    private void addToAssocBindVars(EntityReference entityReference, AttributeDefImpl[] attributeDefImplArray) {
        if (attributeDefImplArray == null) {
            return;
        }
        String string = entityReference.getName() + ".";
        int n = 0;
        while (n < attributeDefImplArray.length) {
            this.mAssocBindVars.add((Object)(string + attributeDefImplArray[n].getName()));
            ++n;
        }
    }

    public byte getFetchMode() {
        return this.mFetchMode;
    }

    public void setFetchMode(byte by) {
        switch (by) {
            case 2: {
                this.mFetchMode = 0;
                break;
            }
            case 0: 
            case 1: {
                this.mFetchMode = by;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public short getFetchSize() {
        return this.mFetchSize;
    }

    public void setFetchSize(short s) {
        if (s <= 0) {
            throw new IllegalArgumentException();
        }
        this.mFetchSize = s;
    }

    public int getMaxFetchSize() {
        return this.mMaxFetchSize;
    }

    public void setMaxFetchSize(int n) {
        if (n < -1) {
            throw new IllegalArgumentException();
        }
        this.mMaxFetchSize = n;
    }

    public boolean isUseGlueCode() {
        return this.mUseGlueCode;
    }

    public void setUseGlueCode(boolean bl) {
        this.mUseGlueCode = bl;
    }

    public void setMaxRowsPerNode(int n) {
        this.mMaxRowsPerNode = n;
    }

    public int getMaxRowsPerNode() {
        if (this.mMaxRowsPerNode < 0) {
            return ViewObjectImpl.mDefaultMaxRowsPerNode;
        }
        if (this.mMaxRowsPerNode < 5) {
            return 5;
        }
        return this.mMaxRowsPerNode;
    }

    public void setMaxActiveNodes(int n) {
        this.mMaxActiveNodes = n;
    }

    public int getMaxActiveNodes() {
        if (this.mMaxActiveNodes < 0) {
            return !ViewObjectImpl.mUsePersColl ? -1 : ViewObjectImpl.mDefaultMaxActiveNodes;
        }
        if (this.mMaxActiveNodes < 2) {
            return 2;
        }
        return this.mMaxActiveNodes;
    }

    void setCallOut(boolean bl) {
        this.mCallOut = bl;
    }

    boolean getCallOut() {
        return this.mCallOut;
    }

    protected boolean hasPrimaryEntity() {
        return this.mEOInfoRefs.size() > 0;
    }

    protected void finishedLoading() {
        if (this.mUseGlueCode) {
            if (Diagnostic.isOn()) {
                Diagnostic.println("ViewDef: " + this.getFullName() + " using glue class");
            }
            this.generateGlueClass();
        }
    }

    static ViewDefImpl loadFromXML(DefElement defElement) {
        ViewDefImpl viewDefImpl = null;
        Object var2_2 = null;
        Class clazz = null;
        String string = defElement.readString("DefClass");
        if (string != null) {
            Class clazz2 = class$oracle$jbo$server$ViewDefImpl;
            if (clazz2 == null) {
                clazz2 = class$oracle$jbo$server$ViewDefImpl = ViewDefImpl.class$("oracle.jbo.server.ViewDefImpl");
            }
            clazz = JBOClass.findCustomClass(string, clazz2);
            try {
                viewDefImpl = (ViewDefImpl)clazz.newInstance();
            }
            catch (Exception exception) {
                PersistenceException persistenceException = new PersistenceException("26000", null);
                persistenceException.addToDetails(exception);
                throw persistenceException;
            }
        } else {
            viewDefImpl = new ViewDefImpl();
        }
        ViewDefImpl.loadFromXML(defElement, viewDefImpl, null);
        viewDefImpl.resolveDefObject();
        return viewDefImpl;
    }

    protected void resolveReferences() {
        Class clazz;
        if (!this.mUseGlueCode && (clazz = this.mRowClass) != null) {
            int n = 0;
            while (n < this.mAttrRefs.size()) {
                ((ViewAttributeDefImpl)this.mAttrRefs.get(n)).initAccessors(clazz);
                ++n;
            }
        }
    }

    private void generateGlueClass() {
        if (this.mRowClass != null) {
            Class clazz = class$oracle$jbo$server$ViewRowImpl;
            if (clazz == null) {
                clazz = class$oracle$jbo$server$ViewRowImpl = ViewDefImpl.class$("oracle.jbo.server.ViewRowImpl");
            }
            if (this.mRowClass != clazz) {
                String string = this.mRowClass.getName() + "__Glue__";
                Class clazz2 = GlueCodeGen.loadClass(string, this.mRowClass.getClassLoader());
                if (clazz2 == null) {
                    ArrayList arrayList = new ArrayList(10);
                    ArrayList arrayList2 = new ArrayList(10);
                    ArrayList arrayList3 = new ArrayList(10);
                    ArrayList arrayList4 = new ArrayList(10);
                    ArrayList arrayList5 = new ArrayList(10);
                    ArrayList arrayList6 = new ArrayList(10);
                    int n = 0;
                    while (n < this.mAttrRefs.size()) {
                        ViewAttributeDefImpl viewAttributeDefImpl = (ViewAttributeDefImpl)this.mAttrRefs.get(n);
                        String string2 = "get" + viewAttributeDefImpl.getName();
                        Class clazz3 = viewAttributeDefImpl.getJavaType();
                        Class[] classArray = new Class[]{};
                        Class clazz4 = class$oracle$jbo$server$ViewRowImpl;
                        if (clazz4 == null) {
                            clazz4 = ViewDefImpl.class$("oracle.jbo.server.ViewRowImpl");
                        }
                        if (JboNameUtil.findMethod(this.mRowClass, string2, classArray, clazz4) != null) {
                            arrayList.add((Object)string2);
                            arrayList2.add((Object)new Integer(viewAttributeDefImpl.getIndex()));
                            arrayList3.add((Object)clazz3);
                        }
                        String string3 = "set" + viewAttributeDefImpl.getName();
                        Class[] classArray2 = new Class[]{clazz3};
                        Class clazz5 = class$oracle$jbo$server$ViewRowImpl;
                        if (clazz5 == null) {
                            clazz5 = ViewDefImpl.class$("oracle.jbo.server.ViewRowImpl");
                        }
                        if (JboNameUtil.findMethod(this.mRowClass, string3, classArray2, clazz5) != null) {
                            arrayList4.add((Object)string3);
                            arrayList5.add((Object)new Integer(viewAttributeDefImpl.getIndex()));
                            arrayList6.add((Object)clazz3);
                        }
                        ++n;
                    }
                    Object[] objectArray = new String[arrayList.size()];
                    int[] nArray = new int[arrayList2.size()];
                    Object[] objectArray2 = new Class[arrayList3.size()];
                    Object[] objectArray3 = new String[arrayList4.size()];
                    int[] nArray2 = new int[arrayList5.size()];
                    Object[] objectArray4 = new Class[arrayList6.size()];
                    arrayList.toArray(objectArray);
                    int n2 = 0;
                    while (n2 < arrayList2.size()) {
                        nArray[n2] = (Integer)arrayList2.get(n2);
                        ++n2;
                    }
                    arrayList3.toArray(objectArray2);
                    arrayList4.toArray(objectArray3);
                    int n3 = 0;
                    while (n3 < arrayList5.size()) {
                        nArray2[n3] = (Integer)arrayList5.get(n3);
                        ++n3;
                    }
                    arrayList6.toArray(objectArray4);
                    clazz2 = GlueCodeGen.generateClass(string, this.mRowClass.getName(), "getAttrInvokeAccessor", (String[])objectArray, nArray, (Class[])objectArray2, "getAttributeInternal", "setAttrInvokeAccessor", (String[])objectArray3, nArray2, (Class[])objectArray4, "setAttributeInternal", this.mRowClass.getClassLoader());
                }
                this.mRowClass = clazz2;
            }
        }
    }

    static ViewDefImpl loadFromXML(DefElement defElement, ViewDefImpl viewDefImpl, String string) {
        try {
            String string2;
            String string3;
            String string4;
            String string5;
            String string6;
            if (string == null) {
                string = defElement.readString("Name");
            }
            if ((string6 = defElement.readString("Extends")) != null && string6.length() > 0) {
                viewDefImpl = ViewDefImpl.loadFromXML(MetaObjectManager.loadBaseElement(string6), viewDefImpl, string);
                viewDefImpl.mDefResolved = 0;
                viewDefImpl.mTempAttrIndex = viewDefImpl.getAttributeCount();
                ViewDefImpl viewDefImpl2 = ViewDefImpl.findDefObjectNoSub(string6);
                if (string != null) {
                    viewDefImpl.setName(string);
                }
                viewDefImpl.setBaseDefObject(viewDefImpl2);
            } else if (string != null) {
                viewDefImpl.setName(string);
            }
            viewDefImpl.setMessageBundleClass(defElement.readClassName("MsgBundleClass"));
            viewDefImpl.setFullSql(defElement.readBoolean("CustomQuery"));
            ArrayList arrayList = defElement.getChildrenList("EntityUsage");
            int n = arrayList == null ? 0 : arrayList.size();
            EntityReference[] entityReferenceArray = new EntityReference[n];
            DefElement defElement2 = null;
            int n2 = 0;
            while (n2 < n) {
                defElement2 = (DefElement)arrayList.get(n2);
                viewDefImpl.loadEntityReference(defElement2);
                ++n2;
            }
            String string7 = defElement.readString("BindingStyle");
            int n3 = string7 != null ? (string7.equals("Oracle") ? 1 : (string7.equals("OracleName") ? 2 : 0)) : 0;
            viewDefImpl.setBindingStyle(n3);
            String string8 = defElement.readString("MaxRowsPerNode");
            if (string8 != null) {
                viewDefImpl.setMaxRowsPerNode(new Integer(string8));
            }
            if ((string5 = defElement.readString("MaxActiveNodes")) != null) {
                viewDefImpl.setMaxActiveNodes(new Integer(string5));
            }
            if (!viewDefImpl.isFullSql()) {
                String string9;
                String string10;
                viewDefImpl.mQueryStr = null;
                int n4 = defElement.readInt("SelectListFlags");
                viewDefImpl.setSelectClauseFlags(n4);
                int n5 = defElement.readInt("FromListFlags");
                viewDefImpl.setFromClauseFlags(n5);
                int n6 = defElement.readInt("WhereFlags");
                viewDefImpl.setWhereClauseFlags(n6);
                String string11 = defElement.readString("SelectList");
                if (string11 != null && (n4 & 1) == 0) {
                    viewDefImpl.setSelectClause(string11);
                }
                if ((string10 = defElement.readString("FromList")) != null && (n5 & 1) == 0) {
                    viewDefImpl.setFromClause(string10);
                }
                if ((string9 = defElement.readString("Where")) != null && (n6 & 1) == 0) {
                    viewDefImpl.setWhereClause(string9);
                }
            } else {
                String string12 = null;
                DefElement defElement3 = null;
                ArrayList arrayList2 = defElement.getChildrenList();
                int n7 = arrayList2.size();
                int n8 = 0;
                while (n8 < n7) {
                    defElement3 = (DefElement)arrayList2.get(n8);
                    if (defElement3.getNodeName().equals("SQLQuery")) break;
                    ++n8;
                }
                if (defElement3 != null && (n7 = (arrayList2 = defElement3.getChildrenList(NODETYPES_TEXT_CDATA)).size()) > 0) {
                    DefNode defNode = (DefNode)arrayList2.get(n7 - 1);
                    string12 = defNode.getNodeValue();
                }
                if (string12 != null) {
                    int n9 = 0;
                    while (n9 < string12.length()) {
                        char c = string12.charAt(n9);
                        if (c != '\n' && c != '\r') break;
                        ++n9;
                    }
                    if (n9 > 0) {
                        string12 = string12.substring(n9).trim();
                    }
                    viewDefImpl.setQuery(string12);
                }
            }
            String string13 = defElement.readString("OrderBy");
            if (string13 != null) {
                viewDefImpl.setOrderByClause(string13);
            }
            if ((string4 = defElement.readString("QueryHint")) != null) {
                viewDefImpl.setQueryHint(string4);
            }
            viewDefImpl.loadProperties(defElement);
            String string14 = defElement.readString("ComponentClass");
            if (string14 != null) {
                Class clazz = class$oracle$jbo$server$ViewObjectImpl;
                if (clazz == null) {
                    clazz = class$oracle$jbo$server$ViewObjectImpl = ViewDefImpl.class$("oracle.jbo.server.ViewObjectImpl");
                }
                viewDefImpl.setComponentClass(JBOClass.findCustomClass(string14, clazz));
            }
            if ((string14 = defElement.readString("RowClass")) != null) {
                Class clazz = class$oracle$jbo$server$ViewRowImpl;
                if (clazz == null) {
                    clazz = class$oracle$jbo$server$ViewRowImpl = ViewDefImpl.class$("oracle.jbo.server.ViewRowImpl");
                }
                viewDefImpl.setRowClass(JBOClass.findCustomClass(string14, clazz));
            }
            viewDefImpl.setComponentInterfaceName(defElement.readString("ComponentInterface"));
            viewDefImpl.setClientProxyClassName(defElement.readString("ClientProxyName"));
            viewDefImpl.setRowClientProxyClassName(defElement.readString("ClientRowProxyName"));
            viewDefImpl.setRowInterfaceName(defElement.readString("RowInterface"));
            String string15 = defElement.readString("FetchMode");
            if (string15 != null) {
                try {
                    viewDefImpl.setFetchMode((Byte)XML_FETCH_MODE_TABLE.get((Object)string15));
                }
                catch (Exception exception) {
                    throw new PersistenceException("26005", null);
                }
            }
            if ((string3 = defElement.readString("FetchSize")) != null) {
                try {
                    viewDefImpl.setFetchSize(Short.parseShort(string3));
                }
                catch (Exception exception) {
                    throw new PersistenceException("26006", null);
                }
            }
            if ((string2 = defElement.readString("MaxFetchSize")) != null) {
                try {
                    Integer n10 = (Integer)XML_MAX_FETCH_SIZE_TABLE.get((Object)string2);
                    if (n10 == null) {
                        viewDefImpl.setMaxFetchSize(Integer.parseInt(string2));
                    } else {
                        viewDefImpl.setMaxFetchSize(n10);
                    }
                }
                catch (Exception exception) {
                    throw new PersistenceException("26007", null);
                }
            }
            int n11 = "Full".equals(defElement.readString("PageIterMode")) ? 1 : 0;
            viewDefImpl.setIterMode(n11);
            viewDefImpl.setViewLinkAccessorRetained(defElement.readBoolean("ViewLinkAccessorRetained"));
            viewDefImpl.mEJBHomeJNDIName = defElement.readString("EJBHomeJNDIName");
            viewDefImpl.mEJBAppProviderURL = defElement.readString("EJBAppProviderURL");
            viewDefImpl.mIsFinderView = defElement.readBoolean("IsFinderView");
            boolean bl = defElement.readBoolean("UseGlueCode");
            viewDefImpl.setUseGlueCode(bl);
            viewDefImpl.mPassivate = 0;
            string15 = defElement.readString("Passivate");
            if (string15 != null) {
                if (XML_ENUM_PASSIVATE_ALL.equals(string15)) {
                    viewDefImpl.mPassivate = 1;
                } else if (XML_ENUM_PASSIVATE_NONE.equals(string15)) {
                    viewDefImpl.mPassivate = (byte)2;
                }
            }
            viewDefImpl.loadAttributes(defElement);
            viewDefImpl.loadEntityImports(defElement);
            viewDefImpl.loadKey(defElement);
            viewDefImpl.loadViewLinkAccessors(defElement);
            viewDefImpl.resolveDefInternal();
            viewDefImpl.loadCustomDef(defElement);
            viewDefImpl.lookupEJBHome();
            viewDefImpl.loadVariables(defElement);
            ViewDefImpl viewDefImpl3 = viewDefImpl;
            return viewDefImpl3;
        }
        catch (JboException jboException) {
            throw jboException;
        }
        catch (Exception exception) {
            PersistenceException persistenceException = new PersistenceException("26000", null);
            persistenceException.addToDetails(exception);
            throw persistenceException;
        }
    }

    private EntityReference getEOUsageFromVTable(String string) {
        return this.mTempEOInfoRefsVTable != null ? (EntityReference)this.mTempEOInfoRefsVTable.get((Object)string) : null;
    }

    private void putEOUsageInVTable(EntityReference entityReference) {
        if (this.mTempEOInfoRefsVTable == null) {
            this.mTempEOInfoRefsVTable = new HashMap(4);
        }
        this.mTempEOInfoRefsVTable.put((Object)entityReference.getName(), (Object)entityReference);
    }

    private ViewAttributeDefImpl getAttrDefFromVTable(String string) {
        return this.mTempAttrRefsVTable != null ? (ViewAttributeDefImpl)this.mTempAttrRefsVTable.get((Object)string) : null;
    }

    private void putAttrDefInVTable(ViewAttributeDefImpl viewAttributeDefImpl) {
        if (this.mTempAttrRefsVTable == null) {
            this.mTempAttrRefsVTable = new HashMap(20);
        }
        this.mTempAttrRefsVTable.put((Object)viewAttributeDefImpl.getName(), (Object)viewAttributeDefImpl);
    }

    boolean isDefResolved() {
        return this.mDefResolved == 2;
    }

    public void resolveDefObject() {
        if ((this.mDefResolved & 2) != 2) {
            this.resolveDefInternal();
            this.mDefResolved = 2;
            this.mTempEOInfoRefsVTable = null;
            if (this.mFullSql && this.mAttrRefs.size() == 0) {
                this.mDefResolved = 0;
            }
        }
    }

    void resolveDefInternal() {
        int n;
        if ((this.mDefResolved & 1) == 1) {
            return;
        }
        int n2 = n = this.mTempEOInfoRefsVTable != null ? this.mTempEOInfoRefsVTable.size() : 0;
        if (n > 0) {
            EntityReference[] entityReferenceArray = new EntityReference[n];
            Iterator iterator = this.mTempEOInfoRefsVTable.keySet().iterator();
            while (iterator.hasNext()) {
                EntityReference entityReference;
                entityReferenceArray[entityReference.getOrderIndex()] = entityReference = this.getEOUsageFromVTable((String)iterator.next());
            }
            this.setEntityReferences(entityReferenceArray);
        }
        int n3 = n = this.mTempAttrRefsVTable != null ? this.mTempAttrRefsVTable.size() : 0;
        if (n > 0) {
            this.mAttrRefs.clear();
            JboEnvUtil.setSizeInArrayList(this.mAttrRefs, this.mTempAttrRefsVTable.size());
            Iterator iterator = this.mTempAttrRefsVTable.keySet().iterator();
            ViewAttributeDefImpl viewAttributeDefImpl = null;
            EntityReference entityReference = null;
            EntityReference entityReference2 = null;
            while (iterator.hasNext()) {
                viewAttributeDefImpl = this.getAttrDefFromVTable((String)iterator.next());
                entityReference = viewAttributeDefImpl.getEntityReference();
                if (entityReference != null && !entityReference.equals(entityReference2 = this.getEOUsageFromVTable(entityReference.getName()))) {
                    viewAttributeDefImpl = entityReference2.createViewAttribute(viewAttributeDefImpl.getName(), viewAttributeDefImpl.getAliasName(), viewAttributeDefImpl.getAttributeDefImpl(), viewAttributeDefImpl.getIndex(), viewAttributeDefImpl.getAttrLoad(), viewAttributeDefImpl.getJavaType(), viewAttributeDefImpl.isDiscrColumn(), viewAttributeDefImpl.getDefaultValue(), this);
                }
                this.mAttrRefs.set(viewAttributeDefImpl.getIndex(), (Object)viewAttributeDefImpl);
            }
        }
        this.resolveAttrs();
        this.mDefResolved |= 1;
        this.mNumInheritedAttrs = this.mTempAttrIndex;
        this.mNumInheritedERefs = this.mRefIndex;
    }

    private void loadAttributes(DefElement defElement) throws Exception {
        ArrayList arrayList = defElement.getChildrenList("ViewAttribute");
        int n = 0;
        while (n < arrayList.size()) {
            ViewAttributeDefImpl viewAttributeDefImpl;
            DefElement defElement2 = (DefElement)arrayList.get(n);
            String string = defElement2.readString("Name");
            String string2 = defElement2.readString("EntityUsage");
            String string3 = defElement2.readString("AliasName");
            if (string2 != null) {
                String string4 = defElement2.readString("EntityAttrName");
                byte by = AttributeDefImpl.convertAttrLoadStringToEnum(defElement2.readString("AttrLoad"));
                byte by2 = AttributeDefImpl.convertUpdateableStringToFlag(defElement2.readString("IsUpdateable"));
                boolean bl = defElement2.readBoolean("IsPersistent");
                boolean bl2 = defElement2.readBoolean("IsSelected");
                boolean bl3 = defElement2.readBoolean("IsQueriable");
                boolean bl4 = defElement2.readBoolean("DiscrColumn");
                String string5 = defElement2.readString("DefaultValue");
                if (string5 != null && string5.length() == 0) {
                    string5 = null;
                }
                String string6 = defElement2.readString("Expression");
                viewAttributeDefImpl = this.doAddEntityAttribute(string, string2, string4, string3, by, by2, bl, bl2, bl3, bl4, string5, string6);
            } else {
                viewAttributeDefImpl = new ViewAttributeDefImpl();
                viewAttributeDefImpl.loadUserDefinedAttr(defElement2, this, this.calcAttrIndex(string));
                viewAttributeDefImpl.mPassivate = defElement2.readBoolean("Passivate");
                viewAttributeDefImpl.setAliasName(string3);
                this.putAttrDefInVTable(viewAttributeDefImpl);
            }
            if (viewAttributeDefImpl != null) {
                viewAttributeDefImpl.updateHasLongFlag();
                viewAttributeDefImpl.updateFetchAhead();
            }
            viewAttributeDefImpl.loadProperties(defElement2);
            ++n;
        }
    }

    private int calcAttrIndex(String string) {
        int n;
        ViewAttributeDefImpl viewAttributeDefImpl = this.getAttrDefFromVTable(string);
        if (viewAttributeDefImpl != null) {
            RowDef rowDef = viewAttributeDefImpl.getDef();
            if (rowDef == this && ((AttributeDefImpl)viewAttributeDefImpl).getIndex() >= this.mNumInheritedAttrs && !MetaObjectManager.getSingleton().is323Compatible()) {
                throw new NameClashException(131, string);
            }
            n = ((AttributeDefImpl)viewAttributeDefImpl).getIndex();
        } else {
            n = this.mTempAttrIndex++;
        }
        return n;
    }

    public void addAllEntityAttributes(String string) {
        if (string == null || string.length() == 0) {
            throw new InvalidObjNameException(126, string);
        }
        EntityReference entityReference = this.getEOUsageFromVTable(string);
        if (entityReference == null) {
            throw new NoObjException(126, string);
        }
        AttributeDef[] attributeDefArray = entityReference.getEntityDef().getAttributeDefs();
        int n = 0;
        while (n < attributeDefArray.length) {
            AttributeDef attributeDef = attributeDefArray[n];
            this.addEntityAttribute(attributeDef.getName(), string, attributeDef.getName(), true);
            ++n;
        }
    }

    public AttributeDefImpl addEntityAttribute(String string, String string2, String string3, boolean bl) {
        return this.doAddEntityAttribute(string, string2, string3, null, (byte)0, (byte)2, bl, true, true, false, null, null);
    }

    private ViewAttributeDefImpl doAddEntityAttribute(String string, String string2, String string3, String string4, byte by, byte by2, boolean bl, boolean bl2, boolean bl3, boolean bl4, Object object, String string5) {
        int n = this.calcAttrIndex(string);
        if (string2 == null || string2.length() == 0) {
            throw new InvalidObjNameException(126, string2);
        }
        if (string3 == null || string3.length() == 0) {
            throw new PersistenceException("26010", new String[]{this.getName(), string3});
        }
        EntityReference entityReference = this.getEOUsageFromVTable(string2);
        if (entityReference == null) {
            throw new NoObjException(126, string2);
        }
        AttributeDefImpl attributeDefImpl = entityReference.getEntityDef().getAttributeDefImpl(string3);
        if (attributeDefImpl == null) {
            throw new PersistenceException("26010", new String[]{this.getName(), string3});
        }
        ViewAttributeDefImpl viewAttributeDefImpl = entityReference.createViewAttribute(string, string4, attributeDefImpl, n, by, attributeDefImpl.getJavaType(), bl4, object, this);
        viewAttributeDefImpl.setUpdateableFlag(by2);
        if (viewAttributeDefImpl.getUpdateableFlag() > attributeDefImpl.getUpdateableFlag()) {
            viewAttributeDefImpl.setUpdateableFlag(attributeDefImpl.getUpdateableFlag());
        }
        int n2 = bl ? 0 : (attributeDefImpl.getAttributeKind() == 1 ? 0 : 5);
        viewAttributeDefImpl.setAttributeKind((byte)n2);
        viewAttributeDefImpl.setSelected(bl2);
        viewAttributeDefImpl.setQueriable(bl3);
        if (string5 != null) {
            viewAttributeDefImpl.setColumnName(string5);
        }
        this.putAttrDefInVTable(viewAttributeDefImpl);
        return viewAttributeDefImpl;
    }

    public AttributeDefImpl addViewAttribute(String string, String string2, Class clazz) {
        int n = this.calcAttrIndex(string);
        ViewAttributeDefImpl viewAttributeDefImpl = new ViewAttributeDefImpl();
        viewAttributeDefImpl.setName(string.intern());
        viewAttributeDefImpl.setDef(this);
        viewAttributeDefImpl.setParent(this);
        viewAttributeDefImpl.setJavaType(clazz);
        viewAttributeDefImpl.setIndex(n);
        if (string2 != null) {
            viewAttributeDefImpl.setAttributeKind((byte)1);
            viewAttributeDefImpl.setColumnName(string2);
        } else {
            viewAttributeDefImpl.setAttributeKind((byte)3);
        }
        this.putAttrDefInVTable(viewAttributeDefImpl);
        return viewAttributeDefImpl;
    }

    public void addEntityUsage(String string, String string2, boolean bl, String string3, String string4, String string5) {
        this.addEntityUsage(string, string2, bl, false, string3, string4, string5);
    }

    public void addEntityUsage(String string, String string2, boolean bl, boolean bl2, String string3, String string4, String string5) {
        this.doAddEntityUsage(string, string2, bl, bl2, string3, string4, string5);
    }

    EntityReference doAddEntityUsage(String string, String string2, boolean bl, boolean bl2, String string3, String string4, String string5) {
        int n;
        EntityDefImpl entityDefImpl = EntityDefImpl.findDefObject(string2);
        if (entityDefImpl == null) {
            throw new NoObjException(21, string2);
        }
        EntityReference entityReference = this.getEOUsageFromVTable(string);
        if (entityReference != null) {
            n = entityReference.getOrderIndex();
            if (n >= this.mNumInheritedERefs) {
                throw new NameClashException(126, string);
            }
        } else {
            short s = this.mRefIndex;
            this.mRefIndex = (short)(s + 1);
            n = s;
        }
        EntityReference entityReference2 = (EntityReference)ComponentObjectImpl.createRef(string, entityDefImpl);
        entityReference2.setReference(bl);
        entityReference2.setReadOnly(bl2);
        if (string3 != null && string3.length() > 0) {
            TempEntityAssoc tempEntityAssoc = new TempEntityAssoc();
            tempEntityAssoc.mAssocName = string3;
            tempEntityAssoc.mAssocEndName = string4;
            tempEntityAssoc.mSrcERefName = string5;
            tempEntityAssoc.mDstERef = entityReference2;
            if (this.mTempEntityAssocs == null) {
                this.mTempEntityAssocs = new ArrayList(5);
            }
            this.mTempEntityAssocs.add((Object)tempEntityAssoc);
        }
        this.putEOUsageInVTable(entityReference2);
        entityReference2.setOrderIndex(n);
        return entityReference2;
    }

    public void addEntityUsage(String string, String string2, boolean bl) {
        this.addEntityUsage(string, string2, bl, false, null, null, null);
    }

    public void addEntityUsage(String string, String string2, boolean bl, boolean bl2) {
        this.addEntityUsage(string, string2, bl, bl2, null, null, null);
    }

    private void loadEntityReference(DefElement defElement) throws Exception {
        EntityReference entityReference = this.doAddEntityUsage(defElement.readString("Name"), defElement.readString("Entity"), defElement.readBoolean("Reference"), defElement.readBoolean("ReadOnly"), defElement.readString("Association"), defElement.readString("AssociationEnd"), defElement.readString("SourceUsage"));
        entityReference.setEntireObjectTable(defElement.readBoolean("EntireObjectTable"));
    }

    boolean isReadOnly() {
        return this.mReadOnly;
    }

    boolean hasLongData() {
        return this.mHasLongDataType;
    }

    void setHasLongData(boolean bl) {
        this.mHasLongDataType = bl;
    }

    boolean isDefaultVO() {
        return this.mDefaultVO;
    }

    void setDefaultVO(boolean bl) {
        this.mDefaultVO = bl;
    }

    private void initEDefToVOAttrsList(ViewAttributeDefImpl viewAttributeDefImpl, EntityDefImpl entityDefImpl) {
        ArrayList arrayList;
        ArrayList arrayList2 = (ArrayList)this.mEDefToVOAttrsMap.get((Object)entityDefImpl);
        if (arrayList2 == null) {
            arrayList2 = new ArrayList(1);
            this.mEDefToVOAttrsMap.put((Object)entityDefImpl, (Object)arrayList2);
        }
        if (!arrayList2.contains((Object)viewAttributeDefImpl)) {
            arrayList2.add((Object)viewAttributeDefImpl);
        }
        if ((arrayList = entityDefImpl.getExtendedDefObjects()) != null) {
            int n = 0;
            while (n < arrayList.size()) {
                this.initEDefToVOAttrsList(viewAttributeDefImpl, (EntityDefImpl)arrayList.get(n));
                ++n;
            }
        }
    }

    private void initEAttrToVOAttrsList(ViewAttributeDefImpl viewAttributeDefImpl, AttributeDefImpl attributeDefImpl) {
        ArrayList arrayList;
        ArrayList arrayList2 = (ArrayList)this.mEAttrToVOAttrsMap.get((Object)attributeDefImpl);
        if (arrayList2 == null) {
            arrayList2 = new ArrayList(1);
            this.mEAttrToVOAttrsMap.put((Object)attributeDefImpl, (Object)arrayList2);
        }
        if (!arrayList2.contains((Object)viewAttributeDefImpl)) {
            arrayList2.add((Object)viewAttributeDefImpl);
        }
        if ((arrayList = attributeDefImpl.getExtendedDefObjects()) != null) {
            int n = 0;
            while (n < arrayList.size()) {
                this.initEAttrToVOAttrsList(viewAttributeDefImpl, (AttributeDefImpl)arrayList.get(n));
                ++n;
            }
        }
    }

    private void resolveAttrs() {
        int n;
        int[] nArray;
        ArrayList arrayList;
        Object object;
        boolean bl = false;
        ArrayList arrayList2 = new ArrayList(2);
        this.mPrimaryKeys = new ArrayList(4);
        this.mEDefToVOAttrsMap = new HashMap(8);
        this.mEAttrToVOAttrsMap = new HashMap(20);
        int n2 = 0;
        while (n2 < this.mAttrRefs.size()) {
            AttributeDefImpl attributeDefImpl;
            ViewAttributeDefImpl viewAttributeDefImpl = (ViewAttributeDefImpl)this.mAttrRefs.get(n2);
            if (viewAttributeDefImpl.isDiscrColumn()) {
                arrayList2.add((Object)viewAttributeDefImpl);
            }
            if (viewAttributeDefImpl.getEntityReference() != null) {
                EntityDefImpl entityDefImpl = viewAttributeDefImpl.getEntityReference().getEntityDef();
                AttributeDefImpl attributeDefImpl2 = viewAttributeDefImpl.getAttributeDefImpl();
                if (entityDefImpl != null) {
                    this.initEDefToVOAttrsList(viewAttributeDefImpl, entityDefImpl);
                    this.initEAttrToVOAttrsList(viewAttributeDefImpl, attributeDefImpl2);
                }
            }
            if ((attributeDefImpl = viewAttributeDefImpl.getAttributeDefImpl()) != null) {
                if (attributeDefImpl.isPrimaryKey()) {
                    this.mPrimaryKeys.add((Object)attributeDefImpl);
                }
            } else if (!bl) {
                bl = (viewAttributeDefImpl.mKind == 1 || viewAttributeDefImpl.mKind == 3) && viewAttributeDefImpl.mUpdateable != 0;
            }
            ++n2;
        }
        this.referantEntities();
        if (bl || this.mAttrRefs.size() == 0) {
            this.mReadOnly = false;
        } else if (this.mPrimaryKeys.size() == 0) {
            this.mReadOnly = true;
        } else {
            int n3 = 0;
            while (n3 < this.mEOInfoRefs.size()) {
                EntityReference entityReference = (EntityReference)this.mEOInfoRefs.get(n3);
                if (!entityReference.isReadOnly()) {
                    this.mReadOnly = false;
                }
                ++n3;
            }
        }
        Iterator iterator = this.mEDefToVOAttrsMap.keySet().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            arrayList = (ArrayList)this.mEDefToVOAttrsMap.get(object);
            if (arrayList == null || arrayList.size() <= 0) continue;
            nArray = new int[arrayList.size()];
            int n4 = 0;
            while (n4 < arrayList.size()) {
                nArray[n4] = ((ViewAttributeDefImpl)arrayList.get(n4)).getIndex();
                ++n4;
            }
            this.mEDefToVOAttrsMap.put(object, (Object)nArray);
        }
        iterator = this.mEAttrToVOAttrsMap.keySet().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            arrayList = (ArrayList)this.mEAttrToVOAttrsMap.get(object);
            if (arrayList == null || arrayList.size() <= 0) continue;
            nArray = new int[arrayList.size()];
            int n5 = 0;
            while (n5 < arrayList.size()) {
                nArray[n5] = ((ViewAttributeDefImpl)arrayList.get(n5)).getIndex();
                ++n5;
            }
            this.mEAttrToVOAttrsMap.put(object, (Object)nArray);
        }
        if (this.mKeyAttrs != null && (n = this.mKeyAttrs.size()) > 0 && this.mKeyAttrs.get(0) instanceof String) {
            int n6 = 0;
            while (n6 < this.mAttrRefs.size()) {
                AttributeDefImpl attributeDefImpl = (AttributeDefImpl)this.mAttrRefs.get(n6);
                attributeDefImpl.mPrimaryKey = this.mKeyAttrs.contains((Object)attributeDefImpl.getName());
                ++n6;
            }
            this.mKeyAttrs = null;
        }
        if (arrayList2.size() > 0) {
            this.setDiscrColumns((AttributeDefImpl[])arrayList2.toArray((Object[])new AttributeDefImpl[arrayList2.size()]));
        }
    }

    private void referantEntities() {
        int n = 0;
        while (n < this.mEOInfoRefs.size()) {
            EntityReference entityReference = (EntityReference)this.mEOInfoRefs.get(n);
            entityReference.verifyReference();
            if (!entityReference.hasPrimaryKeys()) {
                this.mHasAllEOPKs = false;
            }
            if (n == 0 && entityReference.getEntityDef() instanceof EntityDefOverRowSet) {
                this.mQueryThruEntity = true;
            }
            ++n;
        }
    }

    private void loadEntityImports(DefElement defElement) {
        ArrayList arrayList = defElement.readStringArrayList("EntityImports");
        if (arrayList != null) {
            int n = 0;
            while (n < arrayList.size()) {
                EntityDefImpl.findDefObject((String)arrayList.get(n));
                ++n;
            }
        }
    }

    private void loadKey(DefElement defElement) {
        ArrayList arrayList = defElement.readStringArrayList("KeyAttributes");
        if (this.mKeyAttrs == null && arrayList.size() > 0) {
            this.mKeyAttrs = new ArrayList(arrayList.size());
        }
        int n = 0;
        while (n < arrayList.size()) {
            this.mKeyAttrs.add(arrayList.get(n));
            ++n;
        }
    }

    private void loadViewLinkAccessors(DefElement defElement) {
        ArrayList arrayList = defElement.getChildrenList("ViewLinkAccessor");
        int n = 0;
        while (n < arrayList.size()) {
            DefElement defElement2 = (DefElement)arrayList.get(n);
            TempViewLinkAccr tempViewLinkAccr = new TempViewLinkAccr();
            tempViewLinkAccr.mName = defElement2.readString("Name");
            tempViewLinkAccr.mViewLinkName = defElement2.readString("ViewLink");
            tempViewLinkAccr.mReversed = defElement2.readBoolean("Reversed");
            tempViewLinkAccr.mType = defElement2.readString("Type");
            this.mViewLinkAccessors.put((Object)tempViewLinkAccr.mName, (Object)tempViewLinkAccr);
            this.mViewLinkAccessorList.add((Object)tempViewLinkAccr.mName);
            ++n;
        }
    }

    private AttributeDef resolveViewLinkAccessorAttribute(TempViewLinkAccr tempViewLinkAccr) {
        ViewAttributeDefImpl viewAttributeDefImpl;
        String string;
        String string2;
        ViewLinkDefImpl viewLinkDefImpl = ViewLinkDefImpl.findDefObject(tempViewLinkAccr.mViewLinkName);
        this.mViewLinkAccessors.put((Object)tempViewLinkAccr.mName, (Object)viewLinkDefImpl);
        boolean bl = tempViewLinkAccr.mReversed;
        if (!bl) {
            string2 = viewLinkDefImpl.getSourceName();
            string = viewLinkDefImpl.getDestinationName();
        } else {
            string2 = viewLinkDefImpl.getDestinationName();
            string = viewLinkDefImpl.getSourceName();
        }
        AssociationDefImpl associationDefImpl = viewLinkDefImpl.findEndAccessorByName(string2);
        if (associationDefImpl == null) {
            Class clazz = JBOClass.findCustomClass(tempViewLinkAccr.mType, null);
            try {
                associationDefImpl = new AssociationDefImpl(tempViewLinkAccr.mName, this, clazz);
                associationDefImpl.setAssociation(viewLinkDefImpl);
                associationDefImpl.setEndName(string2);
                associationDefImpl.setOtherEndName(string);
            }
            catch (JboException jboException) {
                throw jboException;
            }
            catch (Exception exception) {
                PersistenceException persistenceException = new PersistenceException("26000", null);
                persistenceException.addToDetails(exception);
                throw persistenceException;
            }
        }
        int n = (viewAttributeDefImpl = this.getAttrDefFromVTable(tempViewLinkAccr.mName)) != null ? viewAttributeDefImpl.getIndex() : this.mAttrRefs.size();
        viewAttributeDefImpl = new ViewAttributeDefImpl(tempViewLinkAccr.mName, null, associationDefImpl, n, associationDefImpl.getAttrLoad(), JBOClass.findDataClass(tempViewLinkAccr.mType), false, null, this, null);
        viewAttributeDefImpl.setReverseAccessor(bl);
        if (n < this.mAttrRefs.size()) {
            this.mAttrRefs.set(n, (Object)viewAttributeDefImpl);
        } else {
            this.mAttrRefs.add((Object)viewAttributeDefImpl);
        }
        this.putAttrDefInVTable(viewAttributeDefImpl);
        return viewAttributeDefImpl;
    }

    private EntityReference findEntityReferenceFromAttrName(String string) {
        string = string.intern();
        int n = 0;
        while (n < this.mAttrRefs.size()) {
            if (((ViewAttributeDefImpl)this.mAttrRefs.get(n)).getName() == string) {
                return (EntityReference)((ViewAttributeDefImpl)this.mAttrRefs.get(n)).getParent();
            }
            ++n;
        }
        return null;
    }

    private synchronized void processViewLinkAccessors() {
        if (!this.mViewLinksResolved) {
            this.mViewLinksResolved = true;
            while (this.mViewLinkAccessorList.size() > 0) {
                String string = (String)this.mViewLinkAccessorList.get(0);
                Object object = this.mViewLinkAccessors.get((Object)string);
                if (object instanceof TempViewLinkAccr) {
                    this.resolveViewLinkAccessorAttribute((TempViewLinkAccr)object);
                }
                this.mViewLinkAccessorList.remove(0);
            }
            this.mViewLinkAccessorList = null;
            this.mTempAttrRefsVTable = null;
        }
    }

    private synchronized int prepareViewLinkAccessors() {
        int n = 0;
        if (!this.mViewLinksResolved) {
            int n2 = 0;
            while (n2 < this.mViewLinkAccessorList.size()) {
                String string = (String)this.mViewLinkAccessorList.get(n2);
                Object object = this.mViewLinkAccessors.get((Object)string);
                if (object instanceof TempViewLinkAccr) {
                    String string2 = ((TempViewLinkAccr)object).mType;
                    ViewAttributeDefImpl viewAttributeDefImpl = this.getAttrDefFromVTable(string);
                    if (viewAttributeDefImpl != null) {
                        int n3 = 0;
                        if (this.mAttrRefs != null) {
                            string = string.intern();
                            while (n3 < this.mAttrRefs.size()) {
                                if (((ViewAttributeDefImpl)this.mAttrRefs.get(n3)).getName() == string) break;
                                ++n3;
                            }
                        }
                        if (this.mAttrRefs == null || n3 >= this.mAttrRefs.size()) {
                            ++n;
                        }
                    } else {
                        int n4 = this.calcAttrIndex(string);
                        ViewAttributeDefImpl viewAttributeDefImpl2 = new ViewAttributeDefImpl(string, null, null, n4, 0, JBOClass.findDataClass(string2), false, null, this, null);
                        this.putAttrDefInVTable(viewAttributeDefImpl2);
                        ++n;
                    }
                    this.mNumInheritedAttrs = this.mTempAttrIndex;
                }
                ++n2;
            }
        }
        return n;
    }

    synchronized void processEntityAssociations() {
        if (this.mTempEntityAssocs != null) {
            ArrayList arrayList = new ArrayList(this.mTempEntityAssocs.size() * 2);
            ArrayList arrayList2 = new ArrayList(this.mTempEntityAssocs.size());
            int n = 0;
            while (n < this.mTempEntityAssocs.size()) {
                TempEntityAssoc tempEntityAssoc = (TempEntityAssoc)this.mTempEntityAssocs.get(n);
                String string = tempEntityAssoc.mSrcERefName;
                if (string == null) {
                    throw new PersistenceException("26035", new Object[]{tempEntityAssoc.mDstERef.getName()});
                }
                EntityReference entityReference = this.getEntityReference(JboNameUtil.getLastPartOfName(string));
                if (!MetaObjectManager.getSingleton().is323Compatible() && entityReference == null) {
                    throw new NoObjException(126, string);
                }
                EntityAssociation entityAssociation = EntityAssociation.findEntityAssociation(tempEntityAssoc.mAssocName);
                if (!MetaObjectManager.getSingleton().is323Compatible() && entityAssociation == null) {
                    throw new NoObjException(125, string);
                }
                if (entityReference != null && entityAssociation != null) {
                    if (tempEntityAssoc.mAssocEndName == null) {
                        throw new PersistenceException("26035", new Object[]{tempEntityAssoc.mDstERef.getName()});
                    }
                    String string2 = JboNameUtil.getLastPartOfName(tempEntityAssoc.mAssocEndName);
                    AssociationEnd associationEnd = entityAssociation.findEndByName(string2);
                    EntityReference entityReference2 = tempEntityAssoc.mDstERef;
                    if (!MetaObjectManager.getSingleton().is323Compatible() && associationEnd.getOwner() != entityReference2.getEntityDef() && !associationEnd.getOwner().isBaseDefFor(entityReference2.getEntityDef())) {
                        throw new PersistenceException("26031", new Object[]{string2, entityAssociation.getName(), entityReference2.getName(), this.getName()});
                    }
                    AssociationEnd associationEnd2 = entityAssociation.getDestinationEnd() == associationEnd ? entityAssociation.getSourceEnd() : entityAssociation.getDestinationEnd();
                    EntityAssociationReference entityAssociationReference = new EntityAssociationReference(entityAssociation, entityReference, entityReference2, associationEnd2.getName(), string2);
                    entityReference.addEntityAssociationReference(entityAssociationReference);
                    entityReference2.addEntityAssociationReference(entityAssociationReference);
                    arrayList2.add((Object)entityAssociationReference);
                    AssociationDefImpl associationDefImpl = entityAssociationReference.getAccessor();
                    if (associationDefImpl != null) {
                        AttributeDefImpl[] attributeDefImplArray = associationDefImpl.getAttributeDefImpls();
                        int n2 = 0;
                        while (n2 < attributeDefImplArray.length) {
                            ViewAttributeDefImpl viewAttributeDefImpl = entityReference.findViewAttrDefByEntityAttrName(attributeDefImplArray[n2].getName(), attributeDefImplArray[n2]);
                            if (viewAttributeDefImpl != null && !arrayList.contains((Object)viewAttributeDefImpl)) {
                                arrayList.add((Object)viewAttributeDefImpl);
                            }
                            ++n2;
                        }
                    }
                }
                ++n;
            }
            this.mTempEntityAssocs.clear();
            this.mTempEntityAssocs = null;
            this.mEORefAttrs = (ViewAttributeDefImpl[])arrayList.toArray((Object[])new ViewAttributeDefImpl[arrayList.size()]);
            this.setEntityAssociationReferences((EntityAssociationReference[])arrayList2.toArray((Object[])new EntityAssociationReference[arrayList2.size()]));
        }
    }

    public boolean isFullSql() {
        return this.mFullSql;
    }

    public void setFullSql(boolean bl) {
        this.mFullSql = bl;
    }

    public boolean isQueryThruEntity() {
        return this.mQueryThruEntity;
    }

    private boolean isForeignKey(AttributeDefImpl attributeDefImpl, AttributeDefImpl[] attributeDefImplArray) {
        int n = 0;
        while (n < attributeDefImplArray.length) {
            if (attributeDefImplArray[n] == attributeDefImpl) {
                return true;
            }
            ++n;
        }
        return false;
    }

    void setDefForComponent(ComponentObjectImpl componentObjectImpl) {
    }

    protected boolean isDynamic() {
        return super.isDynamic() || this.getParent() == null;
    }

    void unsetDefForComponent(ComponentObjectImpl componentObjectImpl) {
        if (super.isDynamic()) {
            this.getPackageDef().removeChild(this, "ViewObject");
        }
    }

    ViewLinkDefImpl findViewLinkDefImpl(ViewAttributeDefImpl viewAttributeDefImpl) {
        return (ViewLinkDefImpl)this.mViewLinkAccessors.get((Object)viewAttributeDefImpl.getName());
    }

    int[] viewAttrsForEntityDef(EntityDefImpl entityDefImpl) {
        return (int[])this.mEDefToVOAttrsMap.get((Object)entityDefImpl);
    }

    int[] viewAttrsForEntityAttr(AttributeDefImpl attributeDefImpl) {
        return (int[])this.mEAttrToVOAttrsMap.get((Object)attributeDefImpl);
    }

    public final boolean isPassivationEnabled() {
        return this.mPassivate != 2;
    }

    final boolean isPassivateTransients() {
        return this.mPassivate == 1;
    }

    boolean isFetchAhead() {
        return this.mFetchAhead;
    }

    void setFetchAhead(boolean bl) {
        this.mFetchAhead = bl;
    }

    protected void loadCustomDef(DefElement defElement) throws PersistenceException {
    }

    public boolean hasQuery() {
        String string = this.getSelectClause();
        return this.mQueryStr != null && this.mQueryStr.length() > 0 || string != null && string.length() > 0;
    }

    public String getXMLRowElementTag() {
        String string = (String)this.getProperty("XML_ROW_ELEMENT");
        return string != null ? string : this.getName() + "Row";
    }

    public String getXMLElementTag() {
        String string = (String)this.getProperty("XML_ELEMENT");
        return string != null ? string : this.getName();
    }

    public int getIterMode() {
        return this.mIterMode;
    }

    public void setIterMode(int n) {
        this.mIterMode = n;
    }

    public boolean isViewLinkAccessorRetained() {
        return this.mViewLinkAccessorRetained;
    }

    public void setViewLinkAccessorRetained(boolean bl) {
        this.mViewLinkAccessorRetained = bl;
    }

    public String getEJBHomeJNDIName() {
        return this.mEJBHomeJNDIName;
    }

    public String getEJBAppProviderURL() {
        return this.mEJBAppProviderURL;
    }

    public boolean isFinderView() {
        return this.mIsFinderView;
    }

    void lookupEJBHome() {
        if (this.mEJBHomeJNDIName != null) {
            try {
                this.mEJBHome = new InitialContext().lookup("java:comp/env/ejb/" + this.mEJBHomeJNDIName);
            }
            catch (NamingException namingException) {
                throw new JboException(namingException);
            }
        }
    }

    public Object getEJBHome() {
        return this.mEJBHome;
    }

    public static String buildDefaultSelect(AttributeDef[] attributeDefArray) {
        String string = "";
        boolean bl = true;
        int n = 0;
        while (n < attributeDefArray.length) {
            boolean bl2 = true;
            boolean bl3 = false;
            ViewAttributeDefImpl viewAttributeDefImpl = (ViewAttributeDefImpl)attributeDefArray[n];
            byte by = viewAttributeDefImpl.getAttributeKind();
            if ((by == 0 || by == 1) && viewAttributeDefImpl.isSelected()) {
                AttributeDefImpl attributeDefImpl = viewAttributeDefImpl.getAttributeDefImpl();
                String string2 = viewAttributeDefImpl.getAliasName();
                EntityReference entityReference = viewAttributeDefImpl.getEntityReference();
                boolean bl4 = false;
                String string3 = null;
                string3 = viewAttributeDefImpl.getColumnName();
                if (string3 != null && string3.length() > 0) {
                    bl4 = true;
                }
                if (entityReference != null || bl4) {
                    if (!bl) {
                        string = string + ",         ";
                    }
                    bl = false;
                }
                String string4 = null;
                if (entityReference != null && attributeDefImpl != null && attributeDefImpl.isPersistent()) {
                    string4 = entityReference.getName();
                    if (string4 == null) {
                        string4 = entityReference.getEntityDef().getSource();
                    }
                    if (attributeDefImpl.isObjectTableRef()) {
                        string = string + "REF(" + string4 + ")";
                    } else if (entityReference.isEntireObjectTable() && !attributeDefImpl.isObjectTableOID()) {
                        string = string + "VALUE(" + string4 + ")";
                        ++n;
                        while (n < attributeDefArray.length) {
                            viewAttributeDefImpl = (ViewAttributeDefImpl)attributeDefArray[n];
                            if (viewAttributeDefImpl.getAttrLoad() != 2) {
                                --n;
                                break;
                            }
                            ++n;
                        }
                    } else {
                        string = string + string4 + "." + attributeDefImpl.getColumnName();
                        if (!attributeDefImpl.getColumnName().equals(string2)) {
                            string = string + " AS " + string2;
                        }
                    }
                } else if (bl4) {
                    if (string2 == null || string2.length() == 0) {
                        string2 = "Calculated";
                    }
                    string = string + string3 + " AS " + string2;
                }
            }
            ++n;
        }
        if (string.length() == 0) {
            string = null;
        }
        return string;
    }

    protected VariableValueManager[] getVarMgrParents() {
        NamedObjectImpl namedObjectImpl = this.getParent();
        VariableValueManager variableValueManager = null;
        if (namedObjectImpl instanceof DefObject) {
            variableValueManager = ((DefObject)namedObjectImpl).ensureVariableManager();
        }
        VariableValueManager[] variableValueManagerArray = new VariableValueManager[1 + this.mEOInfoRefs.size()];
        variableValueManagerArray[0] = variableValueManager;
        int n = 0;
        while (n < this.mEOInfoRefs.size()) {
            variableValueManagerArray[n + 1] = ((EntityReference)this.mEOInfoRefs.get(n)).getEntityDef().ensureVariableManager();
            ++n;
        }
        return variableValueManagerArray;
    }

    public boolean hasVariables() {
        if (super.hasVariables()) {
            return true;
        }
        int n = 0;
        while (n < this.mEOInfoRefs.size()) {
            if (((EntityReference)this.mEOInfoRefs.get(n)).getEntityDef().hasVariables()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    void removeResourceBundle(Locale locale) {
        if (this.getMessageBundleClass() != null) {
            StringManager.getSingleton().removeMessageBundle(this.getMessageBundleClass().getName(), locale);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class TempEntityAssoc {
        EntityReference mDstERef;
        String mSrcERefName;
        String mAssocName;
        String mAssocEndName;

        TempEntityAssoc() {
        }
    }

    public class TempViewLinkAccr {
        String mName;
        String mViewLinkName;
        boolean mReversed;
        String mType;

        TempViewLinkAccr() {
        }
    }
}

