/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.server;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.HashMap;
import java.util.Vector;
import oracle.jbo.ApplicationModule;
import oracle.jbo.ComponentObject;
import oracle.jbo.ComponentObjectListener;
import oracle.jbo.InvalidOwnerException;
import oracle.jbo.JboException;
import oracle.jbo.VariableManagerOwner;
import oracle.jbo.VariableValueManager;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.JboEnvUtil;
import oracle.jbo.common.VariableValueManagerImpl;
import oracle.jbo.server.ApplicationModuleImpl;
import oracle.jbo.server.ContainerObjectImpl;
import oracle.jbo.server.DefObject;
import oracle.jbo.server.NamedObjectImpl;
import oracle.jbo.server.SessionImpl;

public abstract class ComponentObjectImpl
extends NamedObjectImpl
implements VariableManagerOwner,
ComponentObject {
    private HashMap mProxyClassNames;
    private ArrayList mCompListeners;
    private boolean mCreateCalled;
    private DefObject mDef;
    private VariableValueManager mVariableManager;
    private boolean mIsDead;
    private static /* synthetic */ Class class$oracle$jbo$CSMessageBundle;

    private /* synthetic */ void $init$() {
        this.mProxyClassNames = new HashMap(3);
        this.mCompListeners = new ArrayList();
        this.mCreateCalled = false;
        this.mDef = null;
        this.mVariableManager = null;
        this.mIsDead = false;
    }

    void setDef(DefObject defObject) {
        if (this.mDef == defObject) {
            return;
        }
        if (this.mDef != null) {
            this.mDef.unsetDefForComponent(this);
        }
        this.mDef = defObject;
        if (defObject != null) {
            defObject.setDefForComponent(this);
        }
    }

    DefObject getDef() {
        return this.mDef;
    }

    protected ArrayList getCompListenersList() {
        return this.mCompListeners;
    }

    protected Vector getCompListeners() {
        return JboEnvUtil.convertArrayListToVector(this.getCompListenersList());
    }

    public final ApplicationModuleImpl getRootApplicationModule() {
        oracle.jbo.common.NamedObjectImpl namedObjectImpl = this.getParent();
        if (namedObjectImpl == null) {
            if (!(this instanceof ApplicationModuleImpl)) {
                Class clazz = class$oracle$jbo$CSMessageBundle;
                if (clazz == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = ComponentObjectImpl.class$("oracle.jbo.CSMessageBundle");
                }
                throw new InvalidOwnerException(clazz, "25302", this.getName(), null);
            }
            ApplicationModuleImpl applicationModuleImpl = (ApplicationModuleImpl)this;
            if (!applicationModuleImpl.isRoot()) {
                Class clazz = class$oracle$jbo$CSMessageBundle;
                if (clazz == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = ComponentObjectImpl.class$("oracle.jbo.CSMessageBundle");
                }
                throw new InvalidOwnerException(clazz, "25301", this.getName(), null);
            }
            if (!applicationModuleImpl.isRoot()) {
                Diagnostic.ASSERT(false, "Non-root module w/o parent");
            }
            return applicationModuleImpl;
        }
        if (namedObjectImpl instanceof ApplicationModuleImpl) {
            return ((ApplicationModuleImpl)namedObjectImpl).getRootApplicationModule();
        }
        Diagnostic.ASSERT(false, "Parent " + namedObjectImpl + " is not an Application Module");
        return null;
    }

    public static ComponentObjectImpl createRef(String string, DefObject defObject) {
        ComponentObjectImpl componentObjectImpl = null;
        Class clazz = defObject.getComponentClass();
        String string2 = clazz.getName();
        if (defObject != null && clazz != null) {
            try {
                componentObjectImpl = (ComponentObjectImpl)clazz.newInstance();
                componentObjectImpl.setName(string);
                componentObjectImpl.setPropertiesMap(defObject.getPropertiesMap());
                componentObjectImpl.setDef(defObject);
            }
            catch (JboException jboException) {
                throw jboException;
            }
            catch (Exception exception) {
                throw new JboException(exception);
            }
        }
        return componentObjectImpl;
    }

    void callCreate() {
        if (!this.mCreateCalled) {
            this.mCreateCalled = true;
            this.create();
        }
    }

    protected void create() {
    }

    public String getDefName() {
        return this.getDef().getName();
    }

    public String getDefFullName() {
        return this.getDef().getFullName();
    }

    public void remove() {
        oracle.jbo.common.NamedObjectImpl namedObjectImpl = this.getParent();
        if (namedObjectImpl instanceof ContainerObjectImpl) {
            ((ContainerObjectImpl)namedObjectImpl).removeChild(this);
        }
        this.setDef(null);
        this.mIsDead = true;
    }

    public boolean isDead() {
        return this.mIsDead;
    }

    public String getProxyClassName() {
        String string = ((SessionImpl)this.getApplicationModule().getSession()).getAppModuleServerType();
        return this.getProxyClassName(string);
    }

    public ApplicationModule getApplicationModule() {
        oracle.jbo.common.NamedObjectImpl namedObjectImpl = this.getParent();
        if (namedObjectImpl instanceof ApplicationModuleImpl) {
            return (ApplicationModuleImpl)namedObjectImpl;
        }
        return null;
    }

    protected String getProxyClassName(String string) {
        if (string != null) {
            return (String)this.mProxyClassNames.get((Object)string);
        }
        return null;
    }

    protected void setProxyClassName(String string, String string2) {
        this.mProxyClassNames.put((Object)string, (Object)string2);
    }

    public boolean isRegWithPiggyMan() {
        return false;
    }

    public void addListener(ComponentObjectListener componentObjectListener) {
        this.mCompListeners.add((Object)componentObjectListener);
    }

    protected void setName(String string) {
        this.mObjName = string;
    }

    protected void setParent(NamedObjectImpl namedObjectImpl) {
        this.mParent = namedObjectImpl;
    }

    public VariableValueManager getVariableManager() {
        return this.mVariableManager;
    }

    public boolean hasVariables() {
        if (this.mVariableManager != null) {
            return true;
        }
        if (this.mDef.hasVariables()) {
            return true;
        }
        oracle.jbo.common.NamedObjectImpl namedObjectImpl = this.getParent();
        if (namedObjectImpl instanceof ComponentObjectImpl) {
            return ((ComponentObjectImpl)namedObjectImpl).hasVariables();
        }
        return false;
    }

    public VariableValueManager ensureVariableManager() {
        if (this.mVariableManager == null) {
            oracle.jbo.common.NamedObjectImpl namedObjectImpl = this.getParent();
            VariableValueManager variableValueManager = null;
            if (namedObjectImpl instanceof ComponentObjectImpl) {
                variableValueManager = ((ComponentObjectImpl)namedObjectImpl).ensureVariableManager();
            }
            this.mVariableManager = new VariableValueManagerImpl(this, new VariableValueManager[]{this.mDef.ensureVariableManager(), variableValueManager});
        }
        return this.mVariableManager;
    }

    public Class getMessageBundleClass() {
        return this.getDef().getMessageBundleClass();
    }

    public ComponentObjectImpl() {
        this.$init$();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

