/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.pcoll;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Vector;
import oracle.jbo.PCollException;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.pcoll.PCollInputStream;
import oracle.jbo.pcoll.PCollKeyInfo;
import oracle.jbo.pcoll.PCollOutputStream;
import oracle.jbo.pcoll.PCollPersistable;
import oracle.jbo.pcoll.PCollection;
import oracle.jbo.pcoll.PersistManager;
import oracle.jbo.pcoll.PersistentMarker;

public class PCollNode
implements Serializable,
PCollPersistable {
    static final long serialVersionUID = -1725543709925887570L;
    static final String mIndent = "   ";
    long mNodeId;
    PCollNode mLeftSib;
    long mLeftSibId;
    PCollNode mRightSib;
    long mRightSibId;
    PCollection mColl;
    PCollNode mParent;
    long mParentId;
    PCollNode mPrevRUNode;
    PCollNode mNextRUNode;
    boolean mIsLeaf;
    long mNumOfObjs;
    Vector mElems;
    boolean mPCollChanged;
    boolean mHasBeenPersisted;
    int mNumPassivatedElems;
    int mLockCount;
    private static /* synthetic */ Class class$oracle$jbo$CSMessageBundle;

    private /* synthetic */ void $init$() {
        this.mNodeId = 0L;
        this.mLeftSib = null;
        this.mLeftSibId = 0L;
        this.mRightSib = null;
        this.mRightSibId = 0L;
        this.mColl = null;
        this.mParent = null;
        this.mParentId = 0L;
        this.mPrevRUNode = null;
        this.mNextRUNode = null;
        this.mIsLeaf = false;
        this.mNumOfObjs = 0L;
        this.mElems = null;
        this.mPCollChanged = false;
        this.mHasBeenPersisted = false;
        this.mNumPassivatedElems = 0;
        this.mLockCount = 0;
    }

    public PCollNode(PCollection pCollection, PCollNode pCollNode, boolean bl) {
        this.$init$();
        this.mNodeId = pCollection.getNextNodeId();
        this.mColl = pCollection;
        this.setParent(pCollNode);
        this.mElems = new Vector();
        this.mIsLeaf = bl;
        if (this.mIsLeaf) {
            this.mColl.incrNumActiveLeafNodes();
        }
        this.mColl.notifyPCollEvent(4, this, "nodeRecentlyUsed/cons");
        this.mColl.nodeRecentlyUsed(this);
        this.mColl.addToActiveTab(this);
        this.setPCollChanged(true);
    }

    void ASSERT(boolean bl, String string) {
        Diagnostic.ASSERT(bl, string + "\n---Node " + this.getNodeInfo() + "\n---Pers " + this.getNodePersInfo());
    }

    public boolean canBePersisted() {
        return true;
    }

    public boolean getHasBeenPersisted() {
        return this.mHasBeenPersisted;
    }

    public void setHasBeenPersisted(boolean bl) {
        this.mHasBeenPersisted = bl;
    }

    public boolean getPCollChanged() {
        return this.mPCollChanged;
    }

    public void setPCollChanged(boolean bl) {
        this.mPCollChanged = bl;
    }

    public long getPersistentId() {
        return this.mNodeId;
    }

    public void setPersistentId(long l) {
    }

    public long getPCollParentId() {
        return this.mParentId;
    }

    public void setPCollParentId(long l) {
        this.mParentId = l;
    }

    public Object[] getPCollKeys() {
        return null;
    }

    void setParent(PCollNode pCollNode) {
        long l;
        this.mParent = pCollNode;
        long l2 = l = this.mParent != null ? this.mParent.mNodeId : 0L;
        if (this.mParentId != l) {
            this.mParentId = l;
            this.setPCollChanged(true);
        }
    }

    PCollNode getLeftSib(boolean bl) {
        if (this.mLeftSibId == 0L) {
            return null;
        }
        if (this.mLeftSib == null) {
            int n = this.mParent.mElems.indexOf(this);
            if (n < 0) {
                Diagnostic.ASSERT(false, "Node not in parent: " + this.getNodeInfo());
            }
            if (bl) {
                this.mLeftSib = (PCollNode)this.mParent.getElemAt(n - 1);
            } else {
                Object e = this.mParent.mElems.elementAt(n - 1);
                if (e instanceof PCollNode) {
                    this.mLeftSib = (PCollNode)e;
                }
            }
        }
        return this.mLeftSib;
    }

    void setLeftSib(PCollNode pCollNode) {
        long l;
        this.mLeftSib = pCollNode;
        long l2 = l = pCollNode != null ? pCollNode.mNodeId : 0L;
        if (this.mLeftSibId != l) {
            this.mLeftSibId = l;
            this.setPCollChanged(true);
        }
    }

    PCollNode getRightSib(boolean bl) {
        if (this.mRightSibId == 0L) {
            return null;
        }
        if (this.mRightSib == null) {
            int n = this.mParent.mElems.indexOf(this);
            if (n < 0) {
                Diagnostic.ASSERT(false, "Node not in parent: " + this.getNodeInfo());
            }
            if (bl) {
                this.mRightSib = (PCollNode)this.mParent.getElemAt(n + 1);
            } else {
                Object e = this.mParent.mElems.elementAt(n + 1);
                if (e instanceof PCollNode) {
                    this.mRightSib = (PCollNode)e;
                }
            }
        }
        return this.mRightSib;
    }

    void setRightSib(PCollNode pCollNode) {
        long l;
        this.mRightSib = pCollNode;
        long l2 = l = pCollNode != null ? pCollNode.mNodeId : 0L;
        if (this.mRightSibId != l) {
            this.mRightSibId = l;
            this.setPCollChanged(true);
        }
    }

    PCollPersistable getElemAt(int n) {
        Object object = this.mElems.elementAt(n);
        if (object instanceof PersistentMarker) {
            PCollPersistable pCollPersistable = this.mColl.activeObjWithId(((PersistentMarker)object).mPersistentId);
            object = pCollPersistable == null ? this.activateElemAt(n, (PersistentMarker)object) : pCollPersistable;
        }
        return (PCollPersistable)object;
    }

    public static void closeInputStream(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeOutputStream(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static PCollPersistable activateElemWithId(PCollection pCollection, long l) {
        PersistManager persistManager = pCollection.getPersistManager();
        if (persistManager == null) {
            return null;
        }
        long[] lArray = new long[1];
        Object[] objectArray = persistManager.retrieve(l, pCollection.getId(), false, lArray);
        if (objectArray == null || objectArray[1] == null) {
            return null;
        }
        PCollKeyInfo[] pCollKeyInfoArray = (PCollKeyInfo[])objectArray[0];
        InputStream inputStream = (InputStream)objectArray[1];
        PCollInputStream pCollInputStream = null;
        PCollPersistable pCollPersistable = null;
        try {
            try {
                pCollInputStream = new PCollInputStream(pCollection, pCollection.getListener(), pCollKeyInfoArray, inputStream);
                pCollPersistable = (PCollPersistable)pCollInputStream.readObject();
                pCollPersistable.setHasBeenPersisted(true);
                pCollPersistable.setPCollParentId(lArray[0]);
                if (l > 0L) {
                    pCollection.getListener().afterActivateElement(pCollection, pCollPersistable);
                }
            }
            catch (Exception exception) {
                Diagnostic.printStackTrace(exception);
                Class clazz = class$oracle$jbo$CSMessageBundle;
                if (clazz == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = PCollNode.class$("oracle.jbo.CSMessageBundle");
                }
                PCollException.throwException(clazz, "28021", new Object[]{pCollection.getName(), new Integer(pCollection.getId()), new Long(l)}, exception);
                Object var12_10 = null;
                PCollNode.closeInputStream(pCollInputStream);
                pCollInputStream = null;
                PCollNode.closeInputStream(inputStream);
                return pCollPersistable;
            }
            Object var12_9 = null;
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            PCollNode.closeInputStream(pCollInputStream);
            pCollInputStream = null;
            PCollNode.closeInputStream(inputStream);
            inputStream = null;
            throw throwable;
        }
        PCollNode.closeInputStream(pCollInputStream);
        pCollInputStream = null;
        PCollNode.closeInputStream(inputStream);
        return pCollPersistable;
    }

    void replacePersistentMarker(int n, PCollPersistable pCollPersistable) {
        this.mElems.setElementAt(pCollPersistable, n);
        --this.mNumPassivatedElems;
        if (pCollPersistable instanceof PCollNode) {
            PCollNode pCollNode = (PCollNode)pCollPersistable;
            pCollNode.mColl = this.mColl;
            pCollNode.setParent(this);
            if (pCollNode.mIsLeaf) {
                this.mColl.incrNumActiveLeafNodes();
            }
            this.mColl.notifyPCollEvent(4, pCollNode, "nodeRecentlyUsed/elemReplaced");
            this.mColl.nodeRecentlyUsed(pCollNode);
        }
        this.mColl.addToActiveTab(pCollPersistable);
    }

    PCollPersistable activateElemAt(int n, PersistentMarker persistentMarker) {
        PCollPersistable pCollPersistable = PCollNode.activateElemWithId(this.mColl, persistentMarker.mPersistentId);
        if (pCollPersistable == null) {
            return null;
        }
        this.replacePersistentMarker(n, pCollPersistable);
        return pCollPersistable;
    }

    public static PCollPersistable activateObjWithId(PCollection pCollection, long l) {
        PCollPersistable pCollPersistable = PCollNode.activateElemWithId(pCollection, l);
        if (pCollPersistable == null) {
            return null;
        }
        PCollPersistable pCollPersistable2 = pCollPersistable;
        boolean bl = false;
        while (true) {
            long l2;
            PCollNode pCollNode;
            if ((pCollNode = (PCollNode)pCollection.activeObjWithId(l2 = pCollPersistable.getPCollParentId())) == null) {
                pCollNode = (PCollNode)PCollNode.activateElemWithId(pCollection, l2);
                pCollection.notifyPCollEvent(4, pCollNode, "nodeRecentlyUsed/activateParent");
                pCollection.nodeRecentlyUsed(pCollNode);
                pCollNode.mColl = pCollection;
            } else {
                bl = true;
            }
            int n = 0;
            while (n < pCollNode.mElems.size()) {
                Object e = pCollNode.mElems.elementAt(n);
                if (e instanceof PersistentMarker) {
                    if (((PersistentMarker)e).mPersistentId == l) {
                        pCollNode.replacePersistentMarker(n, pCollPersistable);
                        break;
                    }
                } else if (e instanceof PCollPersistable && ((PCollPersistable)e).getPersistentId() == l) {
                    Class clazz = class$oracle$jbo$CSMessageBundle;
                    if (clazz == null) {
                        clazz = PCollNode.class$("oracle.jbo.CSMessageBundle");
                    }
                    PCollException.throwException(clazz, "28036", new Object[]{pCollection.getName(), new Integer(pCollection.getId()), new Long(l), new Long(l2)}, null);
                }
                ++n;
            }
            if (n >= pCollNode.mElems.size()) {
                Class clazz = class$oracle$jbo$CSMessageBundle;
                if (clazz == null) {
                    clazz = PCollNode.class$("oracle.jbo.CSMessageBundle");
                }
                PCollException.throwException(clazz, "28037", new Object[]{pCollection.getName(), new Integer(pCollection.getId()), new Long(l), new Long(l2)}, null);
            }
            if (bl) break;
            pCollPersistable = pCollNode;
            l = l2;
        }
        return pCollPersistable2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean passivateElem(PCollPersistable pCollPersistable, PCollNode pCollNode, PCollection pCollection, long l) {
        block18: {
            if (pCollection.count_passivateElemCalls > 0) {
                Diagnostic.ASSERT(false, "Recursion/Reentrancy into passivateElem");
            }
            ++pCollection.count_passivateElemCalls;
            if (!pCollPersistable.canBePersisted()) {
                --pCollection.count_passivateElemCalls;
                pCollection.notifyPCollEvent(3, pCollPersistable, "passivateElem/cantPersist");
                return false;
            }
            ByteArrayOutputStream byteArrayOutputStream = null;
            PCollOutputStream pCollOutputStream = null;
            long l2 = pCollPersistable.getPersistentId();
            long l3 = pCollPersistable.getPCollParentId();
            if (l2 == 0L) {
                l2 = pCollection.getListener().getNextObjId();
                pCollPersistable.setPersistentId(l2);
            }
            try {
                block17: {
                    try {
                        if (pCollPersistable.getPCollChanged()) {
                            if (l2 > 0L) {
                                pCollection.getListener().beforePassivateElement(pCollection, pCollPersistable);
                            }
                            byteArrayOutputStream = new ByteArrayOutputStream();
                            pCollOutputStream = new PCollOutputStream(byteArrayOutputStream);
                            pCollOutputStream.writeObject(pCollPersistable);
                            PCollKeyInfo[] pCollKeyInfoArray = pCollOutputStream.getKeyArr();
                            byteArrayOutputStream.flush();
                            byte[] byArray = byteArrayOutputStream.toByteArray();
                            PersistManager persistManager = pCollection.getPersistManager();
                            if (!pCollPersistable.getHasBeenPersisted()) {
                                if (pCollection.count_persMgrCalls > 0) {
                                    Diagnostic.ASSERT(false, "Recursion/Reentrancy into PersistManager.insert");
                                }
                                ++pCollection.count_persMgrCalls;
                                persistManager.insert(l2, l3, pCollection.getId(), pCollKeyInfoArray, byArray);
                                --pCollection.count_persMgrCalls;
                            } else {
                                if (pCollection.count_persMgrCalls > 0) {
                                    Diagnostic.ASSERT(false, "Recursion/Reentrancy into PersistManager.update");
                                }
                                ++pCollection.count_persMgrCalls;
                                persistManager.update(l2, l3, pCollection.getId(), pCollKeyInfoArray, byArray);
                                --pCollection.count_persMgrCalls;
                            }
                            pCollPersistable.setHasBeenPersisted(true);
                        } else {
                            Diagnostic.println("$$skip for no change$$ id=" + l2);
                        }
                        pCollection.removeFromActiveTab(l2);
                        if (pCollNode == null) break block17;
                        int n = pCollNode.mElems.indexOf(pCollPersistable);
                        if (n < 0) {
                            Diagnostic.ASSERT(false, "Persistable obj not in parent, id: " + l2 + ", obj: " + pCollPersistable);
                        }
                        pCollNode.mElems.setElementAt(new PersistentMarker(l2, l), n);
                        ++pCollNode.mNumPassivatedElems;
                    }
                    catch (Exception exception) {
                        Class clazz = class$oracle$jbo$CSMessageBundle;
                        if (clazz == null) {
                            clazz = class$oracle$jbo$CSMessageBundle = PCollNode.class$("oracle.jbo.CSMessageBundle");
                        }
                        PCollException.throwException(clazz, "28020", new Object[]{pCollection.getName(), new Integer(pCollection.getId()), new Long(l2)}, exception);
                        Object var17_13 = null;
                        PCollNode.closeOutputStream(pCollOutputStream);
                        pCollOutputStream = null;
                        PCollNode.closeOutputStream(byteArrayOutputStream);
                        byteArrayOutputStream = null;
                        break block18;
                    }
                }
                Object var17_12 = null;
            }
            catch (Throwable throwable) {
                Object var17_14 = null;
                PCollNode.closeOutputStream(pCollOutputStream);
                pCollOutputStream = null;
                PCollNode.closeOutputStream(byteArrayOutputStream);
                byteArrayOutputStream = null;
                throw throwable;
            }
            PCollNode.closeOutputStream(pCollOutputStream);
            pCollOutputStream = null;
            PCollNode.closeOutputStream(byteArrayOutputStream);
            byteArrayOutputStream = null;
        }
        if (pCollPersistable instanceof PCollNode) {
            pCollection.dropFromRUChain((PCollNode)pCollPersistable);
        }
        --pCollection.count_passivateElemCalls;
        return true;
    }

    boolean passivateBranch() {
        if (this.mIsLeaf) {
            return this.passivate();
        }
        int n = 0;
        while (n < this.mElems.size()) {
            Object e = this.mElems.elementAt(n);
            if (!(e instanceof PersistentMarker) && !((PCollNode)e).passivateBranch()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    boolean passivate() {
        block10: {
            if (this.mLockCount > 0) {
                this.mColl.notifyPCollEvent(1, this, "passivate/nonZeroLock");
                return false;
            }
            try {
                ++this.mLockCount;
                boolean bl = true;
                if (this.mIsLeaf) {
                    int n = 0;
                    while (n < this.mElems.size()) {
                        Object e = this.mElems.elementAt(n);
                        if (!(e instanceof PersistentMarker) && !PCollNode.passivateElem((PCollPersistable)e, this, this.mColl, -1)) {
                            bl = false;
                        }
                        ++n;
                    }
                }
                if (!bl) {
                    this.mColl.notifyPCollEvent(2, this, "passivate/notAllPers");
                    boolean bl2 = false;
                    Object var6_5 = null;
                    --this.mLockCount;
                    return bl2;
                }
                if (!this.mColl.isCollectionOfOne()) {
                    this.getLeftSib(false);
                    this.getRightSib(false);
                    PCollNode.passivateElem(this, this.mParent, this.mColl, this.mNumOfObjs);
                    if (this.mLeftSib != null) {
                        this.mLeftSib.mRightSib = null;
                    }
                    if (this.mRightSib != null) {
                        this.mRightSib.mLeftSib = null;
                    }
                }
                if (!this.mIsLeaf) break block10;
                this.mColl.decrNumActiveLeafNodes();
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                --this.mLockCount;
                throw throwable;
            }
        }
        Object var6_6 = null;
        --this.mLockCount;
        {
        }
        return true;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.mNodeId = objectInputStream.readLong();
        this.mLeftSibId = objectInputStream.readLong();
        this.mRightSibId = objectInputStream.readLong();
        this.mIsLeaf = objectInputStream.readBoolean();
        this.mNumOfObjs = objectInputStream.readLong();
        this.mElems = (Vector)objectInputStream.readObject();
        this.mHasBeenPersisted = true;
        this.mNumPassivatedElems = this.mElems.size();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeLong(this.mNodeId);
        objectOutputStream.writeLong(this.mLeftSibId);
        objectOutputStream.writeLong(this.mRightSibId);
        objectOutputStream.writeBoolean(this.mIsLeaf);
        objectOutputStream.writeLong(this.mNumOfObjs);
        objectOutputStream.writeObject(this.mElems);
    }

    String indent(int n) {
        String string = "";
        int n2 = 0;
        while (n2 < n) {
            string = string + mIndent;
            ++n2;
        }
        return string;
    }

    boolean isInTree(PCollPersistable pCollPersistable) {
        if (pCollPersistable == this) {
            return true;
        }
        int n = 0;
        while (n < this.mElems.size()) {
            Object e = this.mElems.elementAt(n);
            if (e instanceof PCollPersistable) {
                if (e == pCollPersistable) {
                    return true;
                }
                if (e instanceof PCollNode && ((PCollNode)e).isInTree(pCollPersistable)) {
                    return true;
                }
            }
            ++n;
        }
        return false;
    }

    String getNodeInfo() {
        String string = this.mParent == null ? "null" : "" + this.mParent.mNodeId;
        return "id=" + this.mNodeId + (this.mIsLeaf ? ", Leaf " : ", Branch ") + "#Objs=" + this.mNumOfObjs + ",#Elems=" + this.mElems.size() + ",Par=" + string;
    }

    String getNodePersInfo() {
        return "#PsvElems=" + this.mNumPassivatedElems + ",Pers?=" + this.mHasBeenPersisted + ",LSib=" + this.mLeftSibId + "(" + (this.mLeftSib != null ? this.mLeftSib.mNodeId : 0L) + "),RSib=" + this.mRightSibId + "(" + (this.mRightSib != null ? this.mRightSib.mNodeId : 0L) + ")";
    }

    String getNodePosInfo() {
        String string = "";
        int n = 0;
        PCollNode pCollNode = this;
        while (pCollNode.mParent != null) {
            ++n;
            int n2 = pCollNode.mParent.mElems.indexOf(pCollNode);
            this.ASSERT(n2 >= 0, "Node not in parent");
            if (string.length() > 0) {
                string = string + ",";
            }
            string = string + n2;
            pCollNode = pCollNode.mParent;
        }
        if (string.length() == 0) {
            string = "root";
        }
        this.ASSERT(pCollNode == this.mColl.getRoot(), "Different root found");
        return "lev=" + n + " index(rev)=" + string;
    }

    void printNode(PrintWriter printWriter, int n, int n2) {
        boolean bl = true;
        if (n == 0) {
            n = 1;
        }
        if (printWriter != null) {
            if ((n & 1) != 0) {
                printWriter.println(this.indent(n2) + "Node " + this.getNodeInfo());
                bl = false;
            }
            if ((n & 2) != 0) {
                printWriter.println(this.indent(n2) + (bl ? "Pers " : "-Pers ") + this.getNodePersInfo());
                bl = false;
            }
            if ((n & 4) != 0) {
                printWriter.println(this.indent(n2) + (bl ? "Pos " : "-Pos ") + this.getNodePosInfo());
                bl = false;
            }
        }
        if (this.mColl.activeObjsTab() != null) {
            this.ASSERT(this.mColl.activeObjWithId(this.getPersistentId()) == this, "Object found in active tab " + this.mColl.activeObjWithId(this.getPersistentId()) + " not the same as this node " + this);
        }
        this.ASSERT(this.mLockCount >= 0, "Lock count is negative");
        this.ASSERT(this.mElems.size() <= this.mColl.getNodeCapacity(), "Elem size " + this.mElems.size() + " greater than capacity " + this.mColl.getNodeCapacity());
        if ((n & 8) != 0) {
            this.ASSERT(this.mLockCount >= 0, "Lock count is not zero");
        }
        this.ASSERT(this.mNumPassivatedElems >= 0, "Num of passivated elems is negative");
        int n3 = -1;
        if (this.mParent == null) {
            this.ASSERT(this.mLeftSib == null, "Root left sib is not null");
            this.ASSERT(this.mLeftSibId == 0L, "Root left sib id is not 0");
            this.ASSERT(this.mRightSib == null, "Root right sib is not null");
            this.ASSERT(this.mRightSibId == 0L, "Root right sib id is not 0");
        } else {
            n3 = this.mParent.mElems.indexOf(this);
            this.ASSERT(n3 >= 0, "Node not in parent");
            if (n3 == 0) {
                this.ASSERT(this.mLeftSib == null, "Index in parent 0, but left sib not null");
                this.ASSERT(this.mLeftSibId == 0L, "Index in parent 0, but left sib id not 0");
            } else {
                Object e = this.mParent.mElems.elementAt(n3 - 1);
                if (e instanceof PCollNode) {
                    if (this.mLeftSib != null) {
                        this.ASSERT(e == this.mLeftSib, "Left sib not same as elem with index - 1");
                    }
                    this.ASSERT(((PCollNode)e).mNodeId == this.mLeftSibId, "Left sib not same as elem with index - 1");
                } else {
                    this.ASSERT(this.mLeftSib == null, "Left sib is persistent, but mLeftSib is not null");
                    this.ASSERT(((PersistentMarker)e).mPersistentId == this.mLeftSibId, "Persistent left sib's id does not match mLeftSibId");
                }
            }
            if (n3 == this.mParent.mElems.size() - 1) {
                this.ASSERT(this.mRightSib == null, "Index in parent (size - 1), but right sib not null");
                this.ASSERT(this.mRightSibId == 0L, "Index in parent (size - 1), but right sib id not 0");
            } else {
                Object e = this.mParent.mElems.elementAt(n3 + 1);
                if (e instanceof PCollNode) {
                    if (this.mRightSib != null) {
                        this.ASSERT(e == this.mRightSib, "Right sib not same as elem with index + 1");
                    }
                    this.ASSERT(((PCollNode)e).mNodeId == this.mRightSibId, "Right sib not same as elem with index + 1");
                } else {
                    this.ASSERT(this.mRightSib == null, "Right sib is persistent, but mRightSib is not null");
                    this.ASSERT(((PersistentMarker)e).mPersistentId == this.mRightSibId, "Persistent right sib's id does not match mRightSibId");
                }
            }
        }
        if (this.mLeftSib != null) {
            if (this.mLeftSib.mRightSib != null) {
                this.ASSERT(this.mLeftSib.mRightSib == this, "Left sib''s right sib is not this");
            }
            this.ASSERT(this.mLeftSib.mRightSibId == this.mNodeId, "Left sib''s right sib id is not this node''s id");
        }
        if (this.mRightSib != null) {
            if (this.mRightSib.mLeftSib != null) {
                this.ASSERT(this.mRightSib.mLeftSib == this, "Right sib''s left sib is not this");
            }
            this.ASSERT(this.mRightSib.mLeftSibId == this.mNodeId, "Right sib''s left sib id is not this node''s id");
        }
        if (!this.mIsLeaf) {
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            while (n6 < this.mElems.size()) {
                Object e = this.mElems.elementAt(n6);
                if (e instanceof PCollNode) {
                    PCollNode pCollNode = (PCollNode)e;
                    if (this.mColl.activeObjsTab() != null) {
                        this.ASSERT(this.mColl.activeObjWithId(pCollNode.getPersistentId()) == pCollNode, "Child found in active tab " + this.mColl.activeObjWithId(pCollNode.getPersistentId()) + " not the same as child " + pCollNode);
                    }
                    this.ASSERT(pCollNode.mParent == this, "Child node at index " + n6 + " has bad parent");
                    if (n6 == 0) {
                        this.ASSERT(pCollNode.mLeftSib == null, "Youngest child''s left sib is not null");
                        this.ASSERT(pCollNode.mLeftSibId == 0L, "Youngest child''s left sib id is not 0");
                    }
                    if (n6 == this.mElems.size() - 1) {
                        this.ASSERT(pCollNode.mRightSib == null, "Oldest child''s right sib is not null");
                        this.ASSERT(pCollNode.mRightSibId == 0L, "Oldest child''s right sib id is not 0");
                    }
                    pCollNode.printNode(printWriter, n, n2 + 1);
                    n4 = (int)((long)n4 + pCollNode.mNumOfObjs);
                } else {
                    this.ASSERT(e instanceof PersistentMarker, "Found a child which is not a node nor marker: " + e.getClass().getName());
                    PersistentMarker persistentMarker = (PersistentMarker)e;
                    if (printWriter != null) {
                        printWriter.println(this.indent(n2 + 1) + "PersistentMarker " + persistentMarker);
                    }
                    n4 = (int)((long)n4 + persistentMarker.mNumOfObjs);
                    ++n5;
                }
                ++n6;
            }
            this.ASSERT((long)n4 == this.mNumOfObjs, "Count from children (" + n4 + ") different from mNumOfObjs (" + this.mNumOfObjs + ")");
            this.ASSERT(n5 == this.mNumPassivatedElems, "Count of passivated elems from children (" + n5 + ") different from mNumPassivatedElems (" + this.mNumPassivatedElems + ")");
        } else {
            this.ASSERT((long)this.mElems.size() == this.mNumOfObjs, "Elem vec size (" + this.mElems.size() + ") different from mNumOfObjs (" + this.mNumOfObjs + ")");
            int n7 = 0;
            int n8 = 0;
            while (n8 < this.mElems.size()) {
                Object e = this.mElems.elementAt(n8);
                if (e == null) {
                    if (printWriter != null) {
                        printWriter.println("Elem null");
                    }
                } else if (e instanceof PersistentMarker) {
                    if (printWriter != null) {
                        printWriter.println(this.indent(n2 + 1) + "PersistentMarker " + e);
                    }
                    ++n7;
                } else {
                    this.ASSERT(e instanceof PCollPersistable, "Element " + e + " is not a PCollPersistable");
                    if (this.mColl.activeObjsTab() != null) {
                        long l = ((PCollPersistable)e).getPersistentId();
                        this.ASSERT(this.mColl.activeObjWithId(l) == e, "Elem found in active tab " + this.mColl.activeObjWithId(l) + " not the same as elem " + e);
                    }
                    if (printWriter != null) {
                        printWriter.println(this.indent(n2 + 1) + "Elem id=" + ((PCollPersistable)e).getPersistentId() + " (" + e.getClass().getName() + ") " + e);
                    }
                }
                ++n8;
            }
            this.ASSERT(n7 == this.mNumPassivatedElems, "Count of passivated elems from children (" + n7 + ") different from mNumPassivatedElems (" + this.mNumPassivatedElems + ")");
        }
    }

    void printNode(PrintWriter printWriter, int n) {
        this.printNode(printWriter, n, 0);
    }

    void moveElemsToLeft(PCollNode pCollNode, int n, int n2) {
        PCollNode pCollNode2 = null;
        PCollNode pCollNode3 = null;
        try {
            ++this.mLockCount;
            if (!this.mIsLeaf) {
                if (pCollNode.mElems.size() > 0) {
                    pCollNode2 = (PCollNode)pCollNode.getElemAt(pCollNode.mElems.size() - 1);
                    ++pCollNode2.mLockCount;
                }
                if (n2 < this.mElems.size()) {
                    PCollNode pCollNode4 = (PCollNode)this.getElemAt(n2);
                    pCollNode4.setLeftSib(null);
                }
            }
            int n3 = n;
            while (n3 < n2) {
                Object e = this.mElems.elementAt(n);
                if (!this.mIsLeaf) {
                    pCollNode3 = (PCollNode)this.getElemAt(n);
                    ++pCollNode3.mLockCount;
                    pCollNode.mElems.addElement(pCollNode3);
                    pCollNode.setPCollChanged(true);
                    pCollNode3.setParent(pCollNode);
                    if (pCollNode2 != null) {
                        pCollNode2.setRightSib(pCollNode3);
                    }
                    pCollNode3.setLeftSib(pCollNode2);
                    if (pCollNode2 != null) {
                        --pCollNode2.mLockCount;
                    }
                    pCollNode2 = pCollNode3;
                    pCollNode.mNumOfObjs += pCollNode3.mNumOfObjs;
                    this.mNumOfObjs -= pCollNode3.mNumOfObjs;
                } else {
                    pCollNode.mElems.addElement(e);
                    pCollNode.setPCollChanged(true);
                    if (e instanceof PersistentMarker) {
                        if (this.mColl.count_persMgrCalls > 0) {
                            Diagnostic.ASSERT(false, "Recursion/Reentrancy into PersistManager.changeParent");
                        }
                        ++this.mColl.count_persMgrCalls;
                        this.mColl.getPersistManager().changeParent(((PersistentMarker)e).mPersistentId, pCollNode.mNodeId, this.mColl.getId());
                        --this.mColl.count_persMgrCalls;
                        ++pCollNode.mNumPassivatedElems;
                    } else {
                        ((PCollPersistable)e).setPCollParentId(pCollNode.mNodeId);
                        ((PCollPersistable)e).setPCollChanged(true);
                    }
                    ++pCollNode.mNumOfObjs;
                    --this.mNumOfObjs;
                }
                this.setPCollChanged(true);
                if (this.mElems.elementAt(n) instanceof PersistentMarker) {
                    --this.mNumPassivatedElems;
                }
                this.mElems.removeElementAt(n);
                ++n3;
            }
            if (pCollNode3 != null) {
                pCollNode3.setRightSib(null);
            }
            this.mColl.notifyPCollEvent(4, pCollNode, "nodeRecentlyUsed/moveElemsToLeft.left");
            this.mColl.nodeRecentlyUsed(pCollNode);
            if (this.mElems.size() > 0) {
                this.mColl.notifyPCollEvent(4, this, "nodeRecentlyUsed/moveElemsToLeft.right");
                this.mColl.nodeRecentlyUsed(this);
            }
            Object var10_9 = null;
            if (pCollNode2 != null) {
                --pCollNode2.mLockCount;
            }
            if (pCollNode2 != pCollNode3 && pCollNode3 != null) {
                --pCollNode3.mLockCount;
            }
            --this.mLockCount;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (pCollNode2 != null) {
                --pCollNode2.mLockCount;
            }
            if (pCollNode2 != pCollNode3 && pCollNode3 != null) {
                --pCollNode3.mLockCount;
            }
            --this.mLockCount;
            throw throwable;
        }
    }

    void moveElemsToRight(PCollNode pCollNode, int n, int n2) {
        PCollNode pCollNode2 = null;
        PCollNode pCollNode3 = null;
        try {
            ++this.mLockCount;
            if (!this.mIsLeaf) {
                if (pCollNode.mElems.size() > 0) {
                    pCollNode2 = (PCollNode)pCollNode.getElemAt(0);
                    ++pCollNode2.mLockCount;
                }
                if (n > 0) {
                    PCollNode pCollNode4 = (PCollNode)this.getElemAt(n - 1);
                    pCollNode4.setRightSib(null);
                }
            }
            int n3 = n2 - 1;
            while (n3 >= n) {
                Object e = this.mElems.elementAt(n3);
                if (!this.mIsLeaf) {
                    pCollNode3 = (PCollNode)this.getElemAt(n3);
                    ++pCollNode3.mLockCount;
                    pCollNode.mElems.insertElementAt(pCollNode3, 0);
                    pCollNode.setPCollChanged(true);
                    pCollNode3.setParent(pCollNode);
                    if (pCollNode2 != null) {
                        pCollNode2.setLeftSib(pCollNode3);
                    }
                    pCollNode3.setRightSib(pCollNode2);
                    if (pCollNode2 != null) {
                        --pCollNode2.mLockCount;
                    }
                    pCollNode2 = pCollNode3;
                    pCollNode.mNumOfObjs += pCollNode3.mNumOfObjs;
                    this.mNumOfObjs -= pCollNode3.mNumOfObjs;
                } else {
                    pCollNode.mElems.insertElementAt(e, 0);
                    pCollNode.setPCollChanged(true);
                    if (e instanceof PersistentMarker) {
                        if (this.mColl.count_persMgrCalls > 0) {
                            Diagnostic.ASSERT(false, "Recursion/Reentrancy into PersistManager.changeParent");
                        }
                        ++this.mColl.count_persMgrCalls;
                        this.mColl.getPersistManager().changeParent(((PersistentMarker)e).mPersistentId, pCollNode.mNodeId, this.mColl.getId());
                        --this.mColl.count_persMgrCalls;
                        ++pCollNode.mNumPassivatedElems;
                    } else {
                        ((PCollPersistable)e).setPCollParentId(pCollNode.mNodeId);
                        ((PCollPersistable)e).setPCollChanged(true);
                    }
                    ++pCollNode.mNumOfObjs;
                    --this.mNumOfObjs;
                }
                this.setPCollChanged(true);
                if (this.mElems.elementAt(n3) instanceof PersistentMarker) {
                    --this.mNumPassivatedElems;
                }
                this.mElems.removeElementAt(n3);
                --n3;
            }
            if (!pCollNode.mIsLeaf) {
                ((PCollNode)pCollNode.getElemAt(0)).setLeftSib(null);
            }
            this.mColl.notifyPCollEvent(4, pCollNode, "nodeRecentlyUsed/moveElemsToRight.right");
            this.mColl.nodeRecentlyUsed(pCollNode);
            if (this.mElems.size() > 0) {
                this.mColl.notifyPCollEvent(4, this, "nodeRecentlyUsed/moveElemsToRight.left");
                this.mColl.nodeRecentlyUsed(this);
            }
            Object var10_9 = null;
            if (pCollNode2 != null) {
                --pCollNode2.mLockCount;
            }
            if (pCollNode2 != pCollNode3 && pCollNode3 != null) {
                --pCollNode3.mLockCount;
            }
            --this.mLockCount;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (pCollNode2 != null) {
                --pCollNode2.mLockCount;
            }
            if (pCollNode2 != pCollNode3 && pCollNode3 != null) {
                --pCollNode3.mLockCount;
            }
            --this.mLockCount;
            throw throwable;
        }
    }

    void removeFromParent() {
        if (this.getLeftSib(true) != null) {
            try {
                ++this.mLeftSib.mLockCount;
                this.mLeftSib.setRightSib(this.getRightSib(true));
                Object var2_1 = null;
                --this.mLeftSib.mLockCount;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                --this.mLeftSib.mLockCount;
                throw throwable;
            }
        }
        if (this.getRightSib(true) != null) {
            try {
                ++this.mRightSib.mLockCount;
                this.mRightSib.setLeftSib(this.getLeftSib(true));
                Object var4_4 = null;
                --this.mRightSib.mLockCount;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                --this.mRightSib.mLockCount;
                throw throwable;
            }
        }
        if (this.mParent != null) {
            this.mColl.dropFromRUChain(this);
            if (this.mIsLeaf) {
                this.mColl.decrNumActiveLeafNodes();
            }
            this.mParent.mElems.removeElementAt(this.mParent.mElems.indexOf(this));
            if (this.mColl.getPersistManager() != null && this.getHasBeenPersisted()) {
                if (this.mColl.count_persMgrCalls > 0) {
                    Diagnostic.ASSERT(false, "Recursion/Reentrancy into PersistManager.delete");
                }
                ++this.mColl.count_persMgrCalls;
                this.mColl.getPersistManager().delete(this.getPersistentId(), this.mColl.getId());
                --this.mColl.count_persMgrCalls;
            }
            this.mColl.removeFromActiveTab(this.getPersistentId());
            if (this.mParent.mElems.size() == 0) {
                this.mParent.removeFromParent();
            } else {
                this.mParent.checkForMerge();
            }
        }
    }

    PCollNode checkForMerge() {
        PCollNode pCollNode;
        block12: {
            int n = this.mColl.getNodeCapacity();
            int n2 = n / 4;
            pCollNode = null;
            try {
                ++this.mLockCount;
                int n3 = this.mElems.size();
                if (n3 == 0) {
                    this.removeFromParent();
                    break block12;
                }
                if (n3 >= n2) break block12;
                if (this.getRightSib(true) != null && this.mRightSib.mElems.size() + n3 < n) {
                    pCollNode = this.mRightSib;
                    Diagnostic.println("$$merge-to-right$$ this node=" + this.mNodeId + ", sib=" + pCollNode.mNodeId);
                    ++pCollNode.mLockCount;
                    this.moveElemsToRight(pCollNode, 0, n3);
                } else if (this.getLeftSib(true) != null && this.mLeftSib.mElems.size() + n3 < n) {
                    pCollNode = this.mLeftSib;
                    Diagnostic.println("$$merge-to-left$$ this node=" + this.mNodeId + ", sib=" + pCollNode.mNodeId);
                    ++pCollNode.mLockCount;
                    this.moveElemsToLeft(pCollNode, 0, n3);
                } else {
                    pCollNode = null;
                }
                if (pCollNode != null || n3 == 0) {
                    this.removeFromParent();
                    PCollNode pCollNode2 = pCollNode;
                    Object var7_6 = null;
                    if (pCollNode != null) {
                        --pCollNode.mLockCount;
                    }
                    --this.mLockCount;
                    return pCollNode2;
                }
                if (this.getRightSib(true) != null && this.mRightSib.mElems.size() >= n * 3 / 4) {
                    pCollNode = this.mRightSib;
                    Diagnostic.println("$$balance-right-to-this$$ this node=" + this.mNodeId + ", sib=" + pCollNode.mNodeId);
                    ++pCollNode.mLockCount;
                    pCollNode.moveElemsToLeft(this, 0, n / 2);
                    break block12;
                }
                if (this.getLeftSib(true) == null || this.mLeftSib.mElems.size() < n * 3 / 4) break block12;
                pCollNode = this.mLeftSib;
                Diagnostic.println("$$balance-left-to-this$$ this node=" + this.mNodeId + ", sib=" + pCollNode.mNodeId);
                ++pCollNode.mLockCount;
                pCollNode.moveElemsToRight(this, n / 2, pCollNode.mElems.size());
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (pCollNode != null) {
                    --pCollNode.mLockCount;
                }
                --this.mLockCount;
                throw throwable;
            }
        }
        Object var7_7 = null;
        if (pCollNode != null) {
            --pCollNode.mLockCount;
        }
        --this.mLockCount;
        {
        }
        return null;
    }

    PCollNode checkForSplit() {
        int n = this.mColl.getNodeCapacity();
        PCollNode pCollNode = null;
        PCollNode pCollNode2 = null;
        try {
            int n2;
            ++this.mLockCount;
            if (this.mElems.size() <= n) {
                PCollNode pCollNode3 = null;
                Object var10_5 = null;
                --this.mLockCount;
                if (pCollNode2 != null) {
                    --pCollNode2.mLockCount;
                }
                if (pCollNode != null) {
                    --pCollNode.mLockCount;
                }
                return pCollNode3;
            }
            int n3 = n / 2;
            int n4 = n - n3;
            if (this.mParent == null) {
                PCollNode pCollNode4 = new PCollNode(this.mColl, null, false);
                this.setParent(pCollNode4);
                this.mParent.mElems.addElement(this);
                n2 = 0;
                this.mParent.mNumOfObjs = this.mNumOfObjs;
                Diagnostic.println("$$added root$$ id=" + this.mParent.mNodeId);
                this.mColl.setRoot(this.mParent);
            } else {
                n2 = this.mParent.mElems.indexOf(this);
            }
            pCollNode = new PCollNode(this.mColl, this.mParent, this.mIsLeaf);
            ++pCollNode.mLockCount;
            pCollNode2 = this.getRightSib(true);
            if (pCollNode2 != null) {
                ++pCollNode2.mLockCount;
            }
            this.setRightSib(pCollNode);
            pCollNode.setLeftSib(this);
            pCollNode.setRightSib(pCollNode2);
            if (pCollNode2 != null) {
                pCollNode2.setLeftSib(pCollNode);
            }
            this.moveElemsToRight(pCollNode, n3, n + 1);
            this.mParent.mElems.insertElementAt(pCollNode, n2 + 1);
            this.mParent.checkForSplit();
        }
        catch (Throwable throwable) {
            Object var10_7 = null;
            --this.mLockCount;
            if (pCollNode2 != null) {
                --pCollNode2.mLockCount;
            }
            if (pCollNode != null) {
                --pCollNode.mLockCount;
            }
            throw throwable;
        }
        Object var10_6 = null;
        --this.mLockCount;
        if (pCollNode2 != null) {
            --pCollNode2.mLockCount;
        }
        if (pCollNode != null) {
            --pCollNode.mLockCount;
        }
        return pCollNode;
    }

    void addObject(PCollPersistable pCollPersistable) {
        if (!this.mIsLeaf) {
            ++this.mNumOfObjs;
            this.setPCollChanged(true);
            ((PCollNode)this.getElemAt(this.mElems.size() - 1)).addObject(pCollPersistable);
        } else {
            this.mColl.notifyPCollEvent(4, this, "nodeRecentlyUsed/addObject.leaf");
            this.mColl.nodeRecentlyUsed(this);
            ++this.mNumOfObjs;
            pCollPersistable.setPCollParentId(this.mNodeId);
            this.setPCollChanged(true);
            this.mElems.addElement(pCollPersistable);
            this.mColl.addToActiveTab(pCollPersistable);
            this.checkForSplit();
        }
    }

    void addPersistentMarker(long l, long l2) {
        ++this.mNumOfObjs;
        this.mElems.addElement(new PersistentMarker(l, l2));
    }

    PCollPersistable objectAt(long l) {
        long l2 = l;
        if (!this.mIsLeaf) {
            int n = this.mElems.size();
            int n2 = 0;
            while (n2 < n) {
                Object e = this.mElems.elementAt(n2);
                long l3 = e instanceof PCollNode ? ((PCollNode)e).mNumOfObjs : ((PersistentMarker)e).mNumOfObjs;
                if (l3 > l) {
                    return ((PCollNode)this.getElemAt(n2)).objectAt(l);
                }
                l -= l3;
                ++n2;
            }
            throw new ArrayIndexOutOfBoundsException("PCollNode.objectAt index=" + l2);
        }
        this.mColl.notifyPCollEvent(4, this, "nodeRecentlyUsed/objectAt.leaf");
        this.mColl.nodeRecentlyUsed(this);
        return this.getElemAt((int)l);
    }

    long idAt(long l) {
        long l2 = l;
        if (!this.mIsLeaf) {
            int n = this.mElems.size();
            int n2 = 0;
            while (n2 < n) {
                Object e = this.mElems.elementAt(n2);
                long l3 = e instanceof PCollNode ? ((PCollNode)e).mNumOfObjs : ((PersistentMarker)e).mNumOfObjs;
                if (l3 > l) {
                    if (e instanceof PCollNode) {
                        return ((PCollNode)e).idAt(l);
                    }
                    return -1;
                }
                l -= l3;
                ++n2;
            }
            throw new ArrayIndexOutOfBoundsException("PCollNode.idAt index=" + l2);
        }
        Object e = this.mElems.elementAt((int)l);
        if (e instanceof PCollPersistable) {
            return ((PCollPersistable)e).getPersistentId();
        }
        return ((PersistentMarker)e).mPersistentId;
    }

    void insertObjectAt(PCollPersistable pCollPersistable, long l) {
        long l2 = l;
        if (l == this.mNumOfObjs) {
            this.addObject(pCollPersistable);
            return;
        }
        if (!this.mIsLeaf) {
            int n = this.mElems.size();
            int n2 = 0;
            while (n2 < n) {
                Object e = this.mElems.elementAt(n2);
                long l3 = e instanceof PCollNode ? ((PCollNode)e).mNumOfObjs : ((PersistentMarker)e).mNumOfObjs;
                if (l3 > l) {
                    ++this.mNumOfObjs;
                    this.setPCollChanged(true);
                    ((PCollNode)this.getElemAt(n2)).insertObjectAt(pCollPersistable, l);
                    return;
                }
                l -= l3;
                ++n2;
            }
            throw new ArrayIndexOutOfBoundsException("PCollNode.insertObjectAt index=" + l2);
        }
        this.mColl.notifyPCollEvent(4, this, "nodeRecentlyUsed/insertObjectAt.leaf");
        this.mColl.nodeRecentlyUsed(this);
        ++this.mNumOfObjs;
        pCollPersistable.setPCollParentId(this.mNodeId);
        this.setPCollChanged(true);
        this.mElems.insertElementAt(pCollPersistable, (int)l);
        this.mColl.addToActiveTab(pCollPersistable);
        this.checkForSplit();
    }

    void setObjectAt(PCollPersistable pCollPersistable, long l) {
        long l2;
        long l3 = l;
        if (!this.mIsLeaf) {
            int n = this.mElems.size();
            int n2 = 0;
            while (n2 < n) {
                Object e = this.mElems.elementAt(n2);
                long l4 = e instanceof PCollNode ? ((PCollNode)e).mNumOfObjs : ((PersistentMarker)e).mNumOfObjs;
                if (l4 > l) {
                    ((PCollNode)this.getElemAt(n2)).setObjectAt(pCollPersistable, l);
                    return;
                }
                l -= l4;
                ++n2;
            }
            throw new ArrayIndexOutOfBoundsException("PCollNode.setObjectAt index=" + l3);
        }
        this.mColl.notifyPCollEvent(4, this, "nodeRecentlyUsed/setObjectAt.leaf");
        this.mColl.nodeRecentlyUsed(this);
        pCollPersistable.setPCollParentId(this.mNodeId);
        this.setPCollChanged(true);
        Object e = this.mElems.elementAt((int)l);
        boolean bl = false;
        if (e instanceof PCollPersistable) {
            l2 = ((PCollPersistable)e).getPersistentId();
            bl = ((PCollPersistable)e).getHasBeenPersisted();
        } else {
            l2 = ((PersistentMarker)e).mPersistentId;
            bl = true;
            --this.mNumPassivatedElems;
        }
        if (e != null && this.mColl.getPersistManager() != null && bl) {
            if (this.mColl.count_persMgrCalls > 0) {
                Diagnostic.ASSERT(false, "Recursion/Reentrancy into PersistManager.delete");
            }
            ++this.mColl.count_persMgrCalls;
            this.mColl.getPersistManager().delete(l2, this.mColl.getId());
            --this.mColl.count_persMgrCalls;
        }
        this.mColl.removeFromActiveTab(l2);
        this.mElems.setElementAt(pCollPersistable, (int)l);
        this.mColl.addToActiveTab(pCollPersistable);
    }

    void removeAllObjects() {
        if (!this.mIsLeaf) {
            int n = this.mElems.size();
            int n2 = 0;
            while (n2 < n) {
                Object var10_4;
                PCollNode pCollNode = (PCollNode)this.getElemAt(n2);
                try {
                    ++pCollNode.mLockCount;
                    pCollNode.removeAllObjects();
                    this.mColl.dropFromRUChain(pCollNode);
                    if (this.mIsLeaf) {
                        this.mColl.decrNumActiveLeafNodes();
                    }
                    var10_4 = null;
                    --pCollNode.mLockCount;
                }
                catch (Throwable throwable) {
                    var10_4 = null;
                    --pCollNode.mLockCount;
                    throw throwable;
                }
                ++n2;
            }
            this.mNumOfObjs = 0L;
            this.setPCollChanged(true);
            return;
        }
        int n = 0;
        while (n < this.mElems.size()) {
            long l;
            Object e = this.mElems.elementAt(n);
            boolean bl = false;
            if (e instanceof PCollPersistable) {
                l = ((PCollPersistable)e).getPersistentId();
                bl = ((PCollPersistable)e).getHasBeenPersisted();
            } else {
                l = ((PersistentMarker)e).mPersistentId;
                bl = true;
            }
            if (e != null && this.mColl.getPersistManager() != null && bl) {
                if (this.mColl.count_persMgrCalls > 0) {
                    Diagnostic.ASSERT(false, "Recursion/Reentrancy into PersistManager.delete");
                }
                ++this.mColl.count_persMgrCalls;
                this.mColl.getPersistManager().delete(l, this.mColl.getId());
                --this.mColl.count_persMgrCalls;
            }
            this.mColl.removeFromActiveTab(l);
            ++n;
        }
        this.mElems.removeAllElements();
        this.setPCollChanged(true);
        this.mNumOfObjs = 0L;
        this.mNumPassivatedElems = 0;
    }

    void removeObjectAt(long l) {
        long l2;
        long l3 = l;
        if (!this.mIsLeaf) {
            int n = this.mElems.size();
            int n2 = 0;
            while (n2 < n) {
                Object e = this.mElems.elementAt(n2);
                long l4 = e instanceof PCollNode ? ((PCollNode)e).mNumOfObjs : ((PersistentMarker)e).mNumOfObjs;
                if (l4 > l) {
                    --this.mNumOfObjs;
                    this.setPCollChanged(true);
                    ((PCollNode)this.getElemAt(n2)).removeObjectAt(l);
                    return;
                }
                l -= l4;
                ++n2;
            }
            throw new ArrayIndexOutOfBoundsException("PCollNode.removeObjectAt index=" + l3);
        }
        this.mColl.notifyPCollEvent(4, this, "nodeRecentlyUsed/removeObjectAt.leaf");
        this.mColl.nodeRecentlyUsed(this);
        --this.mNumOfObjs;
        this.setPCollChanged(true);
        Object e = this.mElems.elementAt((int)l);
        boolean bl = false;
        if (e instanceof PCollPersistable) {
            l2 = ((PCollPersistable)e).getPersistentId();
            bl = ((PCollPersistable)e).getHasBeenPersisted();
        } else {
            l2 = ((PersistentMarker)e).mPersistentId;
            bl = true;
            --this.mNumPassivatedElems;
        }
        if (e != null && this.mColl.getPersistManager() != null && bl) {
            if (this.mColl.count_persMgrCalls > 0) {
                Diagnostic.ASSERT(false, "Recursion/Reentrancy into PersistManager.delete");
            }
            ++this.mColl.count_persMgrCalls;
            this.mColl.getPersistManager().delete(l2, this.mColl.getId());
            --this.mColl.count_persMgrCalls;
        }
        this.mElems.removeElementAt((int)l);
        this.mColl.removeFromActiveTab(l2);
        this.checkForMerge();
    }

    long indexOfFirstObj() {
        if (this.mParent == null) {
            return 0L;
        }
        PCollNode pCollNode = this.getLeftSib(true);
        if (pCollNode != null) {
            return pCollNode.indexOfFirstObj() + pCollNode.mNumOfObjs;
        }
        return this.mParent.indexOfFirstObj();
    }

    long indexOf(PCollPersistable pCollPersistable) {
        long l = this.mElems.indexOf(pCollPersistable);
        if (l < 0L) {
            return l;
        }
        return this.indexOfFirstObj() + l;
    }

    void addToActiveTabRecurse() {
        this.mColl.addToActiveTab(this);
        int n = 0;
        while (n < this.mElems.size()) {
            Object e = this.mElems.elementAt(n);
            if (e instanceof PCollNode) {
                ((PCollNode)e).addToActiveTabRecurse();
            } else if (e instanceof PCollPersistable) {
                this.mColl.addToActiveTab((PCollPersistable)e);
            }
            ++n;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

