/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common.ws;

import com.sun.java.util.collections.HashMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import oracle.jbo.ApplicationModule;
import oracle.jbo.AttributeDef;
import oracle.jbo.AttributeList;
import oracle.jbo.DeleteEvent;
import oracle.jbo.InsertEvent;
import oracle.jbo.InvalidOperException;
import oracle.jbo.InvalidParamException;
import oracle.jbo.NameValuePairs;
import oracle.jbo.NavigationEvent;
import oracle.jbo.NoDefException;
import oracle.jbo.NoObjException;
import oracle.jbo.RangeRefreshEvent;
import oracle.jbo.Row;
import oracle.jbo.RowSet;
import oracle.jbo.RowSetIterator;
import oracle.jbo.RowSetListener;
import oracle.jbo.ScrollEvent;
import oracle.jbo.UpdateEvent;
import oracle.jbo.Variable;
import oracle.jbo.VariableManager;
import oracle.jbo.VariableManagerOwner;
import oracle.jbo.VariableValueManager;
import oracle.jbo.ViewObject;
import oracle.jbo.common.AccTravDef;
import oracle.jbo.common.AccTravDefImpl;
import oracle.jbo.common.AccTravInvoke;
import oracle.jbo.common.AccTravInvokeImpl;
import oracle.jbo.common.AccTravQualAllImpl;
import oracle.jbo.common.AccTravQualifier;
import oracle.jbo.common.DataCollector;
import oracle.jbo.common.JboEnvUtil;
import oracle.jbo.common.SvcMsgResponseValues;
import oracle.jbo.common.ws.WSApplicationModuleImpl;
import oracle.jbo.common.ws.WSObject;
import oracle.jbo.common.ws.WSRowSet;
import oracle.jbo.common.ws.WSRowSetIteratorBase;
import oracle.jbo.common.ws.WSRowSetIteratorImpl;
import oracle.jbo.common.ws.WSRowSetMarshaller;
import oracle.jbo.common.ws.WSViewObjectImpl;
import oracle.jbo.server.ViewRowImpl;
import oracle.svcmsg.ResponseValues;
import oracle.xml.parser.v2.XSLStylesheet;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WSRowSetImpl
extends WSRowSetIteratorBase
implements RowSetListener,
Serializable,
WSRowSet {
    private ArrayList mRowSetIterators;
    private boolean mIsDefault;
    private ArrayList mWhereClauseParams;
    private boolean mIsForwardOnly;
    private byte mAccessMode;
    private boolean mIsAssociationConsistent;
    private boolean mExecuteQuery;
    private boolean mExecuteQueryResetCurr;
    private boolean mExecuteQueryForce;
    private boolean mRefreshDataModel;
    private boolean mRequestEstimatedRowCount;
    private String[] mAttributeAccessorPath;
    private AccTravDef mAccTravDef;
    private static final int CHANGE_RS_WHERE_CLAUSE_PARAMS = 0;
    private static final int CHANGE_RS_IS_FORWARD_ONLY = 1;
    private static final int CHANGE_RS_ACCESS_MODE = 2;
    private static final int CHANGE_RS_IS_ASSOCIATION_CONSISTENT = 3;
    private static final int CHANGE_RS_END = 4;
    private boolean mIsRangeSizeChanged;
    private transient RowSet mRS;
    private transient WSViewObjectImpl mParent;
    private transient WSRowSetIteratorImpl mDefaultRSI;
    private transient boolean mIsListening;
    private transient RowSet[] mDetailRowSets;
    private static /* synthetic */ Class class$oracle$jbo$CSMessageBundle;

    private /* synthetic */ void $init$() {
        this.mRowSetIterators = new ArrayList(4);
        this.mWhereClauseParams = new ArrayList(4);
        this.mIsForwardOnly = false;
        this.mAccessMode = 0;
        this.mIsAssociationConsistent = false;
        this.mExecuteQuery = false;
        this.mExecuteQueryResetCurr = false;
        this.mExecuteQueryForce = false;
        this.mRefreshDataModel = false;
        this.mRequestEstimatedRowCount = false;
        this.mAccTravDef = null;
        this.mIsRangeSizeChanged = false;
        this.mRS = null;
        this.mParent = null;
        this.mDefaultRSI = null;
        this.mIsListening = false;
        this.mDetailRowSets = null;
    }

    WSRowSetImpl(String string, boolean bl, boolean bl2, WSViewObjectImpl wSViewObjectImpl) {
        super(string);
        this.$init$();
        this.mIsDefault = bl2;
        this.mParent = wSViewObjectImpl;
        this.mId = wSViewObjectImpl.registerObject(this);
        this.mObjStat = bl ? 0 : (this.isClient() ? 3 : 1);
        this.afterCreate();
        this.getDefaultRowSetIterator();
    }

    int getNumChangeFlags() {
        return 4;
    }

    public boolean isOnLine() {
        return this.mParent.isOnLine();
    }

    public WSObject getParent() {
        return this.mParent;
    }

    public void setAccessorTraversalByNamePaths(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            this.setAccessorTraversalDef(null);
            return;
        }
        ArrayList<AccTravQualAllImpl> arrayList = new ArrayList<AccTravQualAllImpl>(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            StringTokenizer stringTokenizer = new StringTokenizer(stringArray[n], "/");
            AccTravQualAllImpl accTravQualAllImpl = null;
            AccTravInvokeImpl accTravInvokeImpl = null;
            while (stringTokenizer.hasMoreTokens()) {
                AccTravInvokeImpl accTravInvokeImpl2 = new AccTravInvokeImpl(stringTokenizer.nextToken());
                AccTravQualAllImpl accTravQualAllImpl2 = new AccTravQualAllImpl(new AccTravInvoke[]{accTravInvokeImpl2});
                if (accTravInvokeImpl != null) {
                    accTravInvokeImpl.setAccTravDef(new AccTravDefImpl(null, new AccTravQualifier[]{accTravQualAllImpl2}));
                }
                if (accTravQualAllImpl == null) {
                    accTravQualAllImpl = accTravQualAllImpl2;
                }
                accTravInvokeImpl = accTravInvokeImpl2;
            }
            if (accTravQualAllImpl != null) {
                arrayList.add(accTravQualAllImpl);
            }
            ++n;
        }
        if (arrayList.size() > 0) {
            AccTravQualifier[] accTravQualifierArray = new AccTravQualifier[arrayList.size()];
            arrayList.toArray(accTravQualifierArray);
            this.setAccessorTraversalDef(new AccTravDefImpl(null, accTravQualifierArray));
        } else {
            this.setAccessorTraversalDef(null);
        }
    }

    public AccTravDef getAccessorTraversalDef() {
        return this.mAccTravDef;
    }

    public void setAccessorTraversalDef(AccTravDef accTravDef) {
        this.mAccTravDef = accTravDef;
        this.refreshDataModel2(false, false);
    }

    public boolean hasAccessorTraversalDef() {
        return this.mAccTravDef != null;
    }

    RowSetIterator getRowSetIterator() {
        return this.getRowSetImpl();
    }

    RowSet getRowSetImpl() {
        ViewObject viewObject;
        if (this.mRS == null && this.mObjStat == 3 && this.mParent != null && this.isClient() && (viewObject = this.mParent.getViewObjectImpl()) != null) {
            this.mRS = viewObject.findRowSet(this.mName);
            this.mObjStat = this.mRS != null ? 4 : 1;
        }
        return this.mRS;
    }

    void setRowSetImpl(RowSet rowSet) {
        this.mRS = rowSet;
        this.registerWSListeners();
        if (rowSet != null) {
            ((WSApplicationModuleImpl)this.getApplicationModule()).registerImplToWSObject(this.mRS, this);
        }
    }

    public Object getImplObject() {
        return this.getRowSetImpl();
    }

    public void setImplObject(Object object) {
        this.setRowSetImpl((RowSet)object);
    }

    int getBatchCommMode() {
        return ((WSApplicationModuleImpl)this.getApplicationModule()).getBatchCommMode();
    }

    public void markForError(Exception exception, boolean bl) {
        if (!bl) {
            this.mObjStat = -1;
            this.mParent.removeRowSet(this);
            this.mParent = null;
        }
    }

    boolean isDefault() {
        return this.mIsDefault;
    }

    int registerObject(Object object) {
        return this.mParent.registerObject(object);
    }

    RowSetIterator getDefaultRowSetIterator() {
        if (this.mDefaultRSI == null) {
            this.mDefaultRSI = new WSRowSetIteratorImpl(this.getName(), 1, true, this);
            this.mRowSetIterators.add(this.mDefaultRSI);
        }
        return this.mDefaultRSI;
    }

    void removeRowSetIterator(RowSetIterator rowSetIterator) {
        if (this.mRowSetIterators.contains(rowSetIterator)) {
            this.mRowSetIterators.remove(rowSetIterator);
        }
        if (this.mDefaultRSI == rowSetIterator) {
            this.mDefaultRSI = null;
        }
    }

    void beforeSend(List list) {
        this.getRowSetImpl();
        if (this.mObjStat == 3 || this.mObjStat == 4) {
            this.mObjStat = 1;
        }
        this.getVariableOpers();
        int n = 0;
        while (n < this.mRowSetIterators.size()) {
            WSRowSetIteratorImpl wSRowSetIteratorImpl = (WSRowSetIteratorImpl)this.mRowSetIterators.get(n);
            wSRowSetIteratorImpl.beforeSend(list);
            ++n;
        }
    }

    void afterSend() {
        this.resetVariableOpers();
        if (this.mObjStat == 100) {
            this.mParent.removeRowSet(this);
            return;
        }
        this.mObjStat = 5;
        this.mExecuteQuery = false;
        this.mExecuteQueryResetCurr = false;
        this.mExecuteQueryForce = false;
        this.mRequestEstimatedRowCount = false;
        this.mAttributeAccessorPath = null;
        this.mIsRangeSizeChanged = false;
        this.clearChangeFlags();
        int n = 0;
        while (n < this.mRowSetIterators.size()) {
            WSRowSetIteratorImpl wSRowSetIteratorImpl = (WSRowSetIteratorImpl)this.mRowSetIterators.get(n);
            wSRowSetIteratorImpl.afterSend();
            ++n;
        }
    }

    void afterActivation(int n) {
        if (n == 1) {
            this.mRefreshDataModel = true;
            this.mExecuteQuery = true;
        }
        int n2 = 0;
        while (n2 < this.mRowSetIterators.size()) {
            WSRowSetIteratorImpl wSRowSetIteratorImpl = (WSRowSetIteratorImpl)this.mRowSetIterators.get(n2);
            wSRowSetIteratorImpl.afterActivation(n);
            ++n2;
        }
    }

    void setRangeSizeChanged(boolean bl) {
        this.mIsRangeSizeChanged = bl;
    }

    void doInit() {
        if (this.mObjStat == -1) {
            return;
        }
        try {
            RowSet rowSet;
            ViewObject viewObject = this.mParent.getViewObjectImpl();
            if (this.mIsDefault) {
                rowSet = viewObject;
            } else if (this.mObjStat == 0) {
                rowSet = viewObject.createRowSet(this.getName());
            } else {
                rowSet = viewObject.findRowSet(this.getName());
                if (rowSet == null) {
                    throw new NoObjException(112, this.getName());
                }
                if (this.mObjStat == 100) {
                    rowSet.closeRowSet();
                    return;
                }
            }
            this.setRowSetImpl(rowSet);
            if (this.applyVariableOpers()) {
                ((WSRowSetMarshaller)((Object)rowSet)).refreshWhereClauseParams();
            }
            if (this.getChangeFlag(0)) {
                rowSet.setWhereClauseParams(null);
                int n = 0;
                while (n < this.mWhereClauseParams.size()) {
                    rowSet.setWhereClauseParam(n, this.mWhereClauseParams.get(n));
                    ++n;
                }
            }
            if (this.getChangeFlag(3)) {
                rowSet.setAssociationConsistent(this.mIsAssociationConsistent);
            }
            if (this.getChangeFlag(1)) {
                rowSet.setForwardOnly(this.mIsForwardOnly);
            }
            if (this.getChangeFlag(2)) {
                rowSet.setAccessMode(this.mAccessMode);
            }
            int n = 0;
            while (n < this.mRowSetIterators.size()) {
                WSRowSetIteratorImpl wSRowSetIteratorImpl = (WSRowSetIteratorImpl)this.mRowSetIterators.get(n);
                if (wSRowSetIteratorImpl.isDefault()) {
                    this.mDefaultRSI = wSRowSetIteratorImpl;
                }
                ++n;
            }
            int n2 = 0;
            while (n2 < this.mRowSetIterators.size()) {
                WSRowSetIteratorImpl wSRowSetIteratorImpl = (WSRowSetIteratorImpl)this.mRowSetIterators.get(n2);
                wSRowSetIteratorImpl.doInit();
                ++n2;
            }
            this.mDetailRowSets = rowSet.getDetailRowSets();
            if (this.mDetailRowSets != null && this.mDetailRowSets.length > 0) {
                rowSet.addListener(this);
                this.mIsListening = true;
            }
        }
        catch (Exception exception) {
            this.processWSException(exception);
        }
    }

    void doInit2() {
        RowSet rowSet;
        RowSetIterator[] rowSetIteratorArray;
        if (this.mObjStat == -1 || this.mObjStat == 100) {
            return;
        }
        if (!(this.mExecuteQuery && this.mRefreshDataModel || (rowSetIteratorArray = (rowSet = this.getRowSetImpl()).getMasterRowSetIterators()) == null || rowSetIteratorArray.length <= 0 || this.mDetailRowSets == null || this.mDetailRowSets.length <= 0)) {
            WSApplicationModuleImpl wSApplicationModuleImpl = (WSApplicationModuleImpl)this.getApplicationModule();
            int n = 0;
            while (n < this.mDetailRowSets.length) {
                WSRowSet wSRowSet;
                WSObject wSObject = wSApplicationModuleImpl.getWSObjectFromImpl(this.mDetailRowSets[n]);
                if (wSObject instanceof WSRowSet && (wSRowSet = (WSRowSet)((Object)wSObject)).isExecuteQuery() && wSRowSet.isRefreshDataModel()) {
                    this.refreshDataModel2(false, false);
                }
                ++n;
            }
        }
    }

    void addDMMarker(WSApplicationModuleImpl wSApplicationModuleImpl, RowSet rowSet) {
        int n = wSApplicationModuleImpl.getRemoteObjectId(rowSet);
        SvcMsgResponseValues svcMsgResponseValues = new SvcMsgResponseValues(4199, wSApplicationModuleImpl.getResponseName());
        svcMsgResponseValues.setIntValues(new int[]{n});
        wSApplicationModuleImpl.addResponse(svcMsgResponseValues);
    }

    private void addEndExecuteMarker() {
        WSApplicationModuleImpl wSApplicationModuleImpl = (WSApplicationModuleImpl)this.getApplicationModule();
        SvcMsgResponseValues svcMsgResponseValues = new SvcMsgResponseValues(4200, wSApplicationModuleImpl.getResponseName());
        wSApplicationModuleImpl.addResponse(svcMsgResponseValues);
    }

    void doWork() {
        if (this.mObjStat == -1 || this.mObjStat == 100) {
            return;
        }
        try {
            RowSet rowSet = this.getRowSetImpl();
            if (this.mExecuteQuery) {
                WSApplicationModuleImpl wSApplicationModuleImpl = (WSApplicationModuleImpl)this.getApplicationModule();
                if (this.mRefreshDataModel) {
                    this.addDMMarker(wSApplicationModuleImpl, rowSet);
                }
                RowSetIterator[] rowSetIteratorArray = rowSet.getMasterRowSetIterators();
                if (this.mExecuteQueryForce) {
                    if (rowSetIteratorArray == null || rowSetIteratorArray.length == 0) {
                        rowSet.executeQuery();
                    } else {
                        ((WSRowSetMarshaller)((Object)rowSet)).executeEmptyRowSet();
                    }
                } else if (rowSetIteratorArray == null || rowSetIteratorArray.length == 0) {
                    ((WSRowSetMarshaller)((Object)rowSet)).refreshCollection(null, this.mExecuteQueryResetCurr, true);
                }
                this.addEndExecuteMarker();
            }
            if (this.mRequestEstimatedRowCount) {
                WSApplicationModuleImpl wSApplicationModuleImpl = (WSApplicationModuleImpl)this.getApplicationModule();
                int n = wSApplicationModuleImpl.getRemoteObjectId(rowSet);
                SvcMsgResponseValues svcMsgResponseValues = new SvcMsgResponseValues(4151, wSApplicationModuleImpl.getResponseName());
                svcMsgResponseValues.setIntValues(new int[]{n});
                svcMsgResponseValues.setLongValues(new long[]{rowSet.getEstimatedRowCount()});
                wSApplicationModuleImpl.addResponse(svcMsgResponseValues);
            }
            int n = 0;
            while (n < this.mRowSetIterators.size()) {
                WSRowSetIteratorImpl wSRowSetIteratorImpl = (WSRowSetIteratorImpl)this.mRowSetIterators.get(n);
                wSRowSetIteratorImpl.doWork();
                ++n;
            }
        }
        catch (Exception exception) {
            this.processWSException(exception);
        }
    }

    void callRSIWorkPart2() {
        int n = 0;
        while (n < this.mRowSetIterators.size()) {
            WSRowSetIteratorImpl wSRowSetIteratorImpl = (WSRowSetIteratorImpl)this.mRowSetIterators.get(n);
            wSRowSetIteratorImpl.doWorkPart2();
            ++n;
        }
    }

    void doWorkPart2() {
        if (this.mObjStat == -1 || this.mObjStat == 100) {
            return;
        }
        try {
            this.doWorkPart2Internal();
        }
        catch (Exception exception) {
            this.processWSException(exception);
        }
    }

    private void doWorkPart2Internal() {
        block21: {
            if (!this.mExecuteQuery || !this.mRefreshDataModel) {
                this.callRSIWorkPart2();
                return;
            }
            WSApplicationModuleImpl wSApplicationModuleImpl = (WSApplicationModuleImpl)this.getApplicationModule();
            RowSet rowSet = this.getRowSetImpl();
            RowSetIterator[] rowSetIteratorArray = rowSet.getMasterRowSetIterators();
            if (rowSetIteratorArray != null && rowSetIteratorArray.length > 0) {
                Object[] objectArray = new Object[rowSetIteratorArray.length];
                ArrayList<Row[]> arrayList = new ArrayList<Row[]>(rowSetIteratorArray.length);
                ArrayList arrayList2 = wSApplicationModuleImpl.getAllRowSetIterators();
                int[] nArray = new int[rowSetIteratorArray.length];
                boolean bl = true;
                int n = 0;
                while (n < rowSetIteratorArray.length) {
                    RowSetIterator rowSetIterator = rowSetIteratorArray[n];
                    int n2 = 0;
                    while (n2 < arrayList2.size()) {
                        WSRowSetIteratorImpl wSRowSetIteratorImpl = (WSRowSetIteratorImpl)arrayList2.get(n2);
                        if (wSRowSetIteratorImpl.getRowSetIterator() == rowSetIterator) {
                            Row[] rowArray = wSRowSetIteratorImpl.getDataModelMasterRows();
                            if (rowArray == null || rowArray.length == 0) {
                                bl = false;
                                break;
                            }
                            arrayList.add(rowArray);
                            nArray[n] = rowArray.length;
                            break;
                        }
                        ++n2;
                    }
                    if (!bl || n2 >= arrayList2.size()) {
                        bl = false;
                        break;
                    }
                    objectArray[n] = wSApplicationModuleImpl.marshal(rowSetIterator);
                    ++n;
                }
                if (bl) {
                    WSRowSetIteratorImpl wSRowSetIteratorImpl = (WSRowSetIteratorImpl)this.getDefaultRowSetIterator();
                    Object[] objectArray2 = wSRowSetIteratorImpl.getRowFilterValues();
                    Row[] rowArray = new Row[nArray.length];
                    int[] nArray2 = new int[nArray.length];
                    Row[] rowArray2 = (Row[])arrayList.get(0);
                    int n3 = wSApplicationModuleImpl.getRemoteObjectId(rowSet);
                    wSApplicationModuleImpl.setDataModelRefresh(true);
                    SvcMsgResponseValues svcMsgResponseValues = new SvcMsgResponseValues(4331, wSApplicationModuleImpl.getResponseName());
                    svcMsgResponseValues.setIntValues(new int[]{n3});
                    svcMsgResponseValues.setObjectValues(objectArray);
                    wSApplicationModuleImpl.addResponse(svcMsgResponseValues);
                    try {
                        int n4 = 0;
                        while (n4 < rowArray2.length) {
                            nArray2[0] = n4;
                            int n5 = 1;
                            while (n5 < nArray.length) {
                                nArray2[n5] = 0;
                                ++n5;
                            }
                            block6: while (true) {
                                Object[] objectArray3;
                                int[] nArray3 = new int[rowArray.length];
                                n5 = 0;
                                while (n5 < nArray2.length) {
                                    rowArray[n5] = ((Row[])arrayList.get(n5))[nArray2[n5]];
                                    nArray3[n5] = (Integer)((ViewRowImpl)rowArray[n5]).getHandle();
                                    ++n5;
                                }
                                svcMsgResponseValues = new SvcMsgResponseValues(4198, wSApplicationModuleImpl.getResponseName());
                                svcMsgResponseValues.setIntValues(nArray3);
                                wSApplicationModuleImpl.addResponse(svcMsgResponseValues);
                                if (this.mExecuteQueryForce) {
                                    objectArray3 = ((WSRowSetMarshaller)((Object)rowSet)).executeDetailQuery(rowArray);
                                } else {
                                    boolean bl2 = this.mExecuteQueryResetCurr;
                                    boolean bl3 = false;
                                    if (this.mIsRangeSizeChanged) {
                                        bl3 = ((WSRowSetMarshaller)((Object)rowSet)).doesRowFilterMatch(rowArray, objectArray2);
                                        if (bl3) {
                                            wSRowSetIteratorImpl.setRowFilterValues();
                                            wSRowSetIteratorImpl.syncIteratorState();
                                        } else {
                                            bl2 = true;
                                        }
                                    }
                                    objectArray3 = ((WSRowSetMarshaller)((Object)rowSet)).refreshCollection(rowArray, bl2, true);
                                }
                                svcMsgResponseValues.setLongValues(new long[]{this.mRequestEstimatedRowCount ? ((WSRowSetMarshaller)((Object)rowSet)).getDetailEstimatedRowCount(rowArray) : (long)-1});
                                svcMsgResponseValues.setObjectValues(objectArray3);
                                this.addEndExecuteMarker();
                                n5 = nArray.length - 1;
                                while (n5 > 0) {
                                    int n6 = n5;
                                    nArray2[n6] = nArray2[n6] + 1;
                                    if (nArray2[n5] != nArray[n5]) break;
                                    nArray2[n5] = -1;
                                    --n5;
                                }
                                if (n5 == 0) break;
                                int n7 = n5 + 1;
                                while (true) {
                                    if (n7 >= nArray2.length) continue block6;
                                    nArray2[n7] = 0;
                                    ++n7;
                                }
                                break;
                            }
                            ++n4;
                        }
                        Object var29_28 = null;
                        svcMsgResponseValues = new SvcMsgResponseValues(4332, wSApplicationModuleImpl.getResponseName());
                    }
                    catch (Throwable throwable) {
                        Object var29_29 = null;
                        svcMsgResponseValues = new SvcMsgResponseValues(4332, wSApplicationModuleImpl.getResponseName());
                        svcMsgResponseValues.setIntValues(new int[]{n3});
                        wSApplicationModuleImpl.addResponse(svcMsgResponseValues);
                        wSApplicationModuleImpl.setDataModelRefresh(false);
                        throw throwable;
                    }
                    svcMsgResponseValues.setIntValues(new int[]{n3});
                    wSApplicationModuleImpl.addResponse(svcMsgResponseValues);
                    wSApplicationModuleImpl.setDataModelRefresh(false);
                    {
                        break block21;
                    }
                }
                ((WSRowSetMarshaller)((Object)rowSet)).refreshCollection(null, this.mExecuteQueryResetCurr, true);
            }
        }
        this.processAccessorAttributes();
        this.callRSIWorkPart2();
    }

    void doFinish(boolean bl) {
        if (this.mObjStat == -1 || this.mObjStat == 100) {
            return;
        }
        try {
            WSRowSetIteratorImpl wSRowSetIteratorImpl;
            Row[] rowArray;
            int n = 0;
            while (n < this.mRowSetIterators.size()) {
                WSRowSetIteratorImpl wSRowSetIteratorImpl2 = (WSRowSetIteratorImpl)this.mRowSetIterators.get(n);
                wSRowSetIteratorImpl2.doFinish(bl);
                ++n;
            }
            if (bl) {
                if (this.mIsListening) {
                    this.getRowSetImpl().removeListener(this);
                    this.mIsListening = false;
                }
            } else if (this.mDetailRowSets != null && this.mDetailRowSets.length > 0 && (rowArray = (wSRowSetIteratorImpl = (WSRowSetIteratorImpl)this.getDefaultRowSetIterator()).getCachedDataModelMasterRows()) != null) {
                boolean bl2 = false;
                int n2 = 0;
                while (n2 < this.mDetailRowSets.length) {
                    RowSet rowSet;
                    WSApplicationModuleImpl wSApplicationModuleImpl = (WSApplicationModuleImpl)this.getApplicationModule();
                    WSObject wSObject = wSApplicationModuleImpl.getWSObjectFromImpl(rowSet = this.mDetailRowSets[n2]);
                    if (wSObject instanceof WSRowSet) {
                        if (!bl2) {
                            this.addDMMarker(wSApplicationModuleImpl, this.getRowSetImpl());
                            bl2 = true;
                        }
                        WSRowSet wSRowSet = (WSRowSet)((Object)wSObject);
                        wSRowSet.executeQuery2(false, false);
                        if (wSRowSet instanceof WSViewObjectImpl) {
                            ((WSViewObjectImpl)wSRowSet).doWorkPart2();
                        } else if (wSRowSet instanceof WSRowSetImpl) {
                            ((WSRowSetImpl)wSRowSet).doWorkPart2();
                        }
                    }
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            this.processWSException(exception);
        }
    }

    ArrayList collectRowSetIterators(ArrayList arrayList) {
        int n = 0;
        while (n < this.mRowSetIterators.size()) {
            WSRowSetIteratorImpl wSRowSetIteratorImpl = (WSRowSetIteratorImpl)this.mRowSetIterators.get(n);
            arrayList.add(wSRowSetIteratorImpl);
            ++n;
        }
        return arrayList;
    }

    public boolean setMasterRowSetIterator(RowSetIterator rowSetIterator) {
        if (this.mRS != null && (this.getBatchCommMode() & 0x40) != 0) {
            return this.mRS.setMasterRowSetIterator(rowSetIterator);
        }
        this.invalidOperation("setMasterRowSetIterator");
        return false;
    }

    public ViewObject getViewObject() {
        return this.mParent;
    }

    public void setWhereClauseParams(Object[] objectArray) {
        this.mWhereClauseParams.clear();
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                this.mWhereClauseParams.add(objectArray[n]);
                ++n;
            }
        }
        if (!this.isClient()) {
            RowSet rowSet = this.getRowSetImpl();
            rowSet.setWhereClauseParams(objectArray);
        } else {
            this.setChangeFlag(0, true);
        }
    }

    public void setWhereClauseParam(int n, Object object) {
        if (n >= this.mWhereClauseParams.size()) {
            JboEnvUtil.setSizeInArrayList(this.mWhereClauseParams, n + 1);
        }
        this.mWhereClauseParams.set(n, object);
        if (!this.isClient()) {
            RowSet rowSet = this.getRowSetImpl();
            rowSet.setWhereClauseParam(n, object);
        } else {
            this.setChangeFlag(0, true);
        }
    }

    public void defineNamedWhereClauseParam(String string, Object object, int[] nArray) {
        WSViewObjectImpl wSViewObjectImpl;
        VariableValueManager variableValueManager = this.mParent.ensureVariableManager();
        Variable variable = variableValueManager.lookupVariable(string);
        VariableManagerOwner variableManagerOwner = wSViewObjectImpl = this.getImplObject() == null ? this.mParent : (VariableManagerOwner)this.mParent.getImplObject();
        if (variable != null) {
            VariableManager variableManager = variable.getVariableManager();
            if (variableManager.getVarMgrOwner() != wSViewObjectImpl) {
                variable = null;
            } else {
                String string2 = variable.getVariableKind();
                if (string2 == null || string2.equals("where")) {
                    if (string2 == null) {
                        variable.setVariableKind("where");
                    }
                    variable.setExtendedData(nArray);
                    variable.setDefaultValue(object);
                } else {
                    Class clazz = class$oracle$jbo$CSMessageBundle;
                    if (clazz == null) {
                        clazz = class$oracle$jbo$CSMessageBundle = WSRowSetImpl.class$("oracle.jbo.CSMessageBundle");
                    }
                    throw new InvalidParamException(clazz, "25064", new Object[]{this.getName(), string, string2});
                }
            }
        }
        if (variable == null) {
            variable = variableValueManager.addVariable(string);
            variable.setVariableKind("where");
            variable.setExtendedData(nArray);
            variable.setDefaultValue(object);
        }
    }

    public void removeNamedWhereClauseParam(String string) {
        WSViewObjectImpl wSViewObjectImpl;
        VariableValueManager variableValueManager = this.mParent.getVariableManager();
        if (variableValueManager == null) {
            throw new NoDefException(132, string, this.getName());
        }
        Variable variable = variableValueManager.findVariable(string);
        VariableManager variableManager = variable.getVariableManager();
        VariableManagerOwner variableManagerOwner = variableManager.getVarMgrOwner();
        VariableManagerOwner variableManagerOwner2 = wSViewObjectImpl = this.getImplObject() == null ? this.mParent : (VariableManagerOwner)this.mParent.getImplObject();
        if (variableManagerOwner != wSViewObjectImpl) {
            Class clazz = class$oracle$jbo$CSMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$jbo$CSMessageBundle = WSRowSetImpl.class$("oracle.jbo.CSMessageBundle");
            }
            throw new InvalidOperException(clazz, "25065", new Object[]{string, this.mParent.getName(), variableManagerOwner.getClass().getName()});
        }
        if (!"where".equals(variable.getVariableKind())) {
            Class clazz = class$oracle$jbo$CSMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$jbo$CSMessageBundle = WSRowSetImpl.class$("oracle.jbo.CSMessageBundle");
            }
            throw new InvalidParamException(clazz, "25064", new Object[]{this.getName(), string, variable.getVariableKind()});
        }
        variableManager.removeVariable(string);
    }

    public Object getNamedWhereClauseParam(String string) {
        VariableValueManager variableValueManager = this.ensureVariableManager();
        Variable variable = variableValueManager.findVariable(string);
        String string2 = variable.getVariableKind();
        if (string2 == null || !string2.equals("where")) {
            Class clazz = class$oracle$jbo$CSMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$jbo$CSMessageBundle = WSRowSetImpl.class$("oracle.jbo.CSMessageBundle");
            }
            throw new InvalidParamException(clazz, "25064", new Object[]{this.getName(), string, string2});
        }
        return variableValueManager.getVariableValue(variable);
    }

    public void setNamedWhereClauseParams(AttributeList attributeList) {
        String[] stringArray = attributeList.getAttributeNames();
        Object[] objectArray = attributeList.getAttributeValues();
        int n = 0;
        while (n < stringArray.length) {
            this.setNamedWhereClauseParam(stringArray[n], objectArray[n]);
            ++n;
        }
    }

    public AttributeList getNamedWhereClauseParams() {
        VariableValueManager variableValueManager = this.mParent.getViewObjectImpl().ensureVariableManager();
        Variable[] variableArray = variableValueManager.getVariables();
        Object[] objectArray = new Object[variableArray.length];
        String[] stringArray = new String[variableArray.length];
        int n = 0;
        while (n < variableArray.length) {
            stringArray[n] = variableArray[n].getName();
            objectArray[n] = this.getNamedWhereClauseParam(stringArray[n]);
            ++n;
        }
        return new NameValuePairs(stringArray, objectArray);
    }

    public void setNamedWhereClauseParam(String string, Object object) {
        VariableValueManager variableValueManager = this.ensureVariableManager();
        Variable variable = variableValueManager.findVariable(string);
        String string2 = variable.getVariableKind();
        if (string2 == null || !string2.equals("where")) {
            Class clazz = class$oracle$jbo$CSMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$jbo$CSMessageBundle = WSRowSetImpl.class$("oracle.jbo.CSMessageBundle");
            }
            throw new InvalidParamException(clazz, "25064", new Object[]{this.getName(), string, string2});
        }
        variableValueManager.setVariableValue(variable, object);
    }

    public void skipNamedWhereClauseParam(String string) {
    }

    public Object[] getWhereClauseParams() {
        return this.mWhereClauseParams.toArray();
    }

    boolean willRefresh() {
        return this.mExecuteQuery;
    }

    boolean willRefreshDataModel() {
        return this.mExecuteQuery && this.mRefreshDataModel;
    }

    public void executeQuery() {
        this.executeQuery2(true, true);
    }

    public void executeQuery2(boolean bl, boolean bl2) {
        this.markForExecuteQuery(bl, bl2);
        WSApplicationModuleImpl wSApplicationModuleImpl = (WSApplicationModuleImpl)this.getApplicationModule();
        if (!this.isClient()) {
            RowSet rowSet = this.getRowSetImpl();
            if (this.mExecuteQueryForce) {
                rowSet.executeQuery();
            } else {
                ((WSRowSetMarshaller)((Object)rowSet)).refreshCollection(null, this.mExecuteQueryResetCurr, true);
            }
            this.mExecuteQuery = false;
            this.mExecuteQueryForce = false;
            return;
        }
        int n = 0;
        while (n < this.mRowSetIterators.size()) {
            RowSet[] rowSetArray;
            WSRowSetIteratorImpl wSRowSetIteratorImpl = (WSRowSetIteratorImpl)this.mRowSetIterators.get(n);
            RowSetIterator rowSetIterator = wSRowSetIteratorImpl.getRowSetIterator();
            if (rowSetIterator != null && (rowSetArray = rowSetIterator.getDetailRowSets()) != null) {
                int n2 = 0;
                while (n2 < rowSetArray.length) {
                    WSObject wSObject = wSApplicationModuleImpl.getWSObjectFromImpl(rowSetArray[n2]);
                    if (wSObject instanceof RowSet && ((WSRowSet)((Object)wSObject)).isRefreshDataModel()) {
                        ((WSRowSet)((Object)wSObject)).executeQuery2(bl, bl2);
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    public void markForExecuteQuery(boolean bl, boolean bl2) {
        WSApplicationModuleImpl wSApplicationModuleImpl = (WSApplicationModuleImpl)this.getApplicationModule();
        this.mExecuteQuery = true;
        wSApplicationModuleImpl.setIsSyncNeeded(true);
        if (bl) {
            this.mExecuteQueryResetCurr = true;
        }
        if (bl2) {
            this.mExecuteQueryForce = true;
        }
        this.getDefaultRowSetIterator();
    }

    public boolean cancelQuery() {
        return false;
    }

    public boolean isExecuteQuery() {
        return this.mExecuteQuery;
    }

    public boolean isRefreshDataModel() {
        return this.mRefreshDataModel;
    }

    public void refreshDataModel() {
        this.mRefreshDataModel = true;
        this.executeQuery();
    }

    public void refreshDataModel2(boolean bl, boolean bl2) {
        this.mRefreshDataModel = true;
        this.executeQuery2(bl, bl2);
    }

    public boolean isExecuted() {
        if (this.mRS != null) {
            return this.mRS.isExecuted();
        }
        return false;
    }

    public RowSetIterator createRowSetIterator(String string) {
        WSRowSetIteratorImpl wSRowSetIteratorImpl = new WSRowSetIteratorImpl(string, 0, false, this);
        this.mRowSetIterators.add(wSRowSetIteratorImpl);
        return wSRowSetIteratorImpl;
    }

    public RowSetIterator[] getRowSetIterators() {
        RowSetIterator[] rowSetIteratorArray = new RowSetIterator[this.mRowSetIterators.size()];
        this.mRowSetIterators.toArray(rowSetIteratorArray);
        return rowSetIteratorArray;
    }

    public RowSetIterator findRowSetIterator(String string) {
        WSRowSetIteratorImpl wSRowSetIteratorImpl = this.findWSRowSetIterator(string);
        if (wSRowSetIteratorImpl == null) {
            wSRowSetIteratorImpl = new WSRowSetIteratorImpl(string, 1, false, this);
            this.mRowSetIterators.add(wSRowSetIteratorImpl);
        }
        return wSRowSetIteratorImpl;
    }

    public RowSetIterator findOrCreateRowSetIterator(String string) {
        WSRowSetIteratorImpl wSRowSetIteratorImpl = this.findWSRowSetIterator(string);
        if (wSRowSetIteratorImpl == null) {
            wSRowSetIteratorImpl = new WSRowSetIteratorImpl(string, 2, false, this);
            this.mRowSetIterators.add(wSRowSetIteratorImpl);
        }
        return wSRowSetIteratorImpl;
    }

    public WSRowSetIteratorImpl findWSRowSetIterator(String string) {
        int n = 0;
        while (n < this.mRowSetIterators.size()) {
            WSRowSetIteratorImpl wSRowSetIteratorImpl = (WSRowSetIteratorImpl)this.mRowSetIterators.get(n);
            if (wSRowSetIteratorImpl.getName() == null && string == null) {
                return wSRowSetIteratorImpl;
            }
            if (wSRowSetIteratorImpl.getName().equals(string)) {
                return wSRowSetIteratorImpl;
            }
            ++n;
        }
        return null;
    }

    public boolean removeMasterRowSetIterator(RowSetIterator rowSetIterator) {
        if (this.mRS != null && (this.getBatchCommMode() & 0x40) != 0) {
            return this.mRS.removeMasterRowSetIterator(rowSetIterator);
        }
        this.invalidOperation("removeMasterRowSetIterator");
        return false;
    }

    public RowSetIterator[] getMasterRowSetIterators() {
        if (this.mRS != null) {
            return this.mRS.getMasterRowSetIterators();
        }
        this.invalidOperation("getMasterRowSetIterators");
        return null;
    }

    public ApplicationModule getApplicationModule() {
        return this.mParent.getApplicationModule();
    }

    public void requestEstimatedRowCount() {
        this.mRequestEstimatedRowCount = true;
    }

    public long getEstimatedRowCount() {
        if (this.mRS != null) {
            return this.mRS.getEstimatedRowCount();
        }
        this.invalidOperation("getEstimatedRowCount");
        return -1;
    }

    public boolean isForwardOnly() {
        return this.mIsForwardOnly;
    }

    public void setForwardOnly(boolean bl) {
        this.mIsForwardOnly = bl;
        if (!this.isClient()) {
            RowSet rowSet = this.getRowSetImpl();
            rowSet.setForwardOnly(bl);
        } else {
            this.setChangeFlag(1, true);
        }
    }

    public byte getAccessMode() {
        return this.mAccessMode;
    }

    public void setAccessMode(byte by) {
        this.mAccessMode = by;
        if (!this.isClient()) {
            RowSet rowSet = this.getRowSetImpl();
            rowSet.setAccessMode(by);
        } else {
            this.setChangeFlag(2, true);
        }
    }

    public void setAssociationConsistent(boolean bl) {
        this.mIsAssociationConsistent = bl;
        if (!this.isClient()) {
            RowSet rowSet = this.getRowSetImpl();
            rowSet.setAssociationConsistent(bl);
        } else {
            this.setChangeFlag(3, true);
        }
    }

    public boolean isAssociationConsistent() {
        return this.mIsAssociationConsistent;
    }

    public void closeRowSet() {
        if (this.mObjStat == 0) {
            this.mParent.removeRowSet(this);
        }
        this.mObjStat = 100;
    }

    public boolean isFetchComplete() {
        return false;
    }

    public boolean isMaxFetchSizeExceeded() {
        return false;
    }

    public Object getProperty(String string) {
        if (this.mRS != null && (this.getBatchCommMode() & 4) != 0) {
            return this.mRS.getProperty(string);
        }
        this.invalidOperation("getProperty");
        return null;
    }

    public Object refreshProperty(String string) {
        if (this.mRS != null && (this.getBatchCommMode() & 4) != 0) {
            return this.mRS.refreshProperty(string);
        }
        this.invalidOperation("refreshProperty");
        return null;
    }

    public Hashtable getProperties() {
        if (this.mRS != null && (this.getBatchCommMode() & 4) != 0) {
            return this.mRS.getProperties();
        }
        this.invalidOperation("getProperties");
        return null;
    }

    public Node writeXML(int n, long l) {
        return this.writeXML(n, l, null);
    }

    public Node writeXML(int n, long l, XSLStylesheet xSLStylesheet) {
        if (this.mRS != null && (this.getBatchCommMode() & 0x20) != 0) {
            return this.mRS.writeXML(n, l, xSLStylesheet);
        }
        this.invalidOperation("writeXML");
        return null;
    }

    public void readXML(Element element, int n) {
        this.readXML(element, n, null);
    }

    public void readXML(Element element, int n, XSLStylesheet xSLStylesheet) {
        if (this.mRS != null && (this.getBatchCommMode() & 0x20) != 0) {
            this.mRS.readXML(element, n, xSLStylesheet);
        } else {
            this.invalidOperation("readXML");
        }
    }

    public Node writeXML(long l, HashMap hashMap) {
        return this.writeXML(l, hashMap, null);
    }

    public Node writeXML(long l, HashMap hashMap, XSLStylesheet xSLStylesheet) {
        if (this.mRS != null && (this.getBatchCommMode() & 0x20) != 0) {
            return this.mRS.writeXML(l, hashMap, xSLStylesheet);
        }
        this.invalidOperation("writeXML");
        return null;
    }

    public RowSet getRowSet() {
        return this.mIsDefault ? this.mParent.getRowSet() : this;
    }

    public RowSet[] getDetailRowSets() {
        return this.getDefaultRowSetIterator().getDetailRowSets();
    }

    public RowSet createDetailRowSet(String string, String string2) {
        return this.getDefaultRowSetIterator().createDetailRowSet(string, string2);
    }

    public void closeRowSetIterator() {
    }

    public Object getSyncLock() {
        return this.mParent.getSyncLock();
    }

    public int setRangeSize(int n) {
        return this.getDefaultRowSetIterator().setRangeSize(n);
    }

    public int getRangeSize() {
        return this.getDefaultRowSetIterator().getRangeSize();
    }

    public int getRangeStart() {
        return this.getDefaultRowSetIterator().getRangeStart();
    }

    public int setRangeStart(int n) {
        return this.getDefaultRowSetIterator().setRangeStart(n);
    }

    public int scrollRange(int n) {
        return this.getDefaultRowSetIterator().scrollRange(n);
    }

    public int scrollRangeTo(Row row, int n) {
        return this.getDefaultRowSetIterator().scrollRangeTo(row, n);
    }

    public void setRowValidation(boolean bl) {
        this.getDefaultRowSetIterator().setRowValidation(bl);
    }

    public boolean isRowValidation() {
        return this.getDefaultRowSetIterator().isRowValidation();
    }

    public int getIterMode() {
        return this.getDefaultRowSetIterator().getIterMode();
    }

    public void setIterMode(int n) {
        this.getDefaultRowSetIterator().setIterMode(n);
    }

    void resolveAfterLoad(WSViewObjectImpl wSViewObjectImpl) {
        this.mParent = wSViewObjectImpl;
        int n = 0;
        while (n < this.mRowSetIterators.size()) {
            WSRowSetIteratorImpl wSRowSetIteratorImpl = (WSRowSetIteratorImpl)this.mRowSetIterators.get(n);
            wSRowSetIteratorImpl.resolveAfterLoad(this);
            ++n;
        }
    }

    void processAccessorAttributes() {
        if (this.hasAccessorTraversalDef()) {
            WSApplicationModuleImpl wSApplicationModuleImpl = (WSApplicationModuleImpl)this.getApplicationModule();
            WSRowSetIteratorImpl wSRowSetIteratorImpl = (WSRowSetIteratorImpl)this.getDefaultRowSetIterator();
            try {
                wSApplicationModuleImpl.setDataModelRefresh(true);
                wSRowSetIteratorImpl.setRowFilterValues();
                wSRowSetIteratorImpl.syncIteratorState();
                DataCollector dataCollector = wSApplicationModuleImpl.getObjectMarshaller().findOrCreateDataCollector(this.getRowSetImpl());
                int n = this.mAccTravDef.getAccTravLimit();
                if (n == Integer.MIN_VALUE) {
                    n = -1;
                }
                Object object = dataCollector.collectDataRows(this.mAccTravDef, n, this.mExecuteQueryForce);
                wSApplicationModuleImpl.addResponse((Serializable)object);
                Object var7_6 = null;
                wSApplicationModuleImpl.setDataModelRefresh(false);
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                wSApplicationModuleImpl.setDataModelRefresh(false);
                throw throwable;
            }
        }
    }

    static void addAttribute(WSApplicationModuleImpl wSApplicationModuleImpl, RowSet rowSet, StringTokenizer stringTokenizer) {
        while (stringTokenizer.hasMoreTokens()) {
            byte by;
            String string = stringTokenizer.nextToken();
            AttributeDef attributeDef = rowSet.getViewObject().findAttributeDef(string);
            if (attributeDef == null || (by = attributeDef.getAttributeKind()) != 6 && by != 2) continue;
            Row[] rowArray = rowSet.getAllRowsInRange();
            int n = 0;
            while (n < rowArray.length) {
                if (by == 6) {
                    RowSet rowSet2 = (RowSet)rowArray[n].getAttribute(string);
                    wSApplicationModuleImpl.addResponse((ResponseValues)wSApplicationModuleImpl.marshal(rowSet2));
                    rowSet2.getAllRowsInRange();
                    WSRowSetImpl.addAttribute(wSApplicationModuleImpl, rowSet, stringTokenizer);
                }
                ++n;
            }
        }
    }

    void processDataModelMasterRows(Row[] rowArray) {
        if (this.mDetailRowSets != null) {
            ((WSRowSetIteratorImpl)this.getDefaultRowSetIterator()).addDataModelMasterRows(rowArray);
        }
    }

    public void rangeRefreshed(RangeRefreshEvent rangeRefreshEvent) {
        this.processDataModelMasterRows(rangeRefreshEvent.getAllRowsInRange());
    }

    public void rangeScrolled(ScrollEvent scrollEvent) {
        this.processDataModelMasterRows(scrollEvent.getAllRowsInRange());
    }

    public void rowInserted(InsertEvent insertEvent) {
    }

    public void rowDeleted(DeleteEvent deleteEvent) {
    }

    public void rowUpdated(UpdateEvent updateEvent) {
    }

    public void navigated(NavigationEvent navigationEvent) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

