/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common;

import oracle.jbo.ViewCriteria;
import oracle.jbo.ViewCriteriaRow;
import oracle.jbo.ViewObject;
import oracle.jbo.common.SvcMsgDataRow;
import oracle.jbo.common.SvcMsgRequestParams;
import oracle.jbo.common.SvcMsgResponseValues;
import oracle.svcmsg.RequestParams;
import oracle.svcmsg.ResponseValues;

public class ViewCriteriaMarshaller {
    public static ViewCriteria createCriteria(ViewObject viewObject, SvcMsgDataRow[] svcMsgDataRowArray, boolean[] blArray, int[] nArray) {
        ViewCriteria viewCriteria = null;
        if (svcMsgDataRowArray != null) {
            viewCriteria = viewObject.createViewCriteria();
            int n = 0;
            while (n < svcMsgDataRowArray.length) {
                ViewCriteriaRow viewCriteriaRow = new ViewCriteriaRow(viewCriteria, svcMsgDataRowArray[n].getAttributes());
                viewCriteriaRow.setUpperColumns(blArray[n]);
                viewCriteriaRow.setConjunction(nArray[n]);
                viewCriteria.addElement(viewCriteriaRow);
                ++n;
            }
        }
        return viewCriteria;
    }

    public static ViewCriteria fromSvcMsg(ViewObject viewObject, RequestParams requestParams) {
        ViewCriteria viewCriteria = null;
        SvcMsgDataRow[] svcMsgDataRowArray = (SvcMsgDataRow[])requestParams.getObjectParams()[0];
        boolean[] blArray = (boolean[])requestParams.getObjectParams()[1];
        int[] nArray = (int[])requestParams.getObjectParams()[2];
        if (svcMsgDataRowArray != null) {
            viewCriteria = ViewCriteriaMarshaller.createCriteria(viewObject, svcMsgDataRowArray, blArray, nArray);
            viewCriteria.setCriteriaForQuery(requestParams.getBooleanParams()[0]);
            viewCriteria.setUseAttributeFormatHint(requestParams.getBooleanParams()[1]);
        }
        return viewCriteria;
    }

    public static ViewCriteria fromSvcMsgResp(ViewObject viewObject, ResponseValues responseValues) {
        ViewCriteria viewCriteria = null;
        SvcMsgDataRow[] svcMsgDataRowArray = (SvcMsgDataRow[])responseValues.getObjectValues()[0];
        boolean[] blArray = (boolean[])responseValues.getObjectValues()[1];
        int[] nArray = (int[])responseValues.getObjectValues()[2];
        if (svcMsgDataRowArray != null) {
            viewCriteria = ViewCriteriaMarshaller.createCriteria(viewObject, svcMsgDataRowArray, blArray, nArray);
            viewCriteria.setCriteriaForQuery(responseValues.getBooleanValues()[0]);
            viewCriteria.setUseAttributeFormatHint(responseValues.getBooleanValues()[1]);
        }
        return viewCriteria;
    }

    public static SvcMsgDataRow[] getSvcMsgDataRows(int n, ViewCriteria viewCriteria, boolean[] blArray, int[] nArray) {
        SvcMsgDataRow[] svcMsgDataRowArray = null;
        if (viewCriteria != null) {
            svcMsgDataRowArray = new SvcMsgDataRow[viewCriteria.size()];
            int n2 = 0;
            while (n2 < viewCriteria.size()) {
                ViewCriteriaRow viewCriteriaRow = (ViewCriteriaRow)viewCriteria.elementAt(n2);
                boolean bl = viewCriteriaRow.isUpperColumns();
                svcMsgDataRowArray[n2] = new SvcMsgDataRow(null, 2, n, n2, viewCriteriaRow, null, 127, null);
                blArray[n2] = viewCriteriaRow.isUpperColumns();
                nArray[n2] = viewCriteriaRow.getConjunction();
                ++n2;
            }
        }
        return svcMsgDataRowArray;
    }

    public static RequestParams toSvcMsg(int n, ViewCriteria viewCriteria) {
        SvcMsgRequestParams svcMsgRequestParams = new SvcMsgRequestParams(88, n, null);
        SvcMsgDataRow[] svcMsgDataRowArray = null;
        boolean[] blArray = null;
        int[] nArray = null;
        if (viewCriteria != null) {
            svcMsgRequestParams.setBooleanParams(new boolean[]{viewCriteria.isCriteriaForQuery(), viewCriteria.isUseAttributeFormatHint()});
            blArray = new boolean[viewCriteria.size()];
            nArray = new int[viewCriteria.size()];
            svcMsgDataRowArray = ViewCriteriaMarshaller.getSvcMsgDataRows(n, viewCriteria, blArray, nArray);
        }
        svcMsgRequestParams.setObjectParams(new Object[]{svcMsgDataRowArray, blArray, nArray});
        return svcMsgRequestParams;
    }

    public static ResponseValues toSvcMsgResp(ViewCriteria viewCriteria, String string) {
        SvcMsgResponseValues svcMsgResponseValues = new SvcMsgResponseValues(4197, string);
        SvcMsgDataRow[] svcMsgDataRowArray = null;
        boolean[] blArray = null;
        int[] nArray = null;
        if (viewCriteria != null) {
            svcMsgResponseValues.setBooleanValues(new boolean[]{viewCriteria.isCriteriaForQuery(), viewCriteria.isUseAttributeFormatHint()});
            blArray = new boolean[viewCriteria.size()];
            nArray = new int[viewCriteria.size()];
            svcMsgDataRowArray = ViewCriteriaMarshaller.getSvcMsgDataRows(-1, viewCriteria, blArray, nArray);
        }
        svcMsgResponseValues.setObjectValues(new Object[]{svcMsgDataRowArray, blArray, nArray});
        return svcMsgResponseValues;
    }
}

