/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common;

import java.text.DateFormat;
import java.util.Date;

public class Timer {
    private static long start;
    private static long end;
    private long prevTime = Timer.getCurrentTime();

    public long start() {
        start = System.currentTimeMillis();
        end = 0L;
        return start;
    }

    public String startAsTimeStamp() {
        return this.formatTime(this.start());
    }

    public long end() {
        if (end == 0L) {
            end = System.currentTimeMillis();
        }
        return end - start;
    }

    public String endAsTimeStamp() {
        return this.formatTime(this.end());
    }

    String formatTime(long l) {
        return DateFormat.getDateTimeInstance().format(new Date(l)) + "  " + l % 1000L;
    }

    public static long getCurrentTime() {
        return System.currentTimeMillis() / 1000L;
    }

    public void reset() {
        this.prevTime = Timer.getCurrentTime();
    }

    public long getElapsedTime() {
        return Timer.getCurrentTime() - this.prevTime;
    }
}

