<?xml version='1.0' encoding='windows-1252'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" 
  xmlns:java="http://xml.apache.org/xslt/java" exclude-result-prefixes="java" extension-element-prefixes="barcode" 
  xmlns:cal="xalan://java.util.GregorianCalendar"> 

<xsl:output method="xml" encoding="windows-1252" indent="yes"/>

<xsl:decimal-format decimal-separator="," grouping-separator="."/>

  <!-- Variaveis de ambiente de execucao -->
  <xsl:param name="PATH_IMAGENS" select="'imagens/'"/>
  <xsl:param name="PATH_REMESSA" select="'remessa/'"/>
  
  <xsl:attribute-set name="bordas"> 
	  <xsl:attribute name="border-after-width">1pt</xsl:attribute> 
	  <xsl:attribute name="border-after-style">solid</xsl:attribute> 
	  <xsl:attribute name="border-before-width">1pt</xsl:attribute> 
	  <xsl:attribute name="border-before-style">solid</xsl:attribute> 
	  <xsl:attribute name="border-left-width">1pt</xsl:attribute> 
	  <xsl:attribute name="border-left-style">solid</xsl:attribute> 
  	  <xsl:attribute name="border-right-width">1pt</xsl:attribute> 
  	  <xsl:attribute name="border-right-style">solid</xsl:attribute> 
  </xsl:attribute-set>
    
  <xsl:attribute-set name="cabecalhoLeftCourier">
	<xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">Courier, monospace</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="background-color">white</xsl:attribute>
	<xsl:attribute name="text-align">left</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="cabecalhoRightCourier">
	<xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">Courier, monospace</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="background-color">white</xsl:attribute>
	<xsl:attribute name="text-align">right</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="cabecalhoLeft">
	<xsl:attribute name="font-size">9.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif, monospace</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="background-color">white</xsl:attribute>
	<xsl:attribute name="text-align">left</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="cabecalhoRight">
	<xsl:attribute name="font-size">9.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif, monospace</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="background-color">white</xsl:attribute>
	<xsl:attribute name="text-align">right</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="titFCinza">
    <xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">bold</xsl:attribute>
	<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
	<xsl:attribute name="border-bottom-width">1.0pt</xsl:attribute>
	<xsl:attribute name="background-color">#EEEEEE</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="titFCinzaEscuro">
    <xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">bold</xsl:attribute>
	<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
	<xsl:attribute name="border-bottom-width">1.0pt</xsl:attribute>
	<xsl:attribute name="background-color">silver</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>
  
  <xsl:attribute-set name="titNegrito">
	<xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">bold</xsl:attribute>
	<xsl:attribute name="text-align">center</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="titNegritoLeft">
	<xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">bold</xsl:attribute>
	<xsl:attribute name="text-align">left</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="titNegritoBig">
	<xsl:attribute name="font-size">12.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">bold</xsl:attribute>
	<xsl:attribute name="text-align">center</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="titNegritoMed">
	<xsl:attribute name="font-size">10.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">bold</xsl:attribute>
	<xsl:attribute name="text-align">left</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="titMed">
	<xsl:attribute name="font-size">10.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="text-align">left</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="titNegritoItalico">
    <xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
	<xsl:attribute name="font-weight">bold</xsl:attribute>
	<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
	<xsl:attribute name="border-bottom-width">1.0pt</xsl:attribute>
	<xsl:attribute name="background-color">silver</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="total">
	<xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="text-align">right</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="totalLeft">
    <xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="background-color">white</xsl:attribute>
	<xsl:attribute name="text-align">left</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

 <xsl:attribute-set name="cabecalho">
	<xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="background-color">white</xsl:attribute>
	<xsl:attribute name="text-align">right</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="cabecalhoCenter">
	<xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="background-color">white</xsl:attribute>
	<xsl:attribute name="text-align">center</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="txtJustifyMed">
	<xsl:attribute name="font-size">10.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="text-align">justify</xsl:attribute>
	<xsl:attribute name="hyphenate">true</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>	
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
	<xsl:attribute name="language">pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="txtJustify">
    <xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="text-align">justify</xsl:attribute>
	<xsl:attribute name="hyphenate">true</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
	<xsl:attribute name="language">pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="txtLeft">
    <xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="text-align">left</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>
  
  <xsl:attribute-set name="txtLeftShort">
    <xsl:attribute name="font-size">7.4pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="text-align">left</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>  
  
  <xsl:attribute-set name="txtLeftBig">
    <xsl:attribute name="font-size">12.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="text-align">left</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>
  
  <xsl:attribute-set name="txtLeftBigCur">
    <xsl:attribute name="font-size">12.0pt</xsl:attribute>
	<xsl:attribute name="font-family">Courier, monospace</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="text-align">left</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="txtCenter">
    <xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="text-align">center</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="txtCenterBig">
    <xsl:attribute name="font-size">12.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="text-align">center</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="txtRight">
    <xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="text-align">right</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>
  
  <xsl:attribute-set name="txtRightShort">
    <xsl:attribute name="font-size">7.4pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="text-align">right</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>  

  <xsl:attribute-set name="txtRightBig">
    <xsl:attribute name="font-size">12.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="text-align">right</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="linhaTotal">
	<xsl:attribute name="font-size">8.0pt</xsl:attribute>
	<xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
	<xsl:attribute name="background-color">white</xsl:attribute>
	<xsl:attribute name="text-align">right</xsl:attribute>
	<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
	<xsl:attribute name="border-bottom-width">1.0pt</xsl:attribute>
	<xsl:attribute name="border-top-style">solid</xsl:attribute>
	<xsl:attribute name="border-top-width">1.0pt</xsl:attribute>
	<xsl:attribute name="space-after">1mm</xsl:attribute>
	<xsl:attribute name="padding-top">2pt</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="txtQuadroTce">
    <xsl:attribute name="font-size">7.0pt</xsl:attribute>
    <xsl:attribute name="font-family">serif</xsl:attribute>
    <xsl:attribute name="font-weight">normal</xsl:attribute>
    <xsl:attribute name="space-before">0pt</xsl:attribute>
    <xsl:attribute name="space-after">0pt</xsl:attribute>
    <xsl:attribute name="padding-top">1pt</xsl:attribute>
    <xsl:attribute name="padding-bottom">1pt</xsl:attribute>
  </xsl:attribute-set>

  <!--******* VARIAVEIS GLOBAIS *******-->

    <xsl:variable name="valorRcl" select="/Modelo9/Modelos/Modelo1/Modelo1Row/VALOR"/>
    <xsl:variable name="valorRclEndividamento" select="/Modelo9/Modelos/Modelo1Endividamento/Modelo1EndividamentoRow/VALOR"/>
    <xsl:variable name="valorRclAjustada" select="/Modelo9/Modelos/Modelo1CfArt199/Modelo1CfArt199Row/VALOR"/>
	
  <!--******* VARIAVEIS GLOBAIS *******-->

<xsl:template match="/">
  <fo:root>
    <fo:layout-master-set>
      <!-- Define a body (or default) page. -->
      <fo:simple-page-master master-name="default-master" page-height="29.6cm"  page-width="21cm" margin-top="15pt"  margin-left="20pt" margin-right="20pt" margin-bottom="15pt">

        <!-- Central part of page -->
        <fo:region-body column-count="1" margin-top="1.65in" margin-bottom="0.2in"/>

        <!-- Header -->
        <fo:region-before border-after-style="solid" extent="1.65in" margin-bottom="0.2in"/>

        <!-- Footer -->
        <fo:region-after border-before-style="solid" extent="0.2in" margin-bottom="0.2in"/>
      </fo:simple-page-master>
    </fo:layout-master-set>

    <!-- Body page -->
    <fo:page-sequence master-reference="default-master">

      <!-- Define the contents of the header. -->
      <fo:static-content flow-name="xsl-region-before">
		<xsl:apply-templates select="Modelo9/Header"/>
      </fo:static-content>

      <!-- Define the contents of the footer. -->
      <fo:static-content flow-name="xsl-region-after">

      </fo:static-content>

      <!-- The main contents of the body page, that is, the catalog
           entries -->

      <!-- The main contents of the body page, that is, the catalog entries 
	   ########## CORPO DO TEXTO DOS RELATORIOS #########
	    -->
      <fo:flow flow-name="xsl-region-body">
        <fo:block>

		 <!--******* VARIAVEIS *******-->
		 <xsl:variable name="entidade">
	 	  <xsl:if test="Modelo9/Header/Informacoes/InformacoesRow/TIPO_SETOR_GOV='P'">Poder Executivo</xsl:if>
		  <xsl:if test="Modelo9/Header/Informacoes/InformacoesRow/TIPO_SETOR_GOV='C'">Poder Legislativo</xsl:if>
		 </xsl:variable>

		<xsl:variable name="periodicidade">
		 <xsl:if test="Modelo9/Header/Informacoes/InformacoesRow/TP_ENTREGA='S'">Semestre</xsl:if>
		 <xsl:if test="Modelo9/Header/Informacoes/InformacoesRow/TP_ENTREGA='Q'">Quadrimestre</xsl:if>
		</xsl:variable>

		<xsl:variable name="periodo">
		 <xsl:if test="Modelo9/Header/Informacoes/InformacoesRow/TP_ENTREGA='S'">
		  <xsl:if test="Modelo9/Header/Informacoes/InformacoesRow/PERIODO_INFORMACOES div 3 &lt;= 1">1</xsl:if>
		  <xsl:if test="Modelo9/Header/Informacoes/InformacoesRow/PERIODO_INFORMACOES div 3 &gt; 1">2</xsl:if>
		 </xsl:if>
		 <xsl:if test="Modelo9/Header/Informacoes/InformacoesRow/TP_ENTREGA='Q'">
		  <xsl:if test="Modelo9/Header/Informacoes/InformacoesRow/PERIODO_INFORMACOES div 2 &lt;= 1">1</xsl:if>
		  <xsl:if test="Modelo9/Header/Informacoes/InformacoesRow/PERIODO_INFORMACOES div 2 &gt; 1 and Modelo9/Header/Informacoes/InformacoesRow/PERIODO_INFORMACOES div 2 &lt;= 2">2</xsl:if>
		  <xsl:if test="Modelo9/Header/Informacoes/InformacoesRow/PERIODO_INFORMACOES div 2 &gt; 2">3</xsl:if>
		 </xsl:if>
		</xsl:variable>
		<!--******* VARIAVEIS *******-->

		<!-- CABECALHO INICIAL -->
		 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
		  <fo:table-column column-number="1" column-width="556pt"/>

		  <fo:table-body>  
		   <fo:table-row>
		    <fo:table-cell border-width="0.5pt">
		     <fo:block xsl:use-attribute-sets="titNegritoLeft">Nome da Entidade: <xsl:value-of select="Modelo9/Header/Informacoes/InformacoesRow/NOME"/></fo:block>
		    </fo:table-cell>
		   </fo:table-row>
		   <fo:table-row>
		    <fo:table-cell border-width="0.5pt">
		     <fo:block xsl:use-attribute-sets="titNegritoLeft">CNPJ: <xsl:value-of select="Modelo9/Header/Informacoes/InformacoesRow/CNPJ"/></fo:block>
		    </fo:table-cell>
		   </fo:table-row>
		   <fo:table-row>
		    <fo:table-cell border-width="0.5pt">
		     <fo:block xsl:use-attribute-sets="titNegritoLeft">ORG&#195;O N&#186;: <xsl:value-of select="document(concat($PATH_REMESSA,'\remessa_info.xml'))//codigo-entidade"/></fo:block>
		    </fo:table-cell>
		   </fo:table-row>
		   <fo:table-row>
		    <fo:table-cell border-width="0.5pt">
		     <fo:block xsl:use-attribute-sets="titNegritoLeft">C&#243;d. Barras do RVE Vinculado:
		       <xsl:value-of select="document(concat($PATH_REMESSA,'\remessa_info.xml'))//cod-barras-rve-original"/>
		       <xsl:value-of select="document(concat($PATH_REMESSA,'\remessa_info.xml'))//cod-barras-rve"/>
		     </fo:block>
		    </fo:table-cell>
		   </fo:table-row>
		  </fo:table-body>
		 </fo:table>
		<!-- FIM CABECALHO INICIAL -->

		  <xsl:if test="Modelo9/Header/Indiretas!=''">
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="Modelo9/Header/Indiretas"/>
		  </xsl:if>

		  <xsl:if test="Modelo9/Modelos/Modelo1!=''">
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		   <xsl:apply-templates select="Modelo9/Modelos/Modelo1"/>
		  </xsl:if>

		  <xsl:if test="Modelo9/Modelos/Modelo2!=''">
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>		  
 		   <xsl:apply-templates select="Modelo9/Modelos/Modelo2"/>
		  </xsl:if>

		  <xsl:if test="Modelo9/Modelos/Modelo4!=''">
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>		  
		   <xsl:apply-templates select="Modelo9/Modelos/Modelo4"/>
		  </xsl:if>
		  
		  <fo:block><fo:leader leader-pattern="space" /></fo:block>
		  <xsl:apply-templates select="Modelo9/Modelos/Modelo5"/>

		  
		  <fo:block><fo:leader leader-pattern="space" /></fo:block>
		  <xsl:apply-templates select="Modelo9/Modelos/Modelo6"/>


		  <xsl:if test="((Modelo9/Header/Informacoes/InformacoesRow/TP_ENTREGA='Q' and $periodo=3) or (Modelo9/Header/Informacoes/InformacoesRow/TP_ENTREGA='S' and $periodo=2))">
		   <fo:block><fo:leader leader-pattern="space" /></fo:block>
		    <xsl:apply-templates select="Modelo9/Modelos/Modelo7">
          <xsl:with-param name = "CNPJ"> <xsl:value-of select="Modelo9/Header/Informacoes/InformacoesRow/CNPJ"/></xsl:with-param> 
  		  </xsl:apply-templates>

        <xsl:if test="Modelo9/Header/Indiretas/IndiretasRow[STATUS_CONSOLIDACAO=1]/STATUS_CONSOLIDACAO=1">
          <xsl:for-each select="Modelo9/Header/Indiretas/IndiretasRow">
            <xsl:if test="STATUS_CONSOLIDACAO=1">	
              <fo:block><fo:leader leader-pattern="space"/></fo:block>			  
              <xsl:apply-templates select="../../../Modelos/Modelo7">
                <xsl:with-param name="CNPJ"><xsl:value-of select="CNPJ"/></xsl:with-param> 
              </xsl:apply-templates>
              <fo:block><fo:leader leader-pattern="space" /></fo:block>	
            </xsl:if>
          </xsl:for-each> 
        </xsl:if>
      </xsl:if>
        	
        	
		  <!-- ALERTAS - inicio -->
		  <xsl:if test="((Modelo9/Modelos/Modelo2/Modelo2Row/VALOR) div ($valorRclAjustada) * 100)&gt;48.605
						or ((Modelo9/Modelos/Modelo4/Modelo4Row/VALOR) div ($valorRclEndividamento) * 100)&gt;108.005
						or (
							(
								((Modelo9/Modelos/Modelo5/Pergunta/PerguntaRow/RESPOSTA = 'S')
								or (((Modelo9/Modelos/Modelo4/Modelo4Row/VALOR div $valorRclEndividamento)*100)&gt;120.005)
								or (((Modelo9/Modelos/Modelo2/Modelo2Row/VALOR div $valorRclAjustada)*100)&gt;54.005))
								and (((Modelo9/Modelos/Modelo5/Valor/ValorRow/VALOR div $valorRclEndividamento)*100)&gt;19.805)
							)
							or (((Modelo9/Modelos/Modelo5/Valor/ValorRow/VALOR div $valorRclEndividamento)*100)&gt;28.805)
						)
						or ((Modelo9/Modelos/Modelo6/Internas/InternasRow/VALOR) div ($valorRclEndividamento) * 100)&gt;14.405
						or ((Modelo9/Modelos/Modelo6/Antecipacao/AntecipacaoRow/VALOR) div ($valorRclEndividamento) * 100)&gt;6.305
						">
			  <fo:block><fo:leader leader-pattern="space"/></fo:block>
			  <fo:block><fo:leader leader-pattern="space"/></fo:block>   
			  <fo:block><fo:leader leader-pattern="space"/></fo:block>
			  <fo:block><fo:leader leader-pattern="space"/></fo:block>
			    
			  <xsl:call-template name="Alertas"/>
		
			  <xsl:if test="Modelo9/Modelos/Modelo2!=''">
			   <xsl:call-template name="DespesasPessoal">
				<xsl:with-param name="VALOR"><xsl:value-of select="(Modelo9/Modelos/Modelo2/Modelo2Row/VALOR) div ($valorRclAjustada) * 100"/></xsl:with-param>
			   </xsl:call-template>
			  </xsl:if>

			  <xsl:if test="Modelo9/Modelos/Modelo4!=''">
		       <xsl:call-template name="Endividamento">
				<xsl:with-param name="VALOR"><xsl:value-of select="(Modelo9/Modelos/Modelo4/Modelo4Row/VALOR) div ($valorRclEndividamento) * 100"/></xsl:with-param>
			   </xsl:call-template>
			  </xsl:if>

			  <xsl:if test="Modelo9/Modelos/Modelo5/Valor/ValorRow!='' and Modelo9/Modelos/Modelo5/Pergunta/PerguntaRow!=''">
			   <xsl:if test="((((Modelo9/Modelos/Modelo5/Pergunta/PerguntaRow/RESPOSTA = 'S') or
					(((Modelo9/Modelos/Modelo4/Modelo4Row/VALOR div $valorRclEndividamento)*100)&gt;120.005) or
					(((Modelo9/Modelos/Modelo2/Modelo2Row/VALOR div $valorRclAjustada)*100)&gt;54.005)) and
					(((Modelo9/Modelos/Modelo5/Valor/ValorRow/VALOR div $valorRclEndividamento)*100)&gt;19.805)) or
					(((Modelo9/Modelos/Modelo5/Valor/ValorRow/VALOR div $valorRclEndividamento)*100)&gt;28.805))">
			     <xsl:call-template name="Garantias">
				   <xsl:with-param name="VALOR"><xsl:value-of select="(Modelo9/Modelos/Modelo5/Valor/ValorRow/VALOR) div ($valorRclEndividamento) * 100"/></xsl:with-param>							
			     </xsl:call-template>
			   </xsl:if>
			  </xsl:if>

			  <xsl:if test="Modelo9/Modelos/Modelo6/Internas!=''">
			   <xsl:call-template name="CreditoInterna">
				<xsl:with-param name="VALOR"><xsl:value-of select="(Modelo9/Modelos/Modelo6/Internas/InternasRow/VALOR) div ($valorRclEndividamento) * 100"/></xsl:with-param>
		 	   </xsl:call-template>
			  </xsl:if>
		  
			  <xsl:if test="Modelo9/Modelos/Modelo6/Antecipacao!=''">
		 	   <xsl:call-template name="CreditoAntecipacao">
				<xsl:with-param name="VALOR"><xsl:value-of select="(Modelo9/Modelos/Modelo6/Antecipacao/AntecipacaoRow/VALOR) div ($valorRclEndividamento) * 100"/></xsl:with-param>
			   </xsl:call-template>
			  </xsl:if>

			  <xsl:call-template name="Ciencia"/>
		  </xsl:if>
		  <!-- ALERTAS - final -->
        	
		  <!-- QUEBRA DE PAGINA -->
		  <fo:block break-before="page"/>
		  <!-- QUEBRA DE PAGINA -->
          
	      <xsl:apply-templates select="Modelo9/Header/Informacoes"></xsl:apply-templates>
		  
		  <!-- pagina final -->
		  <fo:block id="last-page"/>
		  <!-- pagina final -->
        </fo:block>
      </fo:flow>
    </fo:page-sequence>
  </fo:root>
</xsl:template>

<xsl:template name="Alertas">
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>  

 <!-- INICIO ALERTA 1 -->
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="45pt"/>
  <fo:table-column column-number="2" column-width="55pt"/>
  <fo:table-column column-number="3" column-width="390pt"/>
  <fo:table-column column-number="4" column-width="36pt"/>
  
  <fo:table-body>
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt" border-width="0.5pt" number-columns-spanned="4">
     <fo:block font-weight="bold" text-align="center" xsl:use-attribute-sets="titNegritoBig">DOS ALERTAS </fo:block>
    </fo:table-cell>
   </fo:table-row>   

   <fo:table-row>
    <fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="txtJustifyMed"><fo:inline font-weight="normal" color="white">__________</fo:inline>Em atendimento ao disposto no &#167; 1&#186; do art. 59 da Lei Complementar n&#186; 101/2000 - LEI DE RESPONSABILIDADE FISCAL (LRF), e considerando que o (s) &#237;ndice (s) demonstrado (s) no Modelo 9 - Demonstrativo dos Limites est&#225; (&#227;o)  acima do limite estabelecido na LRF, ser&#227;o emitidos, automaticamente, conforme o caso, os ALERTAS a seguir indicados:</fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt">
	<fo:block></fo:block>
	</fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>
 <!-- FIM ALERTA 1 -->
</xsl:template>

<!--#############################-->
<!--####       HEADER       ####-->
<!--#############################-->
<xsl:template match="Header">

<!--******* VARIAVEIS *******-->
<xsl:variable name="periodicidade">
 <xsl:if test="Informacoes/InformacoesRow/TP_ENTREGA='S'">
  <xsl:value-of select="'Semestre'"></xsl:value-of>
  </xsl:if>
 <xsl:if test="Informacoes/InformacoesRow/TP_ENTREGA='Q'">
  <xsl:value-of select="'Quadrimestre'"></xsl:value-of>
 </xsl:if>
</xsl:variable>

<xsl:variable name="periodo">
 <xsl:if test="Informacoes/InformacoesRow/TP_ENTREGA='S'">
  <xsl:if test="Informacoes/InformacoesRow/PERIODO_INFORMACOES div 3 &lt;= 1">1</xsl:if>
  <xsl:if test="Informacoes/InformacoesRow/PERIODO_INFORMACOES div 3 &gt; 1">2</xsl:if>
 </xsl:if>
 <xsl:if test="Informacoes/InformacoesRow/TP_ENTREGA='Q'">
  <xsl:if test="Informacoes/InformacoesRow/PERIODO_INFORMACOES div 2 &lt;= 1">1</xsl:if>
  <xsl:if test="Informacoes/InformacoesRow/PERIODO_INFORMACOES div 2 &gt; 1 and Informacoes/InformacoesRow/PERIODO_INFORMACOES div 2 &lt;= 2">2</xsl:if>
  <xsl:if test="Informacoes/InformacoesRow/PERIODO_INFORMACOES div 2 &gt; 2">3</xsl:if>
 </xsl:if>
</xsl:variable>

<xsl:variable name="dataHora" select="document(concat($PATH_REMESSA,'\remessa_info.xml'))//data-geracao"/>
<xsl:variable name="data" select="substring($dataHora, 1, 10)"/>
<xsl:variable name="horario" select="substring($dataHora, 12, 8)"/>
<xsl:variable name="dia" select="substring($data, 9, 2)"/>
<xsl:variable name="mes" select="substring($data, 6, 2)"/>
<xsl:variable name="ano" select="substring($data, 1, 4)"/>
<xsl:variable name="hora" select="substring($horario, 1, 2)"/>
<xsl:variable name="minuto" select="substring($horario, 4, 2)"/>
<xsl:variable name="segundo" select="substring($horario, 7, 2)"/>
<!--******* VARIAVEIS *******-->

 <fo:block>
  <fo:table table-layout="fixed" width="556pt">
   <fo:table-column column-width="40pt"/>
   <fo:table-column column-width="325pt"/>
   <fo:table-column column-width="100pt"/>
   <fo:table-column column-width="10pt"/>
   <fo:table-column column-width="70pt"/>

   <fo:table-body>
    <fo:table-row>
	 <fo:table-cell padding-bottom="3pt">
	    <fo:block>
		<fo:external-graphic src="{concat($PATH_IMAGENS,'Brasao.jpg')}"/>
	    </fo:block>
	 </fo:table-cell>
	 <fo:table-cell>
	  <fo:block padding-bottom="5pt">
	      <!-- INICIO CABE&#199;ALHO  -->
		 <fo:table width="325pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
		  <fo:table-column column-number="1" column-width="5pt"/>
		  <fo:table-column column-number="2" column-width="315pt"/>
		  <fo:table-column column-number="3" column-width="5pt"/>

		  <fo:table-body>
		   <fo:table-row>
		    <fo:table-cell border-width="0.5pt" number-columns-spanned="3" padding-left="5pt">
		     <fo:block xsl:use-attribute-sets="txtLeft">ESTADO DO RIO GRANDE DO SUL</fo:block>
		     <fo:block xsl:use-attribute-sets="txtLeft">TRIBUNAL DE CONTAS DO ESTADO</fo:block>
		    </fo:table-cell>
		   </fo:table-row>
		   <fo:table-row>
		    <fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>	 
		    <fo:table-cell border-width="0.5pt">
		     <fo:block xsl:use-attribute-sets="titNegritoBig">Modelo 9 - DEMONSTRATIVO DOS LIMITES - RGF</fo:block>
		    </fo:table-cell>
			<fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>	 
		   </fo:table-row>
		   <fo:table-row>
		    <fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>	 
		    <fo:table-cell border-width="0.5pt">
		     <fo:block xsl:use-attribute-sets="titNegrito">EXECUTIVO/INDIRETAS MUNICIPAIS</fo:block>
		    </fo:table-cell>
			<fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>	 
		   </fo:table-row>
		   <fo:table-row>
		    <fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>	 
		    <fo:table-cell border-width="0.5pt">
		     <fo:block xsl:use-attribute-sets="titNegrito">EXERC&#205;CIO DE <xsl:value-of select="Informacoes/InformacoesRow/EXERCICIO"/> <xsl:if test="Indiretas!=''"> - CONSOLIDA&#199;&#195;O</xsl:if></fo:block>
		    </fo:table-cell>
			<fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>	 
		   </fo:table-row>
		   <fo:table-row>
		    <fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>	 
		    <fo:table-cell border-width="0.5pt">
		     <fo:block xsl:use-attribute-sets="titNegrito"><xsl:value-of select="Informacoes/InformacoesRow/NOME"/></fo:block>
		    </fo:table-cell>
			<fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>	 
		   </fo:table-row>
		   <fo:table-row>
		    <fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>	 
		    <fo:table-cell border-width="0.5pt">
		     <fo:block xsl:use-attribute-sets="titNegrito"><xsl:value-of select="$periodo"/>&#186; <xsl:value-of select="$periodicidade"/></fo:block>
		    </fo:table-cell>
			<fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>	 
		   </fo:table-row>
		  </fo:table-body>
		 </fo:table>
	    <!-- FIM CABE&#199;ALHO  -->  
    </fo:block>
	</fo:table-cell>
	<fo:table-cell padding-bottom="3pt" text-align="center">
	  <!-- BARCODE -->
	      <fo:block><fo:leader leader-pattern="space" /></fo:block>
	      <fo:block><fo:leader leader-pattern="space" /></fo:block>
	      <fo:block>
          <fo:instream-foreign-object>
            <barcode:barcode 
            xmlns:barcode="http://barcode4j.krysalis.org/ns"
            message="{document(concat($PATH_REMESSA,'\remessa_info.xml'))//cod-barras-modelo9}">
              <barcode:code128>
                <barcode:height>15mm</barcode:height>
              </barcode:code128>
            </barcode:barcode>
          </fo:instream-foreign-object>
	      </fo:block>
	 <!-- BARCODE -->
  </fo:table-cell>
	<fo:table-cell padding-bottom="3pt">
  </fo:table-cell>    
  <fo:table-cell >
    <fo:block>
		  <!-- <fo:table text-align="center" table-layout="fixed">
		    <fo:table-column column-width="35pt"/>
		    <fo:table-column column-width="35pt"/>
		    <fo:table-body>
		      <fo:table-row>
		        <fo:table-cell number-columns-spanned="2" border-style="solid" border-width="0.25pt" space-before="0pt" space-after="0pt">
		          <fo:block xsl:use-attribute-sets="txtQuadroTce" text-align="center">Para uso do</fo:block>
		          <fo:block xsl:use-attribute-sets="txtQuadroTce" text-align="center">Tribunal de Contas</fo:block>
		        </fo:table-cell>
		      </fo:table-row>
		      <fo:table-row>
		        <fo:table-cell border-style="solid" height="20pt" border-width="0.25pt" space-before="0pt" space-after="0pt">
		          <fo:block xsl:use-attribute-sets="txtQuadroTce" text-align="left">Fl.</fo:block>
		          <fo:block xsl:use-attribute-sets="txtQuadroTce"></fo:block>
		        </fo:table-cell>
		        <fo:table-cell border-style="solid" height="20pt" border-width="0.25pt" space-before="0pt" space-after="0pt">
		          <fo:block xsl:use-attribute-sets="txtQuadroTce" text-align="left">Rubrica</fo:block>
		          <fo:block xsl:use-attribute-sets="txtQuadroTce"></fo:block>
		        </fo:table-cell>
		      </fo:table-row>
		    </fo:table-body>
		  </fo:table> -->
		</fo:block>
	  <fo:block xsl:use-attribute-sets="txtRight">
      <fo:external-graphic src="{concat($PATH_IMAGENS,'tce_2025.jpg')}" width="42pt"/>
	  </fo:block>
	  <fo:block xsl:use-attribute-sets="txtRight" font-weight="bold">
      <xsl:value-of select="Informacoes/InformacoesRow/VERSAO_PAD"/>
	  <xsl:value-of select="java:br.gov.rs.tce.pad.util.VersaoUtils.getVersaoTestId()"/>
    </fo:block> 	  
	  <fo:block xsl:use-attribute-sets="txtRight">
      <xsl:value-of select="$dia"/>/<xsl:value-of select="$mes"/>/<xsl:value-of select="$ano"/>
	  </fo:block>		 
	  <fo:block xsl:use-attribute-sets="txtRight">
      <xsl:value-of select="$hora"/>:<xsl:value-of select="$minuto"/>:<xsl:value-of select="$segundo"/>
	  </fo:block>
	  <fo:block xsl:use-attribute-sets="txtRight">
	    P&#225;g.: <fo:page-number/>/<fo:page-number-citation ref-id="last-page"/>
    </fo:block>
    </fo:table-cell>
    </fo:table-row>
   </fo:table-body>
  </fo:table>
 </fo:block>
</xsl:template>

<!--#############################-->
<!--####      INDIRETAS      ####-->
<!--#############################-->
<xsl:template match="Indiretas">
  <fo:block xsl:use-attribute-sets="titFCinza">ENTIDADES DA ADMINISTRA&#199;&#195;O INDIRETA QUE COMP&#213;EM AS INFORMA&#199;&#213;ES DO MODELO 9:</fo:block>

	<fo:table table-layout="fixed" width="556pt">
		<fo:table-column column-width="80pt"/>
		<fo:table-column column-width="240pt"/>
		<fo:table-column column-width="60pt"/>
		<fo:table-column column-width="60pt"/>
		<fo:table-column column-width="80pt"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell padding-left="10pt"> 
						<fo:block xsl:use-attribute-sets="titNegrito" text-align="left">CNPJ</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="titNegrito" text-align="left">Nome da Entidade</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="titNegrito" text-align="left">Tipo</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="titNegrito" text-align="left">&#201; RPPS ? </fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="titNegrito" text-align="left">C&#243;d. Barras do RVE</fo:block>
					</fo:table-cell>
				</fo:table-row>
				<xsl:for-each select="IndiretasRow">
				<fo:table-row>
					<fo:table-cell padding-left="10pt">
						<fo:block xsl:use-attribute-sets="txtLeft" ><xsl:value-of select="CNPJ"/></fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="NOME_ENTIDADE"/></fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="txtLeft">
							<xsl:if test="TIPO_SETOR_GOV='P'">
								<fo:block xsl:use-attribute-sets="txtLeft">Prefeitura </fo:block>
							</xsl:if>
							<xsl:if test="TIPO_SETOR_GOV='C'">
								<fo:block xsl:use-attribute-sets="txtLeft">C&#226;mara </fo:block>
							</xsl:if>
							<xsl:if test="TIPO_SETOR_GOV='A'">
								<fo:block xsl:use-attribute-sets="txtLeft">Autarquia </fo:block>
							</xsl:if>
							<xsl:if test="TIPO_SETOR_GOV='F' or TIPO_SETOR_GOV='T'">
								<fo:block xsl:use-attribute-sets="txtLeft">Funda&#231;&#227;o </fo:block>
							</xsl:if>
							<xsl:if test="TIPO_SETOR_GOV='E'">
								<fo:block xsl:use-attribute-sets="txtLeft">Empresa </fo:block>
							</xsl:if>
							<xsl:if test="TIPO_SETOR_GOV='M'">
								<fo:block xsl:use-attribute-sets="txtLeft">Empresa </fo:block>
							</xsl:if>
							<xsl:if test="TIPO_SETOR_GOV='O' or TIPO_SETOR_GOV='S'">
								<fo:block xsl:use-attribute-sets="txtLeft">Cons&#243;rcio </fo:block>
							</xsl:if>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="RPPS"/></fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="txtLeft"><xsl:value-of select="COD_RVE"/></fo:block>
					</fo:table-cell>
				</fo:table-row>
				</xsl:for-each>
			</fo:table-body>
		</fo:table>	
</xsl:template>

<!--#############################-->
<!--####       MODELO 1      ####-->
<!--#############################-->
<xsl:template match="Modelo1">

<fo:table table-layout="fixed" width="556pt">
	<fo:table-column column-width="440pt"/>
	<fo:table-column column-width="116pt"/>

	<fo:table-body>
	 <fo:table-row>
		<fo:table-cell number-columns-spanned="2">
			<fo:block xsl:use-attribute-sets="titFCinza">MODELO 1 - DEMONSTRATIVO DA RECEITA CORRENTE L&#205;QUIDA</fo:block>
		</fo:table-cell>
	 </fo:table-row>
	 <fo:table-row>
		<fo:table-cell padding-left="10pt">
			<fo:block xsl:use-attribute-sets="txtLeft">Lei Complementar Federal n&#186; 101/2000 - LRF,  Inciso I do art. 53</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtCenter" >Valores expressos em reais</fo:block>
		</fo:table-cell>
	 </fo:table-row>
	 <fo:table-row>
		<fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
			<fo:block xsl:use-attribute-sets="titNegrito" text-align="left">RECEITA CORRENTE L&#205;QUIDA - RCL</fo:block>
		</fo:table-cell>
		<fo:table-cell xsl:use-attribute-sets="bordas">
			<fo:block xsl:use-attribute-sets="titNegrito" text-align="right">Valor Ajustado</fo:block>
		</fo:table-cell>
	 </fo:table-row>
	<fo:table-row>
		<fo:table-cell padding-left="10pt" xsl:use-attribute-sets="bordas">
			<fo:block xsl:use-attribute-sets="txtLeft" >Arrecadadas no m&#234;s de refer&#234;ncia e nos onze anteriores (12 meses)</fo:block>
		</fo:table-cell>
		<fo:table-cell xsl:use-attribute-sets="bordas">
			<fo:block xsl:use-attribute-sets="txtRight"> <xsl:value-of select="format-number($valorRcl,'###.###.###.##0,00')"/></fo:block>
		</fo:table-cell>
	</fo:table-row>
	<fo:table-row>
		<fo:table-cell padding-left="10pt" xsl:use-attribute-sets="bordas">
			<fo:block xsl:use-attribute-sets="txtLeft" >Arrecadadas no m&#234;s de refer&#234;ncia e nos onze anteriores (12 meses) - Endividamento</fo:block>
		</fo:table-cell>
		<fo:table-cell xsl:use-attribute-sets="bordas">
			<fo:block xsl:use-attribute-sets="txtRight"> <xsl:value-of select="format-number($valorRclEndividamento,'###.###.###.##0,00')"/></fo:block>
		</fo:table-cell>
	</fo:table-row>
	<fo:table-row>
		<fo:table-cell padding-left="10pt" xsl:use-attribute-sets="bordas">
			<fo:block xsl:use-attribute-sets="txtLeft" >Arrecadadas no m&#234;s de refer&#234;ncia e nos onze anteriores (12 meses) - Despesa com Pessoal<!--AJUSTADA EC 86/2015--></fo:block>
		</fo:table-cell>
		<fo:table-cell xsl:use-attribute-sets="bordas">
			<fo:block xsl:use-attribute-sets="txtRight"> <xsl:value-of select="format-number($valorRclAjustada,'###.###.###.##0,00')"/></fo:block>
		</fo:table-cell>
	</fo:table-row>
	</fo:table-body>
</fo:table>		
</xsl:template>

<!--#############################-->
<!--####       MODELO 2      ####-->
<!--#############################-->
<xsl:template match="Modelo2">
	<fo:table table-layout="fixed" width="556pt">
		<fo:table-column column-width="400pt"/>
		<fo:table-column column-width="90pt"/>
		<fo:table-column column-width="66pt"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell number-columns-spanned="3">
						<fo:block xsl:use-attribute-sets="titFCinza">MODELO 2 - DEMONSTRATIVO DA DESPESA COM PESSOAL</fo:block>
					</fo:table-cell>
				</fo:table-row>
				<fo:table-row>
					<fo:table-cell padding-left="10pt">
						<fo:block xsl:use-attribute-sets="txtLeft">Lei Complementar Federal n&#186; 101/2000 - LRF, art. 54 e al&#237;nea &#180;&#180;a&#180;&#180; do Inciso I do art. 55</fo:block>
					</fo:table-cell>
					<fo:table-cell number-columns-spanned="2">
						<fo:block xsl:use-attribute-sets="txtCenter" >Valores expressos em reais</fo:block>
					</fo:table-cell>
				</fo:table-row>
				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
						<fo:block xsl:use-attribute-sets="titNegrito" >DESPESA COM PESSOAL</fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
						<fo:block xsl:use-attribute-sets="titNegrito" text-align="left">VALOR AJUSTADO</fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="bordas">
						<fo:block xsl:use-attribute-sets="titNegrito" text-align="right">% s/RCL</fo:block>
					</fo:table-cell>
				</fo:table-row>
				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
						<fo:block xsl:use-attribute-sets="titNegrito" text-align="left">Total da Despesa L&#237;quida c/ Pessoal nos 12 &#250;ltimos meses</fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="bordas">
						<fo:block xsl:use-attribute-sets="titNegrito" text-align="right"> <xsl:value-of select="format-number((Modelo2Row/VALOR),'###.###.###.##0,00')"/></fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="bordas">
						<fo:block xsl:use-attribute-sets="titNegrito" text-align="right">
							<xsl:choose>
							<xsl:when test="$valorRclAjustada=0.00 or $valorRclAjustada='0,00' or $valorRclAjustada=''">
								<xsl:value-of select="format-number(0.00, '###.###.##0,00')"/> %
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="format-number((Modelo2Row/VALOR) div ($valorRclAjustada) * 100,'###.##0,00')"/>%
							</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>

				<xsl:variable name="cont">0</xsl:variable>
					<fo:table-row>
						<fo:table-cell padding-left="20pt" number-columns-spanned="2" xsl:use-attribute-sets="bordas">						
									<fo:block xsl:use-attribute-sets="txtLeft" font-weight="bold">Limite para Emiss&#227;o de Alerta - LRF, Inciso II do &#167; 1&#186; do art. 59</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="bordas">
							<fo:block xsl:use-attribute-sets="txtRight">48,60 %</fo:block>
						</fo:table-cell>
					</fo:table-row>
					<fo:table-row>
						<fo:table-cell padding-left="20pt" number-columns-spanned="2" xsl:use-attribute-sets="bordas">						
									<fo:block xsl:use-attribute-sets="txtLeft" font-weight="bold">Limite Prudencial - LRF, Par&#225;grafo &#218;nico do art. 22 </fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="bordas">
							<fo:block xsl:use-attribute-sets="txtRight">51,30 %</fo:block>
						</fo:table-cell>
					</fo:table-row>
					<fo:table-row>
						<fo:table-cell padding-left="20pt" number-columns-spanned="2" xsl:use-attribute-sets="bordas">						
									<fo:block xsl:use-attribute-sets="txtLeft" font-weight="bold">Limite Legal - LRF, al&#237;nea &#180;&#180;b&#180;&#180; do Inciso III do art. 20</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="bordas">
							<fo:block xsl:use-attribute-sets="txtRight">54,00 %</fo:block>
						</fo:table-cell>
					</fo:table-row>
				<xsl:if test="(Modelo2Row/VALOR) div ($valorRclAjustada) * 100 &gt; 54.005">
				<fo:table-row>
					<fo:table-cell padding-left="10pt" number-columns-spanned="3" xsl:use-attribute-sets="bordas">
						<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt">
							Nos termos do inciso II do art. 55 da LRF, ultrapassado o limite legal &#233; compuls&#243;ria a indica&#231;&#227;o das provid&#234;ncias, adotadas ou a adotar, para elimina&#231;&#227;o do percentual excedente.<!-- no prazo determinado no art. 23 da LRF.-->
						</fo:block>
						<!--<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt">
							Nos termos do &#167; 3&#186;, artigo 15 da Lei Complementar 178/2020, est&#227;o suspensas as contagens de prazo e as disposi&#231;&#245;es do art. 23 da LRF no exerc&#237;cio
							<xsl:value-of select="/Modelo9/Header/Informacoes/InformacoesRow/EXERCICIO"/>.
						</fo:block>-->
					</fo:table-cell>
				</fo:table-row>
				<xsl:for-each select="../../MedidasCorretivas/MedidasCorretivasRow[CD_PLANILHA=2]">
				<fo:table-row>
					<fo:table-cell padding-left="10pt" number-columns-spanned="3" xsl:use-attribute-sets="bordas">
						<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true"><xsl:value-of select="TEXTO"/></fo:block>
					</fo:table-cell>
				</fo:table-row>
				</xsl:for-each>

				</xsl:if>
			</fo:table-body>
		</fo:table>			
</xsl:template>

<!--#############################-->
<!--####       MODELO 4      ####-->
<!--#############################-->
<xsl:template match="Modelo4">
	<fo:table table-layout="fixed" width="556pt">
		<fo:table-column column-width="400pt"/>
		<fo:table-column column-width="90pt"/>
		<fo:table-column column-width="66pt"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell number-columns-spanned="3">
						<fo:block xsl:use-attribute-sets="titFCinza">MODELO 4 - DEMONSTRATIVO DA D&#205;VIDA CONSOLIDADA L&#205;QUIDA</fo:block>
					</fo:table-cell>
				</fo:table-row>
				<fo:table-row>
					<fo:table-cell padding-left="10pt">
						<fo:block xsl:use-attribute-sets="txtLeft">Lei Complementar Federal n&#186; 101/2000 - LRF, art. 54 e al&#237;nea &#180;&#180;b&#180;&#180; do Inciso I do art. 55</fo:block>
					</fo:table-cell>
					<fo:table-cell number-columns-spanned="2">
						<fo:block xsl:use-attribute-sets="txtCenter" >Valores expressos em reais</fo:block>
					</fo:table-cell>
				</fo:table-row>
				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
						<fo:block xsl:use-attribute-sets="titNegrito" >D&#205;VIDA</fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
						<fo:block xsl:use-attribute-sets="titNegrito" text-align="left">VALOR AJUSTADO</fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="bordas">
						<fo:block xsl:use-attribute-sets="titNegrito" text-align="right">% s/RCL</fo:block>
					</fo:table-cell>
				</fo:table-row>
				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
						<fo:block xsl:use-attribute-sets="titNegrito" text-align="left">D&#237;vida Consolidada L&#237;quida</fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="bordas">
						<fo:block xsl:use-attribute-sets="titNegrito" text-align="right"> <xsl:value-of select="format-number((Modelo4Row/VALOR),'###.###.###.##0,00')"/></fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="bordas">
						<fo:block xsl:use-attribute-sets="titNegrito" text-align="right">
							<xsl:choose>
								<xsl:when test="$valorRclEndividamento=0.00 or $valorRclEndividamento='0,00' or $valorRclEndividamento=''">
									<xsl:value-of select="format-number(0.00, '###.###.##0,00')"/> %
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select=" format-number((Modelo4Row/VALOR) div ($valorRclEndividamento) * 100,'###.##0,00')"/>%
								</xsl:otherwise>
							</xsl:choose>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>

				<xsl:variable name="cont">0</xsl:variable>
					<fo:table-row>
						<fo:table-cell padding-left="20pt" number-columns-spanned="2" xsl:use-attribute-sets="bordas">						
									<fo:block xsl:use-attribute-sets="txtLeft" font-weight="bold">Limite Para Emiss&#227;o de Alerta - LRF, Inciso III do &#167; 1&#186; do art. 59</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="bordas">
							<fo:block xsl:use-attribute-sets="txtRight">108,00 %</fo:block>
						</fo:table-cell>
					</fo:table-row>
					<fo:table-row>
						<fo:table-cell padding-left="20pt" number-columns-spanned="2" xsl:use-attribute-sets="bordas">						
									<fo:block xsl:use-attribute-sets="txtLeft" font-weight="bold">Limite Legal - Resolu&#231;&#227;o do  Senado Federal n&#186; 40/2001, Inciso II do art. 3&#186;</fo:block>
						</fo:table-cell>
						<fo:table-cell xsl:use-attribute-sets="bordas">
							<fo:block xsl:use-attribute-sets="txtRight">120,00 %</fo:block>
						</fo:table-cell>
					</fo:table-row>
				<xsl:if test="(Modelo4Row/VALOR) div ($valorRclEndividamento) * 100 &gt; 120.005">
				<fo:table-row>
					<fo:table-cell padding-left="10pt" number-columns-spanned="3" xsl:use-attribute-sets="bordas">
						<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt">Nos termos do inciso II do art. 55 da LRF, ultrapassado o limite legal &#233; compuls&#243;ria a indica&#231;&#227;o das provid&#234;ncias, adotadas ou a adotar, para elimina&#231;&#227;o do percentual excedente.<!-- no prazo determinado no art. 31 da LRF.--></fo:block>
					</fo:table-cell>
				</fo:table-row>
				<xsl:for-each select="../../MedidasCorretivas/MedidasCorretivasRow[CD_PLANILHA=4]">
				<fo:table-row>
					<fo:table-cell padding-left="10pt" number-columns-spanned="3" xsl:use-attribute-sets="bordas">
						<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true"><xsl:value-of select="TEXTO"/></fo:block>
					</fo:table-cell>
				</fo:table-row>
				</xsl:for-each>

				</xsl:if>
			</fo:table-body>
		</fo:table>			
</xsl:template>

<!--#############################-->
<!--####       MODELO 5      ####-->
<!--#############################-->
<xsl:template match="Modelo5">
<fo:table table-layout="fixed" width="556pt">
	<fo:table-column column-width="400pt"/>
	<fo:table-column column-width="90pt"/>
	<fo:table-column column-width="66pt"/>
<fo:table-body>
	<fo:table-row>
		<fo:table-cell number-columns-spanned="3">
			<fo:block xsl:use-attribute-sets="titFCinza">MODELO 5 - DEMONSTRATIVO DAS GARANTIAS E CONTRAGARANTIAS DE VALORES</fo:block>
		</fo:table-cell>
	</fo:table-row>
	<fo:table-row>
		<fo:table-cell padding-left="10pt">
			<fo:block xsl:use-attribute-sets="txtLeft">Lei Complementar Federal n&#186; 101/2000 - LRF, art. 54 e al&#237;nea &#180;&#180;c&#180;&#180; do Inciso I do art. 55</fo:block>
		</fo:table-cell>
		<fo:table-cell number-columns-spanned="2">
			<fo:block xsl:use-attribute-sets="txtCenter" >Valores expressos em reais</fo:block>
		</fo:table-cell>
	</fo:table-row>
	<fo:table-row>
		<fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
			<fo:block xsl:use-attribute-sets="titNegrito" >GARANTIAS DE VALORES</fo:block>
		</fo:table-cell>
		<fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
			<fo:block xsl:use-attribute-sets="titNegrito" text-align="left">VALOR AJUSTADO</fo:block>
		</fo:table-cell>
		<fo:table-cell xsl:use-attribute-sets="bordas">
			<fo:block xsl:use-attribute-sets="titNegrito" text-align="right">% s/RCL</fo:block>
		</fo:table-cell>
	</fo:table-row>
	<xsl:if test="Valor/ValorRow/VALOR='' or ValorRow='' or Valor=''">
		<fo:table-row>
			<fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
				<fo:block xsl:use-attribute-sets="titNegrito" text-align="left">Total das Garantias</fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
				<fo:block xsl:use-attribute-sets="titNegrito" text-align="right"> <xsl:value-of select="format-number((0.00),'###.###.###.##0,00')"/></fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas">
				<fo:block xsl:use-attribute-sets="titNegrito" text-align="right">
					<xsl:choose>
					<xsl:when test="$valorRclEndividamento=0.00 or $valorRclEndividamento='0,00' or $valorRclEndividamento=''">
						<xsl:value-of select="format-number(0.00, '###.###.##0,00')"/> %
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select=" format-number((0.00) div ($valorRclEndividamento) * 100,'###.##0,00')"/>%
					</xsl:otherwise>
					</xsl:choose>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:if>
	<xsl:if test="Valor/ValorRow/VALOR!='' or ValorRow!='' or Valor!=''">
		<fo:table-row>
			<fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
				<fo:block xsl:use-attribute-sets="titNegrito" text-align="left">Total das Garantias</fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
				<fo:block xsl:use-attribute-sets="titNegrito" text-align="right">
					<xsl:value-of select="format-number((Valor/ValorRow/VALOR),'###.###.###.##0,00')"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas">
				<fo:block xsl:use-attribute-sets="titNegrito" text-align="right">
					<xsl:value-of select="format-number((Valor/ValorRow/VALOR) div ($valorRclEndividamento) * 100,'###.##0,00')"/>%
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
	</xsl:if>

	<xsl:choose>
 	 <xsl:when test="Pergunta/PerguntaRow[RESPOSTA = 'S']/RESPOSTA = 'S'
				 or (../Modelo4/Modelo4Row/VALOR) div ($valorRclEndividamento) * 100 &gt; 120.005	
				 or (../Modelo2/Modelo2Row/VALOR) div ($valorRclEndividamento) * 100 &gt; 54.005">
		<fo:table-row>
			<fo:table-cell padding-left="20pt" number-columns-spanned="2" xsl:use-attribute-sets="bordas">						
				<fo:block xsl:use-attribute-sets="txtLeft" font-weight="bold">Limite para Emiss&#227;o de Alerta s/Limite Legal - LRF, Inciso III do &#167; 1&#186; do art. 59</fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas">
				<fo:block xsl:use-attribute-sets="txtRight">19,80 %</fo:block>
			</fo:table-cell>
		</fo:table-row>
		<fo:table-row>
			<fo:table-cell padding-left="20pt" number-columns-spanned="2" xsl:use-attribute-sets="bordas">						
						<fo:block xsl:use-attribute-sets="txtLeft" font-weight="bold">Limite Legal -  Resolu&#231;&#227;o do Senado Federal n&#186; 43/2001, art, 9&#186;, caput do art. 9&#186;</fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas">
				<fo:block xsl:use-attribute-sets="txtRight">22,00 %</fo:block>
			</fo:table-cell>
		</fo:table-row>
		<xsl:if test="(Valor/ValorRow/VALOR) div ($valorRclEndividamento) * 100 &gt; 22.005">
			<fo:table-row>
				<fo:table-cell padding-left="10pt" number-columns-spanned="3" xsl:use-attribute-sets="bordas">
					<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt">Nos termos do inciso II do art. 55 da LRF, ultrapassado o limite legal &#233; compuls&#243;ria a indica&#231;&#227;o das provid&#234;ncias, adotadas ou a adotar, para elimina&#231;&#227;o do percentual excedente.</fo:block>
				</fo:table-cell>
			</fo:table-row>
			<xsl:for-each select="../../MedidasCorretivas/MedidasCorretivasRow[CD_PLANILHA=5]">
				<fo:table-row>
					<fo:table-cell padding-left="10pt" number-columns-spanned="3" xsl:use-attribute-sets="bordas">
						<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true"><xsl:value-of select="TEXTO"/></fo:block>
					</fo:table-cell>
				</fo:table-row>
			</xsl:for-each>
		</xsl:if>
	</xsl:when>
	<xsl:otherwise>
	<!--<xsl:if test="Modelo5Row/RESPOSTA = 'N'
			 	  and (../Modelo4/Modelo4Row/VALOR) div (../Modelo1/Modelo1Row/VALOR) * 100 &lt; 120.005	
				  and (../Modelo2/Modelo2Row/VALOR) div (../Modelo1/Modelo1Row/VALOR) * 100 &lt; 54.005">-->
		<fo:table-row>
			<fo:table-cell padding-left="20pt" number-columns-spanned="2" xsl:use-attribute-sets="bordas">						
						<fo:block xsl:use-attribute-sets="txtLeft" font-weight="bold">Limite p/Emiss&#227;o de Alerta s/Limite Legal Ampliado - LRF, Inciso III do &#167; 1&#186; do art. 59</fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas">
				<fo:block xsl:use-attribute-sets="txtRight">28,80 %</fo:block>
			</fo:table-cell>
		</fo:table-row>
		<fo:table-row>
			<fo:table-cell padding-left="20pt" number-columns-spanned="2" xsl:use-attribute-sets="bordas">						
						<fo:block xsl:use-attribute-sets="txtLeft" font-weight="bold">Limite Legal Ampliado - Resolu&#231;&#227;o  Senado Federal n&#186; 43/2001, Par&#225;grafo &#218;nico do art. 9&#186;</fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas">
				<fo:block xsl:use-attribute-sets="txtRight">32,00 %</fo:block>
			</fo:table-cell>
		</fo:table-row>
		<xsl:if test="(Valor/ValorRow/VALOR) div ($valorRclEndividamento) * 100 &gt; 32.005">
			<fo:table-row>
				<fo:table-cell padding-left="10pt" number-columns-spanned="3" xsl:use-attribute-sets="bordas">
					<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt">Nos termos do inciso II do art. 55 da LRF, ultrapassado o limite legal &#233; compuls&#243;ria a indica&#231;&#227;o das provid&#234;ncias, adotadas ou a adotar, para elimina&#231;&#227;o do percentual excedente.</fo:block>
				</fo:table-cell>
			</fo:table-row>
			<xsl:for-each select="../../MedidasCorretivas/MedidasCorretivasRow[CD_PLANILHA=5]">
				<fo:table-row>
					<fo:table-cell padding-left="10pt" number-columns-spanned="3" xsl:use-attribute-sets="bordas">
						<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true"><xsl:value-of select="TEXTO"/></fo:block>
					</fo:table-cell>
				</fo:table-row>
			</xsl:for-each>
		</xsl:if>
	  </xsl:otherwise>
	</xsl:choose>
</fo:table-body>
</fo:table>			
</xsl:template>

<!--#############################-->
<!--####      MODELO 6       ####-->
<!--#############################-->
<xsl:template match="Modelo6">
<fo:table table-layout="fixed" width="556pt">
	<fo:table-column column-width="400pt"/>
	<fo:table-column column-width="90pt"/>
	<fo:table-column column-width="66pt"/>
<fo:table-body>
	<fo:table-row>
		<fo:table-cell number-columns-spanned="3">
			<fo:block xsl:use-attribute-sets="titFCinza">MODELO 6 - DEMONSTRATIVO DAS OPERA&#199;&#213;ES DE CR&#201;DITO</fo:block>
		</fo:table-cell>
	</fo:table-row>
	<fo:table-row>
		<fo:table-cell padding-left="10pt">
			<fo:block xsl:use-attribute-sets="txtLeft">Lei Complementar Federal n&#186; 101/2000 - LRF, art. 54 e al&#237;nea &#180;&#180;d&#180;&#180; do Inciso I do art. 55</fo:block>
		</fo:table-cell>
		<fo:table-cell number-columns-spanned="2">
			<fo:block xsl:use-attribute-sets="txtCenter" >Valores expressos em reais</fo:block>
		</fo:table-cell>
	</fo:table-row>
	<fo:table-row>
		<fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
			<fo:block xsl:use-attribute-sets="titNegrito" >OPERA&#199;&#213;ES DE CR&#201;DITO</fo:block>
		</fo:table-cell>
		<fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
			<fo:block xsl:use-attribute-sets="titNegrito" text-align="left">VALOR AJUSTADO</fo:block>
		</fo:table-cell>
		<fo:table-cell xsl:use-attribute-sets="bordas">
			<fo:block xsl:use-attribute-sets="titNegrito" text-align="right">% s/RCL</fo:block>
		</fo:table-cell>
	</fo:table-row>

	<xsl:if test="Internas">
		<xsl:if test="Internas='' or Internas/InternasRow='' or Internas/InternasRow/VALOR=''">
		<fo:table-row>
			<fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
				<fo:block xsl:use-attribute-sets="titNegrito" text-align="left">Opera&#231;&#245;es de Cr&#233;dito Internas e Externas</fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
				<fo:block xsl:use-attribute-sets="titNegrito" text-align="right"> <xsl:value-of select="format-number((0.00),'###.###.###.##0,00')"/></fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas">
				<fo:block xsl:use-attribute-sets="titNegrito" text-align="right">
					<xsl:choose>
					<xsl:when test="$valorRclEndividamento=0.00 or $valorRclEndividamento='0,00' or $valorRclEndividamento=''">
						<xsl:value-of select="format-number(0.00, '###.###.##0,00')"/> %
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="format-number((0.00) div ($valorRclEndividamento) * 100,'###.##0,00')"/>%
					</xsl:otherwise>
					</xsl:choose>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
		</xsl:if>
		<xsl:if test="Internas!='' or Internas/InternasRow!='' or Internas/InternasRow/VALOR!=''">
		<fo:table-row>
			<fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
				<fo:block xsl:use-attribute-sets="titNegrito" text-align="left">Opera&#231;&#245;es de Cr&#233;dito Internas e Externas</fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
				<fo:block xsl:use-attribute-sets="titNegrito" text-align="right"> <xsl:value-of select="format-number((Internas/InternasRow/VALOR),'###.###.###.##0,00')"/></fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas">
				<fo:block xsl:use-attribute-sets="titNegrito" text-align="right"> 
					<xsl:choose>
					<xsl:when test="$valorRclEndividamento=0.00 or $valorRclEndividamento='0,00' or $valorRclEndividamento=''">
						<xsl:value-of select="format-number(0.00, '###.###.##0,00')"/> %
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="format-number((Internas/InternasRow/VALOR) div ($valorRclEndividamento) * 100,'###.##0,00')"/>%
					</xsl:otherwise>
					</xsl:choose>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
		</xsl:if>
		<fo:table-row>
			<fo:table-cell padding-left="20pt" number-columns-spanned="2" xsl:use-attribute-sets="bordas">						
				<fo:block xsl:use-attribute-sets="txtLeft" font-weight="bold">Limite p/Emiss&#227;o de Alerta s/Limite Legal -  LRF, Inciso III do &#167; 1&#186; do art. 59</fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas">
				<fo:block xsl:use-attribute-sets="txtRight">14,40 %</fo:block>
			</fo:table-cell>
		</fo:table-row>
		<fo:table-row>
			<fo:table-cell padding-left="20pt" number-columns-spanned="2" xsl:use-attribute-sets="bordas">						
				<fo:block xsl:use-attribute-sets="txtLeft" font-weight="bold">Limite Legal - Opera&#231;&#227;o de Cr&#233;dito Internas e Externas- Resolu&#231;&#227;o do Senado Federal n&#186; 43/2001, art. 7&#186;</fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas">
				<fo:block xsl:use-attribute-sets="txtRight">16,00 %</fo:block>
			</fo:table-cell>
		</fo:table-row>
		<xsl:if test="((Internas/InternasRow/VALOR) div ($valorRclEndividamento)) * 100 &gt; 16.005">
			<fo:table-row>
				<fo:table-cell padding-left="10pt" number-columns-spanned="3" xsl:use-attribute-sets="bordas">
					<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt">Nos termos do inciso II do art. 55 da LRF, ultrapassado o limite legal &#233; compuls&#243;ria a indica&#231;&#227;o das provid&#234;ncias, adotadas ou a adotar, para elimina&#231;&#227;o do percentual excedente.</fo:block>
				</fo:table-cell>
			</fo:table-row>
			<xsl:for-each select="../../MedidasCorretivas/MedidasCorretivasRow[CD_PLANILHA=61]">
			<fo:table-row>
				<fo:table-cell padding-left="10pt" number-columns-spanned="3" xsl:use-attribute-sets="bordas">
					<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true"><xsl:value-of select="TEXTO"/></fo:block>
				</fo:table-cell>
			</fo:table-row>
			</xsl:for-each>
		</xsl:if>
	</xsl:if>				
	<fo:table-row>
		<fo:table-cell xsl:use-attribute-sets="bordas" number-columns-spanned="3" padding-left="10pt">
			<fo:block xsl:use-attribute-sets="titNegrito" text-align="left"></fo:block>
		</fo:table-cell>
	</fo:table-row>

	<xsl:if test="Antecipacao">
		<xsl:if test="Antecipacao='' or Antecipacao/AntecipacaoRow='' or Antecipacao/AntecipacaoRow/VALOR=''">
		<fo:table-row>
			<fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
				<fo:block xsl:use-attribute-sets="titNegrito" text-align="left">Opera&#231;&#227;o de Cr&#233;dito p/Antecipa&#231;&#227;o de Receita - ARO</fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
				<fo:block xsl:use-attribute-sets="titNegrito" text-align="right"> <xsl:value-of select="format-number((0.00),'###.###.###.##0,00')"/></fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas">
				<fo:block xsl:use-attribute-sets="titNegrito" text-align="right">
					<xsl:choose>
					<xsl:when test="$valorRclEndividamento=0.00 or $valorRclEndividamento='0,00' or $valorRclEndividamento=''">
						<xsl:value-of select="format-number(0.00, '###.###.##0,00')"/> %
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="format-number((0.00) div ($valorRclEndividamento) * 100,'###.##0,00')"/>%
					</xsl:otherwise>
					</xsl:choose>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
		</xsl:if>
		<xsl:if test="Antecipacao!='' or Antecipacao/AntecipacaoRow!='' or Antecipacao/AntecipacaoRow/VALOR!=''">
		<fo:table-row>
			<fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
				<fo:block xsl:use-attribute-sets="titNegrito" text-align="left">Opera&#231;&#227;o de Cr&#233;dito p/Antecipa&#231;&#227;o de Receita - ARO</fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
				<fo:block xsl:use-attribute-sets="titNegrito" text-align="right"> <xsl:value-of select="format-number((Antecipacao/AntecipacaoRow/VALOR),'###.###.###.##0,00')"/></fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas">
				<fo:block xsl:use-attribute-sets="titNegrito" text-align="right"> 
					<xsl:choose>
					<xsl:when test="$valorRclEndividamento=0.00 or $valorRclEndividamento='0,00' or $valorRclEndividamento=''">
						<xsl:value-of select="format-number(0.00, '###.###.##0,00')"/> %
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="format-number((Antecipacao/AntecipacaoRow/VALOR) div ($valorRclEndividamento) * 100,'###.##0,00')"/>%
					</xsl:otherwise>
					</xsl:choose>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
		</xsl:if>
		<fo:table-row>
			<fo:table-cell padding-left="20pt" number-columns-spanned="2" xsl:use-attribute-sets="bordas">						
						<fo:block xsl:use-attribute-sets="txtLeft" font-weight="bold">Limite p/Emiss&#227;o de Alerta s/Limite Legal - ARO - Resolu&#231;&#227;o do Senado Federal n&#186; 43/2001, art. 10</fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas">
				<fo:block xsl:use-attribute-sets="txtRight">6,30 %</fo:block>
			</fo:table-cell>
		</fo:table-row>
		<fo:table-row>
			<fo:table-cell padding-left="20pt" number-columns-spanned="2" xsl:use-attribute-sets="bordas">						
						<fo:block xsl:use-attribute-sets="txtLeft" font-weight="bold">Limite Legal - ARO - Resolu&#231;&#227;o do Senado Federal n&#186; 43/2001, art. 10</fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas">
				<fo:block xsl:use-attribute-sets="txtRight">7,00 %</fo:block>
			</fo:table-cell>
		</fo:table-row>
		<xsl:if test="(Antecipacao/AntecipacaoRow/VALOR) div ($valorRclEndividamento) * 100 &gt; 7.005">
			<fo:table-row>
				<fo:table-cell padding-left="10pt" number-columns-spanned="3" xsl:use-attribute-sets="bordas">
					<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true" language="pt">Nos termos do inciso II do art. 55 da LRF, ultrapassado o limite legal &#233; compuls&#243;ria a indica&#231;&#227;o das provid&#234;ncias, adotadas ou a adotar, para elimina&#231;&#227;o do percentual excedente.</fo:block>
				</fo:table-cell>
			</fo:table-row>
			<xsl:for-each select="../../MedidasCorretivas/MedidasCorretivasRow[CD_PLANILHA=62]">
			<fo:table-row>
				<fo:table-cell padding-left="10pt" number-columns-spanned="3" xsl:use-attribute-sets="bordas">
					<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true"><xsl:value-of select="TEXTO"/></fo:block>
				</fo:table-cell>
			</fo:table-row>
			</xsl:for-each>
		</xsl:if>
	</xsl:if>				
</fo:table-body>
</fo:table>			
</xsl:template>

<!--#############################-->
<!--####       MODELO 7      ####-->
<!--#############################-->
<xsl:template match="Modelo7">
<xsl:param name="CNPJ"/>

<!--***** VARIAVEIS *****-->
<xsl:variable name="isConsolidacao">
	<xsl:if test="../../Header/Indiretas/IndiretasRow[STATUS_CONSOLIDACAO = '1']">S</xsl:if>
</xsl:variable>

<xsl:variable name="CNPJHeader">
	<xsl:value-of select="../../Header/Informacoes/InformacoesRow/CNPJ"/>
</xsl:variable>
<!--*********************-->

 <fo:table table-layout="fixed" width="556pt">
	<fo:table-column column-width="100pt"/>
	<fo:table-column column-width="200pt"/>
	<fo:table-column column-width="128pt"/>
	<fo:table-column column-width="128pt"/>
	

	<fo:table-body>
	 <fo:table-row>
		<fo:table-cell number-columns-spanned="4">
			<fo:block xsl:use-attribute-sets="titFCinza">MODELO 7 - DEMONSTRATIVO DOS RESTOS A PAGAR</fo:block>
		</fo:table-cell>
	 </fo:table-row>
	 <fo:table-row>
		<fo:table-cell padding-left="10pt" number-columns-spanned="2">
			<fo:block xsl:use-attribute-sets="txtLeft">Lei Complementar Federal n&#186; 101/2000 - LRF, art. 54 e al&#237;nea &#180;&#180;b&#180;&#180; do Inciso III do art. 55</fo:block>
		</fo:table-cell>
		<fo:table-cell number-columns-spanned="2">
			<fo:block xsl:use-attribute-sets="txtCenter" >Valores expressos em reais</fo:block>
		</fo:table-cell>
	 </fo:table-row>

	  <xsl:if test="$isConsolidacao='S' and $CNPJ!=$CNPJHeader">
		<fo:table-row>
			<fo:table-cell number-columns-spanned="4">
				<fo:block xsl:use-attribute-sets="txtLeft">CNPJ: <xsl:value-of select="$CNPJ"/></fo:block>
				<fo:block xsl:use-attribute-sets="txtLeft">Entidade: <xsl:value-of select="../../Header/Indiretas/IndiretasRow[CNPJ=$CNPJ]/NOME_ENTIDADE"/></fo:block>
			</fo:table-cell>
		</fo:table-row>
	  </xsl:if>
	  <xsl:if test="$CNPJ=$CNPJHeader">
		<fo:table-row>
			<fo:table-cell number-columns-spanned="4">
				<fo:block xsl:use-attribute-sets="txtLeft">CNPJ: <xsl:value-of select="../../Header/Informacoes/InformacoesRow/CNPJ"/></fo:block>
				<fo:block xsl:use-attribute-sets="txtLeft">Entidade: <xsl:value-of select="../../Header/Informacoes/InformacoesRow/NOME"/></fo:block>
			</fo:table-cell>
		</fo:table-row>
	  </xsl:if>


 	</fo:table-body>
 </fo:table>				

	<xsl:variable name="restosRows" select="../TodosRestos/TodosRestosRow[CNPJ=$CNPJ]"/>

	<fo:table table-layout="fixed" width="556pt">
		<fo:table-column column-width="92pt"/>
		<fo:table-column column-width="92pt"/>
		<fo:table-column column-width="92pt"/>
		<fo:table-column column-width="92pt"/>
		<fo:table-column column-width="92pt"/>
		<fo:table-column column-width="92pt"/>

		<fo:table-body>
		<fo:table-row>
			<fo:table-cell number-rows-spanned="4" xsl:use-attribute-sets="bordas" padding-left="10pt">
				<fo:block xsl:use-attribute-sets="titNegrito">F.R.</fo:block>
			</fo:table-cell>
			<fo:table-cell number-columns-spanned="5" xsl:use-attribute-sets="bordas">
				<fo:block xsl:use-attribute-sets="titNegrito">Obrigaes Financeiras</fo:block>
			</fo:table-cell>
		</fo:table-row>
		<fo:table-row>
			<fo:table-cell number-columns-spanned="2" xsl:use-attribute-sets="bordas">
				<fo:block xsl:use-attribute-sets="titNegrito">Restos a Pagar Processados</fo:block>
			</fo:table-cell>
			<fo:table-cell number-rows-spanned="2" xsl:use-attribute-sets="bordas">
				<fo:block xsl:use-attribute-sets="titNegrito">RPNP de Exerccios Anteriores</fo:block>
			</fo:table-cell>
			<fo:table-cell number-rows-spanned="2" xsl:use-attribute-sets="bordas">
				<fo:block xsl:use-attribute-sets="titNegrito">Demais Obrigaes Financeiras</fo:block>
			</fo:table-cell>
			<fo:table-cell number-rows-spanned="2" xsl:use-attribute-sets="bordas">
				<fo:block xsl:use-attribute-sets="titNegrito">Total Obrigaes Financeiras antes Inscrio RPNP Exerccio</fo:block>
			</fo:table-cell>
		</fo:table-row>
		<fo:table-row>
			<fo:table-cell xsl:use-attribute-sets="bordas">
				<fo:block xsl:use-attribute-sets="titNegrito">De Exerccios Anteriores</fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas">
				<fo:block xsl:use-attribute-sets="titNegrito">Do Exerccio</fo:block>
			</fo:table-cell>
		</fo:table-row>
		<fo:table-row>
			<fo:table-cell xsl:use-attribute-sets="bordas">
				<fo:block xsl:use-attribute-sets="titNegrito">(a)</fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas">
				<fo:block xsl:use-attribute-sets="titNegrito">(b)</fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas">
				<fo:block xsl:use-attribute-sets="titNegrito">(c)</fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas">
				<fo:block xsl:use-attribute-sets="titNegrito">(d)</fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas">
				<fo:block xsl:use-attribute-sets="titNegrito">(e) = (a) + (b) + (c) + (d)</fo:block>
			</fo:table-cell>
			<!--
			-->
		</fo:table-row>
		<xsl:for-each select="$restosRows">
			<fo:table-row>
				<fo:table-cell border-width="0.5pt" >
					<fo:block xsl:use-attribute-sets="txtRight">
						<xsl:value-of select="CD_RECURSO"/>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell border-width="0.5pt" >
					<fo:block xsl:use-attribute-sets="txtRight">
						<xsl:value-of select="format-number(VLR_PROC_ANTERIOR+VLR_PROC_ANTERIOR_AJUSTE,'###.##0,00')"/>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell border-width="0.5pt" >
					<fo:block xsl:use-attribute-sets="txtRight">
						<xsl:value-of select="format-number(VLR_PROC_ATUAL+VLR_PROC_ATUAL_AJUSTE,'###.##0,00')"/>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell border-width="0.5pt" >
					<fo:block xsl:use-attribute-sets="txtRight">
						<xsl:value-of select="format-number(VLR_NPROC_ANTERIOR+VLR_NPROC_ANTERIOR_AJUSTE,'###.##0,00')"/>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell border-width="0.5pt" >
					<fo:block xsl:use-attribute-sets="txtRight">
						<xsl:value-of select="format-number(VLR_DEMAIS_OBR_FINANCEIRAS,'###.##0,00')"/>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell border-width="0.5pt" >
					<fo:block xsl:use-attribute-sets="txtRight">
						<xsl:value-of select="format-number(VLR_TOFAIPE,'###.##0,00')"/>
						<!--
						<xsl:value-of select="format-number(VLR_PROC_ANTERIOR+VLR_PROC_ANTERIOR_AJUSTE+
															VLR_PROC_ATUAL+VLR_PROC_ATUAL_AJUSTE+
															VLR_NPROC_ANTERIOR+VLR_NPROC_ANTERIOR_AJUSTE+
															VLR_DEMAIS_OBR_FINANCEIRAS,'###.##0,00')"/>
						-->
					</fo:block>
				</fo:table-cell>
			</fo:table-row>
		</xsl:for-each>
		<fo:table-row>
			<fo:table-cell border-width="0.5pt" >
				<fo:block xsl:use-attribute-sets="txtCenter" font-weight="bold">
					TOTAL
				</fo:block>
			</fo:table-cell>
			<fo:table-cell border-width="0.5pt" >
				<fo:block xsl:use-attribute-sets="txtRight" font-weight="bold">
					<xsl:value-of select="format-number(sum($restosRows/VLR_PROC_ANTERIOR)+sum($restosRows/VLR_PROC_ANTERIOR_AJUSTE),'###.##0,00')"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell border-width="0.5pt" >
				<fo:block xsl:use-attribute-sets="txtRight" font-weight="bold">
					<xsl:value-of select="format-number(sum($restosRows/VLR_PROC_ATUAL)+sum($restosRows/VLR_PROC_ATUAL_AJUSTE),'###.##0,00')"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell border-width="0.5pt" >
				<fo:block xsl:use-attribute-sets="txtRight" font-weight="bold">
					<xsl:value-of select="format-number(sum($restosRows/VLR_NPROC_ANTERIOR)+sum($restosRows/VLR_NPROC_ANTERIOR_AJUSTE),'###.##0,00')"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell border-width="0.5pt" >
				<fo:block xsl:use-attribute-sets="txtRight" font-weight="bold">
					<xsl:value-of select="format-number(sum($restosRows/VLR_DEMAIS_OBR_FINANCEIRAS),'###.##0,00')"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell border-width="0.5pt" >
				<fo:block xsl:use-attribute-sets="txtRight" font-weight="bold">
					<xsl:value-of select="format-number(sum($restosRows/VLR_TOFAIPE),'###.##0,00')"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>

		</fo:table-body>
	</fo:table>

	<fo:block><fo:leader leader-pattern="space"/></fo:block>
	<fo:block><fo:leader leader-pattern="space"/></fo:block>

	<fo:table table-layout="fixed" width="556pt">
		<fo:table-column column-width="92pt"/>
		<fo:table-column column-width="92pt"/>
		<fo:table-column column-width="92pt"/>
		<fo:table-column column-width="92pt"/>
		<fo:table-column column-width="92pt"/>
		<fo:table-column column-width="92pt"/>

		<fo:table-body>
		<fo:table-row>
			<fo:table-cell number-rows-spanned="2" xsl:use-attribute-sets="bordas">
				<fo:block xsl:use-attribute-sets="titNegrito">F.R.</fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas">
				<fo:block xsl:use-attribute-sets="titNegrito">Disponibilidade de Caixa Bruta</fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas">
				<fo:block xsl:use-attribute-sets="titNegrito">Total Obrigaes Financeitas antes Inscrio RPNP Exerccio</fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas">
				<fo:block xsl:use-attribute-sets="titNegrito">Disponibilidade de Caixa Lquida (antes da inscrio RPNP do exerccio)</fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas">
				<fo:block xsl:use-attribute-sets="titNegrito">RPNP do exerccio</fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas">
				<fo:block xsl:use-attribute-sets="titNegrito">Disponibilidade de Caixa Lquida (aps inscrio RPNP do exerccio)</fo:block>
			</fo:table-cell>
		</fo:table-row>
		<fo:table-row>
			<fo:table-cell xsl:use-attribute-sets="bordas">
				<fo:block xsl:use-attribute-sets="titNegrito">(f)</fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas">
				<fo:block xsl:use-attribute-sets="titNegrito">(e)</fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas">
				<fo:block xsl:use-attribute-sets="titNegrito">(g) = (f) - (e)</fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas">
				<fo:block xsl:use-attribute-sets="titNegrito">(h)</fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas">
				<fo:block xsl:use-attribute-sets="titNegrito">(i) = (g - h)</fo:block>
			</fo:table-cell>
		</fo:table-row>

		<xsl:for-each select="$restosRows">
			<fo:table-row>
				<fo:table-cell border-width="0.5pt" >
					<fo:block xsl:use-attribute-sets="txtRight">
						<xsl:value-of select="CD_RECURSO"/>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell border-width="0.5pt" >
					<fo:block xsl:use-attribute-sets="txtRight">
						<xsl:value-of select="format-number(DISP_FINANCEIRA+DISP_FINANCEIRA_AJUSTE,'###.##0,00')"/>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell border-width="0.5pt" >
					<fo:block xsl:use-attribute-sets="txtRight">
						<xsl:value-of select="format-number(VLR_TOFAIPE,'###.##0,00')"/>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell border-width="0.5pt" >
					<fo:block xsl:use-attribute-sets="txtRight">
						<!--
						<xsl:value-of select="format-number(VLR_PROC_ATUAL+VLR_PROC_ATUAL_AJUSTE-VLR_TOFAIPE,'###.##0,00')"/>
						-->
						<xsl:value-of select="format-number(DISP_FIN_ANTES_IR,'###.##0,00')"/>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell border-width="0.5pt" >
					<fo:block xsl:use-attribute-sets="txtRight">
						<xsl:value-of select="format-number(VLR_NPROC_ATUAL+VLR_NPROC_ATUAL_AJUSTE,'###.##0,00')"/>
					</fo:block>
				</fo:table-cell>
				<fo:table-cell border-width="0.5pt" >
					<fo:block xsl:use-attribute-sets="txtRight">
						<xsl:value-of select="format-number(DISP_FIN_APOS_IR,'###.##0,00')"/>
					</fo:block>
				</fo:table-cell>
			</fo:table-row>
		</xsl:for-each>
		<fo:table-row>
			<fo:table-cell border-width="0.5pt" >
				<fo:block xsl:use-attribute-sets="txtCenter" font-weight="bold">
					TOTAL
				</fo:block>
			</fo:table-cell>
			<fo:table-cell border-width="0.5pt" >
				<fo:block xsl:use-attribute-sets="txtRight" font-weight="bold">
					<xsl:value-of select="format-number(sum($restosRows/DISP_FINANCEIRA)+sum($restosRows/DISP_FINANCEIRA_AJUSTE),'###.##0,00')"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell border-width="0.5pt" >
				<fo:block xsl:use-attribute-sets="txtRight" font-weight="bold">
					<xsl:value-of select="format-number(sum($restosRows/VLR_TOFAIPE),'###.##0,00')"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell border-width="0.5pt" >
				<fo:block xsl:use-attribute-sets="txtRight" font-weight="bold">
					<xsl:value-of select="format-number(sum($restosRows/DISP_FIN_ANTES_IR),'###.##0,00')"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell border-width="0.5pt" >
				<fo:block xsl:use-attribute-sets="txtRight" font-weight="bold">
					<xsl:value-of select="format-number(sum($restosRows/VLR_NPROC_ATUAL)+sum($restosRows/VLR_NPROC_ATUAL_AJUSTE),'###.##0,00')"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell border-width="0.5pt" >
				<fo:block xsl:use-attribute-sets="txtRight" font-weight="bold">
					<xsl:value-of select="format-number(sum($restosRows/DISP_FIN_APOS_IR),'###.##0,00')"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
		<fo:table-row>
			<fo:table-cell border-width="0.5pt" number-columns-spanned="6">
				<fo:block xsl:use-attribute-sets="txtLeft" font-weight="bold">
				</fo:block>
			</fo:table-cell>
		</fo:table-row>
		<fo:table-row>
			<fo:table-cell border-width="0.5pt" number-columns-spanned="5">
				<fo:block xsl:use-attribute-sets="txtLeft" font-weight="bold">
					TOTAL DAS FONTES DE RECURSOS COM INSUFICINCIA FINANCEIRA
				</fo:block>
			</fo:table-cell>
			<fo:table-cell border-width="0.5pt" >
				<fo:block xsl:use-attribute-sets="txtRight" font-weight="bold">
					<xsl:value-of select="format-number(sum($restosRows[DISP_FIN_APOS_IR &lt; 0]/DISP_FIN_APOS_IR),'###.##0,00')"/>
				</fo:block>
			</fo:table-cell>
		</fo:table-row>

		</fo:table-body>
	</fo:table>

<!--
	 <fo:table-row>
		<fo:table-cell padding-left="10pt" number-rows-spanned="3" xsl:use-attribute-sets="bordas">
			<fo:block xsl:use-attribute-sets="titNegrito" text-align="left">C&#243;digo do Recurso</fo:block>
		</fo:table-cell>
		<fo:table-cell number-rows-spanned="3" xsl:use-attribute-sets="bordas">
			<fo:block xsl:use-attribute-sets="txtCenter" >Nome do Recurso</fo:block>
		</fo:table-cell>
		<fo:table-cell xsl:use-attribute-sets="bordas" number-columns-spanned="2">
			<fo:block xsl:use-attribute-sets="txtCenter" >INSCRITOS EM RESTOS A PAGAR COM SUFICI&#202;NCIA FINANCEIRA</fo:block>
		</fo:table-cell>
	 </fo:table-row>
	 <fo:table-row>
		<fo:table-cell xsl:use-attribute-sets="bordas">
			<fo:block xsl:use-attribute-sets="titNegrito">PROCESSADOS</fo:block>
		</fo:table-cell>
		<fo:table-cell xsl:use-attribute-sets="bordas">
			<fo:block xsl:use-attribute-sets="titNegrito">N&#195;O PROCESSADOS</fo:block>
		</fo:table-cell>
	 </fo:table-row>
	 <fo:table-row>
		<fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
			<fo:block xsl:use-attribute-sets="titNegrito" >Ajustado</fo:block>
		</fo:table-cell>
		<fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
			<fo:block xsl:use-attribute-sets="titNegrito" >Ajustado</fo:block>
		</fo:table-cell>
	 </fo:table-row>

	 <xsl:for-each select="Modelo7Row[CNPJ=$CNPJ and (VALOR_P>0 or VALOR_Q>0)]">
	 <fo:table-row>
			<fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
				<fo:block xsl:use-attribute-sets="txtLeft" text-align="left"><xsl:value-of select="CD_RECURSO"/></fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
				<fo:block xsl:use-attribute-sets="txtLeft" text-align="left"><xsl:value-of select="DS_RECURSO"/></fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas">
				<fo:block xsl:use-attribute-sets="txtRight" text-align="right"><xsl:value-of select=" format-number(VALOR_P,'###.##0,00')"/></fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas">
				<fo:block xsl:use-attribute-sets="txtRight" text-align="right">
					<xsl:value-of select=" format-number(VALOR_Q,'###.##0,00')"/>
				</fo:block>
			</fo:table-cell>
	 </fo:table-row>
	 </xsl:for-each>  

	 <fo:table-row>
		<fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt" number-columns-spanned="2">
			<fo:block xsl:use-attribute-sets="txtLeft" text-align="left">SUBTOTAL </fo:block>
		</fo:table-cell>
		<fo:table-cell xsl:use-attribute-sets="bordas">
			<fo:block xsl:use-attribute-sets="txtRight" text-align="right"><xsl:value-of select="format-number(sum(Modelo7Row[CNPJ=$CNPJ]/VALOR_P),'###.###.###.##0,00')"/></fo:block>
		</fo:table-cell>
		<fo:table-cell xsl:use-attribute-sets="bordas">
			<fo:block xsl:use-attribute-sets="txtRight" text-align="right"><xsl:value-of select="format-number(sum(Modelo7Row[CNPJ=$CNPJ]/VALOR_Q),'###.###.###.##0,00')"/></fo:block>
		</fo:table-cell>
	 </fo:table-row>
	 <fo:table-row>
		<fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt" number-columns-spanned="2">
			<fo:block xsl:use-attribute-sets="txtLeft" text-align="left">TOTAL </fo:block>
		</fo:table-cell>
		<fo:table-cell xsl:use-attribute-sets="bordas" number-columns-spanned="2">
			<fo:block xsl:use-attribute-sets="txtRight" text-align="right"><xsl:value-of select="format-number(sum(Modelo7Row[CNPJ=$CNPJ]/VALOR_P) + sum(Modelo7Row[CNPJ=$CNPJ]/VALOR_Q),'###.###.###.##0,00')"/></fo:block>
		</fo:table-cell>
	 </fo:table-row>

 	</fo:table-body>
 </fo:table>				

  <fo:block><fo:leader leader-pattern="space" /></fo:block>
  <fo:block><fo:leader leader-pattern="space" /></fo:block>
	
<!- - ######   Segundo quadro Modelo 7  ######- ->
<fo:table table-layout="fixed" width="556pt">
	<fo:table-column column-width="50pt"/>
	<fo:table-column column-width="186pt"/>
	<fo:table-column column-width="80pt"/>
	<fo:table-column column-width="80pt"/>
	<fo:table-column column-width="80pt"/>
	<fo:table-column column-width="80pt"/>

	<fo:table-body>
	 <fo:table-row>
		<fo:table-cell padding-left="10pt" number-rows-spanned="4" xsl:use-attribute-sets="bordas">
			<fo:block xsl:use-attribute-sets="titNegrito" text-align="left">C&#243;digo do Recurso</fo:block>
		</fo:table-cell>
		<fo:table-cell number-rows-spanned="4" xsl:use-attribute-sets="bordas">
			<fo:block xsl:use-attribute-sets="txtCenter" >Nome do Recurso</fo:block>
		</fo:table-cell>
		<fo:table-cell xsl:use-attribute-sets="bordas" number-columns-spanned="4">
			<fo:block xsl:use-attribute-sets="txtCenter" >INSCRITOS EM RESTOS A PAGAR COM INSUFICI&#202;NCIA FINANCEIRA</fo:block>
		</fo:table-cell>
	 </fo:table-row>
	 <fo:table-row>
		<fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt" number-columns-spanned="2">
			<fo:block xsl:use-attribute-sets="titNegrito" >DE EXERC&#205;CIOS ANTERIORES</fo:block>
		</fo:table-cell>
		<fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt" number-columns-spanned="2">
			<fo:block xsl:use-attribute-sets="titNegrito" >DO EXERC&#205;CIO ATUAL</fo:block>
		</fo:table-cell>
	 </fo:table-row>
	 <fo:table-row>
		<fo:table-cell xsl:use-attribute-sets="bordas" >
			<fo:block xsl:use-attribute-sets="txtCenter" >PROCESSADOS</fo:block>
		</fo:table-cell>
		<fo:table-cell xsl:use-attribute-sets="bordas" >
			<fo:block xsl:use-attribute-sets="txtCenter" >N&#195;O PROCESSADOS</fo:block>
		</fo:table-cell>
		<fo:table-cell xsl:use-attribute-sets="bordas" >
			<fo:block xsl:use-attribute-sets="txtCenter" >PROCESSADOS</fo:block>
		</fo:table-cell>
		<fo:table-cell xsl:use-attribute-sets="bordas" >
			<fo:block xsl:use-attribute-sets="txtCenter" >N&#195;O PROCESSADOS</fo:block>
		</fo:table-cell>
	 </fo:table-row>
	 <fo:table-row>
		<fo:table-cell xsl:use-attribute-sets="bordas" >
			<fo:block xsl:use-attribute-sets="titNegrito" >Ajustado</fo:block>
		</fo:table-cell>
		<fo:table-cell xsl:use-attribute-sets="bordas" >
			<fo:block xsl:use-attribute-sets="titNegrito" >Ajustado</fo:block>
		</fo:table-cell>
		<fo:table-cell xsl:use-attribute-sets="bordas" >
			<fo:block xsl:use-attribute-sets="titNegrito" >Ajustado</fo:block>
		</fo:table-cell>
		<fo:table-cell xsl:use-attribute-sets="bordas" >
			<fo:block xsl:use-attribute-sets="titNegrito" >Ajustado</fo:block>
		</fo:table-cell>
	 </fo:table-row>
	 <xsl:for-each select="Modelo7Row[CNPJ=$CNPJ and (VALOR_R>0 or VALOR_S>0 or VALOR_T>0 or VALOR_U>0)]">
		<fo:table-row>
			<fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
				<fo:block xsl:use-attribute-sets="txtLeft" text-align="left"><xsl:value-of select="CD_RECURSO"/></fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt">
				<fo:block xsl:use-attribute-sets="txtLeft" text-align="left"><xsl:value-of select="DS_RECURSO"/></fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas">
				<fo:block xsl:use-attribute-sets="txtRight" text-align="right">
					<xsl:value-of select=" format-number((VALOR_R),'###.##0,00')"/>
				</fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas">
				<fo:block xsl:use-attribute-sets="txtRight" text-align="right">
					<xsl:value-of select=" format-number((VALOR_S),'###.##0,00')"/>							
				</fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas">
				<fo:block xsl:use-attribute-sets="txtRight" text-align="right">
					<xsl:value-of select=" format-number((VALOR_T),'###.##0,00')"/>							
				</fo:block>
			</fo:table-cell>
			<fo:table-cell xsl:use-attribute-sets="bordas">
				<fo:block xsl:use-attribute-sets="txtRight" text-align="right">
					<xsl:value-of select=" format-number((VALOR_U),'###.##0,00')"/>							
				</fo:block>
			</fo:table-cell>
		 </fo:table-row>
	 </xsl:for-each> 

	<fo:table-row>
		<fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt" number-columns-spanned="2">
			<fo:block xsl:use-attribute-sets="txtLeft" text-align="left">SUBTOTAL </fo:block>
		</fo:table-cell>
		<fo:table-cell xsl:use-attribute-sets="bordas">
			<fo:block xsl:use-attribute-sets="txtRight" text-align="right">
				<xsl:value-of select=" format-number(sum(Modelo7Row[CNPJ=$CNPJ]/VALOR_R),'###.##0,00')"/>
			</fo:block>
		</fo:table-cell>
		<fo:table-cell xsl:use-attribute-sets="bordas">
			<fo:block xsl:use-attribute-sets="txtRight" text-align="right">
				<xsl:value-of select=" format-number(sum(Modelo7Row[CNPJ=$CNPJ]/VALOR_S),'###.##0,00')"/>							
			</fo:block>
		</fo:table-cell>
		<fo:table-cell xsl:use-attribute-sets="bordas">
			<fo:block xsl:use-attribute-sets="txtRight" text-align="right">
				<xsl:value-of select=" format-number(sum(Modelo7Row[CNPJ=$CNPJ]/VALOR_T),'###.##0,00')"/>							
			</fo:block>
		</fo:table-cell>
		<fo:table-cell xsl:use-attribute-sets="bordas">
			<fo:block xsl:use-attribute-sets="txtRight" text-align="right">
				<xsl:value-of select=" format-number(sum(Modelo7Row[CNPJ=$CNPJ]/VALOR_U),'###.##0,00')"/>							
			</fo:block>
		</fo:table-cell>
	</fo:table-row>		

	<fo:table-row>
		<fo:table-cell xsl:use-attribute-sets="bordas" padding-left="10pt" number-columns-spanned="2">
			<fo:block xsl:use-attribute-sets="txtLeft" text-align="left">TOTAL </fo:block>
		</fo:table-cell>
		<fo:table-cell xsl:use-attribute-sets="bordas" number-columns-spanned="2">
			<fo:block xsl:use-attribute-sets="txtRight" text-align="right">
				<xsl:value-of select=" format-number(sum(Modelo7Row[CNPJ=$CNPJ]/VALOR_R)+sum(Modelo7Row[CNPJ=$CNPJ]/VALOR_S),'###.##0,00')"/>							
			</fo:block>
		</fo:table-cell>
		<fo:table-cell xsl:use-attribute-sets="bordas" number-columns-spanned="2">
			<fo:block xsl:use-attribute-sets="txtRight" text-align="right">
				<xsl:value-of select=" format-number(sum(Modelo7Row[CNPJ=$CNPJ]/VALOR_T)+sum(Modelo7Row[CNPJ=$CNPJ]/VALOR_U),'###.##0,00')"/>							
			</fo:block>
		</fo:table-cell>
	</fo:table-row>		

	</fo:table-body>

 </fo:table>				

  <fo:block><fo:leader leader-pattern="space" /></fo:block>
  <fo:block><fo:leader leader-pattern="space" /></fo:block>

<!- -##### Terceiro Quadro Modelo 7 #####- ->
<fo:table table-layout="fixed" width="556pt">
	<fo:table-column column-width="110pt"/>
	<fo:table-column column-width="90pt"/>
	<fo:table-column column-width="100pt"/>
<fo:table-body>
	<fo:table-row>
		<fo:table-cell padding-left="10pt" number-columns-spanned="3">
			<fo:block xsl:use-attribute-sets="titNegrito" text-align="left">TOTAL DOS RESTOS A PAGAR COM INSUFICI&#202;NCIA FINANCEIRA</fo:block>
		</fo:table-cell>
	</fo:table-row>
	<fo:table-row>
		<fo:table-cell padding-left="10pt" number-columns-spanned="2">
			<fo:block xsl:use-attribute-sets="titNegrito" text-align="left" >Exerc&#237;cios Anteriores</fo:block>
		</fo:table-cell>
	</fo:table-row>
	<fo:table-row>
		<fo:table-cell padding-left="20pt">
			<fo:block xsl:use-attribute-sets="txtLeft" >Processados</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<fo:block xsl:use-attribute-sets="txtRight" ><xsl:value-of select="format-number(sum(Modelo7Row[CNPJ=$CNPJ]/VALOR_R),'###.###.###.##0,00')"/></fo:block>
		</fo:table-cell>
	</fo:table-row>
	<fo:table-row>
		<fo:table-cell padding-left="20pt">
			<fo:block xsl:use-attribute-sets="txtLeft" >N&#227;o Processados</fo:block>
		</fo:table-cell>
		<fo:table-cell >
			<fo:block xsl:use-attribute-sets="txtRight" ><xsl:value-of select="format-number(sum(Modelo7Row[CNPJ=$CNPJ]/VALOR_S),'###.###.###.##0,00')"/></fo:block>
		</fo:table-cell>
	</fo:table-row>
	<fo:table-row>
		<fo:table-cell padding-left="10pt">
			<fo:block xsl:use-attribute-sets="txtLeft" >Subtotal</fo:block>
		</fo:table-cell>
		<fo:table-cell >
			<fo:block xsl:use-attribute-sets="txtRight" ><xsl:value-of select="format-number(sum(Modelo7Row[CNPJ=$CNPJ]/VALOR_S) + sum(Modelo7Row[CNPJ=$CNPJ]/VALOR_R),'###.###.###.##0,00')"/></fo:block>
		</fo:table-cell>
	</fo:table-row>
	<fo:table-row>
		<fo:table-cell padding-left="10pt" number-columns-spanned="2">
			<fo:block xsl:use-attribute-sets="titNegrito" text-align="left"><fo:leader leader-pattern="space" /></fo:block>
		</fo:table-cell>
	</fo:table-row>
	<fo:table-row>
		<fo:table-cell padding-left="10pt" number-columns-spanned="2">
			<fo:block xsl:use-attribute-sets="titNegrito" text-align="left">Exerc&#237;cio Atual</fo:block>
		</fo:table-cell>
	</fo:table-row>
	<fo:table-row>
		<fo:table-cell padding-left="20pt">
			<fo:block xsl:use-attribute-sets="txtLeft" >Processados</fo:block>
		</fo:table-cell>
		<fo:table-cell >
			<fo:block xsl:use-attribute-sets="txtRight" ><xsl:value-of select="format-number(sum(Modelo7Row[CNPJ=$CNPJ]/VALOR_T),'###.###.###.##0,00')"/></fo:block>
		</fo:table-cell>
	</fo:table-row>
	<fo:table-row>
		<fo:table-cell padding-left="20pt">
			<fo:block xsl:use-attribute-sets="txtLeft" >N&#227;o Processados</fo:block>
		</fo:table-cell>
		<fo:table-cell >
			<fo:block xsl:use-attribute-sets="txtRight" ><xsl:value-of select="format-number(sum(Modelo7Row[CNPJ=$CNPJ]/VALOR_U),'###.###.###.##0,00')"/></fo:block>
		</fo:table-cell>
	</fo:table-row>
	<fo:table-row>
		<fo:table-cell padding-left="10pt">
			<fo:block xsl:use-attribute-sets="txtLeft" >Subtotal</fo:block>
		</fo:table-cell>
		<fo:table-cell >
			<fo:block xsl:use-attribute-sets="txtRight" ><xsl:value-of select="format-number(sum(Modelo7Row[CNPJ=$CNPJ]/VALOR_T) + sum(Modelo7Row[CNPJ=$CNPJ]/VALOR_U),'###.###.###.##0,00')"/></fo:block>
		</fo:table-cell>
	</fo:table-row>
	<fo:table-row>
		<fo:table-cell padding-left="10pt" number-columns-spanned="2">
			<fo:block xsl:use-attribute-sets="titNegrito" text-align="left"><fo:leader leader-pattern="space" /></fo:block>
		</fo:table-cell>
	</fo:table-row>
	<fo:table-row>
		<fo:table-cell padding-left="10pt">
			<fo:block xsl:use-attribute-sets="txtLeft" >Total Ex Anterior + Ex Atual</fo:block>
		</fo:table-cell>
		<fo:table-cell >
			<fo:block xsl:use-attribute-sets="txtRight" ><xsl:value-of select="format-number(sum(Modelo7Row[CNPJ=$CNPJ]/VALOR_T) + sum(Modelo7Row[CNPJ=$CNPJ]/VALOR_U) + sum(Modelo7Row[CNPJ=$CNPJ]/VALOR_S) + sum(Modelo7Row[CNPJ=$CNPJ]/VALOR_R),'###.###.###.##0,00')"/></fo:block>
		</fo:table-cell>
	</fo:table-row>
</fo:table-body>
</fo:table>
-->

</xsl:template>

<!--***************************************************-->
<!--**********************ALERTAS**********************-->
<!--***************************************************-->

<!-- -############## DespesasPessoal  ################-->
<xsl:template name="DespesasPessoal">
<xsl:param name="VALOR"/>

<xsl:choose>

 <!-- INICIO ALERTA 2 -->
 <xsl:when test="$VALOR &gt;= 48.61 and $VALOR &lt;= 51.305">
  <fo:block><fo:leader leader-pattern="space"/></fo:block>
  <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="45pt"/>
  <fo:table-column column-number="2" column-width="125pt"/>
  <fo:table-column column-number="3" column-width="320pt"/>
  <fo:table-column column-number="4" column-width="36pt"/>

  <fo:table-body>
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt" border-width="0.5pt" number-columns-spanned="4">
     <fo:block font-weight="bold" text-align="center" xsl:use-attribute-sets="titNegritoBig">DESPESA COM PESSOAL </fo:block>
    </fo:table-cell>
   </fo:table-row> 

   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt" border-width="0.5pt" number-columns-spanned="4">
		<fo:block><fo:leader leader-pattern="space"/></fo:block>
	</fo:table-cell>
   </fo:table-row>   
   
   <fo:table-row>
    <fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="txtJustifyMed"><fo:inline font-weight="normal" color="white">__________</fo:inline>O <fo:inline font-weight="bold">&#205;NDICE DE DESPESA COM PESSOAL</fo:inline> de <xsl:value-of select="format-number($VALOR,'###.###.##0,00')"></xsl:value-of> % est&#225; situado <fo:inline font-weight="bold" font-style="italic" text-decoration="underline">no intervalo de 48,61% a 51,30%</fo:inline>, sendo, portanto, superior ao limite para emiss&#227;o do alerta de que trata o Inciso II do &#167; 1&#186; do Art. 59 da LRF, de 48,60%, (percentual este equivalente a 90,00% sobre o limite de 54,00%, conforme estipulado no Inciso II do &#167; 1&#186; do Art. 59 c/c al&#237;nea &#180;&#180;b&#180;&#180; do Inciso III do Art. 20, ambos da LRF).</fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>
</xsl:when>
<!-- FIM ALERTA 2 -->	  

<!-- INICIO ALERTA 3 -->
<xsl:when test="$VALOR  &gt; 51.305 and $VALOR &lt; 54.005">

 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="45pt"/>
  <fo:table-column column-number="2" column-width="125pt"/>
  <fo:table-column column-number="3" column-width="320pt"/>
  <fo:table-column column-number="4" column-width="36pt"/>
  
  <fo:table-body>
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt" border-width="0.5pt" number-columns-spanned="4">
     <fo:block font-weight="bold" text-align="center" xsl:use-attribute-sets="titNegritoBig">DESPESA COM PESSOAL </fo:block>
    </fo:table-cell>
   </fo:table-row>   

   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt" border-width="0.5pt" number-columns-spanned="4"><fo:block><fo:leader leader-pattern="space"/></fo:block></fo:table-cell>
   </fo:table-row>   

   <fo:table-row>
    <fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="txtJustifyMed"><fo:inline font-weight="normal" color="white">__________</fo:inline>O <fo:inline font-weight="bold">&#205;NDICE DE DESPESA COM PESSOAL</fo:inline> de <xsl:value-of select="format-number($VALOR,'###.###.##0,00')"></xsl:value-of> % est&#225; situado <fo:inline font-weight="bold" font-style="italic" text-decoration="underline">no intervalo de 51,31%</fo:inline>, a 54,00% sendo, portanto, superior ao limite para emiss&#227;o do alerta de que trata o Inciso II do &#167; 1&#186; do Art. 59 da LRF (51,30%, percentual este equivalente a 95,00% sobre o limite de 54,00%, conforme estipulado no par&#225;grafo &#250;nico  do art. 22 c/c al&#237;nea &#180;&#180;b&#180;&#180; do Inciso III do Art. 20, ambos da LRF), e coloca o Poder Executivo/Indiretas Municipais, conforme determinado no citado par&#225;grafo &#250;nico do art. 22 da LRF, ao <fo:inline font-weight="bold" font-style="italic" text-decoration="underline">ao alcance das seguintes VEDA&#199;&#213;ES</fo:inline></fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>
   </fo:table-row>

   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
	 <fo:block xsl:use-attribute-sets="txtJustify">Lei de Responsabilidade Fiscal, Incisos I a V do Par&#225;grafo &#218;nico do Art. 22:</fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="txtJustify">Art. 22 -  [...]</fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>

   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="txtJustify">Par&#225;grafo &#218;nico - [...]</fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="txtJustify">I - concess&#227;o de vantagem, aumento, reajuste ou adequa&#231;&#227;o de remunera&#231;&#227;o a qualquer t&#237;tulo, salvo os derivados de senten&#231;a judicial ou de determina&#231;&#227;o legal ou contratual, ressalvada a revis&#227;o prevista no inciso X do art. 37 da Constitui&#231;&#227;o;</fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="txtJustify">II - cria&#231;&#227;o de cargo, emprego ou fun&#231;&#227;o;</fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="txtJustify">III - altera&#231;&#227;o de estrutura de carreira que implique aumento de despesa;</fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="txtJustify">IV - provimento de cargo p&#250;blico, admiss&#227;o ou contrata&#231;&#227;o de pessoal a qualquer t&#237;tulo, ressalvada a reposi&#231;&#227;o decorrente de aposentadoria ou falecimento de servidores das &#225;reas de educa&#231;&#227;o, sa&#250;de e seguran&#231;a;</fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="txtJustify">V - contrata&#231;&#227;o de hora extra, salvo no caso do disposto no inciso II do &#167; 6&#186; do art. 57 da Constitui&#231;&#227;o e as situa&#231;&#245;es previstas na lei de diretrizes or&#231;ament&#225;rias.</fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>
</xsl:when>
<!-- FIM ALERTA 3 --> 	 

<!-- INICIO ALERTA 4 -->
<xsl:when test="$VALOR  &gt;= 54.005">

 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="45pt"/>
  <fo:table-column column-number="2" column-width="125pt"/>
  <fo:table-column column-number="3" column-width="320pt"/>
  <fo:table-column column-number="4" column-width="36pt"/>

  <fo:table-body>
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt" border-width="0.5pt" number-columns-spanned="4">
     <fo:block font-weight="bold" text-align="center" xsl:use-attribute-sets="titNegritoBig">DESPESA COM PESSOAL </fo:block>
    </fo:table-cell>
   </fo:table-row>   

   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt" border-width="0.5pt" number-columns-spanned="4"><fo:block><fo:leader leader-pattern="space"/></fo:block></fo:table-cell>
   </fo:table-row>   

   <fo:table-row>
    <fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2">
      <fo:block xsl:use-attribute-sets="txtJustifyMed">
        <fo:inline font-weight="normal" color="white">__________</fo:inline>O <fo:inline font-weight="bold">&#205;NDICE DE DESPESA COM PESSOAL</fo:inline>
        de <xsl:value-of select="format-number($VALOR,'###.###.##0,00')"></xsl:value-of> %
        <fo:inline font-weight="bold" font-style="italic" text-decoration="underline">&#233; superior</fo:inline> ao limite para emiss&#227;o do alerta de que trata o Inciso II do &#167; 1&#186; do art. 59 da LRF,
        e ao limite de 54,00% fixado na al&#237;nea &#180;&#180;b&#180;&#180; do inciso III do art. 20 da LRF,
        situa&#231;&#227;o que coloca o Poder Executivo/Indiretas Municipais
        <fo:inline font-weight="bold" font-style="italic" text-decoration="underline">ao alcance das veda&#231;&#245;es descritas no par&#225;grafo &#250;nico do art. 22,
        na obriga&#231;&#227;o de adotar provid&#234;ncias para a elimina&#231;&#227;o do percentual excedente no prazo
        <!--
        e condi&#231;&#245;es estabelecidas nos &#167;
        1&#186; e &#167; 2&#186; e do caput do art. 23, e o Munic&#237;pio sujeito &#224;s restri&#231;&#245;es dos &#167; 3&#186; e &#167; 4&#186; do mesmo artigo,
        sem prejuzo do disposto nos 5 e 6,
        todos da LRF.
        -->
        estabelecido no caput do artigo 23, e sujeita o Municpio s restries dos  3 e 4, sem prejuzo do disposto nos 5 e 6, do mesmo artigo, todos da LRF.
        </fo:inline>

        <!--
        <fo:inline font-weight="normal" color="white">__________</fo:inline>O <fo:inline font-weight="bold">&#205;NDICE DE DESPESA COM PESSOAL</fo:inline>
        ao trmino do exerccio financeiro de 2021 de
        <xsl:value-of select="format-number($VALOR,'###.###.##0,00')"></xsl:value-of> %  superior ao limite para emisso do alerta de que trata o inciso II do  1 do artigo 59 da LRF,
        e ao limite de 54% fixado na alnea "b" do inciso III do artigo 20 da LRF, situao que coloca o Poder Executivo/Indiretas Municipais ao alcance do disposto
        no artigo 15 da Lei Complementar Federal n 178, de 13 de janeiro de 2021, que instituiu um regime especial para eliminao, em dez anos,
        a partir do exerccio de 2023, do excedente da despesa com pessoal apurado ao final do exerccio de 2021,
        suspendendo assim as contagens de prazo e das disposies do art. 23 da Lei Complementar Federal n 101, de 2000.
        -->
      </fo:block>
    </fo:table-cell>
    <fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>
   </fo:table-row>

   <fo:table-row>
    <fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2">
      <fo:block xsl:use-attribute-sets="txtJustifyMed">
        <fo:inline font-weight="normal" color="white">__________</fo:inline>
        O Poder Executivo cuja despesa total com pessoal ao
        <fo:inline font-weight="bold" font-style="italic" text-decoration="underline">
        trmino de 2021 foi superior ao limite estabelecido no art. 20 da LRF, dever eliminar o excesso  razo de, pelo menos, 10% (dez por cento) a cada exerccio a partir de 2023, de forma a se enquadrar no respectivo limite at o trmino do exerccio de 2032
        </fo:inline>
        , conforme regra trazida pelo art. 15 da LC n 178/2021 (Regime Especial). Nessa situao, o Poder Executivo que no decurso dos 10 anos vier a ficar abaixo do limite legal, volta para o regramento determinado no art. 23 da LRF.
      </fo:block>
    </fo:table-cell>
    <fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>
   </fo:table-row>

   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
	 <fo:block xsl:use-attribute-sets="titNegritoBig">Das Veda&#231;&#245;es</fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt" border-width="0.5pt" number-columns-spanned="4"><fo:block><fo:leader leader-pattern="space"/></fo:block></fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="txtJustify">Lei de Responsabilidade Fiscal, Incisos I a V do Par&#225;grafo &#218;nico do Art. 22:</fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="txtJustify">Art. 22 -  [...]</fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="txtJustify">Par&#225;grafo &#218;nico - [...]</fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="txtJustify">I - concess&#227;o de vantagem, aumento, reajuste ou adequa&#231;&#227;o de remunera&#231;&#227;o a qualquer t&#237;tulo, salvo os derivados de senten&#231;a judicial ou de determina&#231;&#227;o legal ou contratual, ressalvada a revis&#227;o prevista no inciso X do art. 37 da Constitui&#231;&#227;o;</fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="txtJustify">II - cria&#231;&#227;o de cargo, emprego ou fun&#231;&#227;o;</fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="txtJustify">III - altera&#231;&#227;o de estrutura de carreira que implique aumento de despesa;</fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="txtJustify">IV - provimento de cargo p&#250;blico, admiss&#227;o ou contrata&#231;&#227;o de pessoal a qualquer t&#237;tulo, ressalvada a reposi&#231;&#227;o decorrente de aposentadoria ou falecimento de servidores das &#225;reas de educa&#231;&#227;o, sa&#250;de e seguran&#231;a;</fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="txtJustify">V - contrata&#231;&#227;o de hora extra, salvo no caso do disposto no inciso II do &#167; 6&#186; do art. 57 da Constitui&#231;&#227;o e as situa&#231;&#245;es previstas na lei de diretrizes or&#231;ament&#225;rias.</fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>

   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="titNegritoBig">Do Prazo para Elimina&#231;&#227;o do Percentual Excedente</fo:block>
    </fo:table-cell>
   </fo:table-row>

   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
     <fo:block xsl:use-attribute-sets="titNegritoMed">Regime ordinrio (para o Poder Executivo/Indiretas que no exceder o limite ao final de 2021)</fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt" border-width="0.5pt" number-columns-spanned="4"><fo:block><fo:leader leader-pattern="space"/></fo:block></fo:table-cell>
   </fo:table-row>

   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="txtJustify">Lei de Responsabilidade Fiscal, Art. 23:</fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtJustify">
      <!--
      Art. 23 - Ultrapassado o limite legal (54%) o percentual excedente dever&#225; ser eliminado nos dois quadrimestres seguintes, sendo pelo menos um ter&#231;o no primeiro.
      -->
      Art. 23. Se a despesa total com pessoal, do Poder ou rgo referido no artigo 20, ultrapassar os limites definidos no mesmo artigo, sem prejuzo das medidas previstas no artigo 22, o percentual excedente ter de ser eliminado nos dois quadrimestres seguintes, sendo pelo menos um tero no primeiro, adotando-se, entre outras, as providncias previstas nos  3 e 4 do artigo 169 da Constituio.
     </fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>

   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"></fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
     <fo:block xsl:use-attribute-sets="titNegritoMed">Regime especial (para o Poder Executivo/Indiretas que exceder o limite ao final de 2021)</fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt" border-width="0.5pt" number-columns-spanned="4"><fo:block><fo:leader leader-pattern="space"/></fo:block></fo:table-cell>
   </fo:table-row>

   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtJustify">Lei Complementar Federal n 178, caput e  2, 3 e 4 do arigo 15:</fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>

   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtJustify">Art. 15. O Poder ou rgo cuja despesa total com pessoal ao trmino do exerccio financeiro da publicao desta Lei Complementar estiver acima de seu respectivo limite estabelecido no art. 20 da Lei Complementar n 101, de 4 de maio de 2000, dever eliminar o excesso  razo de, pelo menos, 10% (dez por cento) a cada exerccio a partir de 2023, por meio da adoo, entre outras, das medidas previstas nos arts. 22 e 23 daquela Lei Complementar, de forma a se enquadrar no respectivo limite at o trmino do exerccio de 2032.</fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>

   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtJustify">[...]</fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtJustify"> 2 A comprovao acerca do cumprimento da regra de eliminao do excesso de despesas com pessoal prevista no caput dever ser feita no ltimo quadrimestre de cada exerccio, observado o art. 18 da Lei Complementar n 101, de 4 de maio de 2000.</fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtJustify"> 3 Ficam suspensas as contagens de prazo e as disposies do art. 23 da Lei Complementar n 101, de 4 de maio de 2000, no exerccio financeiro de publicao desta Lei Complementar.</fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtJustify"> 4 At o encerramento do prazo a que se refere o caput, ser considerado cumprido o disposto no art. 23 da Lei Complementar n 101, de 4 de maio de 2000, pelo Poder ou rgo referido no art. 20 daquela Lei Complementar que atender ao estabelecido neste artigo.</fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>

   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="titNegritoBig">Das Provid&#234;ncias para Elimina&#231;&#227;o do Percentual Excedente</fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt" border-width="0.5pt" number-columns-spanned="4"><fo:block><fo:leader leader-pattern="space"/></fo:block></fo:table-cell>
   </fo:table-row>

   <!--
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtJustify">Lei Complementar Federal n 178, caput do artigo 15:</fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtJustify">Art. 15. O Poder ou rgo cuja despesa total com pessoal ao trmino do exerccio financeiro da publicao desta Lei Complementar estiver acima de seu respectivo limite estabelecido no art. 20 da Lei Complementar n 101, de 4 de maio de 2000, dever eliminar o excesso  razo de, pelo menos, 10% (dez por cento) a cada exerccio a partir de 2023, por meio da adoo, entre outras, das medidas previstas nos arts. 22 e 23 daquela Lei Complementar, de forma a se enquadrar no respectivo limite at o trmino do exerccio de 2032.</fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtJustify">Lei de Responsabilidade Fiscal, incisos I a V do pargrafo nico do artigo 22:</fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtJustify">Art. 22 [...]</fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtJustify">Pargrafo nico. [...]</fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtJustify">I - concesso de vantagem, aumento, reajuste ou adequao de remunerao a qualquer ttulo, salvo os derivados de sentena judicial ou de determinao legal ou contratual, ressalvada a reviso prevista no inciso X do artigo 37 da Constituio;</fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtJustify">II - criao de cargo, emprego ou funo;</fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtJustify">III - alterao de estrutura de carreira que implique aumento de despesa;</fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtJustify">IV - provimento de cargo pblico, admisso ou contratao de pessoal a qualquer ttulo, ressalvada a reposio decorrente de aposentadoria ou falecimento de servidores das reas de educao, sade e segurana;</fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtJustify">V - contratao de hora extra, salvo no caso do disposto no inciso II do  6 do artigo 57 da Constituio e as situaes previstas na lei de diretrizes oramentrias.</fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtJustify">Lei de Responsabilidade Fiscal, artigo 23:</fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtJustify">Art. 23 Se a despesa total com pessoal, do Poder ou rgo referido no artigo 20, ultrapassar os limites definidos no mesmo artigo, sem prejuzo das medidas previstas no artigo 22, o percentual excedente ter de ser eliminado nos dois quadrimestres seguintes, sendo pelo menos um tero no primeiro, adotando-se, entre outras, as providncias previstas nos  3 e 4 do artigo 169 da Constituio.</fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   -->
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="txtJustify">Constitui&#231;&#227;o Federal, &#167; 3&#186; e &#167; 4&#186; do Art. 169:</fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="txtJustify">Art. 169 -  [...]</fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="txtJustify">&#167; 3&#186; -  [...]</fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="txtJustify">I - redu&#231;&#227;o em pelo menos vinte por cento das despesas com cargos em comiss&#227;o e fun&#231;&#245;es de confian&#231;a;</fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="txtJustify">II - exonera&#231;&#227;o dos servidores n&#227;o est&#225;veis.</fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="txtJustify">&#167; 4&#186; - Se as medidas adotadas com base no par&#225;grafo anterior n&#227;o forem suficientes para assegurar o cumprimento da determina&#231;&#227;o da lei complementar referida neste artigo, o servidor est&#225;vel poder&#225; perder o cargo, desde que ato normativo motivado de cada um dos Poderes especifique a atividade funcional, o &#243;rg&#227;o ou unidade administrativa objeto da redu&#231;&#227;o de pessoal. [...]</fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <!--
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="txtJustify">Lei de Responsabilidade Fiscal, &#167; 1&#186; e &#167; 2&#186; do Art. 23:</fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="txtJustify">Art. 23 -  [...]</fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="txtJustify">&#167; 1&#186; - No caso do inciso I do &#167; 3&#186; do art. 169 da Constitui&#231;&#227;o, o objetivo poder&#225; ser alcan&#231;ado tanto pela extin&#231;&#227;o de cargos e fun&#231;&#245;es quanto pela redu&#231;&#227;o dos valores a eles atribu&#237;dos. &#185;</fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="txtJustify">&#167; 2&#186; - &#201; facultada a redu&#231;&#227;o tempor&#225;ria da jornada de trabalho com adequa&#231;&#227;o dos vencimentos &#224; nova carga hor&#225;ria.&#178; [...]</fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="3">
	 <fo:block xsl:use-attribute-sets="txtJustify">&#185; A express&#227;o &#180;&#180;quanto pela redu&#231;&#227;o dos valores a eles atribu&#237;dos&#180;&#180; foi suspensa pelo STF (ADIN 2238 em 09-5-2002), visto n&#227;o haver previs&#227;o de redu&#231;&#227;o de vencimentos dos servidores p&#250;blicos no art. 169 da Constitui&#231;&#227;o.</fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="3">
	 <fo:block xsl:use-attribute-sets="txtJustify">&#178; Prerrogativa suspensa na &#237;ntegra pelo STF (ADIN 2238 de 09-5-2002), porque possibilita a redu&#231;&#227;o tempor&#225;ria da jornada de trabalho com adequa&#231;&#227;o de vencimentos.</fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   -->

   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
	 <fo:block xsl:use-attribute-sets="titNegritoBig">Das Restri&#231;&#245;es</fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt" border-width="0.5pt" number-columns-spanned="4"><fo:block><fo:leader leader-pattern="space"/></fo:block></fo:table-cell>
   </fo:table-row>

   <!--
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtJustify">Lei Complementar Federal n 178,  1 do artigo 15:</fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtJustify"> 1 A inobservncia do disposto no caput no prazo fixado sujeita o ente s restries previstas no  3 do art. 23 da Lei Complementar n 101, de 4 de maio de 2000.</fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   -->
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtJustify">Lei de Responsabilidade Fiscal,  3, 4, 5 e 6 do artigo 23:</fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtJustify">Art. 23 - [...]</fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtJustify"> 3 No alcanada a reduo no prazo estabelecido e enquanto perdurar o excesso, o Poder ou rgo referido no art. 20 no poder:</fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtJustify">I - receber transferncias voluntrias;</fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtJustify">II - obter garantia, direta ou indireta, de outro ente;</fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtJustify">III - contratar operaes de crdito, ressalvadas as destinadas ao pagamento da dvida mobiliria e as que visem  reduo das despesas com pessoal.</fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtJustify"> 4 As restries do 3 aplicam-se imediatamente se a despesa total com pessoal exceder o limite no primeiro quadrimestre do ltimo ano do mandato dos titulares de Poder ou rgo referidos no artigo 20.</fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtJustify"> 5 As restries previstas no 3 deste artigo no se aplicam ao Municpio em caso de queda de receita real superior a 10% (dez por cento), em comparao ao correspondente quadrimestre do exerccio financeiro anterior, devido a:</fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtJustify">I - diminuio das transferncias recebidas do Fundo de Participao dos Municpios decorrente de concesso de isenes tributrias pela Unio; e</fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtJustify">II - diminuio das receitas recebidas de royalties e participaes especiais.</fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtJustify"> 6 O disposto no 5 deste artigo s se aplica caso a despesa total com pessoal do quadrimestre vigente no ultrapasse o limite percentual previsto no art. 19 desta Lei Complementar, considerada, para este clculo, a receita corrente lquida do quadrimestre correspondente do ano anterior atualizada monetariamente.</fo:block>
     <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>

   <!--
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="txtJustify">Lei de Responsabilidade Fiscal, &#167; 3&#186; e &#167; 4&#186; do Art. 23:</fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="txtJustify">Art. 23 -  [...]</fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="txtJustify">&#167; 3&#186; N&#227;o alcan&#231;ada a redu&#231;&#227;o no prazo estabelecido, e enquanto perdurar o excesso, o ente n&#227;o poder&#225;:</fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="txtJustify">I - receber transfer&#234;ncias volunt&#225;rias;</fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="txtJustify">II - obter garantia, direta ou indireta, de outro ente;</fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="txtJustify">III - contratar opera&#231;&#245;es de cr&#233;dito, ressalvadas as destinadas ao refinanciamento da d&#237;vida mobili&#225;ria e as que visem &#224; redu&#231;&#227;o das despesas com pessoal.</fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="txtJustify">&#167; 4&#186; As restri&#231;&#245;es do &#167; 3&#186; aplicam-se imediatamente se a despesa total com pessoal exceder o limite no primeiro quadrimestre do &#250;ltimo ano do mandato dos titulares de Poder ou &#243;rg&#227;o referidos no art. 20. [...]</fo:block>
    </fo:table-cell>
   </fo:table-row>
   -->
  </fo:table-body>
 </fo:table>
</xsl:when>
<!-- FIM ALERTA 4 --> 	 

</xsl:choose>
</xsl:template>
<!-- -############## DespesasPessoal  ################-->

<!-- -############## Endividamento  ################-->
<xsl:template name="Endividamento">
<xsl:param name="VALOR"/>
<xsl:choose>
     <!-- SITUA&#199;&#195;O 1-->
<xsl:when test="$VALOR &gt;= 108.005 and $VALOR &lt; 120.005">
 <!-- INICIO ALERTA -->
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="45pt"/>
  <fo:table-column column-number="2" column-width="125pt"/>
  <fo:table-column column-number="3" column-width="320pt"/>
  <fo:table-column column-number="4" column-width="36pt"/>
  
  <fo:table-body>
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt" border-width="0.5pt" number-columns-spanned="4">
     <fo:block font-weight="bold" text-align="center" xsl:use-attribute-sets="titNegritoBig">DO ENDIVIDAMENTO</fo:block>
    </fo:table-cell>
   </fo:table-row>   

   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt" border-width="0.5pt" number-columns-spanned="4"><fo:block><fo:leader leader-pattern="space"/></fo:block></fo:table-cell>
   </fo:table-row>   

   <fo:table-row>
    <fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="txtJustifyMed"><fo:inline font-weight="normal" color="white">__________</fo:inline>O <fo:inline font-weight="bold">&#205;NDICE DE ENDIVIDAMENTO </fo:inline> de <xsl:value-of select="format-number($VALOR , '###.###.##0,00')"></xsl:value-of> % <fo:inline font-weight="bold" font-style="italic" text-decoration="underline">(intervalo de 108,01% a 120,00%)</fo:inline> &#233; superior ao limite para emiss&#227;o do alerta de que trata o Inciso III do &#167; 1&#186; do art. 59 da LRF, de 108,00%, percentual este equivalente a 90,00% sobre o limite de 120,00%, conforme estipulado no Inciso II do &#167; 1&#186; do art. 59 da LRF c/c Inciso II do art. 3&#186; da Resolu&#231;&#227;o do Senado Federal n&#186; 40/2001, respectivamente.</fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>
 <!-- FIM ALERTA -->
	</xsl:when>
	<!-- SITUA&#199;&#195;O 1-->
	
	<!-- SITUA&#199;&#195;O 2-->
<xsl:when test="$VALOR  &gt;= 120.005">
 <!-- INICIO ALERTA -->
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="45pt"/>
  <fo:table-column column-number="2" column-width="125pt"/>
  <fo:table-column column-number="3" column-width="320pt"/>
  <fo:table-column column-number="4" column-width="36pt"/>
  
  <fo:table-body>
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt" border-width="0.5pt" number-columns-spanned="4">
     <fo:block font-weight="bold" text-align="center" xsl:use-attribute-sets="titNegritoBig">DO ENDIVIDAMENTO</fo:block>
    </fo:table-cell>
   </fo:table-row>   

   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt" border-width="0.5pt" number-columns-spanned="4"><fo:block><fo:leader leader-pattern="space"/></fo:block></fo:table-cell>
   </fo:table-row>   

   <fo:table-row>
    <fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="txtJustifyMed"><fo:inline font-weight="normal" color="white">__________</fo:inline>O <fo:inline font-weight="bold">&#205;NDICE DE ENDIVIDAMENTO </fo:inline> de <xsl:value-of select="format-number($VALOR , '###.###.##0,00')"></xsl:value-of> % <fo:inline font-weight="bold" font-style="italic" text-decoration="underline">&#233; superior</fo:inline> ao limite para emiss&#227;o do alerta de que trata o Inciso III do &#167; 1&#186; do art. 59 da LRF, de 108,00%, percentual este equivalente a 90,00% sobre o limite de 120,00%, e ao limite de 120,00% fixado no Inciso II do art. 3&#186; da Resolu&#231;&#227;o n&#186; 40/2001 do Senado Federal, situa&#231;&#227;o que obriga o Poder Executivo/Indiretas Municipais &#224; recondu&#231;&#227;o da d&#237;vida aos limites, mediante a ado&#231;&#227;o de provid&#234;ncias para a elimina&#231;&#227;o do percentual excedente no prazo e  condi&#231;&#245;es estabelecidas no art. 31 da LRF. </fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>
   </fo:table-row>

   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt" border-width="0.5pt" number-columns-spanned="4"><fo:block><fo:leader leader-pattern="space"/></fo:block></fo:table-cell>
   </fo:table-row>   
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="txtJustify">Lei de Responsabilidade Fiscal, Art. 31:</fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="txtJustify">Art. 31. Se a d&#237;vida consolidada de um ente da Federa&#231;&#227;o ultrapassar o respectivo limite ao final de um quadrimestre, dever&#225; ser a ele reconduzida at&#233; o t&#233;rmino dos tr&#234;s subseq&#252;entes, reduzindo o excedente em pelo menos 25,00% (vinte e cinco por cento) no primeiro.</fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   
    <!--<fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="txtJustify">Resolu&#231;&#227;o do Senado Federal N&#186; 20, de 07-11-2003, Incisos I e II do Par&#225;grafo &#218;nico do Art. 1&#186;:</fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>-->
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="txtJustify">Art. 1&#186; - Nos termos do &#167; 4&#186; do art. 66 da Lei Complementar n&#186; 101, de 2000, fica ampliado em 4 (quatro) quadrimestres o prazo estipulado pelo seu art. 31 para o cumprimento dos limites para a d&#237;vida consolidada.</fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="txtJustify">Par&#225;grafo &#218;nico - O disposto no caput ser&#225; implementado da seguinte forma:</fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="txtJustify">I - de 1&#186; de janeiro de 2003 a 30 de abril de 2005, fica suspensa a obrigatoriedade de cumprimento dos limites e condi&#231;&#245;es estabelecidos pelos arts. 3&#186; e 4&#186; da Resolu&#231;&#227;o n&#186; 40, de 2001, do Senado Federal;</fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="txtJustify">II - em 1&#186; de maio de 2005, os Estados, o Distrito Federal e os Munic&#237;pios dever&#227;o estar ajustados aos limites  no art. 3&#186; ou &#224; trajet&#243;ria de redu&#231;&#227;o da d&#237;vida definida no art. 4&#186;, ambos da Resolu&#231;&#227;o n&#186; 40, de 2001, do Senado Federal, conforme o caso. [...]</fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
     <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
	 <fo:block xsl:use-attribute-sets="titNegritoBig">Restri&#231;&#245;es</fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="txtJustify">Lei de Responsabilidade Fiscal, &#167; 1&#186;, &#167; 2&#186; e &#167; 3&#186; do Art. 31:</fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="txtJustify">Art. 31 - [...]</fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="txtJustify">&#167; 1&#186; Enquanto perdurar o excesso, o ente que nele houver incorrido:</fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="txtJustify">I - estar&#225; proibido de realizar opera&#231;&#227;o de cr&#233;dito interna ou externa, inclusive por antecipa&#231;&#227;o de receita, ressalvado o refinanciamento do principal atualizado da d&#237;vida mobili&#225;ria;</fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="txtJustify">II - obter&#225; resultado prim&#225;rio necess&#225;rio &#224; recondu&#231;&#227;o da d&#237;vida ao limite, promovendo, entre outras medidas, limita&#231;&#227;o de empenho, na forma do art. 9&#186;.</fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="txtJustify">&#167; 2&#186; Vencido o prazo para retorno da d&#237;vida ao limite, e enquanto perdurar o excesso, o ente ficar&#225; tamb&#233;m impedido de receber transfer&#234;ncias volunt&#225;rias da Uni&#227;o ou do Estado.</fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="txtJustify">&#167; 3&#186; As restri&#231;&#245;es do &#167; 1&#186; aplicam-se imediatamente se o montante da d&#237;vida exceder o limite no primeiro quadrimestre do &#250;ltimo ano do mandato do Chefe do Poder Executivo. [...]</fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>
 <!-- FIM ALERTA -->
    </xsl:when>
	<!-- SITUA&#199;&#195;O 2-->
</xsl:choose>
</xsl:template>
<!-- -############## Endividamento  ################-->

<!-- -############## Garantias  ################-->
<xsl:template name="Garantias">
<xsl:param name="VALOR"/>
<xsl:choose>

 <!-- INICIO ALERTA -->
 <xsl:when test="Modelo9/Modelos/Modelo5/Pergunta/PerguntaRow/RESPOSTA = 'S'
				or (Modelo9/Modelos/Modelo4/Modelo4Row/VALOR) div ($valorRclEndividamento) * 100 &gt; 120.005	
				or (Modelo9/Modelos/Modelo2/Modelo2Row/VALOR) div ($valorRclAjustada) * 100 &gt; 54.005">
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="45pt"/>
  <fo:table-column column-number="2" column-width="125pt"/>
  <fo:table-column column-number="3" column-width="320pt"/>
  <fo:table-column column-number="4" column-width="36pt"/>
  
  <fo:table-body>
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt" border-width="0.5pt" number-columns-spanned="4">
     <fo:block font-weight="bold" text-align="center" xsl:use-attribute-sets="titNegritoBig">GARANTIAS DE VALORES</fo:block>
    </fo:table-cell>
   </fo:table-row>   

   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt" border-width="0.5pt" number-columns-spanned="4"><fo:block><fo:leader leader-pattern="space"/></fo:block></fo:table-cell>
   </fo:table-row>   

   <fo:table-row>
    <fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="txtJustifyMed"><fo:inline font-weight="normal" color="white">__________</fo:inline>O <fo:inline font-weight="bold">&#205;NDICE DE GARANTIAS</fo:inline> de <xsl:value-of select="format-number($VALOR , '###.###.##0,00')"></xsl:value-of> %, concedidas pelo Munic&#237;pio, <fo:inline font-weight="bold" font-style="italic" text-decoration="underline">&#233; superior</fo:inline> ao limite para emiss&#227;o do alerta de que trata o Inciso III do &#167; 1&#186; do art. 59 da LRF, de 19,80%, percentual este equivalente a 90,00% sobre o limite de 22,00%, conforme estipulado no art. 9&#186; da Resolu&#231;&#227;o n&#186; 43/2001 do Senado Federal.</fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>
   </fo:table-row>

   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt" border-width="0.5pt" number-columns-spanned="4"><fo:block><fo:leader leader-pattern="space"/></fo:block></fo:table-cell>
   </fo:table-row>   
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="txtJustify">Resolu&#231;&#227;o n&#186; 43/2001 do Senado Federal, Art. 9&#186;:</fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="txtJustify">Art. 9&#186; - O saldo global das garantias concedidas pelos Estados, pelo Distrito Federal e pelos Munic&#237;pios n&#227;o poder&#225; exceder a 22,00% (vinte e dois por cento) da receita corrente l&#237;quida, calculada na forma do art. 4&#186;. [...]</fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>
</xsl:when>
<!-- FIM ALERTA 1-->

<!-- INICIO ALERTA 2-->
<xsl:otherwise>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="45pt"/>
  <fo:table-column column-number="2" column-width="125pt"/>
  <fo:table-column column-number="3" column-width="320pt"/>
  <fo:table-column column-number="4" column-width="36pt"/>
  
  <fo:table-body>
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt" border-width="0.5pt" number-columns-spanned="4">
     <fo:block font-weight="bold" text-align="center" xsl:use-attribute-sets="titNegritoBig">GARANTIAS DE VALORES</fo:block>
    </fo:table-cell>
   </fo:table-row>   

   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt" border-width="0.5pt" number-columns-spanned="4"><fo:block><fo:leader leader-pattern="space"/></fo:block></fo:table-cell>
   </fo:table-row>   
   
   <fo:table-row>
    <fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="txtJustifyMed"><fo:inline font-weight="normal" color="white">__________</fo:inline>O <fo:inline font-weight="bold">&#205;NDICE DE GARANTIAS</fo:inline> de <xsl:value-of select="format-number($VALOR , '###.###.##0,00')"></xsl:value-of> %, concedidas pelo Munic&#237;pio, <fo:inline font-weight="bold" font-style="italic" text-decoration="underline">&#233; superior</fo:inline> ao limite para emiss&#227;o do alerta de que trata o Inciso III do &#167; 1&#186; do art. 59 da LRF, de 28,80%, percentual este equivalente a 90,00% sobre o limite de 32,00%, conforme estipulado no par&#225;grafo &#250;nico do art. 9&#186; da Resolu&#231;&#227;o n&#186; 43/2001 do Senado Federal.</fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>
   </fo:table-row>

   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt" border-width="0.5pt" number-columns-spanned="4"><fo:block><fo:leader leader-pattern="space"/></fo:block></fo:table-cell>
   </fo:table-row>   
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="txtJustify">Resolu&#231;&#227;o n&#186; 43/2001 do Senado Federal, Incisos I a IV do Art. 9&#186;:</fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="txtJustify">Art. 9&#186; - [...]</fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="txtJustify">Par&#225;grafo &#250;nico. O limite de que trata o caput poder&#225; ser elevado para 32,00% (trinta e dois por cento) da receita corrente l&#237;quida, desde que, cumulativamente, quando aplic&#225;vel, o garantidor: </fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="txtJustify">I - n&#227;o tenha sido chamado a honrar, nos &#250;ltimos 24 (vinte e quatro) meses, a contar do m&#234;s da an&#225;lise, quaisquer garantias anteriormente prestadas; </fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="txtJustify">II - esteja cumprindo o limite da d&#237;vida consolidada l&#237;quida, definido na Resolu&#231;&#227;o n&#186; 40, de 2001, do Senado Federal; </fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="txtJustify">III - esteja cumprindo os limites de despesa com pessoal previstos na Lei complementar n&#186; 101, de 2000; </fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="txtJustify">IV - esteja cumprindo o Programa de Ajuste Fiscal acordado com a Uni&#227;o, nos termos da Lei n&#186; 9.496, de 1997.</fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>
 <!-- FIM ALERTA -->
        <!-- SITUCA&#199;&#195;O 2 -->
	</xsl:otherwise>
  </xsl:choose>
</xsl:template>
<!-- -##############   ################-->

<!-- -############## CreditoInterna  ################-->
<xsl:template name="CreditoInterna">
<xsl:param name="VALOR"/>
<xsl:choose>
 <xsl:when test="$VALOR &gt;= 14.405">
 <!-- INICIO ALERTA -->
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="45pt"/>
  <fo:table-column column-number="2" column-width="125pt"/>
  <fo:table-column column-number="3" column-width="320pt"/>
  <fo:table-column column-number="4" column-width="36pt"/>
  
  <fo:table-body>
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt" border-width="0.5pt" number-columns-spanned="4">
     <fo:block font-weight="bold" text-align="center" xsl:use-attribute-sets="titNegritoBig">OPERA&#199;&#213;ES DE CR&#201;DITO INTERNAS E EXTERNAS</fo:block>
    </fo:table-cell>
   </fo:table-row>   

   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt" border-width="0.5pt" number-columns-spanned="4"><fo:block><fo:leader leader-pattern="space"/></fo:block></fo:table-cell>
   </fo:table-row>   
   
   <fo:table-row>
    <fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="titMed"><fo:inline font-weight="normal" color="white">__________</fo:inline>O <fo:inline font-weight="bold">&#205;NDICE DE OPERA&#199;&#213;ES DE CR&#201;DITO INTERNAS E EXTERNAS </fo:inline> de <xsl:value-of select="format-number($VALOR , '###.###.##0,00')"></xsl:value-of> % <fo:inline font-weight="bold" font-style="italic" text-decoration="underline">&#233; superior</fo:inline> ao limite para emiss&#227;o do alerta de que trata o Inciso III do &#167; 1&#186; do art. 59 da LRF, de 14,40%, percentual este equivalente a 90,00% sobre o limite de 16,00%, conforme estipulado no Inciso I do art. 7&#186; da Resolu&#231;&#227;o do Senado Federal n&#186; 43/2001.</fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>
   </fo:table-row>

   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt" border-width="0.5pt" number-columns-spanned="4"><fo:block><fo:leader leader-pattern="space"/></fo:block></fo:table-cell>
   </fo:table-row>   
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="txtJustify">Resolu&#231;&#227;o do Senado Federal n&#186; 43/2001, Inciso I do Art. 7&#186;:</fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="txtJustify">Art. 7&#186; As opera&#231;&#245;es de cr&#233;dito interno e externo dos Estados, do Distrito Federal, dos Munic&#237;pios observar&#227;o, ainda, os seguintes limites: </fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="txtJustify">I - o montante global das opera&#231;&#245;es realizadas em um exerc&#237;cio financeiro n&#227;o poder&#225; ser superior a 16,00% (dezesseis por cento) da receita corrente l&#237;quida, definida no art. 4&#186;;  [...]</fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>
 <!-- FIM ALERTA -->
	</xsl:when>
  </xsl:choose>
</xsl:template>
<!-- -############## CreditoInterna  ################-->

<!-- -############## CreditoAntecipacao  ################-->
<xsl:template name="CreditoAntecipacao">

<xsl:param name="VALOR"/>
<xsl:choose>
	<xsl:when test="$VALOR &gt;= 6.305">
 <!-- INICIO ALERTA-->
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="45pt"/>
  <fo:table-column column-number="2" column-width="125pt"/>
  <fo:table-column column-number="3" column-width="320pt"/>
  <fo:table-column column-number="4" column-width="36pt"/>
  
  <fo:table-body>
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt" border-width="0.5pt" number-columns-spanned="4">
     <fo:block font-weight="bold" text-align="center" xsl:use-attribute-sets="titNegritoBig">OPERA&#199;&#213;ES DE CR&#201;DITO POR ANTECIPA&#199;&#195;O DE RECEITA  OR&#199;AMENT&#193;RIA - ARO </fo:block>
    </fo:table-cell>
   </fo:table-row>   

   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt" border-width="0.5pt" number-columns-spanned="4"><fo:block><fo:leader leader-pattern="space"/></fo:block></fo:table-cell>
   </fo:table-row>   

   <fo:table-row>
    <fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="txtJustifyMed"><fo:inline font-weight="normal" color="white">__________</fo:inline>O <fo:inline font-weight="bold">&#205;NDICE DE OPERA&#199;&#213;ES DE CR&#201;DITO POR ANTECIPA&#199;&#195;O DE RECEITA </fo:inline><fo:inline font-weight="bold">OR&#199;AMENT&#193;RIA - ARO</fo:inline> de <xsl:value-of select="format-number($VALOR , '###.###.##0,00')"></xsl:value-of>% <fo:inline font-weight="bold" font-style="italic" text-decoration="underline">&#233; superior</fo:inline> ao limite para emiss&#227;o do alerta de que trata o Inciso III do &#167; 1&#186; do Art. 59 da LRF, de 6,30%, percentual este equivalente a 90,00% sobre o limite de 7,00%, conforme estipulado no art. 10 da Resolu&#231;&#227;o do Senado Federal n&#186; 43/2001.</fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>
   </fo:table-row>

   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt" border-width="0.5pt" number-columns-spanned="4"><fo:block><fo:leader leader-pattern="space"/></fo:block></fo:table-cell>
   </fo:table-row>   
   <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="txtJustify">Resolu&#231;&#227;o do Senado Federal n&#186; 43/2001, Art. 10:</fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
      <fo:table-row>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="1">
	 <fo:block xsl:use-attribute-sets="txtJustify">Art. 10 -  O saldo devedor das opera&#231;&#245;es de cr&#233;dito por antecipa&#231;&#227;o de receita or&#231;ament&#225;ria n&#227;o poder&#225; exceder, no exerc&#237;cio em que estiver sendo apurado, a 7,00% (sete por cento) da receita corrente l&#237;quida, definida no art. 4&#186;, observado o disposto nos arts. 14 e 15.</fo:block>
	 <fo:block xsl:use-attribute-sets="txtLeft"><fo:leader leader-pattern="space"/></fo:block>
    </fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>
 <!-- FIM ALERTA -->
</xsl:when>
</xsl:choose>
</xsl:template>
<!-- -############## CreditoAntecipacao  ################-->

<!-- -############## ALERTAS FINAIS ################-->
<xsl:template name="Ciencia">
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <!-- INICIO ALERTA Ciencia 1 -->
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="45pt"/>
  <fo:table-column column-number="2" column-width="125pt"/>
  <fo:table-column column-number="3" column-width="320pt"/>
  <fo:table-column column-number="4" column-width="36pt"/>
    
  <fo:table-body>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="txtJustifyMed"><fo:inline font-weight="normal" color="white">__________</fo:inline>Considerando a(s) ocorr&#234;ncia(s) prevista(s) no(s) inciso(s) II e/ou III do &#167; 1&#186; do  art. 59 da Lei Complementar n&#186; 101, de 04 de maio de 2000 (LRF), os montantes da despesa total com pessoal, e/ou a d&#237;vida consolidada l&#237;quida, e/ou as garantias de valores e opera&#231;&#245;es de cr&#233;dito se encontra(m) acima de 90,00% dos limites legais.</fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>
 <!-- FIM ALERTA Ciencia 1 -->

 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>

 <!-- INICIO ALERTA Ciencia 2 -->
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="45pt"/>
  <fo:table-column column-number="2" column-width="125pt"/>
  <fo:table-column column-number="3" column-width="320pt"/>
  <fo:table-column column-number="4" column-width="36pt"/>
    
  <fo:table-body>
   <fo:table-row>
    <fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2">
     <fo:block xsl:use-attribute-sets="txtJustifyMed"><fo:inline font-weight="normal" color="white">__________</fo:inline>Assim, considerando as compet&#234;ncias estabelecidas no &#167; 1&#186; do art. 59 da Lei Complementar n&#186; 101, de 04 de maio de 2000 (LRF) e o disposto no inciso XI do art. 48, do Regimento Interno do Tribunal de Contas do Estado - RITCE, esta Corte emite o presente <fo:inline font-weight="bold">ALERTA</fo:inline>.</fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>
 <!-- FIM ALERTA Ciencia 2-->

 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
  <!-- INICIO ALERTA Ciencia 22-->
 <fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
  <fo:table-column column-number="1" column-width="45pt"/>
  <fo:table-column column-number="2" column-width="55pt"/>
  <fo:table-column column-number="3" column-width="390pt"/>
  <fo:table-column column-number="4" column-width="36pt"/>

  <fo:table-body>
   <fo:table-row border-width="0.5pt">
    <fo:table-cell padding="2pt" border-width="0.5pt" number-columns-spanned="4">
     <fo:block font-weight="bold" text-align="center" xsl:use-attribute-sets="titNegritoBig">DA CI&#202;NCIA </fo:block>
    </fo:table-cell>
   </fo:table-row>  

   <fo:table-row>
    <fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>
    <fo:table-cell border-width="0.5pt" number-columns-spanned="2">
    	<fo:block xsl:use-attribute-sets="txtJustifyMed"><fo:inline font-weight="normal" color="white">__________</fo:inline>EU, PREFEITO MUNICIPAL, com base no(s) &#237;ndice(s) acima demonstrado(s), considero-me cientificado do referido alerta.</fo:block>
    </fo:table-cell>
	<fo:table-cell border-width="0.5pt"><fo:block></fo:block></fo:table-cell>
   </fo:table-row>
  </fo:table-body>
 </fo:table>
  <!-- FIM ALERTA Ciencia 3-->
</xsl:template>
<!-- -############## ALERTAS FINAIS ################-->

<xsl:template match="Informacoes">
 <fo:block><fo:leader leader-pattern="space"/></fo:block>
 <fo:block><fo:leader leader-pattern="space"/></fo:block>

<!--<fo:block xsl:use-attribute-sets="txtCenter"><xsl:value-of select="InformacoesRow/DATA_EX"/></fo:block>-->
<fo:block xsl:use-attribute-sets="txtCenter">
	<xsl:value-of select="InformacoesRow/DATA_EX"/>
</fo:block>
<fo:leader leader-pattern="space" />
<fo:leader leader-pattern="space" />
<fo:block xsl:use-attribute-sets="txtCenter">_________________________________________________</fo:block>
<fo:block xsl:use-attribute-sets="txtCenter"><xsl:value-of select="InformacoesRow/NOME_REPRESENTANTE"/></fo:block>
<fo:block xsl:use-attribute-sets="txtCenter">Prefeito Municipal</fo:block>

<fo:leader leader-pattern="space" />
<fo:leader leader-pattern="space" />
<fo:block xsl:use-attribute-sets="txtCenter">_________________________________________________</fo:block>
<fo:block xsl:use-attribute-sets="txtCenter"><xsl:value-of select="InformacoesRow/RESP_ADMIN_FINAN"/></fo:block>
<fo:block xsl:use-attribute-sets="txtCenter">Respons&#225;vel pela Administra&#231;&#227;o Financeira</fo:block>

<fo:leader leader-pattern="space" />
<fo:leader leader-pattern="space" />
<fo:block xsl:use-attribute-sets="txtCenter">_________________________________________________</fo:block>
<fo:block xsl:use-attribute-sets="txtCenter"><xsl:value-of select="InformacoesRow/RESP_CTRL_INTERNO"/></fo:block>
<fo:block xsl:use-attribute-sets="txtCenter">Respons&#225;vel pelo Controle Interno</fo:block>
</xsl:template>

<!--
#############################################
#### ManifestacaoConclusiva
############################################# 
-->
<xsl:template match="ManifestacaoConclusiva">
	<fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
		<fo:table-column column-number="1" />
		<fo:table-body>
			<fo:table-row>
				<fo:table-cell>
					<fo:block xsl:use-attribute-sets="titFCinza">
						<xsl:text>Manifesta&#231;&#227;o Conclusiva do Controle Interno - Poder Executivo</xsl:text>
					</fo:block>
				</fo:table-cell>
			</fo:table-row>
		</fo:table-body>
	</fo:table>
	
	<fo:block><fo:leader leader-pattern="space"/></fo:block>
	
	<fo:table width="556pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
		<fo:table-column column-number="1" column-width="556pt"/>
		
		<fo:table-body >	
			<xsl:for-each select="ManifestacaoConclusivaRow">	
				<fo:table-row>								
					<fo:table-cell>
						<fo:block xsl:use-attribute-sets="txtLeft" text-align="justify" margin-left="15pt" hyphenate="true" >
							<xsl:value-of select="TEXTO"/>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>   	
			</xsl:for-each>	 	
		</fo:table-body>
	</fo:table>	
</xsl:template>
<!-- #### FIM - ManifestacaoConclusiva ####-->	
	
</xsl:stylesheet>
