<?xml version='1.0' encoding='ISO-8859-1'?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:barcode="org.krysalis.barcode4j.xalan.BarcodeExt" xmlns:java="http://xml.apache.org/xslt/java"
	exclude-result-prefixes="java" extension-element-prefixes="barcode"
	xmlns:cal="xalan://java.util.GregorianCalendar"
	xmlns:exslt="http://exslt.org/common">

	<xsl:output method="xml" encoding="ISO-8859-1" indent="yes" />

	<xsl:decimal-format decimal-separator="," grouping-separator="." />

	<!-- Variveis de ambiente de execuo -->
	<xsl:param name="PATH_IMAGENS" select="'imagens/'" />
	<xsl:param name="PATH_REMESSA" select="'remessa/'" />

	<xsl:variable name="pageWidthInternal" select="'784pt'" />

	<!-- ######### Styles para os textos do documento ######### -->
	<xsl:attribute-set name="bordas">
		<xsl:attribute name="border-after-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-after-style">solid</xsl:attribute>
		<xsl:attribute name="border-before-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-before-style">solid</xsl:attribute>
		<xsl:attribute name="border-left-width">0pt</xsl:attribute>
		<xsl:attribute name="border-left-style">solid</xsl:attribute>
		<xsl:attribute name="border-right-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-right-style">solid</xsl:attribute>

		<xsl:attribute name="border-start-width">1pt</xsl:attribute>
		<xsl:attribute name="border-start-style">solid</xsl:attribute>
		<xsl:attribute name="border-end-width">1pt</xsl:attribute>
		<xsl:attribute name="border-end-style">solid</xsl:attribute>
		<!-- xsl:attribute name="border-top-width">1pt</xsl:attribute> <xsl:attribute 
			name="border-top-style">solid</xsl:attribute> <xsl:attribute name="border-bottom-width">1pt</xsl:attribute> 
			<xsl:attribute name="border-bottom-style">solid</xsl:attribute -->
	</xsl:attribute-set>

	<xsl:attribute-set name="bordasLR">
		<xsl:attribute name="border-left-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-left-style">solid</xsl:attribute>
		<xsl:attribute name="border-right-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-right-style">solid</xsl:attribute>
		<xsl:attribute name="border-collapse">collapse</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="bordasL">
		<xsl:attribute name="border-left-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-left-style">solid</xsl:attribute>
		<xsl:attribute name="border-collapse">collapse</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="bordasR">
		<xsl:attribute name="border-right-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-right-style">solid</xsl:attribute>
		<xsl:attribute name="border-collapse">collapse</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="bordasB">
		<xsl:attribute name="border-bottom-width">1pt</xsl:attribute>
		<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
		<xsl:attribute name="border-collapse">collapse</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="bordasTB">
		<xsl:attribute name="border-top-width">1pt</xsl:attribute>
		<xsl:attribute name="border-top-style">solid</xsl:attribute>
		<xsl:attribute name="border-bottom-width">1pt</xsl:attribute>
		<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
		<xsl:attribute name="border-collapse">collapse</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="bordasAll">
		<xsl:attribute name="border-left-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-left-style">solid</xsl:attribute>
		<xsl:attribute name="border-right-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-right-style">solid</xsl:attribute>
		<xsl:attribute name="border-top-width">1pt</xsl:attribute>
		<xsl:attribute name="border-top-style">solid</xsl:attribute>
		<xsl:attribute name="border-bottom-width">1pt</xsl:attribute>
		<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
		<xsl:attribute name="border-collapse">collapse</xsl:attribute>
	</xsl:attribute-set>

	<!-- xsl:attribute-set name="bordasTableHeader">
		<xsl:attribute name="background-color">#EEEEEE</xsl:attribute>
		<xsl:attribute name="border-after-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-after-style">solid</xsl:attribute>
		<xsl:attribute name="border-before-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-before-style">solid</xsl:attribute>
		<xsl:attribute name="border-left-width">0pt</xsl:attribute>
		<xsl:attribute name="border-left-style">solid</xsl:attribute>
		<xsl:attribute name="border-right-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-right-style">solid</xsl:attribute>
	</xsl:attribute-set-->

	<!-- xsl:attribute-set name="bordas2">
		<xsl:attribute name="border-after-width">0pt</xsl:attribute>
		<xsl:attribute name="border-after-style">solid</xsl:attribute>
		<xsl:attribute name="border-before-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-before-style">solid</xsl:attribute>
		<xsl:attribute name="border-left-width">0pt</xsl:attribute>
		<xsl:attribute name="border-left-style">solid</xsl:attribute>
		<xsl:attribute name="border-right-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-right-style">solid</xsl:attribute>
		<xsl:attribute name="border-start-width">1pt</xsl:attribute>
		<xsl:attribute name="border-start-style">solid</xsl:attribute>
		<xsl:attribute name="border-end-width">1pt</xsl:attribute>
		<xsl:attribute name="border-end-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="bordas3">
		<xsl:attribute name="border-after-width">0pt</xsl:attribute>
		<xsl:attribute name="border-after-style">solid</xsl:attribute>
		<xsl:attribute name="border-before-width">0pt</xsl:attribute>
		<xsl:attribute name="border-before-style">solid</xsl:attribute>
		<xsl:attribute name="border-left-width">0pt</xsl:attribute>
		<xsl:attribute name="border-left-style">solid</xsl:attribute>
		<xsl:attribute name="border-right-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-right-style">solid</xsl:attribute>
		<xsl:attribute name="border-start-width">1pt</xsl:attribute>
		<xsl:attribute name="border-start-style">solid</xsl:attribute>
		<xsl:attribute name="border-end-width">1pt</xsl:attribute>
		<xsl:attribute name="border-end-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="bordasUltColuna">
		<xsl:attribute name="border-after-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-after-style">solid</xsl:attribute>
		<xsl:attribute name="border-before-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-before-style">solid</xsl:attribute>
		<xsl:attribute name="border-left-width">0pt</xsl:attribute>
		<xsl:attribute name="border-left-style">solid</xsl:attribute>
		<xsl:attribute name="border-right-width">0pt</xsl:attribute>
		<xsl:attribute name="border-right-style">solid</xsl:attribute>
	</xsl:attribute-set>


	<xsl:attribute-set name="bordasDireita1pt">
		<xsl:attribute name="border-after-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-after-style">solid</xsl:attribute>
		<xsl:attribute name="border-before-width">0.5pt</xsl:attribute>
		<xsl:attribute name="border-before-style">solid</xsl:attribute>
		<xsl:attribute name="border-left-width">0pt</xsl:attribute>
		<xsl:attribute name="border-left-style">solid</xsl:attribute>
		<xsl:attribute name="border-right-width">1pt</xsl:attribute>
		<xsl:attribute name="border-right-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cabecalhoLeftCourier">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">Courier, monospace</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="background-color">white</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cabecalhoRightCourier">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">Courier, monospace</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="background-color">white</xsl:attribute>
		<xsl:attribute name="text-align">right</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cabecalhoLeft">
		<xsl:attribute name="font-size">9.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif, monospace</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="background-color">white</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cabecalhoRight">
		<xsl:attribute name="font-size">9.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif, monospace</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="background-color">white</xsl:attribute>
		<xsl:attribute name="text-align">right</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set-->

	<xsl:attribute-set name="titFCinza">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
		<xsl:attribute name="border-bottom-width">1.0pt</xsl:attribute>
		<xsl:attribute name="background-color">#EEEEEE</xsl:attribute>
		<!-- xsl:attribute name="space-after">1mm</xsl:attribute -->
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<!-- xsl:attribute-set name="titFCinzaEscuro">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
		<xsl:attribute name="border-bottom-width">1.0pt</xsl:attribute>
		<xsl:attribute name="background-color">silver</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="titNegrito">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="text-align">center</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set-->

	<xsl:attribute-set name="titNegritoLeft">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
		<xsl:attribute name="vertical-align">middle</xsl:attribute>
	</xsl:attribute-set>

	<!-- xsl:attribute-set name="titNegritoRight">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="text-align">right</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
		<xsl:attribute name="vertical-align">middle</xsl:attribute>
	</xsl:attribute-set-->

	<xsl:attribute-set name="titNegritoBig">
		<xsl:attribute name="font-size">16.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="text-align">center</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<!-- xsl:attribute-set name="titNegritoMed">
		<xsl:attribute name="font-size">10.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="titMed">
		<xsl:attribute name="font-size">10.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="titNegritoItalico">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
		<xsl:attribute name="border-bottom-width">1.0pt</xsl:attribute>
		<xsl:attribute name="background-color">silver</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="total">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="background-color">white</xsl:attribute>
		<xsl:attribute name="text-align">right</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="totalLeft">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="background-color">white</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cabecalho">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="background-color">white</xsl:attribute>
		<xsl:attribute name="text-align">right</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cabecalhoCenter">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="background-color">white</xsl:attribute>
		<xsl:attribute name="text-align">center</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set-->

	<xsl:attribute-set name="txtLeft">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<!-- <xsl:attribute name="space-after">1mm</xsl:attribute> -->
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="txtLeftBold">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<!-- xsl:attribute-set name="txtLeftShort">
		<xsl:attribute name="font-size">7.4pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="txtLeftShort2">
		<xsl:attribute name="font-size">7.2pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="txtLeftBig">
		<xsl:attribute name="font-size">12.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="txtLeftBigCur">
		<xsl:attribute name="font-size">12.0pt</xsl:attribute>
		<xsl:attribute name="font-family">Courier, monospace</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set-->

	<xsl:attribute-set name="txtCenter">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="text-align">center</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<!-- xsl:attribute-set name="txtCenterBig">
		<xsl:attribute name="font-size">12.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="text-align">center</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set-->

	<xsl:attribute-set name="txtRight">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="text-align">right</xsl:attribute>
		<!-- xsl:attribute name="space-after">1mm</xsl:attribute -->
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<!-- xsl:attribute-set name="txtRightShort">
		<xsl:attribute name="font-size">7.4pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="text-align">right</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="txtRightBig">
		<xsl:attribute name="font-size">12.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="text-align">right</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="linhaTotal">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="background-color">white</xsl:attribute>
		<xsl:attribute name="text-align">right</xsl:attribute>
		<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
		<xsl:attribute name="border-bottom-width">1.0pt</xsl:attribute>
		<xsl:attribute name="border-top-style">solid</xsl:attribute>
		<xsl:attribute name="border-top-width">1.0pt</xsl:attribute>
		<xsl:attribute name="space-after">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="txtQuadroTce">
		<xsl:attribute name="font-size">7.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">normal</xsl:attribute>
		<xsl:attribute name="space-before">0pt</xsl:attribute>
		<xsl:attribute name="space-after">0pt</xsl:attribute>
		<xsl:attribute name="padding-top">1pt</xsl:attribute>
		<xsl:attribute name="padding-bottom">1pt</xsl:attribute>
	</xsl:attribute-set-->

	<xsl:attribute-set name="titTabelaHeader">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="text-align">center</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
		<xsl:attribute name="padding-bottom">2pt</xsl:attribute>
		<xsl:attribute name="vertical-align">middle</xsl:attribute>
		<!-- xsl:attribute name="background-color">#EEEEEE</xsl:attribute-->
	</xsl:attribute-set>

	<xsl:attribute-set name="titTabelaHeaderLeft">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
		<xsl:attribute name="padding-bottom">2pt</xsl:attribute>
		<xsl:attribute name="vertical-align">middle</xsl:attribute>
		<!-- <xsl:attribute name="background-color">#EEEEEE</xsl:attribute> -->
	</xsl:attribute-set>

	<xsl:attribute-set name="titTabelaHeaderRight">
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="text-align">right</xsl:attribute>
		<xsl:attribute name="padding-top">2pt</xsl:attribute>
		<xsl:attribute name="padding-bottom">2pt</xsl:attribute>
		<xsl:attribute name="vertical-align">middle</xsl:attribute>
		<!-- <xsl:attribute name="background-color">#EEEEEE</xsl:attribute> -->
	</xsl:attribute-set>

	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<!-- ******* Define a configurao da pgina (Folha) ******* -->
				<fo:simple-page-master master-name="default-master"
					page-height="21cm" page-width="29.6cm" margin-top="15pt"
					margin-left="20pt" margin-right="35pt" margin-bottom="15pt">

					<!-- ******* Parte central da pgina (Margens) ******* -->
					<fo:region-body column-count="1" margin-top="1.30in"
						margin-bottom="0.5in" />

					<!-- ******* Cabealho (Margens) ******* -->
					<fo:region-before border-after-style="solid"
						extent="1.30in" margin-bottom="0.2in" />

					<!-- ******* Rodap (Margens) ******* -->
					<fo:region-after border-before-style="solid"
						extent="0.2in" margin-bottom="0.2in" />
				</fo:simple-page-master>
			</fo:layout-master-set>

			<!-- Body page -->
			<!-- ******* Corpo da pgina (Contedo) ******* -->
			<fo:page-sequence master-reference="default-master">

				<!-- ******* Definindo o contedo do cabealho ******* -->
				<fo:static-content flow-name="xsl-region-before">
					<xsl:apply-templates select="dc-balpat/Cabecalho" />
				</fo:static-content>

				<!-- ******* Definindo o contedo do rodap ******* -->
				<fo:static-content flow-name="xsl-region-after">

					<!-- ******* Variveis locais ******* -->
					<!-- variveis para obter a data e hora atual -->
					<xsl:variable name="timeZone1"
						select="java:java.util.TimeZone.getTimeZone('America/Sao_Paulo')" />
					<xsl:variable name="tmp" select="cal:new()" />
					<xsl:variable name="tmp2" select="cal:setTimeZone($tmp,$timeZone1)" />
					<!-- ******* ******* -->

					<fo:table text-align="center" table-layout="fixed">
						<xsl:attribute name="width"><xsl:value-of select="$pageWidthInternal"/></xsl:attribute>
						<fo:table-column column-width="162pt" />
						<fo:table-column column-width="178pt" />
						<fo:table-column column-width="162pt" />

						<fo:table-body>
							<fo:table-row>
								<fo:table-cell number-columns-spanned="3" border-bottom-style="solid" border-bottom-width="1pt">
									<fo:block />
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="txtLeft">
										<xsl:value-of select="java:format(java:java.text.SimpleDateFormat.new('dd/MM/yyyy'), java:java.util.Date.new())" />
									</fo:block>
								</fo:table-cell>
								<fo:table-cell padding-left="10pt">
									<fo:block xsl:use-attribute-sets="txtCenter">
										P&#225;gina <fo:page-number />
										de <fo:page-number-citation ref-id="last-page" />
									</fo:block>
								</fo:table-cell>

								<xsl:variable name="timeZone1" select="java:java.util.TimeZone.getTimeZone('America/Sao_Paulo')" />
								<xsl:variable name="tmp" select="cal:new()" />
								<xsl:variable name="tmp2" select="cal:setTimeZone($tmp,$timeZone1)" />

								<fo:table-cell>
									<fo:block xsl:use-attribute-sets="txtRight">
										<xsl:value-of select="java:format(java:java.text.SimpleDateFormat.new('HH:mm:ss'), cal:getTime())" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:static-content>

				<xsl:variable name="temRPPS" select="sum(dc-balpat/ContasAtivo/ContasAtivoRow/VL_SALDO_RPPS) + sum(dc-balpat/ContasPassivo/ContasPassivoRow/VL_SALDO_RPPS) > 0" />

				<!-- ******* Definindo o contedo do corpo da pgina ******* -->
				<fo:flow flow-name="xsl-region-body">
					<fo:block font-size="7.0pt" font-family="serif">

						<!--xxxxxxxxxxx BLOCO PRINCIPAL xxxxxxxxxxxxx -->
						
						<!-- <fo:block xsl:use-attribute-sets="titNegritoLeft">Este Demonstrativo est em fase de testes. Em caso de discordncia, apontar em Notas Explicativas.</fo:block>
						<fo:block><fo:leader leader-pattern="space"/></fo:block> -->

						<fo:block xsl:use-attribute-sets="titFCinza" id="BP_a_0">a. Quadro Principal</fo:block>
						<fo:block><fo:leader leader-pattern="space" /></fo:block>
						<xsl:call-template name="Balanco"/>
						
						<!-- QUEBRA DE PAGINA -->
						<fo:block break-after="page"/>
						
						<fo:block xsl:use-attribute-sets="titFCinza" id="BP_b_0">b. Quadro dos Ativos e Passivos Financeiros e Permanentes</fo:block>
						<fo:block><fo:leader leader-pattern="space" /></fo:block>
						<xsl:call-template name="QuadroTotais"/>

						<fo:block><fo:leader leader-pattern="space" /></fo:block>
						<fo:block><fo:leader leader-pattern="space" /></fo:block>
						<fo:block xsl:use-attribute-sets="titFCinza" id="BP_c_0">c. Quadro das Contas de Compensaes</fo:block>
						<fo:block><fo:leader leader-pattern="space"/></fo:block>
						<xsl:call-template name="Compensacoes"/>
						
						<fo:block><fo:leader leader-pattern="space" /></fo:block>
						<fo:block><fo:leader leader-pattern="space" /></fo:block>
						<fo:block xsl:use-attribute-sets="titFCinza" id="BP_d_0">d. Quadro do Supervit/Dficit Financeiro</fo:block>
						<fo:block><fo:leader leader-pattern="space"/></fo:block>
						<xsl:apply-templates select="dc-balpat/SaldosPorRecurso">
							<xsl:with-param name="elementos" select="dc-balpat/SaldosPorRecurso/SaldosPorRecursoRow"/>
						</xsl:apply-templates>
						
						<xsl:if test="$temRPPS">
							<fo:block break-after="page"/>
							<fo:block xsl:use-attribute-sets="titFCinza" id="BP_a_1">a.1 Quadro Principal - Prefeitura</fo:block>
							<fo:block><fo:leader leader-pattern="space" /></fo:block>
							<xsl:call-template name="Balanco">
								<xsl:with-param name="ELEM_SALDO" select="'VL_SALDO_PRINCIPAL'"/>
							</xsl:call-template>
							
							<fo:block break-after="page"/>
							<!-- <fo:block><fo:leader leader-pattern="space" /></fo:block>
							<fo:block><fo:leader leader-pattern="space" /></fo:block> -->
							<fo:block xsl:use-attribute-sets="titFCinza" id="BP_b_1">b.1 Quadro dos Ativos e Passivos Financeiros e Permanentes - Prefeitura</fo:block>
							<fo:block><fo:leader leader-pattern="space" /></fo:block>
							<xsl:call-template name="QuadroTotais">
								<xsl:with-param name="ELEM_SALDO" select="'VL_SALDO_PRINCIPAL'"/>
							</xsl:call-template>
							
							<fo:block><fo:leader leader-pattern="space" /></fo:block>
							<fo:block><fo:leader leader-pattern="space" /></fo:block>
							<fo:block xsl:use-attribute-sets="titFCinza" id="BP_c_1">c.1 Quadro das Contas de Compensaes - Prefeitura</fo:block>
							<fo:block><fo:leader leader-pattern="space" /></fo:block>
							<xsl:call-template name="Compensacoes">
								<xsl:with-param name="ELEM_SALDO" select="'VL_SALDO_PRINCIPAL'"/>
							</xsl:call-template>
							
							<fo:block><fo:leader leader-pattern="space" /></fo:block>
							<fo:block><fo:leader leader-pattern="space" /></fo:block>
							<fo:block xsl:use-attribute-sets="titFCinza" id="BP_d_1">d.1 Quadro do Supervit/Dficit Financeiro - Prefeitura</fo:block>
							<fo:block><fo:leader leader-pattern="space"/></fo:block>
							<xsl:apply-templates select="dc-balpat/SaldosPorRecurso">
								<xsl:with-param name="elementos" select="dc-balpat/SaldosPorRecurso/SaldosPorRecursoRow [TP_UNIDADE=0]"/>
								<!-- <xsl:with-param name="select" select="SaldosPorRecursoRow [TP_UNIDADE=0]"/> -->
							</xsl:apply-templates>
							
							<fo:block break-after="page"/>
							<fo:block xsl:use-attribute-sets="titFCinza" id="BP_a_2">a.2 Quadro Principal - RPPS</fo:block>
							<fo:block><fo:leader leader-pattern="space" /></fo:block>
							<xsl:call-template name="Balanco">
								<xsl:with-param name="ELEM_SALDO" select="'VL_SALDO_RPPS'"/>
							</xsl:call-template>

							<fo:block break-after="page"/>
							<!-- <fo:block><fo:leader leader-pattern="space" /></fo:block>
							<fo:block><fo:leader leader-pattern="space" /></fo:block> -->
							<fo:block xsl:use-attribute-sets="titFCinza" id="BP_b_2">b.2 Quadro dos Ativos e Passivos Financeiros e Permanentes - RPPS</fo:block>
							<fo:block><fo:leader leader-pattern="space" /></fo:block>
							<xsl:call-template name="QuadroTotais">
								<xsl:with-param name="ELEM_SALDO" select="'VL_SALDO_RPPS'"/>
							</xsl:call-template>

							<fo:block><fo:leader leader-pattern="space" /></fo:block>
							<fo:block><fo:leader leader-pattern="space" /></fo:block>
							<fo:block xsl:use-attribute-sets="titFCinza" id="BP_c_2">c.2 Quadro das Contas de Compensaes - RPPS</fo:block>
							<fo:block><fo:leader leader-pattern="space" /></fo:block>
							<xsl:call-template name="Compensacoes">
								<xsl:with-param name="ELEM_SALDO" select="'VL_SALDO_RPPS'"/>
							</xsl:call-template>
							
							<fo:block><fo:leader leader-pattern="space" /></fo:block>
							<fo:block><fo:leader leader-pattern="space" /></fo:block>
							<fo:block xsl:use-attribute-sets="titFCinza" id="BP_d_2">d.2 Quadro do Supervit/Dficit Financeiro - RPPS</fo:block>
							<fo:block><fo:leader leader-pattern="space"/></fo:block>
							<xsl:apply-templates select="dc-balpat/SaldosPorRecurso">
								<xsl:with-param name="elementos" select="dc-balpat/SaldosPorRecurso/SaldosPorRecursoRow [TP_UNIDADE=5]"/>
							</xsl:apply-templates>
							
						</xsl:if>
						
						<fo:block break-after="page"/>
						<!-- <fo:block><fo:leader leader-pattern="space" /></fo:block>
						<fo:block><fo:leader leader-pattern="space" /></fo:block> -->
						<fo:block xsl:use-attribute-sets="titFCinza" id="BP_e_0">e. Notas Explicativas</fo:block>
						<fo:block><fo:leader leader-pattern="space"/></fo:block>
						
						<xsl:apply-templates select="dc-balpat/NotasExplicativas"/>
						
						<fo:block><fo:leader leader-pattern="space" /></fo:block>
						<fo:block><fo:leader leader-pattern="space" /></fo:block>
						
						<xsl:apply-templates select="dc-balpat/Assinaturas"/>

						
						<!--xxxxxxxxxxx BLOCO PRINCIPAL - FIM xxxxxxx -->
						
						<!-- QUEBRA DE PAGINA -->
						<!-- fo:block break-after="page" /-->

						<!--=========== MENSAGEM ============ -->

						<!-- fo:block>
							<fo:leader leader-pattern="space" />
						</fo:block>
						<fo:table margin-left="1pt" margin-right="1pt" table-layout="fixed">
							<xsl:attribute name="width"><xsl:value-of select="$pageWidthInternal"/></xsl:attribute>
							<fo:table-column column-number="1" />

							<fo:table-body>
								<fo:table-row>
									<fo:table-cell padding-left="50pt">
										<fo:block xsl:use-attribute-sets="txtLeft" hyphenate="true"
											language="pt" id="RVE_7_1">
											CERTIFICAMOS, com base nos registros constantes na Entidade, a
											consist&#234;ncia das informa&#231;&#245;es apresentadas
											neste relat&#243;rio com as
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell>
										<fo:block xsl:use-attribute-sets="txtLeft">
											enviadas ao TCE.
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
								<fo:table-row>
									<fo:table-cell>
										<fo:block xsl:use-attribute-sets="txtLeft" />
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>
						</fo:table>
						<fo:block>
							<fo:leader leader-pattern="space" />
						</fo:block>
						<fo:block>
							<fo:leader leader-pattern="space" />
						</fo:block>
						<fo:block>
							<fo:leader leader-pattern="space" />
						</fo:block>
						<fo:block>
							<fo:leader leader-pattern="space" />
						</fo:block>
						<fo:block>
							<fo:leader leader-pattern="space" />
						</fo:block-->
						
						<!--=========== MENSAGEM ============ -->

						<!--xxxxxxxxxxx ITEM PRINCIPAL [7] - FIM xxxxxxxxxxx -->

						<fo:block id="last-page" />

					</fo:block>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>

	<!-- ########################## #### CABECALHO ########################## -->
	<xsl:template match="Cabecalho">
		<xsl:variable name="periodoFinal">
			<xsl:if test="CabecalhoRow/PERIODO_INFORMACOES = 1">
				<xsl:if test="(CabecalhoRow/ANO_EXERCICIO mod 4 = 0 and CabecalhoRow/ANO_EXERCICIO mod 100 != 0) or (CabecalhoRow/ANO_EXERCICIO mod 400 = 0)">29/02/</xsl:if>
				<xsl:if test="(CabecalhoRow/ANO_EXERCICIO mod 4 != 0) or (CabecalhoRow/ANO_EXERCICIO mod 100 = 0 and CabecalhoRow/ANO_EXERCICIO mod 400 != 0)">28/02/</xsl:if>
			</xsl:if>
			<xsl:if test="CabecalhoRow/PERIODO_INFORMACOES = 2">30/04/</xsl:if>
			<xsl:if test="CabecalhoRow/PERIODO_INFORMACOES = 3">30/06/</xsl:if>
			<xsl:if test="CabecalhoRow/PERIODO_INFORMACOES = 4">31/08/</xsl:if>
			<xsl:if test="CabecalhoRow/PERIODO_INFORMACOES = 5">31/10/</xsl:if>
			<xsl:if test="CabecalhoRow/PERIODO_INFORMACOES = 6">31/12/</xsl:if>
		</xsl:variable>

		<xsl:variable name="tipoRelatorio">
			<xsl:value-of select="CabecalhoRow/TP_RELATORIO" />
		</xsl:variable>

		<xsl:variable name="dataHora" select="document(concat($PATH_REMESSA,'\remessa_info.xml'))//data-geracao" />
		<xsl:variable name="data" select="substring($dataHora, 1, 10)" />
		<xsl:variable name="horario" select="substring($dataHora, 12, 8)" />
		<xsl:variable name="dia" select="substring($data, 9, 2)" />
		<xsl:variable name="mes" select="substring($data, 6, 2)" />
		<xsl:variable name="ano" select="substring($data, 1, 4)" />
		<xsl:variable name="hora" select="substring($horario, 1, 2)" />
		<xsl:variable name="minuto" select="substring($horario, 4, 2)" />
		<xsl:variable name="segundo" select="substring($horario, 7, 2)" />

		<fo:block>
			<fo:table margin-left="1pt" margin-right="1pt" table-layout="fixed">
				<xsl:attribute name="width"><xsl:value-of select="$pageWidthInternal"/></xsl:attribute>
				<fo:table-column column-width="60pt" />
				<fo:table-column column-width="623pt" />
				<fo:table-column column-width="101pt" />

				<fo:table-body>

					<fo:table-row>
						<fo:table-cell number-columns-spanned="3"
							border-bottom-style="solid" border-bottom-width="1pt">
							<fo:block />
						</fo:table-cell>
					</fo:table-row>

					<fo:table-row>
						<fo:table-cell padding-bottom="3pt">
							<fo:block>
								<fo:external-graphic src="{concat($PATH_IMAGENS,'Brasao.jpg')}" width="50pt" />
							</fo:block>
						</fo:table-cell>

						<fo:table-cell>
							<fo:block padding-bottom="1pt">
								<fo:table table-layout="fixed">
									<fo:table-column column-width="423pt" />
									<fo:table-column column-width="200pt" />
									<fo:table-column column-width="0pt" />

									<fo:table-body>
										<fo:table-row>
											<fo:table-cell padding-left="15pt" padding-top="1pt" number-columns-spanned="3">
												<fo:block xsl:use-attribute-sets="txtCenter">
												ESTADO DO RIO GRANDE DO SUL - TRIBUNAL DE CONTAS DO ESTADO
												</fo:block>
											</fo:table-cell>
										</fo:table-row>

										<fo:table-row>
											<fo:table-cell padding-left="15pt">
												<fo:block xsl:use-attribute-sets="txtLeft" font-weight="bold">
													SIAPC - Sistema de Informa&#231;&#245;es para
													Auditoria e Presta&#231;&#227;o de Contas
												</fo:block>
												<fo:block xsl:use-attribute-sets="txtLeft" font-weight="bold">
													Programa Autenticador de Dados - Vers&#227;o:
													<xsl:value-of select="CabecalhoRow/VERSAO_PAD" />
													<xsl:value-of select="java:br.gov.rs.tce.pad.util.VersaoUtils.getVersaoTestId()"/>
												</fo:block>
											</fo:table-cell>
											<!-- BARCODE -->
											<fo:table-cell number-rows-spanned="2" text-align="center">
												<fo:block xsl:use-attribute-sets="txtRight">

													<fo:instream-foreign-object>
														<barcode:barcode xmlns:barcode="http://barcode4j.krysalis.org/ns"
															message="{document(concat($PATH_REMESSA,'\remessa_info.xml'))//cod-barras-dc-bp}">
															<barcode:code128>
																<barcode:height>15mm</barcode:height>
															</barcode:code128>
														</barcode:barcode>
													</fo:instream-foreign-object>


												</fo:block>
											</fo:table-cell>
											<!-- /BARCODE -->
										</fo:table-row>
										<!-- fo:table-row>
											<fo:table-cell number-columns-spanned="2"
												padding-left="90pt">
												<fo:block xsl:use-attribute-sets="txtLeft"
													font-weight="bold">
													Programa Autenticador de Dados - PAD Vers&#227;o:
													<xsl:value-of select="CabecalhoRow/VERSAO_PAD" />
												</fo:block>
											</fo:table-cell>
										</fo:table-row-->
										<fo:table-row>
											<fo:table-cell padding-left="40pt" number-columns-spanned="3">
												<fo:block xsl:use-attribute-sets="titNegritoBig" font-weight="normal">Balano Patrimonial</fo:block>
											</fo:table-cell>
										</fo:table-row>
									</fo:table-body>
								</fo:table>
							</fo:block>
						</fo:table-cell>

						<fo:table-cell padding-top="5pt" text-align="right">
							<fo:block>
								<fo:external-graphic src="{concat($PATH_IMAGENS,'tce_2025.jpg')}"
									width="42pt" />
							</fo:block>
							<fo:block xsl:use-attribute-sets="txtRight"> <!-- txtRightShort -->
								<xsl:value-of select="$dia" />
								/
								<xsl:value-of select="$mes" />
								/
								<xsl:value-of select="$ano" />
								-
								<xsl:value-of select="$hora" />
								:
								<xsl:value-of select="$minuto" />
								:
								<xsl:value-of select="$segundo" />
							</fo:block>
						</fo:table-cell>
					</fo:table-row>

					<fo:table-row>
						<fo:table-cell number-columns-spanned="3"
							border-bottom-style="solid" border-bottom-width="1pt">
							<fo:block>
								<fo:table text-align="center" table-layout="fixed">
									<xsl:attribute name="width"><xsl:value-of select="$pageWidthInternal"/></xsl:attribute>
								
									<fo:table-column column-width="281pt" />
									<fo:table-column column-width="90pt" />
									<fo:table-column column-width="90pt" />
									<fo:table-column column-width="95pt" />

									<fo:table-body>
										<fo:table-row>
											<fo:table-cell padding-left="60pt">
												<fo:block xsl:use-attribute-sets="txtLeft">
													<xsl:value-of select="CabecalhoRow/NOME" />
												</fo:block>
											</fo:table-cell>
											<fo:table-cell padding-left="5pt">
												<fo:block xsl:use-attribute-sets="txtLeft">
													ORGO N:
													<xsl:value-of
														select="document(concat($PATH_REMESSA,'\remessa_info.xml'))//codigo-entidade" />
												</fo:block>
											</fo:table-cell>
											<fo:table-cell padding-left="5pt">
												<fo:block xsl:use-attribute-sets="txtLeft">
													CNPJ:
													<xsl:value-of select="CabecalhoRow/CNPJ" />
												</fo:block>
											</fo:table-cell>
											<fo:table-cell>
												<fo:block xsl:use-attribute-sets="txtRight">
													01/01/<xsl:value-of select="CabecalhoRow/ANO_EXERCICIO" />
													a
													<xsl:value-of select="$periodoFinal" /><xsl:value-of select="CabecalhoRow/ANO_EXERCICIO" />
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
									</fo:table-body>
								</fo:table>
							</fo:block>
						</fo:table-cell>
					</fo:table-row>

				</fo:table-body>
			</fo:table>
		</fo:block>
	</xsl:template>
	<!-- #### FIM - CABE&#199;ALHO #### -->

<!-- #############################################  ############################################# -->

<xsl:template name="Balanco">
	<xsl:param name="ELEM_SALDO" select="'VL_SALDO'"/>
	
	<fo:block>
		<fo:table margin-left="1pt" margin-right="1pt" table-layout="fixed" border-collapse="collapse">
			<fo:table-column column-width="386pt" />
			<fo:table-column column-width="10pt" />
			<fo:table-column column-width="386pt" />

			<fo:table-body>
				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="bordasAll">
						<fo:block>
							<fo:table margin-left="1pt" margin-right="1pt" table-layout="fixed">
								<xsl:call-template name="BalancoHeader">
									<xsl:with-param name="TITULO">ATIVO</xsl:with-param>
								</xsl:call-template>
								<fo:table-body>
									<xsl:apply-templates select="dc-balpat/ContasAtivo/ContasAtivoRow [NR_NIVEL!=1]">
										<xsl:with-param name="NR_NIVEL_SUB" select="-2"/>
										<xsl:with-param name="ELEM_SALDO" select="$ELEM_SALDO"/>
									</xsl:apply-templates>
									<!-- xsl:call-template name="ContasRow">
										<xsl:with-param name="DS_CONTA_BVER">TOTAL</xsl:with-param>
										<xsl:with-param name="NR_NIVEL" select="1"/>
										<xsl:with-param name="VL_SALDO" select="sum(dc-balpat/ContasAtivo/ContasAtivoRow/VL_SALDO [../NR_NIVEL=1])"/>
										<xsl:with-param name="_titulo">true</xsl:with-param>
									</xsl:call-template-->
								</fo:table-body>
							</fo:table>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block>
							<fo:leader leader-pattern="space" />
						</fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="bordasAll">
						<fo:block>
							<fo:table margin-left="1pt" margin-right="1pt" table-layout="fixed">
								<xsl:call-template name="BalancoHeader">
									<xsl:with-param name="TITULO">PASSIVO</xsl:with-param>
								</xsl:call-template>
								<fo:table-body>
									<xsl:apply-templates select="dc-balpat/ContasPassivo/ContasPassivoRow [GRUPO_CONTAS_N2='21' or GRUPO_CONTAS_N2='22']">
										<xsl:with-param name="NR_NIVEL_SUB" select="-2"/>
										<xsl:with-param name="ELEM_SALDO" select="$ELEM_SALDO"/>
									</xsl:apply-templates>
									<xsl:call-template name="ContasRow">
										<xsl:with-param name="DS_CONTA_BVER">TOTAL DO PASSIVO</xsl:with-param>
										<xsl:with-param name="NR_NIVEL" select="1"/>
										<xsl:with-param name="VL_SALDO" select="sum(dc-balpat/ContasPassivo/ContasPassivoRow/* [local-name() = $ELEM_SALDO][../NR_NIVEL=2][../GRUPO_CONTAS_N2='21' or ../GRUPO_CONTAS_N2='22'])"/>
										<xsl:with-param name="_titulo">true</xsl:with-param>
									</xsl:call-template>
								</fo:table-body>
							</fo:table>
						</fo:block>
						<fo:block>
							<fo:table margin-left="1pt" margin-right="1pt" table-layout="fixed">
								<xsl:call-template name="BalancoHeader">
									<xsl:with-param name="TITULO">PATRIMNIO LQUIDO</xsl:with-param>
								</xsl:call-template>
								<fo:table-body>
									<xsl:apply-templates select="dc-balpat/ContasPassivo/ContasPassivoRow [NR_NIVEL>2][GRUPO_CONTAS_N2='23']">
										<xsl:with-param name="NR_NIVEL_SUB" select="-2"/>
										<xsl:with-param name="ELEM_SALDO" select="$ELEM_SALDO"/>
									</xsl:apply-templates>
									<xsl:call-template name="ContasRow">
										<xsl:with-param name="DS_CONTA_BVER">TOTAL DO PATRIMNIO LQUIDO</xsl:with-param>
										<xsl:with-param name="NR_NIVEL" select="1"/>
										<xsl:with-param name="VL_SALDO" select="sum(dc-balpat/ContasPassivo/ContasPassivoRow/* [local-name() = $ELEM_SALDO][../NR_NIVEL=2][../GRUPO_CONTAS_N2='23'])"/>
										<xsl:with-param name="_titulo">true</xsl:with-param>
									</xsl:call-template>
								</fo:table-body>
							</fo:table>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="bordasAll">
						<fo:block>
							<fo:table margin-left="1pt" margin-right="1pt" table-layout="fixed">
								<xsl:call-template name="BalancoHeaderColunas"/>
								<fo:table-body>
									<xsl:call-template name="ContasRow">
										<xsl:with-param name="DS_CONTA_BVER">TOTAL</xsl:with-param>
										<xsl:with-param name="NR_NIVEL" select="1"/>
										<xsl:with-param name="VL_SALDO" select="sum(dc-balpat/ContasAtivo/ContasAtivoRow/* [local-name() = $ELEM_SALDO][../NR_NIVEL=1][../TIPO_NIVEL='S'])"/>
										<xsl:with-param name="_titulo">true</xsl:with-param>
									</xsl:call-template>
								</fo:table-body>
							</fo:table>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block><fo:leader leader-pattern="space" /></fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="bordasAll">
						<fo:block>
							<fo:table margin-left="1pt" margin-right="1pt" table-layout="fixed">
								<xsl:call-template name="BalancoHeaderColunas"/>
								<fo:table-body>
									<xsl:call-template name="ContasRow">
										<xsl:with-param name="DS_CONTA_BVER">TOTAL</xsl:with-param>
										<xsl:with-param name="NR_NIVEL" select="1"/>
										<xsl:with-param name="VL_SALDO" select="sum(dc-balpat/ContasPassivo/ContasPassivoRow/* [local-name() = $ELEM_SALDO][../NR_NIVEL=1][../TIPO_NIVEL='S'])"/>
										<xsl:with-param name="_titulo">true</xsl:with-param>
									</xsl:call-template>
								</fo:table-body>
							</fo:table>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</fo:block>
</xsl:template>

<xsl:template name="BalancoHeader">
	<xsl:param name="TITULO" select="-1"/>
								<xsl:call-template name="BalancoHeaderColunas"/>
								<fo:table-header>
									<fo:table-row>
										<fo:table-cell xsl:use-attribute-sets="bordasAll" number-columns-spanned="2">
											<fo:block xsl:use-attribute-sets="titTabelaHeader">
												<xsl:value-of select="$TITULO" />
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell xsl:use-attribute-sets="bordasAll">
											<fo:block xsl:use-attribute-sets="titTabelaHeader">
												ESPECIFICAO
											</fo:block>
										</fo:table-cell>
										<fo:table-cell xsl:use-attribute-sets="bordasAll">
											<fo:block xsl:use-attribute-sets="titTabelaHeader">
												Exerccio Atual
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-header>
</xsl:template>

<xsl:template name="BalancoHeaderColunas">
								<fo:table-column column-width="286pt" />
								<fo:table-column column-width="100pt" />
</xsl:template>

<!-- #############################################  ############################################# -->

<xsl:template match="ContasAtivoRow|ContasPassivoRow|CompensacoesAtivoRow|CompensacoesPassivoRow|ContasPassivoFinanceiroRow|ContasPassivoPermanenteRow" name="ContasRow">
<!-- xsl:if test="number(VL_SALDO)>0" --> <!--  and number(NR_NIVEL)>1 -->
	<xsl:param name="DS_CONTA_BVER" select="DS_CONTA_BVER"/>
	<xsl:param name="NR_NIVEL" select="NR_NIVEL"/>
	<xsl:param name="NR_NIVEL_SUB" select="-1"/>
	<xsl:param name="ELEM_SALDO" select="'VL_SALDO'"/>
	<xsl:param name="VL_SALDO" select="sum(./* [local-name() = $ELEM_SALDO])"/>
	<xsl:param name="_titulo" select="false"/>
	
	<fo:table-row>
		<fo:table-cell>
			<xsl:attribute name="padding-left"><xsl:value-of select="concat( (number($NR_NIVEL)+number($NR_NIVEL_SUB) ) * 15,'pt')"/></xsl:attribute>
			<xsl:if test="$_titulo">
				<xsl:attribute name="border-right-width">0.5pt</xsl:attribute>
				<xsl:attribute name="border-right-style">solid</xsl:attribute>
				<xsl:attribute name="border-top-width">1pt</xsl:attribute>
				<xsl:attribute name="border-top-style">solid</xsl:attribute>
			</xsl:if>
			
			<fo:block xsl:use-attribute-sets="txtLeft">
				<xsl:if test="$_titulo">
					<xsl:attribute name="font-weight">bold</xsl:attribute>
					<!-- <xsl:attribute name="background-color">#EEEEEE</xsl:attribute> -->
				</xsl:if>
				<xsl:value-of select="$DS_CONTA_BVER" />
			</fo:block>
		</fo:table-cell>
		<fo:table-cell>
			<xsl:if test="$_titulo">
				<xsl:attribute name="border-top-width">1pt</xsl:attribute>
				<xsl:attribute name="border-top-style">solid</xsl:attribute>
			</xsl:if>
			
			<fo:block xsl:use-attribute-sets="txtRight">
				<xsl:if test="$_titulo">
					<xsl:attribute name="font-weight">bold</xsl:attribute>
					<!-- <xsl:attribute name="background-color">#EEEEEE</xsl:attribute> -->
				</xsl:if>
				<xsl:call-template name="FormataNumero">
					<xsl:with-param name="valor" select="$VL_SALDO"/>
				</xsl:call-template>
			</fo:block>
		</fo:table-cell>
	</fo:table-row>
<!-- /xsl:if -->
</xsl:template>

<!-- #############################################  ############################################# -->

<xsl:template name="QuadroTotais">
	<xsl:param name="ELEM_SALDO" select="'VL_SALDO'"/>
	
	<fo:block>
		<fo:table margin-left="1pt" margin-right="1pt" table-layout="fixed">
			<fo:table-column column-width="286pt" />
			<fo:table-column column-width="100pt" />
			<fo:table-column column-width="10pt" />
			<fo:table-column column-width="286pt" />
			<fo:table-column column-width="100pt" />

			<fo:table-body>
				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="bordasAll" number-columns-spanned="2">
						<fo:block xsl:use-attribute-sets="titTabelaHeaderLeft">
							ATIVO (I)
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block><fo:leader leader-pattern="space" /></fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="bordasAll" number-columns-spanned="2">
						<fo:block xsl:use-attribute-sets="titTabelaHeaderLeft">
							PASSIVO (II)
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				
				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="bordasAll">
						<fo:block xsl:use-attribute-sets="titTabelaHeaderLeft">
							ATIVO FINANCEIRO
						</fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="bordasAll">
						<fo:block xsl:use-attribute-sets="titTabelaHeaderRight">
							<xsl:call-template name="FormataNumero">
								<xsl:with-param name="valor" select="sum(dc-balpat/SomaAtivoFinanceiro/SomaAtivoFinanceiroRow/* [local-name() = $ELEM_SALDO])"/>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block><fo:leader leader-pattern="space" /></fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="bordasAll">
						<fo:block xsl:use-attribute-sets="titTabelaHeaderLeft">
							PASSIVO FINANCEIRO
						</fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="bordasAll">
						<fo:block xsl:use-attribute-sets="titTabelaHeaderRight">
							<xsl:call-template name="FormataNumero">
								<xsl:with-param name="valor" select="sum(dc-balpat/ContasPassivoFinanceiro/ContasPassivoFinanceiroRow/* [local-name() = $ELEM_SALDO])"/>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>

				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="bordasAll" number-columns-spanned="2">
						<fo:block>
							<fo:table margin-left="1pt" margin-right="1pt" table-layout="fixed">
								<fo:table-column column-width="286pt" />
								<fo:table-column column-width="100pt" />
								<fo:table-body>
									<xsl:call-template name="ContasRow">
										<xsl:with-param name="DS_CONTA_BVER">Contas escrituraveis da Classe 1 com atributo F</xsl:with-param>
										<xsl:with-param name="NR_NIVEL" select="1"/>
										<xsl:with-param name="VL_SALDO" select="sum(dc-balpat/SomaAtivoFinanceiro/SomaAtivoFinanceiroRow/* [local-name() = $ELEM_SALDO])"/>
									</xsl:call-template>
								</fo:table-body>
							</fo:table>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block><fo:leader leader-pattern="space" /></fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="bordasAll" number-columns-spanned="2">
						<fo:block>
							<fo:table margin-left="1pt" margin-right="1pt" table-layout="fixed">
								<fo:table-column column-width="286pt" />
								<fo:table-column column-width="100pt" />
								<fo:table-body>
									<xsl:apply-templates select="dc-balpat/ContasPassivoFinanceiro/ContasPassivoFinanceiroRow">
										<xsl:with-param name="ELEM_SALDO" select="$ELEM_SALDO"/>
									</xsl:apply-templates>
								</fo:table-body>
							</fo:table>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				
				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="bordasAll">
						<fo:block xsl:use-attribute-sets="titTabelaHeaderLeft">
							ATIVO PERMANENTE
						</fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="bordasAll">
						<fo:block xsl:use-attribute-sets="titTabelaHeaderRight">
							<xsl:call-template name="FormataNumero">
								<xsl:with-param name="valor" select="sum(dc-balpat/SomaAtivoPermanente/SomaAtivoPermanenteRow/* [local-name() = $ELEM_SALDO])"/>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block><fo:leader leader-pattern="space" /></fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="bordasAll">
						<fo:block xsl:use-attribute-sets="titTabelaHeaderLeft">
							PASSIVO PERMANENTE
						</fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="bordasAll">
						<fo:block xsl:use-attribute-sets="titTabelaHeaderRight">
							<xsl:call-template name="FormataNumero">
								<xsl:with-param name="valor" select="sum(dc-balpat/ContasPassivoPermanente/ContasPassivoPermanenteRow/* [local-name() = $ELEM_SALDO])"/>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>

				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="bordasAll" number-columns-spanned="2">
						<fo:block>
							<fo:table margin-left="1pt" margin-right="1pt" table-layout="fixed">
								<fo:table-column column-width="286pt" />
								<fo:table-column column-width="100pt" />
								<fo:table-body>
									<xsl:call-template name="ContasRow">
										<xsl:with-param name="DS_CONTA_BVER">Contas escrituraveis da Classe 1 com atributo P</xsl:with-param>
										<xsl:with-param name="NR_NIVEL" select="1"/>
										<xsl:with-param name="VL_SALDO" select="sum(dc-balpat/SomaAtivoPermanente/SomaAtivoPermanenteRow/* [local-name() = $ELEM_SALDO])"/>
									</xsl:call-template>
								</fo:table-body>
							</fo:table>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block><fo:leader leader-pattern="space" /></fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="bordasAll" number-columns-spanned="2">
						<fo:block>
							<fo:table margin-left="1pt" margin-right="1pt" table-layout="fixed">
								<fo:table-column column-width="286pt" />
								<fo:table-column column-width="100pt" />
								<fo:table-body>
									<xsl:apply-templates select="dc-balpat/ContasPassivoPermanente/ContasPassivoPermanenteRow">
										<xsl:with-param name="ELEM_SALDO" select="$ELEM_SALDO"/>
									</xsl:apply-templates>
								</fo:table-body>
							</fo:table>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>

				<xsl:variable name="vSomaAtivoFinanceiro">
					<xsl:value-of select="sum(dc-balpat/SomaAtivoFinanceiro/SomaAtivoFinanceiroRow/* [local-name() = $ELEM_SALDO])"/>
				</xsl:variable>
				<xsl:variable name="vSomaAtivoPermanente">
					<xsl:value-of select="sum(dc-balpat/SomaAtivoPermanente/SomaAtivoPermanenteRow/* [local-name() = $ELEM_SALDO])"/>
				</xsl:variable>
				<xsl:variable name="vSomaPassivoFinanceiro">
					<xsl:value-of select="sum(dc-balpat/ContasPassivoFinanceiro/ContasPassivoFinanceiroRow/* [local-name() = $ELEM_SALDO])"/>
				</xsl:variable>
				<xsl:variable name="vSomaPassivoPermanente">
					<xsl:value-of select="sum(dc-balpat/ContasPassivoPermanente/ContasPassivoPermanenteRow/* [local-name() = $ELEM_SALDO])"/>
				</xsl:variable>
				
				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="bordasAll">
						<fo:block xsl:use-attribute-sets="titTabelaHeaderLeft">
							TOTAL
						</fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="bordasAll">
						<fo:block xsl:use-attribute-sets="titTabelaHeaderRight">
							<xsl:call-template name="FormataNumero">
								<xsl:with-param name="valor" select="$vSomaAtivoFinanceiro + $vSomaAtivoPermanente"/>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block><fo:leader leader-pattern="space" /></fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="bordasAll">
						<fo:block xsl:use-attribute-sets="titTabelaHeaderLeft">
							TOTAL
						</fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="bordasAll">
						<fo:block xsl:use-attribute-sets="titTabelaHeaderRight">
							<xsl:call-template name="FormataNumero">
								<xsl:with-param name="valor" select="$vSomaPassivoFinanceiro + $vSomaPassivoPermanente"/>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>

				<!-- <xsl:variable name="saldoPatrimonialAtivo">
					<xsl:value-of select="
					sum(dc-balpat/SomaAtivoFinanceiro/SomaAtivoFinanceiroRow/* [local-name() = $ELEM_SALDO])
					+sum(dc-balpat/SomaAtivoPermanente/SomaAtivoPermanenteRow/* [local-name() = $ELEM_SALDO])
					-sum(dc-balpat/ContasPassivoFinanceiro/ContasPassivoFinanceiroRow/* [local-name() = $ELEM_SALDO])
					-sum(dc-balpat/ContasPassivoPermanente/ContasPassivoPermanenteRow/* [local-name() = $ELEM_SALDO])"/>
				</xsl:variable> -->
				<xsl:variable name="saldoPatrimonialAtivo">
					<xsl:value-of select="
					$vSomaAtivoFinanceiro + $vSomaAtivoPermanente - $vSomaPassivoFinanceiro - $vSomaPassivoPermanente
					"/>
				</xsl:variable>
				<xsl:variable name="saldoPatrimonialPassivo">
					<xsl:value-of select="-$saldoPatrimonialAtivo"/>
				</xsl:variable>
				<xsl:variable name="saldoPatrimonialAbs">
					<xsl:choose>
						<xsl:when test="$saldoPatrimonialAtivo &gt; 0">
							<xsl:value-of select="$saldoPatrimonialAtivo"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="$saldoPatrimonialPassivo"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:variable name="tituloSaldoPatrimonial">
					<xsl:choose>
						<xsl:when test="$saldoPatrimonialAtivo &gt; 0">
							(I - II)
						</xsl:when>
						<xsl:otherwise>
							(II - I)
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>

				<fo:table-row>
					<xsl:if test="$saldoPatrimonialAtivo &gt; 0">
						<!-- fo:table-cell xsl:use-attribute-sets="bordasAll" number-columns-spanned="2">
							<fo:block xsl:use-attribute-sets="titTabelaHeaderLeft">
								<fo:leader leader-pattern="space" />
							</fo:block>
						</fo:table-cell-->
						<fo:table-cell number-columns-spanned="3">
							<fo:block>
								<fo:leader leader-pattern="space" />
							</fo:block>
						</fo:table-cell>
					</xsl:if>
					
					<fo:table-cell xsl:use-attribute-sets="bordasAll">
						<fo:block xsl:use-attribute-sets="titTabelaHeaderLeft">
							SALDO PATRIMONIAL <xsl:value-of select="$tituloSaldoPatrimonial"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="bordasAll">
						<fo:block xsl:use-attribute-sets="titTabelaHeaderRight">
							<xsl:call-template name="FormataNumero">
								<xsl:with-param name="valor" select="$saldoPatrimonialAbs"/>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
					
					<xsl:if test="$saldoPatrimonialAtivo &lt;= 0">
						<fo:table-cell number-columns-spanned="3">
							<fo:block>
								<fo:leader leader-pattern="space" />
							</fo:block>
						</fo:table-cell>
						<!-- fo:table-cell xsl:use-attribute-sets="bordasAll" number-columns-spanned="2">
							<fo:block xsl:use-attribute-sets="titTabelaHeaderLeft">
								<fo:leader leader-pattern="space" />
							</fo:block>
						</fo:table-cell-->
					</xsl:if>
				</fo:table-row>

				<!-- <fo:table-row>
						<fo:table-cell number-columns-spanned="3">
							<fo:block>
								SomaAtivoFinanceiroRow: <xsl:value-of select="$vSomaAtivoFinanceiro"/>
							</fo:block>
							<fo:block>
								SomaAtivoPermanenteRow: <xsl:value-of select="$vSomaAtivoPermanente"/>
							</fo:block>
							<fo:block>
								ContasPassivoFinanceiroRow: <xsl:value-of select="$vSomaPassivoFinanceiro"/>
							</fo:block>
							<fo:block>
								ContasPassivoPermanenteRow: <xsl:value-of select="$vSomaPassivoPermanente"/>
							</fo:block>
							<fo:block>
								saldoPatrimonialAtivo: <xsl:value-of select="$saldoPatrimonialAtivo"/>
							</fo:block>
							<fo:block>
								saldoPatrimonialPassivo: <xsl:value-of select="$saldoPatrimonialPassivo"/>
							</fo:block>
							<fo:block>
								saldoPatrimonialAbs: <xsl:value-of select="$saldoPatrimonialAbs"/>
							</fo:block>
						</fo:table-cell>
				</fo:table-row> -->
				
			</fo:table-body>
		</fo:table>
	</fo:block>
</xsl:template>

<!-- #############################################  ############################################# -->

<xsl:template name="Compensacoes">
	<xsl:param name="ELEM_SALDO" select="'VL_SALDO'"/>
	
	<fo:block>
		<fo:table margin-left="1pt" margin-right="1pt" table-layout="fixed">
			<fo:table-column column-width="390pt" />
			<fo:table-column column-width="390pt" />

			<fo:table-body>
				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="bordasAll">
						<fo:block>
							<fo:table margin-left="1pt" margin-right="1pt" table-layout="fixed">
								<fo:table-column column-width="290pt" />
								<fo:table-column column-width="100pt" />
								<fo:table-header>
									<fo:table-row>
										<fo:table-cell number-columns-spanned="2">
											<fo:block xsl:use-attribute-sets="titTabelaHeader">
												Compensaes ATIVO
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell xsl:use-attribute-sets="bordasTB">
											<xsl:attribute name="border-right-width">0.5pt</xsl:attribute>
											<xsl:attribute name="border-right-style">solid</xsl:attribute>
											<fo:block xsl:use-attribute-sets="titTabelaHeader">
												ESPECIFICAO
											</fo:block>
										</fo:table-cell>
										<fo:table-cell xsl:use-attribute-sets="bordasTB">
											<fo:block xsl:use-attribute-sets="titTabelaHeader">
												Exerccio Atual
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-header>
								<fo:table-body>
									<xsl:apply-templates select="dc-balpat/CompensacoesAtivo/CompensacoesAtivoRow">
										<xsl:with-param name="NR_NIVEL_SUB" select="-3"/>
										<xsl:with-param name="ELEM_SALDO" select="$ELEM_SALDO"/>
									</xsl:apply-templates>
								</fo:table-body>
							</fo:table>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="bordasAll">
						<fo:block>
							<fo:table margin-left="1pt" margin-right="1pt" table-layout="fixed">
								<fo:table-column column-width="290pt" />
								<fo:table-column column-width="100pt" />
								<fo:table-header>
									<fo:table-row>
										<fo:table-cell number-columns-spanned="2">
											<fo:block xsl:use-attribute-sets="titTabelaHeader">
												Compensaes PASSIVO
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell xsl:use-attribute-sets="bordasTB">
											<xsl:attribute name="border-right-width">0.5pt</xsl:attribute>
											<xsl:attribute name="border-right-style">solid</xsl:attribute>
											<fo:block xsl:use-attribute-sets="titTabelaHeader">
												ESPECIFICAO
											</fo:block>
										</fo:table-cell>
										<fo:table-cell xsl:use-attribute-sets="bordasTB">
											<fo:block xsl:use-attribute-sets="titTabelaHeader">
												Exerccio Atual
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-header>
								<fo:table-body>
									<xsl:apply-templates select="dc-balpat/CompensacoesPassivo/CompensacoesPassivoRow">
										<xsl:with-param name="NR_NIVEL_SUB" select="-3"/>
										<xsl:with-param name="ELEM_SALDO" select="$ELEM_SALDO"/>
									</xsl:apply-templates>
								</fo:table-body>
							</fo:table>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				
				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="bordasAll">
						<fo:block>
							<fo:table margin-left="1pt" margin-right="1pt" table-layout="fixed">
								<fo:table-column column-width="290pt" />
								<fo:table-column column-width="100pt" />
								<fo:table-body>
									<xsl:call-template name="ContasRow">
										<xsl:with-param name="DS_CONTA_BVER">TOTAL</xsl:with-param>
										<xsl:with-param name="NR_NIVEL" select="1"/>
										<xsl:with-param name="VL_SALDO" select="sum(dc-balpat/CompensacoesAtivo/CompensacoesAtivoRow/* [local-name() = $ELEM_SALDO])"/>
										<xsl:with-param name="_titulo">true</xsl:with-param>
									</xsl:call-template>
								</fo:table-body>
							</fo:table>
						</fo:block>
					</fo:table-cell>
					<!-- <fo:table-cell>
						<fo:block><fo:leader leader-pattern="space" /></fo:block>
					</fo:table-cell> -->
					<fo:table-cell xsl:use-attribute-sets="bordasAll">
						<fo:block>
							<fo:table margin-left="1pt" margin-right="1pt" table-layout="fixed">
								<fo:table-column column-width="290pt" />
								<fo:table-column column-width="100pt" />
								<fo:table-body>
									<xsl:call-template name="ContasRow">
										<xsl:with-param name="DS_CONTA_BVER">TOTAL</xsl:with-param>
										<xsl:with-param name="NR_NIVEL" select="1"/>
										<xsl:with-param name="VL_SALDO" select="sum(dc-balpat/CompensacoesPassivo/CompensacoesPassivoRow/* [local-name() = $ELEM_SALDO])"/>
										<xsl:with-param name="_titulo">true</xsl:with-param>
									</xsl:call-template>
								</fo:table-body>
							</fo:table>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</fo:block>
</xsl:template>

<!-- #############################################  ############################################# -->

<xsl:template match="SaldosPorRecurso">
	<!-- [TP_UNIDADE=$tpUnidade] -->
	<!-- <xsl:param name="filter" select="''"/> -->
	<!-- <xsl:param name="select" select="SaldosPorRecursoRow"/> -->
	<!-- <xsl:param name="tpUnidade" select="''"/> -->
	<xsl:param name="elementos" select="SaldosPorRecursoRow"/>
	
	<fo:block>
		<fo:table margin-left="1pt" margin-right="1pt" table-layout="fixed">
			<!-- <fo:table-column column-width="100pt" /> -->
			<fo:table-column column-width="100pt" />
			<fo:table-column column-width="582pt" />
			<fo:table-column column-width="100pt" />

			<fo:table-header>
				<fo:table-row>
					<!-- <fo:table-cell xsl:use-attribute-sets="bordas">
						<fo:block xsl:use-attribute-sets="titTabelaHeader">
							Tipo Unidade
						</fo:block>
					</fo:table-cell> -->
					<fo:table-cell xsl:use-attribute-sets="bordas">
						<fo:block xsl:use-attribute-sets="titTabelaHeader">
							Fonte de Recurso
						</fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="bordas">
						<fo:block xsl:use-attribute-sets="titTabelaHeader">
							Descrio
						</fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="bordas">
						<fo:block xsl:use-attribute-sets="titTabelaHeader">
							Valor
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-header>
			<fo:table-body>
				<xsl:apply-templates select="$elementos"/>
				<fo:table-row>
					<fo:table-cell xsl:use-attribute-sets="bordas" number-columns-spanned="2">
						<fo:block xsl:use-attribute-sets="txtLeft">
							Total
						</fo:block>
					</fo:table-cell>
					<fo:table-cell xsl:use-attribute-sets="bordas">
						<fo:block xsl:use-attribute-sets="txtRight">
							<xsl:call-template name="FormataNumero">
								<xsl:with-param name="valor" select="sum($elementos/VL_SALDO_FINAL)"/>
							</xsl:call-template>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</fo:block>
</xsl:template>

<!-- #############################################  ############################################# -->

<xsl:template match="SaldosPorRecursoRow">
	<fo:table-row>
		<!-- <fo:table-cell xsl:use-attribute-sets="bordas">
			<fo:block xsl:use-attribute-sets="txtLeft">
				<xsl:value-of select="TP_UNIDADE" />
			</fo:block>
		</fo:table-cell> -->
		<fo:table-cell xsl:use-attribute-sets="bordas">
			<fo:block xsl:use-attribute-sets="txtRight">
				<xsl:value-of select="CD_FONTE_RECURSO" />
			</fo:block>
		</fo:table-cell>
		<fo:table-cell xsl:use-attribute-sets="bordas">
			<fo:block xsl:use-attribute-sets="txtLeft">
				<xsl:value-of select="DS_FONTE_RECURSO" /><!-- (<xsl:value-of select="DS_GRUPO_RECURSO" />) -->
			</fo:block>
		</fo:table-cell>
		<fo:table-cell xsl:use-attribute-sets="bordas">
			<fo:block xsl:use-attribute-sets="txtRight">
				<xsl:call-template name="FormataNumero">
					<xsl:with-param name="valor" select="VL_SALDO_FINAL"/>
				</xsl:call-template>
			</fo:block>
		</fo:table-cell>
	</fo:table-row>
</xsl:template>


<!-- #############################################  ############################################# -->


<!-- xmlgraphics.apache.org/fop/fo.html#fo-preformat -->
<xsl:template match="NotasExplicativas">

	<xsl:choose>
	<xsl:when test="NotasExplicativasRow/TEXTO != ''">
	<fo:table width="784pt" margin-left="1pt" margin-right="1pt" table-layout="fixed" xsl:use-attribute-sets="bordasAll">
		<fo:table-column column-number="1" />
		<fo:table-body>
			<xsl:for-each select="NotasExplicativasRow">
				<fo:table-row>
					<fo:table-cell border-width="0.5pt" padding-left="5pt">
						<fo:block xsl:use-attribute-sets="txtLeft" white-space-collapse="false">
							<xsl:value-of select="TEXTO" />
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</xsl:for-each>
		</fo:table-body>
	</fo:table>
	</xsl:when>
	</xsl:choose>
</xsl:template>


<!-- #############################################  ############################################# -->


<xsl:template match="Assinaturas">
	<!-- ************* Variaveis locais ************** -->
	<xsl:variable name="administrador">
		<xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='P'">
			Prefeito Municipal
		</xsl:if>
		<xsl:if test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV='C'">
			Presidente da C&#226;mara Municipal
		</xsl:if>
		<xsl:if
			test="../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV!='P' and ../Cabecalho/CabecalhoRow/TIPO_SETOR_GOV!='C'">
			Respons&#225;vel
		</xsl:if>
	</xsl:variable>

	<xsl:variable name="anoExercicio" select="../Cabecalho/CabecalhoRow/ANO_EXERCICIO" />
	<!-- USAR VARIAVEL DOCUMENTO SO PCDI -->
	<xsl:variable name="dataHora" select="document(concat($PATH_REMESSA,'\remessa_info.xml'))//data-geracao" />
	<xsl:variable name="data" select="substring($dataHora, 1, 10)" />
	<xsl:variable name="dia" select="substring($data, 9, 2)" />
	<xsl:variable name="mes" select="substring($data, 6, 2)" />
	<xsl:variable name="ano" select="substring($data, 1, 4)" />
	<xsl:variable name="mesNome">
		<xsl:if test="$mes='01'">
			Janeiro
		</xsl:if>
		<xsl:if test="$mes='02'">
			Fevereiro
		</xsl:if>
		<xsl:if test="$mes='03'">
			Mar&#231;o
		</xsl:if>
		<xsl:if test="$mes='04'">
			Abril
		</xsl:if>
		<xsl:if test="$mes='05'">
			Maio
		</xsl:if>
		<xsl:if test="$mes='06'">
			Junho
		</xsl:if>
		<xsl:if test="$mes='07'">
			Julho
		</xsl:if>
		<xsl:if test="$mes='08'">
			Agosto
		</xsl:if>
		<xsl:if test="$mes='09'">
			Setembro
		</xsl:if>
		<xsl:if test="$mes='10'">
			Outubro
		</xsl:if>
		<xsl:if test="$mes='11'">
			Novembro
		</xsl:if>
		<xsl:if test="$mes='12'">
			Dezembro
		</xsl:if>
	</xsl:variable>

	<fo:table width="784pt" margin-left="1pt" margin-right="1pt" table-layout="fixed">
		<fo:table-column column-number="1" column-width="375pt" />
		<fo:table-column column-number="2" column-width="16pt" />
		<fo:table-column column-number="3" column-width="0pt" />
		<fo:table-column column-number="4" column-width="16pt" />
		<fo:table-column column-number="5" column-width="375pt" />

		<fo:table-body>
			<fo:table-row>
				<fo:table-cell border-width="0.5pt" padding="1pt" number-columns-spanned="5">
					<fo:block>
						<fo:leader leader-pattern="space" />
					</fo:block>
					<fo:block>
						<fo:leader leader-pattern="space" />
					</fo:block>
				</fo:table-cell>
			</fo:table-row>
			<fo:table-row>
				<fo:table-cell border-width="0.5pt" number-columns-spanned="5">
					<fo:block xsl:use-attribute-sets="txtCenter">
						<xsl:value-of select="AssinaturasRow/NOME_MUNICIPIO" />
						,
						<xsl:value-of select="$dia" />
						de
						<xsl:value-of select="$mesNome" />
						de
						<xsl:value-of select="$ano" />
					</fo:block>
				</fo:table-cell>
			</fo:table-row>
			<fo:table-row>
				<fo:table-cell border-width="0.5pt" padding="1pt" number-columns-spanned="5">
					<fo:block>
						<fo:leader leader-pattern="space" />
					</fo:block>
					<fo:block>
						<fo:leader leader-pattern="space" />
					</fo:block>
				</fo:table-cell>
			</fo:table-row>
			<fo:table-row>
				<fo:table-cell border-width="0.5pt" padding="1pt" number-columns-spanned="5">
					<fo:block xsl:use-attribute-sets="txtCenter" font-weight="bold">
						Gestor responsvel pelo perodo de 01/01/<xsl:value-of select="$anoExercicio"/> a 31/12/<xsl:value-of select="$anoExercicio"/> -
						<xsl:value-of select="AssinaturasRow/RESPONSAVEL_PERIODO" /> -
						<xsl:value-of select="$administrador" />
					</fo:block>
				</fo:table-cell>
			</fo:table-row>
			
			<fo:table-row>
				<fo:table-cell border-width="0.5pt" padding="1pt" number-columns-spanned="5">
					<fo:block xsl:use-attribute-sets="txtCenter"><fo:leader/></fo:block>
				</fo:table-cell>
			</fo:table-row>
			
			<fo:table-row>
				<fo:table-cell border-width="0.5pt" padding="1pt" number-columns-spanned="5">
					<fo:block xsl:use-attribute-sets="txtCenter" font-weight="bold">
						Responsveis pela entrega dos documentos
					</fo:block>
				</fo:table-cell>
			</fo:table-row>
			<fo:table-row>
				<fo:table-cell border-width="0.5pt" padding="1pt" number-columns-spanned="5">
					<fo:block xsl:use-attribute-sets="txtCenter"><fo:leader/></fo:block>
					<fo:block xsl:use-attribute-sets="txtCenter"><fo:leader/></fo:block>
				</fo:table-cell>
			</fo:table-row>

			<fo:table-row>
				<fo:table-cell border-width="0.5pt">txtCenter
					<fo:block xsl:use-attribute-sets="txtCenter">
						<xsl:value-of select="AssinaturasRow/CONTABILISTA" />
					</fo:block>
					<fo:block xsl:use-attribute-sets="txtCenter">Contabilista</fo:block>
				</fo:table-cell>
				<fo:table-cell border-width="0.5pt">
					<fo:block xsl:use-attribute-sets="txtRight"></fo:block>
				</fo:table-cell>
				<fo:table-cell border-width="0.5pt" padding="1pt">
					<!-- fo:block xsl:use-attribute-sets="txtCenter">
						<xsl:value-of select="AssinaturasRow/RESP_CTRL_INTERNO"/>
					</fo:block>
					<fo:block xsl:use-attribute-sets="txtCenter">
						Respons&#225;vel pelo Controle Interno
					</fo:block-->
				</fo:table-cell>
				<fo:table-cell border-width="0.5pt">
					<fo:block xsl:use-attribute-sets="txtRight"></fo:block>
				</fo:table-cell>
				<fo:table-cell border-width="0.5pt" padding="1pt">
					<fo:block xsl:use-attribute-sets="txtCenter">
						<xsl:value-of select="AssinaturasRow/ADMINISTRADOR" />
					</fo:block>
					<fo:block xsl:use-attribute-sets="txtCenter">
						<xsl:value-of select="$administrador" />
					</fo:block>
				</fo:table-cell>
			</fo:table-row>
			
		</fo:table-body>
	</fo:table>
</xsl:template>

<!-- #############################################  ############################################# -->

<xsl:template name="FormataNumero">
	<xsl:param name="valor" select="0" />
	<xsl:choose>
		<xsl:when test="string(number($valor))='NaN'">-</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select="format-number($valor, '#.##0,00')" />
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

</xsl:stylesheet>
