/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.gui.layout;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Enumeration;
import java.util.EventListener;
import javax.swing.JPanel;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.border.UIBorderFactory;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.pivot.PivotEvent;
import oracle.bali.ewt.pivot.PivotHeader;
import oracle.bali.ewt.pivot.PivotListener;
import oracle.bali.share.event.ListenerManager;
import oracle.dss.util.gui.layout.ColumnHeader;
import oracle.dss.util.gui.layout.CornerPainter;
import oracle.dss.util.gui.layout.CrosstabScrollPane;
import oracle.dss.util.gui.layout.DataPointGrid;
import oracle.dss.util.gui.layout.Layout;
import oracle.dss.util.gui.layout.LayoutComponent;
import oracle.dss.util.gui.layout.RowHeader;
import oracle.dss.util.gui.layout.ScrollPaneDropAdapter;

public class Crosstab
extends JPanel {
    public static final String PROPERTY_SELECTION = "selection";
    static final Object KEY_HORIZONTAL = "crosstablayout.horizontal";
    static final Object KEY_VERTICAL = "crosstablayout.vertical";
    ColumnHeader _columnHeader = new ColumnHeader(this, 0);
    RowHeader _rowHeader = new RowHeader(this, 1);
    DataPointGrid _grid = new DataPointGrid(this, -1);
    CrosstabScrollPane _scrollPane = new CrosstabScrollPane((Component)((Object)this._grid));
    CrosstabScrollPane _columnScrollPane = new CrosstabScrollPane((Component)((Object)this._columnHeader));
    CrosstabScrollPane _rowScrollPane = new CrosstabScrollPane((Component)((Object)this._rowHeader), false);
    LWComponent _corner = new Corner();
    Layout _layout;
    ScrollPaneDropAdapter _mainScrollDrop;
    ScrollPaneDropAdapter _rowScrollDrop;
    ScrollPaneDropAdapter _columnScrollDrop;
    private ListenerManager _pivotListeners;

    public Crosstab() {
        this._columnHeader.setBorder(null);
        this._rowHeader.setBorder(null);
        this._scrollPane.setBorder(null);
        this._columnScrollPane.setBorder(null);
        this._rowScrollPane.setBorder(null);
        this._layout = new Layout();
        this.setLayout(this._layout);
        this.setBorder(UIBorderFactory.getLoweredBevelBorder());
        this.add(this._columnScrollPane);
        this.add(this._rowScrollPane);
        this.add(this._scrollPane);
        this.add((Component)this._corner);
    }

    public ColumnHeader getColumnHeader() {
        return this._columnHeader;
    }

    public RowHeader getRowHeader() {
        return this._rowHeader;
    }

    public DataPointGrid getDataPointGrid() {
        return this._grid;
    }

    public boolean isSomethingSelected() {
        int n = this._columnHeader.getSelectedIndex();
        if (n != -1) {
            return true;
        }
        n = this._rowHeader.getSelectedIndex();
        if (n != -1) {
            return true;
        }
        n = this._grid.getSelectedIndex();
        return n != -1;
    }

    public LayoutComponent getSelectedAxis() {
        int n = this._columnHeader.getSelectedIndex();
        if (n != -1) {
            return this._columnHeader;
        }
        n = this._rowHeader.getSelectedIndex();
        if (n != -1) {
            return this._rowHeader;
        }
        n = this._grid.getSelectedIndex();
        if (n != -1) {
            return this._grid;
        }
        return null;
    }

    public void addNotify() {
        super.addNotify();
        this._columnHeader.setBorder(null);
        this._rowHeader.setBorder(null);
        this._scrollPane.setBorder(null);
        this._columnScrollPane.setBorder(null);
        this._rowScrollPane.setBorder(null);
        this._mainScrollDrop = new ScrollPaneDropAdapter(this._scrollPane, this);
        this._columnScrollDrop = new ScrollPaneDropAdapter(this._columnScrollPane, this);
        this._rowScrollDrop = new ScrollPaneDropAdapter(this._rowScrollPane, this);
    }

    public void clearSelection() {
        this._columnHeader.clearSelection();
        this._rowHeader.clearSelection();
        this._grid.clearSelection();
    }

    public synchronized void addPivotListener(PivotListener pivotListener) {
        if (this._pivotListeners == null) {
            this._pivotListeners = new ListenerManager();
        }
        this._pivotListeners.addListener((EventListener)pivotListener);
    }

    public synchronized void removePivotListener(PivotListener pivotListener) {
        if (this._pivotListeners != null) {
            this._pivotListeners.removeListener((EventListener)pivotListener);
        }
    }

    public int getDataPointOrientation() {
        return this._grid.getOrientation();
    }

    public void setDataPointOrientation(int n) {
        this._grid.setOrientation(n);
        this.invalidate();
    }

    public void setPopupManager(Layout.PopupManager popupManager) {
        if (this._columnHeader != null) {
            this._columnHeader.setPopupManager(popupManager);
            popupManager.setColumnLayoutComponent(this._columnHeader);
        }
        if (this._rowHeader != null) {
            this._rowHeader.setPopupManager(popupManager);
            popupManager.setRowLayoutComponent(this._rowHeader);
        }
    }

    public void setGridPopupManager(Layout.PopupManager popupManager) {
        if (this._grid != null) {
            this._grid.setPopupManager(popupManager);
            popupManager.setMeasureLayoutComponent(this._grid);
        }
    }

    public void cleanup() {
        this._columnHeader.cleanup();
        this._rowHeader.cleanup();
        this._grid.cleanup();
        if (this._mainScrollDrop != null) {
            this._mainScrollDrop.cleanup();
            this._rowScrollDrop.cleanup();
            this._columnScrollDrop.cleanup();
        }
        BorderLayout borderLayout = (BorderLayout)this.getParent().getLayout();
        borderLayout.removeLayoutComponent(this);
        this.removeAll();
        this.setLayout(null);
        this._columnScrollPane.removeAll();
        this._rowScrollPane.removeAll();
        this._scrollPane.removeAll();
        this._layout = null;
        this._columnHeader = null;
        this._columnScrollPane = null;
        this._corner = null;
        this._grid = null;
        this._pivotListeners = null;
        this._rowHeader = null;
        this._rowScrollPane = null;
        this._scrollPane = null;
        this._mainScrollDrop = null;
        this._rowScrollDrop = null;
        this._columnScrollDrop = null;
    }

    public void firePivotEvent(Object object, int n, Object object2, int n2) {
        PivotEvent pivotEvent = new PivotEvent(object, 2001, object2, n, n2);
        this.processEvent((AWTEvent)pivotEvent);
    }

    public void fireSwapEvent(Object object, int n, Object object2, int n2) {
        PivotEvent pivotEvent = new PivotEvent(object, 2002, object2, n, n2);
        this.processEvent((AWTEvent)pivotEvent);
    }

    public boolean isValidateRoot() {
        return true;
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof PivotEvent) {
            this.processPivotEvent((PivotEvent)aWTEvent);
        } else {
            super.processEvent(aWTEvent);
        }
    }

    protected void processPivotEvent(PivotEvent pivotEvent) {
        if (this._pivotListeners == null) {
            return;
        }
        Enumeration enumeration = this._pivotListeners.getListeners();
        if (enumeration == null) {
            return;
        }
        switch (pivotEvent.getID()) {
            case 2001: {
                while (enumeration.hasMoreElements()) {
                    ((PivotListener)enumeration.nextElement()).pivot(pivotEvent);
                }
                break;
            }
            case 2002: {
                while (enumeration.hasMoreElements()) {
                    ((PivotListener)enumeration.nextElement()).swap(pivotEvent);
                }
                break;
            }
        }
    }

    void columnSelectionChanged() {
        this._rowHeader.clearSelection();
        this._grid.clearSelection();
        this.firePropertyChange(PROPERTY_SELECTION, null, null);
    }

    void rowSelectionChanged() {
        this._columnHeader.clearSelection();
        this._grid.clearSelection();
        this.firePropertyChange(PROPERTY_SELECTION, null, null);
    }

    void gridSelectionChanged() {
        this._rowHeader.clearSelection();
        this._columnHeader.clearSelection();
        this.firePropertyChange(PROPERTY_SELECTION, null, null);
    }

    void axisItemToDataPoint(PivotHeader pivotHeader, int n) {
        this.firePivotEvent(pivotHeader, n, this._grid, 0);
    }

    void dataPointToAxisItem(int n) {
        int n2 = this._columnHeader.getItemCount();
        this.firePivotEvent(this._grid, n, this._columnHeader, n2);
    }

    private class Layout
    implements LayoutManager {
        Layout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension = Crosstab.this._rowHeader.getPreferredScrollableViewportSize();
            Dimension dimension2 = Crosstab.this._columnHeader.getPreferredScrollableViewportSize();
            Dimension dimension3 = Crosstab.this._grid.getPreferredScrollableViewportSize();
            if (dimension2.height == 0) {
                dimension2.height = Crosstab.this._columnHeader.getPreferredSize().height;
            }
            if (dimension.width == 0) {
                dimension.width = Crosstab.this._rowHeader.getPreferredSize().width;
            }
            int n = Crosstab.this._columnHeader.getRowHeaderWidth();
            int n2 = dimension.width + n + Math.max(dimension2.width, dimension3.width);
            int n3 = dimension2.height + n + Math.max(dimension.height, dimension3.height);
            return new Dimension(n2, n3);
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public void layoutContainer(Container container) {
            int n;
            Dimension dimension = container.getSize();
            Insets insets = Crosstab.this.getInsets();
            if (insets != null) {
                dimension.width -= insets.left + insets.right;
                dimension.height -= insets.top + insets.bottom;
            }
            Dimension dimension2 = Crosstab.this._rowHeader.getPreferredScrollableViewportSize();
            Dimension dimension3 = Crosstab.this._columnHeader.getPreferredScrollableViewportSize();
            Dimension dimension4 = Crosstab.this._grid.getPreferredScrollableViewportSize();
            if (dimension3.height == 0) {
                dimension3.height = Crosstab.this._columnHeader.getPreferredSize().height;
            }
            if (dimension2.width == 0) {
                dimension2.width = Crosstab.this._rowHeader.getPreferredSize().width;
            }
            if (dimension3.height + dimension2.height > dimension.height) {
                n = dimension.height / 2;
                if (dimension3.height > n) {
                    dimension3.height = n;
                }
                if (dimension2.height > n) {
                    dimension2.height = n;
                }
            }
            if (dimension3.width + dimension2.width > dimension.width) {
                n = dimension.width / 2;
                if (dimension3.width > n) {
                    dimension3.width = n;
                }
                if (dimension2.width > n) {
                    dimension2.width = n;
                }
            }
            n = Crosstab.this._columnHeader.getRowHeaderWidth();
            int n2 = 0;
            int n3 = 0;
            if (insets != null) {
                n2 = insets.left;
                n3 = insets.top;
            }
            Crosstab.this._corner.setBounds(n2, n3, dimension2.width, dimension3.height);
            Crosstab.this._rowScrollPane.setBounds(n2, n3 + dimension3.height, dimension2.width, dimension.height - dimension3.height);
            int n4 = dimension.width - dimension2.width;
            Crosstab.this._columnHeader.setColumnWidth(n4);
            Crosstab.this._columnScrollPane.setBounds(n2 + dimension2.width, n3, n4, dimension3.height);
            Crosstab.this._grid.setColumnWidth(n4 -= n);
            Crosstab.this._scrollPane.setBounds(dimension2.width + n, dimension3.height + n, n4, dimension.height - dimension3.height - n + 1);
        }
    }

    private class Corner
    extends LWComponent {
        Corner() {
        }

        public void paintComponent(Graphics graphics) {
            Painter painter = CornerPainter.getPainter();
            painter.paint(this.getPaintContext(), graphics, 0, 0, this.getWidth(), this.getHeight());
        }

        public Object getPaintData(Object object) {
            if (KEY_HORIZONTAL.equals(object)) {
                return Crosstab.this._rowHeader.getGrid().getColumnCount() != 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            if (KEY_VERTICAL.equals(object)) {
                return Crosstab.this._columnHeader.getGrid().getRowCount() != 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            return super.getPaintData(object);
        }
    }
}

