/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.math;

import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.math.CurveFitIF;

public class FitPolynomial
implements CurveFitIF {
    private static final int MAX_ORDER = 10;
    private int m_nOrder;

    public FitPolynomial(int n) throws AssertionException {
        PfjAssert.pfjAssert(n >= 1 && n <= 10);
        this.m_nOrder = n;
    }

    public double compute(double d, double[] dArray) throws AssertionException {
        PfjAssert.pfjAssert(dArray.length >= this.m_nOrder + 1 + 1);
        double d2 = dArray[1];
        int n = 1;
        while (n <= this.m_nOrder) {
            d2 += dArray[n + 1] * Math.pow(d, n);
            ++n;
        }
        return d2;
    }

    public void eval(double d, double[] dArray) throws AssertionException {
        PfjAssert.pfjAssert(dArray.length >= this.m_nOrder + 1 + 1);
        double d2 = 1.0;
        int n = 1;
        while (n <= this.m_nOrder + 1) {
            dArray[n] = d2;
            d2 *= d;
            ++n;
        }
    }

    public int numCoeffs() {
        return this.m_nOrder + 1;
    }

    public double transformY(double d) {
        return d;
    }

    public double invTransformCoeff(int n, double d) {
        return d;
    }

    public String createEquation(String[] stringArray, boolean bl) throws AssertionException {
        String string;
        PfjAssert.pfjAssert(stringArray.length >= this.m_nOrder + 1 + 1);
        if (bl) {
            string = String.valueOf(stringArray[2]) + " * x" + " + " + stringArray[1];
            int n = 3;
            while (n <= this.m_nOrder + 1) {
                string = String.valueOf(stringArray[n]) + " * x^" + (n - 1) + " + " + string;
                ++n;
            }
        } else {
            string = String.valueOf(stringArray[1]) + " + " + stringArray[2] + " * x";
            int n = 3;
            while (n <= this.m_nOrder + 1) {
                string = String.valueOf(string) + " + " + stringArray[n] + " * x^" + (n - 1);
                ++n;
            }
        }
        return string;
    }
}

