/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JPanel;
import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.Attr;
import oracle.dss.graph.pfj.BackgroundObj;
import oracle.dss.graph.pfj.JChart_Base;
import oracle.dss.graph.pfj.LookKeyObj;
import oracle.dss.graph.pfj.TDGNestedLabel;
import oracle.dss.graph.pfj.TDGProperties;
import oracle.dss.graph.pfj.TitleObj;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.draw.SelList;
import oracle.dss.graph.pfj.event.TDGErrorListener;
import oracle.dss.graph.pfj.event.TDGErrorManager;
import oracle.dss.graph.pfj.event.TDGEventManager;
import oracle.dss.graph.pfj.event.TDGListener;

public class PerspectiveBase
extends JPanel {
    protected static final int CALC_TO_BEGIN = 0;
    protected static final int CALC_COMPLETE = 1;
    protected static final int CALC_DONE_DRAW_IN_PROGRESS = 2;
    protected static final int CHART_COMPLETE = 3;
    public static final int MAX_EXCEPTIONAL_RISERS = 256;
    public static final int NUM_PRESET_SERIES = 64;
    protected transient BackgroundObj m_background = null;
    protected transient JChart_Base m_chart = null;
    protected transient TitleObj m_title = null;
    protected transient TitleObj m_subtitle = null;
    protected transient TitleObj m_footnote = null;
    protected TDGProperties m_look;
    private HashMap m_calcLook;
    protected TDGErrorManager m_ErrorManager;
    protected TDGEventManager m_EventManager;
    protected TDGNestedLabel m_O1LabelCallback;
    protected SelList m_selList;
    protected int m_nChartState = 0;
    protected Vector m_groupLabels = new Vector(100);
    protected Vector m_seriesLabels = new Vector(100);
    protected int[] m_seriesGradientEffect = new int[((Integer)Attr.SeriesLooping.getDefault()).intValue()];

    public PerspectiveBase() {
        int n = 0;
        while (n < this.m_seriesGradientEffect.length) {
            this.m_seriesGradientEffect[n] = 0;
            ++n;
        }
    }

    void sync3DPresetParameters(int n) {
    }

    Object getFromLook(Attr attr) {
        return this.getFromLook(attr, 0);
    }

    Object getFromLook(Attr attr, int n) {
        IdentObj identObj = this.m_selList.firstElement();
        if (this.m_selList.hasMoreElements()) {
            IdentObj identObj2;
            switch (n) {
                case 1: {
                    identObj2 = new IdentObj(-3, identObj.getSeriesID());
                    break;
                }
                case 2: {
                    identObj2 = new IdentObj(-3, -3, identObj.getGroupID());
                    break;
                }
                case 3: {
                    identObj2 = new IdentObj(-3, identObj.getSeriesID(), identObj.getGroupID());
                    break;
                }
                default: {
                    identObj2 = identObj;
                }
            }
            return this.getFromLook(identObj2, attr);
        }
        return attr.getDefault();
    }

    Object getFromLook(IdentObj identObj, Attr attr) {
        return this.getFromLook(identObj, attr, true);
    }

    Object getFromLook(IdentObj identObj, Attr attr, boolean bl) {
        Object v;
        LookKeyObj lookKeyObj = new LookKeyObj(attr, identObj);
        if (this.m_calcLook != null && (v = this.m_calcLook.get(lookKeyObj)) != null) {
            return v;
        }
        v = this.m_look.get(lookKeyObj);
        if (v != null) {
            return v;
        }
        lookKeyObj.setStackID(-3);
        lookKeyObj.setMiscID(-3);
        if (!identObj.isSERIES_NA() && !identObj.isGROUP_NA()) {
            lookKeyObj.setObjectID(-3);
            lookKeyObj.setSeriesID(identObj.getSeriesID());
            lookKeyObj.setGroupID(identObj.getGroupID());
            if (this.m_calcLook != null && (v = this.m_calcLook.get(lookKeyObj)) != null) {
                return v;
            }
            v = this.m_look.get(lookKeyObj);
            if (v != null) {
                return v;
            }
        }
        if (!identObj.isSERIES_NA()) {
            lookKeyObj.setObjectID(-3);
            lookKeyObj.setGroupID(-3);
            lookKeyObj.setSeriesID(identObj.getSeriesID());
            if (this.m_calcLook != null && (v = this.m_calcLook.get(lookKeyObj)) != null) {
                return v;
            }
            v = this.m_look.get(lookKeyObj);
            if (v != null) {
                return v;
            }
        }
        if (!identObj.isGROUP_NA()) {
            lookKeyObj.setObjectID(-3);
            lookKeyObj.setSeriesID(-3);
            lookKeyObj.setGroupID(identObj.getGroupID());
            if (this.m_calcLook != null && (v = this.m_calcLook.get(lookKeyObj)) != null) {
                return v;
            }
            v = this.m_look.get(lookKeyObj);
            if (v != null) {
                return v;
            }
        }
        if (!identObj.isOBJECT_NA()) {
            lookKeyObj.setObjectID(identObj.getObjectID());
            lookKeyObj.setGroupID(-3);
            lookKeyObj.setSeriesID(-3);
            if (this.m_calcLook != null && (v = this.m_calcLook.get(lookKeyObj)) != null) {
                return v;
            }
            v = this.m_look.get(lookKeyObj);
            if (v != null) {
                return v;
            }
        }
        if (bl) {
            return attr.getDefault();
        }
        return null;
    }

    protected void destroyCalcLook() {
        this.m_calcLook = null;
    }

    protected void putToLook(Attr attr, Object object) throws AssertionException {
        this.putToLook(attr, object, 0);
    }

    protected void putToLook(Attr attr, Object object, int n) throws AssertionException {
        IdentObj identObj = this.m_selList.firstElement();
        while (this.m_selList.hasMoreElements()) {
            IdentObj identObj2;
            switch (n) {
                case 1: {
                    identObj2 = new IdentObj(-3, identObj.getSeriesID());
                    break;
                }
                case 2: {
                    identObj2 = new IdentObj(-3, -3, identObj.getGroupID());
                    break;
                }
                case 3: {
                    identObj2 = new IdentObj(-3, identObj.getSeriesID(), identObj.getGroupID());
                    break;
                }
                default: {
                    identObj2 = identObj;
                }
            }
            this.putToLook(identObj2, attr, object);
            identObj = this.m_selList.nextElement();
        }
    }

    protected void putToLook(IdentObj identObj, Attr attr, Object object) throws AssertionException {
        if (attr == null) {
            return;
        }
        attr.rangeCheckIfPossible(object);
        this.m_look.put(new LookKeyObj(attr, identObj), object);
        this.m_nChartState = 0;
    }

    public void putToLookNoCalc(IdentObj identObj, Attr attr, Object object) {
        this.putToLookNoCalc(identObj, attr, object, false);
    }

    public void putToLookNoCalc(IdentObj identObj, Attr attr, Object object, boolean bl) {
        if (bl) {
            if (this.m_calcLook == null) {
                this.m_calcLook = new HashMap();
            }
            this.m_calcLook.put(new LookKeyObj(attr, identObj), object);
        } else {
            this.m_look.put(new LookKeyObj(attr, identObj), object);
        }
    }

    protected void putToLookAndRepaint(IdentObj identObj, Attr attr, Object object) throws AssertionException {
        this.putToLook(identObj, attr, object);
        if (!this.getManualRedraw()) {
            this.repaint();
        }
    }

    protected void putToLookAndRepaint(Attr attr, Object object) throws AssertionException {
        this.putToLookAndRepaint(attr, object, 0);
    }

    protected void putToLookAndRepaint(Attr attr, Object object, int n) throws AssertionException {
        this.putToLook(attr, object, n);
        if (!this.getManualRedraw()) {
            this.repaint();
        }
    }

    void removeFromLook(Attr attr) {
        this.removeFromLook(attr, 0);
    }

    void removeFromLook(Attr attr, int n) {
        IdentObj identObj = this.m_selList.firstElement();
        while (this.m_selList.hasMoreElements()) {
            IdentObj identObj2;
            switch (n) {
                case 1: {
                    identObj2 = new IdentObj(-3, identObj.getSeriesID());
                    break;
                }
                case 2: {
                    identObj2 = new IdentObj(-3, -3, identObj.getGroupID());
                    break;
                }
                case 3: {
                    identObj2 = new IdentObj(-3, identObj.getSeriesID(), identObj.getGroupID());
                    break;
                }
                default: {
                    identObj2 = identObj;
                }
            }
            this.removeFromLook(identObj2, attr);
            identObj = this.m_selList.nextElement();
        }
    }

    void removeFromLook(IdentObj identObj, Attr attr) {
        IdentObj identObj2;
        Object v = this.m_look.remove(new LookKeyObj(attr, identObj));
        if (v == null && !identObj.isSERIES_NA() && !identObj.isGROUP_NA()) {
            identObj2 = new IdentObj(-3, identObj.getSeriesID(), identObj.getGroupID());
            v = this.m_look.remove(new LookKeyObj(attr, identObj2));
        }
        if (v == null && !identObj.isSERIES_NA()) {
            identObj2 = new IdentObj(-3, identObj.getSeriesID());
            v = this.m_look.remove(new LookKeyObj(attr, identObj2));
        }
        if (v == null && !identObj.isGROUP_NA()) {
            identObj2 = new IdentObj(-3, -3, identObj.getGroupID());
            v = this.m_look.remove(new LookKeyObj(attr, identObj2));
        }
        if (v == null && !identObj.isOBJECT_NA()) {
            identObj2 = new IdentObj(identObj.getObjectID());
            v = this.m_look.remove(new LookKeyObj(attr, identObj2));
        }
    }

    void DeleteAttribute(int n, int n2, Attr attr) {
        IdentObj identObj = new IdentObj(-3, n, n2);
        this.removeFromLook(identObj, attr);
    }

    void DeleteAttribute(int n, Attr attr) {
        IdentObj identObj = new IdentObj(-3, n, -3);
        this.removeFromLook(identObj, attr);
    }

    void DeleteAttribute(Attr attr) {
        this.removeFromLook(attr);
    }

    void DeleteAttribute(IdentObj identObj, Attr attr) {
        this.removeFromLook(identObj, attr);
    }

    public boolean getManualRedraw() {
        Boolean bl = (Boolean)this.getFromLook(IdentObj.GLOBAL, Attr.ManualRedraw);
        return bl;
    }

    public void setManualRedraw(boolean bl) {
        if (bl) {
            this.putToLook(IdentObj.GLOBAL, Attr.ManualRedraw, new Boolean(bl));
        } else {
            this.putToLookAndRepaint(IdentObj.GLOBAL, Attr.ManualRedraw, new Boolean(bl));
        }
    }

    synchronized void init() {
    }

    static Attr GraphCategory_3D_Attr_Resolution(int n) {
        return null;
    }

    static Attr GraphCategory_BLA_Attr_Resolution(int n) {
        return null;
    }

    static Attr GraphCategory_PIE_Attr_Resolution(int n) {
        return null;
    }

    static Attr GraphCategory_SCATTER_Attr_Resolution(int n) {
        return null;
    }

    static Attr GraphCategory_HILO_Attr_Resolution(int n) {
        return null;
    }

    static Attr GraphCategory_MISC_Attr_Resolution(int n) {
        return null;
    }

    public boolean getUseOffScreen() {
        Boolean bl = (Boolean)this.getFromLook(IdentObj.GLOBAL, Attr.UseOffScreen);
        return bl;
    }

    public void setUseOffScreen(boolean bl) {
        this.putToLook(IdentObj.GLOBAL, Attr.UseOffScreen, new Boolean(bl));
    }

    public void addPerspectiveListener(TDGListener tDGListener) {
        this.m_EventManager.addPerspectiveListener(tDGListener);
    }

    public void removePerspectiveListener(TDGListener tDGListener) {
        this.m_EventManager.removePerspectiveListener(tDGListener);
    }

    public void addErrorListener(TDGErrorListener tDGErrorListener) {
        this.m_ErrorManager.addErrorListener(tDGErrorListener);
    }

    public void removeErrorListener(TDGErrorListener tDGErrorListener) {
        this.m_ErrorManager.removeErrorListener(tDGErrorListener);
    }

    public boolean getConnectLineMarkers() {
        Boolean bl = (Boolean)this.getFromLook(new IdentObj(2000), Attr.ConnectLineMarkers);
        return bl;
    }

    public void setConnectLineMarkers(boolean bl) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.ConnectLineMarkers, new Boolean(bl));
    }

    public boolean getConnectScatterMarkers() {
        Boolean bl = (Boolean)this.getFromLook(new IdentObj(2000), Attr.ConnectScatterMarkers);
        return bl;
    }

    public void setConnectScatterMarkers(boolean bl) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.ConnectScatterMarkers, new Boolean(bl));
    }

    public double getCubeFocusFactor() {
        Double d = (Double)this.getFromLook(new IdentObj(2000), Attr.CubeFocusFactor);
        return d;
    }

    public void setCubeFocusFactor(double d) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.CubeFocusFactor, new Double(d));
    }

    public void setO1LabelCallback(TDGNestedLabel tDGNestedLabel) {
        this.m_O1LabelCallback = tDGNestedLabel;
    }

    public TDGNestedLabel getO1LabelCallBack() {
        return this.m_O1LabelCallback;
    }

    public double getCubeSizeX() {
        Double d = (Double)this.getFromLook(new IdentObj(2000), Attr.CubeSizeX);
        return d;
    }

    public void setCubeSizeX(double d) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.CubeSizeX, new Double(d));
    }

    public double getCubeSizeY() {
        Double d = (Double)this.getFromLook(new IdentObj(2000), Attr.CubeSizeY);
        return d;
    }

    public void setCubeSizeY(double d) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.CubeSizeY, new Double(d));
    }

    public double getCubeSizeZ() {
        Double d = (Double)this.getFromLook(new IdentObj(2000), Attr.CubeSizeZ);
        return d;
    }

    public void setCubeSizeZ(double d) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.CubeSizeZ, new Double(d));
    }

    public double getCubeTranslationX() {
        Double d = (Double)this.getFromLook(new IdentObj(2000), Attr.CubeTranslationX);
        return d;
    }

    public void setCubeTranslationX(double d) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.CubeTranslationX, new Double(d));
    }

    public double getCubeTranslationY() {
        Double d = (Double)this.getFromLook(new IdentObj(2000), Attr.CubeTranslationY);
        return d;
    }

    public void setCubeTranslationY(double d) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.CubeTranslationY, new Double(d));
    }

    public double getCubeTranslationZ() {
        Double d = (Double)this.getFromLook(new IdentObj(2000), Attr.CubeTranslationZ);
        return d;
    }

    public void setCubeTranslationZ(double d) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.CubeTranslationZ, new Double(d));
    }

    public double getCubeViewerX() {
        Double d = (Double)this.getFromLook(new IdentObj(2000), Attr.CubeViewerX);
        return d;
    }

    public void setCubeViewerX(double d) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.CubeViewerX, new Double(d));
    }

    public double getCubeViewerY() {
        Double d = (Double)this.getFromLook(new IdentObj(2000), Attr.CubeViewerY);
        return d;
    }

    public void setCubeViewerY(double d) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.CubeViewerY, new Double(d));
    }

    public double getCubeViewerZ() {
        Double d = (Double)this.getFromLook(new IdentObj(2000), Attr.CubeViewerZ);
        return d;
    }

    public void setCubeViewerZ(double d) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.CubeViewerZ, new Double(d));
    }

    public boolean getCubeIsometricProjection() {
        Boolean bl = (Boolean)this.getFromLook(new IdentObj(2000), Attr.CubeIsometricProjection);
        return bl;
    }

    public void setCubeIsometricProjection(boolean bl) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.CubeIsometricProjection, new Boolean(bl));
    }

    public boolean getSquareMarkers() {
        Boolean bl = (Boolean)this.getFromLook(new IdentObj(2000), Attr.SquareMarkers);
        return bl;
    }

    public void setSquareMarkers(boolean bl) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.SquareMarkers, new Boolean(bl));
    }

    public boolean getCubeSquareRisers() {
        Boolean bl = (Boolean)this.getFromLook(new IdentObj(2000), Attr.CubeSquareRisers);
        return bl;
    }

    public void setCubeSquareRisers(boolean bl) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.CubeSquareRisers, new Boolean(bl));
    }

    public int getColorMode() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.ColorMode);
        return n;
    }

    public void setColorMode(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.ColorMode, new Integer(n));
    }

    public boolean getAutoshading() {
        Boolean bl = (Boolean)this.getFromLook(new IdentObj(2000), Attr.Autoshading);
        return bl;
    }

    public void setAutoshading(boolean bl) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.Autoshading, new Boolean(bl));
    }

    public double getCubeWallThickX() {
        Double d = (Double)this.getFromLook(new IdentObj(2000), Attr.CubeWallThickX);
        return d;
    }

    public void setCubeWallThickX(double d) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.CubeWallThickX, new Double(d));
    }

    public double getCubeWallThickY() {
        Double d = (Double)this.getFromLook(new IdentObj(2000), Attr.CubeWallThickY);
        return d;
    }

    public void setCubeWallThickY(double d) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.CubeWallThickY, new Double(d));
    }

    public double getCubeWallThickZ() {
        Double d = (Double)this.getFromLook(new IdentObj(2000), Attr.CubeWallThickZ);
        return d;
    }

    public void setCubeWallThickZ(double d) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.CubeWallThickZ, new Double(d));
    }

    public double getCubeZoomFactor() {
        Double d = (Double)this.getFromLook(new IdentObj(2000), Attr.CubeZoomFactor);
        return d;
    }

    public void setCubeZoomFactor(double d) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.CubeZoomFactor, new Double(d));
    }

    public boolean getDataItemsAlongSeries() {
        Boolean bl = (Boolean)this.getFromLook(new IdentObj(2000), Attr.DataItemsAlongSeries);
        return bl;
    }

    public void setDataItemsAlongSeries(boolean bl) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.DataItemsAlongSeries, new Boolean(bl));
    }

    public int getDataTextFormat() {
        return this.getTextFormatPreset(new IdentObj(2000));
    }

    public void setDataTextFormat(int n) {
        this.setTextFormatPreset(new IdentObj(2000), n);
    }

    public int getDataTextAngleDefault() {
        return this.getDataTextAngle(new IdentObj(2000));
    }

    public void setDataTextAngleDefault(int n) {
        this.setDataTextAngle(new IdentObj(2000), n);
    }

    public boolean getDataTextDisplay() {
        return this.getDisplay(new IdentObj(260));
    }

    public void setDataTextDisplay(boolean bl) {
        this.setDisplay(new IdentObj(260), bl);
    }

    public int getDataTextRadiusDefault() {
        return this.getDataTextRadius(new IdentObj(2000));
    }

    public void setDataTextRadiusDefault(int n) {
        this.setDataTextRadius(new IdentObj(2000), n);
    }

    public int getDepthAngle() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.DepthAngle);
        return n;
    }

    public void setDepthAngle(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.DepthAngle, new Integer(n));
    }

    public int getDepthRadius() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.DepthRadius);
        return n;
    }

    public void setDepthRadius(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.DepthRadius, new Integer(n));
    }

    public boolean getDisplay3DFloor() {
        return this.getDisplay(new IdentObj(514));
    }

    public void setDisplay3DFloor(boolean bl) {
        this.setDisplay(new IdentObj(514), bl);
    }

    public boolean getDisplay3DLeftWall() {
        return this.getDisplay(new IdentObj(515));
    }

    public void setDisplay3DLeftWall(boolean bl) {
        this.setDisplay(new IdentObj(515), bl);
    }

    public boolean getDisplay3DRightWall() {
        return this.getDisplay(new IdentObj(516));
    }

    public void setDisplay3DRightWall(boolean bl) {
        this.setDisplay(new IdentObj(516), bl);
    }

    public int getDualAxisSplitPosition() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.DualAxisSplitPosition);
        return n;
    }

    public void setDualAxisSplitPosition(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.DualAxisSplitPosition, new Integer(n));
    }

    public boolean getFootnoteAutofit() {
        return this.getAutofit(new IdentObj(3));
    }

    public void setFootnoteAutofit(boolean bl) {
        this.setAutofit(new IdentObj(3), bl);
    }

    public boolean getFootnoteDisplay() {
        return this.getDisplay(new IdentObj(3));
    }

    public void setFootnoteDisplay(boolean bl) {
        this.setDisplay(new IdentObj(3), bl);
    }

    public String getFootnoteString() {
        return this.getTextString(new IdentObj(3));
    }

    public void setFootnoteString(String string) {
        this.setTextString(new IdentObj(3), string);
        if (this.getCascade() && string.length() > 0) {
            this.setFootnoteDisplay(true);
        }
    }

    public boolean getFrameDisplay() {
        return this.getDisplay(new IdentObj(2));
    }

    public void setFrameDisplay(boolean bl) {
        this.setDisplay(new IdentObj(2), bl);
    }

    public boolean getGrid3DFloorDisplayX() {
        return this.getDisplay(new IdentObj(525));
    }

    public void setGrid3DFloorDisplayX(boolean bl) {
        this.setDisplay(new IdentObj(525), bl);
    }

    public boolean getGrid3DFloorDisplayZ() {
        return this.getDisplay(new IdentObj(526));
    }

    public void setGrid3DFloorDisplayZ(boolean bl) {
        this.setDisplay(new IdentObj(526), bl);
    }

    public boolean getGrid3DLeftWallDisplayY() {
        return this.getDisplay(new IdentObj(527));
    }

    public void setGrid3DLeftWallDisplayY(boolean bl) {
        this.setDisplay(new IdentObj(527), bl);
    }

    public boolean getGrid3DLeftWallDisplayZ() {
        return this.getDisplay(new IdentObj(528));
    }

    public void setGrid3DLeftWallDisplayZ(boolean bl) {
        this.setDisplay(new IdentObj(528), bl);
    }

    public boolean getGrid3DRightWallDisplayX() {
        return this.getDisplay(new IdentObj(529));
    }

    public void setGrid3DRightWallDisplayX(boolean bl) {
        this.setDisplay(new IdentObj(529), bl);
    }

    public boolean getGrid3DRightWallDisplayY() {
        return this.getDisplay(new IdentObj(530));
    }

    public void setGrid3DRightWallDisplayY(boolean bl) {
        this.setDisplay(new IdentObj(530), bl);
    }

    public boolean getGrid3DRiserDisplayX() {
        return this.getDisplay(new IdentObj(518));
    }

    public void setGrid3DRiserDisplayX(boolean bl) {
        this.setDisplay(new IdentObj(518), bl);
    }

    public boolean getGrid3DRiserDisplayY() {
        return this.getDisplay(new IdentObj(519));
    }

    public void setGrid3DRiserDisplayY(boolean bl) {
        this.setDisplay(new IdentObj(519), bl);
    }

    public boolean getGrid3DRiserDisplayZ() {
        return this.getDisplay(new IdentObj(520));
    }

    public void setGrid3DRiserDisplayZ(boolean bl) {
        this.setDisplay(new IdentObj(520), bl);
    }

    public boolean getLegendAutomatic() {
        Boolean bl = (Boolean)this.getFromLook(new IdentObj(2000), Attr.LegendAutomatic);
        return bl;
    }

    public void setLegendAutomatic(boolean bl) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.LegendAutomatic, new Boolean(bl));
    }

    public boolean getLegendDisplay() {
        return this.getDisplay(new IdentObj(12));
    }

    public void setLegendDisplay(boolean bl) {
        this.setDisplay(new IdentObj(12), bl);
    }

    public int getLegendMarkerPosition() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.LegendMarkerPosition);
        return n;
    }

    public void setLegendMarkerPosition(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.LegendMarkerPosition, new Integer(n));
    }

    public boolean getLegendTextAutofit() {
        return this.getAutofit(new IdentObj(14));
    }

    public void setLegendTextAutofit(boolean bl) {
        this.setAutofit(new IdentObj(14), bl);
    }

    public boolean getMarkerDisplay() {
        Boolean bl = (Boolean)this.getFromLook(new IdentObj(2000), Attr.MarkerDisplay);
        return bl;
    }

    public void setMarkerDisplay(boolean bl) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.MarkerDisplay, new Boolean(bl));
    }

    public int getMarkerSizeDefault() {
        return this.getMarkerSize(new IdentObj(2000));
    }

    public void setMarkerSizeDefault(int n) {
        this.setMarkerSize(new IdentObj(2000), n);
    }

    public int getO1AxisSide() {
        return this.getAxisSide(new IdentObj(2001));
    }

    public void setO1AxisSide(int n) {
        this.setAxisSide(new IdentObj(2001), n);
    }

    public boolean getO1ExcludeMaxLabel() {
        return this.getExcludeMaxLabel(this.getO1Label());
    }

    public void setO1ExcludeMaxLabel(boolean bl) {
        this.setExcludeMaxLabel(this.getO1Label(), bl);
    }

    public boolean getO1ExcludeMinLabel() {
        return this.getExcludeMinLabel(this.getO1Label());
    }

    public void setO1ExcludeMinLabel(boolean bl) {
        this.setExcludeMinLabel(this.getO1Label(), bl);
    }

    public boolean getO1LabelAutofit() {
        return this.getAutofit(this.getO1Label());
    }

    public void setO1LabelAutofit(boolean bl) {
        this.setAutofit(this.getO1Label(), bl);
    }

    public boolean getO1LabelDisplay() {
        return this.getDisplay(this.getO1Label());
    }

    public void setO1LabelDisplay(boolean bl) {
        this.setDisplay(this.getO1Label(), bl);
    }

    public boolean getO1LabelStagger() {
        return this.getLabelStagger(this.getO1Label());
    }

    public void setO1LabelStagger(boolean bl) {
        this.setLabelStagger(this.getO1Label(), bl);
    }

    public boolean getO1LabelWrap() {
        return this.getTextWrap(this.getO1Label());
    }

    public void setO1LabelWrap(boolean bl) {
        this.setTextWrap(this.getO1Label(), bl);
    }

    public boolean getO1MajorGridDisplay() {
        return this.getDisplay(new IdentObj(271));
    }

    public void setO1MajorGridDisplay(boolean bl) {
        this.setDisplay(new IdentObj(271), bl);
    }

    public int getO1MajorGridStyle() {
        return this.getGridStyle(new IdentObj(271));
    }

    public void setO1MajorGridStyle(int n) {
        this.setGridStyle(new IdentObj(271), n);
    }

    public boolean getO1MinorGridDisplay() {
        return this.getDisplay(new IdentObj(272));
    }

    public void setO1MinorGridDisplay(boolean bl) {
        this.setDisplay(new IdentObj(272), bl);
    }

    public int getO1MinorGridStyle() {
        return this.getGridStyle(new IdentObj(272));
    }

    public void setO1MinorGridStyle(int n) {
        this.setGridStyle(new IdentObj(272), n);
    }

    public boolean getO1TitleAutofit() {
        return this.getAutofit(new IdentObj(8));
    }

    public void setO1TitleAutofit(boolean bl) {
        this.setAutofit(new IdentObj(8), bl);
    }

    public boolean getO1TitleDisplay() {
        return this.getDisplay(new IdentObj(8));
    }

    public void setO1TitleDisplay(boolean bl) {
        this.setDisplay(new IdentObj(8), bl);
    }

    public String getO1TitleString() {
        return this.getTextString(new IdentObj(8));
    }

    public void setO1TitleString(String string) {
        this.setTextString(new IdentObj(8), string);
        if (this.getCascade() && string.length() > 0) {
            this.setO1TitleDisplay(true);
        }
    }

    public boolean getO2ExcludeMaxLabel() {
        return this.getExcludeMaxLabel(this.getO2Label());
    }

    public void setO2ExcludeMaxLabel(boolean bl) {
        this.setExcludeMaxLabel(this.getO2Label(), bl);
    }

    public boolean getO2ExcludeMinLabel() {
        return this.getExcludeMinLabel(this.getO2Label());
    }

    public void setO2ExcludeMinLabel(boolean bl) {
        this.setExcludeMinLabel(this.getO2Label(), bl);
    }

    public boolean getO2LabelAutofit() {
        return this.getAutofit(this.getO2Label());
    }

    public void setO2LabelAutofit(boolean bl) {
        this.setAutofit(this.getO2Label(), bl);
    }

    public boolean getO2LabelDisplay() {
        return this.getDisplay(this.getO2Label());
    }

    public void setO2LabelDisplay(boolean bl) {
        this.setDisplay(this.getO2Label(), bl);
    }

    public boolean getStockCloseTicksDisplay() {
        return this.getDisplay(new IdentObj(307));
    }

    public void setStockCloseTicksDisplay(boolean bl) {
        this.setDisplay(new IdentObj(307), bl);
    }

    public boolean getStockOpenTicksDisplay() {
        return this.getDisplay(new IdentObj(308));
    }

    public void setStockOpenTicksDisplay(boolean bl) {
        this.setDisplay(new IdentObj(308), bl);
    }

    public boolean getStockCloseSplitDisplay() {
        return this.getDisplay(new IdentObj(306));
    }

    public void setStockCloseSplitDisplay(boolean bl) {
        this.setDisplay(new IdentObj(306), bl);
    }

    public boolean getO2LabelWrap() {
        return this.getTextWrap(this.getO2Label());
    }

    public void setO2LabelWrap(boolean bl) {
        this.setTextWrap(this.getO2Label(), bl);
    }

    public boolean getO2TitleAutofit() {
        return this.getAutofit(new IdentObj(9));
    }

    public void setO2TitleAutofit(boolean bl) {
        this.setAutofit(new IdentObj(9), bl);
    }

    public boolean getO2TitleDisplay() {
        return this.getDisplay(new IdentObj(9));
    }

    public void setO2TitleDisplay(boolean bl) {
        this.setDisplay(new IdentObj(9), bl);
    }

    public String getO2TitleString() {
        return this.getTextString(new IdentObj(9));
    }

    public void setO2TitleString(String string) {
        this.setTextString(new IdentObj(9), string);
        if (this.getCascade() && string.length() > 0) {
            this.setO2TitleDisplay(true);
        }
    }

    public double getCubePanX() {
        Double d = (Double)this.getFromLook(new IdentObj(2000), Attr.CubePanX);
        return d;
    }

    public void setCubePanX(double d) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.CubePanX, new Double(d));
    }

    public double getCubePanY() {
        Double d = (Double)this.getFromLook(new IdentObj(2000), Attr.CubePanY);
        return d;
    }

    public void setCubePanY(double d) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.CubePanY, new Double(d));
    }

    public int getPieDepth() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.PieDepth);
        return n;
    }

    public void setPieDepth(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.PieDepth, new Integer(n));
    }

    public int getPieFeelerTextDisplay() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.PieFeelerTextDisplay);
        return n;
    }

    public void setPieFeelerTextDisplay(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.PieFeelerTextDisplay, new Integer(n));
    }

    public int getPieFeelerTextFormat() {
        return this.getTextFormatPreset(new IdentObj(295));
    }

    public void setPieFeelerTextFormat(int n) {
        this.setTextFormatPreset(new IdentObj(295), n);
    }

    public int getPieLabelDisplay() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.PieLabelDisplay);
        return n;
    }

    public void setPieLabelDisplay(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.PieLabelDisplay, new Integer(n));
    }

    public int getPieRingSize() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.PieRingSize);
        return n;
    }

    public void setPieRingSize(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.PieRingSize, new Integer(n));
    }

    public boolean getPieRingTotalDisplay() {
        return this.getDisplay(new IdentObj(297));
    }

    public void setPieRingTotalDisplay(boolean bl) {
        this.setDisplay(new IdentObj(297), bl);
    }

    public int getPieRotate() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.PieRotate);
        return n;
    }

    public void setPieRotate(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.PieRotate, new Integer(n));
    }

    public int getPiesPerRow() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.PiesPerRow);
        return n;
    }

    public void setPiesPerRow(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.PiesPerRow, new Integer(n));
    }

    public int getPieTilt() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.PieTilt);
        return n;
    }

    public void setPieTilt(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.PieTilt, new Integer(n));
    }

    public boolean getReshapeEnable() {
        Boolean bl = (Boolean)this.getFromLook(new IdentObj(2000), Attr.ReshapeEnable);
        return bl;
    }

    public void setReshapeEnable(boolean bl) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.ReshapeEnable, new Boolean(bl));
    }

    public boolean getResizeBarMode() {
        Boolean bl = (Boolean)this.getFromLook(new IdentObj(2000), Attr.ResizeBarMode);
        return bl;
    }

    public void setResizeBarMode(boolean bl) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.ResizeBarMode, new Boolean(bl));
    }

    public int getGridCount() {
        Integer n = (Integer)this.getFromLook(Attr.GridCount);
        return n;
    }

    public int getGridCount(IdentObj identObj) {
        Integer n = (Integer)this.getFromLook(identObj, Attr.GridCount);
        return n;
    }

    public int getGridCount(int n) {
        return this.getGridCount(new IdentObj(n));
    }

    public void setGridCount(int n) {
        this.putToLookAndRepaint(Attr.GridCount, new Integer(n));
    }

    public void setGridCount(IdentObj identObj, int n) {
        this.putToLookAndRepaint(identObj, Attr.GridCount, new Integer(n));
    }

    public void setGridCount(int n, int n2) {
        this.setGridCount(new IdentObj(n), n2);
    }

    public double getStock52WeekHighValue() {
        Double d = (Double)this.getFromLook(new IdentObj(2000), Attr.Stock52WeekHighValue);
        return d;
    }

    public void setStock52WeekHighValue(double d) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.Stock52WeekHighValue, new Double(d));
        if (this.getCascade()) {
            this.setStock52WeekHighDisplay(true);
        }
    }

    public boolean getReverseGroups() {
        Boolean bl = (Boolean)this.getFromLook(new IdentObj(2000), Attr.ReverseGroups);
        return bl;
    }

    public void setReverseGroups(boolean bl) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.ReverseGroups, new Boolean(bl));
    }

    public boolean getReverseSeries() {
        Boolean bl = (Boolean)this.getFromLook(new IdentObj(2000), Attr.ReverseSeries);
        return bl;
    }

    public void setReverseSeries(boolean bl) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.ReverseSeries, new Boolean(bl));
    }

    public int getRiser3DThicknessY() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.Riser3DThicknessY);
        return n;
    }

    public void setRiser3DThicknessY(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.Riser3DThicknessY, new Integer(n));
    }

    public int getRiserBarGroupSpacing() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.RiserBarGroupSpacing);
        return n;
    }

    public void setRiserBarGroupSpacing(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.RiserBarGroupSpacing, new Integer(n));
    }

    public int getRiserWidth() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.RiserWidth);
        return n;
    }

    public void setRiserWidth(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.RiserWidth, new Integer(n));
    }

    public boolean getScaleFromZero() {
        Boolean bl = (Boolean)this.getFromLook(new IdentObj(2000), Attr.ScaleFromZero);
        return bl;
    }

    public void setScaleFromZero(boolean bl) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.ScaleFromZero, new Boolean(bl));
    }

    public int getSelectionEnable() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.SelectionEnable);
        return n;
    }

    public void setSelectionEnable(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.SelectionEnable, new Integer(n));
    }

    public boolean getSelectionEnableMove() {
        Boolean bl = (Boolean)this.getFromLook(new IdentObj(2000), Attr.SelectionEnableMove);
        return bl;
    }

    public void setSelectionEnableMove(boolean bl) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.SelectionEnableMove, new Boolean(bl));
    }

    public int getShadowXOffsetDefault() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.ShadowXOffsetDefault);
        return n;
    }

    public void setShadowXOffsetDefault(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.ShadowXOffsetDefault, new Integer(n));
    }

    public int getShadowYOffsetDefault() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.ShadowYOffsetDefault);
        return n;
    }

    public void setShadowYOffsetDefault(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.ShadowYOffsetDefault, new Integer(n));
    }

    public boolean getStock52WeekHighDisplay() {
        return this.getDisplay(new IdentObj(304));
    }

    public void setStock52WeekHighDisplay(boolean bl) {
        this.setDisplay(new IdentObj(304), bl);
    }

    public boolean getStock52WeekLowDisplay() {
        return this.getDisplay(new IdentObj(305));
    }

    public void setStock52WeekLowDisplay(boolean bl) {
        this.setDisplay(new IdentObj(305), bl);
    }

    public boolean getStockMovingAverageDisplay() {
        return this.getDisplay(new IdentObj(309));
    }

    public void setStockMovingAverageDisplay(boolean bl) {
        this.setDisplay(new IdentObj(309), bl);
    }

    public int getStockTickLength() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.StockTickLength);
        return n;
    }

    public void setStockTickLength(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.StockTickLength, new Integer(n));
    }

    public boolean getSubtitleAutofit() {
        return this.getAutofit(new IdentObj(4));
    }

    public void setSubtitleAutofit(boolean bl) {
        this.setAutofit(new IdentObj(4), bl);
    }

    public boolean getSubtitleDisplay() {
        return this.getDisplay(new IdentObj(4));
    }

    public void setSubtitleDisplay(boolean bl) {
        this.setDisplay(new IdentObj(4), bl);
    }

    public String getSubtitleString() {
        return this.getTextString(new IdentObj(4));
    }

    public void setSubtitleString(String string) {
        this.setTextString(new IdentObj(4), string);
        if (this.getCascade() && string.length() > 0) {
            this.setSubtitleDisplay(true);
        }
    }

    public boolean getTitleAutofit() {
        return this.getAutofit(new IdentObj(5));
    }

    public void setTitleAutofit(boolean bl) {
        this.setAutofit(new IdentObj(5), bl);
    }

    public boolean getTitleDisplay() {
        return this.getDisplay(new IdentObj(5));
    }

    public void setTitleDisplay(boolean bl) {
        this.setDisplay(new IdentObj(5), bl);
    }

    public String getTitleString() {
        return this.getTextString(new IdentObj(5));
    }

    public void setTitleString(String string) {
        this.setTextString(new IdentObj(5), string);
        if (this.getCascade() && string.length() > 0) {
            this.setTitleDisplay(true);
        }
    }

    public boolean getToolTipDisplay() {
        Boolean bl = (Boolean)this.getFromLook(new IdentObj(2000), Attr.ToolTipDisplay);
        return bl;
    }

    public void setToolTipDisplay(boolean bl) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.ToolTipDisplay, new Boolean(bl));
    }

    public boolean getToolTipMode() {
        Boolean bl = (Boolean)this.getFromLook(new IdentObj(2000), Attr.ToolTipMode);
        return bl;
    }

    public void setToolTipMode(boolean bl) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.ToolTipMode, new Boolean(bl));
    }

    public boolean getUseSeriesShapes() {
        Boolean bl = (Boolean)this.getFromLook(new IdentObj(2000), Attr.UseSeriesShapes);
        return bl;
    }

    public void setUseSeriesShapes(boolean bl) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.UseSeriesShapes, new Boolean(bl));
    }

    public int getViewing3DAnglePreset() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.Viewing3DAnglePreset);
        return n;
    }

    public void setViewing3DAnglePreset(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.Viewing3DAnglePreset, new Integer(n));
        if (this.getCascade()) {
            this.sync3DPresetParameters(n);
        }
    }

    public boolean getX1AxisDescending() {
        return this.getAxisDescending(new IdentObj(2003));
    }

    public void setX1AxisDescending(boolean bl) {
        this.setAxisDescending(new IdentObj(2003), bl);
    }

    public int getX1AxisSide() {
        return this.getAxisSide(new IdentObj(2003));
    }

    public void setX1AxisSide(int n) {
        this.setAxisSide(new IdentObj(2003), n);
    }

    public boolean getX1OffScaleDisplay() {
        return this.getDisplayOffScale(new IdentObj(2003));
    }

    public void setX1OffScaleDisplay(boolean bl) {
        this.setDisplayOffScale(new IdentObj(2003), bl);
    }

    public boolean getX1ExcludeMaxLabel() {
        return this.getExcludeMaxLabel(new IdentObj(280));
    }

    public void setX1ExcludeMaxLabel(boolean bl) {
        this.setExcludeMaxLabel(new IdentObj(280), bl);
    }

    public boolean getX1ExcludeMinLabel() {
        return this.getExcludeMinLabel(new IdentObj(280));
    }

    public void setX1ExcludeMinLabel(boolean bl) {
        this.setExcludeMinLabel(new IdentObj(280), bl);
    }

    public boolean getX1LabelAutofit() {
        return this.getAutofit(new IdentObj(280));
    }

    public void setX1LabelAutofit(boolean bl) {
        this.setAutofit(new IdentObj(280), bl);
    }

    public boolean getY2TitleDisplay() {
        return this.getDisplay(new IdentObj(7));
    }

    public void setY2TitleDisplay(boolean bl) {
        this.setDisplay(new IdentObj(7), bl);
    }

    public boolean getX1LabelDisplay() {
        return this.getDisplay(new IdentObj(280));
    }

    public void setX1LabelDisplay(boolean bl) {
        this.setDisplay(new IdentObj(280), bl);
    }

    public int getX1LabelFormat() {
        return this.getTextFormatPreset(new IdentObj(280));
    }

    public void setX1LabelFormat(int n) {
        this.setTextFormatPreset(new IdentObj(280), n);
    }

    public boolean getX1LabelStagger() {
        return this.getLabelStagger(new IdentObj(280));
    }

    public void setX1LabelStagger(boolean bl) {
        this.setLabelStagger(new IdentObj(280), bl);
    }

    public boolean getX1LogScale() {
        return this.getLogScale(new IdentObj(2003));
    }

    public void setX1LogScale(boolean bl) {
        this.setLogScale(new IdentObj(2003), bl);
    }

    public boolean getX1MajorGridDisplay() {
        return this.getDisplay(new IdentObj(281));
    }

    public void setX1MajorGridDisplay(boolean bl) {
        this.setDisplay(new IdentObj(281), bl);
    }

    public double getX1MajorGridStep() {
        return this.getGridStep(new IdentObj(281));
    }

    public void setX1MajorGridStep(double d) {
        this.setGridStep(new IdentObj(281), d);
        if (this.getCascade()) {
            this.setX1MajorGridStepAuto(false);
        }
    }

    public boolean getX1MajorGridStepAuto() {
        return this.getGridStepAuto(new IdentObj(281));
    }

    public void setX1MajorGridStepAuto(boolean bl) {
        this.setGridStepAuto(new IdentObj(281), bl);
    }

    public int getX1MajorGridStyle() {
        return this.getGridStyle(new IdentObj(281));
    }

    public void setX1MajorGridStyle(int n) {
        this.setGridStyle(new IdentObj(281), n);
    }

    public boolean getX1MinorGridDisplay() {
        return this.getDisplay(new IdentObj(282));
    }

    public void setX1MinorGridDisplay(boolean bl) {
        this.setDisplay(new IdentObj(282), bl);
    }

    public double getX1MinorGridStep() {
        return this.getGridStep(new IdentObj(282));
    }

    public void setX1MinorGridStep(double d) {
        this.setGridStep(new IdentObj(282), d);
    }

    public boolean getX1MinorGridStepAuto() {
        return this.getGridStepAuto(new IdentObj(282));
    }

    public void setX1MinorGridStepAuto(boolean bl) {
        this.setGridStepAuto(new IdentObj(282), bl);
    }

    public int getX1MinorGridStyle() {
        return this.getGridStyle(new IdentObj(282));
    }

    public void setX1MinorGridStyle(int n) {
        this.setGridStyle(new IdentObj(282), n);
    }

    public boolean getX1MustIncludeZero() {
        if (this.getX1LogScale()) {
            return false;
        }
        return this.getScaleMustIncludeZero(new IdentObj(2003));
    }

    public void setX1MustIncludeZero(boolean bl) {
        this.setScaleMustIncludeZero(new IdentObj(2003), bl);
    }

    public double getX1ScaleMax() {
        return this.getScaleMax(new IdentObj(2003));
    }

    public void setX1ScaleMax(double d) {
        this.setScaleMax(new IdentObj(2003), d);
    }

    public boolean getX1ScaleMaxAuto() {
        return this.getScaleMaxAuto(new IdentObj(2003));
    }

    public void setX1ScaleMaxAuto(boolean bl) {
        this.setScaleMaxAuto(new IdentObj(2003), bl);
    }

    public double getX1ScaleMin() {
        return this.getScaleMin(new IdentObj(2003));
    }

    public void setX1ScaleMin(double d) {
        this.setScaleMin(new IdentObj(2003), d);
    }

    public boolean getX1ScaleMinAuto() {
        return this.getScaleMinAuto(new IdentObj(2003));
    }

    public void setX1ScaleMinAuto(boolean bl) {
        this.setScaleMinAuto(new IdentObj(2003), bl);
    }

    public boolean getX1TitleAutofit() {
        return this.getAutofit(new IdentObj(10));
    }

    public void setX1TitleAutofit(boolean bl) {
        this.setAutofit(new IdentObj(10), bl);
    }

    public boolean getX1TitleDisplay() {
        return this.getDisplay(new IdentObj(10));
    }

    public void setX1TitleDisplay(boolean bl) {
        this.setDisplay(new IdentObj(10), bl);
    }

    public String getX1TitleString() {
        return this.getTextString(new IdentObj(10));
    }

    public void setX1TitleString(String string) {
        this.setTextString(new IdentObj(10), string);
        if (this.getCascade() && string.length() > 0) {
            this.setX1TitleDisplay(true);
        }
    }

    public boolean getX1ZeroLineDisplay() {
        return this.getDisplay(new IdentObj(291));
    }

    public void setX1ZeroLineDisplay(boolean bl) {
        this.setDisplay(new IdentObj(291), bl);
    }

    public boolean getY1AxisDescending() {
        return this.getAxisDescending(new IdentObj(2004));
    }

    public void setY1AxisDescending(boolean bl) {
        this.setAxisDescending(new IdentObj(2004), bl);
    }

    public int getY1AxisSide() {
        return this.getAxisSide(new IdentObj(2004));
    }

    public void setY1AxisSide(int n) {
        this.setAxisSide(new IdentObj(2004), n);
    }

    public boolean getY1OffScaleDisplay() {
        return this.getDisplayOffScale(new IdentObj(2004));
    }

    public void setY1OffScaleDisplay(boolean bl) {
        this.setDisplayOffScale(new IdentObj(2004), bl);
    }

    public boolean getY1ExcludeMaxLabel() {
        return this.getExcludeMaxLabel(new IdentObj(284));
    }

    public void setY1ExcludeMaxLabel(boolean bl) {
        this.setExcludeMaxLabel(new IdentObj(284), bl);
    }

    public int getO1LabelAutoSkip() {
        return this.getAutoSkip(this.getO1Label());
    }

    public void setO1LabelAutoSkip(int n) {
        this.setAutoSkip(this.getO1Label(), n);
    }

    public int getO1LabelSkipCount() {
        return this.getSkipCount(this.getO1Label());
    }

    public void setO1LabelSkipCount(int n) {
        this.setSkipCount(this.getO1Label(), n);
    }

    public int getO1LabelSkipBegin() {
        return this.getSkipBegin(this.getO1Label());
    }

    public void setO1LabelSkipBegin(int n) {
        this.setSkipBegin(this.getO1Label(), n);
    }

    public int getAutoSkip() {
        Integer n = (Integer)this.getFromLook(Attr.AutoSkip);
        return n;
    }

    public int getAutoSkip(IdentObj identObj) {
        Integer n = (Integer)this.getFromLook(identObj, Attr.AutoSkip);
        return n;
    }

    public int getAutoSkip(int n) {
        return this.getAutoSkip(new IdentObj(n));
    }

    public void setAutoSkip(int n) {
        this.putToLookAndRepaint(Attr.AutoSkip, new Integer(n));
    }

    public void setAutoSkip(IdentObj identObj, int n) {
        this.putToLookAndRepaint(identObj, Attr.AutoSkip, new Integer(n));
    }

    public void setAutoSkip(int n, int n2) {
        this.setAutoSkip(new IdentObj(n), n2);
    }

    public int getSkipBegin() {
        Integer n = (Integer)this.getFromLook(Attr.SkipBegin);
        return n;
    }

    public int getSkipBegin(IdentObj identObj) {
        Integer n = (Integer)this.getFromLook(identObj, Attr.SkipBegin);
        return n;
    }

    public int getSkipBegin(int n) {
        return this.getSkipBegin(new IdentObj(n));
    }

    public void setSkipBegin(int n) {
        this.putToLookAndRepaint(Attr.SkipBegin, new Integer(n));
    }

    public void setSkipBegin(IdentObj identObj, int n) {
        this.putToLookAndRepaint(identObj, Attr.SkipBegin, new Integer(n));
    }

    public void setSkipBegin(int n, int n2) {
        this.setSkipBegin(new IdentObj(n), n2);
    }

    public int getSkipCount() {
        Integer n = (Integer)this.getFromLook(Attr.SkipCount);
        return n;
    }

    public int getSkipCount(IdentObj identObj) {
        Integer n = (Integer)this.getFromLook(identObj, Attr.SkipCount);
        return n;
    }

    public int getSkipCount(int n) {
        return this.getSkipCount(new IdentObj(n));
    }

    public void setSkipCount(int n) {
        this.putToLookAndRepaint(Attr.SkipCount, new Integer(n));
    }

    public void setSkipCount(IdentObj identObj, int n) {
        this.putToLookAndRepaint(identObj, Attr.SkipCount, new Integer(n));
    }

    public void setSkipCount(int n, int n2) {
        this.setSkipCount(new IdentObj(n), n2);
    }

    public boolean getExactColorByHeight() {
        Boolean bl = (Boolean)this.getFromLook(new IdentObj(2000), Attr.ExactColorByHeight);
        return bl;
    }

    public void setExactColorByHeight(boolean bl) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.ExactColorByHeight, new Boolean(bl));
    }

    public int getViewableSeries() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.ViewableSeries);
        return n;
    }

    public void setViewableSeries(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.ViewableSeries, new Integer(n));
    }

    public int getViewableGroups() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.ViewableGroups);
        return n;
    }

    public void setViewableGroups(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.ViewableGroups, new Integer(n));
    }

    public int getViewableSeriesStock() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.ViewableSeriesStock);
        return n;
    }

    public void setViewableSeriesStock(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.ViewableSeriesStock, new Integer(n));
    }

    public int getViewableGroupsStock() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.ViewableGroupsStock);
        return n;
    }

    public void setViewableGroupsStock(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.ViewableGroupsStock, new Integer(n));
    }

    public int getScrollOffsetSeries() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.ScrollOffsetSeries);
        return n;
    }

    public void setScrollOffsetSeries(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.ScrollOffsetSeries, new Integer(n));
    }

    public int getScrollOffsetGroup() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.ScrollOffsetGroup);
        return n;
    }

    public void setScrollOffsetGroup(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.ScrollOffsetGroup, new Integer(n));
    }

    public int getSeriesLooping() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.SeriesLooping);
        return n;
    }

    public void setSeriesLooping(int n) {
        if (n > this.m_seriesGradientEffect.length) {
            int[] nArray = this.m_seriesGradientEffect;
            this.m_seriesGradientEffect = new int[n];
            System.arraycopy(nArray, 0, this.m_seriesGradientEffect, 0, nArray.length);
            int n2 = nArray.length;
            while (n2 < this.m_seriesGradientEffect.length) {
                this.m_seriesGradientEffect[n2] = 0;
                ++n2;
            }
        }
        this.putToLookAndRepaint(new IdentObj(2000), Attr.SeriesLooping, new Integer(n));
    }

    public double getZoomPercentage() {
        Double d = (Double)this.getFromLook(new IdentObj(2000), Attr.ZoomPercentage);
        return d;
    }

    public void setZoomPercentage(double d) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.ZoomPercentage, new Double(d));
    }

    public int getRiserBorderMode() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.RiserBorderMode);
        return n;
    }

    public void setRiserBorderMode(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.RiserBorderMode, new Integer(n));
    }

    public boolean getOtherSeries() {
        Boolean bl = (Boolean)this.getFromLook(new IdentObj(2000), Attr.OtherSeries);
        return bl;
    }

    public void setOtherSeries(boolean bl) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.OtherSeries, new Boolean(bl));
    }

    public double getOtherPercentage() {
        Double d = (Double)this.getFromLook(new IdentObj(2000), Attr.OtherPercentage);
        return d;
    }

    public void setOtherPercentage(double d) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.OtherPercentage, new Double(d));
    }

    public int getCubeRiserInterpolation() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.CubeRiserInterpolation);
        return n;
    }

    public void setCubeRiserInterpolation(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.CubeRiserInterpolation, new Integer(n));
    }

    public boolean getOverdrawSkip() {
        Boolean bl = (Boolean)this.getFromLook(new IdentObj(2000), Attr.OverdrawSkip);
        return bl;
    }

    public void setOverdrawSkip(boolean bl) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.OverdrawSkip, new Boolean(bl));
    }

    public boolean getInterpretAsHLOC() {
        Boolean bl = (Boolean)this.getFromLook(new IdentObj(2000), Attr.InterpretAsHLOC);
        return bl;
    }

    public void setInterpretAsHLOC(boolean bl) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.InterpretAsHLOC, new Boolean(bl));
    }

    public boolean getUseSeriesBorderDefaults() {
        Boolean bl = (Boolean)this.getFromLook(new IdentObj(2000), Attr.UseSeriesBorderDefaults);
        return bl;
    }

    public void setUseSeriesBorderDefaults(boolean bl) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.UseSeriesBorderDefaults, new Boolean(bl));
    }

    public Color getSeriesDefaultBorderColor() {
        Color color = (Color)this.getFromLook(new IdentObj(2000), Attr.SeriesDefaultBorderColor);
        return color;
    }

    public void setSeriesDefaultBorderColor(Color color) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.SeriesDefaultBorderColor, color);
    }

    public boolean getSeriesDefaultTransparentBorderColor() {
        Boolean bl = (Boolean)this.getFromLook(new IdentObj(2000), Attr.SeriesDefaultTransparentBorderColor);
        return bl;
    }

    public void setSeriesDefaultTransparentBorderColor(boolean bl) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.SeriesDefaultTransparentBorderColor, new Boolean(bl));
    }

    public boolean getStackedDataValueSum() {
        Boolean bl = (Boolean)this.getFromLook(new IdentObj(2000), Attr.StackedDataValueSum);
        return bl;
    }

    public void setStackedDataValueSum(boolean bl) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.StackedDataValueSum, new Boolean(bl));
    }

    public int getValidGroupsMin() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.ValidGroupsMin);
        return n;
    }

    public void setValidGroupsMin(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.ValidGroupsMin, new Integer(n));
    }

    public int getValidSeriesMin() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.ValidSeriesMin);
        return n;
    }

    public void setValidSeriesMin(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.ValidSeriesMin, new Integer(n));
    }

    public int getCurveFitType() {
        Integer n = (Integer)this.getFromLook(Attr.CurveFitType, 1);
        return n;
    }

    public int getCurveFitType(IdentObj identObj) {
        Integer n = (Integer)this.getFromLook(identObj, Attr.CurveFitType);
        return n;
    }

    public int getCurveFitType(int n) {
        IdentObj identObj = new IdentObj(-3, n, -3);
        return this.getCurveFitType(identObj);
    }

    public void setCurveFitType(int n) {
        this.putToLookAndRepaint(Attr.CurveFitType, new Integer(n), 1);
    }

    public void setCurveFitType(IdentObj identObj, int n) {
        this.putToLookAndRepaint(identObj, Attr.CurveFitType, new Integer(n));
    }

    public void setCurveFitType(int n, int n2) {
        IdentObj identObj = new IdentObj(-3, n, -3);
        this.setCurveFitType(identObj, n2);
    }

    public int getCurveFitPolynomialOrder() {
        Integer n = (Integer)this.getFromLook(Attr.CurveFitPolynomialOrder, 1);
        return n;
    }

    public int getCurveFitPolynomialOrder(IdentObj identObj) {
        Integer n = (Integer)this.getFromLook(identObj, Attr.CurveFitPolynomialOrder);
        return n;
    }

    public int getCurveFitPolynomialOrder(int n) {
        IdentObj identObj = new IdentObj(-3, n, -3);
        return this.getCurveFitPolynomialOrder(identObj);
    }

    public void setCurveFitPolynomialOrder(int n) {
        this.putToLookAndRepaint(Attr.CurveFitPolynomialOrder, new Integer(n), 1);
    }

    public void setCurveFitPolynomialOrder(IdentObj identObj, int n) {
        this.putToLookAndRepaint(identObj, Attr.CurveFitPolynomialOrder, new Integer(n));
    }

    public void setCurveFitPolynomialOrder(int n, int n2) {
        IdentObj identObj = new IdentObj(-3, n, -3);
        this.setCurveFitPolynomialOrder(identObj, n2);
    }

    public int getCurveFitNumSegments() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.CurveFitNumSegments);
        return n;
    }

    public void setCurveFitNumSegments(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.CurveFitNumSegments, new Integer(n));
    }

    public boolean getCurveFitEquationDisplay() {
        return this.getDisplay(new IdentObj(42));
    }

    public void setCurveFitEquationDisplay(boolean bl) {
        this.setDisplay(new IdentObj(42), bl);
    }

    public boolean getCurveFitHighOrderFirst() {
        Boolean bl = (Boolean)this.getFromLook(new IdentObj(2000), Attr.CurveFitHighOrderFirst);
        return bl;
    }

    public void setCurveFitHighOrderFirst(boolean bl) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.CurveFitHighOrderFirst, new Boolean(bl));
    }

    public int getDeadZonePercent() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.DeadZonePercent);
        return n;
    }

    public void setDeadZonePercent(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.DeadZonePercent, new Integer(n));
    }

    public boolean getDisplaySystemConsoleMessages() {
        return this.getDisplay(new IdentObj(2000));
    }

    public void setDisplaySystemConsoleMessages(boolean bl) {
        this.setDisplay(new IdentObj(2000), bl);
    }

    public int getFillMissingData() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.FillMissingData);
        return n;
    }

    public void setFillMissingData(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.FillMissingData, new Integer(n));
    }

    public int getNumMissingDataSegments() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.NumMissingDataSegments);
        return n;
    }

    public void setNumMissingDataSegments(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.NumMissingDataSegments, new Integer(n));
    }

    public boolean getFontSizeAbsolute() {
        Boolean bl = (Boolean)this.getFromLook(Attr.FontSizeAbsolute);
        return bl;
    }

    public boolean getFontSizeAbsolute(IdentObj identObj) {
        Boolean bl = (Boolean)this.getFromLook(identObj, Attr.FontSizeAbsolute);
        return bl;
    }

    public boolean getFontSizeAbsolute(int n) {
        return this.getFontSizeAbsolute(new IdentObj(n));
    }

    public void setFontSizeAbsolute(boolean bl) {
        this.putToLookAndRepaint(Attr.FontSizeAbsolute, new Boolean(bl));
    }

    public void setFontSizeAbsolute(IdentObj identObj, boolean bl) {
        this.putToLookAndRepaint(identObj, Attr.FontSizeAbsolute, new Boolean(bl));
    }

    public void setFontSizeAbsolute(int n, boolean bl) {
        this.setFontSizeAbsolute(new IdentObj(n), bl);
    }

    public int getLegendSeriesStart() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.LegendSeriesStart);
        return n;
    }

    public void setLegendSeriesStart(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.LegendSeriesStart, new Integer(n));
    }

    public int getLegendSeriesCount() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.LegendSeriesCount);
        return n;
    }

    public void setLegendSeriesCount(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.LegendSeriesCount, new Integer(n));
    }

    public int getLegendMarkerSize() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.LegendMarkerSize);
        return n;
    }

    public void setLegendMarkerSize(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.LegendMarkerSize, new Integer(n));
    }

    public int getLegendMarkerSizeMax() {
        return 1000;
    }

    public void setLegendMarkerSizeMax(int n) {
    }

    public int getO1LabelAutoAngle() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.O1LabelAutoAngle);
        return n;
    }

    public void setO1LabelAutoAngle(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.O1LabelAutoAngle, new Integer(n));
    }

    public int getLegendScroll() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.LegendScroll);
        return n;
    }

    public void setLegendScroll(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.LegendScroll, new Integer(n));
    }

    public int getO2LabelAutoSkip() {
        return this.getAutoSkip(this.getO2Label());
    }

    public void setO2LabelAutoSkip(int n) {
        this.setAutoSkip(this.getO2Label(), n);
    }

    public int getO2LabelSkipCount() {
        return this.getSkipCount(this.getO2Label());
    }

    public void setO2LabelSkipCount(int n) {
        this.setSkipCount(this.getO2Label(), n);
    }

    public int getO2LabelSkipBegin() {
        return this.getSkipBegin(this.getO2Label());
    }

    public void setO2LabelSkipBegin(int n) {
        this.setSkipBegin(this.getO2Label(), n);
    }

    public boolean getY1ExcludeMinLabel() {
        return this.getExcludeMinLabel(new IdentObj(284));
    }

    public void setY1ExcludeMinLabel(boolean bl) {
        this.setExcludeMinLabel(new IdentObj(284), bl);
    }

    public boolean getY1LabelAutofit() {
        return this.getAutofit(new IdentObj(284));
    }

    public void setY1LabelAutofit(boolean bl) {
        this.setAutofit(new IdentObj(284), bl);
    }

    public boolean getY1LabelDisplay() {
        return this.getDisplay(new IdentObj(284));
    }

    public void setY1LabelDisplay(boolean bl) {
        this.setDisplay(new IdentObj(284), bl);
    }

    public int getY1LabelFormat() {
        return this.getTextFormatPreset(new IdentObj(284));
    }

    public void setY1LabelFormat(int n) {
        this.setTextFormatPreset(new IdentObj(284), n);
    }

    public boolean getY1LabelStagger() {
        return this.getLabelStagger(new IdentObj(284));
    }

    public void setY1LabelStagger(boolean bl) {
        this.setLabelStagger(new IdentObj(284), bl);
    }

    public boolean getY1LogScale() {
        return this.getLogScale(new IdentObj(2004));
    }

    public void setY1LogScale(boolean bl) {
        this.setLogScale(new IdentObj(2004), bl);
    }

    public boolean getY1MajorGridDisplay() {
        return this.getDisplay(new IdentObj(285));
    }

    public void setY1MajorGridDisplay(boolean bl) {
        this.setDisplay(new IdentObj(285), bl);
    }

    public double getY1MajorGridStep() {
        return this.getGridStep(new IdentObj(285));
    }

    public void setY1MajorGridStep(double d) {
        this.setGridStep(new IdentObj(285), d);
        if (this.getCascade()) {
            this.setY1MajorGridStepAuto(false);
        }
    }

    public boolean getY1MajorGridStepAuto() {
        return this.getGridStepAuto(new IdentObj(285));
    }

    public void setY1MajorGridStepAuto(boolean bl) {
        this.setGridStepAuto(new IdentObj(285), bl);
    }

    public int getY1MajorGridStyle() {
        return this.getGridStyle(new IdentObj(285));
    }

    public void setY1MajorGridStyle(int n) {
        this.setGridStyle(new IdentObj(285), n);
    }

    public boolean getY1MinorGridDisplay() {
        return this.getDisplay(new IdentObj(286));
    }

    public void setY1MinorGridDisplay(boolean bl) {
        this.setDisplay(new IdentObj(286), bl);
    }

    public double getY1MinorGridStep() {
        return this.getGridStep(new IdentObj(286));
    }

    public void setY1MinorGridStep(double d) {
        this.setGridStep(new IdentObj(286), d);
    }

    public boolean getY1MinorGridStepAuto() {
        return this.getGridStepAuto(new IdentObj(286));
    }

    public void setY1MinorGridStepAuto(boolean bl) {
        this.setGridStepAuto(new IdentObj(286), bl);
    }

    public int getY1MinorGridStyle() {
        return this.getGridStyle(new IdentObj(286));
    }

    public void setY1MinorGridStyle(int n) {
        this.setGridStyle(new IdentObj(286), n);
    }

    public boolean getY1MustIncludeZero() {
        if (this.getY1LogScale()) {
            return false;
        }
        return this.getScaleMustIncludeZero(new IdentObj(2004));
    }

    public void setY1MustIncludeZero(boolean bl) {
        this.setScaleMustIncludeZero(new IdentObj(2004), bl);
    }

    public double getY1ScaleMax() {
        return this.getScaleMax(new IdentObj(2004));
    }

    public void setY1ScaleMax(double d) {
        this.setScaleMax(new IdentObj(2004), d);
    }

    public boolean getY1ScaleMaxAuto() {
        return this.getScaleMaxAuto(new IdentObj(2004));
    }

    public void setY1ScaleMaxAuto(boolean bl) {
        this.setScaleMaxAuto(new IdentObj(2004), bl);
    }

    public double getY1ScaleMin() {
        return this.getScaleMin(new IdentObj(2004));
    }

    public void setY1ScaleMin(double d) {
        this.setScaleMin(new IdentObj(2004), d);
    }

    public boolean getY1ScaleMinAuto() {
        return this.getScaleMinAuto(new IdentObj(2004));
    }

    public void setY1ScaleMinAuto(boolean bl) {
        this.setScaleMinAuto(new IdentObj(2004), bl);
    }

    public boolean getY1TitleAutofit() {
        return this.getAutofit(new IdentObj(6));
    }

    public void setY1TitleAutofit(boolean bl) {
        this.setAutofit(new IdentObj(6), bl);
    }

    public boolean getY1TitleDisplay() {
        return this.getDisplay(new IdentObj(6));
    }

    public void setY1TitleDisplay(boolean bl) {
        this.setDisplay(new IdentObj(6), bl);
    }

    public String getY1TitleString() {
        return this.getTextString(new IdentObj(6));
    }

    public void setY1TitleString(String string) {
        this.setTextString(new IdentObj(6), string);
        if (this.getCascade() && string.length() > 0) {
            this.setY1TitleDisplay(true);
        }
    }

    public boolean getY1ZeroLineDisplay() {
        return this.getDisplay(new IdentObj(292));
    }

    public void setY1ZeroLineDisplay(boolean bl) {
        this.setDisplay(new IdentObj(292), bl);
    }

    public boolean getY2AxisDescending() {
        return this.getAxisDescending(new IdentObj(2005));
    }

    public void setY2AxisDescending(boolean bl) {
        this.setAxisDescending(new IdentObj(2005), bl);
    }

    public int getY2AxisSide() {
        return this.getAxisSide(new IdentObj(2005));
    }

    public void setY2AxisSide(int n) {
        this.setAxisSide(new IdentObj(2005), n);
    }

    public boolean getY2OffScaleDisplay() {
        return this.getDisplayOffScale(new IdentObj(2005));
    }

    public void setY2OffScaleDisplay(boolean bl) {
        this.setDisplayOffScale(new IdentObj(2005), bl);
    }

    public boolean getY2ExcludeMaxLabel() {
        return this.getExcludeMaxLabel(new IdentObj(288));
    }

    public void setY2ExcludeMaxLabel(boolean bl) {
        this.setExcludeMaxLabel(new IdentObj(288), bl);
    }

    public boolean getY2ExcludeMinLabel() {
        return this.getExcludeMinLabel(new IdentObj(288));
    }

    public void setY2ExcludeMinLabel(boolean bl) {
        this.setExcludeMinLabel(new IdentObj(288), bl);
    }

    public boolean getY2LabelAutofit() {
        return this.getAutofit(new IdentObj(288));
    }

    public void setY2LabelAutofit(boolean bl) {
        this.setAutofit(new IdentObj(288), bl);
    }

    public boolean getY2LabelDisplay() {
        return this.getDisplay(new IdentObj(288));
    }

    public void setY2LabelDisplay(boolean bl) {
        this.setDisplay(new IdentObj(288), bl);
    }

    public int getY2LabelFormat() {
        return this.getTextFormatPreset(new IdentObj(288));
    }

    public void setY2LabelFormat(int n) {
        this.setTextFormatPreset(new IdentObj(288), n);
    }

    public boolean getY2LabelStagger() {
        return this.getLabelStagger(new IdentObj(288));
    }

    public void setY2LabelStagger(boolean bl) {
        this.setLabelStagger(new IdentObj(288), bl);
    }

    public boolean getY2LogScale() {
        return this.getLogScale(new IdentObj(2005));
    }

    public void setY2LogScale(boolean bl) {
        this.setLogScale(new IdentObj(2005), bl);
    }

    public boolean getY2MajorGridDisplay() {
        return this.getDisplay(new IdentObj(289));
    }

    public void setY2MajorGridDisplay(boolean bl) {
        this.setDisplay(new IdentObj(289), bl);
    }

    public double getY2MajorGridStep() {
        return this.getGridStep(new IdentObj(289));
    }

    public void setY2MajorGridStep(double d) {
        this.setGridStep(new IdentObj(289), d);
        if (this.getCascade()) {
            this.setY2MajorGridStepAuto(false);
        }
    }

    public boolean getY2MajorGridStepAuto() {
        return this.getGridStepAuto(new IdentObj(289));
    }

    public void setY2MajorGridStepAuto(boolean bl) {
        this.setGridStepAuto(new IdentObj(289), bl);
    }

    public int getY2MajorGridStyle() {
        return this.getGridStyle(new IdentObj(289));
    }

    public void setY2MajorGridStyle(int n) {
        this.setGridStyle(new IdentObj(289), n);
    }

    public boolean getY2MinorGridDisplay() {
        return this.getDisplay(new IdentObj(290));
    }

    public void setY2MinorGridDisplay(boolean bl) {
        this.setDisplay(new IdentObj(290), bl);
    }

    public double getY2MinorGridStep() {
        return this.getGridStep(new IdentObj(290));
    }

    public void setY2MinorGridStep(double d) {
        this.setGridStep(new IdentObj(290), d);
    }

    public boolean getY2MinorGridStepAuto() {
        return this.getGridStepAuto(new IdentObj(290));
    }

    public void setY2MinorGridStepAuto(boolean bl) {
        this.setGridStepAuto(new IdentObj(290), bl);
    }

    public int getY2MinorGridStyle() {
        return this.getGridStyle(new IdentObj(290));
    }

    public void setY2MinorGridStyle(int n) {
        this.setGridStyle(new IdentObj(290), n);
    }

    public boolean getY2MustIncludeZero() {
        if (this.getY2LogScale()) {
            return false;
        }
        return this.getScaleMustIncludeZero(new IdentObj(2005));
    }

    public void setY2MustIncludeZero(boolean bl) {
        this.setScaleMustIncludeZero(new IdentObj(2005), bl);
    }

    public double getY2ScaleMax() {
        return this.getScaleMax(new IdentObj(2005));
    }

    public void setY2ScaleMax(double d) {
        this.setScaleMax(new IdentObj(2005), d);
    }

    public boolean getY2ScaleMaxAuto() {
        return this.getScaleMaxAuto(new IdentObj(2005));
    }

    public void setY2ScaleMaxAuto(boolean bl) {
        this.setScaleMaxAuto(new IdentObj(2005), bl);
    }

    public double getY2ScaleMin() {
        return this.getScaleMin(new IdentObj(2005));
    }

    public void setY2ScaleMin(double d) {
        this.setScaleMin(new IdentObj(2005), d);
    }

    public boolean getY2ScaleMinAuto() {
        return this.getScaleMinAuto(new IdentObj(2005));
    }

    public void setY2ScaleMinAuto(boolean bl) {
        this.setScaleMinAuto(new IdentObj(2005), bl);
    }

    public boolean getY2TitleAutofit() {
        return this.getAutofit(new IdentObj(7));
    }

    public void setY2TitleAutofit(boolean bl) {
        this.setAutofit(new IdentObj(7), bl);
    }

    public int getAxisAssignment() {
        Integer n = (Integer)this.getFromLook(Attr.AxisAssignment, 1);
        return n;
    }

    public int getAxisAssignment(IdentObj identObj) {
        Attr attr = Attr.AxisAssignment;
        if (identObj.getObjectID() == -3 && identObj.getSeriesID() == 1) {
            attr = Attr.AxisAssignmentY2;
        }
        Integer n = (Integer)this.getFromLook(identObj, attr);
        return n;
    }

    public int getAxisAssignment(int n) {
        IdentObj identObj = new IdentObj(-3, n, -3);
        return this.getAxisAssignment(identObj);
    }

    public void setAxisAssignment(int n) {
        this.putToLookAndRepaint(Attr.AxisAssignment, new Integer(n), 1);
    }

    public void setAxisAssignment(IdentObj identObj, int n) {
        Attr attr = Attr.AxisAssignment;
        if (identObj.getObjectID() == -3 && identObj.getSeriesID() == 1) {
            attr = Attr.AxisAssignmentY2;
        }
        this.putToLookAndRepaint(identObj, attr, new Integer(n));
    }

    public void setAxisAssignment(int n, int n2) {
        IdentObj identObj = new IdentObj(-3, n, -3);
        this.setAxisAssignment(identObj, n2);
    }

    public boolean getAutofit() {
        Boolean bl = (Boolean)this.getFromLook(Attr.Autofit);
        return bl;
    }

    public boolean getAutofit(IdentObj identObj) {
        Attr attr = Attr.Autofit;
        if (identObj.getObjectID() == 297) {
            attr = Attr.PieRingLabelAutofit;
        }
        Boolean bl = (Boolean)this.getFromLook(identObj, attr);
        return bl;
    }

    public boolean getAutofit(int n) {
        return this.getAutofit(new IdentObj(n));
    }

    public void setAutofit(boolean bl) {
        this.putToLookAndRepaint(Attr.Autofit, new Boolean(bl));
    }

    public void setAutofit(IdentObj identObj, boolean bl) {
        Attr attr = Attr.Autofit;
        if (identObj.getObjectID() == 297) {
            attr = Attr.PieRingLabelAutofit;
        }
        this.putToLookAndRepaint(identObj, attr, new Boolean(bl));
    }

    public void setAutofit(int n, boolean bl) {
        this.setAutofit(new IdentObj(n), bl);
    }

    public int getO1MinorGridCount() {
        return this.getGridCount(new IdentObj(272));
    }

    public void setO1MinorGridCount(int n) {
        this.setGridCount(new IdentObj(272), n);
    }

    public int getDataTextPosition() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.DataTextPosition);
        return n;
    }

    public void setDataTextPosition(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.DataTextPosition, new Integer(n));
    }

    public int getPieRingTotalFormat() {
        return this.getTextFormatPreset(new IdentObj(297));
    }

    public void setPieRingTotalFormat(int n) {
        this.setTextFormatPreset(new IdentObj(297), n);
    }

    public boolean getX1AxisLineDisplay() {
        return this.getDisplay(new IdentObj(279));
    }

    public void setX1AxisLineDisplay(boolean bl) {
        this.setDisplay(new IdentObj(279), bl);
    }

    public boolean getY1AxisLineDisplay() {
        return this.getDisplay(new IdentObj(283));
    }

    public void setY1AxisLineDisplay(boolean bl) {
        this.setDisplay(new IdentObj(283), bl);
    }

    public boolean getY2AxisLineDisplay() {
        return this.getDisplay(new IdentObj(287));
    }

    public void setY2AxisLineDisplay(boolean bl) {
        this.setDisplay(new IdentObj(287), bl);
    }

    public boolean getO1AxisLineDisplay() {
        return this.getDisplay(new IdentObj(269));
    }

    public void setO1AxisLineDisplay(boolean bl) {
        this.setDisplay(new IdentObj(269), bl);
    }

    public boolean getDualAxisLineDisplay() {
        return this.getDisplay(new IdentObj(17));
    }

    public void setDualAxisLineDisplay(boolean bl) {
        this.setDisplay(new IdentObj(17), bl);
    }

    public double getStock52WeekLowValue() {
        Double d = (Double)this.getFromLook(new IdentObj(2000), Attr.Stock52WeekLowValue);
        return d;
    }

    public void setStock52WeekLowValue(double d) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.Stock52WeekLowValue, new Double(d));
        if (this.getCascade()) {
            this.setStock52WeekLowDisplay(true);
        }
    }

    public double getNumPieArcSegmentsPerPixel() {
        Double d = (Double)this.getFromLook(new IdentObj(2000), Attr.NumPieArcSegmentsPerPixel);
        return d;
    }

    public void setNumPieArcSegmentsPerPixel(double d) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.NumPieArcSegmentsPerPixel, new Double(d));
    }

    public boolean getAxisDescending() {
        Boolean bl = (Boolean)this.getFromLook(Attr.AxisDescending);
        return bl;
    }

    public boolean getAxisDescending(IdentObj identObj) {
        Boolean bl = (Boolean)this.getFromLook(identObj, Attr.AxisDescending);
        return bl;
    }

    public boolean getAxisDescending(int n) {
        return this.getAxisDescending(new IdentObj(n));
    }

    public void setAxisDescending(boolean bl) {
        this.putToLookAndRepaint(Attr.AxisDescending, new Boolean(bl));
    }

    public void setAxisDescending(IdentObj identObj, boolean bl) {
        this.putToLookAndRepaint(identObj, Attr.AxisDescending, new Boolean(bl));
    }

    public void setAxisDescending(int n, boolean bl) {
        this.setAxisDescending(new IdentObj(n), bl);
    }

    public int getAxisSide() {
        Integer n = (Integer)this.getFromLook(Attr.AxisSide);
        return n;
    }

    public int getAxisSide(IdentObj identObj) {
        Attr attr = Attr.AxisSide;
        if (identObj.getObjectID() == 2005 || identObj.getObjectID() == 2013) {
            attr = Attr.Y2AxisSide;
        }
        Integer n = (Integer)this.getFromLook(identObj, attr);
        return n;
    }

    public int getAxisSide(int n) {
        return this.getAxisSide(new IdentObj(n));
    }

    public void setAxisSide(int n) {
        this.putToLookAndRepaint(Attr.AxisSide, new Integer(n));
    }

    public void setAxisSide(IdentObj identObj, int n) {
        Attr attr = Attr.AxisSide;
        if (identObj.getObjectID() == 2005 || identObj.getObjectID() == 2013) {
            attr = Attr.Y2AxisSide;
        }
        this.putToLookAndRepaint(identObj, attr, new Integer(n));
    }

    public void setAxisSide(int n, int n2) {
        this.setAxisSide(new IdentObj(n), n2);
    }

    public int getDataTextAngle() {
        Integer n = (Integer)this.getFromLook(Attr.DataTextAngle, 3);
        return n;
    }

    public int getDataTextAngle(IdentObj identObj) {
        Integer n = (Integer)this.getFromLook(identObj, Attr.DataTextAngle);
        return n;
    }

    public int getDataTextAngle(int n) {
        IdentObj identObj = new IdentObj(-3, n, -3);
        Integer n2 = (Integer)this.getFromLook(identObj, Attr.DataTextAngle, false);
        if (n2 != null) {
            return n2;
        }
        return this.getDataTextAngleDefault();
    }

    public int getDataTextAngle(int n, int n2) {
        IdentObj identObj = new IdentObj(-3, n, n2);
        Integer n3 = (Integer)this.getFromLook(identObj, Attr.DataTextAngle, false);
        if (n3 != null) {
            return n3;
        }
        return this.getDataTextAngle(n);
    }

    public void setDataTextAngle(int n) {
        this.putToLookAndRepaint(Attr.DataTextAngle, new Integer(n), 3);
    }

    public void setDataTextAngle(IdentObj identObj, int n) {
        this.putToLookAndRepaint(identObj, Attr.DataTextAngle, new Integer(n));
    }

    public void setDataTextAngle(int n, int n2) {
        IdentObj identObj = new IdentObj(-3, n, -3);
        this.setDataTextAngle(identObj, n2);
    }

    public void setDataTextAngle(int n, int n2, int n3) {
        IdentObj identObj = new IdentObj(-3, n, n2);
        this.setDataTextAngle(identObj, n3);
    }

    public int getDataTextRadius() {
        Integer n = (Integer)this.getFromLook(Attr.DataTextRadius, 3);
        return n;
    }

    public int getDataTextRadius(IdentObj identObj) {
        Integer n = (Integer)this.getFromLook(identObj, Attr.DataTextRadius);
        return n;
    }

    public int getDataTextRadius(int n) {
        IdentObj identObj = new IdentObj(-3, n, -3);
        Integer n2 = (Integer)this.getFromLook(identObj, Attr.DataTextRadius, false);
        if (n2 != null) {
            return n2;
        }
        return this.getDataTextRadiusDefault();
    }

    public int getDataTextRadius(int n, int n2) {
        IdentObj identObj = new IdentObj(-3, n, n2);
        Integer n3 = (Integer)this.getFromLook(identObj, Attr.DataTextRadius, false);
        if (n3 != null) {
            return n3;
        }
        return this.getDataTextRadius(n);
    }

    public void setDataTextRadius(int n) {
        this.putToLookAndRepaint(Attr.DataTextRadius, new Integer(n), 3);
    }

    public void setDataTextRadius(IdentObj identObj, int n) {
        this.putToLookAndRepaint(identObj, Attr.DataTextRadius, new Integer(n));
    }

    public void setDataTextRadius(int n, int n2) {
        IdentObj identObj = new IdentObj(-3, n, -3);
        this.setDataTextRadius(identObj, n2);
    }

    public void setDataTextRadius(int n, int n2, int n3) {
        IdentObj identObj = new IdentObj(-3, n, n2);
        this.setDataTextRadius(identObj, n3);
    }

    public boolean getDisplay() {
        Boolean bl = (Boolean)this.getFromLook(Attr.Display);
        return bl;
    }

    public boolean getDisplay(IdentObj identObj) {
        Attr attr = Attr.Display;
        switch (identObj.getObjectID()) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 40: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 235: 
            case 260: 
            case 271: 
            case 272: 
            case 276: 
            case 282: 
            case 286: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 304: 
            case 305: 
            case 309: 
            case 329: 
            case 518: 
            case 519: 
            case 520: 
            case 525: 
            case 526: 
            case 527: 
            case 528: 
            case 529: 
            case 530: {
                attr = Attr.NoDisplay;
                break;
            }
            case 306: {
                attr = Attr.StockCloseSplitDisplay;
            }
        }
        Boolean bl = (Boolean)this.getFromLook(identObj, attr);
        return bl;
    }

    public boolean getDisplay(int n) {
        return this.getDisplay(new IdentObj(n));
    }

    public void setDisplay(boolean bl) {
        this.putToLookAndRepaint(Attr.Display, new Boolean(bl));
    }

    public void setDisplay(IdentObj identObj, boolean bl) {
        Attr attr = Attr.Display;
        switch (identObj.getObjectID()) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 40: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 235: 
            case 260: 
            case 271: 
            case 272: 
            case 276: 
            case 282: 
            case 286: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 304: 
            case 305: 
            case 309: 
            case 329: 
            case 518: 
            case 519: 
            case 520: 
            case 525: 
            case 526: 
            case 527: 
            case 528: 
            case 529: 
            case 530: {
                attr = Attr.NoDisplay;
                break;
            }
            case 306: {
                attr = Attr.StockCloseSplitDisplay;
            }
        }
        this.putToLookAndRepaint(identObj, attr, new Boolean(bl));
    }

    public void setDisplay(int n, boolean bl) {
        this.setDisplay(new IdentObj(n), bl);
    }

    public boolean getDisplayOffScale() {
        Boolean bl = (Boolean)this.getFromLook(Attr.DisplayOffScale);
        return bl;
    }

    public boolean getDisplayOffScale(IdentObj identObj) {
        Boolean bl = (Boolean)this.getFromLook(identObj, Attr.DisplayOffScale);
        return bl;
    }

    public boolean getDisplayOffScale(int n) {
        return this.getDisplayOffScale(new IdentObj(n));
    }

    public void setDisplayOffScale(boolean bl) {
        this.putToLookAndRepaint(Attr.DisplayOffScale, new Boolean(bl));
    }

    public void setDisplayOffScale(IdentObj identObj, boolean bl) {
        this.putToLookAndRepaint(identObj, Attr.DisplayOffScale, new Boolean(bl));
    }

    public void setDisplayOffScale(int n, boolean bl) {
        this.setDisplayOffScale(new IdentObj(n), bl);
    }

    public boolean getExcludeMaxLabel() {
        Boolean bl = (Boolean)this.getFromLook(Attr.ExcludeMaxLabel);
        return bl;
    }

    public boolean getExcludeMaxLabel(IdentObj identObj) {
        Boolean bl = (Boolean)this.getFromLook(identObj, Attr.ExcludeMaxLabel);
        return bl;
    }

    public boolean getExcludeMaxLabel(int n) {
        return this.getExcludeMaxLabel(new IdentObj(n));
    }

    public void setExcludeMaxLabel(boolean bl) {
        this.putToLookAndRepaint(Attr.ExcludeMaxLabel, new Boolean(bl));
    }

    public void setExcludeMaxLabel(IdentObj identObj, boolean bl) {
        this.putToLookAndRepaint(identObj, Attr.ExcludeMaxLabel, new Boolean(bl));
    }

    public void setExcludeMaxLabel(int n, boolean bl) {
        this.setExcludeMaxLabel(new IdentObj(n), bl);
    }

    public boolean getExcludeMinLabel() {
        Boolean bl = (Boolean)this.getFromLook(Attr.ExcludeMinLabel);
        return bl;
    }

    public boolean getExcludeMinLabel(IdentObj identObj) {
        Boolean bl = (Boolean)this.getFromLook(identObj, Attr.ExcludeMinLabel);
        return bl;
    }

    public boolean getExcludeMinLabel(int n) {
        return this.getExcludeMinLabel(new IdentObj(n));
    }

    public void setExcludeMinLabel(boolean bl) {
        this.putToLookAndRepaint(Attr.ExcludeMinLabel, new Boolean(bl));
    }

    public void setExcludeMinLabel(IdentObj identObj, boolean bl) {
        this.putToLookAndRepaint(identObj, Attr.ExcludeMinLabel, new Boolean(bl));
    }

    public void setExcludeMinLabel(int n, boolean bl) {
        this.setExcludeMinLabel(new IdentObj(n), bl);
    }

    public String getFontName() {
        String string = (String)this.getFromLook(Attr.FontName);
        return string;
    }

    public String getFontName(IdentObj identObj) {
        String string = (String)this.getFromLook(identObj, Attr.FontName);
        return string;
    }

    public String getFontName(int n) {
        return this.getFontName(new IdentObj(n));
    }

    public void setFontName(String string) {
        this.putToLookAndRepaint(Attr.FontName, string);
    }

    public void setFontName(IdentObj identObj, String string) {
        this.putToLookAndRepaint(identObj, Attr.FontName, string);
    }

    public void setFontName(int n, String string) {
        this.setFontName(new IdentObj(n), string);
    }

    public int getFontSizeVC() {
        Integer n = (Integer)this.getFromLook(Attr.FontSizeVC);
        return n;
    }

    public int getFontSizeVC(IdentObj identObj) {
        Attr attr = Attr.FontSizeVC;
        switch (identObj.getObjectID()) {
            case 3: 
            case 4: 
            case 14: 
            case 235: 
            case 270: 
            case 274: 
            case 280: 
            case 284: 
            case 288: 
            case 295: 
            case 296: 
            case 441: 
            case 446: 
            case 451: {
                attr = Attr.LabelFontSizeVC;
                break;
            }
            case 5: 
            case 297: {
                attr = Attr.TitleFontSizeVC;
            }
        }
        Integer n = (Integer)this.getFromLook(identObj, attr);
        return n;
    }

    public int getFontSizeVC(int n) {
        return this.getFontSizeVC(new IdentObj(n));
    }

    public void setFontSizeVC(int n) {
        this.putToLookAndRepaint(Attr.FontSizeVC, new Integer(n));
    }

    public void setFontSizeVC(IdentObj identObj, int n) {
        Attr attr = Attr.FontSizeVC;
        switch (identObj.getObjectID()) {
            case 3: 
            case 4: 
            case 14: 
            case 235: 
            case 270: 
            case 274: 
            case 280: 
            case 284: 
            case 288: 
            case 295: 
            case 296: 
            case 441: 
            case 446: 
            case 451: {
                attr = Attr.LabelFontSizeVC;
                break;
            }
            case 5: 
            case 297: {
                attr = Attr.TitleFontSizeVC;
            }
        }
        this.putToLookAndRepaint(identObj, attr, new Integer(n));
    }

    public void setFontSizeVC(int n, int n2) {
        this.setFontSizeVC(new IdentObj(n), n2);
    }

    public int getFontStyle() {
        Integer n = (Integer)this.getFromLook(Attr.FontStyle);
        return n;
    }

    public int getFontStyle(IdentObj identObj) {
        Attr attr = Attr.FontStyle;
        switch (identObj.getObjectID()) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 260: {
                attr = Attr.TitleFontStyle;
                break;
            }
            case 232: 
            case 233: 
            case 235: {
                attr = Attr.DrillLabelFontStyle;
            }
        }
        Integer n = (Integer)this.getFromLook(identObj, attr);
        return n;
    }

    public int getFontStyle(int n) {
        return this.getFontStyle(new IdentObj(n));
    }

    public void setFontStyle(int n) {
        this.putToLookAndRepaint(Attr.FontStyle, new Integer(n));
    }

    public void setFontStyle(IdentObj identObj, int n) {
        Attr attr = Attr.FontStyle;
        switch (identObj.getObjectID()) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 260: {
                attr = Attr.TitleFontStyle;
                break;
            }
            case 232: 
            case 233: 
            case 235: {
                attr = Attr.DrillLabelFontStyle;
            }
        }
        this.putToLookAndRepaint(identObj, attr, new Integer(n));
    }

    public void setFontStyle(int n, int n2) {
        this.setFontStyle(new IdentObj(n), n2);
    }

    public double getMinAutoGridStep() {
        Double d = (Double)this.getFromLook(Attr.MinAutoGridStep);
        return d;
    }

    public double getMinAutoGridStep(IdentObj identObj) {
        Double d = (Double)this.getFromLook(identObj, Attr.MinAutoGridStep);
        return d;
    }

    public double getMinAutoGridStep(int n) {
        return this.getMinAutoGridStep(new IdentObj(n));
    }

    public void setMinAutoGridStep(double d) {
        this.putToLookAndRepaint(Attr.MinAutoGridStep, new Double(d));
    }

    public void setMinAutoGridStep(IdentObj identObj, double d) {
        this.putToLookAndRepaint(identObj, Attr.MinAutoGridStep, new Double(d));
    }

    public void setMinAutoGridStep(int n, double d) {
        this.setMinAutoGridStep(new IdentObj(n), d);
    }

    public double getGridStep() {
        Double d = (Double)this.getFromLook(Attr.GridStep);
        return d;
    }

    public double getGridStep(IdentObj identObj) {
        Double d = (Double)this.getFromLook(identObj, Attr.GridStep);
        return d;
    }

    public double getGridStep(int n) {
        return this.getGridStep(new IdentObj(n));
    }

    public void setGridStep(double d) {
        this.putToLookAndRepaint(Attr.GridStep, new Double(d));
    }

    public void setGridStep(IdentObj identObj, double d) {
        this.putToLookAndRepaint(identObj, Attr.GridStep, new Double(d));
    }

    public void setGridStep(int n, double d) {
        this.setGridStep(new IdentObj(n), d);
    }

    public boolean getGridStepAuto() {
        Boolean bl = (Boolean)this.getFromLook(Attr.GridStepAuto);
        return bl;
    }

    public boolean getGridStepAuto(IdentObj identObj) {
        Boolean bl = (Boolean)this.getFromLook(identObj, Attr.GridStepAuto);
        return bl;
    }

    public boolean getGridStepAuto(int n) {
        return this.getGridStepAuto(new IdentObj(n));
    }

    public void setGridStepAuto(boolean bl) {
        this.putToLookAndRepaint(Attr.GridStepAuto, new Boolean(bl));
    }

    public void setGridStepAuto(IdentObj identObj, boolean bl) {
        this.putToLookAndRepaint(identObj, Attr.GridStepAuto, new Boolean(bl));
    }

    public void setGridStepAuto(int n, boolean bl) {
        this.setGridStepAuto(new IdentObj(n), bl);
    }

    public int getGridStyle() {
        Integer n = (Integer)this.getFromLook(Attr.GridStyle);
        return n;
    }

    public int getGridStyle(IdentObj identObj) {
        Integer n = (Integer)this.getFromLook(identObj, Attr.GridStyle);
        return n;
    }

    public int getGridStyle(int n) {
        return this.getGridStyle(new IdentObj(n));
    }

    public void setGridStyle(int n) {
        this.putToLookAndRepaint(Attr.GridStyle, new Integer(n));
    }

    public void setGridStyle(IdentObj identObj, int n) {
        this.putToLookAndRepaint(identObj, Attr.GridStyle, new Integer(n));
    }

    public void setGridStyle(int n, int n2) {
        this.setGridStyle(new IdentObj(n), n2);
    }

    public String getGroupLabel(int n) {
        String string = null;
        if (this.getNestedLabels()) {
            Vector vector = this.getO1LabelCallBack().getAllLabels(0);
            if (vector.size() > n) {
                string = (String)vector.elementAt(n);
            }
            return string;
        }
        if (this.m_groupLabels.size() > n) {
            string = (String)this.m_groupLabels.elementAt(n);
        }
        return string;
    }

    public void setGroupLabel(int n, Object object) {
        if (this.m_groupLabels.size() < n) {
            this.m_groupLabels.setSize(n + 1);
        }
        this.m_groupLabels.insertElementAt(object, n);
    }

    public boolean getLabelStagger() {
        Boolean bl = (Boolean)this.getFromLook(Attr.LabelStagger);
        return bl;
    }

    public boolean getLabelStagger(IdentObj identObj) {
        Boolean bl = (Boolean)this.getFromLook(identObj, Attr.LabelStagger);
        return bl;
    }

    public boolean getLabelStagger(int n) {
        return this.getLabelStagger(new IdentObj(n));
    }

    public void setLabelStagger(boolean bl) {
        this.putToLookAndRepaint(Attr.LabelStagger, new Boolean(bl));
    }

    public void setLabelStagger(IdentObj identObj, boolean bl) {
        this.putToLookAndRepaint(identObj, Attr.LabelStagger, new Boolean(bl));
    }

    public void setLabelStagger(int n, boolean bl) {
        this.setLabelStagger(new IdentObj(n), bl);
    }

    public boolean getLogScale() {
        Boolean bl = (Boolean)this.getFromLook(Attr.LogScale);
        return bl;
    }

    public boolean getLogScale(IdentObj identObj) {
        Boolean bl = (Boolean)this.getFromLook(identObj, Attr.LogScale);
        return bl;
    }

    public boolean getLogScale(int n) {
        return this.getLogScale(new IdentObj(n));
    }

    public void setLogScale(boolean bl) {
        this.putToLookAndRepaint(Attr.LogScale, new Boolean(bl));
    }

    public void setLogScale(IdentObj identObj, boolean bl) {
        this.putToLookAndRepaint(identObj, Attr.LogScale, new Boolean(bl));
    }

    public void setLogScale(int n, boolean bl) {
        this.setLogScale(new IdentObj(n), bl);
    }

    public int getMarkerSize() {
        Integer n = (Integer)this.getFromLook(Attr.MarkerSize, 3);
        return n;
    }

    public int getMarkerSize(IdentObj identObj) {
        Integer n = (Integer)this.getFromLook(identObj, Attr.MarkerSize);
        return n;
    }

    public int getMarkerSize(int n) {
        IdentObj identObj = new IdentObj(-3, n, -3);
        Integer n2 = (Integer)this.getFromLook(identObj, Attr.MarkerSize, false);
        if (n2 != null) {
            return n2;
        }
        return this.getMarkerSizeDefault();
    }

    public int getMarkerSize(int n, int n2) {
        IdentObj identObj = new IdentObj(-3, n, n2);
        Integer n3 = (Integer)this.getFromLook(identObj, Attr.MarkerSize, false);
        if (n3 != null) {
            return n3;
        }
        return this.getMarkerSize(n);
    }

    public void setMarkerSize(int n) {
        this.putToLookAndRepaint(Attr.MarkerSize, new Integer(n), 3);
    }

    public void setMarkerSize(IdentObj identObj, int n) {
        this.putToLookAndRepaint(identObj, Attr.MarkerSize, new Integer(n));
    }

    public void setMarkerSize(int n, int n2) {
        IdentObj identObj = new IdentObj(-3, n, -3);
        this.setMarkerSize(identObj, n2);
    }

    public void setMarkerSize(int n, int n2, int n3) {
        IdentObj identObj = new IdentObj(-3, n, n2);
        this.setMarkerSize(identObj, n3);
    }

    public boolean getPieSliceDelete() {
        Boolean bl = (Boolean)this.getFromLook(Attr.PieSliceDelete, 3);
        return bl;
    }

    public boolean getPieSliceDelete(IdentObj identObj) {
        Boolean bl = (Boolean)this.getFromLook(identObj, Attr.PieSliceDelete);
        return bl;
    }

    public boolean getPieSliceDelete(int n) {
        IdentObj identObj = new IdentObj(-3, n, -3);
        return this.getPieSliceDelete(identObj);
    }

    public boolean getPieSliceDelete(int n, int n2) {
        IdentObj identObj = new IdentObj(-3, n, n2);
        return this.getPieSliceDelete(identObj);
    }

    public void setPieSliceDelete(boolean bl) {
        this.putToLookAndRepaint(Attr.PieSliceDelete, new Boolean(bl), 3);
    }

    public void setPieSliceDelete(IdentObj identObj, boolean bl) {
        this.putToLookAndRepaint(identObj, Attr.PieSliceDelete, new Boolean(bl));
    }

    public void setPieSliceDelete(int n, boolean bl) {
        IdentObj identObj = new IdentObj(-3, n, -3);
        this.setPieSliceDelete(identObj, bl);
    }

    public void setPieSliceDelete(int n, int n2, boolean bl) {
        IdentObj identObj = new IdentObj(-3, n, n2);
        this.setPieSliceDelete(identObj, bl);
    }

    public int getPieSliceDetach() {
        Integer n = (Integer)this.getFromLook(Attr.PieSliceDetach, 3);
        return n;
    }

    public int getPieSliceDetach(IdentObj identObj) {
        Integer n = (Integer)this.getFromLook(identObj, Attr.PieSliceDetach);
        return n;
    }

    public int getPieSliceDetach(int n) {
        IdentObj identObj = new IdentObj(-3, n, -3);
        return this.getPieSliceDetach(identObj);
    }

    public int getPieSliceDetach(int n, int n2) {
        IdentObj identObj = new IdentObj(-3, n, n2);
        return this.getPieSliceDetach(identObj);
    }

    public void setPieSliceDetach(int n) {
        this.putToLookAndRepaint(Attr.PieSliceDetach, new Integer(n), 3);
    }

    public void setPieSliceDetach(IdentObj identObj, int n) {
        this.putToLookAndRepaint(identObj, Attr.PieSliceDetach, new Integer(n));
    }

    public void setPieSliceDetach(int n, int n2) {
        IdentObj identObj = new IdentObj(-3, n, -3);
        this.setPieSliceDetach(identObj, n2);
    }

    public void setPieSliceDetach(int n, int n2, int n3) {
        IdentObj identObj = new IdentObj(-3, n, n2);
        this.setPieSliceDetach(identObj, n3);
    }

    public Rectangle getRect() {
        Rectangle rectangle = (Rectangle)this.getFromLook(Attr.Rect);
        return rectangle;
    }

    public Rectangle getRect(IdentObj identObj) {
        Attr attr = Attr.Rect;
        switch (identObj.getObjectID()) {
            case 1: {
                attr = Attr.ChartBackgroundRect;
                break;
            }
            case 42: {
                attr = Attr.CurveFitEquationTextRect;
                break;
            }
            case 3: {
                attr = Attr.FootnoteRect;
                break;
            }
            case 2: {
                attr = Attr.FrameRect;
                break;
            }
            case 12: {
                attr = Attr.LegendAreaRect;
                break;
            }
            case 302: {
                attr = Attr.PieFrameRect;
                break;
            }
            case 4: {
                attr = Attr.SubtitleRect;
                break;
            }
            case 5: {
                attr = Attr.TitleRect;
                break;
            }
            case 7: {
                attr = Attr.Y2TitleRect;
            }
        }
        Rectangle rectangle = (Rectangle)this.getFromLook(identObj, attr);
        return rectangle;
    }

    public Rectangle getRect(int n) {
        return this.getRect(new IdentObj(n));
    }

    public void setRect(Rectangle rectangle) {
        this.putToLookAndRepaint(Attr.Rect, rectangle);
    }

    public void setRect(IdentObj identObj, Rectangle rectangle) {
        Attr attr = Attr.Rect;
        switch (identObj.getObjectID()) {
            case 1: {
                attr = Attr.ChartBackgroundRect;
                break;
            }
            case 42: {
                attr = Attr.CurveFitEquationTextRect;
                break;
            }
            case 3: {
                attr = Attr.FootnoteRect;
                break;
            }
            case 2: {
                attr = Attr.FrameRect;
                break;
            }
            case 12: {
                attr = Attr.LegendAreaRect;
                break;
            }
            case 302: {
                attr = Attr.PieFrameRect;
                break;
            }
            case 4: {
                attr = Attr.SubtitleRect;
                break;
            }
            case 5: {
                attr = Attr.TitleRect;
                break;
            }
            case 7: {
                attr = Attr.Y2TitleRect;
            }
        }
        this.putToLookAndRepaint(identObj, attr, rectangle);
    }

    public void setRect(int n, Rectangle rectangle) {
        this.setRect(new IdentObj(n), rectangle);
    }

    public double getScaleMax() {
        Double d = (Double)this.getFromLook(Attr.ScaleMax);
        return d;
    }

    public double getScaleMax(IdentObj identObj) {
        Attr attr = Attr.ScaleMax;
        switch (identObj.getObjectID()) {
            case 2003: {
                attr = Attr.X1ScaleMax;
                break;
            }
            case 2004: {
                attr = Attr.Y1ScaleMax;
                break;
            }
            case 2005: {
                attr = Attr.Y2ScaleMax;
            }
        }
        Double d = (Double)this.getFromLook(identObj, attr);
        return d;
    }

    public double getScaleMax(int n) {
        return this.getScaleMax(new IdentObj(n));
    }

    public void setScaleMax(double d) {
        this.putToLookAndRepaint(Attr.ScaleMax, new Double(d));
    }

    public void setScaleMax(IdentObj identObj, double d) {
        Attr attr = Attr.ScaleMax;
        switch (identObj.getObjectID()) {
            case 2003: {
                attr = Attr.X1ScaleMax;
                break;
            }
            case 2004: {
                attr = Attr.Y1ScaleMax;
                break;
            }
            case 2005: {
                attr = Attr.Y2ScaleMax;
            }
        }
        this.putToLookAndRepaint(identObj, attr, new Double(d));
    }

    public void setScaleMax(int n, double d) {
        this.setScaleMax(new IdentObj(n), d);
    }

    public boolean getScaleMaxAuto() {
        Boolean bl = (Boolean)this.getFromLook(Attr.ScaleMaxAuto);
        return bl;
    }

    public boolean getScaleMaxAuto(IdentObj identObj) {
        Boolean bl = (Boolean)this.getFromLook(identObj, Attr.ScaleMaxAuto);
        return bl;
    }

    public boolean getScaleMaxAuto(int n) {
        return this.getScaleMaxAuto(new IdentObj(n));
    }

    public void setScaleMaxAuto(boolean bl) {
        this.putToLookAndRepaint(Attr.ScaleMaxAuto, new Boolean(bl));
    }

    public void setScaleMaxAuto(IdentObj identObj, boolean bl) {
        this.putToLookAndRepaint(identObj, Attr.ScaleMaxAuto, new Boolean(bl));
    }

    public void setScaleMaxAuto(int n, boolean bl) {
        this.setScaleMaxAuto(new IdentObj(n), bl);
    }

    public double getScaleMin() {
        Double d = (Double)this.getFromLook(Attr.ScaleMin);
        return d;
    }

    public double getScaleMin(IdentObj identObj) {
        Attr attr = Attr.ScaleMin;
        switch (identObj.getObjectID()) {
            case 2005: {
                attr = Attr.Y2ScaleMin;
            }
        }
        Double d = (Double)this.getFromLook(identObj, attr);
        return d;
    }

    public double getScaleMin(int n) {
        return this.getScaleMin(new IdentObj(n));
    }

    public void setScaleMin(double d) {
        this.putToLookAndRepaint(Attr.ScaleMin, new Double(d));
    }

    public void setScaleMin(IdentObj identObj, double d) {
        Attr attr = Attr.ScaleMin;
        switch (identObj.getObjectID()) {
            case 2005: {
                attr = Attr.Y2ScaleMin;
            }
        }
        this.putToLookAndRepaint(identObj, attr, new Double(d));
    }

    public void setScaleMin(int n, double d) {
        this.setScaleMin(new IdentObj(n), d);
    }

    public boolean getScaleMinAuto() {
        Boolean bl = (Boolean)this.getFromLook(Attr.ScaleMinAuto);
        return bl;
    }

    public boolean getScaleMinAuto(IdentObj identObj) {
        Boolean bl = (Boolean)this.getFromLook(identObj, Attr.ScaleMinAuto);
        return bl;
    }

    public boolean getScaleMinAuto(int n) {
        return this.getScaleMinAuto(new IdentObj(n));
    }

    public void setScaleMinAuto(boolean bl) {
        this.putToLookAndRepaint(Attr.ScaleMinAuto, new Boolean(bl));
    }

    public void setScaleMinAuto(IdentObj identObj, boolean bl) {
        this.putToLookAndRepaint(identObj, Attr.ScaleMinAuto, new Boolean(bl));
    }

    public void setScaleMinAuto(int n, boolean bl) {
        this.setScaleMinAuto(new IdentObj(n), bl);
    }

    public boolean getScaleMustIncludeZero() {
        Boolean bl = (Boolean)this.getFromLook(Attr.ScaleMustIncludeZero);
        return bl;
    }

    public boolean getScaleMustIncludeZero(IdentObj identObj) {
        Boolean bl = (Boolean)this.getFromLook(identObj, Attr.ScaleMustIncludeZero);
        return bl;
    }

    public boolean getScaleMustIncludeZero(int n) {
        return this.getScaleMustIncludeZero(new IdentObj(n));
    }

    public void setScaleMustIncludeZero(boolean bl) {
        this.putToLookAndRepaint(Attr.ScaleMustIncludeZero, new Boolean(bl));
    }

    public void setScaleMustIncludeZero(IdentObj identObj, boolean bl) {
        this.putToLookAndRepaint(identObj, Attr.ScaleMustIncludeZero, new Boolean(bl));
    }

    public void setScaleMustIncludeZero(int n, boolean bl) {
        this.setScaleMustIncludeZero(new IdentObj(n), bl);
    }

    public String getSeriesLabel(int n) {
        String string = null;
        if (this.m_seriesLabels.size() > n) {
            string = (String)this.m_seriesLabels.elementAt(n);
        }
        return string;
    }

    public void setSeriesLabel(int n, Object object) {
        if (this.m_seriesLabels.size() < n) {
            this.m_seriesLabels.setSize(n + 1);
        }
        this.m_seriesLabels.insertElementAt(object, n);
    }

    public boolean getShadowDisplay() {
        Boolean bl = (Boolean)this.getFromLook(Attr.ShadowDisplay);
        return bl;
    }

    public boolean getShadowDisplay(IdentObj identObj) {
        Boolean bl = (Boolean)this.getFromLook(identObj, Attr.ShadowDisplay);
        return bl;
    }

    public boolean getShadowDisplay(int n) {
        return this.getShadowDisplay(new IdentObj(n));
    }

    public void setShadowDisplay(boolean bl) {
        this.putToLookAndRepaint(Attr.ShadowDisplay, new Boolean(bl));
    }

    public void setShadowDisplay(IdentObj identObj, boolean bl) {
        this.putToLookAndRepaint(identObj, Attr.ShadowDisplay, new Boolean(bl));
    }

    public void setShadowDisplay(int n, boolean bl) {
        this.setShadowDisplay(new IdentObj(n), bl);
    }

    public int getShadowXOffset() {
        Integer n = (Integer)this.getFromLook(Attr.ShadowXOffset);
        return n;
    }

    public int getShadowXOffset(IdentObj identObj) {
        Integer n = (Integer)this.getFromLook(identObj, Attr.ShadowXOffset);
        return n;
    }

    public int getShadowXOffset(int n) {
        return this.getShadowXOffset(new IdentObj(n));
    }

    public void setShadowXOffset(int n) {
        this.putToLookAndRepaint(Attr.ShadowXOffset, new Integer(n));
    }

    public void setShadowXOffset(IdentObj identObj, int n) {
        this.putToLookAndRepaint(identObj, Attr.ShadowXOffset, new Integer(n));
    }

    public void setShadowXOffset(int n, int n2) {
        this.setShadowXOffset(new IdentObj(n), n2);
    }

    public int getShadowYOffset() {
        Integer n = (Integer)this.getFromLook(Attr.ShadowYOffset);
        return n;
    }

    public int getShadowYOffset(IdentObj identObj) {
        Integer n = (Integer)this.getFromLook(identObj, Attr.ShadowYOffset);
        return n;
    }

    public int getShadowYOffset(int n) {
        return this.getShadowYOffset(new IdentObj(n));
    }

    public void setShadowYOffset(int n) {
        this.putToLookAndRepaint(Attr.ShadowYOffset, new Integer(n));
    }

    public void setShadowYOffset(IdentObj identObj, int n) {
        this.putToLookAndRepaint(identObj, Attr.ShadowYOffset, new Integer(n));
    }

    public void setShadowYOffset(int n, int n2) {
        this.setShadowYOffset(new IdentObj(n), n2);
    }

    public int getTextFormatPreset() {
        Integer n = (Integer)this.getFromLook(Attr.TextFormatPreset);
        return n;
    }

    public int getTextFormatPreset(IdentObj identObj) {
        Attr attr = Attr.TextFormatPreset;
        if (identObj.getObjectID() == 295) {
            attr = Attr.SliceLabelTextFormatPreset;
        }
        Integer n = (Integer)this.getFromLook(identObj, attr);
        return n;
    }

    public int getTextFormatPreset(int n) {
        return this.getTextFormatPreset(new IdentObj(n));
    }

    public void setTextFormatPreset(int n) {
        this.putToLookAndRepaint(Attr.TextFormatPreset, new Integer(n));
    }

    public void setTextFormatPreset(IdentObj identObj, int n) {
        Attr attr = Attr.TextFormatPreset;
        if (identObj.getObjectID() == 295) {
            attr = Attr.SliceLabelTextFormatPreset;
        }
        this.putToLookAndRepaint(identObj, attr, new Integer(n));
    }

    public void setTextFormatPreset(int n, int n2) {
        this.setTextFormatPreset(new IdentObj(n), n2);
    }

    public int getTextJustHoriz() {
        Integer n = (Integer)this.getFromLook(Attr.TextJustHoriz);
        return n;
    }

    public int getTextJustHoriz(IdentObj identObj) {
        Attr attr = Attr.TextJustHoriz;
        switch (identObj.getObjectID()) {
            case 274: 
            case 284: 
            case 288: {
                attr = Attr.RightTextJustHoriz;
                break;
            }
            case 3: 
            case 14: 
            case 235: {
                attr = Attr.LeftTextJustHoriz;
            }
        }
        Integer n = (Integer)this.getFromLook(identObj, attr);
        return n;
    }

    public int getTextJustHoriz(int n) {
        return this.getTextJustHoriz(new IdentObj(n));
    }

    public void setTextJustHoriz(int n) {
        this.putToLookAndRepaint(Attr.TextJustHoriz, new Integer(n));
    }

    public void setTextJustHoriz(IdentObj identObj, int n) {
        Attr attr = Attr.TextJustHoriz;
        switch (identObj.getObjectID()) {
            case 260: 
            case 274: 
            case 284: 
            case 288: {
                attr = Attr.RightTextJustHoriz;
                break;
            }
            case 3: 
            case 14: 
            case 235: {
                attr = Attr.LeftTextJustHoriz;
            }
        }
        this.putToLookAndRepaint(identObj, attr, new Integer(n));
    }

    public void setTextJustHoriz(int n, int n2) {
        this.setTextJustHoriz(new IdentObj(n), n2);
    }

    public int getTextJustVert() {
        Integer n = (Integer)this.getFromLook(Attr.TextJustVert);
        return n;
    }

    public int getTextJustVert(IdentObj identObj) {
        Attr attr = Attr.TextJustVert;
        if (identObj.getObjectID() == 270) {
            attr = Attr.TopTextJustVert;
        }
        Integer n = (Integer)this.getFromLook(identObj, attr);
        return n;
    }

    public int getTextJustVert(int n) {
        return this.getTextJustVert(new IdentObj(n));
    }

    public void setTextJustVert(int n) {
        this.putToLookAndRepaint(Attr.TextJustVert, new Integer(n));
    }

    public void setTextJustVert(IdentObj identObj, int n) {
        Attr attr = Attr.TextJustVert;
        if (identObj.getObjectID() == 270) {
            attr = Attr.TopTextJustVert;
        }
        this.putToLookAndRepaint(identObj, attr, new Integer(n));
    }

    public void setTextJustVert(int n, int n2) {
        this.setTextJustVert(new IdentObj(n), n2);
    }

    public int getTextRotation() {
        Integer n = (Integer)this.getFromLook(Attr.TextRotation);
        return n;
    }

    public int getTextRotation(IdentObj identObj) {
        Attr attr = Attr.TextRotation;
        switch (identObj.getObjectID()) {
            case 6: {
                attr = Attr.Y1TextRotation;
                break;
            }
            case 7: {
                attr = Attr.Y2TextRotation;
            }
        }
        Integer n = (Integer)this.getFromLook(identObj, attr);
        return n;
    }

    public int getTextRotation(int n) {
        return this.getTextRotation(new IdentObj(n));
    }

    public void setTextRotation(int n) {
        this.putToLookAndRepaint(Attr.TextRotation, new Integer(n));
    }

    public void setTextRotation(IdentObj identObj, int n) {
        Attr attr = Attr.TextRotation;
        switch (identObj.getObjectID()) {
            case 6: {
                attr = Attr.Y1TextRotation;
                break;
            }
            case 7: {
                attr = Attr.Y2TextRotation;
            }
        }
        this.putToLookAndRepaint(identObj, attr, new Integer(n));
    }

    public void setTextRotation(int n, int n2) {
        this.setTextRotation(new IdentObj(n), n2);
    }

    public String getTextString() {
        String string = (String)this.getFromLook(Attr.TextString);
        return string;
    }

    public String getTextString(IdentObj identObj) {
        String string = (String)this.getFromLook(identObj, Attr.TextString);
        return string;
    }

    public String getTextString(int n) {
        return this.getTextString(new IdentObj(n));
    }

    public void setTextString(String string) {
        this.putToLookAndRepaint(Attr.TextString, string);
    }

    public void setTextString(IdentObj identObj, String string) {
        this.putToLookAndRepaint(identObj, Attr.TextString, string);
    }

    public void setTextString(int n, String string) {
        this.setTextString(new IdentObj(n), string);
    }

    public boolean getTextWrap() {
        Boolean bl = (Boolean)this.getFromLook(Attr.TextWrap);
        return bl;
    }

    public boolean getTextWrap(IdentObj identObj) {
        Attr attr = Attr.TextWrap;
        switch (identObj.getObjectID()) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 232: 
            case 233: 
            case 260: {
                attr = Attr.TitleTextWrap;
            }
        }
        Boolean bl = (Boolean)this.getFromLook(identObj, attr);
        return bl;
    }

    public boolean getTextWrap(int n) {
        return this.getTextWrap(new IdentObj(n));
    }

    public void setTextWrap(boolean bl) {
        this.putToLookAndRepaint(Attr.TextWrap, new Boolean(bl));
    }

    public void setTextWrap(IdentObj identObj, boolean bl) {
        Attr attr = Attr.TextWrap;
        switch (identObj.getObjectID()) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 232: 
            case 233: 
            case 260: {
                attr = Attr.TitleTextWrap;
            }
        }
        this.putToLookAndRepaint(identObj, attr, new Boolean(bl));
    }

    public void setTextWrap(int n, boolean bl) {
        this.setTextWrap(new IdentObj(n), bl);
    }

    public int getSeriesType() {
        Integer n = (Integer)this.getFromLook(Attr.SeriesType, 1);
        return n;
    }

    public int getSeriesType(IdentObj identObj) {
        Integer n = (Integer)this.getFromLook(identObj, Attr.SeriesType);
        return n;
    }

    public int getSeriesType(int n) {
        IdentObj identObj = new IdentObj(-3, n, -3);
        return this.getSeriesType(identObj);
    }

    public void setSeriesType(int n) {
        this.putToLookAndRepaint(Attr.SeriesType, new Integer(n), 1);
    }

    public void setSeriesType(IdentObj identObj, int n) {
        this.putToLookAndRepaint(identObj, Attr.SeriesType, new Integer(n));
    }

    public void setSeriesType(int n, int n2) {
        IdentObj identObj = new IdentObj(-3, n, -3);
        this.setSeriesType(identObj, n2);
    }

    public int getDataLineThickness() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.DataLineThickness);
        return n;
    }

    public void setDataLineThickness(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.DataLineThickness, new Integer(n));
    }

    public boolean getLegendReverse() {
        Boolean bl = (Boolean)this.getFromLook(new IdentObj(2000), Attr.LegendReverse);
        return bl;
    }

    public void setLegendReverse(boolean bl) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.LegendReverse, new Boolean(bl));
    }

    public String getY2TitleString() {
        return this.getTextString(new IdentObj(7));
    }

    public void setY2TitleString(String string) {
        this.setTextString(new IdentObj(7), string);
        if (this.getCascade() && string.length() > 0) {
            this.setY2TitleDisplay(true);
        }
    }

    public boolean getDisplayBarAsPictograph() {
        Boolean bl = (Boolean)this.getFromLook(new IdentObj(2000), Attr.DisplayBarAsPictograph);
        return bl;
    }

    public void setDisplayBarAsPictograph(boolean bl) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.DisplayBarAsPictograph, new Boolean(bl));
    }

    public String getDataTextTemplateHiLo() {
        String string = (String)this.getFromLook(new IdentObj(2000), Attr.DataTextTemplateHiLo);
        return string;
    }

    public void setDataTextTemplateHiLo(String string) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.DataTextTemplateHiLo, string);
    }

    public String getTextFormatPattern() {
        String string = (String)this.getFromLook(Attr.TextFormatPattern);
        return string;
    }

    public String getTextFormatPattern(IdentObj identObj) {
        String string = (String)this.getFromLook(identObj, Attr.TextFormatPattern);
        return string;
    }

    public String getTextFormatPattern(int n) {
        return this.getTextFormatPattern(new IdentObj(n));
    }

    public void setTextFormatPattern(String string) {
        this.putToLookAndRepaint(Attr.TextFormatPattern, string);
    }

    public void setTextFormatPattern(IdentObj identObj, String string) {
        this.putToLookAndRepaint(identObj, Attr.TextFormatPattern, string);
    }

    public void setTextFormatPattern(int n, String string) {
        this.setTextFormatPattern(new IdentObj(n), string);
    }

    public String getDataTextFormatPattern() {
        return this.getTextFormatPattern(new IdentObj(2000));
    }

    public void setDataTextFormatPattern(String string) {
        this.setTextFormatPattern(new IdentObj(2000), string);
    }

    public int getTextureDisplayMode() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.TextureDisplayMode);
        return n;
    }

    public void setTextureDisplayMode(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.TextureDisplayMode, new Integer(n));
    }

    public double getCubeLightSourceX() {
        Double d = (Double)this.getFromLook(new IdentObj(2000), Attr.CubeLightSourceX);
        return d;
    }

    public void setCubeLightSourceX(double d) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.CubeLightSourceX, new Double(d));
    }

    public double getCubeLightSourceY() {
        Double d = (Double)this.getFromLook(new IdentObj(2000), Attr.CubeLightSourceY);
        return d;
    }

    public void setCubeLightSourceY(double d) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.CubeLightSourceY, new Double(d));
    }

    public String getPieFeelerTextFormatPattern() {
        return this.getTextFormatPattern(new IdentObj(295));
    }

    public void setPieFeelerTextFormatPattern(String string) {
        this.setTextFormatPattern(new IdentObj(295), string);
    }

    public String getPieRingTotalFormatPattern() {
        return this.getTextFormatPattern(new IdentObj(297));
    }

    public void setPieRingTotalFormatPattern(String string) {
        this.setTextFormatPattern(new IdentObj(297), string);
    }

    public String getX1LabelFormatPattern() {
        return this.getTextFormatPattern(new IdentObj(280));
    }

    public void setX1LabelFormatPattern(String string) {
        this.setTextFormatPattern(new IdentObj(280), string);
    }

    public int getQuadrantLineCountX() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.QuadrantLineCountX);
        return n;
    }

    public void setQuadrantLineCountX(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.QuadrantLineCountX, new Integer(n));
    }

    public int getO1LabelRotate() {
        return this.getTextRotation(this.getO1Label());
    }

    public void setO1LabelRotate(int n) {
        this.setTextRotation(this.getO1Label(), n);
    }

    public int getO2LabelRotate() {
        return this.getTextRotation(this.getO2Label());
    }

    public void setO2LabelRotate(int n) {
        this.setTextRotation(this.getO2Label(), n);
    }

    public int getY1LabelRotate() {
        return this.getTextRotation(new IdentObj(284));
    }

    public void setY1LabelRotate(int n) {
        this.setTextRotation(new IdentObj(284), n);
    }

    public int getY2LabelRotate() {
        return this.getTextRotation(new IdentObj(288));
    }

    public void setY2LabelRotate(int n) {
        this.setTextRotation(new IdentObj(288), n);
    }

    public int getX1LabelRotate() {
        return this.getTextRotation(new IdentObj(280));
    }

    public void setX1LabelRotate(int n) {
        this.setTextRotation(new IdentObj(280), n);
    }

    public String getToolTipCustomString() {
        String string = (String)this.getFromLook(Attr.ToolTipCustomString, 3);
        return string;
    }

    public String getToolTipCustomString(IdentObj identObj) {
        String string = (String)this.getFromLook(identObj, Attr.ToolTipCustomString);
        return string;
    }

    public String getToolTipCustomString(int n) {
        IdentObj identObj = new IdentObj(-3, n, -3);
        return this.getToolTipCustomString(identObj);
    }

    public String getToolTipCustomString(int n, int n2) {
        IdentObj identObj = new IdentObj(-3, n, n2);
        return this.getToolTipCustomString(identObj);
    }

    public void setToolTipCustomString(String string) {
        this.putToLookAndRepaint(Attr.ToolTipCustomString, string, 3);
    }

    public void setToolTipCustomString(IdentObj identObj, String string) {
        this.putToLookAndRepaint(identObj, Attr.ToolTipCustomString, string);
    }

    public void setToolTipCustomString(int n, String string) {
        IdentObj identObj = new IdentObj(-3, n, -3);
        this.setToolTipCustomString(identObj, string);
    }

    public void setToolTipCustomString(int n, int n2, String string) {
        IdentObj identObj = new IdentObj(-3, n, n2);
        this.setToolTipCustomString(identObj, string);
    }

    public double getCubeLightSourceZ() {
        Double d = (Double)this.getFromLook(new IdentObj(2000), Attr.CubeLightSourceZ);
        return d;
    }

    public void setCubeLightSourceZ(double d) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.CubeLightSourceZ, new Double(d));
    }

    public String getY1LabelFormatPattern() {
        return this.getTextFormatPattern(new IdentObj(284));
    }

    public void setY1LabelFormatPattern(String string) {
        this.setTextFormatPattern(new IdentObj(284), string);
    }

    public String getY2LabelFormatPattern() {
        return this.getTextFormatPattern(new IdentObj(288));
    }

    public void setY2LabelFormatPattern(String string) {
        this.setTextFormatPattern(new IdentObj(288), string);
    }

    public int getTextAutofitMin() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.TextAutofitMin);
        return n;
    }

    public void setTextAutofitMin(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.TextAutofitMin, new Integer(n));
    }

    public int getTextAutofitMax() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.TextAutofitMax);
        return n;
    }

    public void setTextAutofitMax(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.TextAutofitMax, new Integer(n));
    }

    public int getQuadrantLineCountY() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.QuadrantLineCountY);
        return n;
    }

    public void setQuadrantLineCountY(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.QuadrantLineCountY, new Integer(n));
    }

    public int getZoomDirection() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.ZoomDirection);
        return n;
    }

    public void setZoomDirection(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.ZoomDirection, new Integer(n));
    }

    public boolean getIgnoreSeries() {
        Boolean bl = (Boolean)this.getFromLook(Attr.IgnoreSeries, 1);
        return bl;
    }

    public boolean getIgnoreSeries(IdentObj identObj) {
        Boolean bl = (Boolean)this.getFromLook(identObj, Attr.IgnoreSeries);
        return bl;
    }

    public boolean getIgnoreSeries(int n) {
        IdentObj identObj = new IdentObj(-3, n, -3);
        return this.getIgnoreSeries(identObj);
    }

    public void setIgnoreSeries(boolean bl) {
        this.putToLookAndRepaint(Attr.IgnoreSeries, new Boolean(bl), 1);
    }

    public void setIgnoreSeries(IdentObj identObj, boolean bl) {
        this.putToLookAndRepaint(identObj, Attr.IgnoreSeries, new Boolean(bl));
    }

    public void setIgnoreSeries(int n, boolean bl) {
        IdentObj identObj = new IdentObj(-3, n, -3);
        this.setIgnoreSeries(identObj, bl);
    }

    public int getDataScrollerPresenceGroups() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.DataScrollerPresenceGroups);
        return n;
    }

    public void setDataScrollerPresenceGroups(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.DataScrollerPresenceGroups, new Integer(n));
    }

    public int getPieBarSeries() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.PieBarSeries);
        return n;
    }

    public void setPieBarSeries(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.PieBarSeries, new Integer(n));
    }

    public int getO1LabelMargin() {
        return this.getLabelMargin(this.getO1Label());
    }

    public void setO1LabelMargin(int n) {
        this.setLabelMargin(this.getO1Label(), n);
    }

    public int getLabelMargin() {
        Integer n = (Integer)this.getFromLook(Attr.LabelMargin);
        return n;
    }

    public int getLabelMargin(IdentObj identObj) {
        Integer n = (Integer)this.getFromLook(identObj, Attr.LabelMargin);
        return n;
    }

    public int getLabelMargin(int n) {
        return this.getLabelMargin(new IdentObj(n));
    }

    public void setLabelMargin(int n) {
        this.putToLookAndRepaint(Attr.LabelMargin, new Integer(n));
    }

    public void setLabelMargin(IdentObj identObj, int n) {
        this.putToLookAndRepaint(identObj, Attr.LabelMargin, new Integer(n));
    }

    public void setLabelMargin(int n, int n2) {
        this.setLabelMargin(new IdentObj(n), n2);
    }

    public int getDataScrollerPresenceSeries() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.DataScrollerPresenceSeries);
        return n;
    }

    public void setDataScrollerPresenceSeries(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.DataScrollerPresenceSeries, new Integer(n));
    }

    public boolean getBiDirectional() {
        Boolean bl = (Boolean)this.getFromLook(new IdentObj(2000), Attr.BiDirectional);
        return bl;
    }

    public void setBiDirectional(boolean bl) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.BiDirectional, new Boolean(bl));
    }

    public int getAxisTextAutofitMax() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.AxisTextAutofitMax);
        return n;
    }

    public void setAxisTextAutofitMax(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.AxisTextAutofitMax, new Integer(n));
    }

    public int getAxisTextAutofitMin() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.AxisTextAutofitMin);
        return n;
    }

    public void setAxisTextAutofitMin(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.AxisTextAutofitMin, new Integer(n));
    }

    public int getAxisTextAutofitMode() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.AxisTextAutofitMode);
        return n;
    }

    public void setAxisTextAutofitMode(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.AxisTextAutofitMode, new Integer(n));
    }

    public int getAxisTextAutofitPercent() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.AxisTextAutofitPercent);
        return n;
    }

    public void setAxisTextAutofitPercent(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.AxisTextAutofitPercent, new Integer(n));
    }

    public boolean getNestedLabels() {
        Boolean bl = (Boolean)this.getFromLook(new IdentObj(2000), Attr.NestedLabels);
        return bl;
    }

    public void setNestedLabels(boolean bl) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.NestedLabels, new Boolean(bl));
    }

    public boolean getNestedLabelsUniformStyle() {
        Boolean bl = (Boolean)this.getFromLook(new IdentObj(2000), Attr.NestedLabelsUniformStyle);
        return bl;
    }

    public void setNestedLabelsUniformStyle(boolean bl) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.NestedLabelsUniformStyle, new Boolean(bl));
    }

    public String getDataTextTemplateScatter() {
        String string = (String)this.getFromLook(new IdentObj(2000), Attr.DataTextTemplateScatter);
        return string;
    }

    public void setDataTextTemplateScatter(String string) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.DataTextTemplateScatter, string);
    }

    public String getDataTextTemplateBubble() {
        String string = (String)this.getFromLook(new IdentObj(2000), Attr.DataTextTemplateBubble);
        return string;
    }

    public void setDataTextTemplateBubble(String string) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.DataTextTemplateBubble, string);
    }

    public int getFontSize() {
        Integer n = (Integer)this.getFromLook(Attr.FontSize);
        return n;
    }

    public int getFontSize(IdentObj identObj) {
        Attr attr = Attr.FontSize;
        switch (identObj.getObjectID()) {
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 30: {
                attr = Attr.ScrollerFontSize;
                break;
            }
            case 5: {
                attr = Attr.TitleFontSize;
                break;
            }
            case 4: {
                attr = Attr.SubtitleFontSize;
            }
        }
        Integer n = (Integer)this.getFromLook(identObj, attr);
        return n;
    }

    public int getFontSize(int n) {
        return this.getFontSize(new IdentObj(n));
    }

    public void setFontSize(int n) {
        if (this.getCascade()) {
            this.setAutofit(false);
        }
        this.putToLookAndRepaint(Attr.FontSize, new Integer(n));
    }

    public void setFontSize(IdentObj identObj, int n) {
        Attr attr = Attr.FontSize;
        switch (identObj.getObjectID()) {
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 30: {
                attr = Attr.ScrollerFontSize;
                break;
            }
            case 5: {
                attr = Attr.TitleFontSize;
                break;
            }
            case 4: {
                attr = Attr.SubtitleFontSize;
            }
        }
        if (this.getCascade()) {
            this.setAutofit(identObj, false);
        }
        this.putToLookAndRepaint(identObj, attr, new Integer(n));
    }

    public void setFontSize(int n, int n2) {
        this.setFontSize(new IdentObj(n), n2);
    }

    public int getLegendMarkersPerRow() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.LegendMarkersPerRow);
        return n;
    }

    public void setLegendMarkersPerRow(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.LegendMarkersPerRow, new Integer(n));
    }

    public int getLegendOrient() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.LegendOrient);
        return n;
    }

    public void setLegendOrient(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.LegendOrient, new Integer(n));
    }

    public int getTextDirection() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.TextDirection);
        return n;
    }

    public void setTextDirection(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.TextDirection, new Integer(n));
    }

    public double getLogScaleBase() {
        Double d = (Double)this.getFromLook(Attr.LogScaleBase);
        return d;
    }

    public double getLogScaleBase(IdentObj identObj) {
        Double d = (Double)this.getFromLook(identObj, Attr.LogScaleBase);
        return d;
    }

    public double getLogScaleBase(int n) {
        return this.getLogScaleBase(new IdentObj(n));
    }

    public void setLogScaleBase(double d) {
        this.putToLookAndRepaint(Attr.LogScaleBase, new Double(d));
    }

    public void setLogScaleBase(IdentObj identObj, double d) {
        this.putToLookAndRepaint(identObj, Attr.LogScaleBase, new Double(d));
    }

    public void setLogScaleBase(int n, double d) {
        this.setLogScaleBase(new IdentObj(n), d);
    }

    public boolean getMoveAxisTitles() {
        Boolean bl = (Boolean)this.getFromLook(new IdentObj(2000), Attr.MoveAxisTitles);
        return bl;
    }

    public void setMoveAxisTitles(boolean bl) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.MoveAxisTitles, new Boolean(bl));
    }

    public String getPieBarLabelString() {
        return this.getTextString(new IdentObj(355));
    }

    public void setPieBarLabelString(String string) {
        this.setTextString(new IdentObj(355), string);
        if (this.getCascade() && string.length() > 0) {
            this.setPieBarLabelDisplay(true);
        }
    }

    public boolean getPieBarLabelDisplay() {
        return this.getDisplay(new IdentObj(355));
    }

    public void setPieBarLabelDisplay(boolean bl) {
        this.setDisplay(new IdentObj(355), bl);
    }

    public boolean getCascade() {
        Boolean bl = (Boolean)this.getFromLook(new IdentObj(2000), Attr.Cascade);
        return bl;
    }

    public void setCascade(boolean bl) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.Cascade, new Boolean(bl));
    }

    public int getTextureFlipMode() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.TextureFlipMode);
        return n;
    }

    public void setTextureFlipMode(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.TextureFlipMode, new Integer(n));
    }

    public boolean getExtendToFrameEdge() {
        Boolean bl = (Boolean)this.getFromLook(new IdentObj(2000), Attr.ExtendToFrameEdge);
        return bl;
    }

    public void setExtendToFrameEdge(boolean bl) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.ExtendToFrameEdge, new Boolean(bl));
    }

    public int getDisplayParetoSeries() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.DisplayParetoSeries);
        return n;
    }

    public void setDisplayParetoSeries(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.DisplayParetoSeries, new Integer(n));
    }

    public boolean getConnectParetoBars() {
        Boolean bl = (Boolean)this.getFromLook(new IdentObj(2000), Attr.ConnectParetoBars);
        return bl;
    }

    public void setConnectParetoBars(boolean bl) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.ConnectParetoBars, new Boolean(bl));
    }

    public double getParetoY2MajorGridStep() {
        Double d = (Double)this.getFromLook(new IdentObj(2000), Attr.ParetoY2MajorGridStep);
        return d;
    }

    public void setParetoY2MajorGridStep(double d) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.ParetoY2MajorGridStep, new Double(d));
    }

    public int getAxisSize() {
        Integer n = (Integer)this.getFromLook(Attr.AxisSize);
        return n;
    }

    public int getAxisSize(IdentObj identObj) {
        Integer n = (Integer)this.getFromLook(identObj, Attr.AxisSize);
        return n;
    }

    public int getAxisSize(int n) {
        return this.getAxisSize(new IdentObj(n));
    }

    public void setAxisSize(int n) {
        this.putToLookAndRepaint(Attr.AxisSize, new Integer(n));
    }

    public void setAxisSize(IdentObj identObj, int n) {
        this.putToLookAndRepaint(identObj, Attr.AxisSize, new Integer(n));
    }

    public void setAxisSize(int n, int n2) {
        this.setAxisSize(new IdentObj(n), n2);
    }

    public int getAxisOffset() {
        Integer n = (Integer)this.getFromLook(Attr.AxisOffset);
        return n;
    }

    public int getAxisOffset(IdentObj identObj) {
        Integer n = (Integer)this.getFromLook(identObj, Attr.AxisOffset);
        return n;
    }

    public int getAxisOffset(int n) {
        return this.getAxisOffset(new IdentObj(n));
    }

    public void setAxisOffset(int n) {
        this.putToLookAndRepaint(Attr.AxisOffset, new Integer(n));
    }

    public void setAxisOffset(IdentObj identObj, int n) {
        this.putToLookAndRepaint(identObj, Attr.AxisOffset, new Integer(n));
    }

    public void setAxisOffset(int n, int n2) {
        this.setAxisOffset(new IdentObj(n), n2);
    }

    public boolean getPrimitiveAntialiasing() {
        Boolean bl = (Boolean)this.getFromLook(new IdentObj(2000), Attr.PrimitiveAntialiasing);
        return bl;
    }

    public void setPrimitiveAntialiasing(boolean bl) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.PrimitiveAntialiasing, new Boolean(bl));
    }

    public boolean getTextAntialiasing() {
        Boolean bl = (Boolean)this.getFromLook(new IdentObj(2000), Attr.TextAntialiasing);
        return bl;
    }

    public void setTextAntialiasing(boolean bl) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.TextAntialiasing, new Boolean(bl));
    }

    public boolean getTextTruncate() {
        Boolean bl = (Boolean)this.getFromLook(Attr.TextTruncate);
        return bl;
    }

    public boolean getTextTruncate(IdentObj identObj) {
        Boolean bl = (Boolean)this.getFromLook(identObj, Attr.TextTruncate);
        return bl;
    }

    public boolean getTextTruncate(int n) {
        return this.getTextTruncate(new IdentObj(n));
    }

    public void setTextTruncate(boolean bl) {
        this.putToLookAndRepaint(Attr.TextTruncate, new Boolean(bl));
    }

    public void setTextTruncate(IdentObj identObj, boolean bl) {
        this.putToLookAndRepaint(identObj, Attr.TextTruncate, new Boolean(bl));
    }

    public void setTextTruncate(int n, boolean bl) {
        this.setTextTruncate(new IdentObj(n), bl);
    }

    public int getParetoDisplayThreshold() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.ParetoDisplayThreshold);
        return n;
    }

    public void setParetoDisplayThreshold(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.ParetoDisplayThreshold, new Integer(n));
    }

    public boolean getNonZeroBaseline() {
        Boolean bl = (Boolean)this.getFromLook(Attr.NonZeroBaseline);
        return bl;
    }

    public boolean getNonZeroBaseline(IdentObj identObj) {
        Boolean bl = (Boolean)this.getFromLook(identObj, Attr.NonZeroBaseline);
        return bl;
    }

    public boolean getNonZeroBaseline(int n) {
        return this.getNonZeroBaseline(new IdentObj(n));
    }

    public void setNonZeroBaseline(boolean bl) {
        this.putToLookAndRepaint(Attr.NonZeroBaseline, new Boolean(bl));
    }

    public void setNonZeroBaseline(IdentObj identObj, boolean bl) {
        this.putToLookAndRepaint(identObj, Attr.NonZeroBaseline, new Boolean(bl));
    }

    public void setNonZeroBaseline(int n, boolean bl) {
        this.setNonZeroBaseline(new IdentObj(n), bl);
    }

    public boolean getTransparentMarkers() {
        Boolean bl = (Boolean)this.getFromLook(new IdentObj(2000), Attr.TransparentMarkers);
        return bl;
    }

    public void setTransparentMarkers(boolean bl) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.TransparentMarkers, new Boolean(bl));
    }

    public int getTransparentMarkerSize() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.TransparentMarkerSize);
        return n;
    }

    public void setTransparentMarkerSize(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.TransparentMarkerSize, new Integer(n));
    }

    public int getSeriesLineWidthDefault() {
        Integer n = (Integer)this.getFromLook(new IdentObj(2000), Attr.SeriesLineWidthDefault);
        return n;
    }

    public void setSeriesLineWidthDefault(int n) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.SeriesLineWidthDefault, new Integer(n));
    }

    public boolean getIgnoreGridSkip() {
        Boolean bl = (Boolean)this.getFromLook(new IdentObj(2000), Attr.IgnoreGridSkip);
        return bl;
    }

    public void setIgnoreGridSkip(boolean bl) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.IgnoreGridSkip, new Boolean(bl));
    }

    public boolean getToolTipTimeOutEnabled() {
        Boolean bl = (Boolean)this.getFromLook(new IdentObj(2000), Attr.ToolTipTimeOutEnabled);
        return bl;
    }

    public void setToolTipTimeOutEnabled(boolean bl) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.ToolTipTimeOutEnabled, new Boolean(bl));
    }

    public boolean getToolTipDisplayTimeOut() {
        Boolean bl = (Boolean)this.getFromLook(new IdentObj(2000), Attr.ToolTipDisplayTimeOut);
        return bl;
    }

    public void setToolTipDisplayTimeOut(boolean bl) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.ToolTipDisplayTimeOut, new Boolean(bl));
    }

    public boolean getUseDefaultBubbleMarker() {
        Boolean bl = (Boolean)this.getFromLook(new IdentObj(2000), Attr.UseDefaultBubbleMarker);
        return bl;
    }

    public void setUseDefaultBubbleMarker(boolean bl) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.UseDefaultBubbleMarker, new Boolean(bl));
    }

    public boolean getSizeToContainer() {
        Boolean bl = (Boolean)this.getFromLook(new IdentObj(2000), Attr.SizeToContainer);
        return bl;
    }

    public void setSizeToContainer(boolean bl) {
        this.putToLookAndRepaint(new IdentObj(2000), Attr.SizeToContainer, new Boolean(bl));
    }

    public IdentObj getChartBackground() {
        return new IdentObj(1);
    }

    public IdentObj getFrame() {
        return new IdentObj(2);
    }

    public IdentObj getFootnote() {
        return new IdentObj(3);
    }

    public IdentObj getSubtitle() {
        return new IdentObj(4);
    }

    public IdentObj getTitle() {
        return new IdentObj(5);
    }

    public IdentObj getY1Title() {
        return new IdentObj(6);
    }

    public IdentObj getY2Title() {
        return new IdentObj(7);
    }

    public IdentObj getY3Title() {
        return new IdentObj(67);
    }

    public IdentObj getY4Title() {
        return new IdentObj(69);
    }

    public IdentObj getY5Title() {
        return new IdentObj(71);
    }

    public IdentObj getO1Title() {
        return new IdentObj(8);
    }

    public IdentObj getO2Title() {
        return new IdentObj(9);
    }

    public IdentObj getX1Title() {
        return new IdentObj(10);
    }

    public IdentObj getO1DrillLabel() {
        return new IdentObj(232);
    }

    public IdentObj getO2DrillLabel() {
        return new IdentObj(233);
    }

    public IdentObj getDrillMarker() {
        return new IdentObj(234);
    }

    public IdentObj getDrillText() {
        return new IdentObj(235);
    }

    public IdentObj getLegendArea() {
        return new IdentObj(12);
    }

    public IdentObj getLegendMarker() {
        return new IdentObj(13);
    }

    public IdentObj getLegendText() {
        return new IdentObj(14);
    }

    public IdentObj getFrameSide() {
        return new IdentObj(15);
    }

    public IdentObj getFrameBottom() {
        return new IdentObj(16);
    }

    public IdentObj getFrameSeparator() {
        return new IdentObj(17);
    }

    public IdentObj getSpectralLegendMarker() {
        return new IdentObj(18);
    }

    public IdentObj getGroupScroller() {
        return new IdentObj(19);
    }

    public IdentObj getGroupScrollerThumb() {
        return new IdentObj(20);
    }

    public IdentObj getGroupScrollerEditBox() {
        return new IdentObj(21);
    }

    public IdentObj getGroupScrollerEditLeft() {
        return new IdentObj(22);
    }

    public IdentObj getGroupScrollerEditThumb() {
        return new IdentObj(23);
    }

    public IdentObj getGroupScrollerEditRight() {
        return new IdentObj(24);
    }

    public IdentObj getSeriesScroller() {
        return new IdentObj(25);
    }

    public IdentObj getSeriesScrollerThumb() {
        return new IdentObj(26);
    }

    public IdentObj getSeriesScrollerEditBox() {
        return new IdentObj(27);
    }

    public IdentObj getSeriesScrollerEditLeft() {
        return new IdentObj(28);
    }

    public IdentObj getSeriesScrollerEditThumb() {
        return new IdentObj(29);
    }

    public IdentObj getSeriesScrollerEditRight() {
        return new IdentObj(30);
    }

    public IdentObj getNestedO1Label0() {
        return new IdentObj(31);
    }

    public IdentObj getNestedO1Label1() {
        return new IdentObj(32);
    }

    public IdentObj getNestedO1Label2() {
        return new IdentObj(33);
    }

    public IdentObj getNestedO1Label3() {
        return new IdentObj(34);
    }

    public IdentObj getNestedO1Label4() {
        return new IdentObj(35);
    }

    public IdentObj getNestedO1Label5() {
        return new IdentObj(36);
    }

    public IdentObj getNestedO1Label6() {
        return new IdentObj(37);
    }

    public IdentObj getNestedO1Label7() {
        return new IdentObj(38);
    }

    public IdentObj getNestedO1Label8() {
        return new IdentObj(39);
    }

    public IdentObj getNestedO1LabelLine() {
        return new IdentObj(40);
    }

    public IdentObj getCurveFitLineRiser() {
        return new IdentObj(41);
    }

    public IdentObj getCurveFitEquationText() {
        return new IdentObj(42);
    }

    public IdentObj getCurveFitCorrelationText() {
        return new IdentObj(43);
    }

    public IdentObj getFootnoteBox() {
        return new IdentObj(44);
    }

    public IdentObj getSubtitleBox() {
        return new IdentObj(45);
    }

    public IdentObj getTitleBox() {
        return new IdentObj(46);
    }

    public IdentObj getO1TitleBox() {
        return new IdentObj(49);
    }

    public IdentObj getO2TitleBox() {
        return new IdentObj(50);
    }

    public IdentObj getX1TitleBox() {
        return new IdentObj(51);
    }

    public IdentObj getY1TitleBox() {
        return new IdentObj(47);
    }

    public IdentObj getY2TitleBox() {
        return new IdentObj(48);
    }

    public IdentObj getZ1TitleBox() {
        return new IdentObj(52);
    }

    public IdentObj getO1DrillLabelBox() {
        return new IdentObj(230);
    }

    public IdentObj getO2DrillLabelBox() {
        return new IdentObj(231);
    }

    public IdentObj getLegendTextBox() {
        return new IdentObj(53);
    }

    public IdentObj getNestedO1Label0Box() {
        return new IdentObj(54);
    }

    public IdentObj getNestedO1Label1Box() {
        return new IdentObj(55);
    }

    public IdentObj getNestedO1Label2Box() {
        return new IdentObj(56);
    }

    public IdentObj getNestedO1Label3Box() {
        return new IdentObj(57);
    }

    public IdentObj getNestedO1Label4Box() {
        return new IdentObj(58);
    }

    public IdentObj getNestedO1Label5Box() {
        return new IdentObj(59);
    }

    public IdentObj getNestedO1Label6Box() {
        return new IdentObj(60);
    }

    public IdentObj getNestedO1Label7Box() {
        return new IdentObj(61);
    }

    public IdentObj getNestedO1Label8Box() {
        return new IdentObj(62);
    }

    public IdentObj getCurveFitEquationTextBox() {
        return new IdentObj(63);
    }

    public IdentObj getCurveFitCorrelationTextBox() {
        return new IdentObj(64);
    }

    public IdentObj getAreaRiser() {
        return new IdentObj(256);
    }

    public IdentObj getLineRiser() {
        return new IdentObj(258);
    }

    public IdentObj getLineMarker() {
        return new IdentObj(259);
    }

    public IdentObj getDataText() {
        return new IdentObj(260);
    }

    public IdentObj getO1AxisLine() {
        return new IdentObj(269);
    }

    public IdentObj getO1Label() {
        return new IdentObj(270, -3, 0);
    }

    public IdentObj getO1MajorGrid() {
        return new IdentObj(271, true);
    }

    public IdentObj getO1MinorGrid() {
        return new IdentObj(272, true);
    }

    public IdentObj getO2AxisLine() {
        return new IdentObj(273);
    }

    public IdentObj getO2Label() {
        return new IdentObj(274, 0, -3);
    }

    public IdentObj getO2MajorGrid() {
        return new IdentObj(275, true);
    }

    public IdentObj getO2MinorGrid() {
        return new IdentObj(276, true);
    }

    public IdentObj getBarRiser() {
        return new IdentObj(277);
    }

    public IdentObj getX1AxisLine() {
        return new IdentObj(279);
    }

    public IdentObj getX1Label() {
        return new IdentObj(280);
    }

    public IdentObj getX1MajorGrid() {
        return new IdentObj(281, true);
    }

    public IdentObj getX1MinorGrid() {
        return new IdentObj(282, true);
    }

    public IdentObj getY1AxisLine() {
        return new IdentObj(283);
    }

    public IdentObj getY1Label() {
        return new IdentObj(284);
    }

    public IdentObj getY1MajorGrid() {
        return new IdentObj(285, true);
    }

    public IdentObj getY1MinorGrid() {
        return new IdentObj(286, true);
    }

    public IdentObj getY2AxisLine() {
        return new IdentObj(287);
    }

    public IdentObj getY2Label() {
        return new IdentObj(288);
    }

    public IdentObj getY2MajorGrid() {
        return new IdentObj(289, true);
    }

    public IdentObj getY2MinorGrid() {
        return new IdentObj(290, true);
    }

    public IdentObj getX1ZeroLine() {
        return new IdentObj(291);
    }

    public IdentObj getY1ZeroLine() {
        return new IdentObj(292);
    }

    public IdentObj getY2ZeroLine() {
        return new IdentObj(293);
    }

    public IdentObj getPieFeelerLine() {
        return new IdentObj(294);
    }

    public IdentObj getPieSliceLabel() {
        return new IdentObj(295);
    }

    public IdentObj getPieLabel() {
        return new IdentObj(296);
    }

    public IdentObj getPieRingLabel() {
        return new IdentObj(297);
    }

    public IdentObj getSlice() {
        return new IdentObj(298);
    }

    public IdentObj getPieBarSlice() {
        return new IdentObj(332);
    }

    public IdentObj getSliceCrust() {
        return new IdentObj(299);
    }

    public IdentObj getPieBarSliceCrust() {
        return new IdentObj(333);
    }

    public IdentObj getSliceRing() {
        return new IdentObj(300);
    }

    public IdentObj getPieBarConnectLines() {
        return new IdentObj(301);
    }

    public IdentObj getPieFrame() {
        return new IdentObj(302);
    }

    public IdentObj getStockRiser() {
        return new IdentObj(303);
    }

    public IdentObj getStock52WeekHighLine() {
        return new IdentObj(304);
    }

    public IdentObj getStock52WeekLowLine() {
        return new IdentObj(305);
    }

    public IdentObj getStockLowerRiser() {
        return new IdentObj(306);
    }

    public IdentObj getStockCloseTick() {
        return new IdentObj(307);
    }

    public IdentObj getStockOpenTick() {
        return new IdentObj(308);
    }

    public IdentObj getStockMALine() {
        return new IdentObj(309);
    }

    public IdentObj getStockVolumeRiser() {
        return new IdentObj(310);
    }

    public IdentObj getStockRisingRiser() {
        return new IdentObj(319);
    }

    public IdentObj getStockFallingRiser() {
        return new IdentObj(320);
    }

    public IdentObj getStockHighLine() {
        return new IdentObj(321);
    }

    public IdentObj getStockLowLine() {
        return new IdentObj(322);
    }

    public IdentObj getHistogramRiser() {
        return new IdentObj(311);
    }

    public IdentObj getBarRiserSide() {
        return new IdentObj(312);
    }

    public IdentObj getBarRiserBottom() {
        return new IdentObj(313);
    }

    public IdentObj getAreaRiserTop() {
        return new IdentObj(314);
    }

    public IdentObj getAreaRiserBottom() {
        return new IdentObj(316);
    }

    public IdentObj getLineRiserSide() {
        return new IdentObj(317);
    }

    public IdentObj getLineRiserTop() {
        return new IdentObj(318);
    }

    public IdentObj getQuadrantLine() {
        return new IdentObj(328);
    }

    public IdentObj getScatterQuadrantLine() {
        return new IdentObj(329);
    }

    public IdentObj getSpectralMarker() {
        return new IdentObj(330);
    }

    public IdentObj getPieBarRiser() {
        return new IdentObj(331);
    }

    public IdentObj getPieBarRiserSide() {
        return new IdentObj(334);
    }

    public IdentObj getPieBarRiserTop() {
        return new IdentObj(335);
    }

    public IdentObj getPieBarLabel() {
        return new IdentObj(355);
    }

    public IdentObj getWaterfallLine() {
        return new IdentObj(439);
    }

    public IdentObj getY3AxisLine() {
        return new IdentObj(440);
    }

    public IdentObj getY3Label() {
        return new IdentObj(441);
    }

    public IdentObj getY3MajorGrid() {
        return new IdentObj(442);
    }

    public IdentObj getY3MinorGrid() {
        return new IdentObj(443);
    }

    public IdentObj getY3ZeroLine() {
        return new IdentObj(444);
    }

    public IdentObj getY4AxisLine() {
        return new IdentObj(445);
    }

    public IdentObj getY4Label() {
        return new IdentObj(446);
    }

    public IdentObj getY4MajorGrid() {
        return new IdentObj(447);
    }

    public IdentObj getY4MinorGrid() {
        return new IdentObj(448);
    }

    public IdentObj getY4ZeroLine() {
        return new IdentObj(449);
    }

    public IdentObj getY5AxisLine() {
        return new IdentObj(450);
    }

    public IdentObj getY5Label() {
        return new IdentObj(451);
    }

    public IdentObj getY5MajorGrid() {
        return new IdentObj(452);
    }

    public IdentObj getY5MinorGrid() {
        return new IdentObj(453);
    }

    public IdentObj getY5ZeroLine() {
        return new IdentObj(454);
    }

    public IdentObj getBreakevenLossArea() {
        return new IdentObj(367);
    }

    public IdentObj getBreakevenProfitArea() {
        return new IdentObj(368);
    }

    public IdentObj getBreakevenLossLabel() {
        return new IdentObj(369);
    }

    public IdentObj getBreakevenProfitLabel() {
        return new IdentObj(370);
    }

    public IdentObj getBreakevenSummaryLabel() {
        return new IdentObj(371);
    }

    public IdentObj getCubeFloor() {
        return new IdentObj(514);
    }

    public IdentObj getCubeLeftWall() {
        return new IdentObj(515);
    }

    public IdentObj getCubeRightWall() {
        return new IdentObj(516);
    }

    public IdentObj getCubeRiserFace() {
        return new IdentObj(517);
    }

    public IdentObj getCubeRiserGridX() {
        return new IdentObj(518);
    }

    public IdentObj getCubeRiserGridY() {
        return new IdentObj(519);
    }

    public IdentObj getCubeRiserGridZ() {
        return new IdentObj(520);
    }

    public IdentObj getCubeFloorGridX() {
        return new IdentObj(525);
    }

    public IdentObj getCubeFloorGridZ() {
        return new IdentObj(526);
    }

    public IdentObj getCubeLeftWallGridY() {
        return new IdentObj(527);
    }

    public IdentObj getCubeLeftWallGridZ() {
        return new IdentObj(528);
    }

    public IdentObj getCubeRightWallGridX() {
        return new IdentObj(529);
    }

    public IdentObj getCubeRightWallGridY() {
        return new IdentObj(530);
    }

    public IdentObj getO1Axis() {
        return new IdentObj(2001);
    }

    public IdentObj getO2Axis() {
        return new IdentObj(2002);
    }

    public IdentObj getX1Axis() {
        return new IdentObj(2003);
    }

    public IdentObj getY1Axis() {
        return new IdentObj(2004);
    }

    public IdentObj getY2Axis() {
        return new IdentObj(2005);
    }

    public IdentObj getY3Axis() {
        return new IdentObj(2012);
    }

    public IdentObj getY4Axis() {
        return new IdentObj(2013);
    }

    public IdentObj getY5Axis() {
        return new IdentObj(2014);
    }

    public IdentObj getColorByHeight() {
        return new IdentObj(2007);
    }

    public IdentObj getSeries(int n) {
        return new IdentObj(-3, n);
    }

    public IdentObj getGroup(int n) {
        return new IdentObj(-3, -3, n);
    }

    public IdentObj getSeriesGroup(int n, int n2) {
        return new IdentObj(-3, n, n2);
    }

    public IdentObj getGlobal() {
        return new IdentObj(2000);
    }

    public IdentObj getAreaRiser(int n, int n2) {
        return new IdentObj(256, n, n2);
    }

    public IdentObj getBarRiser(int n, int n2) {
        return new IdentObj(277, n, n2);
    }

    public IdentObj getCurveFitEquationText(int n) {
        return new IdentObj(42, n);
    }

    public IdentObj getCurveFitLineRiser(int n) {
        return new IdentObj(41, n);
    }

    public IdentObj getDataText(int n, int n2) {
        return new IdentObj(260, n, n2);
    }

    public IdentObj getLegendMarker(int n) {
        return new IdentObj(13, n);
    }

    public IdentObj getLegendText(int n) {
        return new IdentObj(14, n);
    }

    public IdentObj getLineMarker(int n, int n2) {
        return new IdentObj(259, n, n2);
    }

    public IdentObj getLineRiser(int n, int n2) {
        return new IdentObj(258, n, n2);
    }

    public IdentObj getO1Label(int n) {
        return new IdentObj(270, -3, n);
    }

    public IdentObj getPieBarConnectLineBottom() {
        IdentObj identObj = new IdentObj(301);
        identObj.setMiscID(400);
        return identObj;
    }

    public IdentObj getPieBarConnectLineTop() {
        IdentObj identObj = new IdentObj(301);
        identObj.setMiscID(300);
        return identObj;
    }

    public IdentObj getPieBarSlice(int n, int n2) {
        IdentObj identObj = new IdentObj(332, n, n2);
        identObj.setMiscID(1000);
        return identObj;
    }

    public IdentObj getPieFeelerLine(int n, int n2) {
        IdentObj identObj = new IdentObj(294, n, n2);
        identObj.setMiscID(200);
        return identObj;
    }

    public IdentObj getPieSliceLabel(int n, int n2) {
        return new IdentObj(295, n, n2);
    }

    public IdentObj getPieLabel(int n) {
        return new IdentObj(296, -3, n);
    }

    public IdentObj getPieRingLabel(int n) {
        return new IdentObj(297, -3, n);
    }

    public IdentObj getSlice(int n, int n2) {
        IdentObj identObj = new IdentObj(298, n, n2);
        identObj.setMiscID(1000);
        return identObj;
    }

    public IdentObj getSpectralLegendMarker(int n) {
        IdentObj identObj = new IdentObj(18);
        identObj.setMiscID(n);
        return identObj;
    }

    public IdentObj getStockMALine(int n, int n2) {
        return new IdentObj(309, n, n2);
    }

    public IdentObj getStockVolumeRiser(int n) {
        return new IdentObj(310, 1, n);
    }

    public IdentObj getStockCloseTick(int n, int n2) {
        return new IdentObj(307, n, n2);
    }

    public IdentObj getStockOpenTick(int n, int n2) {
        return new IdentObj(308, n, n2);
    }

    public IdentObj getStockRisingRiser(int n, int n2) {
        return new IdentObj(319, n, n2);
    }

    public IdentObj getStockFallingRiser(int n, int n2) {
        return new IdentObj(320, n, n2);
    }

    public IdentObj getLegendScroller() {
        return new IdentObj(65);
    }

    public IdentObj getLegendScrollerThumb() {
        return new IdentObj(66);
    }

    public IdentObj getReferenceLineLegendText() {
        return new IdentObj(248);
    }

    public String getAlertLabel() {
        String string = (String)this.getFromLook(Attr.AlertLabel, 1);
        return string;
    }

    public String getAlertLabel(IdentObj identObj) {
        String string = (String)this.getFromLook(identObj, Attr.AlertLabel);
        return string;
    }

    public String getAlertLabel(int n) {
        IdentObj identObj = new IdentObj(-3, n, -3);
        return this.getAlertLabel(identObj);
    }

    public void setAlertLabel(String string) {
        this.putToLookAndRepaint(Attr.AlertLabel, string, 1);
    }

    public void setAlertLabel(IdentObj identObj, String string) {
        this.putToLookAndRepaint(identObj, Attr.AlertLabel, string);
    }

    public void setAlertLabel(int n, String string) {
        IdentObj identObj = new IdentObj(-3, n, -3);
        this.setAlertLabel(identObj, string);
    }

    public void setY3LogScale(boolean bl) {
        this.setLogScale(this.getY3Axis(), bl);
    }

    public boolean getY3LogScale() {
        return this.getLogScale(this.getY3Axis());
    }

    public void setY4LogScale(boolean bl) {
        this.setLogScale(this.getY4Axis(), bl);
    }

    public boolean getY4LogScale() {
        return this.getLogScale(this.getY4Axis());
    }

    public void setY5LogScale(boolean bl) {
        this.setLogScale(this.getY5Axis(), bl);
    }

    public boolean getY5LogScale() {
        return this.getLogScale(this.getY5Axis());
    }

    public boolean getY3AxisDescending() {
        return this.getAxisDescending(this.getY3Axis());
    }

    public void setY3AxisDescending(boolean bl) {
        this.setAxisDescending(this.getY3Axis(), bl);
    }

    public boolean getY4AxisDescending() {
        return this.getAxisDescending(this.getY4Axis());
    }

    public void setY4AxisDescending(boolean bl) {
        this.setAxisDescending(this.getY4Axis(), bl);
    }

    public boolean getY5AxisDescending() {
        return this.getAxisDescending(this.getY5Axis());
    }

    public void setY5AxisDescending(boolean bl) {
        this.setAxisDescending(this.getY5Axis(), bl);
    }

    public Iterator getPropertyIterator() {
        return this.m_look.keySet().iterator();
    }
}

