/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicToolTipUI;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.help.HelpProvider;
import oracle.bali.ewt.olaf.OracleLookAndFeel;
import oracle.bali.ewt.painter.NullPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.painter.PainterComponent;
import oracle.bali.ewt.painter.WrappingTextPainter;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.TextWrapper;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.graph.Graph;
import oracle.dss.graph.GraphTypeAndSubtype;
import oracle.dss.graph.GraphTypeConverter;
import oracle.dss.graph.Subtype;
import oracle.dss.graph.Type;
import oracle.dss.graph.UIGraph;
import oracle.dss.graph.gui.BasePanel;
import oracle.dss.graph.gui.GraphTypeConverterAdapter;
import oracle.dss.util.help.HelpContext;

public class GraphType
extends BasePanel
implements ListSelectionListener,
HelpContext {
    private ResourceBundle rBundle;
    private JLabel m_graphTypeLabel;
    Font m_innerFont;
    protected int m_numLinesInName = 2;
    protected JList m_graphTypeList;
    protected MyPainterButton m_subtypeDescriptionLabel;
    protected JPanel m_subtypeDescriptionLabelPanel;
    protected JPanel m_graphSubtypeListPanel;
    protected JPanel m_graphSubtypePanel;
    protected Subtype m_subtype;
    protected Vector m_type;
    protected Vector m_imageButton;
    protected Vector m_innerSubTypePanel;
    protected ButtonGroup m_group;
    protected int m_currentType;
    protected int m_currentSubtype;
    protected JScrollPane m_graphTypeScrollPane;
    protected JScrollPane m_graphSubtypeScrollPane;
    protected String m_toolTip;
    protected boolean m_bHelpEnabled = true;
    protected HelpProvider m_helpProvider;
    protected String m_strHelpContextID;
    protected ComponentAdapter m_componentListener;
    protected ItemListener m_itemListener;
    protected CellRenderer m_cellRenderer;
    protected KeyStroke m_keyStroke;
    public static final String DOUBLE_CLICK = "DoubleClickHappend";
    public static final String SUBTYPE_CHANGED = "SubtypeChanged";
    public static final String TYPE_CHANGED = "TypeChanged";

    public GraphType(Graph graph) {
        super(graph);
        Object object;
        this.updateResourceBundle(graph.getLocale());
        if (this.m_graph.getGraphTypeConverter() == null) {
            object = new GraphTypeConverterAdapter();
            this.m_graph.setGraphTypeConverter((GraphTypeConverter)object);
            ((GraphTypeConverterAdapter)object).setLocale(graph.getLocale());
        }
        this.setTitleText(this.rBundle.getString("create graph type"));
        this.m_mainPanel.setLayout(new BorderLayout(10, 0));
        this._initialiseGraphTypeList();
        this.m_graphTypeScrollPane = new JScrollPane(this.m_graphTypeList);
        object = new Dimension(this.m_graphTypeScrollPane.getPreferredSize().width, -1);
        this.m_graphTypeScrollPane.setPreferredSize((Dimension)object);
        this.m_graphTypeScrollPane.setMaximumSize((Dimension)object);
        this.m_graphTypeScrollPane.setMinimumSize((Dimension)object);
        this._initialiseGraphSubtypeListPanel();
        this.m_graphSubtypeScrollPane = new JScrollPane(this.m_graphSubtypeListPanel);
        this.m_graphSubtypeScrollPane.setVerticalScrollBar(new JScrollBar(){

            public boolean isFocusTraversable() {
                return false;
            }
        });
        this.m_graphSubtypeScrollPane.setHorizontalScrollBarPolicy(31);
        this.m_subtypeDescriptionLabel = new MyPainterButton((Painter)new MyWrappingTextPainter(WordWrapper.getTextWrapper(), ""));
        this.m_subtypeDescriptionLabelPanel = new JPanel();
        this.m_subtypeDescriptionLabelPanel.setBorder(new TitledBorder(this.rBundle.getString("Description")));
        this.m_subtypeDescriptionLabelPanel.setMinimumSize(new Dimension(this.m_subtypeDescriptionLabelPanel.getMinimumSize().width, 100));
        this.m_subtypeDescriptionLabelPanel.setMaximumSize(new Dimension(this.m_subtypeDescriptionLabelPanel.getMaximumSize().width, 100));
        this.m_subtypeDescriptionLabelPanel.setPreferredSize(new Dimension(this.m_subtypeDescriptionLabelPanel.getPreferredSize().width, 100));
        this.m_subtypeDescriptionLabelPanel.setLayout(new BoxLayout(this.m_subtypeDescriptionLabelPanel, 0));
        this.m_subtypeDescriptionLabel.setMinimumSize(new Dimension(this.m_subtypeDescriptionLabelPanel.getMinimumSize().width, 80));
        this.m_subtypeDescriptionLabel.setMaximumSize(new Dimension(this.m_subtypeDescriptionLabelPanel.getMaximumSize().width, 80));
        this.m_subtypeDescriptionLabel.setPreferredSize(new Dimension(this.m_subtypeDescriptionLabelPanel.getPreferredSize().width, 80));
        this.m_subtypeDescriptionLabelPanel.add((Component)((Object)this.m_subtypeDescriptionLabel));
        this.m_graphSubtypePanel = new JPanel();
        this.m_graphSubtypePanel.setLayout(new BoxLayout(this.m_graphSubtypePanel, 1));
        this.m_graphSubtypePanel.add(this.m_graphSubtypeScrollPane);
        this.m_graphSubtypePanel.add(this.m_subtypeDescriptionLabelPanel);
        this.m_graphSubtypeScrollPane.setAlignmentX(1.0f);
        this.m_subtypeDescriptionLabelPanel.setAlignmentX(1.0f);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.m_graphTypeScrollPane, "Center");
        String string = this.rBundle.getString("Graph type");
        this.m_graphTypeLabel = new JLabel(StringUtils.stripMnemonic((String)string));
        this.m_graphTypeLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        this.m_graphTypeLabel.setLabelFor(this.m_graphTypeList);
        jPanel.add((Component)this.m_graphTypeLabel, "North");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)this.m_graphSubtypePanel, "Center");
        string = this.rBundle.getString("Graph sub type");
        JLabel jLabel = new JLabel(StringUtils.stripMnemonic((String)string));
        jLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        jPanel2.add((Component)jLabel, "North");
        this.m_mainPanel.add((Component)jPanel, "West");
        this.m_mainPanel.add((Component)jPanel2, "Center");
        this.m_componentListener = new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                GraphType.this._adjustScrollBar();
                GraphType.this.m_graphSubtypeListPanel.invalidate();
                GraphType.this.m_graphSubtypeListPanel.validate();
                GraphType.this.m_graphTypeScrollPane.invalidate();
                GraphType.this.m_graphTypeScrollPane.validate();
            }
        };
        this.m_mainPanel.addComponentListener(this.m_componentListener);
        this.refresh();
        this.refreshCurrentType();
    }

    public void setGraph(Graph graph) {
        super.setGraph(graph);
        this.refresh();
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_mainPanel.removeComponentListener(this.m_componentListener);
        this.m_componentListener = null;
        this.m_graphTypeLabel.setLabelFor(null);
        this.m_cellRenderer.cleanUp();
        this.m_cellRenderer = null;
        this.m_graphTypeScrollPane.setViewportView(null);
        this.m_graphTypeList.removeListSelectionListener(this);
        this.m_graphTypeList.setCellRenderer(null);
        this.m_graphTypeList = null;
        this.m_graphSubtypeListPanel.unregisterKeyboardAction(this.m_keyStroke);
        while (this.m_innerSubTypePanel.size() > 0) {
            JNoTabToggleButton jNoTabToggleButton = (JNoTabToggleButton)this.m_imageButton.elementAt(0);
            this.m_imageButton.removeElementAt(0);
            this.m_group.remove(jNoTabToggleButton);
            jNoTabToggleButton.cleanUp();
            jNoTabToggleButton = null;
            InnerSubTypePanel innerSubTypePanel = (InnerSubTypePanel)this.m_innerSubTypePanel.elementAt(0);
            this.m_graphSubtypeListPanel.remove(innerSubTypePanel);
            this.m_innerSubTypePanel.removeElementAt(0);
            innerSubTypePanel.cleanUp();
            innerSubTypePanel = null;
        }
        this.m_subtypeDescriptionLabelPanel.remove((Component)((Object)this.m_subtypeDescriptionLabel));
        this.m_subtypeDescriptionLabel.cleanUp();
        this.m_subtypeDescriptionLabel = null;
    }

    private void updateResourceBundle(Locale locale) {
        this.rBundle = locale != null ? ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle", locale) : ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle");
    }

    private void _setupSubtype() {
        this.m_subtype = (Subtype)((Type)this.m_type.elementAt((int)this.m_currentType)).subtypes.elementAt(this.m_currentSubtype);
        this.m_subtypeDescriptionLabel.setText(this.m_subtype.description);
        this.m_toolTip = this.m_subtype.description;
        this._adjustScrollBar();
    }

    private void _initialiseGraphTypeList() {
        this.m_type = (Vector)this.m_graph.getGraphTypeConverter().getTypes().clone();
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < this.m_type.size()) {
            vector.addElement(((Type)this.m_type.elementAt((int)n)).name);
            ++n;
        }
        this.m_graphTypeList = new JList();
        this.m_graphTypeList.setSelectionMode(0);
        this.m_graphTypeList.setListData(vector);
        this.m_graphTypeList.setFixedCellHeight(this._getImageIcon("images/S_BAR_VERT_CLUST.gif").getIconHeight() + 5);
        this.m_cellRenderer = new CellRenderer();
        this.m_graphTypeList.setCellRenderer(this.m_cellRenderer);
    }

    private void _initialiseGraphSubtypeListPanel() {
        this.m_graphSubtypeListPanel = new JPanel();
        this.m_keyStroke = KeyStroke.getKeyStroke(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("Graph sub type")), 8);
        this.m_graphSubtypeListPanel.registerKeyboardAction(new GraphSubtypeKeyListener(), this.m_keyStroke, 2);
        this.m_graphSubtypeListPanel.setBackground(Color.white);
        this.m_graphSubtypeListPanel.setLayout(new FlowLayout(0));
        this.m_graphSubtypeListPanel.setBorder(new BevelBorder(1));
        int n = ((Type)this.m_type.elementAt((int)0)).subtypes.size();
        int n2 = 1;
        while (n2 < this.m_type.size()) {
            if (((Type)this.m_type.elementAt((int)n2)).subtypes.size() > n) {
                n = ((Type)this.m_type.elementAt((int)n2)).subtypes.size();
            }
            ++n2;
        }
        this.m_imageButton = new Vector();
        this.m_group = new ButtonGroup();
        this.m_innerSubTypePanel = new Vector();
        n2 = 0;
        while (n2 < n) {
            this.m_imageButton.addElement(null.new JNoTabToggleButton());
            this.m_group.add((JNoTabToggleButton)this.m_imageButton.elementAt(n2));
            this.m_innerSubTypePanel.addElement(new InnerSubTypePanel((JNoTabToggleButton)this.m_imageButton.elementAt(n2)));
            ++n2;
        }
        InnerSubTypePanel innerSubTypePanel = (InnerSubTypePanel)this.m_innerSubTypePanel.elementAt(0);
        this.m_innerFont = innerSubTypePanel.getLabelFont();
    }

    private ImageIcon _getImageIcon(String string) {
        return new ImageIcon(ImageUtils.getImageResource(Class.forName("oracle.dss.graph.gui.GraphType"), (String)string));
    }

    private void _adjustScrollBar() {
        int n = ((Type)this.m_type.elementAt((int)this.m_currentType)).subtypes.size();
        int n2 = (((FlowLayout)this.m_graphSubtypeListPanel.getLayout()).getVgap() + ((InnerSubTypePanel)this.m_innerSubTypePanel.elementAt(0)).getHeight()) * n;
        int n3 = this.m_graphSubtypeScrollPane.getViewport().getWidth();
        int n4 = ((InnerSubTypePanel)this.m_innerSubTypePanel.elementAt(0)).getWidth();
        int n5 = ((InnerSubTypePanel)this.m_innerSubTypePanel.elementAt(0)).getHeight();
        int n6 = 1;
        int n7 = ((FlowLayout)this.m_graphSubtypeListPanel.getLayout()).getHgap();
        if (n4 != 0) {
            n6 = (int)Math.floor((n3 - n7 + 1) / (n4 + n7));
        }
        if (n6 != 0) {
            n2 = (((FlowLayout)this.m_graphSubtypeListPanel.getLayout()).getVgap() + ((InnerSubTypePanel)this.m_innerSubTypePanel.elementAt(0)).getHeight()) * (int)Math.ceil((double)n / (double)n6);
        }
        this.m_graphSubtypeListPanel.setPreferredSize(new Dimension(n3, n2));
        this.m_graphSubtypeScrollPane.invalidate();
        this.m_graphSubtypeScrollPane.validate();
        int n8 = 0;
        n8 = n6 != 0 ? (((FlowLayout)this.m_graphSubtypeListPanel.getLayout()).getVgap() + ((InnerSubTypePanel)this.m_innerSubTypePanel.elementAt(0)).getHeight()) * (int)Math.floor(this.m_currentSubtype / n6) : ((FlowLayout)this.m_graphSubtypeListPanel.getLayout()).getVgap();
        if (this.m_graphSubtypeScrollPane.getVerticalScrollBar() != null) {
            this.m_graphSubtypeScrollPane.getVerticalScrollBar().setValue(n8);
        }
    }

    public int getCurrentType() {
        return this.m_currentType;
    }

    public int getCurrentSubtype() {
        return this.m_currentSubtype;
    }

    public void refresh() {
        Object object;
        if (this.m_graph.getGraphTypeConverter() == null) {
            object = new GraphTypeConverterAdapter();
            this.m_graph.setGraphTypeConverter((GraphTypeConverter)object);
            ((GraphTypeConverterAdapter)object).setLocale(this.m_graph.getLocale());
        }
        this.m_graphTypeList.removeListSelectionListener(this);
        this.m_graphTypeList.clearSelection();
        this.m_type = (Vector)this.m_graph.getGraphTypeConverter().getTypes().clone();
        object = new Vector();
        int n = 0;
        while (n < this.m_type.size()) {
            ((Vector)object).addElement(((Type)this.m_type.elementAt((int)n)).name);
            ++n;
        }
        this.m_graphTypeList.setListData(object);
        this.m_graphTypeList.addListSelectionListener(this);
        this.m_currentType = this.getTypeIndex(this.m_graph.getGraphTypeConverter().getTypeAndSubtype((UIGraph)this.m_graph).type);
        this.m_currentSubtype = this.getSubtypeIndex(this.m_currentType, this.m_graph.getGraphTypeConverter().getTypeAndSubtype((UIGraph)this.m_graph).subtype);
        this.m_graphTypeList.setSelectedIndex(this.m_currentType);
        this._setupSubtype();
        this.repaint();
    }

    protected int getTypeIndex(int n) {
        int n2 = this.m_type.size();
        int n3 = 0;
        while (n3 < n2) {
            Type type = (Type)this.m_type.elementAt(n3);
            if (n == type.id) {
                return n3;
            }
            ++n3;
        }
        return 0;
    }

    protected int getSubtypeIndex(int n, int n2) {
        Type type = (Type)this.m_type.elementAt(n);
        int n3 = type.subtypes.size();
        int n4 = 0;
        while (n4 < n3) {
            Subtype subtype = (Subtype)type.subtypes.elementAt(n4);
            if (n2 == subtype.id) {
                return n4;
            }
            ++n4;
        }
        return 0;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource() == this.m_graphTypeList) {
            this.refreshCurrentType();
        }
    }

    protected void refreshCurrentType() {
        Subtype subtype;
        Type type;
        InnerSubTypePanel innerSubTypePanel;
        boolean bl = false;
        int n = 0;
        this.m_graphSubtypeListPanel.removeAll();
        while (this.m_innerSubTypePanel.size() > 0) {
            JNoTabToggleButton jNoTabToggleButton = (JNoTabToggleButton)this.m_imageButton.elementAt(0);
            this.m_imageButton.removeElementAt(0);
            this.m_group.remove(jNoTabToggleButton);
            innerSubTypePanel = (InnerSubTypePanel)this.m_innerSubTypePanel.elementAt(0);
            this.m_graphSubtypeListPanel.remove(innerSubTypePanel);
            this.m_innerSubTypePanel.removeElementAt(0);
        }
        n = this.m_currentType;
        int n2 = this.m_currentSubtype;
        this.m_currentType = this.m_graphTypeList.getSelectedIndex();
        if (this.m_currentType == -1) {
            this.m_currentType = n;
            this.m_graphTypeList.setSelectedIndex(this.m_currentType);
        } else if (this.m_currentType != n) {
            this.m_currentSubtype = 0;
        }
        if (n != this.m_currentType) {
            this.firePropertyChange(TYPE_CHANGED, n, this.m_currentType);
        }
        if (n2 != this.m_currentSubtype) {
            this.firePropertyChange(SUBTYPE_CHANGED, n2, this.m_currentSubtype);
        }
        Type type2 = (Type)this.m_type.elementAt(this.m_currentType);
        int n3 = ((Type)this.m_type.elementAt((int)this.m_currentType)).subtypes.size();
        if (n3 > this.m_innerSubTypePanel.size()) {
            int n4 = this.m_innerSubTypePanel.size();
            while (n4 < n3) {
                this.m_imageButton.addElement(null.new JNoTabToggleButton());
                this.m_group.add((JNoTabToggleButton)this.m_imageButton.elementAt(n4));
                this.m_innerSubTypePanel.addElement(new InnerSubTypePanel((JNoTabToggleButton)this.m_imageButton.elementAt(n4)));
                ++n4;
            }
        }
        this.m_numLinesInName = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < n3) {
            type = (Type)this.m_type.elementAt(this.m_currentType);
            subtype = (Subtype)type.subtypes.elementAt(n6);
            innerSubTypePanel = (InnerSubTypePanel)this.m_innerSubTypePanel.elementAt(n6);
            innerSubTypePanel.updatePanel(subtype);
            this.m_graphSubtypeListPanel.add(innerSubTypePanel);
            ImageIcon imageIcon = this._getImageIcon(subtype.non_3D_fileName);
            n5 = innerSubTypePanel.getLineCount(imageIcon);
            if (n5 > this.m_numLinesInName) {
                this.m_numLinesInName = n5;
            }
            ++n6;
        }
        n6 = 0;
        while (n6 < n3) {
            type = (Type)this.m_type.elementAt(this.m_currentType);
            subtype = (Subtype)type.subtypes.elementAt(n6);
            innerSubTypePanel = (InnerSubTypePanel)this.m_innerSubTypePanel.elementAt(n6);
            innerSubTypePanel.resizeInnerSubtypePanel(subtype);
            ++n6;
        }
        this._setupSubtype();
        if (this.m_graphSubtypeScrollPane.getVerticalScrollBar() != null) {
            this.m_graphSubtypeScrollPane.getVerticalScrollBar().setValue(0);
        }
        if (this.m_graphSubtypeScrollPane.getHorizontalScrollBar() != null) {
            this.m_graphSubtypeScrollPane.getHorizontalScrollBar().setValue(0);
        }
        if (!((JNoTabToggleButton)this.m_imageButton.elementAt(this.m_currentSubtype)).isSelected()) {
            ((JNoTabToggleButton)this.m_imageButton.elementAt(this.m_currentSubtype)).doClick();
        }
        this.repaint();
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.updateResourceBundle(locale);
    }

    public void apply() {
        Type type = (Type)this.m_type.elementAt(this.m_currentType);
        int n = type.id;
        int n2 = ((Subtype)type.subtypes.elementAt((int)this.m_currentSubtype)).id;
        this.m_graph.getGraphTypeConverter().setTypeAndSubtype(this.m_graph, new GraphTypeAndSubtype(n, n2));
    }

    public Dimension getPreferredSize() {
        int n = Integer.parseInt(this.rBundle.getString("GraphTypePanelWidth"));
        int n2 = Integer.parseInt(this.rBundle.getString("GraphTypePanelHeight"));
        return new Dimension(n, n2);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public String getHelpContextID() {
        return this.getClass().getName();
    }

    public void setHelpContextID(String string) {
        this.m_strHelpContextID = string;
    }

    public void setHelpProvider(HelpProvider helpProvider) {
        this.m_helpProvider = helpProvider;
    }

    public HelpProvider getHelpProvider() {
        return this.m_helpProvider;
    }

    public void setHelpEnabled(boolean bl) {
        this.m_bHelpEnabled = bl;
    }

    public boolean isHelpEnabled() {
        return this.m_bHelpEnabled;
    }

    class MultiLineToolTip
    extends JToolTip {
        MultiLineToolTip() {
            if (!(UIManager.getLookAndFeel() instanceof OracleLookAndFeel)) {
                this.setUI(new MultiLineToolTipUI());
            }
        }
    }

    class MultiLineToolTipUI
    extends BasicToolTipUI {
        private String[] strs;
        private int maxWidth;

        MultiLineToolTipUI() {
        }

        public void paint(Graphics graphics, JComponent jComponent) {
            FontMetrics fontMetrics = GraphType.this.getToolkit().getFontMetrics(graphics.getFont());
            Dimension dimension = jComponent.getSize();
            graphics.setColor(jComponent.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            graphics.setColor(jComponent.getForeground());
            if (this.strs != null) {
                int n = 0;
                while (n < this.strs.length) {
                    graphics.drawString(this.strs[n], 3, fontMetrics.getHeight() * (n + 1));
                    ++n;
                }
            }
        }

        public Dimension getPreferredSize(JComponent jComponent) {
            int n;
            int n2;
            FontMetrics fontMetrics = GraphType.this.getToolkit().getFontMetrics(jComponent.getFont());
            String string = ((JToolTip)jComponent).getTipText();
            if (string == null) {
                string = "";
            }
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
            int n3 = 0;
            Vector<String> vector = new Vector<String>();
            try {
                String string2;
                while ((string2 = bufferedReader.readLine()) != null) {
                    n2 = SwingUtilities.computeStringWidth(fontMetrics, string2);
                    n3 = n3 < n2 ? n2 : n3;
                    vector.addElement(string2);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            n2 = vector.size();
            if (n2 < 1) {
                this.strs = null;
                n2 = 1;
            } else {
                this.strs = new String[n2];
                n = 0;
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    this.strs[n] = (String)enumeration.nextElement();
                    ++n;
                }
            }
            n = fontMetrics.getHeight() * n2;
            this.maxWidth = n3;
            return new Dimension(n3 + 6, n + 4);
        }
    }

    class MyWrappingTextPainter
    extends WrappingTextPainter {
        String text = "";

        public MyWrappingTextPainter(TextWrapper textWrapper, String string) {
            super(textWrapper);
        }

        public void setText(String string) {
            this.text = new String(string);
        }

        protected String getStringData(PaintContext paintContext) {
            return new String(this.text);
        }

        protected int paintText(PaintContext paintContext, Graphics graphics, FontMetrics fontMetrics, String string, int n, int n2, int n3, float f, int n4) {
            if (string.endsWith("...")) {
                StringBuffer stringBuffer = new StringBuffer(GraphType.this.m_toolTip);
                int n5 = stringBuffer.length();
                int n6 = 20;
                int n7 = 1;
                while (n6 < n5) {
                    int n8 = n6 + n7 - 1;
                    while (n8 < n5) {
                        if (stringBuffer.charAt(n8) == ' ') break;
                        ++n8;
                    }
                    if (n8 < n5) {
                        stringBuffer = stringBuffer.insert(n8, '\n');
                    }
                    ++n7;
                    n6 = n8 + 20;
                }
                GraphType.this.m_subtypeDescriptionLabel.setToolTipText(stringBuffer.toString());
            } else {
                GraphType.this.m_subtypeDescriptionLabel.setToolTipText(null);
            }
            return super.paintText(paintContext, graphics, fontMetrics, string, n, n2, n3, f, n4);
        }
    }

    class MyPainterButton
    extends PainterComponent {
        Painter _painter;

        public MyPainterButton(Painter painter) {
            super(painter);
            this._painter = painter;
            this.setAlignmentX(0.0f);
            this.setAlignmentY(0.0f);
        }

        public void setText(String string) {
            ((MyWrappingTextPainter)this._painter).setText(string);
            this.setPainter(this._painter);
            this.repaint();
            this.validate();
        }

        public void updateUI() {
        }

        public JToolTip createToolTip() {
            MultiLineToolTip multiLineToolTip = new MultiLineToolTip();
            multiLineToolTip.setComponent((JComponent)((Object)this));
            return multiLineToolTip;
        }

        public void cleanUp() {
            this.setPainter((Painter)new NullPainter());
            this._painter = null;
        }
    }

    class NoTabMultiLineLabel
    extends MultiLineLabel {
        NoTabMultiLineLabel() {
        }

        public boolean isFocusTraversable() {
            return false;
        }
    }

    class JNoTabToggleButton
    extends JToggleButton {
        protected boolean m_focusTraversable;

        JNoTabToggleButton() {
        }

        public boolean isFocusTraversable() {
            return this.m_focusTraversable;
        }

        public void setFocusTraversable(boolean bl) {
            this.m_focusTraversable = bl;
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleJNoTabToggleButton();
            }
            return this.accessibleContext;
        }

        public void cleanUp() {
            this.accessibleContext = null;
        }

        protected class AccessibleJNoTabToggleButton
        extends JToggleButton.AccessibleJToggleButton {
            protected AccessibleJNoTabToggleButton() {
                super(JNoTabToggleButton.this);
            }

            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.UNKNOWN;
            }
        }
    }

    class InnerSubTypePanel
    extends JPanel
    implements ItemListener {
        protected MultiLineLabel label;
        protected JNoTabToggleButton toggleButton;
        protected JPanel bottomPanel = new JPanel();
        protected JPanel buttonPanel = new JPanel();
        protected Color highlightColor = new Color(0, 0, 128);
        protected Color oldBackgroundColor;
        protected Color oldForegroundColor;
        protected InnerMouseAdapter mouse;
        protected InnerKeyAdapter keyAdapter;

        public InnerSubTypePanel(JNoTabToggleButton jNoTabToggleButton) {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.setBackground(Color.white);
            this.bottomPanel.setBackground(Color.white);
            this.toggleButton = jNoTabToggleButton;
            this.toggleButton.setBackground(Color.white);
            this.toggleButton.setBorder(UIManager.getBorder("Label.border"));
            this.buttonPanel.setLayout(new BorderLayout());
            this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
            this.buttonPanel.setBackground(Color.white);
            this.buttonPanel.add(this.toggleButton);
            this.label = null.new NoTabMultiLineLabel();
            this.label.setTextWrapper(WordWrapper.getTextWrapper());
            this.label.setAlignment(3);
            this.oldBackgroundColor = this.getBackground();
            this.oldForegroundColor = this.label.getForeground();
            this.add((Component)this.buttonPanel, "North");
            this.add((Component)this.label, "Center");
            this.add((Component)this.bottomPanel, "South");
            this.toggleButton.addItemListener(this);
            this.mouse = new InnerMouseAdapter();
            this.addMouseListener(this.mouse);
            this.toggleButton.addMouseListener(this.mouse);
            this.keyAdapter = new InnerKeyAdapter();
            this.addKeyListener(this.keyAdapter);
            this.toggleButton.addKeyListener(this.keyAdapter);
        }

        public int getHeight() {
            int n = this.toggleButton.getIcon().getIconHeight();
            n += GraphType.this.m_numLinesInName * this.getToolkit().getFontMetrics(this.label.getFont()).getHeight() + 5 + 6;
            return n += 5;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getSource() == this.toggleButton) {
                if (itemEvent.getStateChange() == 1) {
                    this.setBackground(this.highlightColor);
                    this.buttonPanel.setBackground(this.highlightColor);
                    this.bottomPanel.setBackground(Color.white);
                    this.label.setForeground(Color.white);
                    this.toggleButton.setFocusTraversable(true);
                    int n = 0;
                    while (n < GraphType.this.m_imageButton.size()) {
                        if (((JNoTabToggleButton)GraphType.this.m_imageButton.elementAt(n)).isSelected()) {
                            int n2 = GraphType.this.m_currentSubtype;
                            GraphType.this.m_currentSubtype = n;
                            Type type = (Type)GraphType.this.m_type.elementAt(GraphType.this.m_currentType);
                            int n3 = ((Subtype)type.subtypes.elementAt((int)GraphType.this.m_currentSubtype)).id;
                            GraphType.this.firePropertyChange(GraphType.SUBTYPE_CHANGED, n2, GraphType.this.m_currentSubtype);
                            break;
                        }
                        ++n;
                    }
                    GraphType.this._setupSubtype();
                } else {
                    this.setBackground(this.oldBackgroundColor);
                    this.buttonPanel.setBackground(this.oldBackgroundColor);
                    this.label.setForeground(this.oldForegroundColor);
                    this.toggleButton.setFocusTraversable(false);
                }
            }
        }

        public void doSelect() {
            this.toggleButton.requestFocus();
            this.toggleButton.setSelected(true);
            this.setBackground(this.highlightColor);
            this.buttonPanel.setBackground(this.highlightColor);
            this.label.setForeground(Color.white);
            this.bottomPanel.setBackground(Color.white);
            this.scrollRectToVisible(new Rectangle(0, 0, this.getSize().width, this.getSize().height));
        }

        public void updatePanel(Subtype subtype) {
            boolean bl = false;
            ImageIcon imageIcon = GraphType.this._getImageIcon(subtype.non_3D_fileName);
            Dimension dimension = new Dimension(imageIcon.getIconWidth() + 5, imageIcon.getIconHeight() + 6);
            this.toggleButton.setIcon(imageIcon);
            this.toggleButton.setMinimumSize(dimension);
            this.toggleButton.setMaximumSize(dimension);
            this.toggleButton.setPreferredSize(dimension);
            this.toggleButton.getAccessibleContext().setAccessibleName(String.valueOf(StringUtils.stripMnemonic((String)GraphType.this.rBundle.getString("Graph sub type"))) + subtype.name + GraphType.this.rBundle.getString("Description") + subtype.description);
            this.label.setText(subtype.name);
            this.setToolTipText(String.valueOf(subtype.name) + " " + GraphType.this.rBundle.getString("graph"));
            this.getAccessibleContext().setAccessibleName(this.toggleButton.getAccessibleContext().getAccessibleName());
            this.toggleButton.setToolTipText(String.valueOf(subtype.name) + " " + GraphType.this.rBundle.getString("graph"));
        }

        public int getLineCount(ImageIcon imageIcon) {
            String string = this.label.getText();
            int n = imageIcon.getIconWidth() + 20;
            int n2 = 0;
            int n3 = string.length();
            int n4 = 1;
            String string2 = "";
            String string3 = null;
            while (n2 < n3) {
                int n5 = string.indexOf(32, n2);
                if (n5 == -1 && n2 == 0) {
                    n4 = 1;
                    break;
                }
                if (n5 == -1) {
                    string3 = string.substring(n2 - 1, n3);
                    n5 = n3;
                } else {
                    string3 = n2 > 0 ? string.substring(n2 - 1, n5) : string.substring(n2, n5);
                }
                string2 = String.valueOf(string2) + string3;
                FontMetrics fontMetrics = this.getToolkit().getFontMetrics(this.label.getFont());
                int n6 = fontMetrics.stringWidth(string2);
                if (n6 > n) {
                    ++n4;
                    string2 = string3.substring(1, string3.length());
                }
                n2 = n5 + 1;
            }
            return n4;
        }

        public void resizeInnerSubtypePanel(Subtype subtype) {
            int n = 0;
            ImageIcon imageIcon = GraphType.this._getImageIcon(subtype.non_3D_fileName);
            int n2 = this.getLineCount(imageIcon);
            FontMetrics fontMetrics = this.getToolkit().getFontMetrics(this.label.getFont());
            int n3 = fontMetrics.getHeight();
            n = (GraphType.this.m_numLinesInName - n2) * n3;
            Dimension dimension = new Dimension(imageIcon.getIconWidth() + 20, n);
            this.bottomPanel.setMinimumSize(dimension);
            this.bottomPanel.setMaximumSize(dimension);
            this.bottomPanel.setPreferredSize(dimension);
            Dimension dimension2 = new Dimension(imageIcon.getIconWidth() + 20, this.getHeight());
            this.setMinimumSize(dimension2);
            this.setMaximumSize(dimension2);
            this.setPreferredSize(dimension2);
        }

        public void cleanUp() {
            this.remove((Component)this.label);
            this.label = null;
            this.toggleButton.setIcon(null);
            this.toggleButton.removeItemListener(this);
            this.removeKeyListener(this.keyAdapter);
            this.toggleButton.removeKeyListener(this.keyAdapter);
            this.keyAdapter = null;
            this.toggleButton.removeMouseListener(this.mouse);
            this.removeMouseListener(this.mouse);
            this.mouse = null;
            this.buttonPanel.remove(this.toggleButton);
            this.toggleButton.cleanUp();
            this.toggleButton = null;
        }

        public Font getLabelFont() {
            return this.label.getFont();
        }

        class InnerKeyAdapter
        extends KeyAdapter {
            InnerKeyAdapter() {
            }

            public void keyPressed(KeyEvent keyEvent) {
                int n;
                if (keyEvent.getKeyCode() == 37 || keyEvent.getKeyCode() == 38) {
                    if (GraphType.this.m_currentSubtype > 0) {
                        --GraphType.this.m_currentSubtype;
                        ((InnerSubTypePanel)GraphType.this.m_innerSubTypePanel.elementAt(GraphType.this.m_currentSubtype)).doSelect();
                        GraphType.this.firePropertyChange(GraphType.SUBTYPE_CHANGED, GraphType.this.m_currentSubtype + 1, GraphType.this.m_currentSubtype);
                        ((InnerSubTypePanel)GraphType.this.m_innerSubTypePanel.elementAt(GraphType.this.m_currentSubtype)).requestFocus();
                    }
                } else if ((keyEvent.getKeyCode() == 39 || keyEvent.getKeyCode() == 40) && GraphType.this.m_currentSubtype < (n = ((Type)GraphType.this.m_type.elementAt((int)GraphType.this.m_currentType)).subtypes.size()) - 1) {
                    ++GraphType.this.m_currentSubtype;
                    ((InnerSubTypePanel)GraphType.this.m_innerSubTypePanel.elementAt(GraphType.this.m_currentSubtype)).doSelect();
                    GraphType.this.firePropertyChange(GraphType.SUBTYPE_CHANGED, GraphType.this.m_currentSubtype - 1, GraphType.this.m_currentSubtype);
                    ((InnerSubTypePanel)GraphType.this.m_innerSubTypePanel.elementAt(GraphType.this.m_currentSubtype)).requestFocus();
                }
            }
        }

        class InnerMouseAdapter
        extends MouseAdapter {
            InnerMouseAdapter() {
            }

            public void mousePressed(MouseEvent mouseEvent) {
                InnerSubTypePanel.this.doSelect();
                ((InnerSubTypePanel)GraphType.this.m_innerSubTypePanel.elementAt(GraphType.this.m_currentSubtype)).requestFocus();
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() >= 2) {
                    GraphType.this.firePropertyChange(GraphType.DOUBLE_CLICK, false, true);
                }
            }
        }
    }

    class CellRenderer
    extends JLabel
    implements ListCellRenderer {
        protected Color highlightColor = new Color(0, 0, 128);

        public CellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = object.toString();
            this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
            this.setIcon(GraphType.this._getImageIcon(((Type)GraphType.this.m_type.elementAt((int)n)).fileName));
            this.setText(string);
            this.setToolTipText(String.valueOf(string) + " " + GraphType.this.rBundle.getString("graph"));
            if (bl) {
                this.setBackground(this.highlightColor);
                this.setForeground(Color.white);
            } else {
                this.setBackground(Color.white);
                this.setForeground(Color.black);
            }
            return this;
        }

        public void cleanUp() {
            this.setIcon(null);
        }
    }

    class GraphSubtypeKeyListener
    implements ActionListener {
        GraphSubtypeKeyListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ((InnerSubTypePanel)GraphType.this.m_innerSubTypePanel.elementAt(GraphType.this.m_currentSubtype)).doSelect();
        }
    }
}

