/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Color;
import oracle.dss.dataView.UIFillColor;
import oracle.dss.graph.BaseDataComponent;
import oracle.dss.graph.BaseGraphComponent;
import oracle.dss.graph.Graph;
import oracle.dss.graph.GraphDefaultValues;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class VolumeMarker
extends BaseDataComponent
implements UIFillColor {
    protected static final int ATTR_FILLCOLOR = 0;
    protected static final int ATTR_STYLE_MAXID = 1;
    protected int fillColor = GraphDefaultValues.getVolumeMarkerFillColor();

    public VolumeMarker(Graph graph, IdentObj identObj) {
        super(graph, identObj);
    }

    public Color getFillColor() {
        return this.m_pfj.getFillColor(this.m_pfj.getStockVolumeRiser());
    }

    public void setFillColor(Color color) {
        if (color == null) {
            this.m_graph.getErrorHandler().log("invalid Color value", this.getClass().toString(), "setFillColor( Color newColor)");
            return;
        }
        this.m_pfj.setFillColor(this.m_pfj.getStockVolumeRiser(), color);
        this.setPropertyOverrideFlags(0);
    }

    protected String getComponentName() {
        return "VolumeMarker";
    }

    protected int getStylePropertyCount() {
        return 1;
    }

    protected void setStyleXML(ObjectNode objectNode) {
        PropertyNode propertyNode = objectNode.getProperty("fillColor");
        if (propertyNode != null) {
            this.setFillColor(new Color(BaseGraphComponent.hexStringToInt(propertyNode.getValueAsString())));
        }
    }

    protected boolean getStyleXML(boolean bl, ObjectNode objectNode) {
        boolean bl2 = false;
        if (bl || this.isUserOverrideFlag(0)) {
            objectNode.addProperty("fillColor", BaseGraphComponent.toHexString(this.getFillColor().getRGB()));
            bl2 = true;
        }
        return bl2;
    }

    protected void resetStyle() {
        this.setFillColor(new Color(this.fillColor));
        super.resetStyle();
    }
}

