/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Color;
import java.util.Enumeration;
import oracle.dss.graph.BaseGraphComponent;
import oracle.dss.graph.Graph;
import oracle.dss.graph.GraphDefaultValues;
import oracle.dss.graph.UIReferenceLine;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public abstract class BaseReferenceLine
extends BaseGraphComponent
implements UIReferenceLine {
    protected double[] m_value = new double[3];
    protected boolean[] m_isCreated = new boolean[3];
    protected String m_elementName;
    protected static final int MAX_REFERENCE_LINES = 3;
    protected Color[] m_lineColor = new Color[3];
    protected boolean[] m_legend = new boolean[3];

    public BaseReferenceLine(Graph graph) {
        super(graph);
        int n = 0;
        while (n < 3) {
            this.m_value[n] = GraphDefaultValues.getReferenceLineValue();
            this.m_isCreated[n] = false;
            this.m_lineColor[n] = new Color(BaseGraphComponent.hexStringToInt(GraphDefaultValues.getReferenceLineColor(n)));
            this.m_legend[n] = GraphDefaultValues.isReferenceLineDisplayedInLegend();
            ++n;
        }
    }

    private IdentObj _getID(int n) {
        return this.m_pfj.getReferenceLine(this.m_identObj, n);
    }

    protected void create(double d, Color color, int n, int n2, String string, boolean bl, boolean bl2, int n3) {
        this.m_pfj.setDisplay(this._getID(n3), bl);
        this.m_pfj.setLineWidth(this._getID(n3), n);
        this.m_pfj.setLineStyle(this._getID(n3), n2);
        this.m_pfj.setTextString(this._getID(n3), string);
        this.m_pfj.setReferenceLine(this.m_identObj, n3, d);
        this.m_pfj.setDisplay(this.m_pfj.getReferenceLineLegendText(this.m_identObj, n3), bl2);
        this.m_pfj.setFillColor(this._getID(n3), color);
        this.m_isCreated[n3] = true;
    }

    protected void resetToDefault() {
        this.m_isCreated = new boolean[3];
    }

    public boolean selectObject(int n, int n2) {
        IdentObj identObj = this._getID(n);
        this.m_pfj.setSelection(identObj);
        return identObj.equals(this.m_pfj.getSelectionID());
    }

    public boolean isDisplayedInLegend(int n) {
        if (this.m_isCreated[n]) {
            return this.m_pfj.getDisplay(this.m_pfj.getReferenceLineLegendText(this.m_identObj, n));
        }
        return GraphDefaultValues.isReferenceLineDisplayedInLegend();
    }

    public void setDisplayedInLegend(boolean bl, int n) {
        if (n < 0 || n > 2) {
            this.m_graph.getErrorHandler().log("invalid index", this.getClass().getName(), "setDisplayedInLegend(boolean visible, int index)");
            return;
        }
        if (this.m_isCreated[n]) {
            this.m_pfj.setDisplay(this.m_pfj.getReferenceLineLegendText(this.m_identObj, n), bl);
        } else {
            this.create(GraphDefaultValues.getReferenceLineValue(), this.m_lineColor[n], GraphDefaultValues.getReferenceLineWidth(), GraphDefaultValues.getReferenceLineStyle(), GraphDefaultValues.getReferenceLineText(n), GraphDefaultValues.isReferenceLineVisible(), bl, n);
        }
        this.m_legend[n] = bl;
    }

    public Color getLineColor(int n) {
        if (this.m_isCreated[n]) {
            return this.m_pfj.getFillColor(this._getID(n));
        }
        return new Color(BaseGraphComponent.hexStringToInt(GraphDefaultValues.getReferenceLineColor(n)));
    }

    public void setLineColor(Color color, int n) {
        if (n < 0 || n > 2) {
            this.m_graph.getErrorHandler().log("invalid index", this.getClass().getName(), "setLineColor(Color newColor, int index)");
            return;
        }
        if (color == null) {
            this.m_graph.getErrorHandler().log("invalid Color value", this.getClass().toString(), "setLineColor(Color newColor, int index)");
            return;
        }
        if (this.m_isCreated[n]) {
            this.m_pfj.setFillColor(this._getID(n), color);
        } else {
            this.create(GraphDefaultValues.getReferenceLineValue(), color, GraphDefaultValues.getReferenceLineWidth(), GraphDefaultValues.getReferenceLineStyle(), GraphDefaultValues.getReferenceLineText(n), GraphDefaultValues.isReferenceLineVisible(), this.m_legend[n], n);
        }
        this.m_lineColor[n] = color;
    }

    public int getLineWidth(int n) {
        if (this.m_isCreated[n]) {
            return this.m_pfj.getLineWidth(this._getID(n));
        }
        return GraphDefaultValues.getReferenceLineWidth();
    }

    public void setLineWidth(int n, int n2) {
        if (n2 < 0 || n2 > 2) {
            this.m_graph.getErrorHandler().log("invalid index", this.getClass().getName(), "setLineWidth(int width, int index)");
            return;
        }
        if (this.m_isCreated[n2]) {
            this.m_pfj.setLineWidth(this._getID(n2), n);
        } else {
            this.create(GraphDefaultValues.getReferenceLineValue(), this.m_lineColor[n2], n, GraphDefaultValues.getReferenceLineStyle(), GraphDefaultValues.getReferenceLineText(n2), GraphDefaultValues.isReferenceLineVisible(), this.m_legend[n2], n2);
        }
    }

    public int getLineStyle(int n) {
        return this.m_pfj.getLineStyle(this._getID(n));
    }

    public void setLineStyle(int n, int n2) {
        if (n < 0 || n > 3) {
            this.m_graph.getErrorHandler().log("invalid line style", this.getClass().getName(), "setLineStyle (int style)");
            return;
        }
        if (this.m_isCreated[n2]) {
            this.m_pfj.setLineStyle(this._getID(n2), n);
        } else {
            this.create(GraphDefaultValues.getReferenceLineValue(), this.m_lineColor[n2], GraphDefaultValues.getReferenceLineWidth(), n, GraphDefaultValues.getReferenceLineText(n2), GraphDefaultValues.isReferenceLineVisible(), this.m_legend[n2], n2);
        }
    }

    public String getText(int n) {
        if (this.m_isCreated[n]) {
            return this.m_pfj.getTextString(this._getID(n));
        }
        return GraphDefaultValues.getReferenceLineText(n);
    }

    public void setText(String string, int n) {
        if (n < 0 || n > 2) {
            this.m_graph.getErrorHandler().log("invalid index", this.getClass().getName(), "setText(String str, int index )");
            return;
        }
        if (this.m_isCreated[n]) {
            this.m_pfj.setTextString(this._getID(n), string);
        } else {
            this.create(GraphDefaultValues.getReferenceLineValue(), this.m_lineColor[n], GraphDefaultValues.getReferenceLineWidth(), GraphDefaultValues.getReferenceLineStyle(), string, GraphDefaultValues.isReferenceLineVisible(), this.m_legend[n], n);
        }
    }

    public double getValue(int n) {
        if (this.m_isCreated[n]) {
            return this.m_value[n];
        }
        return GraphDefaultValues.getReferenceLineValue();
    }

    public void setValue(double d, int n) {
        if (n < 0 || n > 2) {
            this.m_graph.getErrorHandler().log("invalid index", this.getClass().getName(), "setValue(double value, int index)");
            return;
        }
        if (this.m_isCreated[n]) {
            this.m_pfj.setReferenceLine(this.m_identObj, n, d);
            this.m_pfj.setDisplay(this.m_pfj.getReferenceLineLegendText(this.m_identObj, n), this.m_legend[n]);
            this.m_pfj.setFillColor(this._getID(n), this.m_lineColor[n]);
        } else {
            this.create(d, this.m_lineColor[n], GraphDefaultValues.getReferenceLineWidth(), GraphDefaultValues.getReferenceLineStyle(), GraphDefaultValues.getReferenceLineText(n), GraphDefaultValues.isReferenceLineVisible(), this.m_legend[n], n);
        }
        this.m_value[n] = d;
    }

    public boolean isVisible(int n) {
        if (this.m_isCreated[n]) {
            return this.m_pfj.getDisplay(this._getID(n));
        }
        return GraphDefaultValues.isReferenceLineVisible();
    }

    public void setVisible(boolean bl, int n) {
        if (n < 0 || n > 2) {
            this.m_graph.getErrorHandler().log("invalid index", this.getClass().getName(), "setVisible(boolean visible, int index)");
            return;
        }
        if (this.m_isCreated[n]) {
            this.m_pfj.setDisplay(this._getID(n), bl);
        } else {
            this.create(GraphDefaultValues.getReferenceLineValue(), this.m_lineColor[n], GraphDefaultValues.getReferenceLineWidth(), GraphDefaultValues.getReferenceLineStyle(), GraphDefaultValues.getReferenceLineText(n), bl, this.m_legend[n], n);
        }
    }

    protected boolean getXML(boolean bl, ObjectNode objectNode) {
        ContainerNode containerNode = new ContainerNode(this.getComponentName());
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        while (n < 3) {
            ObjectNode objectNode2 = new ObjectNode("ReferenceLine");
            objectNode2.addProperty("index", n);
            if (bl || this.isVisible(n) != GraphDefaultValues.isReferenceLineVisible()) {
                objectNode2.addProperty("visible", this.isVisible(n));
                bl2 = true;
            }
            if (bl || this.getLineWidth(n) != GraphDefaultValues.getReferenceLineWidth()) {
                objectNode2.addProperty("lineWidth", this.getLineWidth(n));
                bl2 = true;
            }
            if (bl || !this.getText(n).equals(GraphDefaultValues.getReferenceLineText(n))) {
                objectNode2.addProperty("text", this.getText(n));
                bl2 = true;
            }
            if (bl || this.getValue(n) != GraphDefaultValues.getReferenceLineValue()) {
                objectNode2.addProperty("value", this.getValue(n));
                bl2 = true;
            }
            if (bl || this.isDisplayedInLegend(n) != GraphDefaultValues.isReferenceLineDisplayedInLegend()) {
                objectNode2.addProperty("displayedInLegend", this.isDisplayedInLegend(n));
                bl2 = true;
            }
            if (bl || !this.getLineColor(n).equals(new Color(BaseGraphComponent.hexStringToInt(GraphDefaultValues.getReferenceLineColor(n))))) {
                objectNode2.addProperty("lineColor", BaseGraphComponent.toHexString(this.getLineColor(n).getRGB()));
                bl2 = true;
            }
            if (bl || this.getLineStyle(n) != GraphDefaultValues.getReferenceLineStyle()) {
                objectNode2.addProperty("lineStyle", this.convertLineStyleToString(this.getLineStyle(n)));
                bl2 = true;
            }
            if (bl2) {
                containerNode.addContainedObject(objectNode2);
                if (bl2) {
                    bl3 = true;
                }
                bl2 = false;
            }
            ++n;
        }
        if (bl3) {
            objectNode.addContainer(containerNode);
        }
        return bl3;
    }

    protected void setXML(ContainerNode containerNode) {
        Enumeration enumeration = containerNode.getContainedObject();
        while (enumeration.hasMoreElements()) {
            ObjectNode objectNode = (ObjectNode)enumeration.nextElement();
            PropertyNode propertyNode = objectNode.getProperty("index");
            if (propertyNode == null) continue;
            int n = propertyNode.getValueAsInteger();
            propertyNode = objectNode.getProperty("visible");
            if (propertyNode != null) {
                this.setVisible(propertyNode.getValueAsBoolean(), n);
            }
            if ((propertyNode = objectNode.getProperty("lineWidth")) != null) {
                this.setLineWidth(propertyNode.getValueAsInteger(), n);
            }
            if ((propertyNode = objectNode.getProperty("lineStyle")) != null) {
                this.setLineStyle(this.convertLineStyleToInt(propertyNode.getValueAsString()), n);
            }
            if ((propertyNode = objectNode.getProperty("text")) != null) {
                this.setText(propertyNode.getValueAsString(), n);
            }
            if ((propertyNode = objectNode.getProperty("value")) != null) {
                this.setValue(propertyNode.getValueAsDouble(), n);
            }
            if ((propertyNode = objectNode.getProperty("displayedInLegend")) != null) {
                this.setDisplayedInLegend(propertyNode.getValueAsBoolean(), n);
            }
            if ((propertyNode = objectNode.getProperty("lineColor")) == null) continue;
            Color color = null;
            color = propertyNode.getValueAsString().equals("") ? null : new Color(BaseGraphComponent.hexStringToInt(propertyNode.getValueAsString()));
            this.setLineColor(color, n);
        }
    }
}

