/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Rectangle;
import oracle.dss.graph.BaseGraphFrame;
import oracle.dss.graph.Graph;
import oracle.dss.graph.Rect;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public abstract class BaseFrame
extends BaseGraphFrame
implements Rect {
    protected static final int ATTR_RECT = 4;
    protected static final int ATTR_STYLE_MAXID = 5;

    public BaseFrame(Graph graph, IdentObj identObj) {
        this(graph);
        this.m_identObj = identObj;
    }

    public BaseFrame(Graph graph) {
        super(graph);
    }

    public boolean selectObject(int n, int n2) {
        this.m_pfj.setSelection(this.m_identObj);
        return this.m_identObj.equals(this.m_pfj.getSelectionID());
    }

    public Rectangle getRect() {
        Rectangle rectangle = new Rectangle(this.m_pfj.getRect(this.m_identObj));
        rectangle.y += rectangle.height;
        return rectangle;
    }

    public void setRect(Rectangle rectangle) {
        if (rectangle.width >= 100 && rectangle.height >= 100) {
            rectangle.y -= rectangle.height;
            this.m_pfj.setRect(this.m_identObj, rectangle);
            this.m_graph.setFrameSizeAutomatic(false);
            this.setPropertyOverrideFlags(4);
        } else {
            if (rectangle.width < 100) {
                this.m_graph.getErrorHandler().log("Rectangle width too small", this.getClass().getName(), "setRect");
            }
            if (rectangle.height < 100) {
                this.m_graph.getErrorHandler().log("Rectangle height too small", this.getClass().getName(), "setRect");
            }
        }
    }

    private void setRectXML(ObjectNode objectNode) {
        Rectangle rectangle = this.getRect();
        PropertyNode propertyNode = objectNode.getProperty("height");
        if (propertyNode != null) {
            rectangle.height = propertyNode.getValueAsInteger();
        }
        if ((propertyNode = objectNode.getProperty("width")) != null) {
            rectangle.width = propertyNode.getValueAsInteger();
        }
        if ((propertyNode = objectNode.getProperty("x")) != null) {
            rectangle.x = propertyNode.getValueAsInteger();
        }
        if ((propertyNode = objectNode.getProperty("y")) != null) {
            rectangle.y = propertyNode.getValueAsInteger();
        }
        this.setRect(rectangle);
    }

    protected ObjectNode getRectXML(boolean bl) {
        ObjectNode objectNode = new ObjectNode("Rect");
        boolean bl2 = false;
        Rectangle rectangle = this.getRect();
        if (bl || !this.m_graph.isFrameSizeAutomatic() || this.isUserOverrideFlag(4)) {
            objectNode.addProperty("height", rectangle.height);
            objectNode.addProperty("width", rectangle.width);
            objectNode.addProperty("x", rectangle.x);
            objectNode.addProperty("y", rectangle.y);
            bl2 = true;
        }
        if (bl2) {
            return objectNode;
        }
        return null;
    }

    protected void setXML(ObjectNode objectNode, boolean bl) {
        super.setXML(objectNode, bl);
        ObjectNode objectNode2 = objectNode.getPropertyValueAsObjectNode("Rect", true);
        if (objectNode2 != null) {
            this.setRectXML(objectNode2);
        }
    }

    protected void resetStyle() {
        super.resetStyle();
    }
}

