/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.managers;

import java.util.BitSet;
import oracle.dss.rules.Mergeable;

public class ViewSizing
implements Mergeable {
    protected int m_rowHeight;
    protected int m_columnWidth;
    protected BitSet m_propertyUsedFlags;
    private static final int RowHeightPropertyBit = 0;
    private static final int ColumnWidthPropertyBit = 1;
    private static final int NumberOfPropertyBits = 2;
    private static BitSet NoBitsSet = new BitSet();

    public boolean isAnythingOverridden() {
        return !this.m_propertyUsedFlags.equals(NoBitsSet);
    }

    public Object clone() {
        ViewSizing viewSizing = new ViewSizing(this.m_rowHeight, this.m_columnWidth);
        viewSizing.merge(this);
        return viewSizing;
    }

    public ViewSizing() {
        this(10, 10);
    }

    public ViewSizing(int n, int n2) {
        int n3 = 0;
        while (n3 < 2) {
            NoBitsSet.clear(n3);
            ++n3;
        }
        this.m_propertyUsedFlags = new BitSet(2);
        this.m_propertyUsedFlags.and(NoBitsSet);
        this.m_rowHeight = n;
        this.m_columnWidth = n2;
    }

    public void setRowHeight(int n) {
        this.setRowHeightUsed(true);
        this.m_rowHeight = n;
    }

    public int getRowHeight() {
        return this.m_rowHeight;
    }

    public boolean isRowHeightUsed() {
        return this.m_propertyUsedFlags.get(0);
    }

    public void setRowHeightUsed(boolean bl) {
        if (bl) {
            this.m_propertyUsedFlags.set(0);
        } else {
            this.m_propertyUsedFlags.clear(0);
        }
    }

    public void setColumnWidth(int n) {
        this.setColumnWidthUsed(true);
        this.m_columnWidth = n;
    }

    public int getColumnWidth() {
        return this.m_columnWidth;
    }

    public boolean isColumnWidthUsed() {
        return this.m_propertyUsedFlags.get(1);
    }

    public void setColumnWidthUsed(boolean bl) {
        if (bl) {
            this.m_propertyUsedFlags.set(1);
        } else {
            this.m_propertyUsedFlags.clear(1);
        }
    }

    public void merge(Mergeable mergeable) {
        ViewSizing viewSizing = null;
        try {
            viewSizing = (ViewSizing)mergeable;
        }
        catch (ClassCastException classCastException) {
            return;
        }
        if (viewSizing.isRowHeightUsed()) {
            this.setRowHeight(viewSizing.getRowHeight());
        }
        if (viewSizing.isColumnWidthUsed()) {
            this.setColumnWidth(viewSizing.getColumnWidth());
        }
    }

    public boolean equals(Object object) {
        ViewSizing viewSizing;
        if (object == null) {
            return false;
        }
        try {
            viewSizing = (ViewSizing)object;
        }
        catch (ClassCastException classCastException) {
            boolean bl = false;
            return bl;
        }
        if (!this.m_propertyUsedFlags.equals(viewSizing.m_propertyUsedFlags)) {
            return false;
        }
        if (this.getRowHeight() != viewSizing.getRowHeight()) {
            return false;
        }
        return this.getColumnWidth() == viewSizing.getColumnWidth();
    }

    public void clearUsedBits() {
        this.m_propertyUsedFlags.and(NoBitsSet);
    }
}

