/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterJob;
import java.io.PrintWriter;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.help.HelpProvider;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.dataView.ViewPrinter;
import oracle.dss.dataView.gui.PageSelectionPanel;
import oracle.dss.dataView.gui.PageSetupDialog;
import oracle.dss.dataView.gui.PreviewDialogProvider;
import oracle.dss.dataView.gui.PrintDialog;
import oracle.dss.dataView.gui.PrintDialogsAdapter;

public class PrintPanel
extends PageSelectionPanel {
    private ResourceBundle rBundle;
    private JLabel m_whereToExportLabel;
    private JLabel m_whatNameLabel;
    private PrintDialog m_printDialog;
    private PageSetupDialog pageSetup;
    private JButton pageBtn;
    protected JComboBox m_exportFormatComboBox;
    protected int m_exportFormatComboOffset;
    protected JPanel m_WhereToExportPanel;
    protected JTextField m_WhereToExportTextField;
    protected JTextField m_WhatNameTextField;
    protected JButton m_BrowseButton;
    protected int m_layer;
    protected String m_lastDir = "";
    protected boolean m_bLocalFileAccess = true;
    protected String m_strPath = "";
    protected String m_strFilename = "";
    protected boolean m_bViewIsCrosstab = true;
    protected PrintWriter m_printWriter;
    protected String m_strHelpContextID;
    protected boolean m_bHelpEnabled;
    protected HelpProvider m_helpProvider;
    protected Frame m_frame;
    protected ViewPrinter m_viewPrinter;
    protected PrinterJob m_printerJob;

    public PrintPanel(ViewPrinter viewPrinter) {
        this.m_viewPrinter = viewPrinter;
        this.updateResourceBundle(viewPrinter.getDataview().getLocale());
        this.m_dataAccess = this.m_viewPrinter.getDataview().getModel().getDataAccess();
        this.m_dataDirector = this.m_viewPrinter.getDataview().getModel().getDataDirector();
        this.constructPanel();
        this._init();
    }

    private void constructPanel() {
        super.constructPanel(0);
        String string = "";
        this.m_applicationName = this.rBundle.getString("title");
        int n = Integer.parseInt(this.rBundle.getString("PrintPanelWidth"));
        int n2 = Integer.parseInt(this.rBundle.getString("PrintPanelHeight"));
        this.setPreferredSize(new Dimension(n, n2));
        this.setMinimumSize(this.getPreferredSize());
        this.setMaximumSize(this.getPreferredSize());
        this.add(Box.createVerticalStrut(5));
        this.m_translatedText = this.rBundle.getString("pagesetup");
        this.pageBtn = new JButton(StringUtils.stripMnemonic((String)this.m_translatedText));
        this.pageBtn.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.m_translatedText));
        JPanel jPanel = new JPanel(new FlowLayout(2));
        jPanel.setAlignmentX(0.0f);
        jPanel.add(this.pageBtn);
        this.add(jPanel);
        this.pageBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrintPanel.this.apply();
                if (PrintPanel.this.m_printerJob == null) {
                    PrintPanel.this.m_printerJob = PrinterJob.getPrinterJob();
                }
                ViewPrinter[] viewPrinterArray = new ViewPrinter[]{PrintPanel.this.m_viewPrinter};
                PrintDialogsAdapter printDialogsAdapter = new PrintDialogsAdapter(PrintPanel.this.m_viewPrinter, PrintPanel.this.m_printDialog, PrintPanel.this.m_printerJob);
                printDialogsAdapter.setHelpProvider(PrintPanel.this.getHelpProvider());
                PrintPanel.this.pageSetup = new PageSetupDialog(WindowUtils.parentFrame((Component)PrintPanel.this), PrintPanel.this.rBundle.getString("pgsetup"), true, viewPrinterArray, (PreviewDialogProvider)printDialogsAdapter);
                PrintPanel.this.pageSetup.setHelpProvider(PrintPanel.this.getHelpProvider());
                PrintPanel.this.pageSetup.setLocationRelativeTo(PrintPanel.this.pageBtn);
                PrintPanel.this.pageSetup.setVisible(true);
            }
        });
        this.add(Box.createVerticalGlue());
    }

    protected void _init() {
        super._init();
        if (this.m_layerCount == 0 || this.m_pageCount == (long)1) {
            return;
        }
        if (this.m_viewPrinter.getRangeType() == 0) {
            this.m_CurrentSelectionsButton.setSelected(true);
        } else if (this.m_viewPrinter.getRangeType() == 1) {
            this.m_All28Button.setSelected(true);
        } else {
            this.m_SelectedCombinationsButton.setSelected(true);
        }
    }

    protected void setPrintDialog(PrintDialog printDialog) {
        this.m_printDialog = printDialog;
    }

    public String getHelpContextID() {
        return this.getClass().getName();
    }

    public void setHelpContextID(String string) {
        this.m_strHelpContextID = string;
    }

    public void setHelpEnabled(boolean bl) {
        this.m_bHelpEnabled = bl;
    }

    public boolean isHelpEnabled() {
        return this.m_bHelpEnabled;
    }

    public void setHelpProvider(HelpProvider helpProvider) {
        this.m_helpProvider = helpProvider;
    }

    public HelpProvider getHelpProvider() {
        return this.m_helpProvider;
    }

    public boolean apply() {
        boolean bl = true;
        int n = 0;
        if (this.m_CurrentSelectionsButton.isSelected()) {
            n = 0;
        } else if (this.m_All28Button.isSelected()) {
            n = 1;
        } else if (this.m_SelectedCombinationsButton.isSelected()) {
            n = 2;
            if (!this.isAllLayersSelected()) {
                return false;
            }
        }
        this.m_viewPrinter.setRangeType(n);
        try {
            if (n == 2) {
                Vector vector = null;
                bl = this.buildExportVectorArray();
                if (bl) {
                    vector = this.buildListExportHPos();
                    this.m_viewPrinter.setSelectedHPos(vector);
                }
            }
            if (bl) {
                boolean bl2 = true;
                return bl2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public void setLocale(Locale locale) {
        this.m_locale = locale;
        this.updateResourceBundle(locale);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_SelectAllButton) {
            this.selectAllMembers();
        } else if (actionEvent.getSource() == this.m_DeselectAllButton) {
            this.deselectAllMembers();
        }
    }

    void setPrinterJob(PrinterJob printerJob) {
        this.m_printerJob = printerJob;
    }

    private void displayErrorMessage(String string) {
        JDialog jDialog = new JOptionPane(this.rBundle.getString(string), 0, -1, new ImageIcon(ImageUtils.getImageResource(Class.forName("oracle.dss.dataView.gui.PrintPanel"), (String)"images/stop.gif"))).createDialog(this, this.m_applicationName);
        jDialog.show();
    }

    protected void updateResourceBundle(Locale locale) {
        super.updateResourceBundle(locale);
        this.rBundle = locale != null ? ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle", locale) : ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle");
    }
}

