/*
 * Decompiled with CFR 0.152.
 */
package oracle.ord.controls;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import javax.media.ControllerListener;
import javax.media.Manager;
import javax.media.NoPlayerException;
import javax.media.Player;
import javax.media.Time;
import javax.media.protocol.DataSource;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.jbo.JboException;
import oracle.jbo.uicli.jui.JUDefaultControlBinding;
import oracle.jbo.uicli.jui.JUDefaultControlInterface;
import oracle.jbo.uicli.jui.JUIUtil;
import oracle.ord.controls.AudioFileFilter;
import oracle.ord.controls.ImageDialog;
import oracle.ord.controls.ImageFileFilter;
import oracle.ord.controls.JMDialog;
import oracle.ord.controls.JMPanel;
import oracle.ord.controls.OrdDomainDataSource;
import oracle.ord.controls.Res;
import oracle.ord.controls.VideoFileFilter;
import oracle.ord.im.NotConnectedException;
import oracle.ord.im.OrdAudioDomain;
import oracle.ord.im.OrdContentSource;
import oracle.ord.im.OrdDocDomain;
import oracle.ord.im.OrdDomainIOInterface;
import oracle.ord.im.OrdFileSource;
import oracle.ord.im.OrdImageDomain;
import oracle.ord.im.OrdVideoDomain;

public class OrdMediaControl
extends JPanel
implements JUDefaultControlInterface,
FocusListener,
ActionListener {
    private boolean m_showButtons;
    private boolean m_enableUpdateButtons;
    private boolean m_enableLaunchButton;
    private boolean m_enableSaveButton;
    private JUDefaultControlBinding m_ctrlBinding;
    public static final int BUTTON_CHANGE = 0;
    public static final int BUTTON_CLEAR = 1;
    public static final int BUTTON_LAUNCH = 2;
    public static final int BUTTON_SAVE = 3;
    protected BorderLayout m_mainPanelLayout;
    protected GridBagLayout m_buttonPanelLayout;
    protected JScrollPane m_mediaAggregate;
    protected JLabel m_imageCanvas;
    protected JPanel m_mediaDisplay;
    protected JPanel m_buttonPanel;
    protected Dimension m_buttonPreferredSize;
    protected Dimension m_defaultPreferredSize;
    protected Dimension m_defaultMinimumSize;
    protected Insets m_buttonMargin;
    protected JButton m_changeButton;
    protected JButton m_clearButton;
    protected JButton m_launchButton;
    protected JButton m_saveButton;
    protected JFileChooser m_fileChooser;
    protected File m_CurrentDirectory;
    private FocusAdapter m_focusAdapter;
    private Player m_player;
    private boolean m_bJMFAvailable;
    private boolean m_autostart;
    static Properties m_props = new Properties();
    private OrdDomainIOInterface m_ordObject;
    ArrayList controllerList;
    DataSource _datasource;
    boolean m_showControlPanel;
    boolean m_Mute;
    int m_Volume;
    JComponent m_controlPanel;
    ChangeEvent m_changeEvent;
    private static /* synthetic */ Class class$oracle$ord$im$OrdDomainIOInterface;
    private static /* synthetic */ Class class$oracle$ord$im$OrdImageDomain;
    private static /* synthetic */ Class class$oracle$ord$im$OrdAudioDomain;
    private static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    private /* synthetic */ void $init$() {
        this.m_showButtons = true;
        this.m_enableUpdateButtons = true;
        this.m_enableLaunchButton = true;
        this.m_enableSaveButton = true;
        this.m_ctrlBinding = null;
        this.m_mainPanelLayout = new BorderLayout();
        this.m_buttonPanelLayout = new GridBagLayout();
        this.m_imageCanvas = new JLabel();
        this.m_mediaDisplay = new JPanel();
        this.m_buttonPanel = new JPanel();
        this.m_buttonPreferredSize = new Dimension(80, 25);
        this.m_defaultPreferredSize = new Dimension(400, 200);
        this.m_defaultMinimumSize = new Dimension(50, 50);
        this.m_buttonMargin = new Insets(10, 10, 10, 10);
        this.m_changeButton = new JButton(Res.getString(3));
        this.m_clearButton = new JButton(Res.getString(4));
        this.m_launchButton = new JButton(Res.getString(5));
        this.m_saveButton = new JButton(Res.getString(6));
        this.m_fileChooser = null;
        this.m_CurrentDirectory = null;
        this.m_player = null;
        this.m_bJMFAvailable = true;
        this.m_autostart = false;
        this.m_ordObject = null;
        this.controllerList = new ArrayList();
        this._datasource = null;
        this.m_showControlPanel = true;
        this.m_Mute = false;
        this.m_Volume = 75;
        this.m_controlPanel = null;
        this.m_changeEvent = null;
    }

    public OrdMediaControl() {
        this.$init$();
        JPanel jPanel = new JPanel(this.m_mainPanelLayout);
        this.m_mediaAggregate = new JScrollPane(this.m_mediaDisplay);
        this.m_mediaAggregate.setBorder(null);
        this.m_mediaAggregate.setPreferredSize(this.m_defaultPreferredSize);
        this.m_mediaAggregate.setMinimumSize(this.m_defaultMinimumSize);
        jPanel.add((Component)this.m_mediaAggregate, "Center");
        this.m_mediaDisplay.setLayout(new FlowLayout(0));
        this.m_setButtonTooltip();
        this.m_buttonPanel = this.m_createButtonPanel();
        jPanel.add((Component)this.m_buttonPanel, "South");
        this.m_mediaDisplay.addFocusListener(this);
        this.setLayout(new GridLayout());
        this.add(jPanel);
        if (JUIUtil.inDesignTime()) {
            return;
        }
        this.m_initProps();
        try {
            Manager.setHint((int)3, (Object)new Boolean(true));
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            this.m_bJMFAvailable = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void m_initProps() {
        try {
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("oracle/ord/controls/OrdMediaControl.properties");
            m_props.load(inputStream);
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        Class clazz = class$javax$swing$event$ChangeListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ChangeListener = OrdMediaControl.class$("javax.swing.event.ChangeListener");
        }
        this.listenerList.add(clazz, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        Class clazz = class$javax$swing$event$ChangeListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ChangeListener = OrdMediaControl.class$("javax.swing.event.ChangeListener");
        }
        this.listenerList.remove(clazz, changeListener);
    }

    public void addControllerListener(ControllerListener controllerListener) {
        this.controllerList.add(controllerListener);
        if (this.m_player != null) {
            this.m_player.addControllerListener(controllerListener);
        }
    }

    public void removeControllerListener(ControllerListener controllerListener) {
        this.controllerList.remove(controllerListener);
        if (this.m_player != null) {
            this.m_player.removeControllerListener(controllerListener);
        }
    }

    public void addFocusListener(FocusAdapter focusAdapter) {
        if (this.m_focusAdapter != null) {
            // empty if block
        }
        this.m_focusAdapter = focusAdapter;
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
        if (!focusEvent.isTemporary() && this.m_focusAdapter != null) {
            this.m_focusAdapter.focusGained(focusEvent);
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.m_enableButtons(bl);
    }

    public void setMediaBorder(Border border) {
        this.m_mediaAggregate.setBorder(border);
    }

    public Border getMediaBorder() {
        return this.m_mediaAggregate.getBorder();
    }

    public boolean getShowControls() {
        return this.m_showControlPanel;
    }

    public void setShowControls(boolean bl) {
        this.m_showControlPanel = bl;
    }

    public void doClear() {
        this.m_setMedia(null);
    }

    public void doChange() {
        int n;
        if (this.m_fileChooser == null) {
            this.m_fileChooser = new JFileChooser();
        }
        if (this.m_CurrentDirectory != null) {
            this.m_fileChooser.setCurrentDirectory(this.m_CurrentDirectory);
        }
        if ((n = this.m_fileChooser.showOpenDialog(this)) == 0) {
            this.m_CurrentDirectory = this.m_fileChooser.getCurrentDirectory();
            File file = this.m_fileChooser.getSelectedFile();
            this.m_setMedia(file);
        }
    }

    public void doLaunch() {
        this.m_launchViewer();
    }

    public void doSave() {
        int n;
        if (this.m_player != null) {
            this.m_player.stop();
        }
        if (this.m_fileChooser == null) {
            this.m_fileChooser = new JFileChooser();
        }
        String string = null;
        try {
            if (this.m_ordObject.getContentSource() != null) {
                OrdFileSource ordFileSource = (OrdFileSource)this.m_ordObject.getContentSource();
                string = ordFileSource.getFileName();
            } else {
                string = this.m_ordObject.getSourceName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string != null) {
            this.m_fileChooser.setSelectedFile(new File(string));
        }
        String string2 = null;
        try {
            string2 = this.m_ordObject.getMimeType();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string2 != null) {
            this.m_fileChooser.setDialogTitle("Content's MIMETYPE: " + string2);
        }
        if ((n = this.m_fileChooser.showSaveDialog(this)) == 0) {
            File file = this.m_fileChooser.getSelectedFile();
            this.m_saveToFile(file);
        }
        this.m_fileChooser.setSelectedFile(null);
        this.m_fileChooser.setDialogTitle(null);
    }

    public void doStart() {
        if (this.m_player != null) {
            this.m_player.start();
        }
    }

    public void doPause() {
        if (this.m_player != null && this.m_player.getState() != 100) {
            this.m_player.stop();
        }
    }

    public void doStop() {
        if (this.m_player != null && this.m_player.getState() != 100) {
            this.m_player.stop();
            this.m_player.setMediaTime(new Time(0L));
        }
    }

    public void setMute(boolean bl) {
        this.m_Mute = bl;
        if (this.m_player != null) {
            this.m_player.getGainControl().setMute(bl);
        }
    }

    public boolean getMute() {
        return this.m_Mute;
    }

    public void setVolume(int n) {
        this.m_Volume = n;
        if (this.m_player != null) {
            this.m_player.getGainControl().setLevel((float)((double)this.m_Volume * 0.01));
        }
    }

    public int getVolume() {
        return this.m_Volume;
    }

    public JComponent getControlPanel() {
        return this.m_controlPanel;
    }

    public void setControlPanel(JComponent jComponent) {
        this.m_controlPanel = jComponent;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_clearButton) {
            this.doClear();
        } else if (object == this.m_changeButton) {
            this.doChange();
        } else if (object == this.m_launchButton) {
            this.doLaunch();
        } else if (object == this.m_saveButton) {
            this.doSave();
        }
    }

    public void dataChanged(Object object) {
        this.doStop();
        SwingUtilities.invokeLater(new 1(this, object));
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            Object object = objectArray[n];
            Class clazz = class$javax$swing$event$ChangeListener;
            if (clazz == null) {
                clazz = OrdMediaControl.class$("javax.swing.event.ChangeListener");
            }
            if (object == clazz) {
                if (this.m_changeEvent == null) {
                    this.m_changeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)objectArray[n + 1]).stateChanged(this.m_changeEvent);
            }
            n -= 2;
        }
    }

    private void m_updateMedia(Object object) {
        this.m_ordObject = null;
        if (this.m_ctrlBinding != null) {
            if (this.m_ctrlBinding.isAttributeUpdateable(0)) {
                this.m_enableButtons(true);
            } else {
                this.m_enableUpdateButtons(false);
            }
            Object object2 = this.m_ctrlBinding.getValueAt(0);
            if (object2 == null) {
                this.m_clearMediaPanel();
            } else if (object2 instanceof OrdDocDomain) {
                OrdDocDomain ordDocDomain = (OrdDocDomain)object2;
                this.m_ordObject = ordDocDomain;
                if (this.m_isDocImage(ordDocDomain)) {
                    this.m_renderImage((OrdDomainIOInterface)ordDocDomain);
                } else if (this.m_isDocAudio(ordDocDomain) || this.m_isDocVideo(ordDocDomain)) {
                    this.m_renderAV((OrdDomainIOInterface)ordDocDomain);
                } else {
                    this.m_clearMediaPanel();
                    this.m_showInfo(Res.getString(23));
                }
            } else if (object2 instanceof OrdImageDomain) {
                OrdImageDomain ordImageDomain = (OrdImageDomain)object2;
                this.m_ordObject = ordImageDomain;
                this.m_renderImage((OrdDomainIOInterface)ordImageDomain);
            } else if (object2 instanceof OrdVideoDomain || object2 instanceof OrdAudioDomain) {
                if (this.m_bJMFAvailable) {
                    OrdDomainIOInterface ordDomainIOInterface;
                    this.m_ordObject = ordDomainIOInterface = (OrdDomainIOInterface)object2;
                    this.m_renderAV(ordDomainIOInterface);
                } else {
                    this.m_displayJMFLibError();
                }
            } else {
                this.m_clearMediaPanel();
                this.m_showInfo(Res.getString(14));
            }
        } else {
            this.m_enableButtons(false);
            this.m_clearMediaPanel();
        }
        this.fireStateChanged();
    }

    private boolean m_isDocImage(OrdDocDomain ordDocDomain) {
        boolean bl = false;
        OrdFileSource ordFileSource = (OrdFileSource)ordDocDomain.getContentSource();
        if (ordFileSource != null) {
            String string = ordFileSource.getFileName();
            String string2 = this.m_getFileExt(string);
            if (string2 != null && (string2.equals("gif") || string2.equals("jpg") || string2.equals("jpeg"))) {
                bl = true;
            }
        } else {
            String string = null;
            try {
                string = ordDocDomain.getMimeType();
            }
            catch (Exception exception) {
                throw new JboException((Throwable)exception);
            }
            if (string != null && string.toLowerCase().startsWith("image/")) {
                bl = true;
            }
        }
        return bl;
    }

    private boolean m_isDocAudio(OrdDocDomain ordDocDomain) {
        boolean bl = false;
        OrdFileSource ordFileSource = (OrdFileSource)ordDocDomain.getContentSource();
        if (ordFileSource != null) {
            String string = ordFileSource.getFileName();
            String string2 = this.m_getFileExt(string);
            if (string2 != null && (string2.equals("wav") || string2.equals("mp3") || string2.equals("aif") || string2.equals("au"))) {
                bl = true;
            }
        } else {
            String string = null;
            try {
                string = ordDocDomain.getMimeType();
            }
            catch (Exception exception) {
                throw new JboException((Throwable)exception);
            }
            if (string != null && string.toLowerCase().startsWith("audio/")) {
                bl = true;
            }
        }
        return bl;
    }

    private boolean m_isDocVideo(OrdDocDomain ordDocDomain) {
        boolean bl = false;
        OrdFileSource ordFileSource = (OrdFileSource)ordDocDomain.getContentSource();
        if (ordFileSource != null) {
            String string = ordFileSource.getFileName();
            String string2 = this.m_getFileExt(string);
            if (string2 != null && (string2.equals("mov") || string2.equals("mpeg") || string2.equals("mpg") || string2.equals("avi"))) {
                bl = true;
            }
        } else {
            String string = null;
            try {
                string = ordDocDomain.getMimeType();
            }
            catch (Exception exception) {
                throw new JboException((Throwable)exception);
            }
            if (string != null && string.toLowerCase().startsWith("video/")) {
                bl = true;
            }
        }
        return bl;
    }

    private String m_getFileExt(String string) {
        String string2 = null;
        int n = string.lastIndexOf(46);
        if (n > 0 && n < string.length() - 1) {
            string2 = string.substring(n + 1).toLowerCase();
        }
        return string2;
    }

    private void m_renderImage(OrdDomainIOInterface ordDomainIOInterface) {
        ImageIcon imageIcon = null;
        if (ordDomainIOInterface.getContentSource() != null) {
            OrdFileSource ordFileSource = (OrdFileSource)ordDomainIOInterface.getContentSource();
            imageIcon = new ImageIcon(ordFileSource.getFileName());
        } else {
            try {
                byte[] byArray = ordDomainIOInterface.getDataInByteArray();
                if (byArray != null) {
                    imageIcon = new ImageIcon(byArray);
                }
            }
            catch (NotConnectedException notConnectedException) {
                imageIcon = null;
            }
            catch (JboException jboException) {
                throw jboException;
            }
            catch (Exception exception) {
                throw new JboException((Throwable)exception);
            }
        }
        this.m_imageCanvas.setIcon(null);
        this.m_imageCanvas.setIcon(imageIcon);
        this.m_clearMediaPanel();
        this.m_mediaDisplay.add(this.m_imageCanvas);
        this.revalidate();
    }

    private void m_renderAV(OrdDomainIOInterface ordDomainIOInterface) {
        try {
            this._datasource = null;
            if (ordDomainIOInterface.getContentSource() != null) {
                OrdFileSource ordFileSource = (OrdFileSource)ordDomainIOInterface.getContentSource();
                URL uRL = new URL("file:" + ordFileSource.getFileName());
                this._datasource = Manager.createDataSource((URL)uRL);
            } else {
                this._datasource = new OrdDomainDataSource(ordDomainIOInterface);
            }
            this.m_clearMediaPanel();
            try {
                if (this.m_player != null) {
                    if (this.m_player.getState() != 300) {
                        this.m_player.stop();
                        this.m_player.deallocate();
                    }
                    this.m_player.close();
                }
                this.m_player = Manager.createPlayer((DataSource)this._datasource);
            }
            catch (NoPlayerException noPlayerException) {
                this.m_showError("Error:" + (Object)((Object)noPlayerException));
            }
            if (this.m_player != null) {
                this.embedViewer();
                Iterator iterator = this.controllerList.iterator();
                while (iterator.hasNext()) {
                    ControllerListener controllerListener = (ControllerListener)iterator.next();
                    this.m_player.addControllerListener(controllerListener);
                }
            }
        }
        catch (JboException jboException) {
            throw jboException;
        }
        catch (Exception exception) {
            throw new JboException((Throwable)exception);
        }
    }

    void syncStartEmbedPlayer() {
        if (this.m_player != null) {
            this.m_player.start();
        }
    }

    void embedViewer() {
        JMPanel jMPanel = new JMPanel(this.m_player, "test player", this.m_autostart);
        jMPanel.setShowControlPanel(this.m_showControlPanel);
        jMPanel.setControlPanel(this.m_controlPanel);
        this.m_mediaDisplay.add(jMPanel);
    }

    private void m_displayJMFLibError() {
        JOptionPane.showMessageDialog(null, Res.getString(17), Res.getString(18), 0);
    }

    private void m_showInfo(String string) {
        JOptionPane.showMessageDialog(this, string, null, 2);
    }

    private void m_showError(String string) {
        JOptionPane.showMessageDialog(this, string, null, 0);
    }

    private void m_clearMediaPanel() {
        if (this.m_mediaDisplay.getComponentCount() != 0) {
            Component component = this.m_mediaDisplay.getComponent(0);
            if (component != null && component instanceof JMPanel) {
                ((JMPanel)component).closePlayer();
            }
            this.m_mediaDisplay.removeAll();
            this.m_player = null;
            this.repaint();
        }
    }

    private void m_clearMediaPanelWithoutClosePlayer() {
        if (this.m_mediaDisplay.getComponentCount() != 0) {
            Component component = this.m_mediaDisplay.getComponent(0);
            if (component != null && component instanceof JMPanel) {
                ((JMPanel)component).removeControllerListener();
            }
            this.m_mediaDisplay.removeAll();
            this.repaint();
        }
    }

    protected JPanel m_createButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(this.m_buttonPanelLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = this.m_buttonMargin;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        jPanel.add((Component)this.m_changeButton, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)this.m_clearButton, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)this.m_launchButton, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)this.m_saveButton, gridBagConstraints);
        this.m_changeButton.setPreferredSize(this.m_buttonPreferredSize);
        this.m_clearButton.setPreferredSize(this.m_buttonPreferredSize);
        this.m_launchButton.setPreferredSize(this.m_buttonPreferredSize);
        this.m_saveButton.setPreferredSize(this.m_buttonPreferredSize);
        this.m_changeButton.addActionListener(this);
        this.m_clearButton.addActionListener(this);
        this.m_launchButton.addActionListener(this);
        this.m_saveButton.addActionListener(this);
        this.m_changeButton.addFocusListener(this);
        this.m_clearButton.addFocusListener(this);
        this.m_launchButton.addFocusListener(this);
        this.m_saveButton.addFocusListener(this);
        return jPanel;
    }

    protected void m_enableButtons(boolean bl) {
        this.m_changeButton.setEnabled(bl);
        this.m_clearButton.setEnabled(bl);
        this.m_launchButton.setEnabled(bl);
        this.m_saveButton.setEnabled(bl);
    }

    private byte[] m_readImageData(String string) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            byte[] byArray = new byte[bufferedInputStream.available()];
            bufferedInputStream.read(byArray, 0, byArray.length);
            byte[] byArray2 = byArray;
            return byArray2;
        }
        catch (Exception exception) {
            byte[] byArray = null;
            return byArray;
        }
    }

    private void m_setMedia(File file) {
        if (this.m_ctrlBinding != null) {
            Class clazz = this.m_ctrlBinding.getAttributeDef(0).getJavaType();
            Class clazz2 = class$oracle$ord$im$OrdDomainIOInterface;
            if (clazz2 == null) {
                clazz2 = class$oracle$ord$im$OrdDomainIOInterface = OrdMediaControl.class$("oracle.ord.im.OrdDomainIOInterface");
            }
            if (clazz2.isAssignableFrom(clazz)) {
                try {
                    OrdDomainIOInterface ordDomainIOInterface = null;
                    if (file == null) {
                        ordDomainIOInterface = null;
                    } else {
                        ordDomainIOInterface = (OrdDomainIOInterface)clazz.newInstance();
                        ordDomainIOInterface.setContentSource((OrdContentSource)new OrdFileSource(file.getAbsolutePath()));
                        ordDomainIOInterface.setSource("", "", file.getName());
                    }
                    this.m_ctrlBinding.setDataValueAt((Object)ordDomainIOInterface, 0);
                    return;
                }
                catch (Exception exception) {
                    throw new JboException((Throwable)exception);
                }
            }
        }
    }

    private void m_saveToFile(File file) {
        block5: {
            if (this.m_ordObject != null) {
                try {
                    if (this.m_ordObject.getContentSource() != null) {
                        OrdFileSource ordFileSource = (OrdFileSource)this.m_ordObject.getContentSource();
                        this.m_copyFile(ordFileSource.getFileName(), file);
                        break block5;
                    }
                    this.m_ordObject.getDataInFile(file.getAbsolutePath());
                }
                catch (Exception exception) {
                    this.m_showError(exception.toString());
                }
            } else {
                this.m_showInfo(Res.getString(16));
            }
        }
    }

    private void m_copyFile(String string, File file) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(string);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        int n = 8192;
        byte[] byArray = new byte[n];
        int n2 = n;
        while (n2 == n) {
            n2 = fileInputStream.read(byArray);
            fileOutputStream.write(byArray, 0, n2);
        }
        fileOutputStream.close();
        fileInputStream.close();
    }

    private void m_launchViewer() {
        if (this.m_ordObject == null) {
            this.m_showInfo(Res.getString(15));
            return;
        }
        if (this.m_ordObject instanceof OrdImageDomain) {
            this.m_launchImageViewer(this.m_ordObject);
        } else if (this.m_ordObject instanceof OrdAudioDomain || this.m_ordObject instanceof OrdVideoDomain) {
            this.m_launchAVViewer(this.m_ordObject);
        } else if (this.m_ordObject instanceof OrdDocDomain) {
            OrdDocDomain ordDocDomain = (OrdDocDomain)this.m_ordObject;
            if (this.m_isDocImage(ordDocDomain)) {
                this.m_launchImageViewer((OrdDomainIOInterface)ordDocDomain);
            } else if (this.m_isDocAudio(ordDocDomain) || this.m_isDocVideo(ordDocDomain)) {
                this.m_launchAVViewer((OrdDomainIOInterface)ordDocDomain);
            } else {
                this.m_showError(Res.getString(23));
            }
        } else {
            this.m_showError(Res.format(19, this.m_ordObject.getClass().getName()));
        }
    }

    private void m_launchImageViewer(OrdDomainIOInterface ordDomainIOInterface) {
        ImageIcon imageIcon = null;
        if (ordDomainIOInterface.getContentSource() != null) {
            OrdFileSource ordFileSource = (OrdFileSource)ordDomainIOInterface.getContentSource();
            imageIcon = new ImageIcon(ordFileSource.getFileName());
        } else {
            try {
                byte[] byArray = ordDomainIOInterface.getDataInByteArray();
                if (byArray != null) {
                    imageIcon = new ImageIcon(byArray);
                }
            }
            catch (NotConnectedException notConnectedException) {
                imageIcon = null;
            }
            catch (JboException jboException) {
                throw jboException;
            }
            catch (Exception exception) {
                throw new JboException((Throwable)exception);
            }
        }
        ImageDialog imageDialog = new ImageDialog(imageIcon, "");
        imageDialog.showDialog();
    }

    private void m_launchAVViewer(OrdDomainIOInterface ordDomainIOInterface) {
        this._datasource = null;
        if (ordDomainIOInterface.getContentSource() != null) {
            OrdFileSource ordFileSource = (OrdFileSource)ordDomainIOInterface.getContentSource();
            try {
                URL uRL = new URL("file:" + ordFileSource.getFileName());
                this._datasource = Manager.createDataSource((URL)uRL);
            }
            catch (Exception exception) {
                this.m_showError(exception.toString());
            }
        } else {
            this._datasource = new OrdDomainDataSource(ordDomainIOInterface);
        }
        if (this._datasource != null) {
            try {
                JMDialog jMDialog = new JMDialog(this._datasource, "Launch");
                jMDialog.setLocationRelativeTo(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    DataSource getDataSource() {
        return this._datasource;
    }

    public Player getPlayer() {
        return this.m_player;
    }

    public JButton getButton(int n) {
        switch (n) {
            case 0: {
                return this.m_changeButton;
            }
            case 1: {
                return this.m_clearButton;
            }
            case 2: {
                return this.m_launchButton;
            }
            case 3: {
                return this.m_saveButton;
            }
        }
        throw new JboException(Res.format(20, String.valueOf(n)));
    }

    private void m_setButtonTooltip() {
        this.m_changeButton.getAccessibleContext().setAccessibleDescription(Res.getString(7));
        this.m_clearButton.getAccessibleContext().setAccessibleDescription(Res.getString(8));
        this.m_launchButton.getAccessibleContext().setAccessibleDescription(Res.getString(9));
        this.m_saveButton.getAccessibleContext().setAccessibleDescription(Res.getString(10));
        this.m_changeButton.setToolTipText(Res.getString(7));
        this.m_clearButton.setToolTipText(Res.getString(8));
        this.m_launchButton.setToolTipText(Res.getString(9));
        this.m_saveButton.setToolTipText(Res.getString(10));
    }

    private void m_enableUpdateButtons(boolean bl) {
        this.m_changeButton.setEnabled(bl);
        this.m_clearButton.setEnabled(bl);
    }

    public boolean getShowButtons() {
        return this.m_showButtons;
    }

    public void setShowButtons(boolean bl) {
        this.m_showButtons = bl;
        if (this.m_showButtons) {
            this.m_buttonPanel.setVisible(true);
        } else {
            this.m_buttonPanel.setVisible(false);
        }
    }

    public void setAutoPlay(boolean bl) {
        this.m_autostart = bl;
    }

    public boolean getAutoPlay() {
        return this.m_autostart;
    }

    public boolean getEnableUpdateButtons() {
        return this.m_enableUpdateButtons;
    }

    public void setEnableUpdateButtons(boolean bl) {
        this.m_enableUpdateButtons = bl;
        this.m_changeButton.setEnabled(bl);
        this.m_clearButton.setEnabled(bl);
    }

    public boolean getEnableLaunchButton() {
        return this.m_enableLaunchButton;
    }

    public void setEnableLaunchButton(boolean bl) {
        this.m_enableLaunchButton = bl;
        this.m_launchButton.setEnabled(bl);
    }

    public boolean getEnableSaveButton() {
        return this.m_enableSaveButton;
    }

    public void setEnableSaveButton(boolean bl) {
        this.m_enableSaveButton = bl;
        this.m_saveButton.setEnabled(bl);
    }

    public void setModel(JUDefaultControlBinding jUDefaultControlBinding) {
        if (this.m_fileChooser == null) {
            this.m_fileChooser = new JFileChooser();
        }
        this.m_ctrlBinding = jUDefaultControlBinding;
        if (jUDefaultControlBinding != null && !JUIUtil.inDesignTime()) {
            Class clazz;
            Class clazz2 = class$oracle$ord$im$OrdDomainIOInterface;
            if (clazz2 == null) {
                clazz2 = class$oracle$ord$im$OrdDomainIOInterface = OrdMediaControl.class$("oracle.ord.im.OrdDomainIOInterface");
            }
            if (clazz2.isAssignableFrom(jUDefaultControlBinding.getAttributeDef(0).getJavaType())) {
                this.m_enableButtons(false);
            }
            if ((clazz = class$oracle$ord$im$OrdImageDomain) == null) {
                clazz = class$oracle$ord$im$OrdImageDomain = OrdMediaControl.class$("oracle.ord.im.OrdImageDomain");
            }
            if (clazz.isAssignableFrom(jUDefaultControlBinding.getAttributeDef(0).getJavaType())) {
                this.m_autostart = true;
                this.m_fileChooser.resetChoosableFileFilters();
                this.m_fileChooser.addChoosableFileFilter(new ImageFileFilter());
            } else {
                Class clazz3 = class$oracle$ord$im$OrdAudioDomain;
                if (clazz3 == null) {
                    clazz3 = class$oracle$ord$im$OrdAudioDomain = OrdMediaControl.class$("oracle.ord.im.OrdAudioDomain");
                }
                if (clazz3.isAssignableFrom(jUDefaultControlBinding.getAttributeDef(0).getJavaType())) {
                    this.m_fileChooser.resetChoosableFileFilters();
                    this.m_fileChooser.addChoosableFileFilter(new AudioFileFilter());
                } else {
                    this.m_fileChooser.resetChoosableFileFilters();
                    this.m_fileChooser.addChoosableFileFilter(new VideoFileFilter());
                }
            }
        }
    }

    public JUDefaultControlBinding getModel() {
        return this.m_ctrlBinding;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public final class 1
    implements Runnable {
        private final /* synthetic */ Object v$dataItem;
        final /* synthetic */ OrdMediaControl this$0;

        public void run() {
            this.this$0.m_updateMedia(this.v$dataItem);
        }

        public /* synthetic */ 1(OrdMediaControl ordMediaControl, Object object) {
            this.v$dataItem = object;
            this.this$0 = ordMediaControl;
        }
    }
}

