/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.server;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.HashMap;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import oracle.jbo.AttributeList;
import oracle.jbo.DeleteEvent;
import oracle.jbo.InsertEvent;
import oracle.jbo.InvalidOperException;
import oracle.jbo.InvalidParamException;
import oracle.jbo.JboEvent;
import oracle.jbo.JboException;
import oracle.jbo.Key;
import oracle.jbo.NavigationEvent;
import oracle.jbo.NoObjException;
import oracle.jbo.RangeRefreshEvent;
import oracle.jbo.Row;
import oracle.jbo.RowIterator;
import oracle.jbo.RowNotFoundException;
import oracle.jbo.RowSet;
import oracle.jbo.RowSetIterator;
import oracle.jbo.RowSetManagementEvent;
import oracle.jbo.ScrollEvent;
import oracle.jbo.UpdateEvent;
import oracle.jbo.VariableValueManager;
import oracle.jbo.ViewCriteria;
import oracle.jbo.ViewLink;
import oracle.jbo.ViewObject;
import oracle.jbo.common.RowSetIteratorHelper;
import oracle.jbo.common.SvcMsgIteratorState;
import oracle.jbo.common.VariableValueManagerImpl;
import oracle.jbo.common.ws.WSRowSetIteratorMarshaller;
import oracle.jbo.server.ApplicationModuleImpl;
import oracle.jbo.server.DBTransactionImpl;
import oracle.jbo.server.EntityDefImpl;
import oracle.jbo.server.EntityImpl;
import oracle.jbo.server.IteratorStateHolder;
import oracle.jbo.server.QueryCollection;
import oracle.jbo.server.RowFilter;
import oracle.jbo.server.RowQualifier;
import oracle.jbo.server.RowSetStateHolder;
import oracle.jbo.server.ViewDefImpl;
import oracle.jbo.server.ViewLinkDefImpl;
import oracle.jbo.server.ViewLinkImpl;
import oracle.jbo.server.ViewObjectImpl;
import oracle.jbo.server.ViewRowImpl;
import oracle.jbo.server.ViewRowSetImpl;
import org.w3c.dom.Element;

public class ViewRowSetIteratorImpl
extends RowSetIteratorHelper
implements WSRowSetIteratorMarshaller,
RowSetIterator {
    protected ViewRowSetImpl mViewRowSet;
    protected int mViewSize;
    private boolean mIsNameGenerated;
    private boolean mIsDefaultRSI;
    private boolean mRefreshNeeded;
    private int mSuppressEvents;
    private ArrayList mDetailRowSets;
    int mTopRowIndex;
    int mSize;
    private int mCurrentRowIndex;
    private Row mPreviousCurrentRow;
    private int mPreviousCurrentRowIndex;
    private boolean mRowValidation;
    private int mBeyondAbsIndex;
    private int mCurrentRowSlot;
    private int mIterMode;
    private HashMap mRowEvents;
    private VariableValueManager mVariableManager;
    IteratorStateHolder mIteratorState;
    static final String MTH_scrollRangeTo = "ViewRowSetIteratorImpl.scrollRangeTo";
    static final String MTH_insertRowAtRangeIndex = "ViewRowSetIteratorImpl.insertRowAtRangeIndex";
    static final String MTH_ensureInRange = "ViewRowSetIteratorImpl.ensureInRange";
    static final String MTH_createDetailRowSet = "ViewRowSetIteratorImpl.createDetailRowSet";
    private static /* synthetic */ Class class$oracle$jbo$CSMessageBundle;
    private static /* synthetic */ Class class$oracle$jbo$DeleteEvent;
    private static /* synthetic */ Class class$oracle$jbo$InsertEvent;

    private /* synthetic */ void $init$() {
        this.mViewSize = 1;
        this.mIsNameGenerated = false;
        this.mIsDefaultRSI = false;
        this.mSuppressEvents = 0;
        this.mSize = 0;
        this.mRowValidation = true;
        this.mBeyondAbsIndex = -1;
        this.mCurrentRowSlot = 2;
        this.mRowEvents = new HashMap(4);
        this.mVariableManager = null;
        this.mIteratorState = null;
    }

    public ViewRowSetIteratorImpl(ViewRowSetImpl viewRowSetImpl) {
        this.$init$();
        this.initViewRowSetIteratorImpl(viewRowSetImpl);
    }

    public ViewRowSetIteratorImpl(ViewRowSetImpl viewRowSetImpl, String string, boolean bl) {
        this.$init$();
        this.mIsDefaultRSI = bl;
        this.setName(string);
        this.initViewRowSetIteratorImpl(viewRowSetImpl);
    }

    public final Object getSyncLock() {
        return ((ApplicationModuleImpl)this.getViewObject().getApplicationModule()).getSyncLock();
    }

    public final boolean isNameGenerated() {
        return this.mIsNameGenerated;
    }

    final void setNameGenerated(boolean bl) {
        this.mIsNameGenerated = bl;
    }

    private void initViewRowSetIteratorImpl(ViewRowSetImpl viewRowSetImpl) {
        this.mViewRowSet = viewRowSetImpl;
        this.mDetailRowSets = new ArrayList(2);
        this.mRefreshNeeded = true;
        this.mCurrentRowSlot = 2;
        this.mTopRowIndex = -1;
        this.mCurrentRow = null;
        this.mCurrentRowIndex = -1;
        this.mPreviousCurrentRow = null;
        this.mPreviousCurrentRowIndex = -1;
        viewRowSetImpl.addViewRowSetIteratorImpl(this);
        this.mRowValidation = ((DBTransactionImpl)viewRowSetImpl.mQRef.getApplicationModule().getTransaction()).isBundledExceptionMode() ^ true;
        this.mIterMode = viewRowSetImpl.getViewObjectImpl().getViewDef().getIterMode();
    }

    public ViewObject getViewObject() {
        return this.mViewRowSet.getViewObjectImpl();
    }

    public ViewRowSetImpl getRowSetImpl() {
        return this.mViewRowSet;
    }

    public RowSet getRowSet() {
        return this.mViewRowSet.getRowSet();
    }

    public boolean isDefaultRSI() {
        return this.mIsDefaultRSI;
    }

    public RowSetIterator getRowSetIterator() {
        if (this.mIsDefaultRSI) {
            return this.mViewRowSet.getRowSetIterator();
        }
        return this;
    }

    void close() {
        if (this.mViewRowSet != null) {
            if (this.mDetailRowSets != null) {
                int n = this.mDetailRowSets.size() - 1;
                while (n >= 0) {
                    RowSet rowSet = (RowSet)this.mDetailRowSets.get(n);
                    if (rowSet instanceof ViewObjectImpl) {
                        rowSet = ((ViewObjectImpl)rowSet).getDefaultRowSet();
                    }
                    ((ViewRowSetImpl)rowSet).close();
                    --n;
                }
            }
            if (this.mSuppressEvents == 0 && this.hasManagementListeners()) {
                this.fireMgmtIteratorClosed(new RowSetManagementEvent(this.getExposedObject(), 1));
            }
            this.mViewRowSet.removeViewRowSetIteratorImpl(this);
            this.mViewRowSet = null;
            this.refresh(true, false);
            if (this.listeners != null) {
                this.listeners.clear();
                this.listeners = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeRowSetIterator() {
        if (this.mViewRowSet != null && this.getViewObject() != null) {
            Object object = this.getSyncLock();
            synchronized (object) {
                this.close();
            }
        }
    }

    public SvcMsgIteratorState getCliIteratorState() {
        return null;
    }

    public Object[] getRowFilterValues() {
        if (this.getQueryCollection() != null) {
            RowFilter rowFilter = this.getQueryCollection().getRowFilter();
            return rowFilter != null ? rowFilter.getParamValues() : null;
        }
        return null;
    }

    public void prepareForBatchMode(SvcMsgIteratorState svcMsgIteratorState, boolean bl) {
        if (svcMsgIteratorState != null) {
            this.prepareRangeForBatchMode(svcMsgIteratorState.isExecuted(), svcMsgIteratorState.getCurrentRowIndex(), svcMsgIteratorState.getRangeStart(), svcMsgIteratorState.getRangeSize(), bl);
        }
    }

    public void prepareRangeForBatchMode(boolean bl, int n, int n2, int n3, boolean bl2) {
        try {
            if (bl) {
                this.ensureRefreshed(false);
            }
            ++this.mSuppressEvents;
            if (this.mCurrentRowIndex != n) {
                if (!bl2) {
                    this.mCurrentRowIndex = -1;
                    this.mCurrentRow = null;
                } else {
                    this.internalSetCurrentRow(n, true);
                }
            }
            if (this.getRangeSize() != n3) {
                this.setRangeSize(n3);
            }
            if (this.getRangeStart() != n2) {
                int n4 = this.getIterMode();
                try {
                    this.setIterMode(0);
                    this.setRangeStart(n2);
                    Object var8_7 = null;
                    this.setIterMode(n4);
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    this.setIterMode(n4);
                    throw throwable;
                }
            }
            Object var10_10 = null;
            --this.mSuppressEvents;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            --this.mSuppressEvents;
            throw throwable;
        }
    }

    public void setRowFilterValues(Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return;
        }
        RowFilter rowFilter = ((ViewObjectImpl)this.getViewObject()).buildRowFilter(objectArray);
        QueryCollection queryCollection = this.getQueryCollection();
        boolean bl = this.getRowSetImpl().initAndRegisterQC(false, false, rowFilter);
        QueryCollection queryCollection2 = this.getQueryCollection();
        if (queryCollection != queryCollection2) {
            if (!queryCollection2.isExecuted()) {
                this.getRowSetImpl().resetExecuted();
            }
            this.mSize = 0;
            this.mTopRowIndex = -1;
            this.mCurrentRow = null;
            this.mCurrentRowIndex = -1;
            this.mPreviousCurrentRow = null;
            this.mPreviousCurrentRowIndex = -1;
            this.mCurrentRowSlot = 2;
            this.mIteratorState = null;
            this.mRowEvents.clear();
            this.mRefreshNeeded = false;
            this.ensureRefreshed(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setRangeSize(int n) {
        if (this.mViewRowSet.isForwardOnly() && n != 1) {
            Class clazz = class$oracle$jbo$CSMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$jbo$CSMessageBundle = ViewRowSetIteratorImpl.class$("oracle.jbo.CSMessageBundle");
            }
            throw new InvalidOperException(clazz, "25011", new Object[]{this.mViewRowSet.getName()});
        }
        if (n == 0) {
            n = 1;
        }
        if (n < -1) {
            n = -1;
        }
        if (this.mViewRowSet.isRangePaging() && n < 1) {
            Class clazz = class$oracle$jbo$CSMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$jbo$CSMessageBundle = ViewRowSetIteratorImpl.class$("oracle.jbo.CSMessageBundle");
            }
            throw new InvalidOperException(clazz, "25011", new Object[]{this.mViewRowSet.getName()});
        }
        Object object = this.getSyncLock();
        synchronized (object) {
            this.activateIteratorState(null, true);
            if (n != this.mViewSize) {
                int n2 = this.mViewSize;
                if (n == -1 || n2 != -1 && n > n2) {
                    this.mRefreshNeeded = true;
                }
                this.mViewSize = n;
                if (this.mViewRowSet.isRangePaging()) {
                    QueryCollection queryCollection;
                    if (!this.isDefaultRSI()) {
                        this.mViewRowSet.setRangeSize(this.mViewSize);
                    }
                    if ((queryCollection = this.getQueryCollection()) != null) {
                        queryCollection.setRangeSize(this.mViewSize);
                        if (this.mViewRowSet.isExecuted()) {
                            this.mViewRowSet.executeQuery();
                        }
                    }
                }
                if (this.mTopRowIndex != -1) {
                    if (this.mViewSize == -1) {
                        this.mTopRowIndex = 0;
                    }
                    this.mSize = 0;
                    this.ensureRefreshed(true, false, null);
                    if (this.mIterMode == 1 && this.mViewSize != -1 && this.mTopRowIndex > 0 && n > n2 && this.mSize < n) {
                        this.mTopRowIndex -= n - this.mSize;
                        if (this.mTopRowIndex < 0) {
                            this.mTopRowIndex = 0;
                        }
                        this.mSize = 0;
                        this.ensureRefreshed(true, false, null);
                    }
                }
                this.mViewRowSet.setStateToPassivate(true);
            }
            int n3 = this.mViewSize;
            return n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRangeSize() {
        Object object = this.getSyncLock();
        synchronized (object) {
            this.activateIteratorState(null, true);
            int n = this.mViewSize;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFetchedRowCount() {
        Object object = this.getSyncLock();
        synchronized (object) {
            this.activateIteratorState(null, true);
            QueryCollection queryCollection = this.getQueryCollection();
            int n = 0;
            if (queryCollection != null) {
                n = queryCollection.getFetchedRowCount();
            }
            int n2 = n;
            return n2;
        }
    }

    int getUnpostedRowCount() {
        QueryCollection queryCollection = this.getQueryCollection();
        return queryCollection != null ? queryCollection.getUnpostedRowCount() : 0;
    }

    public int getRowCount() {
        this.activateIteratorState(null, true);
        return this.getRowSetImpl().getRowCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowCountInRange() {
        Object object = this.getSyncLock();
        synchronized (object) {
            this.ensureRefreshed(true);
            int n = this.mSize;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Row getRowAtRangeIndex(int n) {
        Object object = this.getSyncLock();
        synchronized (object) {
            this.ensureRefreshed(true);
            Row row = this.getRowAtRangeIndexInternal(n);
            return row;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Row getRowAtRangeIndexInternal(int n) {
        Object object = this.getSyncLock();
        synchronized (object) {
            this.activateIteratorState(null, true);
            if (n < this.mSize) {
                Row row = this.getRowInternal(n + this.mTopRowIndex);
                return row;
            }
            Row row = null;
            return row;
        }
    }

    public Row getRow(Key key) {
        this.activateIteratorState(null, true);
        return this.getRowSetImpl().getRow(key);
    }

    public Row getRowFromHandle(Object object) {
        this.activateIteratorState(null, true);
        return this.getRowSetImpl().getRowFromHandle(object);
    }

    public void removeRowHandle(Object object) {
        this.activateIteratorState(null, true);
        this.getRowSetImpl().removeRowHandle(object);
    }

    public Key createKey(AttributeList attributeList) {
        return this.getRowSetImpl().createKey(attributeList);
    }

    public Row[] findByKey(Key key, int n) {
        return this.getRowSetImpl().findByKey(key, n);
    }

    public void findAndSetCurrentRowByKey(Key key, int n) {
        Row[] rowArray = this.findByKey(key, 1);
        if (rowArray != null && rowArray.length == 1) {
            this.scrollRangeTo(rowArray[0], n);
            this.setCurrentRowAtRangeIndex(this.getRangeIndexOf(rowArray[0]));
        }
    }

    public Row[] findByKey(Key key, int n, boolean bl) {
        return this.getRowSetImpl().findByKey(key, n, bl);
    }

    public RowIterator findByViewCriteria(ViewCriteria viewCriteria, int n, int n2) {
        return this.getRowSetImpl().findByViewCriteria(viewCriteria, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Row getCurrentRow() {
        Object object = this.getSyncLock();
        synchronized (object) {
            this.activateIteratorState(null, true);
            Row row = this.mCurrentRow;
            return row;
        }
    }

    Row getTheRow(Row row) {
        return row;
    }

    public int getCurrentRowSlot() {
        this.activateIteratorState(null, true);
        return this.mCurrentRowSlot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIterMode() {
        Object object = this.getSyncLock();
        synchronized (object) {
            this.activateIteratorState(null, true);
            int n = this.mIterMode;
            return n;
        }
    }

    public void setIterMode(int n) {
        this.mIterMode = n;
        this.mViewRowSet.setStateToPassivate(true);
    }

    public void setRowValidation(boolean bl) {
        this.mRowValidation = bl;
        this.mViewRowSet.setStateToPassivate(true);
    }

    public boolean isRowValidation() {
        return this.mRowValidation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setCurrentRow(Row row) {
        Object object = this.getSyncLock();
        synchronized (object) {
            this.activateIteratorState(null, true);
            if (row == this.mCurrentRow) {
                boolean bl = true;
                return bl;
            }
            int n = this.getQueryCollection().indexOf(row);
            if (n >= 0) {
                if (this.mViewRowSet.isRangePaging() && this.mTopRowIndex > 0) {
                    n += this.mTopRowIndex;
                }
                this.validateCurrentRow(n);
            }
            boolean bl = this.internalSetCurrentRow(n, true);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setCurrentRowAtRangeIndex(int n) {
        Object object = this.getSyncLock();
        synchronized (object) {
            int n2;
            this.activateIteratorState(null, true);
            if (n < 0 || this.mViewSize != -1 && n >= this.mViewSize) {
                boolean bl = false;
                return bl;
            }
            this.ensureRefreshed(true);
            int n3 = n2 = this.mTopRowIndex < 0 ? n : n + this.mTopRowIndex;
            if (n2 == this.mCurrentRowIndex && this.mCurrentRowSlot != 1) {
                boolean bl = true;
                return bl;
            }
            if (n2 >= 0) {
                this.validateCurrentRow(n2);
            }
            boolean bl = this.internalSetCurrentRow(n2, true);
            return bl;
        }
    }

    QueryCollection getQueryCollection() {
        return this.getRowSetImpl().getQueryCollection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentRowIndex() {
        Object object = this.getSyncLock();
        synchronized (object) {
            this.activateIteratorState(null, true);
            int n = this.mCurrentRowIndex;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRangeIndexOf(Row row) {
        Object object = this.getSyncLock();
        synchronized (object) {
            this.activateIteratorState(null, true);
            if (row != null) {
                ViewRowSetImpl viewRowSetImpl = this.getRowSetImpl();
                int n = 0;
                while (n < this.mSize) {
                    if (row.equals(viewRowSetImpl.getRow(this.mTopRowIndex + n))) {
                        int n2 = n;
                        return n2;
                    }
                    ++n;
                }
            }
            int n = -1;
            return n;
        }
    }

    public int getEstimatedRangePageCount() {
        int n = this.getRangeSize();
        return n > 0 ? (int)Math.ceil((double)this.getRowSetImpl().getEstimatedRowCount() / (double)n) : 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int scrollToRangePage(int n) {
        Object object = this.getSyncLock();
        synchronized (object) {
            this.activateIteratorState(null, true);
        }
        int n2 = this.getRangeSize();
        if (n <= 0 || n2 < 1) {
            return 0;
        }
        int n3 = this.mTopRowIndex < 0 ? 0 : this.mTopRowIndex;
        return this.scrollRange(n2 * (n - 1) - n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int scrollRange(int n) {
        if (n == 0) {
            return 0;
        }
        if (n == Integer.MAX_VALUE) {
            int n2 = this.mTopRowIndex < 0 ? 0 : this.mTopRowIndex;
            this.last();
            return this.mTopRowIndex - n2;
        }
        if (this.mViewRowSet.isForwardOnly() && n < 0) {
            Class clazz = class$oracle$jbo$CSMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$jbo$CSMessageBundle = ViewRowSetIteratorImpl.class$("oracle.jbo.CSMessageBundle");
            }
            throw new InvalidOperException(clazz, "25011", new Object[]{this.mViewRowSet.getName()});
        }
        Object object = this.getSyncLock();
        synchronized (object) {
            this.activateIteratorState(null, true);
            ViewRowSetImpl viewRowSetImpl = this.getRowSetImpl();
            boolean bl = viewRowSetImpl.isRangePaging();
            if (!bl) {
                this.ensureRefreshed(true);
            }
            int n3 = this.mTopRowIndex;
            QueryCollection queryCollection = this.getQueryCollection();
            if (queryCollection == null && bl) {
                viewRowSetImpl.ensureStorage();
                queryCollection = this.getQueryCollection();
            }
            if (this.mViewSize == -1 || this.mTopRowIndex >= 0 && this.mSize == 0 && n > 0 || queryCollection.isFetchComplete() && this.mSize >= this.getFetchedRowCount() + this.getUnpostedRowCount()) {
                int n4 = 0;
                return n4;
            }
            int n5 = 0;
            int n6 = this.mTopRowIndex;
            if (n < 0) {
                if (this.mTopRowIndex <= 0) {
                    int n7 = 0;
                    return n7;
                }
                if (this.mTopRowIndex + n < 0) {
                    n5 = -this.mTopRowIndex;
                    this.mTopRowIndex = 0;
                } else {
                    this.mTopRowIndex += n;
                    n5 = n;
                }
                n6 = this.mTopRowIndex;
            } else if (bl) {
                if (queryCollection.isExecuted() && this.isRangeAtBottom()) {
                    int n8 = 0;
                    return n8;
                }
                n6 = this.mTopRowIndex >= 0 ? this.mTopRowIndex + n : n;
                n5 = n6 - n3;
                queryCollection.fetchRangeAt(n6);
                this.mTopRowIndex = n6;
                this.mSize = queryCollection.getCollectionSize();
                if (this.mSize > this.mViewSize) {
                    this.mSize = this.mViewSize;
                }
            } else {
                if (this.isRangeAtBottom()) {
                    int n9 = 0;
                    return n9;
                }
                n6 = this.mTopRowIndex + this.mSize - 1;
                int n10 = n6 + n;
                while (true) {
                    if (viewRowSetImpl.getRow(n10) == null) {
                        if (--n10 > n6) continue;
                        break;
                    }
                    if ((this.mIterMode & 1) == 0) {
                        n5 = n;
                        break;
                    }
                    if (++n5 == n || --n10 <= n6) break;
                }
                if (n5 > 0) {
                    this.mTopRowIndex += n5;
                    if ((this.mIterMode & 1) == 0) {
                        this.mSize = n10 - this.mTopRowIndex + 1;
                    }
                }
            }
            if (n5 != 0) {
                this.notifyRangeScrolled(n3);
            }
            int n11 = n5;
            return n11;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int scrollRangeTo(Row row, int n) {
        this.activateIteratorState(null, true);
        if (this.mViewSize == -1) {
            return 0;
        }
        if (n < 0) {
            throw new InvalidParamException(MTH_scrollRangeTo, "rangeIndex", new Integer(n), "index invalid");
        }
        if (n >= this.mViewSize) {
            throw new InvalidParamException(MTH_scrollRangeTo, "rangeIndex", new Integer(n), "index outside range");
        }
        if (this.mViewRowSet.isForwardOnly()) {
            Class clazz = class$oracle$jbo$CSMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$jbo$CSMessageBundle = ViewRowSetIteratorImpl.class$("oracle.jbo.CSMessageBundle");
            }
            throw new InvalidOperException(clazz, "25011", new Object[]{this.mViewRowSet.getName()});
        }
        Object object = this.getSyncLock();
        synchronized (object) {
            int n2 = this.mTopRowIndex;
            int n3 = this.getQueryCollection().indexOf(row);
            if (n3 < 0) {
                throw new InvalidParamException(MTH_scrollRangeTo, "row", row.getClass().getName(), "not in the row set");
            }
            int n4 = n3 - this.mTopRowIndex - n;
            int n5 = this.scrollRange(n4);
            return n5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.getSyncLock();
        synchronized (object) {
            this.activateIteratorState(null, true);
            boolean bl = this.mTopRowIndex > 0 || this.mCurrentRowSlot != 2;
            this.reset(true);
            if (bl) {
                this.notifyIteratorReset();
            }
        }
    }

    private void reset(boolean bl) {
        if (this.mTopRowIndex > 0) {
            this.scrollRange(-this.mTopRowIndex);
        }
        if (bl) {
            this.mCurrentRow = null;
            this.mCurrentRowIndex = -1;
            this.mCurrentRowSlot = 2;
        }
        this.mTopRowIndex = this.mSize == 0 ? -1 : 0;
        this.mPreviousCurrentRow = null;
        this.mPreviousCurrentRowIndex = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Row first() {
        if (this.mViewRowSet.isForwardOnly() && this.mTopRowIndex > 0) {
            Class clazz = class$oracle$jbo$CSMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$jbo$CSMessageBundle = ViewRowSetIteratorImpl.class$("oracle.jbo.CSMessageBundle");
            }
            throw new InvalidOperException(clazz, "25011", new Object[]{this.mViewRowSet.getName()});
        }
        Object object = this.getSyncLock();
        synchronized (object) {
            this.activateIteratorState(null, true);
            try {
                if (this.mTopRowIndex > 0) {
                    this.reset(false);
                }
                this.ensureRefreshed(true);
                if (this.mTopRowIndex < 0) {
                    this.next();
                }
                this.internalSetCurrentRow(0, false);
            }
            catch (JboException jboException) {
                throw jboException;
            }
            catch (Exception exception) {
                throw new JboException(exception);
            }
            Row row = this.getCurrentRow();
            return row;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Row last() {
        Object object = this.getSyncLock();
        synchronized (object) {
            try {
                this.ensureRefreshed(true);
                int n = this.getRowSetImpl().getRowCount();
                if (n == 0) {
                    this.internalSetCurrentRow(-1, false);
                } else {
                    this.validateCurrentRow(n - 1);
                    if (this.mViewSize != -1) {
                        int n2;
                        int n3 = n2 = this.mTopRowIndex >= 0 ? this.mTopRowIndex : 0;
                        if (n > n2 + this.mViewSize) {
                            int n4 = this.mTopRowIndex;
                            if ((this.mIterMode & 1) == 1) {
                                this.mTopRowIndex = n - this.mViewSize;
                            } else {
                                int n5 = n % this.mViewSize;
                                if (n5 == 0) {
                                    n5 = this.mViewSize;
                                }
                                this.mTopRowIndex = n - n5;
                                this.mSize = n5;
                            }
                            if (n4 != this.mTopRowIndex) {
                                this.notifyRangeScrolled(n4);
                            }
                        } else if (this.mSize == 0) {
                            this.scrollRange(-this.mViewSize);
                        }
                    }
                    this.internalSetCurrentRow(n - 1, false);
                }
            }
            catch (JboException jboException) {
                throw jboException;
            }
            catch (Exception exception) {
                throw new JboException(exception);
            }
            Row row = this.getCurrentRow();
            return row;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Row next() {
        Object object = this.getSyncLock();
        synchronized (object) {
            try {
                Row row;
                this.activateIteratorState(null, true);
                if (this.mCurrentRowSlot == 3) {
                    Row row2 = null;
                    return row2;
                }
                this.ensureRefreshed(true);
                int n = this.nextIndex();
                int n2 = this.mCurrentRowSlot;
                this.validateCurrentRow(n);
                if (this.mViewSize > 0 && this.mCurrentRowSlot != 1 && this.mCurrentRowIndex >= 0) {
                    if (this.mCurrentRowIndex == this.mTopRowIndex + this.mViewSize - 1) {
                        this.scrollRange(1);
                    } else if (this.mCurrentRowIndex < this.mTopRowIndex || this.mCurrentRowIndex >= this.mTopRowIndex + this.mViewSize) {
                        int n3 = this.mCurrentRowIndex + 1 - this.mTopRowIndex - this.mViewSize / 2;
                        this.scrollRange(n3);
                    }
                }
                if ((row = this.getRowInternal(n)) == null) {
                    this.mCurrentRowSlot = 3;
                }
                this.internalSetCurrentRow(n, false);
                if (this.mCurrentRowSlot == 3 && n2 != 3 && n2 != 0) {
                    this.notifyNavigation();
                }
                Row row3 = this.getCurrentRow();
                return row3;
            }
            catch (JboException jboException) {
                throw jboException;
            }
            catch (Exception exception) {
                throw new JboException(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Row previous() {
        if (this.mViewRowSet.isForwardOnly()) {
            Class clazz = class$oracle$jbo$CSMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$jbo$CSMessageBundle = ViewRowSetIteratorImpl.class$("oracle.jbo.CSMessageBundle");
            }
            throw new InvalidOperException(clazz, "25011", new Object[]{this.mViewRowSet.getName()});
        }
        Object object = this.getSyncLock();
        synchronized (object) {
            try {
                int n;
                this.ensureRefreshed(true);
                int n2 = this.mCurrentRowSlot;
                if (this.mCurrentRowSlot == 2 || this.mCurrentRowSlot != 1 && this.mSize == 0 || this.mCurrentRowIndex == this.mTopRowIndex && this.mTopRowIndex == 0) {
                    n = -1;
                    if (this.mCurrentRowSlot != 2) {
                        this.validateCurrentRow(n);
                    }
                    this.mCurrentRowSlot = 2;
                } else {
                    n = this.previousIndex();
                    this.validateCurrentRow(n);
                }
                if (this.mViewSize > 0 && this.mCurrentRowSlot != 1 && this.mCurrentRowIndex > 0) {
                    if (this.mCurrentRowIndex == this.mTopRowIndex && this.mTopRowIndex > 0) {
                        this.scrollRange(-1);
                    } else if (this.mCurrentRowIndex < this.mTopRowIndex || this.mCurrentRowIndex >= this.mTopRowIndex + this.mViewSize) {
                        int n3 = this.mCurrentRowIndex - 1 - this.mTopRowIndex - this.mViewSize / 2;
                        this.scrollRange(n3);
                    }
                }
                this.internalSetCurrentRow(n, false);
                if (this.mCurrentRowSlot == 2 && n2 != 2 && n2 != 0) {
                    this.notifyNavigation();
                }
                Row row = this.getCurrentRow();
                return row;
            }
            catch (JboException jboException) {
                throw jboException;
            }
            catch (Exception exception) {
                throw new JboException(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNext() {
        Object object = this.getSyncLock();
        synchronized (object) {
            this.ensureRefreshed(true);
            if (this.mTopRowIndex == -1 || this.mCurrentRowSlot == 3) {
                boolean bl = false;
                return bl;
            }
            Row row = this.getRowInternal(this.nextIndex());
            boolean bl = row != null;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPrevious() {
        if (this.getViewObject().isForwardOnly()) {
            return false;
        }
        Object object = this.getSyncLock();
        synchronized (object) {
            try {
                this.ensureRefreshed(true);
                if (this.mCurrentRowSlot == 2) {
                    boolean bl = false;
                    return bl;
                }
                ViewRowSetImpl viewRowSetImpl = this.getRowSetImpl();
                if (viewRowSetImpl.isRangePaging() && viewRowSetImpl.getQueryCollection().mPageStart > 0) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = viewRowSetImpl.getRow(this.previousIndex()) != null;
                return bl;
            }
            catch (JboException jboException) {
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRangeAtBottom() {
        Object object = this.getSyncLock();
        synchronized (object) {
            this.ensureRefreshed(true);
            int n = this.mTopRowIndex < 0 ? 0 : this.mTopRowIndex;
            QueryCollection queryCollection = this.getQueryCollection();
            if (queryCollection == null || queryCollection.isFetchComplete() && n + this.mSize >= this.getFetchedRowCount()) {
                if (this.getUnpostedRowCount() > 0) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRangeAtTop() {
        Object object = this.getSyncLock();
        synchronized (object) {
            this.activateIteratorState(null, true);
            boolean bl = this.mTopRowIndex <= 0;
            return bl;
        }
    }

    public int nextIndex() {
        this.activateIteratorState(null, true);
        int n = this.mCurrentRowSlot == 3 ? -1 : (this.mCurrentRowSlot == 2 ? (this.mViewRowSet.isForwardOnly() && this.mTopRowIndex >= 0 ? this.mTopRowIndex : 0) : (this.mCurrentRowSlot == 1 ? this.mCurrentRowIndex : this.mCurrentRowIndex + 1));
        return n;
    }

    public int previousIndex() {
        this.activateIteratorState(null, true);
        int n = this.mCurrentRowSlot == 2 ? -1 : (this.mCurrentRowSlot == 3 ? this.getFetchedRowCount() - 1 : this.mCurrentRowIndex - 1);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Row[] getAllRowsInRangeInternal(boolean bl) {
        if (this.mViewRowSet == null) {
            return new Row[0];
        }
        ArrayList arrayList = null;
        Object object = this.getSyncLock();
        synchronized (object) {
            QueryCollection queryCollection;
            if (bl) {
                this.ensureRefreshed(true);
            }
            if ((queryCollection = this.getQueryCollection()) != null && this.mTopRowIndex >= 0 && this.mSize > 0) {
                int n = 0;
                while (arrayList == null || arrayList.size() < this.mSize) {
                    int n2 = this.mTopRowIndex + n++;
                    if (!bl && n2 >= queryCollection.getCollectionSize()) break;
                    Row row = (Row)queryCollection.get(n2);
                    if (arrayList == null) {
                        arrayList = new ArrayList(this.mSize);
                    }
                    arrayList.add((Object)row);
                }
            }
        }
        return arrayList != null ? (Row[])arrayList.toArray((Object[])new Row[arrayList.size()]) : new Row[]{};
    }

    public Row[] getAllRowsInRange() {
        return this.getAllRowsInRangeInternal(true);
    }

    public Row[] getNextRangeSet() {
        return this.getNextRangeSetWithAdjustment(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Row[] getNextRangeSetWithAdjustment(int n) {
        Object object = this.getSyncLock();
        synchronized (object) {
            if (this.isRangeAtBottom()) {
                Row[] rowArray = new Row[]{};
                return rowArray;
            }
            if (this.mCurrentRowSlot != 2) {
                int n2 = this.getIterMode();
                try {
                    this.setIterMode(0);
                    this.scrollRange(this.mViewSize + n);
                    Object var7_5 = null;
                    this.setIterMode(n2);
                }
                catch (Throwable throwable) {
                    Object var7_6 = null;
                    this.setIterMode(n2);
                    throw throwable;
                }
            }
            Row[] rowArray = this.getAllRowsInRange();
            this.setCurrentRowAtRangeIndex(0);
            Row[] rowArray2 = rowArray;
            return rowArray2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Row[] getPreviousRangeSet() {
        Object object = this.getSyncLock();
        synchronized (object) {
            this.activateIteratorState(null, true);
            if (this.isRangeAtTop()) {
                Row[] rowArray = new Row[]{};
                return rowArray;
            }
            if (this.mCurrentRowSlot != 3) {
                int n = this.getIterMode();
                try {
                    this.setIterMode(0);
                    this.scrollRange(-this.mViewSize);
                    Object var6_4 = null;
                    this.setIterMode(n);
                }
                catch (Throwable throwable) {
                    Object var6_5 = null;
                    this.setIterMode(n);
                    throw throwable;
                }
            }
            Row[] rowArray = this.getAllRowsInRange();
            this.setCurrentRowAtRangeIndex(rowArray.length - 1);
            Row[] rowArray2 = rowArray;
            return rowArray2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration enumerateRowsInRange() {
        Object object = this.getSyncLock();
        synchronized (object) {
            1 var2_2 = new 1();
            return var2_2;
        }
    }

    public Row createAndInitRow(AttributeList attributeList) {
        return this.mViewRowSet.createAndInitRow(attributeList);
    }

    public Row createRow() {
        return this.mViewRowSet.createRow();
    }

    public void insertRow(Row row) {
        this.doInsertRow(row, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doInsertRow(Row row, boolean bl) {
        Object object = this.getSyncLock();
        synchronized (object) {
            this.activateIteratorState(null, true);
            int n = this.mCurrentRowIndex;
            if (this.mViewRowSet.isRangePaging()) {
                n = 0;
            } else if (n < 0 && this.mCurrentRowSlot == 3) {
                this.ensureRefreshed(true);
                n = this.mTopRowIndex + this.mSize;
            } else if (this.mViewRowSet.isForwardOnly()) {
                n = this.mTopRowIndex + this.mSize;
            }
            if (n < 0) {
                n = 0;
            }
            n = this.mViewRowSet.insertViewRowAt(n, (ViewRowImpl)row);
            if (bl) {
                this.validateCurrentRow(n);
            }
            if (this.mViewRowSet.isForwardOnly()) {
                this.scrollRange(n - this.mTopRowIndex);
            }
            if (bl) {
                this.internalSetCurrentRow(n, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertRowAtRangeIndex(int n, Row row) {
        Object object = this.getSyncLock();
        synchronized (object) {
            this.activateIteratorState(null, true);
            if (n < 0 || this.mViewSize > 0 && n > this.mViewSize) {
                throw new InvalidParamException(MTH_insertRowAtRangeIndex, "rangeIndex", new Integer(n), "index outside range");
            }
            this.ensureRefreshed(true);
            if (n > this.mSize) {
                throw new InvalidParamException(MTH_insertRowAtRangeIndex, "rangeIndex", new Integer(n), "index beyond end of row set");
            }
            if (!this.mViewRowSet.isScrollable()) {
                this.insertRow(row);
                return;
            }
            int n2 = n + (this.mTopRowIndex > 0 ? this.mTopRowIndex : 0);
            this.mViewRowSet.insertRowAt(n2, (ViewRowImpl)row);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doRemoveCurrentRow(int n) {
        Object object = this.getSyncLock();
        synchronized (object) {
            this.activateIteratorState(null, true);
            if (this.mCurrentRow == null) {
                throw new RowNotFoundException(this);
            }
            int n2 = this.mCurrentRowIndex;
            if (this.mViewRowSet.isForwardOnly() && this.mTopRowIndex > 0) {
                n2 -= this.mTopRowIndex;
            }
            if (n == 0) {
                this.mViewRowSet.removeRowAt(n2);
            } else if (n == 1) {
                this.mViewRowSet.removeRowFromCollectionAt(n2);
            } else {
                this.mViewRowSet.removeRowAndRetainAt(n2);
            }
        }
    }

    public void removeCurrentRow() {
        this.doRemoveCurrentRow(0);
    }

    public void removeCurrentRowFromCollection() {
        this.doRemoveCurrentRow(1);
    }

    public Row removeCurrentRowAndRetain() {
        Row row = this.getCurrentRow();
        this.doRemoveCurrentRow(2);
        return row;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRowAtRangeIndex(int n) {
        Object object = this.getSyncLock();
        synchronized (object) {
            this.activateIteratorState(null, true);
            int n2 = this.mViewRowSet.isForwardOnly() ? n : n + this.mTopRowIndex;
            this.mViewRowSet.removeRowAt(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowSet createDetailRowSet(String string, String string2) {
        Object object = this.getSyncLock();
        synchronized (object) {
            ViewLinkDefImpl viewLinkDefImpl = ViewLinkDefImpl.findDefObject(string2);
            if (viewLinkDefImpl == null || viewLinkDefImpl.getSourceOwner() != ((ViewObjectImpl)this.getRowSetImpl().getViewObject()).getViewDef()) {
                throw new InvalidParamException(MTH_createDetailRowSet, "linkDefName", string2, "invalid or mismatching view link definition");
            }
            ViewObjectImpl viewObjectImpl = this.findDetailViewObject((ViewDefImpl)viewLinkDefImpl.getDestinationOwner(), viewLinkDefImpl);
            if (viewObjectImpl == null) {
                Class clazz = class$oracle$jbo$CSMessageBundle;
                if (clazz == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = ViewRowSetIteratorImpl.class$("oracle.jbo.CSMessageBundle");
                }
                throw new NoObjException(clazz, "25062", new Object[]{string2, this.getName()});
            }
            ViewRowSetImpl viewRowSetImpl = new ViewRowSetImpl(viewObjectImpl, string, this);
            viewRowSetImpl.getDefaultRowSetIterator();
            RowSet rowSet = viewRowSetImpl;
            return rowSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addDetailViewRowSet(RowSet rowSet) {
        Object object = this.getSyncLock();
        synchronized (object) {
            ((ViewObjectImpl)this.getViewObject()).propagateEvent(ViewObjectImpl.EVENT_PROPAGATION_UPDATE);
            this.mDetailRowSets.add((Object)rowSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeDetailViewRowSet(RowSet rowSet) {
        if (this.mViewRowSet != null && this.getViewObject() != null) {
            Object object = this.getSyncLock();
            synchronized (object) {
                this.mDetailRowSets.remove((Object)rowSet);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowSet[] getDetailRowSets() {
        Object object = this.getSyncLock();
        synchronized (object) {
            if (this.mViewRowSet.getDefaultRowSetIterator() == this) {
                ViewLink[] viewLinkArray = ((ViewObjectImpl)this.getViewObject()).getViewLinks();
                int n = 0;
                while (n < viewLinkArray.length) {
                    if (viewLinkArray[n].getSource() == this.getViewObject()) {
                        ((ViewObjectImpl)viewLinkArray[n].getDestination()).getDefaultRowSet();
                    }
                    ++n;
                }
            }
            RowSet[] rowSetArray = (RowSet[])this.mDetailRowSets.toArray((Object[])new RowSet[this.mDetailRowSets.size()]);
            return rowSetArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRangeStart() {
        Object object = this.getSyncLock();
        synchronized (object) {
            this.activateIteratorState(null, true);
            int n = this.mTopRowIndex;
            return n;
        }
    }

    public int setRangeStart(int n) {
        return this.setRangeStartWithRefresh(n, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int setRangeStartWithRefresh(int n, boolean bl) {
        Object object = this.getSyncLock();
        synchronized (object) {
            if (bl) {
                this.ensureRefreshed(true);
            }
            int n2 = n - (this.mTopRowIndex < 0 ? 0 : this.mTopRowIndex);
            this.scrollRange(n2);
            int n3 = this.mTopRowIndex;
            return n3;
        }
    }

    public boolean isRefreshed() {
        return this.mRefreshNeeded ^ true;
    }

    private void ensureRefreshed(boolean bl) {
        boolean bl2 = bl && this.getCurrentRowSlot() == 2;
        this.ensureRefreshed(bl, bl2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureRefreshed(boolean bl, boolean bl2, Row[] rowArray) {
        boolean bl3 = this.mRefreshNeeded;
        if (this.mViewRowSet == null) {
            return;
        }
        Object object = this.getSyncLock();
        synchronized (object) {
            this.activateIteratorState(null, true);
            if (!this.mViewRowSet.isExecuted()) {
                boolean bl4 = this.mViewRowSet.isNotifiedRefresh();
                this.mViewRowSet.execute(false, false);
                if (!bl4) {
                    return;
                }
            }
            if (this.mRefreshNeeded || this.mSize == 0 && this.mCurrentRowSlot == 2) {
                this.doFetch(-1);
            } else {
                this.doFetch(this.mTopRowIndex + this.mSize);
            }
            this.mRefreshNeeded = false;
            if (bl3) {
                this.notifyRangeRefreshed(bl, bl2, rowArray);
            }
        }
    }

    private ViewObjectImpl findDetailViewObject(ViewDefImpl viewDefImpl, ViewLinkDefImpl viewLinkDefImpl) {
        ViewLink[] viewLinkArray = ((ViewObjectImpl)this.getViewObject()).getViewLinks();
        int n = 0;
        while (n < viewLinkArray.length) {
            if (viewLinkArray[n].getSource() == this.getViewObject() && ((ViewLinkImpl)viewLinkArray[n]).getViewLinkDef() == viewLinkDefImpl) {
                return (ViewObjectImpl)viewLinkArray[n].getDestination();
            }
            ++n;
        }
        return null;
    }

    private void ensureInRange(int n) {
        if (n >= this.mSize) {
            throw new InvalidParamException(MTH_ensureInRange, "rangeIndex", new Integer(n), "index outside range");
        }
    }

    private void doFetch(int n) {
        Row row;
        int n2;
        if (this.mViewSize != -1 && this.mSize >= this.mViewSize) {
            return;
        }
        if (n == -1) {
            this.mSize = 0;
            n2 = this.mTopRowIndex == -1 ? 0 : this.mTopRowIndex;
        } else {
            n2 = n;
        }
        while ((row = this.getRowSetImpl().getRow(n2++)) != null) {
            if (this.mViewSize == -1 || this.mSize < this.mViewSize) {
                ++this.mSize;
            }
            if (this.mViewSize == -1 || this.mSize < this.mViewSize) continue;
            break;
        }
        if (n == -1 && this.mTopRowIndex == -1 && this.mSize > 0) {
            this.mTopRowIndex = 0;
        }
    }

    protected void refresh(boolean bl, boolean bl2) {
        this.refresh(bl, false, bl2, true, null);
    }

    void refresh(boolean bl, boolean bl2, boolean bl3, boolean bl4, Row[] rowArray) {
        if (bl) {
            this.mRefreshNeeded = true;
            this.mSize = 0;
            this.mTopRowIndex = -1;
            this.mCurrentRow = null;
            this.mCurrentRowIndex = -1;
            this.mPreviousCurrentRow = null;
            this.mPreviousCurrentRowIndex = -1;
            this.mCurrentRowSlot = 2;
            this.mIteratorState = null;
            this.mRowEvents.clear();
        }
        if (bl2) {
            this.mRefreshNeeded = true;
            this.mSize = 0;
        }
        if (bl3) {
            this.ensureRefreshed(bl4, bl4 && this.getCurrentRowSlot() == 2, rowArray);
        }
    }

    private RowSetIterator getExposedObject() {
        if (this.mIsDefaultRSI) {
            return this.getRowSet();
        }
        return this;
    }

    private void notifyRangeScrolled(int n) {
        if (this.mSuppressEvents == 0 && this.hasListeners()) {
            this.fireRangeScrolled(new ScrollEvent(this.getExposedObject(), n));
        }
    }

    void notifyRowInserted(Row row, int n, boolean bl, boolean bl2) {
        Row row2 = this.getTheRow(row);
        if (!bl) {
            this.deliverRowInsertedEvent(row2);
            return;
        }
        int n2 = this.mSize;
        if (bl2) {
            if (n <= this.mCurrentRowIndex) {
                ++this.mCurrentRowIndex;
            }
            if (n <= this.mPreviousCurrentRowIndex) {
                ++this.mPreviousCurrentRowIndex;
            }
            if (this.mTopRowIndex < 0) {
                this.mTopRowIndex = 0;
            }
            if (n < this.mTopRowIndex) {
                ++this.mTopRowIndex;
            }
            if (!(n < this.mTopRowIndex || this.mViewSize != -1 && n >= this.mTopRowIndex + this.mViewSize || this.mViewSize != -1 && this.mSize >= this.mViewSize)) {
                ++this.mSize;
            }
        }
        this.addRowEvent(row2, new InsertEvent(this.getExposedObject(), row2, n, n2, this.mSize));
    }

    private void deliverRowInsertedEvent(Row row) {
        InsertEvent insertEvent;
        Class clazz = class$oracle$jbo$InsertEvent;
        if (clazz == null) {
            clazz = class$oracle$jbo$InsertEvent = ViewRowSetIteratorImpl.class$("oracle.jbo.InsertEvent");
        }
        if ((insertEvent = (InsertEvent)this.getRowEvent(row, clazz)) == null) {
            return;
        }
        if (this.mSuppressEvents == 0 && this.hasListeners()) {
            this.fireRowInserted(insertEvent);
        }
    }

    void notifyRowDeleted(Row row, int n, boolean bl, boolean bl2) {
        Row row2 = this.getTheRow(row);
        if (this.mViewRowSet.isForwardOnly() && this.mTopRowIndex > 0) {
            n += this.mTopRowIndex;
        }
        if (!bl) {
            if (this.mViewSize == -1 || n >= this.mTopRowIndex && n <= this.mTopRowIndex + this.mViewSize) {
                if (this.mViewSize != -1 && this.mSize < this.mViewSize) {
                    this.doFetch(this.mTopRowIndex + this.mSize);
                }
                this.deliverRowDeletedEvent(row2);
                if (!this.mViewRowSet.isForwardOnly()) {
                    if ((this.mIterMode & 1) == 1 && this.mViewSize != -1 && this.mTopRowIndex > 0) {
                        int n2;
                        int n3 = n2 = this.mSize == this.mViewSize ? this.mTopRowIndex + this.mSize - 1 : this.mTopRowIndex + this.mSize;
                        if (this.getRowSetImpl().getRow(n2) == null) {
                            this.scrollRange(-1);
                        }
                    } else if ((this.mIterMode & 1) == 0 && this.mViewSize != -1 && this.mSize == 0) {
                        this.scrollRange(-this.mViewSize);
                    }
                }
            } else {
                this.deliverRowDeletedEvent(row2);
            }
            return;
        }
        if (row != null && row.equals(this.mCurrentRow)) {
            this.mCurrentRowSlot = 1;
            this.mCurrentRow = null;
        }
        if (n < this.mCurrentRowIndex) {
            --this.mCurrentRowIndex;
        }
        if (n < this.mPreviousCurrentRowIndex) {
            --this.mPreviousCurrentRowIndex;
        }
        int n4 = this.mSize;
        if (n >= this.mTopRowIndex && n < this.mTopRowIndex + this.mSize) {
            --this.mSize;
        }
        if (this.mTopRowIndex > 0 && n < this.mTopRowIndex) {
            --this.mTopRowIndex;
        }
        this.addRowEvent(row2, new DeleteEvent(this.getExposedObject(), row2, n, n4, this.mSize, bl2));
    }

    private void deliverRowDeletedEvent(Row row) {
        DetailQueryTS[] detailQueryTSArray;
        DeleteEvent deleteEvent;
        if (this.mSuppressEvents > 0) {
            return;
        }
        Class clazz = class$oracle$jbo$DeleteEvent;
        if (clazz == null) {
            clazz = class$oracle$jbo$DeleteEvent = ViewRowSetIteratorImpl.class$("oracle.jbo.DeleteEvent");
        }
        if ((deleteEvent = (DeleteEvent)this.getRowEvent(row, clazz)) == null) {
            return;
        }
        DetailQueryTS[] detailQueryTSArray2 = detailQueryTSArray = this.mDetailRowSets != null ? this.getDetailQueryTSs() : null;
        if (this.hasListeners()) {
            this.fireRowDeleted(deleteEvent);
        }
        if (detailQueryTSArray != null) {
            this.notifyDetailRowSets(deleteEvent, detailQueryTSArray);
        }
    }

    void notifyRowUpdated(Row[] rowArray, int[] nArray) {
        if (this.mSuppressEvents > 0 || !this.hasListeners() && (this.mDetailRowSets == null || this.mDetailRowSets.size() == 0)) {
            return;
        }
        if (!this.hasListeners()) {
            boolean bl = false;
            int n = 0;
            while (n < this.mDetailRowSets.size()) {
                RowSet rowSet = (RowSet)this.mDetailRowSets.get(n);
                if (rowSet.getViewObject() instanceof ViewObjectImpl && ((ViewObjectImpl)rowSet.getViewObject()).isSourceAttribute(nArray)) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                return;
            }
        }
        boolean bl = this.getRowSetImpl().isReceiveAllInsertEvents();
        int n = 0;
        while (n < rowArray.length) {
            Row row = rowArray[n];
            int n2 = this.getRangeIndexOf(row);
            if (n2 != -1 || row == this.mCurrentRow || bl) {
                this.fireRowUpdated(n2, row, nArray);
            }
            ++n;
        }
    }

    ViewLinkDefImpl findViewLinkDef(ViewObject viewObject, ViewObject viewObject2) {
        ViewLink[] viewLinkArray = ((ViewObjectImpl)this.getViewObject()).getViewLinks();
        int n = 0;
        while (n < viewLinkArray.length) {
            if (viewLinkArray[n].getSource() == viewObject && viewLinkArray[n].getDestination() == viewObject2) {
                return ((ViewLinkImpl)viewLinkArray[n]).getViewLinkDef();
            }
            ++n;
        }
        return null;
    }

    private void validateCurrentRow(int n) {
        if (this.mCurrentRowIndex != n && this.mCurrentRow != null && this.mRowValidation) {
            this.mCurrentRow.validate();
        }
    }

    private boolean internalSetCurrentRow(int n, boolean bl) {
        Row row;
        Row row2 = row = n < 0 ? null : this.getRowInternal(n);
        if (row == null) {
            n = -1;
            if (bl) {
                return false;
            }
        }
        if (this.mCurrentRow != row || this.mCurrentRow != null && this.mCurrentRowIndex != n) {
            this.mPreviousCurrentRow = this.mCurrentRow;
            this.mPreviousCurrentRowIndex = this.mCurrentRowIndex;
            this.mCurrentRow = row;
            this.mCurrentRowIndex = n;
            if (row != null) {
                this.mCurrentRowSlot = 0;
            }
            this.notifyNavigation();
        }
        return true;
    }

    private Row getRowInternal(int n) {
        return this.getRowSetImpl().getRow(n);
    }

    public Hashtable getProperties() {
        return this.getViewObject().getProperties();
    }

    public void addListener(Object object) {
        ((ViewObjectImpl)this.getViewObject()).propagateEvent(ViewObjectImpl.EVENT_PROPAGATION_UPDATE);
        super.addListener(object);
    }

    boolean refreshEventPropagation() {
        ArrayList arrayList = this.getListenersList();
        if (arrayList != null && !arrayList.isEmpty()) {
            ((ViewObjectImpl)this.getViewObject()).propagateEvent(ViewObjectImpl.EVENT_PROPAGATION_UPDATE);
            return true;
        }
        return false;
    }

    void notifyDetailRowSets(JboEvent jboEvent, DetailQueryTS[] detailQueryTSArray) {
        if (this.mDetailRowSets == null || this.mDetailRowSets.size() == 0) {
            return;
        }
        int n = this.mDetailRowSets.size();
        int n2 = 0;
        while (n2 < n) {
            Object object = this.mDetailRowSets.get(n2);
            ViewRowSetImpl viewRowSetImpl = (ViewRowSetImpl)(object instanceof ViewObjectImpl ? ((ViewObjectImpl)object).getDefaultRowSet() : object);
            boolean bl = true;
            boolean bl2 = true;
            if (jboEvent instanceof RangeRefreshEvent) {
                RangeRefreshEvent rangeRefreshEvent = (RangeRefreshEvent)jboEvent;
                bl2 = rangeRefreshEvent.isPosReset();
            }
            int n3 = 0;
            while (n3 < detailQueryTSArray.length) {
                if (detailQueryTSArray[n3].mRS == viewRowSetImpl) {
                    boolean bl3 = bl = detailQueryTSArray[n3].mQueryTS == viewRowSetImpl.getQueryTS();
                    if (!(bl &= bl2) || viewRowSetImpl.mDefaultView == null) break;
                    bl = viewRowSetImpl.mDefaultView.mIteratorState == null;
                    break;
                }
                ++n3;
            }
            if (bl) {
                viewRowSetImpl.refreshRowSet(jboEvent);
            }
            ++n2;
        }
    }

    DetailQueryTS[] getDetailQueryTSs() {
        if (this.mDetailRowSets == null || this.mDetailRowSets.size() == 0) {
            return null;
        }
        int n = this.mDetailRowSets.size();
        DetailQueryTS[] detailQueryTSArray = new DetailQueryTS[n];
        int n2 = 0;
        while (n2 < n) {
            Object object = this.mDetailRowSets.get(n2);
            detailQueryTSArray[n2] = new DetailQueryTS((ViewRowSetImpl)(object instanceof ViewObjectImpl ? ((ViewObjectImpl)object).getDefaultRowSet() : object));
            ++n2;
        }
        return detailQueryTSArray;
    }

    private RangeRefreshEvent buildRangeRefreshEvent(boolean bl, boolean bl2, Row[] rowArray) {
        Row[] rowArray2 = this.getAllRowsInRange();
        RangeRefreshEvent rangeRefreshEvent = new RangeRefreshEvent(this.getExposedObject(), this.mTopRowIndex, this.mSize, rowArray2, bl, rowArray);
        rangeRefreshEvent.setPosReset(bl2);
        return rangeRefreshEvent;
    }

    void notifyRangeRefreshed(boolean bl, boolean bl2, Row[] rowArray) {
        if (this.mSuppressEvents > 0) {
            return;
        }
        DetailQueryTS[] detailQueryTSArray = this.mDetailRowSets != null ? this.getDetailQueryTSs() : null;
        RangeRefreshEvent rangeRefreshEvent = null;
        if (this.hasListeners()) {
            if (rangeRefreshEvent == null) {
                rangeRefreshEvent = this.buildRangeRefreshEvent(bl, bl2, rowArray);
            }
            this.fireRangeRefreshed(rangeRefreshEvent);
        }
        if (detailQueryTSArray != null && bl) {
            if (rangeRefreshEvent == null) {
                rangeRefreshEvent = this.buildRangeRefreshEvent(bl, bl2, rowArray);
            }
            this.notifyDetailRowSets(rangeRefreshEvent, detailQueryTSArray);
        }
    }

    private NavigationEvent buildNavigationEvent(Row row) {
        if (row == null) {
            row = this.getCurrentRow();
        }
        return new NavigationEvent(this.getExposedObject(), this.getTheRow(this.mPreviousCurrentRow), row);
    }

    public void refreshDetailRowSet(Row row) {
        this.notifyNavigationToRow(row, false);
    }

    void notifyNavigation() {
        this.notifyNavigationToRow(null, true);
    }

    void notifyNavigationToRow(Row row, boolean bl) {
        if (this.mSuppressEvents > 0) {
            return;
        }
        DetailQueryTS[] detailQueryTSArray = this.mDetailRowSets != null ? this.getDetailQueryTSs() : null;
        NavigationEvent navigationEvent = null;
        if (this.hasListeners()) {
            if (navigationEvent == null) {
                navigationEvent = this.buildNavigationEvent(row);
            }
            if (bl) {
                this.fireNavigationEvent(navigationEvent);
            }
        }
        if (detailQueryTSArray != null) {
            if (navigationEvent == null) {
                navigationEvent = this.buildNavigationEvent(row);
            }
            this.notifyDetailRowSets(navigationEvent, detailQueryTSArray);
        }
    }

    private UpdateEvent buildUpdateEvent(int n, Row row, int[] nArray) {
        return new UpdateEvent(this.getExposedObject(), this.getTheRow(row), n, nArray);
    }

    public void fireRowUpdated(int n, Row row, int[] nArray) {
        if (this.mSuppressEvents > 0) {
            return;
        }
        DetailQueryTS[] detailQueryTSArray = this.mDetailRowSets != null ? this.getDetailQueryTSs() : null;
        UpdateEvent updateEvent = null;
        if (this.hasListeners()) {
            if (updateEvent == null) {
                updateEvent = this.buildUpdateEvent(n, row, nArray);
            }
            this.fireRowUpdated(updateEvent);
        }
        if (detailQueryTSArray != null) {
            if (updateEvent == null) {
                updateEvent = this.buildUpdateEvent(n, row, nArray);
            }
            this.notifyDetailRowSets(updateEvent, detailQueryTSArray);
        }
    }

    private RowSetManagementEvent buildRowSetManagementEvent() {
        return new RowSetManagementEvent(this.getExposedObject(), 0);
    }

    void notifyIteratorReset() {
        if (this.mSuppressEvents > 0) {
            return;
        }
        DetailQueryTS[] detailQueryTSArray = this.mDetailRowSets != null ? this.getDetailQueryTSs() : null;
        RowSetManagementEvent rowSetManagementEvent = null;
        if (detailQueryTSArray != null) {
            if (rowSetManagementEvent == null) {
                rowSetManagementEvent = this.buildRowSetManagementEvent();
            }
            this.notifyDetailRowSets(rowSetManagementEvent, detailQueryTSArray);
        }
        if (this.hasManagementListeners()) {
            if (rowSetManagementEvent == null) {
                rowSetManagementEvent = this.buildRowSetManagementEvent();
            }
            this.fireMgmtIteratorReset(rowSetManagementEvent);
        }
    }

    public static RowSetIterator findRSIForEntity(RowSetIterator[] rowSetIteratorArray, Row row) {
        EntityDefImpl entityDefImpl = ((EntityImpl)row).getEntityDef();
        int n = 0;
        while (n < rowSetIteratorArray.length) {
            ViewObjectImpl viewObjectImpl = (ViewObjectImpl)((ViewRowSetIteratorImpl)rowSetIteratorArray[n]).getViewObject();
            if (viewObjectImpl.getEntityDef(0) == entityDefImpl) {
                return rowSetIteratorArray[n];
            }
            ++n;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Row[] findByEntity(int n, int n2) {
        Object object = this.getSyncLock();
        synchronized (object) {
            ViewObjectImpl viewObjectImpl = (ViewObjectImpl)this.getViewObject();
            ApplicationModuleImpl applicationModuleImpl = (ApplicationModuleImpl)viewObjectImpl.getApplicationModule();
            EntityImpl entityImpl = (EntityImpl)applicationModuleImpl.getEntityRowFromHandle(n);
            EntityDefImpl entityDefImpl = entityImpl.getEntityDef();
            if (viewObjectImpl.getEntityDef(0) != entityDefImpl) {
                Class clazz = class$oracle$jbo$CSMessageBundle;
                if (clazz == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = ViewRowSetIteratorImpl.class$("oracle.jbo.CSMessageBundle");
                }
                throw new InvalidOperException(clazz, "25012", new Object[]{viewObjectImpl.getName(), entityDefImpl.getName()});
            }
            Row[] rowArray = this.findByKey(entityImpl.getKey(), n2);
            return rowArray;
        }
    }

    private Object getRowEvent(Row row, Class clazz) {
        ArrayList arrayList = (ArrayList)this.mRowEvents.get((Object)row);
        if (arrayList == null) {
            return null;
        }
        Object object = null;
        int n = 0;
        while (n < arrayList.size()) {
            if (clazz.isInstance(arrayList.get(n))) {
                object = arrayList.get(n);
                arrayList.remove(n);
                break;
            }
            ++n;
        }
        if (arrayList.size() == 0) {
            this.mRowEvents.remove((Object)row);
        }
        return object;
    }

    private void addRowEvent(Row row, Object object) {
        ArrayList arrayList = (ArrayList)this.mRowEvents.get((Object)row);
        if (arrayList == null) {
            arrayList = new ArrayList(4);
            this.mRowEvents.put((Object)row, (Object)arrayList);
        }
        arrayList.add(object);
    }

    void setIteratorActivationRequired(IteratorStateHolder iteratorStateHolder) {
        this.mIteratorState = iteratorStateHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void activateIteratorState(Element element, boolean bl) {
        if (this.mViewRowSet == null || this.mViewRowSet.mQRef == null) {
            return;
        }
        this.mViewRowSet.activateRowSetState();
        if (this.mIteratorState == null) {
            return;
        }
        Object object = this.getSyncLock();
        synchronized (object) {
            ViewObjectImpl viewObjectImpl = this.mViewRowSet.mQRef;
            IteratorStateHolder iteratorStateHolder = this.mIteratorState;
            this.mIteratorState = null;
            this.setIterMode(iteratorStateHolder.mIterMode);
            Key key = iteratorStateHolder.getCurrentRowKey(this.getViewObject().getKeyAttributeDefs());
            String string = iteratorStateHolder.mMasterViewName;
            if (string != null && string.length() > 0) {
                ApplicationModuleImpl applicationModuleImpl = (ApplicationModuleImpl)this.mViewRowSet.mQRef.getApplicationModule();
                ((ViewObjectImpl)applicationModuleImpl.findViewObject(string)).activateIteratorState(null, bl);
            }
            if (element != null) {
                viewObjectImpl.activateNewRowTracker(this.mViewRowSet, element);
            }
            ViewRowImpl viewRowImpl = null;
            if (iteratorStateHolder instanceof RowSetStateHolder && ((RowSetStateHolder)iteratorStateHolder).mExecuted && !this.mViewRowSet.isExecuted()) {
                this.mViewRowSet.setRowSetActivationRequired((RowSetStateHolder)iteratorStateHolder);
                this.mViewRowSet.activateRowSetState();
            }
            ArrayList arrayList = this.mViewRowSet.mUserParams;
            Object[] objectArray = this.mViewRowSet.mParamValues;
            boolean bl2 = this.mViewRowSet.mParamsChanged;
            this.mViewRowSet.mUserParams = this.mViewRowSet.mExecuteUserParams;
            this.mViewRowSet.mParamValues = this.mViewRowSet.mExecuteParamValues;
            if (key != null) {
                viewRowImpl = viewObjectImpl.activateCurrentRow(this, this.mViewRowSet, key);
            }
            this.mViewSize = iteratorStateHolder.mRangeSize;
            if (iteratorStateHolder.mRangeStart > -1) {
                this.setRangeStartWithRefresh(iteratorStateHolder.mRangeStart, false);
            }
            this.mViewRowSet.mUserParams = arrayList;
            this.mViewRowSet.mParamValues = objectArray;
            this.mViewRowSet.mParamsChanged = bl2;
            if (viewRowImpl != null) {
                int n = this.getRangeIndexOf(viewRowImpl);
                if (this.getRangeStart() == -1 && (n < 0 || n >= this.getRangeSize())) {
                    this.scrollRangeTo(viewRowImpl, 0);
                }
                if (!(iteratorStateHolder instanceof RowSetStateHolder) || ((RowSetStateHolder)iteratorStateHolder).mExecuted) {
                    this.notifyRangeRefreshed(true, true, null);
                }
                this.setCurrentRow(viewRowImpl);
            }
            if (this.isDefaultRSI()) {
                if (this.mViewRowSet.isDefaultRS()) {
                    viewObjectImpl.activateState(viewRowImpl, element);
                } else {
                    viewObjectImpl.activateState(this.mViewRowSet, viewRowImpl, element);
                }
            }
            if (!bl) {
                this.mIteratorState = iteratorStateHolder;
            }
        }
    }

    void restoreIteratorState(Object object) {
        this.mIteratorState = (IteratorStateHolder)object;
    }

    final IteratorStateHolder getIteratorState() {
        return this.mIteratorState;
    }

    private static Row[] findMatchingRows(Row[] rowArray, RowQualifier rowQualifier) {
        ArrayList arrayList = null;
        if (rowArray != null) {
            int n = 0;
            while (n < rowArray.length) {
                if (rowQualifier.rowQualifies((ViewRowImpl)rowArray[n])) {
                    if (arrayList == null) {
                        arrayList = new ArrayList(4);
                    }
                    arrayList.add((Object)rowArray[n]);
                }
                ++n;
            }
        }
        return arrayList != null ? (Row[])arrayList.toArray((Object[])new Row[arrayList.size()]) : new Row[]{};
    }

    public Row[] getFilteredRows(RowQualifier rowQualifier) {
        RowSetIterator rowSetIterator = this.getRowSet().getViewObject().createRowSetIterator(null);
        try {
            rowSetIterator.setRangeSize(-1);
            Row[] rowArray = rowSetIterator.getAllRowsInRange();
            Row[] rowArray2 = ViewRowSetIteratorImpl.findMatchingRows(rowArray, rowQualifier);
            Object var6_5 = null;
            if (rowSetIterator != null) {
                rowSetIterator.closeRowSetIterator();
            }
            return rowArray2;
        }
        catch (Throwable throwable) {
            block3: {
                Object var6_6 = null;
                if (rowSetIterator == null) break block3;
                rowSetIterator.closeRowSetIterator();
            }
            throw throwable;
        }
    }

    public Row[] getFilteredRowsInRange(RowQualifier rowQualifier) {
        Row[] rowArray = this.getAllRowsInRange();
        return ViewRowSetIteratorImpl.findMatchingRows(rowArray, rowQualifier);
    }

    public Row[] getFilteredRows(String string, Object object) {
        return ViewRowSetIteratorImpl.getFilteredRows(this, string, object);
    }

    public Row[] getFilteredRowsInRange(String string, Object object) {
        return ViewRowSetIteratorImpl.getFilteredRowsInRange(this, string, object);
    }

    public VariableValueManager getVariableManager() {
        return this.mVariableManager;
    }

    public boolean hasVariables() {
        if (this.mVariableManager != null) {
            return true;
        }
        return ((ViewObjectImpl)this.getViewObject()).hasVariables();
    }

    public VariableValueManager ensureVariableManager() {
        if (this.mVariableManager == null) {
            VariableValueManager variableValueManager = this.getRowSetImpl().ensureVariableManager();
            this.mVariableManager = new VariableValueManagerImpl(this, new VariableValueManager[]{variableValueManager});
        }
        return this.mVariableManager;
    }

    public Class getMessageBundleClass() {
        return ((ViewObjectImpl)this.getViewObject()).getMessageBundleClass();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public final class 1
    implements Enumeration {
        int count;
        Row[] rows;

        private /* synthetic */ void $init$() {
            this.count = 0;
            this.rows = ViewRowSetIteratorImpl.this.getAllRowsInRange();
        }

        public boolean hasMoreElements() {
            return this.count < this.rows.length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object nextElement() {
            Object object = ViewRowSetIteratorImpl.this.getSyncLock();
            synchronized (object) {
                if (this.count < this.rows.length) {
                    Row row = this.rows[this.count++];
                    return row;
                }
                throw new NoSuchElementException("Row enumeration");
            }
        }

        public /* synthetic */ 1() {
            this.$init$();
        }
    }

    public class DetailQueryTS {
        ViewRowSetImpl mRS;
        int mQueryTS;

        DetailQueryTS(ViewRowSetImpl viewRowSetImpl) {
            this.mRS = viewRowSetImpl;
            this.mQueryTS = viewRowSetImpl.getQueryTS();
        }
    }
}

