/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.server;

import com.sun.java.util.collections.HashMap;
import java.lang.reflect.Method;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.JBOClass;
import oracle.jbo.common.PropertyMetadata;
import oracle.jbo.server.OracleSQLBuilderImpl;
import oracle.jbo.server.SQLBuilder;

public class SQLBuilderFactory {
    private static HashMap _sBuilders = new HashMap(4);

    public static SQLBuilder create() {
        String string = PropertyMetadata.PN_SQLBUILDERIMPL.getProperty();
        return SQLBuilderFactory.create(string);
    }

    public static SQLBuilder create(String string) {
        Object object = _sBuilders.get((Object)string);
        if (object != null) {
            return (SQLBuilder)object;
        }
        return SQLBuilderFactory.doCreate(string);
    }

    private static SQLBuilder doCreate(String string) {
        SQLBuilder sQLBuilder = null;
        sQLBuilder = string == null || string.equalsIgnoreCase("Oracle") ? OracleSQLBuilderImpl.getInterface() : (string.equalsIgnoreCase("OLite") ? SQLBuilderFactory.createDynamic("oracle.jbo.server.OLiteSQLBuilderImpl") : (string.equalsIgnoreCase("DB2") ? SQLBuilderFactory.createDynamic("oracle.jbo.server.DB2SQLBuilderImpl") : (string.equalsIgnoreCase("SQLServer") ? SQLBuilderFactory.createDynamic("oracle.jbo.server.SQLServerSQLBuilderImpl") : (string.equalsIgnoreCase("SQL92") ? SQLBuilderFactory.createDynamic("oracle.jbo.server.SQL92SQLBuilderImpl") : SQLBuilderFactory.createDynamic(string)))));
        _sBuilders.put((Object)string, (Object)sQLBuilder);
        return sQLBuilder;
    }

    private static SQLBuilder createDynamic(String string) {
        block4: {
            try {
                Class clazz = JBOClass.forName(string);
                Method method = clazz.getMethod("getInterface", new Class[0]);
                Object object = method.invoke(null, new Object[0]);
                if (object instanceof SQLBuilder) {
                    SQLBuilder sQLBuilder = (SQLBuilder)object;
                    return sQLBuilder;
                }
            }
            catch (Exception exception) {
                if (!Diagnostic.isOn()) break block4;
                Diagnostic.println("Exception during loading SQLBuilder:" + string);
                Diagnostic.printStackTrace(exception);
            }
        }
        if (Diagnostic.isOn()) {
            Diagnostic.println("Unable to load implementation " + string);
        }
        throw new RuntimeException();
    }
}

