/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.server;

import com.sun.java.util.collections.ArrayList;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.jbo.JboException;
import oracle.jbo.JboSerializationException;
import oracle.jbo.common.JboXMLUtil;
import oracle.jbo.server.ApplicationModuleImpl;
import oracle.jbo.server.Serializer;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;

class MemSerializer
extends Serializer {
    static ArrayList mStaticStore = new ArrayList();
    static final byte[] PLACE_HOLDER = new byte[0];
    static final byte READ = 0;
    static final byte READ_AND_REMOVE = 1;
    static final byte REMOVE = 2;

    MemSerializer(ApplicationModuleImpl applicationModuleImpl) {
        super(applicationModuleImpl);
    }

    int storeToByteStream(XMLDocument xMLDocument, Integer n) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            xMLDocument.print((OutputStream)byteArrayOutputStream);
            byteArrayOutputStream.close();
            int n2 = -1;
            if (n != null) {
                n2 = n;
                if (n2 > mStaticStore.size()) {
                    throw new JboSerializationException(true, -1, "Memory", null);
                }
                mStaticStore.set(n2, (Object)byteArrayOutputStream.toByteArray());
            } else {
                mStaticStore.add((Object)byteArrayOutputStream.toByteArray());
                n2 = mStaticStore.size() - 1;
            }
            int n3 = n2;
            return n3;
        }
        catch (IOException iOException) {
            throw new JboSerializationException(true, -1, "Memory", iOException);
        }
    }

    void doRemoveState(int n) {
        if (n + 1 != mStaticStore.size()) {
            mStaticStore.set(n, (Object)PLACE_HOLDER);
        } else {
            mStaticStore.remove(n);
            --n;
            while (n >= 0) {
                if (!mStaticStore.get(n).equals(PLACE_HOLDER)) break;
                mStaticStore.remove(n);
                --n;
            }
        }
    }

    XMLDocument processByteStream(int n, byte by) {
        try {
            if (by == 0 || by == 1) {
                DOMParser dOMParser = JboXMLUtil.createDOMParser(false);
                Object object = mStaticStore.get(n);
                if (object instanceof byte[]) {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);
                    dOMParser.parse((InputStream)byteArrayInputStream);
                    byteArrayInputStream.close();
                    if (by == 1) {
                        this.doRemoveState(n);
                    }
                    XMLDocument xMLDocument = dOMParser.getDocument();
                    return xMLDocument;
                }
                throw new JboSerializationException(false, n, "Memory", null);
            }
            this.doRemoveState(n);
            XMLDocument xMLDocument = null;
            return xMLDocument;
        }
        catch (JboException jboException) {
            throw jboException;
        }
        catch (Exception exception) {
            throw new JboSerializationException(false, n, "Memory", exception);
        }
    }

    int snapCommittedEOs() {
        XMLDocument xMLDocument = new XMLDocument();
        this.passivateCommitList(xMLDocument);
        return this.storeToByteStream(xMLDocument, null);
    }

    void replayCommittedEOs(int n) {
        this.activateCommitList(this.processByteStream(n, (byte)0));
    }

    void removeCommittedEOs(int n) {
        this.processByteStream(n, (byte)2);
    }

    int reservePassivationId() {
        mStaticStore.add((Object)new byte[0]);
        return mStaticStore.size() - 1;
    }

    int passivateRootAM(byte[] byArray) {
        return this.passivateRootAM(byArray, 1);
    }

    int passivateRootAM(byte[] byArray, int n) {
        XMLDocument xMLDocument = new XMLDocument();
        this.passivate(xMLDocument, byArray, n);
        return this.storeToByteStream(xMLDocument, null);
    }

    int passivateRootAM(int n, byte[] byArray) {
        return this.passivateRootAM(n, byArray, 1);
    }

    int passivateRootAM(int n, byte[] byArray, int n2) {
        XMLDocument xMLDocument = new XMLDocument();
        this.passivate(xMLDocument, byArray, n2);
        return this.storeToByteStream(xMLDocument, new Integer(n));
    }

    byte[] activateRootAM(int n, boolean bl) {
        return this.activateRootAM(n, bl, 1);
    }

    byte[] activateRootAM(int n, boolean bl, int n2) {
        return this.activate(this.processByteStream(n, bl ? (byte)1 : 0), n2);
    }

    void removeRootAM(int n) {
        this.processByteStream(n, (byte)2);
    }
}

