/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.server;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.util.BitSet;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import oracle.jbo.AttributeDef;
import oracle.jbo.DeadEntityAccessException;
import oracle.jbo.Key;
import oracle.jbo.NoDefException;
import oracle.jbo.StructureDef;
import oracle.jbo.TooManyObjectsException;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.WeakHashtable;
import oracle.jbo.common.WeakVector;
import oracle.jbo.server.AttributeDefImpl;
import oracle.jbo.server.DBTransaction;
import oracle.jbo.server.DBTransactionImpl;
import oracle.jbo.server.Entity;
import oracle.jbo.server.EntityDefImpl;
import oracle.jbo.server.EntityEvent;
import oracle.jbo.server.EntityImpl;
import oracle.jbo.server.EntityListener;
import oracle.jbo.server.RowFilter;
import oracle.jbo.server.TransactionEvent;

public class EntityCache
implements StructureDef {
    private WeakHashtable mRows;
    private HashMap mRowsByOldPK;
    private HashMap mRowsByDeletedPK;
    private HashMap mPinnedRows;
    private Object mListeners;
    private int mNumListeners;
    private PreparedStatement mStatement;
    private PreparedStatement mLockStatement;
    private DBTransactionImpl mTransaction;
    private EntityDefImpl mEntityDef;
    private ArrayList mModifiedRows;
    private EntityCache mBaseEntityCache;
    private ArrayList mDynAttrDefs;
    private int mAssociationAccessorRetained;
    int mUpdateCount;
    PreparedStatement mUpdateStatement;
    AttributeDefImpl[] mBatchUpdateAttrs;
    BitSet mBatchUpdateBits;
    int mInsertCount;
    PreparedStatement mInsertStatement;
    AttributeDefImpl[] mBatchInsertAttrs;
    BitSet mBatchInsertBits;
    int mDeleteCount;
    PreparedStatement mDeleteStatement;
    boolean mBatchMode;
    static final String CACHE_DOTS = "*-*-*-*";
    ArrayList mBatchedInsertList;
    ArrayList mBatchedUpdateList;
    ArrayList mBatchedDeleteList;
    private static /* synthetic */ Class class$java$lang$Object;

    private /* synthetic */ void $init$() {
        this.mNumListeners = 0;
        this.mModifiedRows = null;
        this.mBaseEntityCache = null;
        this.mDynAttrDefs = null;
        this.mAssociationAccessorRetained = -1;
        this.mUpdateCount = 0;
        this.mInsertCount = 0;
        this.mDeleteCount = 0;
        this.mBatchMode = false;
        this.mBatchedInsertList = null;
        this.mBatchedUpdateList = null;
        this.mBatchedDeleteList = null;
    }

    public EntityCache() {
        this.$init$();
    }

    public String getName() {
        return this.getEntityDef().getName();
    }

    public String getFullName() {
        return this.getEntityDef().getFullName();
    }

    public String getDefName() {
        return this.getEntityDef().getDefName();
    }

    public String getDefFullName() {
        return this.getEntityDef().getDefFullName();
    }

    protected void init(DBTransactionImpl dBTransactionImpl, EntityDefImpl entityDefImpl) {
        this.mRows = new WeakHashtable();
        this.mListeners = !dBTransactionImpl.isShared() ? new WeakVector(10) : new HashMap(4);
        this.mTransaction = dBTransactionImpl;
        this.mEntityDef = entityDefImpl;
        if (dBTransactionImpl.getBatchModeForEntity(entityDefImpl)) {
            this.mBatchMode = true;
        } else {
            boolean bl = this.mBatchMode = entityDefImpl.mBatchThreshold > 0;
            if (this.mBatchMode) {
                dBTransactionImpl.setBatchModeForEntity(entityDefImpl, this.mBatchMode);
            }
        }
        EntityDefImpl entityDefImpl2 = (EntityDefImpl)this.mEntityDef.getBaseDefObject();
        if (entityDefImpl2 != null) {
            this.mBaseEntityCache = this.mTransaction.findEntityCache(entityDefImpl2);
        }
        if (this.isAssociationAccessorRetained()) {
            this.processAssociationAccessors();
        }
    }

    public DBTransactionImpl getDBTransactionImpl() {
        return this.mTransaction;
    }

    public EntityDefImpl getEntityDef() {
        return this.mEntityDef;
    }

    public void pin(EntityImpl entityImpl) {
        if (this.mPinnedRows == null) {
            this.mPinnedRows = new HashMap(4);
        }
        this.mPinnedRows.put((Object)entityImpl, (Object)entityImpl);
    }

    public boolean unpin(EntityImpl entityImpl) {
        if (this.mPinnedRows != null) {
            return this.mPinnedRows.remove((Object)entityImpl) != null;
        }
        return false;
    }

    protected EntityImpl add(EntityImpl entityImpl) {
        Key key = entityImpl.getPrimaryKey();
        byte by = entityImpl.getPostState();
        if (key == null) {
            if (by == 0 || by == -1) {
                if (by == 0 && entityImpl.getContainer() instanceof DBTransaction) {
                    entityImpl.doRemoveFromTransactionManager();
                    entityImpl.addToTransactionManager();
                }
                this.addModifiedRow(entityImpl);
            } else if (Diagnostic.isOn()) {
                Diagnostic.println("EntityCache:add WARNING - ignoring row with no primary key");
            }
            return entityImpl;
        }
        EntityImpl entityImpl2 = (EntityImpl)this.mRows.get(key);
        if (entityImpl2 != null && !key.equals(entityImpl2.getPrimaryKey())) {
            entityImpl2 = null;
        }
        boolean bl = false;
        if (entityImpl2 == null && this.mRowsByOldPK != null && (entityImpl2 = (EntityImpl)this.mRowsByOldPK.get((Object)key)) != null) {
            bl = true;
        }
        if (entityImpl2 == null) {
            this.addInternal(entityImpl, key, by);
            return entityImpl;
        }
        if (bl) {
            if (entityImpl == entityImpl2) {
                this.mRows.put(key, entityImpl);
                entityImpl.setInRowList(true);
                this.removeRowByOldPK(entityImpl);
                return entityImpl;
            }
            if (by == 0 || by == -1) {
                if (Diagnostic.isOn()) {
                    Diagnostic.println("EntityCache:add WARNING - new row key matches a PK-modified row");
                }
                this.addInternal(entityImpl, key, by);
                return entityImpl;
            }
            if (entityImpl2.getPostState() == 2 || entityImpl2.getPostState() == 1) {
                entityImpl2.merge(entityImpl);
                return entityImpl2;
            }
            if (entityImpl.isPKChanged()) {
                if (Diagnostic.isOn()) {
                    Diagnostic.println("EntityCache:add WARNING - modified row key matches a PK-modified row");
                }
                this.mRows.put(key, entityImpl);
                entityImpl.setInRowList(true);
                return entityImpl;
            }
            if (Diagnostic.isOn()) {
                Diagnostic.println("EntityCache:add WARNING - unmodified row key matches a PK-modified row");
            }
            throw new DeadEntityAccessException(entityImpl.getEntityDef().getName(), key);
        }
        if (entityImpl == entityImpl2) {
            return entityImpl2;
        }
        boolean bl2 = this.getEntityDef().getSource() == null;
        switch (entityImpl2.getPostState()) {
            case 3: 
            case 4: {
                if (by == 0 || by == -1) {
                    if (Diagnostic.isOn()) {
                        Diagnostic.println("EntityCache:add WARNING - new row key matches a removed row");
                    }
                    this.addRowByDeletedPK(key, entityImpl2);
                    this.addInternal(entityImpl, key, by);
                    return entityImpl;
                }
                if (entityImpl.isPKChanged()) {
                    if (Diagnostic.isOn()) {
                        Diagnostic.println("EntityCache:add WARNING - modified row key matches a removed row");
                    }
                    this.mRows.put(key, entityImpl);
                    entityImpl.setInRowList(true);
                    return entityImpl;
                }
                if (Diagnostic.isOn()) {
                    Diagnostic.println("EntityCache:add ERROR - unmodified row key matches a removed row");
                }
                throw new DeadEntityAccessException(entityImpl.getEntityDef().getName(), key);
            }
            case 1: 
            case 2: {
                if (by != 1) {
                    if (bl2) {
                        throw new TooManyObjectsException(this.getEntityDef().getFullName(), key);
                    }
                    if (this.getEntityDef().findFromDatabase(this, this.mTransaction, entityImpl2.getOrigPrimaryKey()) == null) {
                        if (Diagnostic.isOn()) {
                            Diagnostic.println("Found a PK conflict, but the row is no longer in");
                            Diagnostic.println("DB table.  Everything OK");
                        }
                        this.mRows.put(key, entityImpl);
                        entityImpl.setInRowList(true);
                        return entityImpl;
                    }
                    if (Diagnostic.isOn()) {
                        Diagnostic.ASSERT(by != 3 && by != 4, "Deleted or dead entity being added to cache?");
                        Diagnostic.println("EntityCache:add ERROR - **new/modified row with same primary key as an existing row**");
                    }
                    throw new TooManyObjectsException(this.getEntityDef().getFullName(), key);
                }
                if (entityImpl2.isPKChanged()) {
                    if (Diagnostic.isOn()) {
                        Diagnostic.println("EntityCache:add ERROR - **PK-modifed row with matching row from db**");
                    }
                    throw new TooManyObjectsException(this.getEntityDef().getFullName(), key);
                }
                entityImpl2.merge(entityImpl);
                break;
            }
            default: {
                if (by == 1) {
                    EntityImpl entityImpl3;
                    EntityImpl entityImpl4;
                    if (this.mRowsByDeletedPK != null && (entityImpl4 = (EntityImpl)this.mRowsByDeletedPK.get((Object)key)) != null) {
                        if (Diagnostic.isOn()) {
                            Diagnostic.println("EntityCache:add WARNING - unmodified row key matches a new (removed) row");
                        }
                        throw new DeadEntityAccessException(entityImpl.getEntityDef().getName(), key);
                    }
                    if (this.mRowsByOldPK != null && (entityImpl3 = (EntityImpl)this.mRowsByOldPK.get((Object)key)) != null) {
                        if (Diagnostic.isOn()) {
                            Diagnostic.println("EntityCache:add WARNING - unmodified row key matches a new (PK-modified) row");
                        }
                        throw new DeadEntityAccessException(entityImpl.getEntityDef().getName(), key);
                    }
                }
                if (Diagnostic.isOn()) {
                    Diagnostic.println("EntityCache:add ERROR - **more than one new rows with same primary key**");
                }
                throw new TooManyObjectsException(this.getEntityDef().getFullName(), key);
            }
        }
        return entityImpl2;
    }

    private void addInternal(EntityImpl entityImpl, Key key, byte by) {
        if (by == 0 || by == -1) {
            if (by == 0 && entityImpl.getContainer() instanceof DBTransaction) {
                entityImpl.doRemoveFromTransactionManager();
                entityImpl.addToTransactionManager();
            }
            this.addModifiedRow(entityImpl);
        }
        this.mRows.put(key, entityImpl);
        entityImpl.setInRowList(true);
    }

    public EntityImpl get(Key key) {
        return (EntityImpl)this.mRows.get(key);
    }

    public boolean hasRows() {
        return this.mRows.size() > 0;
    }

    protected void addRowByDeletedPK(Key key, EntityImpl entityImpl) {
        if (this.mRowsByDeletedPK == null) {
            this.mRowsByDeletedPK = new HashMap(4);
        }
        this.mRowsByDeletedPK.put((Object)key, (Object)entityImpl);
    }

    protected EntityImpl removeRowByDeletedPK(EntityImpl entityImpl) {
        EntityImpl entityImpl2 = null;
        if (this.mRowsByDeletedPK != null) {
            entityImpl2 = (EntityImpl)this.mRowsByDeletedPK.remove((Object)entityImpl.getPrimaryKey());
            if (this.mRowsByDeletedPK.size() == 0) {
                this.mRowsByDeletedPK = null;
            }
        }
        return entityImpl2;
    }

    protected EntityImpl removeRowByOldPK(EntityImpl entityImpl) {
        EntityImpl entityImpl2 = null;
        if (this.mRowsByOldPK != null) {
            entityImpl2 = (EntityImpl)this.mRowsByOldPK.remove((Object)entityImpl.getOrigPrimaryKey());
            if (this.mRowsByOldPK.size() == 0) {
                this.mRowsByOldPK = null;
            }
        }
        return entityImpl2;
    }

    protected EntityImpl removeRow(EntityImpl entityImpl) {
        Key key = entityImpl.getPrimaryKey();
        if (key == null) {
            if (Diagnostic.isOn()) {
                Diagnostic.println("EntityCache:removeRow WARNING - ignoring row with no primary key");
            }
            return entityImpl;
        }
        if (this.mPinnedRows != null) {
            this.mPinnedRows.remove((Object)entityImpl);
        }
        if (this.mRows.get(key) == entityImpl) {
            EntityImpl entityImpl2;
            EntityImpl entityImpl3 = (EntityImpl)this.mRows.remove(key);
            entityImpl.setInRowList(false);
            if (this.mRowsByDeletedPK != null && (entityImpl2 = (EntityImpl)this.mRowsByDeletedPK.get((Object)key)) != null) {
                this.mRows.put(key, entityImpl2);
                entityImpl2.setInRowList(true);
                this.removeRowByDeletedPK(entityImpl2);
            }
            return entityImpl3;
        }
        return entityImpl;
    }

    protected void clearCache() {
        this.mRows = new WeakHashtable();
        this.mRowsByOldPK = null;
        this.mRowsByDeletedPK = null;
        this.mPinnedRows = null;
        this.mModifiedRows = null;
        this.resetBatchVariables();
    }

    protected Iterator iterator() {
        return new EntityCacheRowIterator(this.mRows);
    }

    public void addEntityListener(EntityListener entityListener) {
        WeakVector weakVector = this.getListeners();
        if (this.mTransaction.isShared() && weakVector == null) {
            weakVector = new WeakVector(10);
            ((HashMap)this.mListeners).put(this.mTransaction.getCurrentSessionContext(), (Object)weakVector);
        }
        if (!weakVector.contains(entityListener)) {
            weakVector.addElement(entityListener);
            ++this.mNumListeners;
        }
    }

    int getNumListeners() {
        return this.mNumListeners;
    }

    WeakVector getListeners() {
        WeakVector weakVector = !this.mTransaction.isShared() ? (WeakVector)this.mListeners : (WeakVector)((HashMap)this.mListeners).get(this.mTransaction.getCurrentSessionContext());
        return weakVector;
    }

    public void removeEntityListener(EntityListener entityListener) {
        WeakVector weakVector = this.getListeners();
        if (weakVector.removeElement(entityListener)) {
            --this.mNumListeners;
        }
        if (!this.mTransaction.isShared() && weakVector.size() == 0) {
            this.closeStatements();
        }
    }

    void sendEvent(WeakVector weakVector, EntityEvent entityEvent) {
        int n = 0;
        while (n < weakVector.size()) {
            ((EntityListener)weakVector.elementAt(n)).sourceChanged(entityEvent);
            ++n;
        }
    }

    void sendEventForSharedTrans(Object object, EntityEvent entityEvent) {
        this.sendEvent((WeakVector)((HashMap)this.mListeners).get(object), entityEvent);
    }

    protected void deliverEntityEvent(EntityEvent entityEvent) {
        if (!this.mTransaction.isShared()) {
            this.sendEvent((WeakVector)this.mListeners, entityEvent);
        } else {
            Iterator iterator = ((HashMap)this.mListeners).keySet().iterator();
            Object object = this.mTransaction.getCurrentSessionContext();
            while (iterator.hasNext()) {
                Object object2 = iterator.next();
                if (object2 == object) {
                    this.sendEventForSharedTrans(object2, entityEvent);
                    continue;
                }
                this.mTransaction.addPendingEvent(object2, entityEvent);
            }
        }
        if (this.mBaseEntityCache != null) {
            this.mBaseEntityCache.deliverEntityEvent(entityEvent);
        }
    }

    final void notifyColumnChange(EntityImpl entityImpl, int[] nArray, Object[] objectArray, boolean bl) {
        if (this.mNumListeners > 0 || this.mBaseEntityCache != null && this.mBaseEntityCache.getNumListeners() > 0) {
            EntityEvent entityEvent = new EntityEvent(entityImpl, 0, -1, nArray, objectArray);
            entityEvent.setMarkQCDirty(bl);
            this.deliverEntityEvent(entityEvent);
        }
    }

    final void notifyBeforePKChange(EntityImpl entityImpl, int[] nArray, Object[] objectArray, Key key) {
        if (this.mNumListeners > 0 || this.mBaseEntityCache != null && this.mBaseEntityCache.getNumListeners() > 0) {
            this.deliverEntityEvent(new EntityEvent(entityImpl, 3, -1, nArray, objectArray, key));
        }
    }

    final void notifyStateChange(EntityImpl entityImpl, int n) {
        if (this.mNumListeners > 0 || this.mBaseEntityCache != null && this.mBaseEntityCache.getNumListeners() > 0) {
            this.deliverEntityEvent(new EntityEvent(entityImpl, 1, n, null, null));
        }
    }

    final void notifyBeforeRemove(EntityImpl entityImpl, int n) {
        if (this.mNumListeners > 0 || this.mBaseEntityCache != null && this.mBaseEntityCache.getNumListeners() > 0) {
            this.deliverEntityEvent(new EntityEvent(entityImpl, 2, n, null, null));
        }
    }

    protected void replace(EntityImpl entityImpl, Key key) {
        EntityImpl entityImpl2 = null;
        if (key != null && (entityImpl2 = (EntityImpl)this.mRows.get(key)) != null && entityImpl == entityImpl2) {
            this.mRows.remove(key);
            entityImpl.setInRowList(false);
            entityImpl.doRemoveFromTransactionManager();
            entityImpl.addToTransactionManager();
        }
        this.add(entityImpl);
        if (key != null && entityImpl.getPostState() == 2 && entityImpl.isPKChanged() && (this.mRowsByOldPK == null || this.mRowsByOldPK.get((Object)entityImpl.getOrigPrimaryKey()) == null)) {
            if (this.mRowsByOldPK == null) {
                this.mRowsByOldPK = new HashMap(4);
            }
            this.mRowsByOldPK.put((Object)key, (Object)entityImpl);
        }
    }

    protected PreparedStatement getPreparedSelectStatement(boolean bl) {
        if (this.mEntityDef.isSingleUseKeyStatement()) {
            return null;
        }
        PreparedStatement preparedStatement = bl ? this.mLockStatement : this.mStatement;
        return preparedStatement != null && !this.mTransaction.isSingleUseStatement(preparedStatement) ? preparedStatement : null;
    }

    protected PreparedStatement createPreparedStatement(String string, boolean bl, int n) {
        PreparedStatement preparedStatement = this.getPreparedSelectStatement(bl);
        this.closeStatement(preparedStatement);
        preparedStatement = this.mTransaction.createReUsePreparedStatement(string, n);
        this.mTransaction.getSQLBuilder().doStatementSetBindingStyle(preparedStatement, this.mEntityDef.getBindingStyle());
        if (bl) {
            this.mLockStatement = preparedStatement;
        } else {
            this.mStatement = preparedStatement;
        }
        return preparedStatement;
    }

    PreparedStatement createRefreshPreparedStatement(String string) {
        PreparedStatement preparedStatement = this.mTransaction.createReUsePreparedStatement(string, 1);
        this.mTransaction.getSQLBuilder().doStatementSetBindingStyle(preparedStatement, this.mEntityDef.getBindingStyle());
        return preparedStatement;
    }

    protected boolean isBatchable(int n) {
        boolean bl = false;
        switch (n) {
            case 2: {
                if (this.mTransaction.getLockingMode() == 3 && this.getEntityDef().getChangeIndicatorColumn() == null) {
                    bl = false;
                    break;
                }
                bl = this.mUpdateStatement != null ? true : this.mBatchMode && this.mUpdateCount > this.mEntityDef.mBatchThreshold;
                break;
            }
            case 1: {
                bl = this.mInsertStatement != null ? true : this.mBatchMode && this.mInsertCount > this.mEntityDef.mBatchThreshold;
                break;
            }
            case 3: {
                bl = this.mTransaction.getLockingMode() == 3 ? false : (this.mDeleteStatement != null ? true : this.mBatchMode && this.mDeleteCount > this.mEntityDef.mBatchThreshold);
            }
        }
        return bl;
    }

    AttributeDefImpl[] getBatchAttributes(int n) {
        AttributeDefImpl[] attributeDefImplArray = this.mEntityDef.getPersistableAttributeDefImpls();
        int n2 = attributeDefImplArray.length;
        switch (n) {
            case 2: {
                if (this.mBatchUpdateAttrs == null) {
                    ArrayList arrayList = new ArrayList(n2);
                    int n3 = 0;
                    while (n3 < n2) {
                        if (this.mBatchUpdateBits.get(attributeDefImplArray[n3].mIndex)) {
                            arrayList.add((Object)attributeDefImplArray[n3]);
                        }
                        ++n3;
                    }
                    this.mBatchUpdateAttrs = (AttributeDefImpl[])arrayList.toArray((Object[])new AttributeDefImpl[arrayList.size()]);
                }
                return this.mBatchUpdateAttrs;
            }
            case 1: {
                if (this.mBatchInsertAttrs == null) {
                    ArrayList arrayList = new ArrayList(n2);
                    int n4 = 0;
                    while (n4 < n2) {
                        if (this.mBatchInsertBits.get(attributeDefImplArray[n4].mIndex)) {
                            arrayList.add((Object)attributeDefImplArray[n4]);
                        }
                        ++n4;
                    }
                    this.mBatchInsertAttrs = (AttributeDefImpl[])arrayList.toArray((Object[])new AttributeDefImpl[arrayList.size()]);
                }
                return this.mBatchInsertAttrs;
            }
        }
        return attributeDefImplArray;
    }

    PreparedStatement getBatchStatement(int n) {
        switch (n) {
            case 2: {
                return this.mUpdateStatement;
            }
            case 1: {
                return this.mInsertStatement;
            }
            case 3: {
                return this.mDeleteStatement;
            }
        }
        return null;
    }

    void cacheBatchStatement(PreparedStatement preparedStatement, int n) {
        switch (n) {
            case 2: {
                this.mUpdateStatement = preparedStatement;
                break;
            }
            case 1: {
                this.mInsertStatement = preparedStatement;
                break;
            }
            case 3: {
                this.mDeleteStatement = preparedStatement;
            }
        }
    }

    void freeStatement(PreparedStatement preparedStatement) {
        if (preparedStatement != null && this.mTransaction.isSingleUseStatement(preparedStatement)) {
            this.closeStatement(preparedStatement);
        }
    }

    protected void closeStatements() {
        this.closeStatement(this.mStatement);
        this.closeLockStatement();
        this.closeBatchStatements();
    }

    void closeFreeStatements() {
        if (this.mStatement != null) {
            this.closeStatement(this.mStatement);
        }
        this.closeLockStatement();
        this.closeFreeBatchStatements();
    }

    void closeLockStatement() {
        this.closeStatement(this.mLockStatement);
    }

    void closeBatchStatements() {
        if (this.mUpdateStatement != null) {
            this.closeStatement(this.mUpdateStatement);
            this.mUpdateStatement = null;
        }
        if (this.mInsertStatement != null) {
            this.closeStatement(this.mInsertStatement);
            this.mInsertStatement = null;
        }
        if (this.mDeleteStatement != null) {
            this.closeStatement(this.mDeleteStatement);
            this.mDeleteStatement = null;
        }
    }

    void closeFreeBatchStatements() {
        if (this.mUpdateStatement != null && this.mUpdateCount == 0) {
            this.closeStatement(this.mUpdateStatement);
            this.mUpdateStatement = null;
        }
        if (this.mInsertStatement != null && this.mInsertCount == 0) {
            this.closeStatement(this.mInsertStatement);
            this.mInsertStatement = null;
        }
        if (this.mDeleteStatement != null && this.mDeleteCount == 0) {
            this.closeStatement(this.mDeleteStatement);
            this.mDeleteStatement = null;
        }
    }

    void closeStatement(PreparedStatement preparedStatement) {
        if (preparedStatement == null) {
            return;
        }
        if (Diagnostic.isOn()) {
            Diagnostic.println("EntityCache close prepared statement");
        }
        try {
            this.mTransaction.closeStatement(preparedStatement, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (preparedStatement == this.mStatement) {
            this.mStatement = null;
        } else if (preparedStatement == this.mLockStatement) {
            this.mLockStatement = null;
        }
    }

    ArrayList findUnpostedRows(int[] nArray, RowFilter rowFilter, boolean bl) {
        ArrayList arrayList = new ArrayList();
        EntityImpl entityImpl = null;
        Object[] objectArray = null;
        int n = 0;
        while (this.mModifiedRows != null && n < this.mModifiedRows.size()) {
            boolean bl2;
            entityImpl = (EntityImpl)this.mModifiedRows.get(n);
            byte by = entityImpl.getPostState();
            boolean bl3 = bl2 = by == 2;
            if (!bl && by == 0 || bl2) {
                if (nArray == null) {
                    if (by == 0) {
                        arrayList.add((Object)entityImpl);
                    }
                } else {
                    objectArray = new Object[nArray.length];
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        objectArray[n2] = entityImpl.getAttributeInternal(nArray[n2]);
                        ++n2;
                    }
                    if (rowFilter.paramQualifies(objectArray)) {
                        if (bl2) {
                            Object[] objectArray2 = new Object[nArray.length];
                            n2 = 0;
                            while (n2 < nArray.length) {
                                objectArray2[n2] = entityImpl.getPostedAttribute(nArray[n2]);
                                ++n2;
                            }
                            if (!rowFilter.paramQualifies(objectArray2)) {
                                arrayList.add((Object)entityImpl);
                            }
                        } else {
                            arrayList.add((Object)entityImpl);
                        }
                    }
                }
            }
            ++n;
        }
        return arrayList;
    }

    void addModifiedRow(EntityImpl entityImpl) {
        if (entityImpl.isInModifiedList()) {
            return;
        }
        if (this.mModifiedRows == null) {
            this.mModifiedRows = new ArrayList();
        }
        this.mModifiedRows.add((Object)entityImpl);
        entityImpl.setInModifiedList(true);
    }

    void removeModifiedRow(EntityImpl entityImpl) {
        int n;
        if (!entityImpl.isInModifiedList()) {
            return;
        }
        if (this.mModifiedRows != null && (n = this.mModifiedRows.indexOf((Object)entityImpl)) >= 0) {
            this.mModifiedRows.remove(n);
        }
        entityImpl.setInModifiedList(false);
    }

    ArrayList getModifiedRows() {
        return this.mModifiedRows;
    }

    void dump(Writer writer) {
        Iterator iterator = this.iterator();
        EntityImpl entityImpl = null;
        PrintWriter printWriter = new PrintWriter(writer, true);
        printWriter.println("*-*-*-* Entity cache listing *-*-*-*");
        while (iterator.hasNext()) {
            entityImpl = (EntityImpl)iterator.next();
            entityImpl.dump(writer);
        }
        printWriter.println("*-*-*-* (" + this.mRows.size() + ") entries " + CACHE_DOTS);
    }

    void showCursorUsage(Writer writer) {
        PrintWriter printWriter = new PrintWriter(writer, true);
        printWriter.println("\tFault-in statement " + (this.mStatement == null ? "is NULL" : "OPEN"));
        printWriter.println("\tLock statement " + (this.mLockStatement == null ? "is NULL" : "OPEN"));
    }

    void addToBatchList(int n, Entity entity) {
        switch (n) {
            case 1: {
                if (this.mBatchedInsertList == null) {
                    this.mBatchedInsertList = new ArrayList();
                } else if (this.mBatchedInsertList.contains((Object)entity)) {
                    return;
                }
                this.mBatchedInsertList.add((Object)entity);
                break;
            }
            case 2: {
                if (this.mBatchedUpdateList == null) {
                    this.mBatchedUpdateList = new ArrayList();
                } else if (this.mBatchedUpdateList.contains((Object)entity)) {
                    return;
                }
                this.mBatchedUpdateList.add((Object)entity);
                break;
            }
            case 3: {
                if (this.mBatchedDeleteList == null) {
                    this.mBatchedDeleteList = new ArrayList();
                } else if (this.mBatchedDeleteList.contains((Object)entity)) {
                    return;
                }
                this.mBatchedDeleteList.add((Object)entity);
            }
        }
    }

    void resetBatchVariables() {
        this.mBatchUpdateBits = null;
        this.mBatchInsertBits = null;
        this.mBatchUpdateAttrs = null;
        this.mBatchInsertAttrs = null;
        this.mUpdateCount = 0;
        this.mInsertCount = 0;
        this.mDeleteCount = 0;
        this.closeBatchStatements();
        this.mBatchedInsertList = null;
        this.mBatchedUpdateList = null;
        this.mBatchedDeleteList = null;
    }

    /*
     * Exception decompiling
     */
    ArrayList doBatch(int var1, TransactionEvent var2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Missing node tying up JSR block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.tieUpRelations(Op02WithProcessedDataAndRefs.java:2900)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.copyBlock(Op02WithProcessedDataAndRefs.java:2889)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.inlineJSR(Op02WithProcessedDataAndRefs.java:2845)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSRs(Op02WithProcessedDataAndRefs.java:2591)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSR(Op02WithProcessedDataAndRefs.java:2481)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:444)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected Timestamp getCurrentDbTime() {
        if (this.mTransaction != null) {
            return this.mTransaction.getCurrentDbTime();
        }
        return new Timestamp(System.currentTimeMillis());
    }

    public boolean isAssociationAccessorRetained() {
        return this.mAssociationAccessorRetained == -1 ? this.getEntityDef().isAssociationAccessorRetained() : this.mAssociationAccessorRetained == 1;
    }

    public void setAssociationAccessorRetained(boolean bl) {
        int n = this.mAssociationAccessorRetained = bl ? 1 : 0;
        if (bl) {
            this.processAssociationAccessors();
        }
    }

    void processAssociationAccessors() {
        AttributeDef[] attributeDefArray = this.getEntityDef().getAttributeDefs();
        int n = 0;
        while (n < attributeDefArray.length) {
            String string;
            AttributeDef attributeDef;
            AttributeDef attributeDef2 = attributeDefArray[n];
            byte by = attributeDef2.getAttributeKind();
            if ((by == 2 || by == 6) && (attributeDef = this.lookupAttributeDef(string = EntityCache.assocAccResultAttrName(attributeDef2))) == null) {
                attributeDef = this.addDynamicAttribute(string);
            }
            ++n;
        }
    }

    static String assocAccResultAttrName(AttributeDef attributeDef) {
        return attributeDef.getName() + "__association_result__";
    }

    public AttributeDef[] getAttributeDefs() {
        AttributeDef[] attributeDefArray = this.getEntityDef().getAttributeDefs();
        if (this.mDynAttrDefs == null) {
            return attributeDefArray;
        }
        AttributeDef[] attributeDefArray2 = new AttributeDef[this.getAttributeCount()];
        int n = 0;
        while (n < attributeDefArray.length) {
            attributeDefArray2[n] = attributeDefArray[n];
            ++n;
        }
        int n2 = 0;
        while (n2 < this.mDynAttrDefs.size()) {
            attributeDefArray2[n2] = (AttributeDef)this.mDynAttrDefs.get(n2);
            ++n2;
        }
        return attributeDefArray2;
    }

    public int getAttributeCount() {
        int n = this.getEntityDef().getAttributeCount();
        if (this.mDynAttrDefs != null) {
            n += this.getDynamicAttributeCount();
        }
        return n;
    }

    public AttributeDef lookupAttributeDef(String string) {
        string = string.intern();
        AttributeDef attributeDef = this.getEntityDef().lookupAttributeDef(string);
        if (attributeDef == null && this.mDynAttrDefs != null) {
            int n = 0;
            while (n < this.mDynAttrDefs.size()) {
                attributeDef = (AttributeDef)this.mDynAttrDefs.get(n);
                if (attributeDef.getName() == string) {
                    return attributeDef;
                }
                ++n;
            }
        }
        return null;
    }

    public AttributeDef findAttributeDef(String string) {
        AttributeDef attributeDef = this.lookupAttributeDef(string);
        if (attributeDef != null) {
            return attributeDef;
        }
        throw new NoDefException(131, string, this.getEntityDef().getName());
    }

    public AttributeDef getAttributeDef(int n) {
        int n2 = this.getEntityDef().getAttributeCount();
        if (n < n2) {
            return this.getEntityDef().getAttributeDef(n);
        }
        if (this.mDynAttrDefs != null && (n -= n2) < this.mDynAttrDefs.size()) {
            return (AttributeDef)this.mDynAttrDefs.get(n);
        }
        return null;
    }

    public int getAttributeIndexOf(String string) {
        AttributeDef attributeDef = this.lookupAttributeDef(string);
        if (attributeDef == null) {
            return -1;
        }
        return attributeDef.getIndex();
    }

    int getDynamicAttributeCount() {
        return this.mDynAttrDefs == null ? 0 : this.mDynAttrDefs.size();
    }

    public AttributeDef addDynamicAttribute(String string) {
        if (this.mDynAttrDefs == null) {
            this.mDynAttrDefs = new ArrayList(4);
        }
        string = string.intern();
        int n = this.getAttributeCount();
        Class clazz = class$java$lang$Object;
        if (clazz == null) {
            clazz = class$java$lang$Object = EntityCache.class$("java.lang.Object");
        }
        AttributeDefImpl attributeDefImpl = new AttributeDefImpl(string, null, null, null, 2, false, false, false, false, false, 0, n, 12, 4, clazz, null);
        this.mDynAttrDefs.add((Object)attributeDefImpl);
        return attributeDefImpl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class EntityCacheRowIterator
    implements Iterator {
        private Enumeration mValues;

        EntityCacheRowIterator(Dictionary dictionary) {
            this.mValues = dictionary.elements();
        }

        public boolean hasNext() {
            return this.mValues.hasMoreElements();
        }

        public Object next() {
            return this.mValues.nextElement();
        }

        public void remove() {
            throw new NoSuchElementException();
        }
    }
}

