/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.server;

import com.sun.java.util.collections.ArrayList;
import oracle.jbo.common.JboNameUtil;
import oracle.jbo.server.AssociationDefImpl;
import oracle.jbo.server.AttributeDefImpl;
import oracle.jbo.server.ComponentObjectImpl;
import oracle.jbo.server.DefObject;
import oracle.jbo.server.EntityAssociation;
import oracle.jbo.server.EntityDefImpl;
import oracle.jbo.server.RowDef;
import oracle.jbo.server.StmtWithBindVars;
import oracle.jbo.server.ViewObjectImpl;

public class AssociationEnd
extends DefObject {
    private DefObject mOwner;
    private AssociationDefImpl mAccessor;
    private AttributeDefImpl[] mAttributes;
    private boolean mHasContainer;
    private boolean mDBCascadeDelete;
    private boolean mCascadeUpdate;
    private boolean mDeleteContainee;
    private boolean mLockTopContainer;
    private boolean mUpdateHistoryColumn;
    private boolean mSuppressEvent;
    private boolean mPrimaryKeys;
    private int mCardinality;
    private boolean mIsPartitionUsingWhereClause;
    protected String mDBObjectName;
    protected String mAliasName;
    protected ArrayList mColumns;
    protected AttributeDefImpl[] mColumnAttrs;
    protected boolean mIntersectInit;
    private String mSelect;
    private String mFrom;
    private StmtWithBindVars mWhere;

    private /* synthetic */ void $init$() {
        this.mIntersectInit = false;
        this.mSelect = null;
        this.mFrom = null;
        this.mWhere = null;
    }

    AssociationEnd(String string, DefObject defObject, DefObject defObject2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n, boolean bl6, boolean bl7, boolean bl8, AttributeDefImpl[] attributeDefImplArray, String string2, String string3, ArrayList arrayList) {
        this.$init$();
        this.setParent(defObject);
        this.mOwner = defObject2;
        this.mAttributes = attributeDefImplArray;
        if (string == null) {
            string = defObject2.getName();
        }
        this.setName(string);
        this.mHasContainer = bl;
        this.mDBCascadeDelete = bl2;
        this.mCascadeUpdate = bl4;
        this.mDeleteContainee = bl3;
        this.mLockTopContainer = bl5;
        this.mCardinality = n;
        this.mIsPartitionUsingWhereClause = bl6;
        this.mSuppressEvent = bl7;
        this.mUpdateHistoryColumn = bl8;
        if (this.mOwner instanceof EntityDefImpl) {
            this.mPrimaryKeys = EntityDefImpl.isPrimaryKeys((EntityDefImpl)this.mOwner, this.mAttributes);
        }
        this.mDBObjectName = string2;
        if (arrayList != null && arrayList.size() > 0) {
            this.mColumns = (ArrayList)arrayList.clone();
        }
        if (bl4) {
            int n2 = 0;
            while (n2 < attributeDefImplArray.length) {
                attributeDefImplArray[n2].setCascadeUpdateParticipant(true);
                ++n2;
            }
        }
    }

    protected synchronized void resolveIntersectColumns() {
        if (this.mIntersectInit) {
            return;
        }
        if (this.mDBObjectName != null) {
            EntityDefImpl entityDefImpl = EntityDefImpl.findDefObject(this.mDBObjectName);
            this.mDBObjectName = entityDefImpl.getSource();
            this.mAliasName = entityDefImpl.getAliasName();
            AttributeDefImpl[] attributeDefImplArray = ((EntityAssociation)this.getParent()).getEntityAttributeDefImpls(this.mColumns);
            this.mColumns = new ArrayList(attributeDefImplArray.length);
            int n = 0;
            while (n < attributeDefImplArray.length) {
                this.mColumns.add((Object)attributeDefImplArray[n].getColumnName());
                ++n;
            }
            this.mColumnAttrs = attributeDefImplArray;
        }
        this.mIntersectInit = true;
    }

    void setDefForComponent(ComponentObjectImpl componentObjectImpl) {
    }

    void unsetDefForComponent(ComponentObjectImpl componentObjectImpl) {
    }

    public AssociationDefImpl getAccessor() {
        return this.mAccessor;
    }

    synchronized void setAccessor(AssociationDefImpl associationDefImpl) {
        this.mAccessor = associationDefImpl;
    }

    public DefObject getOwner() {
        return this.mOwner;
    }

    public boolean isCascadeUpdate() {
        return this.mCascadeUpdate;
    }

    public boolean isCascadeDelete() {
        return this.mDBCascadeDelete;
    }

    public boolean isDeleteContainee() {
        return this.mDeleteContainee;
    }

    public boolean isLockTopContainer() {
        return this.mLockTopContainer;
    }

    public boolean isUpdateHistoryColumn() {
        return this.mUpdateHistoryColumn;
    }

    public boolean hasContainer() {
        return this.mHasContainer;
    }

    public int getCardinality() {
        return this.mCardinality;
    }

    public String getDBObjectName() {
        return this.mDBObjectName;
    }

    public String getAliasName() {
        return this.mAliasName;
    }

    public ArrayList getColumns() {
        if (!this.mIntersectInit) {
            this.resolveIntersectColumns();
        }
        return this.mColumns;
    }

    AttributeDefImpl[] getIntersectAttrs() {
        if (!this.mIntersectInit) {
            this.resolveIntersectColumns();
        }
        return this.mColumnAttrs;
    }

    boolean suppressEvent() {
        return this.mSuppressEvent;
    }

    public AttributeDefImpl[] getAttributeDefImpls() {
        return this.mAttributes;
    }

    synchronized void setAttributeDefImpls(AttributeDefImpl[] attributeDefImplArray) {
        this.mAttributes = attributeDefImplArray;
    }

    boolean isPrimaryKeys() {
        return this.mPrimaryKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getAssociationSelect() {
        if (this.mSelect != null) {
            return this.mSelect;
        }
        AssociationEnd associationEnd = this;
        synchronized (associationEnd) {
            if (this.mSelect != null) {
                String string = this.mSelect;
                return string;
            }
            if (!this.mIntersectInit) {
                this.resolveIntersectColumns();
            }
            StringBuffer stringBuffer = new StringBuffer();
            EntityDefImpl entityDefImpl = (EntityDefImpl)this.getOwner();
            AttributeDefImpl[] attributeDefImplArray = entityDefImpl.getAttributeDefImpls();
            String string = entityDefImpl.getAliasName();
            int n = 0;
            while (n < attributeDefImplArray.length) {
                if ((attributeDefImplArray[n].getAttributeKind() == 0 || attributeDefImplArray[n].getAttributeKind() == 1) && attributeDefImplArray[n].getAttrLoad() != 2) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(", ");
                    }
                    if (attributeDefImplArray[n].isObjectTableRef()) {
                        stringBuffer.append("REF(" + string + ")");
                    } else if (attributeDefImplArray[n].getAttrLoad() == 1) {
                        stringBuffer.append("VALUE(" + string + ")");
                    } else {
                        if (attributeDefImplArray[n].getAttributeKind() != 1) {
                            stringBuffer.append(string).append('.');
                        }
                        stringBuffer.append(attributeDefImplArray[n].getColumnName()).append(" AS \"").append(attributeDefImplArray[n].getName()).append("\"");
                    }
                }
                ++n;
            }
            String string2 = this.mSelect = stringBuffer.toString();
            return string2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StringBuffer appendIntersectFrom(StringBuffer stringBuffer) {
        AssociationEnd associationEnd = this;
        synchronized (associationEnd) {
            if (this.mDBObjectName != null) {
                if (!this.mIntersectInit) {
                    this.resolveIntersectColumns();
                }
                stringBuffer.append(", ").append(this.mDBObjectName).append(" ").append(this.mAliasName);
            }
            StringBuffer stringBuffer2 = stringBuffer;
            return stringBuffer2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getAssociationFrom() {
        if (this.mFrom != null) {
            return this.mFrom;
        }
        AssociationEnd associationEnd = this;
        synchronized (associationEnd) {
            if (this.mFrom != null) {
                String string = this.mFrom;
                return string;
            }
            StringBuffer stringBuffer = new StringBuffer();
            EntityDefImpl entityDefImpl = (EntityDefImpl)this.getOwner();
            stringBuffer.append(entityDefImpl.getSource()).append(" ").append(entityDefImpl.getAliasName());
            this.appendIntersectFrom(stringBuffer);
            String string = this.mFrom = stringBuffer.toString();
            return string;
        }
    }

    public boolean isPartitionUsingWhereClause() {
        return this.mIsPartitionUsingWhereClause;
    }

    public void setPartitionUsingWhereClause(boolean bl) {
        this.mIsPartitionUsingWhereClause = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StmtWithBindVars getAssociationWhere(ViewObjectImpl viewObjectImpl, AssociationEnd associationEnd, int n) {
        if (this.mWhere != null) {
            return this.mWhere;
        }
        AssociationEnd associationEnd2 = this;
        synchronized (associationEnd2) {
            if (this.mWhere != null) {
                StmtWithBindVars stmtWithBindVars = this.mWhere;
                return stmtWithBindVars;
            }
            StringBuffer stringBuffer = new StringBuffer();
            RowDef rowDef = (RowDef)this.getOwner();
            int n2 = viewObjectImpl != null ? viewObjectImpl.getBindingStyle() : rowDef.getBindingStyle();
            int n3 = 1;
            AttributeDefImpl[] attributeDefImplArray = associationEnd.getAttributeDefImpls();
            AttributeDefImpl[] attributeDefImplArray2 = this.getAttributeDefImpls();
            if (this.mDBObjectName != null) {
                if (!this.mIntersectInit) {
                    this.resolveIntersectColumns();
                }
                ArrayList arrayList = associationEnd.getColumns();
                int n4 = 0;
                while (n4 < arrayList.size()) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(" AND ");
                    }
                    String string = attributeDefImplArray[n4].isObjectTableRef() ? "REF(" + this.mAliasName + ")" : this.mAliasName + "." + (String)arrayList.get(n4);
                    if (n2 == 1) {
                        stringBuffer.append(string).append(" = :" + n3++);
                    } else if (n2 == 2) {
                        stringBuffer.append(string).append(" = :").append(JboNameUtil.getDefaultBindingName(attributeDefImplArray[n4].getName()));
                    } else {
                        stringBuffer.append(string).append(" = ?");
                    }
                    ++n4;
                }
            }
            int n5 = 0;
            while (n5 < attributeDefImplArray2.length) {
                String string;
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" AND ");
                }
                if ((string = attributeDefImplArray2[n5].getColumnNameForQuery()) != null) {
                    if (this.mDBObjectName != null) {
                        stringBuffer.append(string).append(" = ").append(this.mAliasName).append(".").append((String)this.mColumns.get(n5));
                    } else {
                        n = rowDef.appendBindingSpec(stringBuffer, n2, n, attributeDefImplArray2[n5], attributeDefImplArray[n5]);
                    }
                }
                ++n5;
            }
            StmtWithBindVars stmtWithBindVars = this.mWhere = new StmtWithBindVars(stringBuffer.toString(), n);
            return stmtWithBindVars;
        }
    }

    synchronized void setAssociationWhere(StmtWithBindVars stmtWithBindVars) {
        this.mWhere = stmtWithBindVars;
    }
}

