/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.pool;

import oracle.jbo.pool.AgeHistogram;

public class ResourcePoolStatistics
implements Cloneable {
    public long mNumOfInstanceCreations;
    public long mNumOfInstanceRemovals;
    public long mNumOfCheckouts;
    public long mNumOfCheckins;
    public long mNumOfCheckoutFailures;
    public int mResourceCount;
    public long mMaxNumOfInstances;
    public long mAvgNumOfInstances;
    public int mAvailableResourceCount;
    public long mAvgNumOfAvailableInstances;
    public long mAvgNumOfUnavailableInstances;
    public AgeHistogram mResourceAgeHistogram;

    private /* synthetic */ void $init$() {
        this.mNumOfInstanceCreations = 0L;
        this.mNumOfInstanceRemovals = 0L;
        this.mNumOfCheckouts = 0L;
        this.mNumOfCheckins = 0L;
        this.mNumOfCheckoutFailures = 0L;
        this.mResourceCount = 0;
        this.mMaxNumOfInstances = 0L;
        this.mAvgNumOfInstances = 0L;
        this.mAvailableResourceCount = 0;
        this.mAvgNumOfAvailableInstances = 0L;
        this.mAvgNumOfUnavailableInstances = 0L;
        this.mResourceAgeHistogram = null;
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        return object;
    }

    public void add(ResourcePoolStatistics resourcePoolStatistics) {
        this.mNumOfInstanceCreations += resourcePoolStatistics.mNumOfInstanceCreations;
        this.mNumOfInstanceRemovals = resourcePoolStatistics.mNumOfInstanceRemovals;
        this.mNumOfCheckouts += resourcePoolStatistics.mNumOfCheckouts;
        this.mNumOfCheckins += resourcePoolStatistics.mNumOfCheckins;
        this.mNumOfCheckoutFailures += resourcePoolStatistics.mNumOfCheckoutFailures;
        this.mResourceCount += resourcePoolStatistics.mResourceCount;
        this.mMaxNumOfInstances = Math.max(this.mMaxNumOfInstances, resourcePoolStatistics.mMaxNumOfInstances);
        this.mAvgNumOfInstances = (resourcePoolStatistics.mMaxNumOfInstances + this.mMaxNumOfInstances) / (long)2;
        this.mAvailableResourceCount += resourcePoolStatistics.mAvailableResourceCount;
        this.mAvgNumOfAvailableInstances = (resourcePoolStatistics.mAvgNumOfAvailableInstances + this.mAvgNumOfAvailableInstances) / (long)2;
        this.mAvgNumOfUnavailableInstances = (resourcePoolStatistics.mAvgNumOfUnavailableInstances + this.mAvgNumOfUnavailableInstances) / (long)2;
        if (this.mResourceAgeHistogram != null && resourcePoolStatistics.mResourceAgeHistogram != null) {
            this.mResourceAgeHistogram.add(resourcePoolStatistics.mResourceAgeHistogram);
        }
    }

    public ResourcePoolStatistics() {
        this.$init$();
    }
}

