/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.pcoll.pmgr;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import oracle.jbo.PCollException;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.pcoll.JDBCPersistManager;

public class DB2PersistManager
extends JDBCPersistManager {
    private static final int DB2_ERROR_TABLE_ALREADY_EXISTS = -601;
    private static final int DB2_ERROR_LOCK_CONFLICT = -1;
    private static final int DB2_CHUNK_LENGTH = 2048;
    private static /* synthetic */ Class class$oracle$jbo$CSMessageBundle;

    public int getMaxTabNameLength() {
        return 18 - "_SEQ".length();
    }

    protected String sqlCreateControlTable(String string) {
        return "create table " + string + "(tabname varchar(128) not null, rowcreatedate timestamp, createdate timestamp, updatedate timestamp, " + "constraint " + string + "_pk primary key (tabname))";
    }

    protected int sqlTableExistsErrorCode() {
        return -601;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dropTable(String string) {
        DB2PersistManager dB2PersistManager = this;
        synchronized (dB2PersistManager) {
            block19: {
                Statement statement;
                block18: {
                    block17: {
                        statement = null;
                        try {
                            statement = this.getConnection().createStatement();
                        }
                        catch (SQLException sQLException) {
                            Class clazz;
                            if (Diagnostic.isOn()) {
                                Diagnostic.println("**createStatement failed**");
                                Diagnostic.printStackTrace(sQLException);
                            }
                            if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                                clazz = class$oracle$jbo$CSMessageBundle = DB2PersistManager.class$("oracle.jbo.CSMessageBundle");
                            }
                            PCollException.throwException(clazz, "28006", new Object[]{string}, sQLException);
                        }
                        try {
                            String string2 = "drop table \"" + string + "\"";
                            statement.execute(string2);
                            if (Diagnostic.isOn()) {
                                Diagnostic.println("**dropTable** drop table, tabname=" + string);
                            }
                        }
                        catch (SQLException sQLException) {
                            if (!Diagnostic.isOn()) break block17;
                            Diagnostic.println("**dropTable** drop table failed, tabname=" + string);
                        }
                    }
                    String string3 = string + "_ky";
                    try {
                        String string4 = "drop table \"" + string3 + "\"";
                        statement.execute(string4);
                        if (Diagnostic.isOn()) {
                            Diagnostic.println("**dropTable** drop table, tabname=" + string3);
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!Diagnostic.isOn()) break block18;
                        Diagnostic.println("**dropTable** drop table failed, tabname=" + string3);
                    }
                }
                if (this.isPersistent()) {
                    try {
                        String string5 = "drop sequence " + string + "_SEQ restrict";
                        statement.execute(string5);
                        if (Diagnostic.isOn()) {
                            Diagnostic.println("**dropTable** dropped sequence");
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!Diagnostic.isOn()) break block19;
                        Diagnostic.println("**dropTable** drop sequence failed");
                    }
                }
            }
            this.commit();
        }
    }

    protected String sqlAddKeyContColumn(String string) {
        return null;
    }

    protected String sqlDropKeyInfoTable(String string) {
        return "drop table \"" + string + "\"";
    }

    protected String sqlCreateKeyInfoTable(String string) {
        return "create table \"" + string + "\"(collid decimal(10), keyid decimal(20), keyhash decimal(20), id decimal(20))";
    }

    protected String sqlCreateKeyInfoKeyIndex(String string, String string2) {
        return "create index \"" + string + "\" on \"" + string2 + "\" (collid, keyid, keyhash)";
    }

    protected String sqlCreateKeyInfoIdIndex(String string, String string2) {
        return "create index \"" + string + "\" on \"" + string2 + "\" (collid, id)";
    }

    protected String sqlCreateTable(String string) {
        return "create table \"" + string + "\"(id decimal(20) not null, parentid decimal(20), collid decimal(8) not null, " + "keycontlen decimal(20), contentlen decimal(20), contentidx decimal(8) not null, content varchar(" + 2048 + "), contentstatus decimal(1), " + (this.isPersistent() ? "creation_date timestamp DEFAULT current timestamp, " : "") + "constraint " + string + "_pk primary key (collid, id, contentidx))";
    }

    protected String sqlCreateIndex(String string) {
        return "create index \"" + string + "_ci\" on \"" + string + "\" (collid)";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected long sqlNextSequenceVal(String string) {
        Statement statement = null;
        ResultSet resultSet = null;
        long l = -1;
        try {
            try {
                statement = this.getConnection().createStatement();
                resultSet = statement.executeQuery("values nextval for " + string);
                if (!resultSet.next()) {
                    Class clazz = class$oracle$jbo$CSMessageBundle;
                    if (clazz == null) {
                        clazz = class$oracle$jbo$CSMessageBundle = DB2PersistManager.class$("oracle.jbo.CSMessageBundle");
                    }
                    PCollException.throwException(clazz, "28009", null, null);
                }
                l = resultSet.getLong(1);
            }
            catch (Exception exception) {
                Class clazz = class$oracle$jbo$CSMessageBundle;
                if (clazz == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = DB2PersistManager.class$("oracle.jbo.CSMessageBundle");
                }
                PCollException.throwException(clazz, "28010", new Object[]{string}, exception);
                Object var8_6 = null;
                DB2PersistManager.closeResultSet(resultSet);
                resultSet = null;
                DB2PersistManager.closeStmt(statement);
                return l;
            }
            Object var8_5 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            DB2PersistManager.closeResultSet(resultSet);
            resultSet = null;
            DB2PersistManager.closeStmt(statement);
            statement = null;
            throw throwable;
        }
        DB2PersistManager.closeResultSet(resultSet);
        resultSet = null;
        DB2PersistManager.closeStmt(statement);
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Date getCurrentTimeFromDb() {
        Statement statement = null;
        ResultSet resultSet = null;
        Date date = null;
        try {
            try {
                statement = this.getConnection().createStatement();
                resultSet = statement.executeQuery("values current timestamp");
                if (!resultSet.next()) {
                    Class clazz = class$oracle$jbo$CSMessageBundle;
                    if (clazz == null) {
                        clazz = class$oracle$jbo$CSMessageBundle = DB2PersistManager.class$("oracle.jbo.CSMessageBundle");
                    }
                    PCollException.throwException(clazz, "28009", null, null);
                }
                date = (Date)resultSet.getObject(1);
            }
            catch (Exception exception) {
                Class clazz = class$oracle$jbo$CSMessageBundle;
                if (clazz == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = DB2PersistManager.class$("oracle.jbo.CSMessageBundle");
                }
                PCollException.throwException(clazz, "28009", null, exception);
                Object var6_5 = null;
                DB2PersistManager.closeResultSet(resultSet);
                resultSet = null;
                DB2PersistManager.closeStmt(statement);
                return date;
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            DB2PersistManager.closeResultSet(resultSet);
            resultSet = null;
            DB2PersistManager.closeStmt(statement);
            statement = null;
            throw throwable;
        }
        DB2PersistManager.closeResultSet(resultSet);
        resultSet = null;
        DB2PersistManager.closeStmt(statement);
        return date;
    }

    protected String sqlDeleteControlRow(String string, String string2) {
        return "delete from " + string + " where tabname='" + string2 + "'";
    }

    protected String sqlUpdateControlRow(String string, String string2, String string3) {
        return "update " + string + " set " + string3 + "=current timestamp where tabname='" + string2 + "'";
    }

    protected String sqlLockControlRow(String string, String string2) {
        return "select tabname, updatedate from " + string + " where tabname='" + string2 + "' for update";
    }

    protected String sqlInsertControlRow(String string, String string2) {
        return "insert into " + string + " values ('" + string2 + "', current timestamp, current timestamp, current timestamp)";
    }

    protected int sqlLockConflictErrorCode() {
        return -1;
    }

    protected int contentChunkLength() {
        return 2048;
    }

    protected String sqlDeleteKeyInfo(String string, long l) {
        String string2 = "delete from \"" + string + "\" where collid=?";
        if (l != 0L) {
            string2 = string2 + " and id=?";
        }
        return string2;
    }

    protected void bindDeleteKeyInfo(PreparedStatement preparedStatement, long l, int n) throws SQLException {
        preparedStatement.setInt(1, n);
        if (l != 0L) {
            preparedStatement.setLong(2, l);
        }
    }

    protected String sqlInsertKeyInfo(String string) {
        return "insert into \"" + string + "\" values (?, ?, ?, ?)";
    }

    protected void bindInsertKeyInfo(PreparedStatement preparedStatement, long l, int n, int n2, int n3) throws SQLException {
        preparedStatement.setInt(1, n);
        preparedStatement.setInt(2, n2);
        preparedStatement.setInt(3, n3);
        preparedStatement.setLong(4, l);
    }

    protected String sqlInsertDataRow(String string, long l, long l2, int n) {
        String string2 = "insert into \"" + string + "\" (id, parentid, collid, keycontlen, contentlen, contentidx, content, contentstatus) values (?, ?, ?, ?, ?, ?, ?, ?)";
        return string2;
    }

    protected void bindInsertDataRow(PreparedStatement preparedStatement, long l, long l2, int n, int n2, int n3, int n4, byte[] byArray, int n5) throws SQLException {
        preparedStatement.setLong(1, l);
        preparedStatement.setLong(2, l2);
        preparedStatement.setInt(3, n);
        preparedStatement.setInt(4, n2);
        preparedStatement.setInt(5, n3);
        preparedStatement.setInt(6, n4);
        preparedStatement.setBytes(7, byArray);
        preparedStatement.setInt(8, n5);
    }

    protected String sqlDeleteOldChunksDataRow(String string, long l, int n, int n2, int n3) {
        return "delete from \"" + string + "\" where id=? and collid=? and contentidx >= ? and contentidx <= ?";
    }

    protected void bindDeleteOldChunksDataRow(PreparedStatement preparedStatement, long l, int n, int n2, int n3) throws SQLException {
        preparedStatement.setLong(1, l);
        preparedStatement.setInt(2, n);
        preparedStatement.setInt(3, n2);
        preparedStatement.setInt(4, n3);
    }

    protected String sqlUpdateDataRow(String string, long l, long l2, int n) {
        return "update \"" + string + "\" set parentid=?, keycontlen=?, contentlen=?, content=?, contentstatus=? where id=? and collid=? and contentidx=?";
    }

    protected void bindUpdateDataRow(PreparedStatement preparedStatement, long l, long l2, int n, int n2, int n3, int n4, byte[] byArray, int n5) throws SQLException {
        preparedStatement.setLong(1, l2);
        preparedStatement.setInt(2, n2);
        preparedStatement.setInt(3, n3);
        preparedStatement.setBytes(4, byArray);
        preparedStatement.setInt(5, n5);
        preparedStatement.setLong(6, l);
        preparedStatement.setInt(7, n);
        preparedStatement.setInt(8, n4);
    }

    protected String sqlChangeParentDataRow(String string, long l, long l2, int n) {
        return "update \"" + string + "\" set parentid=? where id=? and collid=?";
    }

    protected void bindChangeParentDataRow(PreparedStatement preparedStatement, long l, long l2, int n) throws SQLException {
        preparedStatement.setLong(1, l2);
        preparedStatement.setLong(2, l);
        preparedStatement.setInt(3, n);
    }

    protected String sqlDeleteDataRow(String string, long l, int n) {
        return "delete from \"" + string + "\" where id=? and collid=?";
    }

    protected void bindDeleteDataRow(PreparedStatement preparedStatement, long l, int n) throws SQLException {
        preparedStatement.setLong(1, l);
        preparedStatement.setInt(2, n);
    }

    protected String sqlDeleteAllDataRows(String string, int n) {
        return "delete from \"" + string + "\" where collid=?";
    }

    protected void bindDeleteAllDataRows(PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setInt(1, n);
    }

    protected String sqlRetrieveDataRow(String string, long l, int n, boolean bl, boolean bl2) {
        String string2 = " and contentstatus <= 2";
        String string3 = bl ? "select keycontlen, contentlen from \"" + string + "\" where id=? and collid=?" : "select parentid, keycontlen, contentlen, content from \"" + string + "\" where id=? and collid=?";
        if (bl2) {
            string3 = string3 + string2;
        }
        string3 = string3 + " order by collid, id, contentidx";
        return string3;
    }

    protected void bindRetrieveDataRow(PreparedStatement preparedStatement, long l, int n, boolean bl) throws SQLException {
        preparedStatement.setLong(1, l);
        preparedStatement.setInt(2, n);
    }

    protected byte[] getContentDataRow(ResultSet resultSet, long[] lArray, long[] lArray2, int[] nArray, boolean bl) throws SQLException {
        int n = 1;
        if (bl) {
            nArray[0] = resultSet.getInt(n++);
            nArray[1] = resultSet.getInt(n++);
            return null;
        }
        if (lArray != null) {
            lArray[0] = resultSet.getLong(n++);
        }
        if (lArray2 != null) {
            lArray2[0] = resultSet.getLong(n++);
        }
        nArray[0] = resultSet.getInt(n++);
        nArray[1] = resultSet.getInt(n++);
        return resultSet.getBytes(n++);
    }

    protected String sqlRetrieveIdsWithKey(String string, String string2, int n, Object object, int n2) {
        return "select k.id, t.parentid, t.keycontlen, t.contentlen, t.content from \"" + string2 + "\" k, \"" + string + "\" t where k.collid=? and k.keyid=? and k.keyhash=? and k.collid=t.collid and k.id=t.id and contentstatus <= 2 order by t.collid, t.id, t.contentidx";
    }

    protected void bindRetrieveIdsWithKey(PreparedStatement preparedStatement, int n, Object object, int n2, int n3) throws SQLException {
        preparedStatement.setInt(1, n3);
        preparedStatement.setInt(2, n);
        preparedStatement.setInt(3, n2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

