/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.expr;

import java.io.LineNumberReader;
import oracle.jbo.expr.JIException;
import oracle.jbo.expr.JIInput;
import oracle.jbo.expr.JIParserMethodNode;
import oracle.jbo.expr.JIParserNode;
import oracle.jbo.expr.JISyntaxError;
import oracle.jbo.expr.JIToken;
import oracle.jbo.expr.JIValueSupplier;

public abstract class JIExpr
extends JIInput {
    private boolean mShowParseTree;
    public static final int NULL_COMP_NOT_ALLOWED = 0;
    public static final int NULL_COMP_ALLOWED_FALSE = 1;
    public static final int NULL_COMP_ALLOWED_TRUE = 1;

    private /* synthetic */ void $init$() {
        this.mShowParseTree = false;
    }

    public JIExpr() {
        this.$init$();
    }

    public JIExpr(LineNumberReader lineNumberReader) {
        super(lineNumberReader);
        this.$init$();
    }

    public boolean isShowParseTree() {
        return this.mShowParseTree;
    }

    public void setShowParseTree(boolean bl) {
        this.mShowParseTree = bl;
    }

    public abstract Class findClass(String var1) throws ClassNotFoundException;

    public String getCastingClass() {
        int n = this.getPos();
        String string = "";
        JIToken jIToken = this.findNextWord(false, false);
        if (jIToken.equals("(")) {
            jIToken = this.findNextWord(false, false);
            while (jIToken.getTokType() == 1) {
                string = string + jIToken.getTokStr();
                jIToken = this.findNextWord(false, true);
                int n2 = this.getPos();
                if (jIToken.equals(")")) {
                    return string;
                }
                if (!jIToken.equals(".")) {
                    this.rewindWord();
                    break;
                }
                this.rewindWord();
                this.setPos(n2);
                string = string + jIToken.getTokStr();
                jIToken = this.findNextWord(false, false);
            }
        }
        this.setPos(n);
        return null;
    }

    public JIParserNode getTerm() {
        JIParserNode jIParserNode = null;
        JIToken jIToken = this.findNextWord(false);
        if (jIToken.getTokStr().equals("(")) {
            jIParserNode = this.getExpr();
            jIToken = this.findNextWord(false);
            if (!jIToken.equals(")")) {
                throw new JIException("Mismatching parentheses");
            }
        } else if (jIToken.equals("-")) {
            JIParserNode jIParserNode2 = this.getTerm();
            jIParserNode = new JIParserNode(this, 30, jIToken.getTokStr(), null);
            jIParserNode.setLeftChild(jIParserNode2);
        } else if (jIToken.getTokType() == 1) {
            JIToken jIToken2 = this.findNextWord(false);
            if (jIToken2.equals("(")) {
                jIParserNode = new JIParserMethodNode(this, jIToken.getTokStr());
                jIToken2 = this.findNextWord(false);
                if (!jIToken2.equals(")")) {
                    this.rewindWord();
                    do {
                        String string = this.getCastingClass();
                        JIParserNode jIParserNode3 = this.getExpr();
                        ((JIParserMethodNode)jIParserNode).addParmClass(string);
                        ((JIParserMethodNode)jIParserNode).addParm(jIParserNode3);
                    } while ((jIToken2 = this.findNextWord(false)).equals(","));
                    if (!jIToken2.equals(")")) {
                        throw new JIException("Invalid method call specification--expecting ',' or ')'");
                    }
                }
            } else if (jIToken2.equals("[")) {
                jIParserNode = new JIParserNode(this, 26, jIToken.getTokStr(), null);
                JIParserNode jIParserNode4 = this.getExpr();
                jIParserNode.setRightChild(jIParserNode4);
                jIToken2 = this.findNextWord(false);
                if (!jIToken2.equals("]")) {
                    throw new JIException("Invalid array index specification--expecting ']'");
                }
            } else {
                this.rewindWord();
                jIParserNode = new JIParserNode(this, 20, jIToken.getTokStr(), null);
            }
        } else if (jIToken.getTokType() == 5) {
            jIParserNode = new JIParserNode(this, 5, jIToken.getTokStr(), new Character(jIToken.getTokStr().charAt(0)));
        } else if (jIToken.getTokType() == 4) {
            jIParserNode = new JIParserNode(this, 4, jIToken.getTokStr(), new Boolean(jIToken.getTokStr()));
        } else if (jIToken.getTokType() == 2) {
            jIParserNode = new JIParserNode(this, 2, jIToken.getTokStr(), new Integer(jIToken.getTokStr()));
        } else if (jIToken.getTokType() == 3) {
            jIParserNode = new JIParserNode(this, 3, jIToken.getTokStr(), jIToken.getTokStr());
        } else if (jIToken.getTokType() == 20) {
            jIParserNode = new JIParserNode(this, 1, jIToken.getTokStr(), jIToken.getTokStr());
        } else {
            throw new JIException("Invalid identifier format, '" + jIToken.getTokStr() + "', typ=" + jIToken.getTokType());
        }
        return jIParserNode;
    }

    public JIParserNode getIdentTerm() {
        JIParserNode jIParserNode;
        JIParserNode jIParserNode2 = null;
        jIParserNode2 = jIParserNode = this.getTerm();
        JIToken jIToken = this.findNextWord(false);
        while (jIToken.getTokStr().equals(".")) {
            JIParserNode jIParserNode3 = this.getTerm();
            jIParserNode.setLeftChild(jIParserNode3);
            jIParserNode = jIParserNode3;
            jIToken = this.findNextWord(false);
        }
        this.rewindWord();
        return jIParserNode2;
    }

    public JIParserNode getMultiplyExpr() {
        JIParserNode jIParserNode = null;
        int n = 0;
        JIParserNode jIParserNode2 = this.getIdentTerm();
        JIToken jIToken = this.findNextWord(false);
        while (true) {
            if (jIToken.getTokStr().equals("*")) {
                n = 40;
            } else if (jIToken.getTokStr().equals("/")) {
                n = 41;
            } else if (jIToken.getTokStr().equals("%")) {
                n = 42;
            }
            if (n == 0) break;
            JIParserNode jIParserNode3 = this.getIdentTerm();
            jIParserNode = new JIParserNode(this, n, jIToken.getTokStr(), null);
            jIParserNode.setLeftChild(jIParserNode2);
            jIParserNode.setRightChild(jIParserNode3);
            jIParserNode2 = jIParserNode;
            n = 0;
            jIToken = this.findNextWord(false);
        }
        this.rewindWord();
        jIParserNode = jIParserNode2;
        return jIParserNode;
    }

    public JIParserNode getAddExpr() {
        JIParserNode jIParserNode = null;
        int n = 0;
        JIParserNode jIParserNode2 = this.getMultiplyExpr();
        JIToken jIToken = this.findNextWord(false);
        while (true) {
            if (jIToken.getTokStr().equals("+")) {
                n = 50;
            } else if (jIToken.getTokStr().equals("-")) {
                n = 51;
            }
            if (n == 0) break;
            JIParserNode jIParserNode3 = this.getMultiplyExpr();
            jIParserNode = new JIParserNode(this, n, jIToken.getTokStr(), null);
            jIParserNode.setLeftChild(jIParserNode2);
            jIParserNode.setRightChild(jIParserNode3);
            jIParserNode2 = jIParserNode;
            n = 0;
            jIToken = this.findNextWord(false);
        }
        this.rewindWord();
        jIParserNode = jIParserNode2;
        return jIParserNode;
    }

    public abstract int getComparisonOperators(JIToken var1);

    public JIParserNode getCompareExpr() {
        JIParserNode jIParserNode = null;
        int n = 0;
        JIParserNode jIParserNode2 = this.getAddExpr();
        JIToken jIToken = this.findNextWord(false);
        while ((n = this.getComparisonOperators(jIToken)) != 0) {
            JIParserNode jIParserNode3 = this.getAddExpr();
            jIParserNode = new JIParserNode(this, n, jIToken.getTokStr(), null);
            jIParserNode.setLeftChild(jIParserNode2);
            jIParserNode.setRightChild(jIParserNode3);
            jIParserNode2 = jIParserNode;
            n = 0;
            jIToken = this.findNextWord(false);
        }
        this.rewindWord();
        jIParserNode = jIParserNode2;
        return jIParserNode;
    }

    public abstract String getReservedWord(int var1);

    public abstract boolean checkForReservedWord(String var1, int var2);

    public JIParserNode getBooleanExpr() {
        JIParserNode jIParserNode = null;
        int n = 0;
        JIParserNode jIParserNode2 = this.getCompareExpr();
        JIToken jIToken = this.findNextWord(true);
        while (true) {
            if (this.checkForReservedWord(jIToken.getTokStr(), 60)) {
                n = 60;
            } else if (this.checkForReservedWord(jIToken.getTokStr(), 61)) {
                n = 61;
            }
            if (n == 0) break;
            JIParserNode jIParserNode3 = this.getBooleanExpr();
            jIParserNode = new JIParserNode(this, n, jIToken.getTokStr(), null);
            jIParserNode.setLeftChild(jIParserNode2);
            jIParserNode.setRightChild(jIParserNode3);
            jIParserNode2 = jIParserNode;
            n = 0;
            jIToken = this.findNextWord(false);
        }
        this.rewindWord();
        jIParserNode = jIParserNode2;
        return jIParserNode;
    }

    public JIParserNode getAssignExpr() {
        JIParserNode jIParserNode = null;
        int n = 0;
        JIParserNode jIParserNode2 = this.getBooleanExpr();
        JIToken jIToken = this.findNextWord(false);
        while (true) {
            if (jIToken.getTokStr().equals("=")) {
                JIToken jIToken2 = this.findNextWord(false);
                if (!jIToken2.equals("=")) {
                    n = 80;
                }
                this.rewindWord();
            }
            if (n == 0) break;
            JIParserNode jIParserNode3 = this.getBooleanExpr();
            jIParserNode = new JIParserNode(this, n, jIToken.getTokStr(), null);
            jIParserNode.setLeftChild(jIParserNode2);
            jIParserNode.setRightChild(jIParserNode3);
            jIParserNode2 = jIParserNode;
            n = 0;
            jIToken = this.findNextWord(false);
        }
        this.rewindWord();
        jIParserNode = jIParserNode2;
        return jIParserNode;
    }

    public JIParserNode getExpr() {
        JIParserNode jIParserNode = null;
        JIToken jIToken = this.findNextWord(false);
        this.rewindWord();
        jIParserNode = this.getAssignExpr();
        return jIParserNode;
    }

    public Object getExprVal(JIValueSupplier jIValueSupplier) {
        JIParserNode jIParserNode = this.getExpr();
        if (this.mShowParseTree) {
            jIValueSupplier.println(jIParserNode.toString());
        }
        return jIParserNode.evaluate(jIValueSupplier);
    }

    public boolean getBooleanExprVal(JIValueSupplier jIValueSupplier) {
        Object object = this.getExprVal(jIValueSupplier);
        boolean bl = JIParserNode.convertIntoBoolean(object);
        return bl;
    }

    public void noMoreTokenCheck() {
        JIToken jIToken = this.findNextWord(false);
        if (jIToken.getTokStr().length() > 0) {
            throw new JISyntaxError("Unrecognized token '" + jIToken.getTokStr() + "' found");
        }
    }

    public int getNullComparison() {
        return 0;
    }
}

