/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common.ampool;

import java.util.ArrayList;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import oracle.jbo.ApplicationModule;
import oracle.jbo.ApplicationModuleHome;
import oracle.jbo.ApplicationPoolSvcMsgContext;
import oracle.jbo.JboException;
import oracle.jbo.NotConnectedException;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.ampool.ConnectionStrategy;
import oracle.jbo.common.ampool.EnvInfoProvider;
import oracle.jbo.common.ampool.SessionCookie;

public class DefaultConnectionStrategy
implements ConnectionStrategy {
    public static final String LAST_EXCEPTION = "jbo.lastexception";
    private static /* synthetic */ Class class$oracle$jbo$CSMessageBundle;

    public ApplicationModule createApplicationModule(SessionCookie sessionCookie, EnvInfoProvider envInfoProvider) {
        ApplicationModule applicationModule = null;
        int n = 0;
        if (envInfoProvider != null) {
            n = envInfoProvider.getNumOfRetries();
        }
        RuntimeException runtimeException = null;
        while (n >= 0) {
            --n;
            Hashtable hashtable = sessionCookie.getEnvironment();
            Hashtable hashtable2 = sessionCookie.getClientEnvironment();
            hashtable.putAll(hashtable2);
            if (envInfoProvider != null) {
                if (runtimeException != null) {
                    hashtable.put(LAST_EXCEPTION, runtimeException);
                }
                envInfoProvider.modifyInitialContext(hashtable);
                envInfoProvider.getInfo(null, hashtable);
                hashtable.remove(LAST_EXCEPTION);
            }
            try {
                applicationModule = this.createApplicationModule(hashtable);
                break;
            }
            catch (RuntimeException runtimeException2) {
                if (n >= 0) {
                    runtimeException = runtimeException2;
                    continue;
                }
                throw runtimeException2;
            }
        }
        return applicationModule;
    }

    public ApplicationModule createApplicationModule(Hashtable hashtable) {
        ApplicationModule applicationModule = null;
        try {
            InitialContext initialContext = new InitialContext(hashtable);
            String string = (String)hashtable.get("ApplicationType");
            String string2 = null;
            if ("PACKAGE".equals(string)) {
                string2 = "$DefaultAppModule";
            } else {
                string2 = (String)hashtable.get("AppModuleJndiName");
                if (string2 == null) {
                    string2 = (String)hashtable.get("jbo.applicationmoduleclassname");
                }
            }
            ApplicationModuleHome applicationModuleHome = (ApplicationModuleHome)initialContext.lookup(string2);
            applicationModule = applicationModuleHome.create();
        }
        catch (NamingException namingException) {
            Class clazz;
            Throwable throwable;
            NamingException namingException2 = namingException;
            if (namingException instanceof NamingException && (throwable = namingException.getRootCause()) != null) {
                namingException2 = namingException;
            }
            if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                clazz = class$oracle$jbo$CSMessageBundle = DefaultConnectionStrategy.class$("oracle.jbo.CSMessageBundle");
            }
            JboException jboException = new JboException(clazz, "25222", new Object[0]);
            jboException.addToDetails(namingException2);
            throw jboException;
        }
        return applicationModule;
    }

    public void connect(ApplicationModule applicationModule, SessionCookie sessionCookie, EnvInfoProvider envInfoProvider) {
        ApplicationPoolSvcMsgContext applicationPoolSvcMsgContext = sessionCookie.getMessageContext();
        applicationPoolSvcMsgContext.setApplicationModuleConnected(true);
        if (!applicationModule.getTransaction().isConnected()) {
            applicationPoolSvcMsgContext.setApplicationModuleConnected(false);
            try {
                if (applicationPoolSvcMsgContext.getJDBCConnectionType() == 0) {
                    applicationModule.getTransaction().connectToDataSource(null, applicationPoolSvcMsgContext.getJDBCDataSourceName(), applicationPoolSvcMsgContext.getJDBCDataSourceUser(), applicationPoolSvcMsgContext.getJDBCDataSourcePassword(), false);
                } else if (applicationPoolSvcMsgContext.getJDBCConnectionType() == 1) {
                    applicationModule.getTransaction().connect(applicationPoolSvcMsgContext.getJDBCConnectString(), applicationPoolSvcMsgContext.getJDBCProperties());
                }
                applicationPoolSvcMsgContext.setApplicationModuleConnected(true);
            }
            catch (Throwable throwable) {
                applicationPoolSvcMsgContext.setApplicationModuleConnected(false);
                applicationPoolSvcMsgContext.setStatus(2);
                applicationPoolSvcMsgContext.setJDBCConnectException(throwable);
            }
        }
    }

    public void reconnect(ApplicationModule applicationModule, SessionCookie sessionCookie, EnvInfoProvider envInfoProvider) {
        ApplicationPoolSvcMsgContext applicationPoolSvcMsgContext = sessionCookie.getMessageContext();
        if (applicationPoolSvcMsgContext.isApplicationModuleConnected()) {
            return;
        }
        if (applicationModule.getTransaction().isConnected()) {
            applicationPoolSvcMsgContext.setApplicationModuleConnected(true);
            return;
        }
        try {
            if (applicationPoolSvcMsgContext.getJDBCConnectionType() != 2) {
                Diagnostic.println("DefaultConnectionStrategy is re-establishing an application module connection");
                try {
                    applicationModule.getTransaction().reconnect();
                    applicationPoolSvcMsgContext.setApplicationModuleConnected(true);
                }
                catch (NotConnectedException notConnectedException) {
                    this.connect(applicationModule, sessionCookie, envInfoProvider);
                }
            }
        }
        catch (JboException jboException) {
            if ("25224".equals(jboException.getErrorCode())) {
                boolean bl = false;
                int n = -1;
                if (applicationPoolSvcMsgContext.isRetainState()) {
                    Diagnostic.println("Passivating the application module state.");
                    n = applicationModule.passivateState(null, 0);
                    bl = true;
                }
                applicationModule.getTransaction().disconnect();
                applicationPoolSvcMsgContext.setApplicationModuleConnected(false);
                try {
                    applicationModule.getTransaction().reconnect();
                    applicationPoolSvcMsgContext.setApplicationModuleConnected(true);
                }
                catch (NotConnectedException notConnectedException) {
                    this.connect(applicationModule, sessionCookie, envInfoProvider);
                }
                if (bl) {
                    applicationModule.activateState(n, null, 2);
                    applicationPoolSvcMsgContext.addRtnEvent(6);
                }
            }
            throw jboException;
        }
    }

    public void disconnect(ApplicationModule applicationModule, boolean bl, SessionCookie sessionCookie) {
        block10: {
            ApplicationPoolSvcMsgContext applicationPoolSvcMsgContext = sessionCookie.getMessageContext();
            if (applicationPoolSvcMsgContext.getJDBCConnectionType() == 2) {
                if (!bl) {
                    applicationModule.resetState(3);
                }
                return;
            }
            try {
                if (bl) {
                    try {
                        applicationModule.getTransaction().disconnect(true);
                        break block10;
                    }
                    catch (JboException jboException) {
                        if (jboException.getErrorCode() != null && jboException.getErrorCode().equals("25224")) {
                            Diagnostic.println("Database state was detected while disconnecting the application module's connection");
                            this.doHandleDatabaseState(applicationModule, applicationPoolSvcMsgContext);
                            try {
                                applicationModule.getTransaction().disconnect(true);
                            }
                            catch (NotConnectedException notConnectedException) {}
                            break block10;
                        }
                        throw jboException;
                    }
                }
                applicationModule.getTransaction().disconnect();
            }
            catch (NotConnectedException notConnectedException) {
                // empty catch block
            }
        }
    }

    public void doHandleDatabaseState(ApplicationModule applicationModule, ApplicationPoolSvcMsgContext applicationPoolSvcMsgContext) {
        ArrayList arrayList = applicationPoolSvcMsgContext.getRtnEventList();
        int n = -1;
        if (arrayList != null) {
            int n2 = arrayList.size() - 1;
            while (n2 >= 0) {
                if ((Integer)arrayList.get(n2) == 2) {
                    n = n2;
                    break;
                }
                --n2;
            }
        }
        if (n < 0) {
            Diagnostic.println("Passivating the application module state.");
            int n3 = applicationModule.passivateState(null, 0);
            applicationPoolSvcMsgContext.setRtnPassivationId(n3);
            applicationPoolSvcMsgContext.addRtnEvent(3);
        } else {
            applicationPoolSvcMsgContext.replaceRtnEvent(n, 3);
        }
        applicationModule.resetState(21);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

