/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.navigator;

import java.util.AbstractCollection;
import java.util.ArrayList;
import oracle.help.common.View;
import oracle.help.navigator.Navigator;

public abstract class LazyNavigator
extends Navigator {
    private boolean _isInitialized = false;
    private ArrayList _initialViews;

    protected abstract void doInitializationNow();

    protected abstract void addViewNow(View var1);

    protected abstract void removeViewNow(View var1);

    public void initNavigator(View[] viewArray) {
        if (viewArray != null) {
            this._initialViews = new ArrayList(viewArray.length);
            int n = 0;
            while (n < viewArray.length) {
                this._initialViews.add(viewArray[n]);
                ++n;
            }
        } else {
            this._initialViews = new ArrayList(0);
        }
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl && !this.isInitialized()) {
            this.initializeLazyNavigator();
        }
    }

    public boolean isInitialized() {
        return this._isInitialized;
    }

    public void addView(View view) {
        if (this.isInitialized()) {
            this.addViewNow(view);
        } else {
            this._initialViews.add(view);
        }
    }

    public void removeView(View view) {
        if (this.isInitialized()) {
            this.removeViewNow(view);
        } else {
            ((AbstractCollection)this._initialViews).remove(view);
        }
    }

    public void initializeLazyNavigator() {
        this._isInitialized = true;
        this.doInitializationNow();
    }

    protected View[] getInitialViewsArray() {
        if (this._initialViews.size() > 0) {
            View[] viewArray = new View[this._initialViews.size()];
            this._initialViews.toArray(viewArray);
            return viewArray;
        }
        return null;
    }
}

