/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.common.navigator.searchNavigator;

import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import oracle.help.common.Topic;
import oracle.help.common.View;
import oracle.help.common.log.Logger;
import oracle.help.common.navigator.searchNavigator.SearchModelData;
import oracle.help.common.search.QueryHandler;
import oracle.help.common.search.QueryResult;
import oracle.help.common.search.SearchException;
import oracle.help.common.search.SearchExpression;
import oracle.help.common.util.java.StaticLocaleContext;

public class SearchModel {
    public static final int COLUMN_RANK = 0;
    public static final int COLUMN_TITLE = 1;
    public static final int COLUMN_SOURCE = 2;
    private static String GENERIC_RESOURCE_BUNDLE = "oracle.help.resource.Generic";
    private static String UNTITLED_DOCUMENT_STRING = "navigator.searchNavigator.untitledDocument";
    private static String _untitledDocName = null;
    private Vector _queryHandlerInfos;
    private Vector _queryViews;
    private SearchModelData _searchModelData;

    public SearchModel(SearchModelData searchModelData, View[] viewArray) {
        this._searchModelData = searchModelData;
        this._queryViews = new Vector();
        this._queryHandlerInfos = new Vector();
        int n = 0;
        if (viewArray != null) {
            n = 0;
            while (n < viewArray.length) {
                QueryHandler queryHandler;
                View view = viewArray[n];
                if (!this._queryViews.contains(view) && (queryHandler = this._getQueryHandler(view)) != null) {
                    this._queryViews.addElement(view);
                    this._queryHandlerInfos.addElement(new QueryHandlerInfo(queryHandler, view));
                }
                ++n;
            }
        }
    }

    public SearchModelData getSearchModelData() {
        return this._searchModelData;
    }

    public static Object getData(Object object, int n, int n2, SearchModelData searchModelData) {
        if (n == 2) {
            View view = (View)object;
            String string = view.getTitle();
            if (string == null) {
                string = new String("");
            }
            return string;
        }
        if (n == 1) {
            QueryResult queryResult = (QueryResult)object;
            String string = queryResult.getResultTopic().getLabel();
            if (string != null) {
                string.trim();
                if (string.length() == 0) {
                    string = SearchModel.getUntitledDocumentName();
                }
            } else {
                string = SearchModel.getUntitledDocumentName();
            }
            return string;
        }
        QueryResult queryResult = (QueryResult)object;
        return searchModelData.getRank(queryResult);
    }

    public synchronized void startSearch(SearchExpression searchExpression) {
        int n = 0;
        this.resetModel();
        n = 0;
        while (n < this._queryHandlerInfos.size()) {
            List list = Collections.EMPTY_LIST;
            View view = null;
            try {
                QueryHandlerInfo queryHandlerInfo = (QueryHandlerInfo)this._queryHandlerInfos.elementAt(n);
                QueryHandler queryHandler = queryHandlerInfo.handler;
                view = queryHandlerInfo.view;
                list = queryHandler.executeQuery(searchExpression, null);
            }
            catch (SearchException searchException) {
                Logger.getDefaultLogger().errorUnexpectedException(searchException);
                Logger.getDefaultLogger().errorUnexpectedException(searchException.getSourceException());
                list = Collections.EMPTY_LIST;
            }
            catch (Exception exception) {
                Logger.getDefaultLogger().errorUnexpectedException(exception);
                list = Collections.EMPTY_LIST;
            }
            this._addResults(list, view);
            ++n;
        }
        this._searchModelData.sort(0, false);
    }

    public synchronized void startSearch(String[] stringArray, boolean bl, boolean bl2) {
        int n = 0;
        this.resetModel();
        n = 0;
        while (n < this._queryHandlerInfos.size()) {
            List list = Collections.EMPTY_LIST;
            View view = null;
            try {
                QueryHandlerInfo queryHandlerInfo = (QueryHandlerInfo)this._queryHandlerInfos.elementAt(n);
                QueryHandler queryHandler = queryHandlerInfo.handler;
                view = queryHandlerInfo.view;
                list = queryHandler.executeQuery(stringArray, bl, bl2, null);
            }
            catch (SearchException searchException) {
                Logger.getDefaultLogger().errorUnexpectedException(searchException);
                Logger.getDefaultLogger().errorUnexpectedException(searchException.getSourceException());
                list = Collections.EMPTY_LIST;
            }
            catch (Exception exception) {
                Logger.getDefaultLogger().errorUnexpectedException(exception);
                list = Collections.EMPTY_LIST;
            }
            this._addResults(list, view);
            ++n;
        }
        this._searchModelData.sort(0, false);
    }

    public void stopSearch() {
        int n = 0;
        n = 0;
        while (n < this._queryHandlerInfos.size()) {
            QueryHandlerInfo queryHandlerInfo = (QueryHandlerInfo)this._queryHandlerInfos.elementAt(n);
            QueryHandler queryHandler = queryHandlerInfo.handler;
            queryHandler.stopSearch();
            ++n;
        }
    }

    public Topic getTopicForRow(int n) {
        Topic topic = null;
        QueryResult queryResult = (QueryResult)this._searchModelData.getRealData(1, n);
        if (queryResult != null) {
            topic = queryResult.getResultTopic();
        }
        return topic;
    }

    public static String getUntitledDocumentName() {
        if (_untitledDocName == null) {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(GENERIC_RESOURCE_BUNDLE, StaticLocaleContext.getLocale());
            _untitledDocName = resourceBundle.getString(UNTITLED_DOCUMENT_STRING);
        }
        return _untitledDocName;
    }

    public synchronized void resetModel() {
        this._searchModelData.resetModel();
    }

    private void _addResults(List list, View view) {
        this._searchModelData.addResults(list, view);
    }

    public synchronized void addView(View view) {
        QueryHandler queryHandler;
        if (!this._queryViews.contains(view) && (queryHandler = this._getQueryHandler(view)) != null) {
            this._queryViews.addElement(view);
            this._queryHandlerInfos.addElement(new QueryHandlerInfo(queryHandler, view));
        }
    }

    public synchronized void removeView(View view) {
        if (this._queryViews.contains(view)) {
            Object object;
            int n = 0;
            this._queryViews.removeElement(view);
            n = this._queryHandlerInfos.size() - 1;
            while (n >= 0) {
                object = (QueryHandlerInfo)this._queryHandlerInfos.elementAt(n);
                if (((QueryHandlerInfo)object).view == view) {
                    this._queryHandlerInfos.removeElementAt(n);
                }
                --n;
            }
            n = this._searchModelData.getRowCount() - 1;
            while (n >= 0) {
                object = (View)this._searchModelData.getRealData(2, n);
                if (view == object) {
                    this._searchModelData.removeRows(n, 1);
                }
                --n;
            }
        }
    }

    private QueryHandler _getQueryHandler(View view) {
        QueryHandler queryHandler = null;
        if (view != null) {
            try {
                queryHandler = (QueryHandler)view.getViewData();
            }
            catch (Exception exception) {
                System.err.println("View passed to SearchModel does not contain data in QueryHandler format.");
                exception.printStackTrace();
                queryHandler = null;
            }
        }
        return queryHandler;
    }

    private class QueryHandlerInfo {
        public View view = null;
        public QueryHandler handler = null;

        public QueryHandlerInfo(QueryHandler queryHandler, View view) {
            this.handler = queryHandler;
            this.view = view;
        }
    }
}

