/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.util;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import oracle.dms.spy.ConfigurationError;
import oracle.dms.util.DMSNLSupport;

public abstract class DMSProperties {
    public static final String LOGLEVEL_PROPERTY_KEY = "loglevel";
    public static final String LOGWRITER_PROPERTY_KEY = "logwriter";
    private static final String LOGLEVEL_SUFFIX = "LogLevel";
    private static final String LOGWRITER_SUFFIX = "LogWriter";
    private static final String DMS_PREFIX = "oracle.dms.";
    private static final int DMS_PREFIX_LEN = "oracle.dms.".length();
    public static final String DMS_CONFIG_FILE = "oracle.dms.property.file";
    private static Properties s_fileProperties = null;
    private static Properties s_paramProperties = new Properties();
    private static boolean s_inited = false;
    private static HashMap s_logLevelMap;
    private static HashMap s_nounPropertiesMap;
    private static HashMap s_sensorPropertiesMap;
    private static HashMap s_logWriterProperties;
    private static HashSet s_goodKeys;

    public static void init() throws ConfigurationError {
        DMSProperties.init(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void init(Properties properties) throws ConfigurationError {
        block14: {
            DMSProperties.append(properties);
            Object object = DMSProperties.class;
            synchronized (object) {
                if (s_inited) {
                    return;
                }
                s_inited = true;
            }
            object = null;
            try {
                object = DMSProperties.getSystemProperty(DMS_CONFIG_FILE);
            }
            catch (SecurityException securityException) {
                System.err.println("Calling  updateConfiguration(s_paramProperties)");
                DMSProperties.updateConfiguration(s_paramProperties);
                return;
            }
            if (object == null || ((String)object).length() == 0) {
                DMSProperties.updateConfiguration();
                return;
            }
            Properties properties2 = new Properties();
            BufferedInputStream bufferedInputStream = null;
            try {
                try {
                    bufferedInputStream = new BufferedInputStream(new FileInputStream((String)object));
                    properties2.load(bufferedInputStream);
                    s_fileProperties = properties2;
                }
                catch (IOException iOException) {
                    throw new ConfigurationError();
                }
                catch (SecurityException securityException) {
                    throw new ConfigurationError();
                }
                Object var6_5 = null;
                if (bufferedInputStream == null) break block14;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (bufferedInputStream == null) throw throwable;
                try {
                    ((InputStream)bufferedInputStream).close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            ((InputStream)bufferedInputStream).close();
        }
        DMSProperties.updateConfiguration();
    }

    public static String getProperty(String string, String string2) {
        if (string == null) {
            return string2;
        }
        String string3 = DMSProperties.getProperty(string);
        if (string3 != null) {
            return string3;
        }
        return string2;
    }

    public static void append(Properties properties) {
        if (properties == null) {
            return;
        }
        Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            DMSProperties.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public static void setProperty(String string, String string2) {
        if (string == null || string2 == null) {
            return;
        }
        s_paramProperties.put(string, string2);
        try {
            DMSProperties.updateConfiguration(string, string2);
        }
        catch (ConfigurationError configurationError) {
            // empty catch block
        }
    }

    public static void concatProperty(String string, String string2) {
        if (string == null || string2 == null) {
            return;
        }
        String string3 = DMSProperties.getProperty(string);
        if (string3 == null) {
            DMSProperties.setProperty(string, string2);
        } else {
            DMSProperties.setProperty(string, string3 + string2);
        }
    }

    public static String getProperty(String string) {
        if (string == null) {
            return null;
        }
        String string2 = null;
        if (s_paramProperties != null) {
            string2 = s_paramProperties.getProperty(string);
        }
        if (string2 != null) {
            return string2;
        }
        try {
            string2 = DMSProperties.getSystemProperty(string);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (string2 != null || s_fileProperties == null) {
            return string2;
        }
        return s_fileProperties.getProperty(string);
    }

    public static int getPropertyInt(String string, int n) {
        String string2 = DMSProperties.getProperty(string);
        if (string2 == null) {
            return n;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public static long getPropertyLong(String string, long l) {
        String string2 = DMSProperties.getProperty(string);
        if (string2 == null) {
            return l;
        }
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return l;
        }
    }

    public static double getPropertyDouble(String string, double d) {
        String string2 = DMSProperties.getProperty(string);
        if (string2 == null) {
            return d;
        }
        try {
            return Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return d;
        }
    }

    private DMSProperties() {
    }

    public static final boolean hasNounProperties() {
        return s_nounPropertiesMap != null && s_nounPropertiesMap.size() > 0;
    }

    public static final boolean hasSensorProperties() {
        return s_sensorPropertiesMap != null && s_sensorPropertiesMap.size() > 0;
    }

    public static final Map getNounProperties(String string) {
        if (DMSProperties.hasNounProperties()) {
            return (Map)s_nounPropertiesMap.get(string);
        }
        return null;
    }

    public static final Map getSensorProperties(String string) {
        if (DMSProperties.hasSensorProperties()) {
            return (Map)s_sensorPropertiesMap.get(string);
        }
        return null;
    }

    public static Map getLogWriterProperties() {
        return s_logWriterProperties;
    }

    private static void updateConfiguration(Properties properties) throws ConfigurationError {
        if (properties == null) {
            return;
        }
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(DMS_PREFIX)) continue;
            try {
                string = properties.getProperty(string2);
            }
            catch (Exception exception) {
                return;
            }
            DMSProperties.updateConfiguration(string2, string);
        }
    }

    private static final void updateConfiguration(String string, String string2) throws ConfigurationError {
        if (!string.startsWith(DMS_PREFIX)) {
            return;
        }
        int n = string.indexOf(46, DMS_PREFIX_LEN);
        if (n < 0) {
            return;
        }
        String string3 = string.substring(DMS_PREFIX_LEN, n);
        String string4 = null;
        if (n + 1 < string.length()) {
            string4 = string.substring(n + 1);
        }
        if (string3.equals(LOGWRITER_SUFFIX)) {
            DMSProperties.updateLogWriters(string4, string2);
        } else if (string3.equals("Noun")) {
            DMSProperties.updateNounProperties(string4, string2);
        } else if (string3.equals("Sensor")) {
            DMSProperties.updateSensorProperties(string4, string2);
        }
    }

    private static void updateConfiguration() throws ConfigurationError {
        Properties properties;
        DMSProperties.updateConfiguration(s_fileProperties);
        try {
            properties = DMSProperties.getSystemProperties();
        }
        catch (Exception exception) {
            properties = null;
        }
        DMSProperties.updateConfiguration(properties);
        DMSProperties.updateConfiguration(s_paramProperties);
    }

    private static void updateLogWriters(String string, String string2) throws ConfigurationError {
        Properties properties;
        System.err.println("updateLogWriters(" + string + "," + string2 + ")");
        int n = string.indexOf(46);
        if (n < 0) {
            throw new ConfigurationError(DMSNLSupport.getMessage("PROP_INVALID_PROPERTY", new Object[]{"oracle.dms.LogWriter" + string}));
        }
        String string3 = string.substring(0, n);
        if (string3.length() == 0) {
            throw new ConfigurationError(DMSNLSupport.getMessage("PROP_INVALID_PROPERTY", new Object[]{"oracle.dms.LogWriter" + string}));
        }
        String string4 = string.substring(n + 1);
        if (s_logWriterProperties == null) {
            s_logWriterProperties = new HashMap();
        }
        if ((properties = (Properties)s_logWriterProperties.get(string3)) == null) {
            properties = new Properties();
            s_logWriterProperties.put(string3, properties);
        }
        properties.setProperty(string4, string2);
        System.err.println("Setting property" + string4 + " to " + string2);
    }

    private static void updateNounProperties(String string, String string2) throws ConfigurationError {
        ArrayList arrayList;
        HashMap<String, Object> hashMap;
        String string3;
        String string4;
        int n = string.lastIndexOf(46);
        if (n + 1 == string.length()) {
            throw new ConfigurationError(DMSNLSupport.getMessage("PROP_INVALID_PROPERTY", new Object[]{"oracle.dms.Noun" + string}));
        }
        if (n < 0) {
            string4 = string;
            string3 = "/";
        } else {
            string4 = string.substring(n + 1);
            hashMap = string.substring(0, n);
            string3 = '/' + ((String)((Object)hashMap)).replace('.', '/');
        }
        if (s_nounPropertiesMap == null) {
            s_nounPropertiesMap = new HashMap();
        }
        if ((hashMap = (Map)s_nounPropertiesMap.get(string3)) == null) {
            hashMap = new HashMap<String, Object>();
            s_nounPropertiesMap.put(string3, hashMap);
        }
        if (string4.equals(LOGLEVEL_SUFFIX)) {
            hashMap.put(LOGLEVEL_PROPERTY_KEY, string2);
        } else if (string4.equals(LOGWRITER_SUFFIX) && (arrayList = DMSProperties.parseNameList(string2)) != null) {
            hashMap.put(LOGWRITER_PROPERTY_KEY, arrayList);
        }
    }

    private static void updateSensorProperties(String string, String string2) throws ConfigurationError {
        HashMap<String, String> hashMap;
        int n = string.lastIndexOf(46);
        if (n < 0 || n + 1 == string.length()) {
            throw new ConfigurationError(DMSNLSupport.getMessage("PROP_INVALID_PROPERTY", new Object[]{"oracle.dms.Sensor" + string}));
        }
        String string3 = string.substring(n + 1);
        String string4 = string.substring(0, n);
        String string5 = '/' + string4.replace('.', '/');
        if (s_sensorPropertiesMap == null) {
            s_sensorPropertiesMap = new HashMap();
        }
        if ((hashMap = (HashMap<String, String>)s_sensorPropertiesMap.get(string5)) == null) {
            hashMap = new HashMap<String, String>();
            s_sensorPropertiesMap.put(string5, hashMap);
        }
        if (string3.equals(LOGLEVEL_SUFFIX)) {
            hashMap.put(LOGLEVEL_PROPERTY_KEY, string2);
        }
    }

    private static ArrayList parseNameList(String string) {
        String string2;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        int n2 = string.indexOf(44, n);
        while (n2 >= 0) {
            string2 = string.substring(n, n2).trim();
            if (string2.length() > 0) {
                arrayList.add(string2);
            }
            n = n2 + 1;
            n2 = string.indexOf(44, n);
        }
        string2 = string.substring(n, string.length()).trim();
        if (string2.length() > 0) {
            arrayList.add(string2);
        }
        return arrayList;
    }

    static String getSystemProperty(final String string) {
        String string2 = null;
        if (string.startsWith(DMS_PREFIX) || s_goodKeys.contains(string)) {
            string2 = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty(string);
                }
            });
        }
        return string2;
    }

    private static Properties getSystemProperties() {
        Properties properties = null;
        properties = (Properties)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperties();
            }
        });
        return properties;
    }

    public static synchronized void exit() {
        s_nounPropertiesMap = null;
        s_sensorPropertiesMap = null;
        s_logWriterProperties = null;
        s_logLevelMap = null;
        s_fileProperties = null;
        s_paramProperties.clear();
        s_inited = false;
    }

    static {
        s_goodKeys = new HashSet();
        s_goodKeys.add("oracle.home");
        s_goodKeys.add("user.dir");
    }
}

