/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.Sensor;
import oracle.dms.instrument.Tracer;

public class TracerRecord {
    Sensor sensor = null;
    Noun noun = null;
    Sensor cousin = null;
    long tstamp = System.currentTimeMillis();
    String action = null;
    int actionID = -1;
    Object detail = null;
    Map m_attMap = null;
    Map m_stateValues;
    Map m_updatedStates;

    public TracerRecord(Sensor sensor, String string) {
        this.sensor = sensor;
        this.noun = sensor.getParent();
        this.action = string;
    }

    public TracerRecord(Sensor sensor, int n) {
        this.sensor = sensor;
        this.noun = sensor.getParent();
        this.actionID = n;
    }

    public TracerRecord(Sensor sensor, String string, String string2) {
        this.sensor = sensor;
        this.noun = sensor.getParent();
        this.action = string;
        this.detail = string2;
    }

    public TracerRecord(Sensor sensor, int n, String string) {
        this.sensor = sensor;
        this.noun = sensor.getParent();
        this.actionID = n;
        this.detail = string;
    }

    public TracerRecord(Noun noun, int n) {
        this.noun = noun;
        this.actionID = n;
    }

    public TracerRecord(int n) {
        this.actionID = n;
    }

    public void setTime(long l) {
        this.tstamp = l;
    }

    public long getTime() {
        return this.tstamp;
    }

    public Map getAttributeMap() {
        if (this.m_attMap == null) {
            this.m_attMap = new HashMap();
        }
        return this.m_attMap;
    }

    public void setAttributeMap(Map map) {
        this.m_attMap = map;
    }

    Map getStateValues() {
        if (this.m_stateValues == null) {
            this.m_stateValues = new HashMap();
        }
        return this.m_stateValues;
    }

    Map getUpdatedStates() {
        if (this.m_updatedStates == null) {
            this.m_updatedStates = new HashMap();
        }
        return this.m_updatedStates;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.toStringBuffer(stringBuffer);
        return stringBuffer.toString();
    }

    void toStringBuffer(StringBuffer stringBuffer) {
        if (this.actionID == 5) {
            stringBuffer.append("<REQUEST>");
            if (this.m_attMap != null) {
                Set set = this.m_attMap.keySet();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Object k = iterator.next();
                    stringBuffer.append("\n    <PROPERTY name=\"");
                    stringBuffer.append(k);
                    stringBuffer.append("\"> <![CDATA[");
                    stringBuffer.append(this.m_attMap.get(k));
                    stringBuffer.append("]]> </PROPERTY>");
                }
            }
            stringBuffer.append('\n');
        }
        stringBuffer.append("  <EVENT time=\"");
        stringBuffer.append(this.tstamp);
        if (this.actionID != 5 && this.actionID != 10) {
            if (this.sensor != null) {
                stringBuffer.append("\" type=\"");
                stringBuffer.append(this.noun.getType());
                stringBuffer.append("\" noun=\"");
                stringBuffer.append(this.noun.toString());
                stringBuffer.append("\" sensor=\"");
                stringBuffer.append(this.sensor.getName());
            } else if (this.noun != null) {
                stringBuffer.append("\" type=\"");
                stringBuffer.append(this.noun.getType());
                stringBuffer.append("\" noun=\"");
                stringBuffer.append(this.noun.toString());
            }
        }
        stringBuffer.append("\" action=\"");
        if (this.actionID >= 0) {
            stringBuffer.append(Tracer.ActionList[this.actionID]);
        } else {
            stringBuffer.append(this.action);
        }
        if (this.detail != null) {
            stringBuffer.append("\">\n    <![CDATA[");
            stringBuffer.append(this.detail);
            stringBuffer.append("]]></EVENT>\n");
        } else {
            stringBuffer.append("\"/>");
        }
        if (this.actionID == 6) {
            stringBuffer.append("\n</REQUEST>");
        }
    }

    public TracerRecord findMatchingStart(Stack stack) {
        int n;
        if (stack.empty()) {
            return null;
        }
        TracerRecord tracerRecord = (TracerRecord)stack.peek();
        if (this.sensor == tracerRecord.sensor && tracerRecord.actionID == 1) {
            return (TracerRecord)stack.pop();
        }
        Stack stack2 = stack;
        for (int i = n = stack2.size() - 2; i >= 0; --i) {
            TracerRecord tracerRecord2 = (TracerRecord)stack2.elementAt(i);
            if (tracerRecord2.sensor != this.sensor || tracerRecord2.actionID != 1) continue;
            stack2.removeElementAt(i);
            return tracerRecord2;
        }
        return null;
    }
}

