/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import oracle.core.ojdl.LogMessage;
import oracle.dms.instrument.Event;
import oracle.dms.instrument.ExecutionContext;
import oracle.dms.instrument.InstrumentationException;
import oracle.dms.instrument.Level;
import oracle.dms.instrument.Log;
import oracle.dms.instrument.LogLevel;
import oracle.dms.instrument.LogProperties;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.NounDescriptor;
import oracle.dms.instrument.NounIntf;
import oracle.dms.instrument.Refresh;
import oracle.dms.instrument.SensorDescriptor;
import oracle.dms.instrument.SensorIntf;
import oracle.dms.instrument.TransTrace;
import oracle.dms.spy.ErrorObject;
import oracle.dms.spy.Metric;
import oracle.dms.spy.StatisticsProducer;
import oracle.dms.util.DMSNLSupport;
import oracle.dms.util.DMSProperties;
import oracle.dms.util.DMSUtil;
import oracle.dms.util.PrependStringBuffer;

public abstract class Sensor
implements SensorIntf {
    protected static final byte VALUE_IDX = 0;
    protected static final byte TIME_IDX = 0;
    protected static final byte LOGGED_IDX = 0;
    protected static final byte COUNT_IDX = 1;
    protected static final byte COMPLETED_IDX = 1;
    protected static final byte MIN_IDX = 2;
    protected static final byte MAX_IDX = 3;
    protected static final byte SUM_IDX = 4;
    protected static final byte AVERAGE_IDX = 5;
    protected static final byte ACTIVE_IDX = 6;
    protected static final byte MAX_ACTIVE_IDX = 7;
    protected static final byte EXCLTIME_IDX = 8;
    protected static final byte LASTUPDATE_IDX = 9;
    protected static final byte NUMMETRICS = 10;
    protected static final String OPS_UNITS = "ops";
    protected static final String MSEC_UNITS = "msecs";
    protected static final String KBYTES_UNITS = "kbytes";
    protected static final String ELEMS_UNITS = "elems";
    protected static final String THREADS_UNITS = "threads";
    protected static final String TIMESTAMP_UNITS = "timestamp";
    protected static final String NULL_UNITS = "";
    private Level _msgLevel = Level.DEBUG;
    private Level _logLevel = Level.OFF;
    private boolean _hasLogLevel = true;
    private static Level _flushLevel = Level.TRACE;
    private String _componentId;
    private String _moduleId;
    private LogProperties _logProperties = null;
    private SensorDescriptor _descptor = null;
    protected volatile long _lastUpdate = 0L;
    private long _resetTime = 0L;
    boolean _alive;
    private Noun _noun;
    protected static final int NAME_LEN = 500;
    protected String _name;
    protected String _description;
    protected String _logMsg;
    private Object[] _inserts;
    Metric[] _metrics = new Metric[10];
    protected Refresh _refresh;
    private ArrayList _cachedRefs = null;
    private static Hashtable _sensorCache = new Hashtable();
    private static final String ILLEGAL_OPER = "ILLEGAL_OPER";
    private static final String NO_METRICS = "NO_METRICS";
    private static final String NOT_ALIVE = "NOT_ALIVE";
    private static final String FORMAT_ERROR = "SENSOR_FORMAT_ERROR";
    private static final String LOG_WRITE_ERROR = "SENSOR_LOGWRITE_ERROR";

    protected Sensor() {
        this._noun = null;
        this._alive = true;
        this._description = null;
        this._name = "temporary";
        this._hasLogLevel = false;
    }

    protected Sensor(Noun noun, String string, String string2) {
        this(true, noun, string, string2);
    }

    Sensor(boolean bl, Noun noun, String string, String string2) {
        Object object;
        if (noun == null || string == null || string.equals(NULL_UNITS) || string2 == null || noun.getChild(string) != null) {
            throw new InstrumentationException(DMSNLSupport.getMessage(ILLEGAL_OPER, new Object[]{this.getClass().getName(), noun, string, string2}));
        }
        this._noun = noun;
        this._alive = true;
        this._description = DMSUtil.sanitize(string2, 1023, false, false);
        this._name = bl ? DMSUtil.sanitize(string, 511, true, true) : string;
        this._logLevel = noun.getLogLevel();
        this._hasLogLevel = false;
        this._noun.sensorAdded(this);
        NounDescriptor nounDescriptor = noun.getDescriptor();
        if (nounDescriptor != null) {
            this._descptor = nounDescriptor.getSensorDescriptor(this._name);
            if (this._descptor == null) {
                object = this.getClass().getName();
                int n = ((String)object).lastIndexOf(46);
                if (n != -1) {
                    object = ((String)object).substring(n + 1);
                }
                this._descptor = new SensorDescriptor(this._name, this._description, (String)object);
                nounDescriptor.addSensorDescriptor(this._descptor);
            }
        }
        if ((object = StatisticsProducer._sensorCreate) != null) {
            ((Event)object).occurred(new Object[]{this});
        }
        this.initLogging();
    }

    protected static Noun createParent(String string) {
        if (string == null || string.length() == 0) {
            throw new InstrumentationException("invalid pathname");
        }
        String string2 = DMSUtil.getParentFromPath(string);
        if (string2.length() > 0) {
            return Noun.create(string2, NULL_UNITS);
        }
        return Noun.getRoot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Noun noun = this.getParent();
        if (noun == null) {
            return;
        }
        Noun noun2 = noun;
        synchronized (noun2) {
            Sensor sensor = this;
            synchronized (sensor) {
                if (!this._alive) {
                    return;
                }
                this._alive = false;
                this.cleanupCache();
                Event event = StatisticsProducer._sensorDestroy;
                if (event != null) {
                    event.occurred(new Object[]{this});
                }
                this._noun.sensorDestroyed(this);
                this.removeRefresh();
                for (int i = this._metrics.length - 1; i >= 0; --i) {
                    if (this._metrics[i] == null) continue;
                    this._metrics[i].destroy();
                }
            }
        }
    }

    public String getDescription() {
        return this._description;
    }

    public String getName() {
        return this._name;
    }

    public synchronized String toString() {
        PrependStringBuffer prependStringBuffer = new PrependStringBuffer(50, this._name);
        Noun noun = Noun.getRoot();
        for (Noun noun2 = this._noun; noun2 != noun; noun2 = noun2.getParent()) {
            prependStringBuffer.prepend('/');
            prependStringBuffer.prepend(noun2.getName());
        }
        prependStringBuffer.prepend('/');
        return prependStringBuffer.toString();
    }

    public Noun getParent() {
        return this._noun;
    }

    public NounIntf getParentNoun() {
        return this._noun;
    }

    public abstract Object getValue(Metric var1);

    private int derivToIndex(int n) {
        int n2 = -1;
        switch (n) {
            case 4: {
                n2 = 2;
                break;
            }
            case 8: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 1;
                break;
            }
            case 16: {
                n2 = 4;
                break;
            }
            case 32: {
                n2 = 5;
                break;
            }
            case 64: {
                n2 = 6;
                break;
            }
            case 128: {
                n2 = 7;
                break;
            }
            case 1: {
                n2 = 0;
            }
        }
        return n2;
    }

    public Object getValue(int n) {
        int n2 = this.derivToIndex(n);
        if (n2 == -1) {
            return null;
        }
        if (this._metrics[n2] == null) {
            return null;
        }
        return this.getValue(this._metrics[n2]);
    }

    public Object getValue() {
        for (int i = 0; i < 10; ++i) {
            if (this._metrics[i] == null) continue;
            return this.getValue(this._metrics[i]);
        }
        return new ErrorObject(DMSNLSupport.getString(NO_METRICS));
    }

    public Refresh getRefresh() {
        return this._refresh;
    }

    public void setRefresh(Refresh refresh) {
        this._refresh = refresh;
    }

    public void removeRefresh() {
        this._refresh = null;
    }

    public abstract void deriveMetric(int var1);

    public abstract void reset();

    public static Sensor get(String string) {
        int n;
        if (string == null || string.length() <= 1) {
            return null;
        }
        Sensor sensor = Sensor.lookupCache(string);
        if (sensor != null) {
            return sensor;
        }
        char c = string.charAt(0);
        String string2 = DMSUtil.getLeafFromPath(string);
        if (string2 == null) {
            return null;
        }
        String string3 = DMSUtil.sanitize(string2, 500, true, true);
        String string4 = DMSUtil.getParentFromPath(string);
        if (string4 == null) {
            return null;
        }
        String string5 = DMSUtil.sanitize(string4, 500, false, false);
        String string6 = string5 + c + string3;
        Noun noun = Noun.getRoot();
        int n2 = 1;
        do {
            String string7;
            if ((n = string6.indexOf(c, n2)) == n2) {
                return null;
            }
            if (n < 0) {
                string7 = string6.substring(n2);
                sensor = noun.getSensor(string7);
                if (sensor != null) {
                    sensor.addToCache(string);
                    if (!string.equals(string6)) {
                        sensor.addToCache(string6);
                    }
                }
                return sensor;
            }
            string7 = string6.substring(n2, n);
            if ((noun = noun.getChild(string7)) != null) continue;
            return null;
        } while ((n2 = n + 1) < string6.length());
        return null;
    }

    public long getResetTime() {
        return this._resetTime;
    }

    synchronized void setResetTime(long l) {
        if (this._resetTime < l) {
            this._resetTime = l;
        }
    }

    public boolean isInitialized() {
        return true;
    }

    public long getUpdateTime() {
        return this._lastUpdate;
    }

    void setUpdateTime() {
        long l = System.currentTimeMillis();
        this.setUpdateTime(l);
    }

    synchronized void setUpdateTime(long l) {
        if (this._lastUpdate < l) {
            this._lastUpdate = l;
        }
    }

    protected static final Sensor lookupCache(String string) {
        return (Sensor)_sensorCache.get(string);
    }

    protected synchronized void addToCache(String string) {
        if (!this._alive) {
            return;
        }
        Sensor sensor = _sensorCache.put(string, this);
        if (sensor != null) {
            return;
        }
        if (this._cachedRefs == null) {
            this._cachedRefs = new ArrayList();
        }
        this._cachedRefs.add(string);
    }

    private synchronized void cleanupCache() {
        if (this._cachedRefs == null) {
            return;
        }
        for (int i = 0; i < this._cachedRefs.size(); ++i) {
            String string = (String)this._cachedRefs.get(i);
            _sensorCache.remove(string);
        }
        this._cachedRefs = null;
    }

    public synchronized void getMetrics(Vector vector) {
        if (vector == null) {
            return;
        }
        for (int i = 0; i < 10; ++i) {
            if (this._metrics[i] == null) continue;
            vector.addElement(this._metrics[i]);
        }
    }

    public synchronized Metric getMetric(String string) {
        if (string == null) {
            return null;
        }
        for (int i = 0; i < 10; ++i) {
            if (this._metrics[i] == null || !this._metrics[i].getName().equals(string)) continue;
            return this._metrics[i];
        }
        return null;
    }

    public Metric getMetric(int n) {
        int n2 = this.derivToIndex(n);
        if (n2 == -1) {
            return null;
        }
        return this._metrics[n2];
    }

    public SensorDescriptor getDescriptor() {
        return this._descptor;
    }

    public synchronized void configureLogging(String string, Level level) {
        if (string != null) {
            this._logMsg = string;
        }
        this._msgLevel = level;
    }

    public void configureLogging(String string, LogLevel logLevel) {
        this.configureLogging(string, (Level)logLevel);
    }

    private String formatMessage(String string, Object[] objectArray) {
        try {
            DMSUtil.cleanFormatArgs(objectArray);
            return MessageFormat.format(string, objectArray);
        }
        catch (Exception exception) {
            return DMSNLSupport.getMessage(FORMAT_ERROR, new Object[]{this.getClass().getName(), string, this._description});
        }
    }

    public void setLogLevel(Level level) {
        if (level == null) {
            this._hasLogLevel = false;
            this._logLevel = this.getParent().getLogLevel();
        } else {
            this._hasLogLevel = true;
            this._logLevel = level;
        }
    }

    public void setLogLevel(LogLevel logLevel) {
        this.setLogLevel((Level)logLevel);
    }

    protected void notifyLogLevel(Level level) {
        if (!this._hasLogLevel) {
            this._logLevel = level;
        }
    }

    public static void setLogLevel(String string, Level level) {
        Sensor sensor = Sensor.get(string);
        if (sensor != null) {
            sensor.setLogLevel(level);
        }
    }

    public static void setLogLevel(String string, LogLevel logLevel) {
        Sensor.setLogLevel(string, (Level)logLevel);
    }

    public Level getLogLevel() {
        return this._logLevel;
    }

    public static Level getLogLevel(String string) {
        Sensor sensor = Sensor.get(string);
        if (sensor != null) {
            return sensor.getLogLevel();
        }
        return null;
    }

    public boolean isLoggable() {
        return this._msgLevel.isLessThanOrEqual(this._logLevel) && this._msgLevel != Level.OFF && Log.isLoggingEnabled();
    }

    public boolean isLoggable(Level level) {
        Level level2 = level != null ? level : this._msgLevel;
        return level2.isLessThanOrEqual(this._logLevel) && level2 != Level.OFF && Log.isLoggingEnabled();
    }

    public boolean isGonnaLog() {
        return this.isLoggable();
    }

    public boolean isGonnaLog(LogLevel logLevel) {
        return this.isLoggable((Level)logLevel);
    }

    protected void logActivation(String string) {
        String string2 = this._logMsg != null ? this._logMsg : string;
        this.logActivation(this._msgLevel, string2, null, null);
    }

    protected void logActivation(String string, Object[] objectArray) {
        String string2 = this._logMsg != null ? this._logMsg : string;
        string2 = this.formatMessage(string2, objectArray);
        this.logActivation(this._msgLevel, string2, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logActivation(Level level, String string, Throwable throwable, Properties properties) {
        String string2;
        Object object;
        Object object2 = this;
        synchronized (object2) {
            if (this._moduleId == null) {
                this.initComponentAndModule();
                object = this.getParent();
                if (this._logProperties == null) {
                    this._logProperties = new LogProperties();
                    this._logProperties.setLogProperty("OrganizationId", ((Noun)object).getLogProperty("OrganizationId"));
                    this._logProperties.setLogProperty("HostingClientId", ((Noun)object).getLogProperty("HostingClientId"));
                    this._logProperties.setLogProperty("UserId", ((Noun)object).getLogProperty("HostingClientId"));
                    this._logProperties.setLogProperty("MessageId", ((Noun)object).getLogProperty("MessageId"));
                }
            }
        }
        object2 = level != null ? level : this._msgLevel;
        object = string;
        String string3 = this._logProperties.getLogProperty("OrganizationId", properties);
        String string4 = this._logProperties.getLogProperty("MessageId", properties);
        String string5 = this._logProperties.getLogProperty("HostingClientId", properties);
        String string6 = this._logProperties.getLogProperty("UserId", properties);
        String string7 = this._logProperties.getLogProperty("SupplDet", properties);
        if (string7 == null && throwable != null) {
            string7 = Sensor.getStackTrace(throwable);
        }
        if (object == null) {
            object = this._logProperties.getLogProperty("MessageTxt", this._logMsg);
        }
        if ((string2 = this.getParent().getType()) == "n/a") {
            string2 = null;
        }
        ExecutionContext executionContext = ExecutionContext.get();
        LogMessage logMessage = new LogMessage(string3, this._componentId, string4, string5, ((Level)object2).getMessageType(), string2, ((Level)object2).getArbLevel(), this._moduleId, null, string6, null, null, executionContext.getECID(), null, (String)object, null, null, string7);
        this._noun.log(logMessage, ((Level)object2).getValue() < _flushLevel.getValue());
    }

    public void setLoggingProperties(Properties properties) {
        Object object;
        if (properties == null) {
            return;
        }
        String string = properties.getProperty("Level");
        if (string != null && (object = Level.getLevel(string)) != null) {
            this._msgLevel = object;
        }
        if ((object = properties.getProperty("MessageTxt")) != null) {
            this._logMsg = object;
        }
        if (this._logProperties == null) {
            this._logProperties = new LogProperties(properties);
        } else {
            this._logProperties.setLogProperties(properties);
        }
    }

    private void initLogging() {
        Noun noun = this.getParent();
        this._msgLevel = Level.getLevel(noun.getLogProperty("Level"));
        if (this._msgLevel == null) {
            this._msgLevel = Level.DEBUG;
        }
        this._hasLogLevel = false;
        this._logLevel = noun.getLogLevel();
        if (DMSProperties.hasSensorProperties()) {
            String string;
            Map map;
            String string2 = this.toString();
            int n = string2.indexOf(47);
            if (n > 0) {
                string2 = string2.substring(n);
            }
            if ((map = DMSProperties.getSensorProperties(string2)) != null && (string = (String)map.get("loglevel")) != null) {
                this.setLogLevel(Level.getLevel(string));
            }
        }
    }

    private void initComponentAndModule() {
        PrependStringBuffer prependStringBuffer = new PrependStringBuffer(50, this.getName());
        Noun noun = null;
        Noun noun2 = this.getParent();
        for (Noun noun3 = noun2.getParent(); noun3 != null; noun3 = noun3.getParent()) {
            if (noun != null) {
                prependStringBuffer.prepend('/');
                prependStringBuffer.prepend(noun.getName());
            }
            noun = noun2;
            noun2 = noun3;
        }
        if (noun != null) {
            this._componentId = noun.getName();
            this._moduleId = prependStringBuffer.toString();
        } else {
            this._componentId = this.getName();
            this._moduleId = null;
        }
    }

    private static String getStackTrace(Throwable throwable) {
        if (throwable != null) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            return stringWriter.toString();
        }
        return null;
    }

    final boolean isTraceable() {
        boolean bl = TransTrace._isEnabled() && this._noun != null && this._noun.isTraceable();
        return bl;
    }

    boolean isAlive() {
        return this._alive;
    }

    static synchronized void shutdown() {
        _sensorCache.clear();
        _flushLevel = Level.TRACE;
    }
}

